# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class TestSMTPCredentials(BaseModel):
    """
    Serializer for testing SMTP credentials
    """ # noqa: E501
    smtp_host: Annotated[str, Field(strict=True, max_length=255)] = Field(description="SMTP server hostname")
    smtp_port: Annotated[int, Field(le=65535, strict=True, ge=1)] = Field(description="SMTP server port")
    smtp_username: Annotated[str, Field(strict=True, max_length=255)] = Field(description="SMTP username")
    smtp_password: Annotated[str, Field(strict=True, max_length=255)] = Field(description="SMTP password")
    use_tls: Optional[StrictBool] = Field(default=True, description="Use TLS encryption")
    use_ssl: Optional[StrictBool] = Field(default=False, description="Use SSL encryption")
    test_email: StrictStr = Field(description="Email address to send test email to")
    from_email: Optional[StrictStr] = Field(default=None, description="From email address (optional)")
    __properties: ClassVar[List[str]] = ["smtp_host", "smtp_port", "smtp_username", "smtp_password", "use_tls", "use_ssl", "test_email", "from_email"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TestSMTPCredentials from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TestSMTPCredentials from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "smtp_host": obj.get("smtp_host"),
            "smtp_port": obj.get("smtp_port"),
            "smtp_username": obj.get("smtp_username"),
            "smtp_password": obj.get("smtp_password"),
            "use_tls": obj.get("use_tls") if obj.get("use_tls") is not None else True,
            "use_ssl": obj.get("use_ssl") if obj.get("use_ssl") is not None else False,
            "test_email": obj.get("test_email"),
            "from_email": obj.get("from_email")
        })
        return _obj


