# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from iblai.models.overtime_data_point import OvertimeDataPoint
from iblai.models.time_spent_course import TimeSpentCourse
from typing import Optional, Set
from typing_extensions import Self

class TimeSpentDetail(BaseModel):
    """
    TimeSpentDetail
    """ # noqa: E501
    courses: List[TimeSpentCourse]
    total_time_spent: StrictStr
    total_time_spent_secs: StrictInt
    overtime: Optional[List[OvertimeDataPoint]] = Field(default=None, description="Time spent over time data (when overtime=true)")
    __properties: ClassVar[List[str]] = ["courses", "total_time_spent", "total_time_spent_secs", "overtime"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TimeSpentDetail from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in courses (list)
        _items = []
        if self.courses:
            for _item_courses in self.courses:
                if _item_courses:
                    _items.append(_item_courses.to_dict())
            _dict['courses'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in overtime (list)
        _items = []
        if self.overtime:
            for _item_overtime in self.overtime:
                if _item_overtime:
                    _items.append(_item_overtime.to_dict())
            _dict['overtime'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TimeSpentDetail from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "courses": [TimeSpentCourse.from_dict(_item) for _item in obj["courses"]] if obj.get("courses") is not None else None,
            "total_time_spent": obj.get("total_time_spent"),
            "total_time_spent_secs": obj.get("total_time_spent_secs"),
            "overtime": [OvertimeDataPoint.from_dict(_item) for _item in obj["overtime"]] if obj.get("overtime") is not None else None
        })
        return _obj


