# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class TimeSpentUpdateRequest(BaseModel):
    """
    TimeSpentUpdateRequest
    """ # noqa: E501
    timestamp: datetime = Field(description="Time when the event occurred, ensure it is UTC (ISO 8601 format)")
    course_id: Optional[StrictStr] = Field(default=None, description="Course ID to track time spent")
    mentor_uuid: Optional[StrictStr] = Field(default=None, description="Mentor UUID to track time spent")
    block_id: Optional[StrictStr] = Field(default=None, description="Block ID to track time spent")
    count: StrictInt = Field(description="Time spent in seconds")
    url: StrictStr = Field(description="Source URL")
    metadata: Optional[Any] = Field(default=None, description="Additional metadata")
    session_uuid: Optional[StrictStr] = Field(default=None, description="Session UUID to track time spent")
    __properties: ClassVar[List[str]] = ["timestamp", "course_id", "mentor_uuid", "block_id", "count", "url", "metadata", "session_uuid"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TimeSpentUpdateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TimeSpentUpdateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "timestamp": obj.get("timestamp"),
            "course_id": obj.get("course_id"),
            "mentor_uuid": obj.get("mentor_uuid"),
            "block_id": obj.get("block_id"),
            "count": obj.get("count"),
            "url": obj.get("url"),
            "metadata": obj.get("metadata"),
            "session_uuid": obj.get("session_uuid")
        })
        return _obj


