# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List
from iblai.models.auth_token import AuthToken
from iblai.models.manager_auth_token import ManagerAuthToken
from iblai.models.token_proxy_user import TokenProxyUser
from typing import Optional, Set
from typing_extensions import Self

class TokenProxyOutputSerializerData(BaseModel):
    """
    Core data for Response
    """ # noqa: E501
    user: TokenProxyUser = Field(description="User details")
    axd_token: AuthToken = Field(description="Axd Token details")
    dm_token: ManagerAuthToken = Field(description="DM Token details")
    __properties: ClassVar[List[str]] = ["user", "axd_token", "dm_token"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TokenProxyOutputSerializerData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of user
        if self.user:
            _dict['user'] = self.user.to_dict()
        # override the default output from pydantic by calling `to_dict()` of axd_token
        if self.axd_token:
            _dict['axd_token'] = self.axd_token.to_dict()
        # override the default output from pydantic by calling `to_dict()` of dm_token
        if self.dm_token:
            _dict['dm_token'] = self.dm_token.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TokenProxyOutputSerializerData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "user": TokenProxyUser.from_dict(obj["user"]) if obj.get("user") is not None else None,
            "axd_token": AuthToken.from_dict(obj["axd_token"]) if obj.get("axd_token") is not None else None,
            "dm_token": ManagerAuthToken.from_dict(obj["dm_token"]) if obj.get("dm_token") is not None else None
        })
        return _obj


