# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from iblai.models.tool_category import ToolCategory
from typing import Optional, Set
from typing_extensions import Self

class ToolResponse(BaseModel):
    """
    ToolResponse
    """ # noqa: E501
    id: StrictInt
    name: Annotated[str, Field(strict=True, max_length=500)]
    display_name: Optional[Annotated[str, Field(strict=True, max_length=255)]] = None
    slug: Optional[Annotated[str, Field(strict=True, max_length=50)]] = None
    category: ToolCategory
    description: Optional[StrictStr] = None
    logo: Optional[StrictStr] = None
    metadata: Optional[Any] = None
    allow_base_agent: Optional[StrictBool] = None
    allow_openai_agent: Optional[StrictBool] = None
    allow_openai_assistant: Optional[StrictBool] = None
    allow_google_agent: Optional[StrictBool] = None
    __properties: ClassVar[List[str]] = ["id", "name", "display_name", "slug", "category", "description", "logo", "metadata", "allow_base_agent", "allow_openai_agent", "allow_openai_assistant", "allow_google_agent"]

    @field_validator('slug')
    def slug_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[-a-zA-Z0-9_]+$", value):
            raise ValueError(r"must validate the regular expression /^[-a-zA-Z0-9_]+$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ToolResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "category",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of category
        if self.category:
            _dict['category'] = self.category.to_dict()
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if logo (nullable) is None
        # and model_fields_set contains the field
        if self.logo is None and "logo" in self.model_fields_set:
            _dict['logo'] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ToolResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "display_name": obj.get("display_name"),
            "slug": obj.get("slug"),
            "category": ToolCategory.from_dict(obj["category"]) if obj.get("category") is not None else None,
            "description": obj.get("description"),
            "logo": obj.get("logo"),
            "metadata": obj.get("metadata"),
            "allow_base_agent": obj.get("allow_base_agent"),
            "allow_openai_agent": obj.get("allow_openai_agent"),
            "allow_openai_assistant": obj.get("allow_openai_assistant"),
            "allow_google_agent": obj.get("allow_google_agent")
        })
        return _obj


