# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List
from iblai.models.topics_overview_metric import TopicsOverviewMetric
from typing import Optional, Set
from typing_extensions import Self

class TopicsOverview(BaseModel):
    """
    Dashboard KPI overview for topics.
    """ # noqa: E501
    topics: TopicsOverviewMetric = Field(description="Topic metrics including all-time, monthly counts and percentage change")
    sessions: TopicsOverviewMetric = Field(description="Session metrics including all-time, monthly counts and percentage change")
    conversations: TopicsOverviewMetric = Field(description="Conversation metrics including all-time, monthly counts and percentage change")
    messages: TopicsOverviewMetric = Field(description="Message metrics including all-time, monthly counts and percentage change")
    __properties: ClassVar[List[str]] = ["topics", "sessions", "conversations", "messages"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TopicsOverview from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of topics
        if self.topics:
            _dict['topics'] = self.topics.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sessions
        if self.sessions:
            _dict['sessions'] = self.sessions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of conversations
        if self.conversations:
            _dict['conversations'] = self.conversations.to_dict()
        # override the default output from pydantic by calling `to_dict()` of messages
        if self.messages:
            _dict['messages'] = self.messages.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TopicsOverview from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "topics": TopicsOverviewMetric.from_dict(obj["topics"]) if obj.get("topics") is not None else None,
            "sessions": TopicsOverviewMetric.from_dict(obj["sessions"]) if obj.get("sessions") is not None else None,
            "conversations": TopicsOverviewMetric.from_dict(obj["conversations"]) if obj.get("conversations") is not None else None,
            "messages": TopicsOverviewMetric.from_dict(obj["messages"]) if obj.get("messages") is not None else None
        })
        return _obj


