# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class Trace(BaseModel):
    """
    Trace
    """ # noqa: E501
    id: StrictStr
    timestamp: datetime
    name: StrictStr
    user_id: Optional[StrictStr] = None
    metadata: Optional[Any]
    release: Optional[StrictStr] = None
    version: Optional[StrictStr] = None
    tags: List[StrictStr]
    input: Optional[StrictStr] = None
    output: Optional[StrictStr] = None
    session_id: Optional[StrictStr] = None
    created_at: datetime
    updated_at: Optional[datetime] = None
    event_ts: datetime
    is_deleted: Annotated[int, Field(le=255, strict=True, ge=0)]
    __properties: ClassVar[List[str]] = ["id", "timestamp", "name", "user_id", "metadata", "release", "version", "tags", "input", "output", "session_id", "created_at", "updated_at", "event_ts", "is_deleted"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Trace from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "created_at",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if user_id (nullable) is None
        # and model_fields_set contains the field
        if self.user_id is None and "user_id" in self.model_fields_set:
            _dict['user_id'] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        # set to None if release (nullable) is None
        # and model_fields_set contains the field
        if self.release is None and "release" in self.model_fields_set:
            _dict['release'] = None

        # set to None if version (nullable) is None
        # and model_fields_set contains the field
        if self.version is None and "version" in self.model_fields_set:
            _dict['version'] = None

        # set to None if input (nullable) is None
        # and model_fields_set contains the field
        if self.input is None and "input" in self.model_fields_set:
            _dict['input'] = None

        # set to None if output (nullable) is None
        # and model_fields_set contains the field
        if self.output is None and "output" in self.model_fields_set:
            _dict['output'] = None

        # set to None if session_id (nullable) is None
        # and model_fields_set contains the field
        if self.session_id is None and "session_id" in self.model_fields_set:
            _dict['session_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Trace from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "timestamp": obj.get("timestamp"),
            "name": obj.get("name"),
            "user_id": obj.get("user_id"),
            "metadata": obj.get("metadata"),
            "release": obj.get("release"),
            "version": obj.get("version"),
            "tags": obj.get("tags"),
            "input": obj.get("input"),
            "output": obj.get("output"),
            "session_id": obj.get("session_id"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "event_ts": obj.get("event_ts"),
            "is_deleted": obj.get("is_deleted")
        })
        return _obj


