# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictBytes, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Tuple, Union
from iblai.models.crawler_pattern_type_enum import CrawlerPatternTypeEnum
from typing import Optional, Set
from typing_extensions import Self

class TrainDocumentViewRequest(BaseModel):
    """
    TrainDocumentViewRequest
    """ # noqa: E501
    pathway: Optional[StrictStr] = Field(default=None, description="Pathway for document to be trained in")
    url: Optional[StrictStr] = Field(default=None, description="Url of the document to be trained")
    text: Optional[StrictStr] = Field(default=None, description="Search text for wikipedia")
    type: StrictStr = Field(description="Type of document e.g file")
    translate: Optional[StrictBool] = Field(default=False, description="If file should be translated")
    file: Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]] = Field(default=None, description="File to be trained")
    access: Optional[StrictStr] = Field(default='private', description="Accessibilityto the file")
    branch: Optional[StrictStr] = Field(default=None, description="Branch of the repository")
    google_drive_auth_data: Optional[Any] = Field(default=None, description="Authentication and scoped details of google drive")
    dropbox_auth_data: Optional[Any] = Field(default=None, description="Authentication and scoped details of dropbox")
    crawler_max_depth: Optional[StrictInt] = Field(default=None, description="The max depth of the crawler")
    crawler_max_pages_limit: Optional[StrictInt] = Field(default=None, description="The max pages limit of the crawler")
    crawler_max_concurrency: Optional[StrictInt] = Field(default=None, description="The max concurrency of the crawler")
    crawler_match_patterns: Optional[List[StrictStr]] = Field(default=None, description="The patterns that the crawler should use to match urls. Patterns may be a glob pattern or a full regex pattern. Indicate the specified type in `crawler_pattern_type`.")
    crawler_pattern_type: Optional[CrawlerPatternTypeEnum] = Field(default=None, description="Pattern type for the crawler  * `glob` - Glob * `regex` - Regex")
    custom_metadata: Optional[Any] = Field(default=None, description="Custom metadata to attach to the trained document. Must be a flat JSON object with string keys and string, number, or boolean values.")
    add_to_document_pool: Optional[StrictBool] = Field(default=False, description="Adds document to the pool or not.")
    document_pool_only: Optional[StrictBool] = Field(default=False, description="Only adds document to document pool. Requires pathway to be empty.")
    user_image_description: Optional[StrictStr] = Field(default=None, description="Description of an image submitted by the user for RAG.")
    __properties: ClassVar[List[str]] = ["pathway", "url", "text", "type", "translate", "file", "access", "branch", "google_drive_auth_data", "dropbox_auth_data", "crawler_max_depth", "crawler_max_pages_limit", "crawler_max_concurrency", "crawler_match_patterns", "crawler_pattern_type", "custom_metadata", "add_to_document_pool", "document_pool_only", "user_image_description"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TrainDocumentViewRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if google_drive_auth_data (nullable) is None
        # and model_fields_set contains the field
        if self.google_drive_auth_data is None and "google_drive_auth_data" in self.model_fields_set:
            _dict['google_drive_auth_data'] = None

        # set to None if dropbox_auth_data (nullable) is None
        # and model_fields_set contains the field
        if self.dropbox_auth_data is None and "dropbox_auth_data" in self.model_fields_set:
            _dict['dropbox_auth_data'] = None

        # set to None if custom_metadata (nullable) is None
        # and model_fields_set contains the field
        if self.custom_metadata is None and "custom_metadata" in self.model_fields_set:
            _dict['custom_metadata'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TrainDocumentViewRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pathway": obj.get("pathway"),
            "url": obj.get("url"),
            "text": obj.get("text"),
            "type": obj.get("type"),
            "translate": obj.get("translate") if obj.get("translate") is not None else False,
            "file": obj.get("file"),
            "access": obj.get("access") if obj.get("access") is not None else 'private',
            "branch": obj.get("branch"),
            "google_drive_auth_data": obj.get("google_drive_auth_data"),
            "dropbox_auth_data": obj.get("dropbox_auth_data"),
            "crawler_max_depth": obj.get("crawler_max_depth"),
            "crawler_max_pages_limit": obj.get("crawler_max_pages_limit"),
            "crawler_max_concurrency": obj.get("crawler_max_concurrency"),
            "crawler_match_patterns": obj.get("crawler_match_patterns"),
            "crawler_pattern_type": obj.get("crawler_pattern_type"),
            "custom_metadata": obj.get("custom_metadata"),
            "add_to_document_pool": obj.get("add_to_document_pool") if obj.get("add_to_document_pool") is not None else False,
            "document_pool_only": obj.get("document_pool_only") if obj.get("document_pool_only") is not None else False,
            "user_image_description": obj.get("user_image_description")
        })
        return _obj


