# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from iblai.models.component_block import ComponentBlock
from iblai.models.status6ee_enum import Status6eeEnum
from iblai.models.type_c42_enum import TypeC42Enum
from typing import Optional, Set
from typing_extensions import Self

class UnitWithChildren(BaseModel):
    """
    UnitWithChildren
    """ # noqa: E501
    id: StrictInt
    subsection: StrictInt
    display_name: Annotated[str, Field(strict=True, max_length=255)]
    status: Status6eeEnum
    type: Optional[TypeC42Enum] = None
    created_at: datetime
    updated_at: datetime
    components: List[ComponentBlock]
    __properties: ClassVar[List[str]] = ["id", "subsection", "display_name", "status", "type", "created_at", "updated_at", "components"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UnitWithChildren from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "status",
            "created_at",
            "updated_at",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in components (list)
        _items = []
        if self.components:
            for _item_components in self.components:
                if _item_components:
                    _items.append(_item_components.to_dict())
            _dict['components'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UnitWithChildren from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "subsection": obj.get("subsection"),
            "display_name": obj.get("display_name"),
            "status": obj.get("status"),
            "type": obj.get("type"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "components": [ComponentBlock.from_dict(_item) for _item in obj["components"]] if obj.get("components") is not None else None
        })
        return _obj


