# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from iblai.models.app import App
from iblai.models.platform import Platform
from typing import Optional, Set
from typing_extensions import Self

class UserApp(BaseModel):
    """
    UserApp
    """ # noqa: E501
    id: StrictInt
    app: App = Field(description="The app details")
    platform: Platform = Field(description="The platform details")
    subscription: Optional[Dict[str, Any]] = Field(description="The subscription details, would contain identifier, active, created_on, last_updated")
    provider: StrictStr
    is_admin: StrictBool
    is_active: StrictBool
    metadata: Optional[Any] = None
    onboarding_completed: Optional[StrictBool] = None
    free_trial_started: Optional[StrictBool] = None
    free_trial_expired: Optional[StrictBool] = None
    has_active_subscription: Optional[StrictBool] = None
    __properties: ClassVar[List[str]] = ["id", "app", "platform", "subscription", "provider", "is_admin", "is_active", "metadata", "onboarding_completed", "free_trial_started", "free_trial_expired", "has_active_subscription"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserApp from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "platform",
            "subscription",
            "is_admin",
            "is_active",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of app
        if self.app:
            _dict['app'] = self.app.to_dict()
        # override the default output from pydantic by calling `to_dict()` of platform
        if self.platform:
            _dict['platform'] = self.platform.to_dict()
        # set to None if subscription (nullable) is None
        # and model_fields_set contains the field
        if self.subscription is None and "subscription" in self.model_fields_set:
            _dict['subscription'] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserApp from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "app": App.from_dict(obj["app"]) if obj.get("app") is not None else None,
            "platform": Platform.from_dict(obj["platform"]) if obj.get("platform") is not None else None,
            "subscription": obj.get("subscription"),
            "provider": obj.get("provider"),
            "is_admin": obj.get("is_admin"),
            "is_active": obj.get("is_active"),
            "metadata": obj.get("metadata"),
            "onboarding_completed": obj.get("onboarding_completed"),
            "free_trial_started": obj.get("free_trial_started"),
            "free_trial_expired": obj.get("free_trial_expired"),
            "has_active_subscription": obj.get("has_active_subscription")
        })
        return _obj


