# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from iblai.models.user_group_access_info import UserGroupAccessInfo
from typing import Optional, Set
from typing_extensions import Self

class UserGroupAccess(BaseModel):
    """
    ModelSerializer for user group access policies
    """ # noqa: E501
    platform_key: StrictStr = Field(description="Platform key where the groups exist")
    user_id: StrictInt = Field(description="ID of the user to manage group access for")
    groups_to_add: Optional[List[StrictInt]] = Field(default=None, description="List of group IDs to grant access to")
    groups_to_remove: Optional[List[StrictInt]] = Field(default=None, description="List of group IDs to revoke access from")
    policy_id: StrictInt = Field(description="Policy ID")
    policy_name: StrictStr = Field(description="Policy name")
    groups_with_access: List[UserGroupAccessInfo] = Field(description="Groups with access")
    __properties: ClassVar[List[str]] = ["platform_key", "user_id", "groups_to_add", "groups_to_remove", "policy_id", "policy_name", "groups_with_access"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserGroupAccess from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "policy_id",
            "policy_name",
            "groups_with_access",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in groups_with_access (list)
        _items = []
        if self.groups_with_access:
            for _item_groups_with_access in self.groups_with_access:
                if _item_groups_with_access:
                    _items.append(_item_groups_with_access.to_dict())
            _dict['groups_with_access'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserGroupAccess from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "platform_key": obj.get("platform_key"),
            "user_id": obj.get("user_id"),
            "groups_to_add": obj.get("groups_to_add"),
            "groups_to_remove": obj.get("groups_to_remove"),
            "policy_id": obj.get("policy_id"),
            "policy_name": obj.get("policy_name"),
            "groups_with_access": [UserGroupAccessInfo.from_dict(_item) for _item in obj["groups_with_access"]] if obj.get("groups_with_access") is not None else None
        })
        return _obj


