# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class UserLicenseCreate(BaseModel):
    """
    Request serializer for UserLicenseCreateView POST endpoint
    """ # noqa: E501
    platform_key: StrictStr = Field(description="The platform to create a license for")
    platform_org: Optional[StrictStr] = Field(default=None, description="The organization identifier for the platform")
    name: Optional[StrictStr] = Field(default=None, description="Display name for the license")
    count: Optional[StrictInt] = Field(default=0, description="Number of seats purchased")
    started: Optional[datetime] = Field(default=None, description="Date when license should begin")
    expired: Optional[datetime] = Field(default=None, description="Date when license should expire")
    active: Optional[StrictBool] = Field(default=True, description="Whether the license is active")
    metadata: Optional[Dict[str, Any]] = Field(default=None, description="Additional license metadata")
    enrollment_config: Optional[Dict[str, Any]] = Field(default=None, description="Additional enrollment configuration")
    source: Optional[StrictStr] = Field(default=None, description="Source identifier")
    external_id: Optional[StrictStr] = Field(default=None, description="External identifier (must be unique)")
    transaction_id: Optional[StrictStr] = Field(default=None, description="Transaction identifier for tracking")
    change_type: Optional[StrictStr] = Field(default='create', description="Type of change being made")
    __properties: ClassVar[List[str]] = ["platform_key", "platform_org", "name", "count", "started", "expired", "active", "metadata", "enrollment_config", "source", "external_id", "transaction_id", "change_type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserLicenseCreate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if expired (nullable) is None
        # and model_fields_set contains the field
        if self.expired is None and "expired" in self.model_fields_set:
            _dict['expired'] = None

        # set to None if external_id (nullable) is None
        # and model_fields_set contains the field
        if self.external_id is None and "external_id" in self.model_fields_set:
            _dict['external_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserLicenseCreate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "platform_key": obj.get("platform_key"),
            "platform_org": obj.get("platform_org"),
            "name": obj.get("name"),
            "count": obj.get("count") if obj.get("count") is not None else 0,
            "started": obj.get("started"),
            "expired": obj.get("expired"),
            "active": obj.get("active") if obj.get("active") is not None else True,
            "metadata": obj.get("metadata"),
            "enrollment_config": obj.get("enrollment_config"),
            "source": obj.get("source"),
            "external_id": obj.get("external_id"),
            "transaction_id": obj.get("transaction_id"),
            "change_type": obj.get("change_type") if obj.get("change_type") is not None else 'create'
        })
        return _obj


