# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from iblai.models.user_memory_entry import UserMemoryEntry
from typing import Optional, Set
from typing_extensions import Self

class UserMemory(BaseModel):
    """
    UserMemory
    """ # noqa: E501
    mode: StrictStr
    name: Optional[StrictStr] = None
    email: Optional[StrictStr]
    unique_id: Optional[UUID] = None
    username: Optional[StrictStr]
    platform: Optional[StrictStr]
    mentor: Optional[StrictStr]
    session_id: Optional[StrictStr]
    catalog_item_type: Optional[StrictStr]
    catalog_item_id: Optional[StrictStr]
    entries: List[UserMemoryEntry]
    inserted_at: StrictStr
    updated_at: StrictStr
    is_auto_generated: Optional[StrictBool] = None
    category: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["mode", "name", "email", "unique_id", "username", "platform", "mentor", "session_id", "catalog_item_type", "catalog_item_id", "entries", "inserted_at", "updated_at", "is_auto_generated", "category"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserMemory from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "mode",
            "email",
            "username",
            "platform",
            "mentor",
            "session_id",
            "catalog_item_type",
            "catalog_item_id",
            "inserted_at",
            "updated_at",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in entries (list)
        _items = []
        if self.entries:
            for _item_entries in self.entries:
                if _item_entries:
                    _items.append(_item_entries.to_dict())
            _dict['entries'] = _items
        # set to None if email (nullable) is None
        # and model_fields_set contains the field
        if self.email is None and "email" in self.model_fields_set:
            _dict['email'] = None

        # set to None if username (nullable) is None
        # and model_fields_set contains the field
        if self.username is None and "username" in self.model_fields_set:
            _dict['username'] = None

        # set to None if platform (nullable) is None
        # and model_fields_set contains the field
        if self.platform is None and "platform" in self.model_fields_set:
            _dict['platform'] = None

        # set to None if mentor (nullable) is None
        # and model_fields_set contains the field
        if self.mentor is None and "mentor" in self.model_fields_set:
            _dict['mentor'] = None

        # set to None if session_id (nullable) is None
        # and model_fields_set contains the field
        if self.session_id is None and "session_id" in self.model_fields_set:
            _dict['session_id'] = None

        # set to None if catalog_item_type (nullable) is None
        # and model_fields_set contains the field
        if self.catalog_item_type is None and "catalog_item_type" in self.model_fields_set:
            _dict['catalog_item_type'] = None

        # set to None if catalog_item_id (nullable) is None
        # and model_fields_set contains the field
        if self.catalog_item_id is None and "catalog_item_id" in self.model_fields_set:
            _dict['catalog_item_id'] = None

        # set to None if category (nullable) is None
        # and model_fields_set contains the field
        if self.category is None and "category" in self.model_fields_set:
            _dict['category'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserMemory from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "mode": obj.get("mode"),
            "name": obj.get("name"),
            "email": obj.get("email"),
            "unique_id": obj.get("unique_id"),
            "username": obj.get("username"),
            "platform": obj.get("platform"),
            "mentor": obj.get("mentor"),
            "session_id": obj.get("session_id"),
            "catalog_item_type": obj.get("catalog_item_type"),
            "catalog_item_id": obj.get("catalog_item_id"),
            "entries": [UserMemoryEntry.from_dict(_item) for _item in obj["entries"]] if obj.get("entries") is not None else None,
            "inserted_at": obj.get("inserted_at"),
            "updated_at": obj.get("updated_at"),
            "is_auto_generated": obj.get("is_auto_generated"),
            "category": obj.get("category")
        })
        return _obj


