# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from iblai.models.user_memory_entry_request import UserMemoryEntryRequest
from typing import Optional, Set
from typing_extensions import Self

class UserMemoryRequest(BaseModel):
    """
    UserMemoryRequest
    """ # noqa: E501
    mode: Optional[StrictStr] = 'all'
    name: Optional[StrictStr] = None
    platform: Optional[StrictStr] = None
    mentor_unique_id: Optional[StrictStr] = None
    session_id: Optional[StrictStr] = None
    catalog_item_type: Optional[StrictStr] = None
    catalog_item_id: Optional[StrictStr] = None
    entries: List[UserMemoryEntryRequest]
    category: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["mode", "name", "platform", "mentor_unique_id", "session_id", "catalog_item_type", "catalog_item_id", "entries", "category"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserMemoryRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in entries (list)
        _items = []
        if self.entries:
            for _item_entries in self.entries:
                if _item_entries:
                    _items.append(_item_entries.to_dict())
            _dict['entries'] = _items
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if platform (nullable) is None
        # and model_fields_set contains the field
        if self.platform is None and "platform" in self.model_fields_set:
            _dict['platform'] = None

        # set to None if mentor_unique_id (nullable) is None
        # and model_fields_set contains the field
        if self.mentor_unique_id is None and "mentor_unique_id" in self.model_fields_set:
            _dict['mentor_unique_id'] = None

        # set to None if session_id (nullable) is None
        # and model_fields_set contains the field
        if self.session_id is None and "session_id" in self.model_fields_set:
            _dict['session_id'] = None

        # set to None if catalog_item_type (nullable) is None
        # and model_fields_set contains the field
        if self.catalog_item_type is None and "catalog_item_type" in self.model_fields_set:
            _dict['catalog_item_type'] = None

        # set to None if catalog_item_id (nullable) is None
        # and model_fields_set contains the field
        if self.catalog_item_id is None and "catalog_item_id" in self.model_fields_set:
            _dict['catalog_item_id'] = None

        # set to None if category (nullable) is None
        # and model_fields_set contains the field
        if self.category is None and "category" in self.model_fields_set:
            _dict['category'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserMemoryRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "mode": obj.get("mode") if obj.get("mode") is not None else 'all',
            "name": obj.get("name"),
            "platform": obj.get("platform"),
            "mentor_unique_id": obj.get("mentor_unique_id"),
            "session_id": obj.get("session_id"),
            "catalog_item_type": obj.get("catalog_item_type"),
            "catalog_item_id": obj.get("catalog_item_id"),
            "entries": [UserMemoryEntryRequest.from_dict(_item) for _item in obj["entries"]] if obj.get("entries") is not None else None,
            "category": obj.get("category")
        })
        return _obj


