# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class UserPolicyUpdate(BaseModel):
    """
    Serializer for updating user policies on a platform.  Accepts lists of policies to add and remove for a specific user on a platform.
    """ # noqa: E501
    user_id: StrictInt = Field(description="ID of the user to update policies for")
    platform_key: StrictStr = Field(description="Platform key where the user's policies should be updated")
    policies_to_add: Optional[List[StrictStr]] = Field(default=None, description="List of policy names to add to the user")
    policies_to_remove: Optional[List[StrictStr]] = Field(default=None, description="List of policy names to remove from the user")
    policies_to_set: Optional[List[StrictStr]] = Field(default=None, description="List of policy names to set for the user (replaces all existing policies with these)")
    __properties: ClassVar[List[str]] = ["user_id", "platform_key", "policies_to_add", "policies_to_remove", "policies_to_set"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserPolicyUpdate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserPolicyUpdate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "user_id": obj.get("user_id"),
            "platform_key": obj.get("platform_key"),
            "policies_to_add": obj.get("policies_to_add"),
            "policies_to_remove": obj.get("policies_to_remove"),
            "policies_to_set": obj.get("policies_to_set")
        })
        return _obj


