# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from iblai.models.course_point import CoursePoint
from iblai.models.resource_point import ResourcePoint
from iblai.models.skill import Skill
from typing import Optional, Set
from typing_extensions import Self

class UserSkill(BaseModel):
    """
    UserSkill
    """ # noqa: E501
    skill: Skill
    courses: List[CoursePoint] = Field(description="Courses with skill and associated points")
    resources: List[ResourcePoint] = Field(description="Resources with skill and associated points")
    total_points: StrictInt = Field(description="Total points for skill")
    percentile: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Percentile of points for user.")
    __properties: ClassVar[List[str]] = ["skill", "courses", "resources", "total_points", "percentile"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserSkill from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "total_points",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of skill
        if self.skill:
            _dict['skill'] = self.skill.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in courses (list)
        _items = []
        if self.courses:
            for _item_courses in self.courses:
                if _item_courses:
                    _items.append(_item_courses.to_dict())
            _dict['courses'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in resources (list)
        _items = []
        if self.resources:
            for _item_resources in self.resources:
                if _item_resources:
                    _items.append(_item_resources.to_dict())
            _dict['resources'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserSkill from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "skill": Skill.from_dict(obj["skill"]) if obj.get("skill") is not None else None,
            "courses": [CoursePoint.from_dict(_item) for _item in obj["courses"]] if obj.get("courses") is not None else None,
            "resources": [ResourcePoint.from_dict(_item) for _item in obj["resources"]] if obj.get("resources") is not None else None,
            "total_points": obj.get("total_points"),
            "percentile": obj.get("percentile")
        })
        return _obj


