# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class VectorResult(BaseModel):
    """
    VectorResult
    """ # noqa: E501
    type: Optional[StrictStr] = 'document'
    title: Optional[StrictStr] = ''
    snippet: StrictStr
    source: Optional[StrictStr] = None
    score: Optional[Union[StrictFloat, StrictInt]] = None
    confidence_level: Optional[Union[StrictFloat, StrictInt]] = None
    llm_provider: Optional[StrictStr] = 'openai'
    llm_model: Optional[StrictStr] = 'gpt-4o-mini'
    __properties: ClassVar[List[str]] = ["type", "title", "snippet", "source", "score", "confidence_level", "llm_provider", "llm_model"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of VectorResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of VectorResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type") if obj.get("type") is not None else 'document',
            "title": obj.get("title") if obj.get("title") is not None else '',
            "snippet": obj.get("snippet"),
            "source": obj.get("source"),
            "score": obj.get("score"),
            "confidence_level": obj.get("confidence_level"),
            "llm_provider": obj.get("llm_provider") if obj.get("llm_provider") is not None else 'openai',
            "llm_model": obj.get("llm_model") if obj.get("llm_model") is not None else 'gpt-4o-mini'
        })
        return _obj


