# coding: utf-8

"""
    ibl-data-manager

    API for iblai

    The version of the OpenAPI document: 4.89.4-ai-plus
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class VeoVideoDetail(BaseModel):
    """
    VeoVideoDetail
    """ # noqa: E501
    name: Optional[Annotated[str, Field(strict=True, max_length=1024)]] = None
    data: Optional[Any] = None
    id: StrictInt
    video_file: Optional[StrictStr]
    generation_status: StrictStr
    prompt_text: Optional[StrictStr] = None
    prompt_image: Optional[StrictStr]
    thumbnail_image: Optional[StrictStr]
    __properties: ClassVar[List[str]] = ["name", "data", "id", "video_file", "generation_status", "prompt_text", "prompt_image", "thumbnail_image"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of VeoVideoDetail from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "video_file",
            "generation_status",
            "prompt_image",
            "thumbnail_image",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if data (nullable) is None
        # and model_fields_set contains the field
        if self.data is None and "data" in self.model_fields_set:
            _dict['data'] = None

        # set to None if video_file (nullable) is None
        # and model_fields_set contains the field
        if self.video_file is None and "video_file" in self.model_fields_set:
            _dict['video_file'] = None

        # set to None if prompt_text (nullable) is None
        # and model_fields_set contains the field
        if self.prompt_text is None and "prompt_text" in self.model_fields_set:
            _dict['prompt_text'] = None

        # set to None if prompt_image (nullable) is None
        # and model_fields_set contains the field
        if self.prompt_image is None and "prompt_image" in self.model_fields_set:
            _dict['prompt_image'] = None

        # set to None if thumbnail_image (nullable) is None
        # and model_fields_set contains the field
        if self.thumbnail_image is None and "thumbnail_image" in self.model_fields_set:
            _dict['thumbnail_image'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of VeoVideoDetail from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "data": obj.get("data"),
            "id": obj.get("id"),
            "video_file": obj.get("video_file"),
            "generation_status": obj.get("generation_status"),
            "prompt_text": obj.get("prompt_text"),
            "prompt_image": obj.get("prompt_image"),
            "thumbnail_image": obj.get("thumbnail_image")
        })
        return _obj


