# The DEPLOF font is made by David Elata, MEMS Lab, Technion, Haifa, Israel and
# and is used with permission.  The raw polygon entries are sourced from
# Ulf Griesmann's modified DEPLOF implementation used in the MATLAB gdsii
# toolbox https://github.com/ulfgri/gdsii-toolbox/ and are used with permission


_glyph = {}
_width = {}
_indent = {}

_glyph[33] = [
    [[100, -100], [100, 100], [300, 100], [300, -100], [100, -100]],
    [[100, 250], [100, 1100], [300, 1100], [300, 250], [100, 250]],
]
_glyph[34] = [
    [[300, 800], [300, 1200], [500, 1200], [500, 1000], [300, 800]],
    [[600, 800], [600, 1200], [800, 1200], [800, 1000], [600, 800]],
]
_glyph[35] = [
    [
        [150, 0],
        [170, 200],
        [50, 200],
        [50, 400],
        [190, 400],
        [210, 600],
        [100, 600],
        [100, 800],
        [230, 800],
        [250, 1000],
        [450, 1000],
        [390, 400],
        [530, 400],
        [510, 200],
        [370, 200],
        [350, 0],
        [150, 0],
    ],
    [
        [550, 0],
        [610, 600],
        [470, 600],
        [490, 800],
        [630, 800],
        [650, 1000],
        [850, 1000],
        [830, 800],
        [950, 800],
        [950, 600],
        [810, 600],
        [790, 400],
        [900, 400],
        [900, 200],
        [770, 200],
        [750, 0],
        [550, 0],
    ],
]
_glyph[36] = [
    [
        [400, 1000],
        [400, 1200],
        [600, 1200],
        [600, 1000],
        [800, 1000],
        [900, 900],
        [900, 800],
        [300, 800],
        [300, 600],
        [400, 600],
        [400, 700],
        [600, 700],
        [600, 600],
        [800, 600],
        [900, 500],
        [900, 100],
        [800, 0],
        [600, 0],
        [600, -200],
        [400, -200],
        [400, 0],
        [200, 0],
        [100, 100],
        [100, 200],
        [700, 200],
        [700, 400],
        [600, 400],
        [600, 300],
        [400, 300],
        [400, 400],
        [200, 400],
        [100, 500],
        [100, 900],
        [200, 1000],
        [400, 1000],
    ]
]
_glyph[37] = [
    [[100, 100], [800, 1000], [900, 900], [200, 0], [100, 100]],
    [
        [100, 900],
        [400, 900],
        [400, 650],
        [350, 600],
        [200, 600],
        [300, 700],
        [300, 800],
        [200, 800],
        [200, 700],
        [100, 600],
        [100, 900],
    ],
    [
        [650, 400],
        [800, 400],
        [700, 300],
        [700, 200],
        [800, 200],
        [800, 300],
        [900, 400],
        [900, 100],
        [600, 100],
        [600, 350],
        [650, 400],
    ],
]
_glyph[38] = [
    [
        [700, 0],
        [100, 600],
        [100, 800],
        [200, 900],
        [400, 900],
        [500, 800],
        [500, 800],
        [500, 600],
        [450, 550],
        [350, 650],
        [400, 700],
        [300, 800],
        [200, 700],
        [600, 300],
        [700, 400],
        [800, 300],
        [700, 200],
        [900, 0],
        [700, 0],
    ],
    [
        [550, 50],
        [500, 0],
        [100, 0],
        [0, 100],
        [0, 300],
        [100, 400],
        [150, 450],
        [250, 350],
        [100, 200],
        [100, 150],
        [150, 100],
        [400, 100],
        [450, 150],
        [550, 50],
    ],
]
_glyph[39] = [[[300, 800], [300, 1200], [500, 1200], [500, 1000], [300, 800]]]
_glyph[40] = [
    [
        [100, 500],
        [125, 700],
        [175, 900],
        [250, 1100],
        [450, 1100],
        [375, 900],
        [325, 700],
        [300, 500],
        [325, 300],
        [375, 100],
        [450, -100],
        [250, -100],
        [175, 100],
        [125, 300],
        [100, 500],
    ]
]
_glyph[41] = [
    [
        [100, 1100],
        [300, 1100],
        [375, 900],
        [425, 700],
        [450, 500],
        [425, 300],
        [375, 100],
        [300, -100],
        [100, -100],
        [175, 100],
        [225, 300],
        [250, 500],
        [225, 700],
        [175, 900],
        [100, 1100],
    ]
]
_glyph[42] = [
    [
        [450, 750],
        [450, 1000],
        [550, 1000],
        [550, 750],
        [800, 750],
        [800, 650],
        [550, 650],
        [550, 400],
        [450, 400],
        [450, 650],
        [200, 650],
        [200, 750],
        [450, 750],
    ],
    [
        [350, 850],
        [250, 850],
        [200, 900],
        [200, 1000],
        [300, 1000],
        [350, 950],
        [350, 850],
    ],
    [
        [650, 850],
        [650, 950],
        [700, 1000],
        [800, 1000],
        [800, 900],
        [750, 850],
        [650, 850],
    ],
    [
        [650, 550],
        [750, 550],
        [800, 500],
        [800, 400],
        [700, 400],
        [650, 450],
        [650, 550],
    ],
    [
        [350, 550],
        [350, 450],
        [300, 400],
        [200, 400],
        [200, 500],
        [250, 550],
        [350, 550],
    ],
]
# +
_glyph[43] = [
    [
        [400, 600],
        [400, 900],
        [600, 900],
        [600, 600],
        [900, 600],
        [900, 400],
        [600, 400],
        [600, 100],
        [400, 100],
        [400, 400],
        [100, 400],
        [100, 600],
        [400, 600],
    ]
]
_glyph[44] = [[[300, 200], [300, 0], [100, -200], [100, 200], [300, 200]]]
_glyph[45] = [[[900, 550], [900, 350], [100, 350], [100, 550], [900, 550]]]
_glyph[46] = [[[300, 200], [300, 0], [100, 0], [100, 200], [300, 200]]]
_glyph[47] = [[[500, 1200], [300, -200], [100, -200], [300, 1200], [500, 1200]]]
# 0
_glyph[48] = [
    [
        [400, 800],
        [300, 700],
        [300, 300],
        [400, 200],
        [350, 0],
        [300, 0],
        [100, 200],
        [100, 800],
        [300, 1000],
        [530, 1000],
        [480, 800],
        [400, 800],
    ],
    [
        [600, 200],
        [700, 300],
        [700, 700],
        [600, 800],
        [650, 1000],
        [700, 1000],
        [900, 800],
        [900, 200],
        [700, 0],
        [470, 0],
        [520, 200],
        [600, 200],
    ],
]
_glyph[49] = [
    [
        [200, 600],
        [100, 600],
        [100, 800],
        [300, 1000],
        [400, 1000],
        [400, 200],
        [500, 200],
        [500, 0],
        [100, 0],
        [100, 200],
        [200, 200],
        [200, 600],
        [200, 600],
    ]
]
_glyph[50] = [
    [
        [100, 900],
        [200, 1000],
        [700, 1000],
        [800, 900],
        [800, 600],
        [400, 200],
        [800, 200],
        [800, 0],
        [100, 0],
        [100, 200],
        [600, 700],
        [600, 800],
        [300, 800],
        [300, 700],
        [100, 700],
        [100, 900],
    ]
]
_glyph[51] = [
    [
        [600, 1000],
        [800, 800],
        [800, 600],
        [700, 500],
        [800, 400],
        [800, 200],
        [600, 0],
        [300, 0],
        [100, 200],
        [100, 300],
        [300, 300],
        [400, 200],
        [500, 200],
        [600, 300],
        [500, 400],
        [500, 600],
        [600, 700],
        [500, 800],
        [400, 800],
        [300, 700],
        [100, 700],
        [100, 800],
        [300, 1000],
        [600, 1000],
    ]
]
_glyph[52] = [
    [
        [800, 500],
        [800, 300],
        [700, 300],
        [700, 0],
        [500, 0],
        [500, 300],
        [100, 300],
        [100, 1000],
        [300, 1000],
        [300, 500],
        [500, 500],
        [500, 1000],
        [700, 1000],
        [700, 500],
        [800, 500],
    ]
]
_glyph[53] = [
    [
        [800, 800],
        [300, 800],
        [300, 600],
        [700, 600],
        [800, 500],
        [800, 100],
        [700, 0],
        [200, 0],
        [100, 100],
        [100, 300],
        [300, 300],
        [300, 200],
        [600, 200],
        [600, 400],
        [200, 400],
        [100, 500],
        [100, 1000],
        [800, 1000],
        [800, 800],
    ]
]
_glyph[54] = [
    [
        [800, 700],
        [600, 700],
        [600, 800],
        [300, 800],
        [300, 600],
        [700, 600],
        [800, 500],
        [800, 100],
        [700, 0],
        [500, 0],
        [500, 200],
        [600, 200],
        [600, 400],
        [300, 400],
        [300, 200],
        [400, 200],
        [400, 0],
        [200, 0],
        [100, 100],
        [100, 900],
        [200, 1000],
        [700, 1000],
        [800, 900],
        [800, 700],
    ]
]
_glyph[55] = [
    [
        [560, 800],
        [100, 800],
        [100, 1000],
        [800, 1000],
        [600, 0],
        [400, 0],
        [480, 400],
        [520, 600],
        [560, 800],
    ]
]
_glyph[56] = [
    [
        [400, 800],
        [300, 800],
        [300, 600],
        [600, 600],
        [600, 800],
        [500, 800],
        [500, 1000],
        [700, 1000],
        [800, 900],
        [800, 600],
        [700, 500],
        [800, 400],
        [800, 100],
        [700, 0],
        [500, 0],
        [500, 200],
        [600, 200],
        [600, 400],
        [300, 400],
        [300, 200],
        [400, 200],
        [400, 0],
        [200, 0],
        [100, 100],
        [100, 400],
        [200, 500],
        [100, 600],
        [100, 900],
        [200, 1000],
        [400, 1000],
        [400, 800],
    ]
]
# 9
_glyph[57] = [
    [
        [100, 300],
        [300, 300],
        [300, 200],
        [600, 200],
        [600, 400],
        [200, 400],
        [100, 500],
        [100, 900],
        [200, 1000],
        [400, 1000],
        [400, 800],
        [300, 800],
        [300, 600],
        [600, 600],
        [600, 800],
        [500, 800],
        [500, 1000],
        [700, 1000],
        [800, 900],
        [800, 100],
        [700, 0],
        [200, 0],
        [100, 100],
        [100, 300],
    ]
]
_glyph[58] = [
    [[300, 200], [300, 0], [100, 0], [100, 200], [300, 200]],
    [[300, 600], [300, 400], [100, 400], [100, 600], [300, 600]],
]
_glyph[59] = [
    [[300, 200], [300, 0], [100, -200], [100, 200], [300, 200]],
    [[300, 600], [300, 400], [100, 400], [100, 600], [300, 600]],
]
_glyph[60] = [
    [[700, 900], [700, 700], [400, 500], [700, 300], [700, 100], [100, 500], [700, 900]]
]
_glyph[61] = [
    [[100, 400], [900, 400], [900, 200], [100, 200], [100, 400]],
    [[100, 800], [900, 800], [900, 600], [100, 600], [100, 800]],
]
_glyph[62] = [
    [[700, 500], [100, 100], [100, 300], [400, 500], [100, 700], [100, 900], [700, 500]]
]
_glyph[63] = [
    [
        [100, 1000],
        [200, 1100],
        [800, 1100],
        [900, 1000],
        [900, 500],
        [800, 400],
        [600, 400],
        [600, 200],
        [400, 200],
        [400, 500],
        [500, 600],
        [700, 600],
        [700, 900],
        [300, 900],
        [300, 800],
        [100, 800],
        [100, 1000],
    ],
    [[600, 50], [600, -150], [400, -150], [400, 50], [600, 50]],
]
_glyph[64] = [
    [
        [900, 200],
        [900, 100],
        [800, 0],
        [300, 0],
        [100, 200],
        [100, 800],
        [300, 1000],
        [700, 1000],
        [900, 800],
        [900, 500],
        [800, 400],
        [450, 400],
        [400, 450],
        [400, 600],
        [450, 700],
        [600, 700],
        [550, 600],
        [550, 500],
        [700, 500],
        [700, 700],
        [600, 800],
        [400, 800],
        [300, 700],
        [300, 300],
        [400, 200],
        [900, 200],
    ]
]
# A
_glyph[65] = [
    [
        [100, 800],
        [300, 1000],
        [601, 1000],
        [800, 800],
        [800, 0],
        [601, 0],
        [601, 200],
        [500, 200],
        [500, 400],
        [601, 400],
        [601, 700],
        [500, 800],
        [400, 800],
        [300, 700],
        [300, 400],
        [400, 400],
        [400, 200],
        [300, 200],
        [300, 0],
        [99, 0],
        [100, 800],
    ]
]
_glyph[66] = [
    [
        [600, 1000],
        [800, 800],
        [800, 600],
        [700, 500],
        [800, 400],
        [800, 200],
        [600, 0],
        [100, 0],
        [100, 400],
        [300, 400],
        [300, 200],
        [500, 200],
        [600, 300],
        [500, 400],
        [420, 400],
        [420, 600],
        [500, 600],
        [600, 700],
        [500, 800],
        [300, 800],
        [300, 600],
        [100, 600],
        [100, 1000],
        [600, 1000],
    ]
]
_glyph[67] = [
    [
        [300, 0],
        [100, 200],
        [100, 800],
        [300, 1000],
        [600, 1000],
        [800, 800],
        [800, 600],
        [600, 600],
        [600, 700],
        [500, 800],
        [400, 800],
        [300, 700],
        [300, 300],
        [400, 200],
        [500, 200],
        [600, 300],
        [600, 400],
        [800, 400],
        [800, 200],
        [600, 0],
        [300, 0],
    ]
]
_glyph[68] = [
    [
        [100, 0],
        [100, 400],
        [300, 400],
        [300, 200],
        [500, 200],
        [600, 300],
        [600, 700],
        [500, 800],
        [300, 800],
        [300, 600],
        [100, 600],
        [100, 1000],
        [600, 1000],
        [800, 800],
        [800, 200],
        [600, 0],
        [100, 0],
    ]
]
_glyph[69] = [
    [
        [700, 1000],
        [700, 800],
        [300, 800],
        [300, 600],
        [500, 600],
        [500, 400],
        [300, 400],
        [300, 200],
        [700, 200],
        [700, 0],
        [100, 0],
        [100, 1000],
        [700, 1000],
    ]
]
_glyph[70] = [
    [
        [100, 0],
        [100, 1000],
        [700, 1000],
        [700, 800],
        [300, 800],
        [300, 600],
        [500, 600],
        [500, 400],
        [300, 400],
        [300, 0],
        [100, 0],
    ]
]
_glyph[71] = [
    [
        [300, 0],
        [100, 200],
        [100, 800],
        [300, 1000],
        [600, 1000],
        [800, 800],
        [800, 700],
        [600, 700],
        [500, 800],
        [400, 800],
        [300, 700],
        [300, 300],
        [400, 200],
        [600, 200],
        [600, 300],
        [500, 300],
        [500, 500],
        [800, 500],
        [800, 100],
        [700, 0],
        [300, 0],
    ]
]
_glyph[72] = [
    [
        [100, 1000],
        [300, 1000],
        [300, 600],
        [600, 600],
        [600, 1000],
        [800, 1000],
        [800, 0],
        [600, 0],
        [600, 400],
        [300, 400],
        [300, 0],
        [100, 0],
        [100, 1000],
    ]
]
_glyph[73] = [
    [
        [100, 0],
        [100, 200],
        [300, 200],
        [300, 800],
        [100, 800],
        [100, 1000],
        [700, 1000],
        [700, 800],
        [500, 800],
        [500, 200],
        [700, 200],
        [700, 0],
        [100, 0],
    ]
]
_glyph[74] = [
    [
        [300, 200],
        [500, 200],
        [500, 1000],
        [700, 1000],
        [700, 100],
        [600, 0],
        [200, 0],
        [100, 100],
        [100, 300],
        [300, 300],
        [300, 200],
    ]
]
_glyph[75] = [
    [
        [100, 1000],
        [300, 1000],
        [300, 600],
        [600, 1000],
        [800, 1000],
        [800, 900],
        [500, 500],
        [800, 100],
        [800, 0],
        [600, 0],
        [300, 400],
        [300, 0],
        [100, 0],
        [100, 1000],
    ]
]
_glyph[76] = [
    [[100, 1000], [300, 1000], [300, 200], [800, 200], [800, 0], [100, 0], [100, 1000]]
]
_glyph[77] = [
    [
        [100, 1000],
        [300, 1000],
        [500, 700],
        [700, 1000],
        [900, 1000],
        [900, 0],
        [700, 0],
        [700, 600],
        [500, 300],
        [300, 600],
        [300, 0],
        [100, 0],
        [100, 1000],
    ]
]
_glyph[78] = [
    [
        [100, 1000],
        [300, 1000],
        [700, 400],
        [700, 1000],
        [900, 1000],
        [900, 0],
        [700, 0],
        [300, 600],
        [300, 0],
        [100, 0],
        [100, 1000],
    ]
]
_glyph[79] = [
    [
        [100, 800],
        [300, 1000],
        [430, 1000],
        [430, 800],
        [400, 800],
        [300, 700],
        [300, 300],
        [400, 200],
        [600, 200],
        [700, 300],
        [700, 700],
        [600, 800],
        [570, 800],
        [570, 1000],
        [700, 1000],
        [900, 800],
        [900, 200],
        [700, 0],
        [300, 0],
        [100, 200],
        [100, 800],
    ]
]
_glyph[80] = [
    [
        [100, 1000],
        [700, 1000],
        [900, 800],
        [900, 600],
        [700, 400],
        [500, 400],
        [500, 600],
        [600, 600],
        [700, 700],
        [600, 800],
        [300, 800],
        [300, 0],
        [100, 0],
        [100, 1000],
    ]
]
_glyph[81] = [
    [
        [100, 800],
        [300, 1000],
        [700, 1000],
        [900, 800],
        [900, 200],
        [800, 100],
        [900, 0],
        [600, 0],
        [600, 400],
        [700, 400],
        [700, 700],
        [600, 800],
        [400, 800],
        [300, 700],
        [300, 300],
        [400, 200],
        [400, 0],
        [300, 0],
        [100, 200],
        [100, 800],
    ]
]
_glyph[82] = [
    [
        [100, 1000],
        [700, 1000],
        [900, 800],
        [900, 600],
        [700, 400],
        [900, 200],
        [900, 0],
        [700, 0],
        [700, 100],
        [500, 300],
        [500, 600],
        [600, 600],
        [700, 700],
        [600, 800],
        [300, 800],
        [300, 0],
        [100, 0],
        [100, 1000],
    ]
]
_glyph[83] = [
    [
        [900, 800],
        [300, 800],
        [300, 600],
        [800, 600],
        [900, 500],
        [900, 100],
        [800, 0],
        [200, 0],
        [100, 100],
        [100, 200],
        [700, 200],
        [700, 400],
        [200, 400],
        [100, 500],
        [100, 900],
        [200, 1000],
        [800, 1000],
        [900, 900],
        [900, 800],
    ]
]
_glyph[84] = [
    [
        [900, 1000],
        [900, 800],
        [600, 800],
        [600, 0],
        [400, 0],
        [400, 800],
        [100, 800],
        [100, 1000],
        [900, 1000],
    ]
]
_glyph[85] = [
    [
        [300, 1000],
        [300, 300],
        [400, 200],
        [500, 200],
        [600, 300],
        [600, 1000],
        [800, 1000],
        [800, 200],
        [600, 0],
        [300, 0],
        [100, 200],
        [100, 1000],
        [300, 1000],
    ]
]
_glyph[86] = [
    [
        [300, 1000],
        [500, 400],
        [700, 1000],
        [900, 1000],
        [600, 0],
        [400, 0],
        [100, 1000],
        [300, 1000],
    ]
]
_glyph[87] = [
    [
        [100, 1000],
        [300, 1000],
        [300, 400],
        [500, 700],
        [700, 400],
        [700, 1000],
        [900, 1000],
        [900, 0],
        [700, 0],
        [500, 300],
        [300, 0],
        [100, 0],
        [100, 1000],
    ]
]
_glyph[88] = [
    [
        [367, 500],
        [100, 900],
        [100, 1000],
        [300, 1000],
        [500, 700],
        [700, 1000],
        [900, 1000],
        [900, 900],
        [633, 500],
        [900, 100],
        [900, 0],
        [700, 0],
        [500, 300],
        [300, 0],
        [100, 0],
        [100, 100],
        [367, 500],
    ]
]
_glyph[89] = [
    [
        [600, 450],
        [600, 0],
        [400, 0],
        [400, 450],
        [100, 900],
        [100, 1000],
        [300, 1000],
        [500, 700],
        [700, 1000],
        [900, 1000],
        [900, 900],
        [600, 450],
    ]
]
# Z
_glyph[90] = [
    [
        [100, 1000],
        [900, 1000],
        [900, 700],
        [300, 200],
        [900, 200],
        [900, 0],
        [100, 0],
        [100, 300],
        [700, 800],
        [100, 800],
        [100, 1000],
    ]
]
_glyph[91] = [
    [
        [400, 1200],
        [400, 1000],
        [300, 1000],
        [300, 0],
        [400, 0],
        [400, -200],
        [100, -200],
        [100, 1200],
        [400, 1200],
    ]
]
_glyph[92] = [[[300, 1200], [500, -200], [300, -200], [100, 1200], [300, 1200]]]
_glyph[93] = [
    [
        [400, 1200],
        [400, -200],
        [100, -200],
        [100, 0],
        [200, 0],
        [200, 1000],
        [100, 1000],
        [100, 1200],
        [400, 1200],
    ]
]
_glyph[94] = [
    [[0, 500], [400, 900], [800, 500], [600, 500], [400, 700], [200, 500], [0, 500]]
]
_glyph[95] = [[[100, 200], [900, 200], [900, 0], [100, 0], [100, 200]]]
_glyph[96] = [[[300, 1000], [300, 1200], [500, 1200], [500, 800], [300, 1000]]]
# a
_glyph[97] = [
    [
        [800, 0],
        [300, 0],
        [100, 200],
        [100, 500],
        [334, 700],
        [600, 700],
        [600, 775],
        [800, 775],
        [800, 400],
        [600, 400],
        [600, 500],
        [400, 500],
        [300, 400],
        [300, 300],
        [400, 200],
        [600, 200],
        [600, 300],
        [800, 300],
        [800, 0],
    ]
]
_glyph[98] = [
    [
        [100, 300],
        [300, 300],
        [300, 200],
        [500, 200],
        [600, 300],
        [600, 400],
        [500, 500],
        [300, 500],
        [300, 400],
        [100, 400],
        [100, 1000],
        [300, 1000],
        [300, 700],
        [600, 700],
        [800, 500],
        [800, 200],
        [600, 0],
        [100, 0],
        [100, 300],
    ]
]
_glyph[99] = [
    [
        [800, 200],
        [600, 0],
        [300, 0],
        [100, 200],
        [100, 500],
        [300, 700],
        [600, 700],
        [800, 500],
        [800, 400],
        [600, 400],
        [500, 500],
        [400, 500],
        [300, 400],
        [300, 300],
        [400, 200],
        [500, 200],
        [600, 300],
        [800, 300],
        [800, 200],
    ]
]
_glyph[100] = [
    [
        [800, 0],
        [300, 0],
        [100, 200],
        [100, 500],
        [300, 700],
        [600, 700],
        [600, 1000],
        [800, 1000],
        [800, 400],
        [600, 400],
        [600, 500],
        [400, 500],
        [300, 400],
        [300, 300],
        [400, 200],
        [600, 200],
        [600, 300],
        [800, 300],
        [800, 0],
    ]
]
_glyph[101] = [
    [
        [200, 0],
        [100, 100],
        [100, 700],
        [200, 800],
        [700, 800],
        [800, 700],
        [800, 400],
        [700, 300],
        [440, 300],
        [440, 500],
        [600, 500],
        [600, 600],
        [300, 600],
        [300, 200],
        [800, 200],
        [800, 100],
        [700, 0],
        [200, 0],
    ]
]
_glyph[102] = [
    [
        [600, 800],
        [300, 800],
        [300, 600],
        [500, 600],
        [500, 400],
        [300, 400],
        [300, 0],
        [100, 0],
        [100, 900],
        [200, 1000],
        [600, 1000],
        [600, 800],
    ]
]
_glyph[103] = [
    [
        [800, 400],
        [600, 400],
        [600, 500],
        [400, 500],
        [300, 400],
        [300, 300],
        [400, 200],
        [600, 200],
        [600, 300],
        [800, 300],
        [800, -200],
        [700, -300],
        [300, -300],
        [200, -200],
        [100, -100],
        [600, -100],
        [600, 0],
        [334, 0],
        [100, 200],
        [100, 500],
        [300, 700],
        [800, 700],
        [800, 400],
    ]
]
_glyph[104] = [
    [
        [600, 0],
        [600, 400],
        [500, 500],
        [400, 500],
        [300, 400],
        [300, 0],
        [100, 0],
        [100, 1100],
        [300, 1100],
        [300, 600],
        [400, 700],
        [600, 700],
        [800, 500],
        [800, 0],
        [600, 0],
    ]
]
_glyph[105] = [
    [[100, 0], [100, 600], [300, 600], [300, 0], [100, 0]],
    [[300, 1000], [300, 800], [100, 800], [100, 1000], [300, 1000]],
]
_glyph[106] = [
    [
        [100, -100],
        [100, 0],
        [300, 0],
        [300, 600],
        [500, 600],
        [500, -100],
        [400, -200],
        [200, -200],
        [100, -100],
    ],
    [[500, 1000], [500, 800], [300, 800], [300, 1000], [500, 1000]],
]
_glyph[107] = [
    [
        [300, 500],
        [600, 700],
        [800, 700],
        [800, 600],
        [500, 400],
        [800, 100],
        [800, 0],
        [600, 0],
        [300, 300],
        [300, 0],
        [100, 0],
        [100, 1100],
        [300, 1100],
        [300, 500],
    ]
]
_glyph[108] = [
    [
        [500, 0],
        [200, 0],
        [100, 100],
        [100, 1000],
        [300, 1000],
        [300, 200],
        [500, 200],
        [500, 0],
    ]
]
_glyph[109] = [
    [
        [500, 400],
        [400, 500],
        [300, 400],
        [300, 0],
        [100, 0],
        [100, 700],
        [300, 700],
        [300, 600],
        [400, 700],
        [500, 700],
        [600, 600],
        [700, 700],
        [900, 700],
        [1100, 500],
        [1100, 0],
        [900, 0],
        [900, 400],
        [800, 500],
        [700, 400],
        [700, 0],
        [500, 0],
        [500, 400],
    ]
]
_glyph[110] = [
    [
        [600, 0],
        [600, 400],
        [500, 500],
        [400, 500],
        [300, 400],
        [300, 0],
        [100, 0],
        [100, 700],
        [300, 700],
        [300, 600],
        [400, 700],
        [600, 700],
        [800, 500],
        [800, 0],
        [600, 0],
    ]
]
_glyph[111] = [
    [
        [600, 700],
        [800, 500],
        [800, 200],
        [600, 0],
        [300, 0],
        [100, 200],
        [100, 500],
        [300, 700],
        [400, 700],
        [400, 500],
        [300, 400],
        [300, 300],
        [400, 200],
        [500, 200],
        [600, 300],
        [600, 400],
        [500, 500],
        [500, 700],
        [600, 700],
    ]
]
_glyph[112] = [
    [
        [100, 700],
        [600, 700],
        [800, 500],
        [800, 200],
        [600, 0],
        [300, 0],
        [300, -300],
        [100, -300],
        [100, 300],
        [300, 300],
        [300, 200],
        [500, 200],
        [600, 300],
        [600, 400],
        [500, 500],
        [300, 500],
        [300, 400],
        [100, 400],
        [100, 700],
    ]
]
_glyph[113] = [
    [
        [800, 400],
        [600, 400],
        [600, 500],
        [400, 500],
        [300, 400],
        [300, 300],
        [400, 200],
        [600, 200],
        [600, 300],
        [800, 300],
        [800, -300],
        [600, -300],
        [600, 0],
        [300, 0],
        [100, 200],
        [100, 500],
        [300, 700],
        [800, 700],
        [800, 400],
    ]
]
_glyph[114] = [
    [
        [600, 400],
        [600, 500],
        [400, 500],
        [300, 400],
        [300, 0],
        [100, 0],
        [100, 700],
        [300, 700],
        [300, 600],
        [400, 700],
        [700, 700],
        [800, 600],
        [800, 400],
        [600, 400],
    ]
]
_glyph[115] = [
    [
        [200, 0],
        [100, 100],
        [100, 200],
        [600, 200],
        [600, 300],
        [200, 300],
        [100, 400],
        [100, 700],
        [200, 800],
        [700, 800],
        [800, 700],
        [800, 600],
        [300, 600],
        [300, 500],
        [700, 500],
        [800, 400],
        [800, 100],
        [700, 0],
        [200, 0],
    ]
]
_glyph[116] = [
    [
        [600, 0],
        [400, 0],
        [300, 100],
        [300, 600],
        [100, 600],
        [100, 800],
        [300, 800],
        [300, 1000],
        [500, 1000],
        [500, 800],
        [700, 800],
        [700, 600],
        [500, 600],
        [500, 200],
        [600, 200],
        [600, 0],
    ]
]
_glyph[117] = [
    [
        [300, 700],
        [300, 300],
        [400, 200],
        [500, 200],
        [600, 300],
        [600, 700],
        [800, 700],
        [800, 0],
        [600, 0],
        [600, 100],
        [500, 0],
        [300, 0],
        [100, 200],
        [100, 700],
        [300, 700],
    ]
]
_glyph[118] = [
    [
        [300, 0],
        [100, 700],
        [300, 700],
        [400, 350],
        [500, 700],
        [700, 700],
        [500, 0],
        [300, 0],
    ]
]
_glyph[119] = [
    [
        [600, 350],
        [500, 0],
        [300, 0],
        [100, 700],
        [300, 700],
        [400, 350],
        [500, 700],
        [700, 700],
        [800, 350],
        [900, 700],
        [1100, 700],
        [900, 0],
        [700, 0],
        [600, 350],
    ]
]
_glyph[120] = [
    [
        [308, 350],
        [100, 600],
        [100, 700],
        [300, 700],
        [450, 520],
        [600, 700],
        [800, 700],
        [800, 600],
        [592, 350],
        [800, 100],
        [800, 0],
        [600, 0],
        [450, 180],
        [300, 0],
        [100, 0],
        [100, 100],
        [308, 350],
    ]
]
_glyph[121] = [
    [
        [214, -300],
        [300, 0],
        [100, 700],
        [300, 700],
        [400, 350],
        [500, 700],
        [700, 700],
        [500, 0],
        [414, -300],
        [214, -300],
    ]
]
# z
_glyph[122] = [
    [
        [100, 500],
        [100, 700],
        [700, 700],
        [700, 500],
        [400, 200],
        [700, 200],
        [700, 0],
        [100, 0],
        [100, 200],
        [400, 500],
        [100, 500],
    ]
]
_glyph[123] = [
    [
        [100, 500],
        [200, 600],
        [200, 1000],
        [400, 1200],
        [500, 1200],
        [500, 1000],
        [400, 1000],
        [400, 600],
        [300, 500],
        [400, 400],
        [400, 0],
        [500, 0],
        [500, -200],
        [400, -200],
        [200, 0],
        [200, 400],
        [100, 500],
    ]
]
_glyph[124] = [[[100, -100], [100, 1100], [300, 1100], [300, -100], [100, -100]]]
_glyph[125] = [
    [
        [500, 500],
        [400, 600],
        [400, 1000],
        [200, 1200],
        [100, 1200],
        [100, 1000],
        [200, 1000],
        [200, 600],
        [300, 500],
        [200, 400],
        [200, 0],
        [100, 0],
        [100, -200],
        [200, -200],
        [400, 0],
        [400, 400],
        [500, 500],
    ]
]
_glyph[126] = [
    [
        [100, 700],
        [250, 800],
        [350, 800],
        [650, 600],
        [750, 600],
        [900, 700],
        [900, 500],
        [750, 400],
        [650, 400],
        [350, 600],
        [250, 600],
        [100, 500],
        [100, 700],
    ]
]
_glyph[181] = [
    [
        [300, 700],
        [300, 300],
        [400, 200],
        [500, 200],
        [600, 300],
        [600, 700],
        [800, 700],
        [800, 0],
        [600, 0],
        [600, 100],
        [500, 0],
        [400, 0],
        [300, 100],
        [300, -300],
        [100, -300],
        [100, 700],
        [300, 700],
    ]
]


# _glyph _widths and _indents
_width[33] = 400
_indent[33] = 100  # !
_width[34] = 500
_indent[34] = 200  # "
_width[35] = 800
_indent[35] = 100  # #
_width[36] = 800
_indent[36] = 100  # $
_width[37] = 800
_indent[37] = 100  # #
_width[38] = 900
_indent[38] = 000  # &
_width[39] = 200
_indent[39] = 300  # '
_width[40] = 450
_indent[40] = 100  # (
_width[41] = 450
_indent[41] = 100  # )
_width[42] = 600
_indent[42] = 200  # *
_width[43] = 800
_indent[43] = 100
_width[44] = 200
_indent[44] = 100
_width[45] = 800
_indent[45] = 100
_width[46] = 200
_indent[46] = 100
_width[47] = 400
_indent[47] = 100
_width[48] = 800
_indent[48] = 100
_width[49] = 400
_indent[49] = 100
_width[50] = 700
_indent[50] = 100
_width[51] = 700
_indent[51] = 100
_width[52] = 700
_indent[52] = 100
_width[53] = 700
_indent[53] = 100
_width[54] = 700
_indent[54] = 100
_width[55] = 700
_indent[55] = 100
_width[56] = 700
_indent[56] = 100
_width[57] = 700
_indent[57] = 100
_width[58] = 200
_indent[58] = 100
_width[59] = 200
_indent[59] = 100
_width[60] = 600
_indent[60] = 100
_width[61] = 800
_indent[61] = 100
_width[62] = 600
_indent[62] = 100
_width[63] = 800
_indent[63] = 100
_width[64] = 800
_indent[64] = 100
_width[65] = 700
_indent[65] = 100
_width[66] = 700
_indent[66] = 100
_width[67] = 700
_indent[67] = 100
_width[68] = 700
_indent[68] = 100
_width[69] = 600
_indent[69] = 100
_width[70] = 600
_indent[70] = 100
_width[71] = 700
_indent[71] = 100
_width[72] = 700
_indent[72] = 100
_width[73] = 600
_indent[73] = 100
_width[74] = 600
_indent[74] = 100
_width[75] = 700
_indent[75] = 100
_width[76] = 700
_indent[76] = 100
_width[77] = 800
_indent[77] = 100
_width[78] = 800
_indent[78] = 100
_width[79] = 800
_indent[79] = 100
_width[80] = 800
_indent[80] = 100
_width[81] = 800
_indent[81] = 100
_width[82] = 800
_indent[82] = 100
_width[83] = 800
_indent[83] = 100
_width[84] = 800
_indent[84] = 100
_width[85] = 700
_indent[85] = 100
_width[86] = 800
_indent[86] = 100
_width[87] = 800
_indent[87] = 100
_width[88] = 800
_indent[88] = 100
_width[89] = 800
_indent[89] = 100
_width[90] = 800
_indent[90] = 100
_width[91] = 300
_indent[91] = 100
_width[92] = 400
_indent[92] = 100
_width[93] = 300
_indent[93] = 100
_width[94] = 800
_indent[94] = 000
_width[95] = 800
_indent[95] = 100
_width[96] = 200
_indent[96] = 300
_width[97] = 700
_indent[97] = 100
_width[98] = 700
_indent[98] = 100
_width[99] = 700
_indent[99] = 100
_width[100] = 700
_indent[100] = 100
_width[101] = 700
_indent[101] = 100
_width[102] = 500
_indent[102] = 100
_width[103] = 700
_indent[103] = 100
_width[104] = 700
_indent[104] = 100
_width[105] = 200
_indent[105] = 100
_width[106] = 400
_indent[106] = 100
_width[107] = 700
_indent[107] = 100
_width[108] = 400
_indent[108] = 100
_width[109] = 1000
_indent[109] = 100
_width[110] = 700
_indent[110] = 100
_width[111] = 700
_indent[111] = 100
_width[112] = 700
_indent[112] = 100
_width[113] = 700
_indent[113] = 100
_width[114] = 700
_indent[114] = 100
_width[115] = 700
_indent[115] = 100
_width[116] = 600
_indent[116] = 100
_width[117] = 700
_indent[117] = 100
_width[118] = 600
_indent[118] = 100
_width[119] = 1000
_indent[119] = 100
_width[120] = 700
_indent[120] = 100
_width[121] = 600
_indent[121] = 100
_width[122] = 600
_indent[122] = 100
_width[123] = 500
_indent[123] = 100  # {
_width[124] = 400
_indent[124] = 100  # |
_width[125] = 500
_indent[125] = 100  # }
_width[126] = 800
_indent[126] = 100  # ~
_width[181] = 700
_indent[181] = 100  # Greek mu


_CSS3_NAMES_TO_HEX = {
    "aliceblue": "#f0f8ff",
    "antiquewhite": "#faebd7",
    "aqua": "#00ffff",
    "aquamarine": "#7fffd4",
    "azure": "#f0ffff",
    "beige": "#f5f5dc",
    "bisque": "#ffe4c4",
    "black": "#000000",
    "blanchedalmond": "#ffebcd",
    "blue": "#0000ff",
    "blueviolet": "#8a2be2",
    "brown": "#a52a2a",
    "burlywood": "#deb887",
    "cadetblue": "#5f9ea0",
    "chartreuse": "#7fff00",
    "chocolate": "#d2691e",
    "coral": "#ff7f50",
    "cornflowerblue": "#6495ed",
    "cornsilk": "#fff8dc",
    "crimson": "#dc143c",
    "cyan": "#00ffff",
    "darkblue": "#00008b",
    "darkcyan": "#008b8b",
    "darkgoldenrod": "#b8860b",
    "darkgray": "#a9a9a9",
    "darkgrey": "#a9a9a9",
    "darkgreen": "#006400",
    "darkkhaki": "#bdb76b",
    "darkmagenta": "#8b008b",
    "darkolivegreen": "#556b2f",
    "darkorange": "#ff8c00",
    "darkorchid": "#9932cc",
    "darkred": "#8b0000",
    "darksalmon": "#e9967a",
    "darkseagreen": "#8fbc8f",
    "darkslateblue": "#483d8b",
    "darkslategray": "#2f4f4f",
    "darkslategrey": "#2f4f4f",
    "darkturquoise": "#00ced1",
    "darkviolet": "#9400d3",
    "deeppink": "#ff1493",
    "deepskyblue": "#00bfff",
    "dimgray": "#696969",
    "dimgrey": "#696969",
    "dodgerblue": "#1e90ff",
    "firebrick": "#b22222",
    "floralwhite": "#fffaf0",
    "forestgreen": "#228b22",
    "fuchsia": "#ff00ff",
    "gainsboro": "#dcdcdc",
    "ghostwhite": "#f8f8ff",
    "gold": "#ffd700",
    "goldenrod": "#daa520",
    "gray": "#808080",
    "grey": "#808080",
    "green": "#008000",
    "greenyellow": "#adff2f",
    "honeydew": "#f0fff0",
    "hotpink": "#ff69b4",
    "indianred": "#cd5c5c",
    "indigo": "#4b0082",
    "ivory": "#fffff0",
    "khaki": "#f0e68c",
    "lavender": "#e6e6fa",
    "lavenderblush": "#fff0f5",
    "lawngreen": "#7cfc00",
    "lemonchiffon": "#fffacd",
    "lightblue": "#add8e6",
    "lightcoral": "#f08080",
    "lightcyan": "#e0ffff",
    "lightgoldenrodyellow": "#fafad2",
    "lightgray": "#d3d3d3",
    "lightgrey": "#d3d3d3",
    "lightgreen": "#90ee90",
    "lightpink": "#ffb6c1",
    "lightsalmon": "#ffa07a",
    "lightseagreen": "#20b2aa",
    "lightskyblue": "#87cefa",
    "lightslategray": "#778899",
    "lightslategrey": "#778899",
    "lightsteelblue": "#b0c4de",
    "lightyellow": "#ffffe0",
    "lime": "#00ff00",
    "limegreen": "#32cd32",
    "linen": "#faf0e6",
    "magenta": "#ff00ff",
    "maroon": "#800000",
    "mediumaquamarine": "#66cdaa",
    "mediumblue": "#0000cd",
    "mediumorchid": "#ba55d3",
    "mediumpurple": "#9370db",
    "mediumseagreen": "#3cb371",
    "mediumslateblue": "#7b68ee",
    "mediumspringgreen": "#00fa9a",
    "mediumturquoise": "#48d1cc",
    "mediumvioletred": "#c71585",
    "midnightblue": "#191970",
    "mintcream": "#f5fffa",
    "mistyrose": "#ffe4e1",
    "moccasin": "#ffe4b5",
    "navajowhite": "#ffdead",
    "navy": "#000080",
    "oldlace": "#fdf5e6",
    "olive": "#808000",
    "olivedrab": "#6b8e23",
    "orange": "#ffa500",
    "orangered": "#ff4500",
    "orchid": "#da70d6",
    "palegoldenrod": "#eee8aa",
    "palegreen": "#98fb98",
    "paleturquoise": "#afeeee",
    "palevioletred": "#db7093",
    "papayawhip": "#ffefd5",
    "peachpuff": "#ffdab9",
    "peru": "#cd853f",
    "pink": "#ffc0cb",
    "plum": "#dda0dd",
    "powderblue": "#b0e0e6",
    "purple": "#800080",
    "red": "#ff0000",
    "rosybrown": "#bc8f8f",
    "royalblue": "#4169e1",
    "saddlebrown": "#8b4513",
    "salmon": "#fa8072",
    "sandybrown": "#f4a460",
    "seagreen": "#2e8b57",
    "seashell": "#fff5ee",
    "sienna": "#a0522d",
    "silver": "#c0c0c0",
    "skyblue": "#87ceeb",
    "slateblue": "#6a5acd",
    "slategray": "#708090",
    "slategrey": "#708090",
    "snow": "#fffafa",
    "springgreen": "#00ff7f",
    "steelblue": "#4682b4",
    "tan": "#d2b48c",
    "teal": "#008080",
    "thistle": "#d8bfd8",
    "tomato": "#ff6347",
    "turquoise": "#40e0d0",
    "violet": "#ee82ee",
    "wheat": "#f5deb3",
    "white": "#ffffff",
    "whitesmoke": "#f5f5f5",
    "yellow": "#ffff00",
    "yellowgreen": "#9acd32",
}
