# Contributing to samplics

Thank you so much for considering supporting this project. We love to get your contribution on

- Reporting a bug

- Submitting a fix

- Proposing new features

This document provides a set of guidelines for contributing to the samplics. These are not meant to be very strict rules and we hope that you will use your best judgment while proposing changes. Please fill free to propose improvements to the contributing set of guidelines.

## Code of conduct

We encourage everyone to be friendly, patient, considerate and respectful of others. Please be mindful of the choice of words in the discussions by always discussing disagreements in a professional and respectful manner.

## How can I contribute?

1. Reporting a bug

- Ensure that the bug was not already reported by searching the [issues](https://github.com/issues)

- If you are unable to find an open issue, please open a new one. Make sure to provide a title, a clear explanantion of the issue, and a code sample illustrating the bug. It must be reproducible.

2. Submitting a fix

- Open a new GitHub pull request

- Ensure that the PR describes clearly the problem and the solution. Include relevant issue number if applicable

- Before submitting, please read the [contributing to samplics](https://github.com/samplics-org/samplics/blob/main/CONTRIBUTING.md)

3. Proposing a new features

- Open an issues and label the feature "proposed feature"

- Make sure that the feature does not exist or is not under development

- Describe the proposed features in a clear way and provide the following
  - why do we need the proposed feature
  - How does it fit with the existing package
  - Enough technical details to understand the use cases
  - Technical references describing the proposed features, if applicable
