class QasePytestOptions:

    @staticmethod
    def addoptions(parser, group):
        QasePytestOptions.add_option(
            parser,
            group,
            "--qase-mode",
            dest="qase_mode",
            help="Define Qase reporter mode: `off`, `report` or `testops`"
        )

        QasePytestOptions.add_option(
            parser,
            group,
            "--qase-fallback",
            dest="qase_fallback",
            help="Define Qase reporter fallback mode: `off`, `report` or `testops`"
        )

        QasePytestOptions.add_option(
            parser,
            group,
            "--qase-environment",
            dest="qase_environment",
            help="Define environment slug from TestOps"
        )

        QasePytestOptions.add_option(
            parser,
            group,
            "--qase-debug",
            dest="qase_debug",
            type="bool",
            help="Enable debug mode"
        )

        QasePytestOptions.add_option(
            parser,
            group,
            "--qase-exclude-params",
            dest="qase_exclude_params",
            help="Exclude params from test results"
        )

        QasePytestOptions.add_option(
            parser,
            group,
            "--qase-execution-plan-path",
            dest="qase_execution_plan_path",
            help="Path to file with execution plan"
        )

        QasePytestOptions.add_option(
            parser,
            group,
            "--qase-testops-project",
            dest="qase_testops_project",
            help="Project code in Qase TestOps"
        )

        QasePytestOptions.add_option(
            parser,
            group,
            "--qase-testops-api-token",
            dest="qase_testops_api_token",
            help="API token for Qase TestOps"
        )

        QasePytestOptions.add_option(
            parser,
            group,
            "--qase-testops-api-host",
            dest="qase_testops_api_host",
            help="API host for Qase TestOps"
        )

        QasePytestOptions.add_option(
            parser,
            group,
            "--qase-testops-plan-id",
            dest="qase_testops_plan_id",
            help="Test Plan ID in Qase TestOps"
        )

        QasePytestOptions.add_option(
            parser,
            group,
            "--qase-testops-run-id",
            dest="qase_testops_run_id",
            help="Test Run ID in Qase TestOps"
        )

        QasePytestOptions.add_option(
            parser,
            group,
            "--qase-testops-run-tags",
            dest="qase_testops_run_tags",
            help="Test Run tags in Qase TestOps"
        )

        QasePytestOptions.add_option(
            parser,
            group,
            "--qase-testops-run-title",
            "qase_testops_run_title",
            help="Define title for autocreated Test Run. If not set, will be used autogenerated title"
        )

        QasePytestOptions.add_option(
            parser,
            group,
            "--qase-testops-run-description",
            dest="qase_testops_run_description",
            help="Define description for autocreated Test Run"
        )

        QasePytestOptions.add_option(
            parser,
            group,
            "--qase-testops-run-complete",
            dest="qase_testops_run_complete",
            type="bool",
            help="Complete run after tests execution"
        )

        QasePytestOptions.add_option(
            parser,
            group,
            "--qase-testops-run-external-link-type",
            dest="qase_testops_run_external_link_type",
            help="External link type for test run: `jiraCloud` or `jiraServer`"
        )

        QasePytestOptions.add_option(
            parser,
            group,
            "--qase-testops-run-external-link-url",
            dest="qase_testops_run_external_link_url",
            help="External link URL or identifier for test run"
        )

        QasePytestOptions.add_option(
            parser,
            group,
            "--qase-testops-batch-size",
            dest="qase_testops_batch_size",
            type="int",
            help="Define batch size of results. Default: 200."
        )

        QasePytestOptions.add_option(
            parser,
            group,
            "--qase-testops-defect",
            dest="qase_testops_defect",
            type="bool",
            help="Create defect if test failed"
        )

        QasePytestOptions.add_option(
            parser,
            group,
            "--qase-testops-configurations-values",
            dest="qase_testops_configurations_values",
            help="Configurations for test run. Format: 'group1=value1,group2=value2'"
        )

        QasePytestOptions.add_option(
            parser,
            group,
            "--qase-testops-configurations-create-if-not-exists",
            dest="qase_testops_configurations_create_if_not_exists",
            type="bool",
            help="Create configurations if they don't exist. Default: false"
        )

        QasePytestOptions.add_option(
            parser,
            group,
            "--qase-testops-status-filter",
            dest="qase_testops_status_filter",
            help="Filter results by status. Format: 'passed,failed,skipped'"
        )

        QasePytestOptions.add_option(
            parser,
            group,
            "--qase-report-driver",
            dest="qase_report_driver",
            help="Define report driver: `local`. More options coming soon."
        )

        QasePytestOptions.add_option(
            parser,
            group,
            "--qase-root-suite",
            dest="qase_root_suite",
            help="Define root suite for tests"
        )

        QasePytestOptions.add_option(
            parser,
            group,
            "--qase-report-connection-local-path",
            dest="qase_report_connection_local_path",
            help="Define local path for report directory"
        )

        QasePytestOptions.add_option(
            parser,
            group,
            "--qase-report-connection-local-format",
            dest="qase_report_connection_local_format",
            help="Define local format for report directory: `json` or `jsonp`"
        )

        QasePytestOptions.add_option(
            parser,
            group,
            "--qase-profilers",
            dest="qase_profilers",
            help="Profilers to use for tests. Available: `network`, `db`, `sleep`"
        )

        QasePytestOptions.add_option(
            parser,
            group,
            "--qase-pytest-capture-logs",
            dest="qase_pytest_capture_logs",
            type="bool",
            help="Capture logs from pytest"
        )

        QasePytestOptions.add_option(
            parser,
            group,
            "--qase-pytest-xfail-status-xfail",
            dest="qase_pytest_xfail_status",
            help="Define xfail status for failed tests. Default: `skipped`"
        )

        QasePytestOptions.add_option(
            parser,
            group,
            "--qase-pytest-xfail-status-xpass",
            dest="qase_pytest_xpass_status",
            help="Define xpass status for passed tests. Default: `passed`"
        )

    @staticmethod
    def add_option(parser, group, option, dest, default=None, type=None, **kwargs):
        # We are going to add options that were not added before through the manager
        try:
            group.addoption(option, dest=dest, default=default, action="store", **kwargs)
        except ValueError:
            pass
