var BreakpointsCtrl, ContributorsCount, Ctrl, HeaderCtrl, TestimonialsCtrl,
  __hasProp = {}.hasOwnProperty,
  __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

Ctrl = (function() {
  function Ctrl(element, options) {
    this.element = element;
    this.options = options;
    this.options = $.extend({}, this.getClassVariable('defaults'), this.options);
    this.elements = {};
    this.gatherElements();
    this.bindEvents();
  }

  Ctrl.prototype.getClassVariable = function(prop) {
    return Object.getPrototypeOf(this).constructor[prop];
  };

  Ctrl.prototype.gatherElements = function() {};

  Ctrl.prototype.bindEvents = function() {};

  return Ctrl;

})();

HeaderCtrl = (function(_super) {
  __extends(HeaderCtrl, _super);

  function HeaderCtrl() {
    return HeaderCtrl.__super__.constructor.apply(this, arguments);
  }

  HeaderCtrl.prototype.gatherElements = function() {
    this.elements = {
      menu: this.element.find('nav'),
      main: this.element.find('.main'),
      learn: this.element.find('.learn-more')
    };
    this.top = 120;
    this.bottom = this.elements.main.offset().top;
    return this.opaqueMin = this.element.height() - this.elements.menu.height();
  };

  HeaderCtrl.prototype.bindEvents = function() {
    $(document).scrollspy({
      onTick: (function(_this) {
        return function(element, position, inside, enters, leaves) {
          var opacity;
          if (position.top < _this.top) {
            _this.elements.main.css('opacity', 100);
            _this.elements.learn.css('opacity', 100);
            return;
          }
          opacity = (_this.bottom - position.top) / (_this.bottom - _this.top);
          _this.elements.main.css('opacity', opacity);
          return _this.elements.learn.css('opacity', opacity);
        };
      })(this)
    });
    return this.elements.menu.scrollspy({
      min: 15,
      max: 10000000000,
      onEnter: (function(_this) {
        return function(element, position) {
          return _this.elements.menu.addClass('static');
        };
      })(this),
      onLeave: (function(_this) {
        return function(element, position) {
          return _this.elements.menu.removeClass('static');
        };
      })(this)
    }).scrollspy({
      min: this.opaqueMin,
      max: 10000000000,
      onEnter: (function(_this) {
        return function(element, position) {
          return _this.elements.menu.addClass('opaque');
        };
      })(this),
      onLeave: (function(_this) {
        return function(element, position) {
          return _this.elements.menu.removeClass('opaque');
        };
      })(this)
    });
  };

  return HeaderCtrl;

})(Ctrl);

BreakpointsCtrl = (function(_super) {
  __extends(BreakpointsCtrl, _super);

  function BreakpointsCtrl() {
    return BreakpointsCtrl.__super__.constructor.apply(this, arguments);
  }

  BreakpointsCtrl.prototype.gatherElements = function() {
    this.availableBreakpoints = [1, 601, 801, 1281, 1441, 1681, 1921];
    this.window = $(window);
    return this.breakpoints = {};
  };

  BreakpointsCtrl.prototype.getRandomArbitrary = function(min, max) {
    return parseInt(Math.random() * (max - min) + min, 10);
  };

  BreakpointsCtrl.prototype.bindEvents = function() {
    var breakpoint, _fn, _i, _len, _ref;
    this.window.setBreakpoints({
      distinct: true,
      breakpoints: this.availableBreakpoints
    });
    _ref = this.availableBreakpoints;
    _fn = (function(_this) {
      return function(breakpoint) {
        return _this.window.bind("enterBreakpoint" + breakpoint, function() {
          var element, image, img, imgIndex, pair, _j, _len1, _ref1, _results;
          if (!_this.breakpoints[breakpoint]) {
            return;
          }
          _ref1 = _this.breakpoints[breakpoint];
          _results = [];
          for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
            pair = _ref1[_j];
            element = pair[0];
            image = pair[1];
            if (image instanceof Array) {
              imgIndex = _this.getRandomArbitrary(0, image.length - 1);
              console.log(imgIndex);
              img = image[imgIndex];
              _results.push(element.css('background-image', "url(" + _this.thumborServerUrl + "/" + img + ")"));
            } else {
              _results.push(element.css('background-image', "url(" + _this.thumborServerUrl + "/" + image + ")"));
            }
          }
          return _results;
        });
      };
    })(this);
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      breakpoint = _ref[_i];
      _fn(breakpoint);
    }
  };

  BreakpointsCtrl.prototype.setThumborServer = function(serverUrl) {
    return this.thumborServerUrl = serverUrl;
  };

  BreakpointsCtrl.prototype.addBreakpoint = function(breakpoint, element, image) {
    if (this.breakpoints[breakpoint] == null) {
      this.breakpoints[breakpoint] = [];
    }
    return this.breakpoints[breakpoint].push([element, image]);
  };

  return BreakpointsCtrl;

})(Ctrl);

ContributorsCount = (function(_super) {
  __extends(ContributorsCount, _super);

  function ContributorsCount() {
    return ContributorsCount.__super__.constructor.apply(this, arguments);
  }

  ContributorsCount.prototype.bindEvents = function() {
    return $.ajax({
      url: 'https://api.github.com/repos/thumbor/thumbor/contributors?per_page=1',
      type: 'head'
    }).done((function(_this) {
      return function(response, info, headers) {
        var count, header;
        header = headers.getResponseHeader('Link');
        count = /&page=(\d+)>; rel="last"/g.exec(header)[1];
        return _this.element.html(parseInt(count, 10) - 3);
      };
    })(this));
  };

  return ContributorsCount;

})(Ctrl);

new ContributorsCount($('.contributors-count'));

TestimonialsCtrl = (function(_super) {
  __extends(TestimonialsCtrl, _super);

  function TestimonialsCtrl() {
    this.testimonialSaved = __bind(this.testimonialSaved, this);
    return TestimonialsCtrl.__super__.constructor.apply(this, arguments);
  }

  TestimonialsCtrl.prototype.gatherElements = function() {
    this.elements.username = $('#user-name');
    this.elements.email = $('#user-email');
    this.elements.companyName = $('#company-name');
    this.elements.companyUrl = $('#company-website');
    this.elements.testimonial = $('#testimonial');
    this.elements.submit = this.element.find('.submit a');
    this.elements["new"] = this.element.find('.new');
    return this.elements.success = this.element.find('.success');
  };

  TestimonialsCtrl.prototype.bindEvents = function() {
    return this.elements.submit.on('click', (function(_this) {
      return function(ev) {
        var data;
        _this.clearValidation();
        ev.preventDefault();
        if (_this.validate()) {
          data = {
            sender_name: _this.elements.username.val(),
            email: _this.elements.email.val(),
            company_name: _this.elements.companyName.val(),
            company_url: _this.elements.companyUrl.val(),
            testimonial: _this.elements.testimonial.val()
          };
          return $.ajax({
            type: "POST",
            url: '/new-testimonial',
            data: data,
            success: _this.testimonialSaved
          });
        }
      };
    })(this));
  };

  TestimonialsCtrl.prototype.testimonialSaved = function() {
    this.elements["new"].addClass('hidden');
    return this.elements.success.removeClass('hidden');
  };

  TestimonialsCtrl.prototype.clearValidation = function() {
    this.elements.username.removeClass('error');
    this.elements.email.removeClass('error');
    this.elements.companyName.removeClass('error');
    this.elements.companyUrl.removeClass('error');
    return this.elements.testimonial.removeClass('error');
  };

  TestimonialsCtrl.prototype.validate = function() {
    var isValid;
    isValid = true;
    if (this.elements.username.val() === '') {
      isValid = false;
      this.elements.username.addClass('error');
    }
    if (this.elements.email.val() === '') {
      isValid = false;
      this.elements.email.addClass('error');
    }
    if (this.elements.companyName.val() === '') {
      isValid = false;
      this.elements.companyName.addClass('error');
    }
    if (this.elements.companyUrl.val() === '') {
      isValid = false;
      this.elements.companyUrl.addClass('error');
    }
    if (this.elements.testimonial.val() === '') {
      isValid = false;
      this.elements.testimonial.addClass('error');
    }
    return isValid;
  };

  return TestimonialsCtrl;

})(Ctrl);
