# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetGroupProvisionedUsersResult',
    'AwaitableGetGroupProvisionedUsersResult',
    'get_group_provisioned_users',
    'get_group_provisioned_users_output',
]

@pulumi.output_type
class GetGroupProvisionedUsersResult:
    """
    A collection of values returned by getGroupProvisionedUsers.
    """
    def __init__(__self__, active=None, blocked=None, created_after=None, created_before=None, id=None, provisioned_users=None, search=None, username=None):
        if active and not isinstance(active, bool):
            raise TypeError("Expected argument 'active' to be a bool")
        pulumi.set(__self__, "active", active)
        if blocked and not isinstance(blocked, bool):
            raise TypeError("Expected argument 'blocked' to be a bool")
        pulumi.set(__self__, "blocked", blocked)
        if created_after and not isinstance(created_after, str):
            raise TypeError("Expected argument 'created_after' to be a str")
        pulumi.set(__self__, "created_after", created_after)
        if created_before and not isinstance(created_before, str):
            raise TypeError("Expected argument 'created_before' to be a str")
        pulumi.set(__self__, "created_before", created_before)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if provisioned_users and not isinstance(provisioned_users, list):
            raise TypeError("Expected argument 'provisioned_users' to be a list")
        pulumi.set(__self__, "provisioned_users", provisioned_users)
        if search and not isinstance(search, str):
            raise TypeError("Expected argument 'search' to be a str")
        pulumi.set(__self__, "search", search)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def active(self) -> Optional[builtins.bool]:
        """
        Return only active provisioned users.
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter
    def blocked(self) -> Optional[builtins.bool]:
        """
        Return only blocked provisioned users.
        """
        return pulumi.get(self, "blocked")

    @property
    @pulumi.getter(name="createdAfter")
    def created_after(self) -> Optional[builtins.str]:
        """
        Return only provisioned users created on or after the specified date. Expected in ISO 8601 format (YYYY-MM-DDTHH:MM:SSZ).
        """
        return pulumi.get(self, "created_after")

    @property
    @pulumi.getter(name="createdBefore")
    def created_before(self) -> Optional[builtins.str]:
        """
        Return only provisioned users created on or before the specified date. Expected in ISO 8601 format (YYYY-MM-DDTHH:MM:SSZ).
        """
        return pulumi.get(self, "created_before")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID or URL-encoded path of the group.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="provisionedUsers")
    def provisioned_users(self) -> Optional[Sequence['outputs.GetGroupProvisionedUsersProvisionedUserResult']]:
        """
        The list of provisioned users.
        """
        return pulumi.get(self, "provisioned_users")

    @property
    @pulumi.getter
    def search(self) -> Optional[builtins.str]:
        """
        The search query to filter the provisioned users.
        """
        return pulumi.get(self, "search")

    @property
    @pulumi.getter
    def username(self) -> Optional[builtins.str]:
        """
        The username of the provisioned user.
        """
        return pulumi.get(self, "username")


class AwaitableGetGroupProvisionedUsersResult(GetGroupProvisionedUsersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGroupProvisionedUsersResult(
            active=self.active,
            blocked=self.blocked,
            created_after=self.created_after,
            created_before=self.created_before,
            id=self.id,
            provisioned_users=self.provisioned_users,
            search=self.search,
            username=self.username)


def get_group_provisioned_users(active: Optional[builtins.bool] = None,
                                blocked: Optional[builtins.bool] = None,
                                created_after: Optional[builtins.str] = None,
                                created_before: Optional[builtins.str] = None,
                                id: Optional[builtins.str] = None,
                                provisioned_users: Optional[Sequence[Union['GetGroupProvisionedUsersProvisionedUserArgs', 'GetGroupProvisionedUsersProvisionedUserArgsDict']]] = None,
                                search: Optional[builtins.str] = None,
                                username: Optional[builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGroupProvisionedUsersResult:
    """
    The `get_group_provisioned_users` data source retrieves details of the provisioned users in a given group.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/groups/#list-provisioned-users)


    :param builtins.bool active: Return only active provisioned users.
    :param builtins.bool blocked: Return only blocked provisioned users.
    :param builtins.str created_after: Return only provisioned users created on or after the specified date. Expected in ISO 8601 format (YYYY-MM-DDTHH:MM:SSZ).
    :param builtins.str created_before: Return only provisioned users created on or before the specified date. Expected in ISO 8601 format (YYYY-MM-DDTHH:MM:SSZ).
    :param builtins.str id: The ID or URL-encoded path of the group.
    :param Sequence[Union['GetGroupProvisionedUsersProvisionedUserArgs', 'GetGroupProvisionedUsersProvisionedUserArgsDict']] provisioned_users: The list of provisioned users.
    :param builtins.str search: The search query to filter the provisioned users.
    :param builtins.str username: The username of the provisioned user.
    """
    __args__ = dict()
    __args__['active'] = active
    __args__['blocked'] = blocked
    __args__['createdAfter'] = created_after
    __args__['createdBefore'] = created_before
    __args__['id'] = id
    __args__['provisionedUsers'] = provisioned_users
    __args__['search'] = search
    __args__['username'] = username
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gitlab:index/getGroupProvisionedUsers:getGroupProvisionedUsers', __args__, opts=opts, typ=GetGroupProvisionedUsersResult).value

    return AwaitableGetGroupProvisionedUsersResult(
        active=pulumi.get(__ret__, 'active'),
        blocked=pulumi.get(__ret__, 'blocked'),
        created_after=pulumi.get(__ret__, 'created_after'),
        created_before=pulumi.get(__ret__, 'created_before'),
        id=pulumi.get(__ret__, 'id'),
        provisioned_users=pulumi.get(__ret__, 'provisioned_users'),
        search=pulumi.get(__ret__, 'search'),
        username=pulumi.get(__ret__, 'username'))
def get_group_provisioned_users_output(active: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                                       blocked: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                                       created_after: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                       created_before: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                       id: Optional[pulumi.Input[builtins.str]] = None,
                                       provisioned_users: Optional[pulumi.Input[Optional[Sequence[Union['GetGroupProvisionedUsersProvisionedUserArgs', 'GetGroupProvisionedUsersProvisionedUserArgsDict']]]]] = None,
                                       search: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                       username: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGroupProvisionedUsersResult]:
    """
    The `get_group_provisioned_users` data source retrieves details of the provisioned users in a given group.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/groups/#list-provisioned-users)


    :param builtins.bool active: Return only active provisioned users.
    :param builtins.bool blocked: Return only blocked provisioned users.
    :param builtins.str created_after: Return only provisioned users created on or after the specified date. Expected in ISO 8601 format (YYYY-MM-DDTHH:MM:SSZ).
    :param builtins.str created_before: Return only provisioned users created on or before the specified date. Expected in ISO 8601 format (YYYY-MM-DDTHH:MM:SSZ).
    :param builtins.str id: The ID or URL-encoded path of the group.
    :param Sequence[Union['GetGroupProvisionedUsersProvisionedUserArgs', 'GetGroupProvisionedUsersProvisionedUserArgsDict']] provisioned_users: The list of provisioned users.
    :param builtins.str search: The search query to filter the provisioned users.
    :param builtins.str username: The username of the provisioned user.
    """
    __args__ = dict()
    __args__['active'] = active
    __args__['blocked'] = blocked
    __args__['createdAfter'] = created_after
    __args__['createdBefore'] = created_before
    __args__['id'] = id
    __args__['provisionedUsers'] = provisioned_users
    __args__['search'] = search
    __args__['username'] = username
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gitlab:index/getGroupProvisionedUsers:getGroupProvisionedUsers', __args__, opts=opts, typ=GetGroupProvisionedUsersResult)
    return __ret__.apply(lambda __response__: GetGroupProvisionedUsersResult(
        active=pulumi.get(__response__, 'active'),
        blocked=pulumi.get(__response__, 'blocked'),
        created_after=pulumi.get(__response__, 'created_after'),
        created_before=pulumi.get(__response__, 'created_before'),
        id=pulumi.get(__response__, 'id'),
        provisioned_users=pulumi.get(__response__, 'provisioned_users'),
        search=pulumi.get(__response__, 'search'),
        username=pulumi.get(__response__, 'username')))
