# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetProjectProtectedBranchesResult',
    'AwaitableGetProjectProtectedBranchesResult',
    'get_project_protected_branches',
    'get_project_protected_branches_output',
]

@pulumi.output_type
class GetProjectProtectedBranchesResult:
    """
    A collection of values returned by getProjectProtectedBranches.
    """
    def __init__(__self__, id=None, project_id=None, protected_branches=None):
        if id and not isinstance(id, int):
            raise TypeError("Expected argument 'id' to be a int")
        pulumi.set(__self__, "id", id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if protected_branches and not isinstance(protected_branches, list):
            raise TypeError("Expected argument 'protected_branches' to be a list")
        pulumi.set(__self__, "protected_branches", protected_branches)

    @property
    @pulumi.getter
    def id(self) -> builtins.int:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        """
        The integer or path with namespace that uniquely identifies the project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="protectedBranches")
    def protected_branches(self) -> Optional[Sequence['outputs.GetProjectProtectedBranchesProtectedBranchResult']]:
        """
        A list of protected branches, as defined below.
        """
        return pulumi.get(self, "protected_branches")


class AwaitableGetProjectProtectedBranchesResult(GetProjectProtectedBranchesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectProtectedBranchesResult(
            id=self.id,
            project_id=self.project_id,
            protected_branches=self.protected_branches)


def get_project_protected_branches(project_id: Optional[builtins.str] = None,
                                   protected_branches: Optional[Sequence[Union['GetProjectProtectedBranchesProtectedBranchArgs', 'GetProjectProtectedBranchesProtectedBranchArgsDict']]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectProtectedBranchesResult:
    """
    The `get_project_protected_branches` data source allows details of the protected branches of a given project.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/protected_branches/#list-protected-branches)


    :param builtins.str project_id: The integer or path with namespace that uniquely identifies the project.
    :param Sequence[Union['GetProjectProtectedBranchesProtectedBranchArgs', 'GetProjectProtectedBranchesProtectedBranchArgsDict']] protected_branches: A list of protected branches, as defined below.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    __args__['protectedBranches'] = protected_branches
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gitlab:index/getProjectProtectedBranches:getProjectProtectedBranches', __args__, opts=opts, typ=GetProjectProtectedBranchesResult).value

    return AwaitableGetProjectProtectedBranchesResult(
        id=pulumi.get(__ret__, 'id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        protected_branches=pulumi.get(__ret__, 'protected_branches'))
def get_project_protected_branches_output(project_id: Optional[pulumi.Input[builtins.str]] = None,
                                          protected_branches: Optional[pulumi.Input[Optional[Sequence[Union['GetProjectProtectedBranchesProtectedBranchArgs', 'GetProjectProtectedBranchesProtectedBranchArgsDict']]]]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProjectProtectedBranchesResult]:
    """
    The `get_project_protected_branches` data source allows details of the protected branches of a given project.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/protected_branches/#list-protected-branches)


    :param builtins.str project_id: The integer or path with namespace that uniquely identifies the project.
    :param Sequence[Union['GetProjectProtectedBranchesProtectedBranchArgs', 'GetProjectProtectedBranchesProtectedBranchArgsDict']] protected_branches: A list of protected branches, as defined below.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    __args__['protectedBranches'] = protected_branches
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gitlab:index/getProjectProtectedBranches:getProjectProtectedBranches', __args__, opts=opts, typ=GetProjectProtectedBranchesResult)
    return __ret__.apply(lambda __response__: GetProjectProtectedBranchesResult(
        id=pulumi.get(__response__, 'id'),
        project_id=pulumi.get(__response__, 'project_id'),
        protected_branches=pulumi.get(__response__, 'protected_branches')))
