# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProjectPagesSettingsArgs', 'ProjectPagesSettings']

@pulumi.input_type
class ProjectPagesSettingsArgs:
    def __init__(__self__, *,
                 project: pulumi.Input[builtins.str],
                 force_https: Optional[pulumi.Input[builtins.bool]] = None,
                 is_unique_domain_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 keep_settings_on_destroy: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a ProjectPagesSettings resource.
        :param pulumi.Input[builtins.str] project: The project ID or path.
        :param pulumi.Input[builtins.bool] force_https: Boolean indicating if the project is set to force https. Requires `external_https` to be configured in the GitLab instance: https://docs.gitlab.com/administration/pages/#custom-domains-with-tls-support.
        :param pulumi.Input[builtins.bool] is_unique_domain_enabled: Boolean indicating if a unique domain is enabled.
        """
        pulumi.set(__self__, "project", project)
        if force_https is not None:
            pulumi.set(__self__, "force_https", force_https)
        if is_unique_domain_enabled is not None:
            pulumi.set(__self__, "is_unique_domain_enabled", is_unique_domain_enabled)
        if keep_settings_on_destroy is not None:
            pulumi.set(__self__, "keep_settings_on_destroy", keep_settings_on_destroy)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[builtins.str]:
        """
        The project ID or path.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="forceHttps")
    def force_https(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean indicating if the project is set to force https. Requires `external_https` to be configured in the GitLab instance: https://docs.gitlab.com/administration/pages/#custom-domains-with-tls-support.
        """
        return pulumi.get(self, "force_https")

    @force_https.setter
    def force_https(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force_https", value)

    @property
    @pulumi.getter(name="isUniqueDomainEnabled")
    def is_unique_domain_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean indicating if a unique domain is enabled.
        """
        return pulumi.get(self, "is_unique_domain_enabled")

    @is_unique_domain_enabled.setter
    def is_unique_domain_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_unique_domain_enabled", value)

    @property
    @pulumi.getter(name="keepSettingsOnDestroy")
    def keep_settings_on_destroy(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "keep_settings_on_destroy")

    @keep_settings_on_destroy.setter
    def keep_settings_on_destroy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "keep_settings_on_destroy", value)


@pulumi.input_type
class _ProjectPagesSettingsState:
    def __init__(__self__, *,
                 deployments: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectPagesSettingsDeploymentArgs']]]] = None,
                 force_https: Optional[pulumi.Input[builtins.bool]] = None,
                 is_unique_domain_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 keep_settings_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ProjectPagesSettings resources.
        :param pulumi.Input[Sequence[pulumi.Input['ProjectPagesSettingsDeploymentArgs']]] deployments: List of current active deployments.
        :param pulumi.Input[builtins.bool] force_https: Boolean indicating if the project is set to force https. Requires `external_https` to be configured in the GitLab instance: https://docs.gitlab.com/administration/pages/#custom-domains-with-tls-support.
        :param pulumi.Input[builtins.bool] is_unique_domain_enabled: Boolean indicating if a unique domain is enabled.
        :param pulumi.Input[builtins.str] project: The project ID or path.
        :param pulumi.Input[builtins.str] url: The URL to access the project pages.
        """
        if deployments is not None:
            pulumi.set(__self__, "deployments", deployments)
        if force_https is not None:
            pulumi.set(__self__, "force_https", force_https)
        if is_unique_domain_enabled is not None:
            pulumi.set(__self__, "is_unique_domain_enabled", is_unique_domain_enabled)
        if keep_settings_on_destroy is not None:
            pulumi.set(__self__, "keep_settings_on_destroy", keep_settings_on_destroy)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def deployments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectPagesSettingsDeploymentArgs']]]]:
        """
        List of current active deployments.
        """
        return pulumi.get(self, "deployments")

    @deployments.setter
    def deployments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectPagesSettingsDeploymentArgs']]]]):
        pulumi.set(self, "deployments", value)

    @property
    @pulumi.getter(name="forceHttps")
    def force_https(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean indicating if the project is set to force https. Requires `external_https` to be configured in the GitLab instance: https://docs.gitlab.com/administration/pages/#custom-domains-with-tls-support.
        """
        return pulumi.get(self, "force_https")

    @force_https.setter
    def force_https(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force_https", value)

    @property
    @pulumi.getter(name="isUniqueDomainEnabled")
    def is_unique_domain_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean indicating if a unique domain is enabled.
        """
        return pulumi.get(self, "is_unique_domain_enabled")

    @is_unique_domain_enabled.setter
    def is_unique_domain_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_unique_domain_enabled", value)

    @property
    @pulumi.getter(name="keepSettingsOnDestroy")
    def keep_settings_on_destroy(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "keep_settings_on_destroy")

    @keep_settings_on_destroy.setter
    def keep_settings_on_destroy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "keep_settings_on_destroy", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The project ID or path.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL to access the project pages.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "url", value)


@pulumi.type_token("gitlab:index/projectPagesSettings:ProjectPagesSettings")
class ProjectPagesSettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 force_https: Optional[pulumi.Input[builtins.bool]] = None,
                 is_unique_domain_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 keep_settings_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_project_pages_settings`. For example:

        terraform

        import {

          to = gitlab_project_pages_settings.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        Gitlab project pages settings can be imported using the project ID, for example:

        ```sh
        $ pulumi import gitlab:index/projectPagesSettings:ProjectPagesSettings example 12345
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] force_https: Boolean indicating if the project is set to force https. Requires `external_https` to be configured in the GitLab instance: https://docs.gitlab.com/administration/pages/#custom-domains-with-tls-support.
        :param pulumi.Input[builtins.bool] is_unique_domain_enabled: Boolean indicating if a unique domain is enabled.
        :param pulumi.Input[builtins.str] project: The project ID or path.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectPagesSettingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_project_pages_settings`. For example:

        terraform

        import {

          to = gitlab_project_pages_settings.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        Gitlab project pages settings can be imported using the project ID, for example:

        ```sh
        $ pulumi import gitlab:index/projectPagesSettings:ProjectPagesSettings example 12345
        ```

        :param str resource_name: The name of the resource.
        :param ProjectPagesSettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectPagesSettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 force_https: Optional[pulumi.Input[builtins.bool]] = None,
                 is_unique_domain_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 keep_settings_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectPagesSettingsArgs.__new__(ProjectPagesSettingsArgs)

            __props__.__dict__["force_https"] = force_https
            __props__.__dict__["is_unique_domain_enabled"] = is_unique_domain_enabled
            __props__.__dict__["keep_settings_on_destroy"] = keep_settings_on_destroy
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["deployments"] = None
            __props__.__dict__["url"] = None
        super(ProjectPagesSettings, __self__).__init__(
            'gitlab:index/projectPagesSettings:ProjectPagesSettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            deployments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectPagesSettingsDeploymentArgs', 'ProjectPagesSettingsDeploymentArgsDict']]]]] = None,
            force_https: Optional[pulumi.Input[builtins.bool]] = None,
            is_unique_domain_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            keep_settings_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            url: Optional[pulumi.Input[builtins.str]] = None) -> 'ProjectPagesSettings':
        """
        Get an existing ProjectPagesSettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProjectPagesSettingsDeploymentArgs', 'ProjectPagesSettingsDeploymentArgsDict']]]] deployments: List of current active deployments.
        :param pulumi.Input[builtins.bool] force_https: Boolean indicating if the project is set to force https. Requires `external_https` to be configured in the GitLab instance: https://docs.gitlab.com/administration/pages/#custom-domains-with-tls-support.
        :param pulumi.Input[builtins.bool] is_unique_domain_enabled: Boolean indicating if a unique domain is enabled.
        :param pulumi.Input[builtins.str] project: The project ID or path.
        :param pulumi.Input[builtins.str] url: The URL to access the project pages.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectPagesSettingsState.__new__(_ProjectPagesSettingsState)

        __props__.__dict__["deployments"] = deployments
        __props__.__dict__["force_https"] = force_https
        __props__.__dict__["is_unique_domain_enabled"] = is_unique_domain_enabled
        __props__.__dict__["keep_settings_on_destroy"] = keep_settings_on_destroy
        __props__.__dict__["project"] = project
        __props__.__dict__["url"] = url
        return ProjectPagesSettings(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def deployments(self) -> pulumi.Output[Sequence['outputs.ProjectPagesSettingsDeployment']]:
        """
        List of current active deployments.
        """
        return pulumi.get(self, "deployments")

    @property
    @pulumi.getter(name="forceHttps")
    def force_https(self) -> pulumi.Output[builtins.bool]:
        """
        Boolean indicating if the project is set to force https. Requires `external_https` to be configured in the GitLab instance: https://docs.gitlab.com/administration/pages/#custom-domains-with-tls-support.
        """
        return pulumi.get(self, "force_https")

    @property
    @pulumi.getter(name="isUniqueDomainEnabled")
    def is_unique_domain_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Boolean indicating if a unique domain is enabled.
        """
        return pulumi.get(self, "is_unique_domain_enabled")

    @property
    @pulumi.getter(name="keepSettingsOnDestroy")
    def keep_settings_on_destroy(self) -> pulumi.Output[builtins.bool]:
        return pulumi.get(self, "keep_settings_on_destroy")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The project ID or path.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[builtins.str]:
        """
        The URL to access the project pages.
        """
        return pulumi.get(self, "url")

