# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProjectVariableArgs', 'ProjectVariable']

@pulumi.input_type
class ProjectVariableArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[builtins.str],
                 project: pulumi.Input[builtins.str],
                 value: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 environment_scope: Optional[pulumi.Input[builtins.str]] = None,
                 hidden: Optional[pulumi.Input[builtins.bool]] = None,
                 masked: Optional[pulumi.Input[builtins.bool]] = None,
                 protected: Optional[pulumi.Input[builtins.bool]] = None,
                 raw: Optional[pulumi.Input[builtins.bool]] = None,
                 variable_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ProjectVariable resource.
        :param pulumi.Input[builtins.str] key: The name of the variable.
        :param pulumi.Input[builtins.str] project: The name or id of the project.
        :param pulumi.Input[builtins.str] value: The value of the variable.
        :param pulumi.Input[builtins.str] description: The description of the variable.
        :param pulumi.Input[builtins.str] environment_scope: The environment scope of the variable. Defaults to all environment (`*`). Note that in Community Editions of Gitlab, values other than `*` will cause inconsistent plans.
        :param pulumi.Input[builtins.bool] hidden: If set to `true`, the value of the variable will be hidden in the CI/CD User Interface. The value must meet the [hidden requirements](https://docs.gitlab.com/ci/variables/#hide-a-cicd-variable).
        :param pulumi.Input[builtins.bool] masked: If set to `true`, the value of the variable will be masked in job logs. The value must meet the [masking requirements](https://docs.gitlab.com/ee/ci/variables/#mask-a-cicd-variable).
        :param pulumi.Input[builtins.bool] protected: If set to `true`, the variable will be passed only to pipelines running on protected branches and tags.
        :param pulumi.Input[builtins.bool] raw: Whether the variable is treated as a raw string. When true, variables in the value are not expanded.
        :param pulumi.Input[builtins.str] variable_type: The type of a variable. Valid values are: `env_var`, `file`.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "value", value)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment_scope is not None:
            pulumi.set(__self__, "environment_scope", environment_scope)
        if hidden is not None:
            pulumi.set(__self__, "hidden", hidden)
        if masked is not None:
            pulumi.set(__self__, "masked", masked)
        if protected is not None:
            pulumi.set(__self__, "protected", protected)
        if raw is not None:
            pulumi.set(__self__, "raw", raw)
        if variable_type is not None:
            pulumi.set(__self__, "variable_type", variable_type)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[builtins.str]:
        """
        The name of the variable.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[builtins.str]:
        """
        The name or id of the project.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[builtins.str]:
        """
        The value of the variable.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the variable.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="environmentScope")
    def environment_scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The environment scope of the variable. Defaults to all environment (`*`). Note that in Community Editions of Gitlab, values other than `*` will cause inconsistent plans.
        """
        return pulumi.get(self, "environment_scope")

    @environment_scope.setter
    def environment_scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "environment_scope", value)

    @property
    @pulumi.getter
    def hidden(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to `true`, the value of the variable will be hidden in the CI/CD User Interface. The value must meet the [hidden requirements](https://docs.gitlab.com/ci/variables/#hide-a-cicd-variable).
        """
        return pulumi.get(self, "hidden")

    @hidden.setter
    def hidden(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "hidden", value)

    @property
    @pulumi.getter
    def masked(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to `true`, the value of the variable will be masked in job logs. The value must meet the [masking requirements](https://docs.gitlab.com/ee/ci/variables/#mask-a-cicd-variable).
        """
        return pulumi.get(self, "masked")

    @masked.setter
    def masked(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "masked", value)

    @property
    @pulumi.getter
    def protected(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to `true`, the variable will be passed only to pipelines running on protected branches and tags.
        """
        return pulumi.get(self, "protected")

    @protected.setter
    def protected(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "protected", value)

    @property
    @pulumi.getter
    def raw(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the variable is treated as a raw string. When true, variables in the value are not expanded.
        """
        return pulumi.get(self, "raw")

    @raw.setter
    def raw(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "raw", value)

    @property
    @pulumi.getter(name="variableType")
    def variable_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of a variable. Valid values are: `env_var`, `file`.
        """
        return pulumi.get(self, "variable_type")

    @variable_type.setter
    def variable_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "variable_type", value)


@pulumi.input_type
class _ProjectVariableState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 environment_scope: Optional[pulumi.Input[builtins.str]] = None,
                 hidden: Optional[pulumi.Input[builtins.bool]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 masked: Optional[pulumi.Input[builtins.bool]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 protected: Optional[pulumi.Input[builtins.bool]] = None,
                 raw: Optional[pulumi.Input[builtins.bool]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None,
                 variable_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ProjectVariable resources.
        :param pulumi.Input[builtins.str] description: The description of the variable.
        :param pulumi.Input[builtins.str] environment_scope: The environment scope of the variable. Defaults to all environment (`*`). Note that in Community Editions of Gitlab, values other than `*` will cause inconsistent plans.
        :param pulumi.Input[builtins.bool] hidden: If set to `true`, the value of the variable will be hidden in the CI/CD User Interface. The value must meet the [hidden requirements](https://docs.gitlab.com/ci/variables/#hide-a-cicd-variable).
        :param pulumi.Input[builtins.str] key: The name of the variable.
        :param pulumi.Input[builtins.bool] masked: If set to `true`, the value of the variable will be masked in job logs. The value must meet the [masking requirements](https://docs.gitlab.com/ee/ci/variables/#mask-a-cicd-variable).
        :param pulumi.Input[builtins.str] project: The name or id of the project.
        :param pulumi.Input[builtins.bool] protected: If set to `true`, the variable will be passed only to pipelines running on protected branches and tags.
        :param pulumi.Input[builtins.bool] raw: Whether the variable is treated as a raw string. When true, variables in the value are not expanded.
        :param pulumi.Input[builtins.str] value: The value of the variable.
        :param pulumi.Input[builtins.str] variable_type: The type of a variable. Valid values are: `env_var`, `file`.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment_scope is not None:
            pulumi.set(__self__, "environment_scope", environment_scope)
        if hidden is not None:
            pulumi.set(__self__, "hidden", hidden)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if masked is not None:
            pulumi.set(__self__, "masked", masked)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if protected is not None:
            pulumi.set(__self__, "protected", protected)
        if raw is not None:
            pulumi.set(__self__, "raw", raw)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if variable_type is not None:
            pulumi.set(__self__, "variable_type", variable_type)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the variable.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="environmentScope")
    def environment_scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The environment scope of the variable. Defaults to all environment (`*`). Note that in Community Editions of Gitlab, values other than `*` will cause inconsistent plans.
        """
        return pulumi.get(self, "environment_scope")

    @environment_scope.setter
    def environment_scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "environment_scope", value)

    @property
    @pulumi.getter
    def hidden(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to `true`, the value of the variable will be hidden in the CI/CD User Interface. The value must meet the [hidden requirements](https://docs.gitlab.com/ci/variables/#hide-a-cicd-variable).
        """
        return pulumi.get(self, "hidden")

    @hidden.setter
    def hidden(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "hidden", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the variable.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def masked(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to `true`, the value of the variable will be masked in job logs. The value must meet the [masking requirements](https://docs.gitlab.com/ee/ci/variables/#mask-a-cicd-variable).
        """
        return pulumi.get(self, "masked")

    @masked.setter
    def masked(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "masked", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name or id of the project.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def protected(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to `true`, the variable will be passed only to pipelines running on protected branches and tags.
        """
        return pulumi.get(self, "protected")

    @protected.setter
    def protected(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "protected", value)

    @property
    @pulumi.getter
    def raw(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the variable is treated as a raw string. When true, variables in the value are not expanded.
        """
        return pulumi.get(self, "raw")

    @raw.setter
    def raw(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "raw", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The value of the variable.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="variableType")
    def variable_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of a variable. Valid values are: `env_var`, `file`.
        """
        return pulumi.get(self, "variable_type")

    @variable_type.setter
    def variable_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "variable_type", value)


@pulumi.type_token("gitlab:index/projectVariable:ProjectVariable")
class ProjectVariable(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 environment_scope: Optional[pulumi.Input[builtins.str]] = None,
                 hidden: Optional[pulumi.Input[builtins.bool]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 masked: Optional[pulumi.Input[builtins.bool]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 protected: Optional[pulumi.Input[builtins.bool]] = None,
                 raw: Optional[pulumi.Input[builtins.bool]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None,
                 variable_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        The `ProjectVariable` resource allows creating and managing a GitLab project level variable.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/project_level_variables/)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        example = gitlab.ProjectVariable("example",
            project="12345",
            key="project_variable_key",
            value="project_variable_value",
            protected=False)
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_project_variable`. For example:

        terraform

        import {

          to = gitlab_project_variable.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        GitLab project variables can be imported using an id made up of `project:key:environment_scope`, e.g.

        ```sh
        $ pulumi import gitlab:index/projectVariable:ProjectVariable example '12345:project_variable_key:*'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: The description of the variable.
        :param pulumi.Input[builtins.str] environment_scope: The environment scope of the variable. Defaults to all environment (`*`). Note that in Community Editions of Gitlab, values other than `*` will cause inconsistent plans.
        :param pulumi.Input[builtins.bool] hidden: If set to `true`, the value of the variable will be hidden in the CI/CD User Interface. The value must meet the [hidden requirements](https://docs.gitlab.com/ci/variables/#hide-a-cicd-variable).
        :param pulumi.Input[builtins.str] key: The name of the variable.
        :param pulumi.Input[builtins.bool] masked: If set to `true`, the value of the variable will be masked in job logs. The value must meet the [masking requirements](https://docs.gitlab.com/ee/ci/variables/#mask-a-cicd-variable).
        :param pulumi.Input[builtins.str] project: The name or id of the project.
        :param pulumi.Input[builtins.bool] protected: If set to `true`, the variable will be passed only to pipelines running on protected branches and tags.
        :param pulumi.Input[builtins.bool] raw: Whether the variable is treated as a raw string. When true, variables in the value are not expanded.
        :param pulumi.Input[builtins.str] value: The value of the variable.
        :param pulumi.Input[builtins.str] variable_type: The type of a variable. Valid values are: `env_var`, `file`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectVariableArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `ProjectVariable` resource allows creating and managing a GitLab project level variable.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/project_level_variables/)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        example = gitlab.ProjectVariable("example",
            project="12345",
            key="project_variable_key",
            value="project_variable_value",
            protected=False)
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_project_variable`. For example:

        terraform

        import {

          to = gitlab_project_variable.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        GitLab project variables can be imported using an id made up of `project:key:environment_scope`, e.g.

        ```sh
        $ pulumi import gitlab:index/projectVariable:ProjectVariable example '12345:project_variable_key:*'
        ```

        :param str resource_name: The name of the resource.
        :param ProjectVariableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectVariableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 environment_scope: Optional[pulumi.Input[builtins.str]] = None,
                 hidden: Optional[pulumi.Input[builtins.bool]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 masked: Optional[pulumi.Input[builtins.bool]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 protected: Optional[pulumi.Input[builtins.bool]] = None,
                 raw: Optional[pulumi.Input[builtins.bool]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None,
                 variable_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectVariableArgs.__new__(ProjectVariableArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["environment_scope"] = environment_scope
            __props__.__dict__["hidden"] = hidden
            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = key
            __props__.__dict__["masked"] = masked
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["protected"] = protected
            __props__.__dict__["raw"] = raw
            if value is None and not opts.urn:
                raise TypeError("Missing required property 'value'")
            __props__.__dict__["value"] = value
            __props__.__dict__["variable_type"] = variable_type
        super(ProjectVariable, __self__).__init__(
            'gitlab:index/projectVariable:ProjectVariable',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            environment_scope: Optional[pulumi.Input[builtins.str]] = None,
            hidden: Optional[pulumi.Input[builtins.bool]] = None,
            key: Optional[pulumi.Input[builtins.str]] = None,
            masked: Optional[pulumi.Input[builtins.bool]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            protected: Optional[pulumi.Input[builtins.bool]] = None,
            raw: Optional[pulumi.Input[builtins.bool]] = None,
            value: Optional[pulumi.Input[builtins.str]] = None,
            variable_type: Optional[pulumi.Input[builtins.str]] = None) -> 'ProjectVariable':
        """
        Get an existing ProjectVariable resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: The description of the variable.
        :param pulumi.Input[builtins.str] environment_scope: The environment scope of the variable. Defaults to all environment (`*`). Note that in Community Editions of Gitlab, values other than `*` will cause inconsistent plans.
        :param pulumi.Input[builtins.bool] hidden: If set to `true`, the value of the variable will be hidden in the CI/CD User Interface. The value must meet the [hidden requirements](https://docs.gitlab.com/ci/variables/#hide-a-cicd-variable).
        :param pulumi.Input[builtins.str] key: The name of the variable.
        :param pulumi.Input[builtins.bool] masked: If set to `true`, the value of the variable will be masked in job logs. The value must meet the [masking requirements](https://docs.gitlab.com/ee/ci/variables/#mask-a-cicd-variable).
        :param pulumi.Input[builtins.str] project: The name or id of the project.
        :param pulumi.Input[builtins.bool] protected: If set to `true`, the variable will be passed only to pipelines running on protected branches and tags.
        :param pulumi.Input[builtins.bool] raw: Whether the variable is treated as a raw string. When true, variables in the value are not expanded.
        :param pulumi.Input[builtins.str] value: The value of the variable.
        :param pulumi.Input[builtins.str] variable_type: The type of a variable. Valid values are: `env_var`, `file`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectVariableState.__new__(_ProjectVariableState)

        __props__.__dict__["description"] = description
        __props__.__dict__["environment_scope"] = environment_scope
        __props__.__dict__["hidden"] = hidden
        __props__.__dict__["key"] = key
        __props__.__dict__["masked"] = masked
        __props__.__dict__["project"] = project
        __props__.__dict__["protected"] = protected
        __props__.__dict__["raw"] = raw
        __props__.__dict__["value"] = value
        __props__.__dict__["variable_type"] = variable_type
        return ProjectVariable(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        The description of the variable.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="environmentScope")
    def environment_scope(self) -> pulumi.Output[builtins.str]:
        """
        The environment scope of the variable. Defaults to all environment (`*`). Note that in Community Editions of Gitlab, values other than `*` will cause inconsistent plans.
        """
        return pulumi.get(self, "environment_scope")

    @property
    @pulumi.getter
    def hidden(self) -> pulumi.Output[builtins.bool]:
        """
        If set to `true`, the value of the variable will be hidden in the CI/CD User Interface. The value must meet the [hidden requirements](https://docs.gitlab.com/ci/variables/#hide-a-cicd-variable).
        """
        return pulumi.get(self, "hidden")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[builtins.str]:
        """
        The name of the variable.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def masked(self) -> pulumi.Output[builtins.bool]:
        """
        If set to `true`, the value of the variable will be masked in job logs. The value must meet the [masking requirements](https://docs.gitlab.com/ee/ci/variables/#mask-a-cicd-variable).
        """
        return pulumi.get(self, "masked")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The name or id of the project.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def protected(self) -> pulumi.Output[builtins.bool]:
        """
        If set to `true`, the variable will be passed only to pipelines running on protected branches and tags.
        """
        return pulumi.get(self, "protected")

    @property
    @pulumi.getter
    def raw(self) -> pulumi.Output[builtins.bool]:
        """
        Whether the variable is treated as a raw string. When true, variables in the value are not expanded.
        """
        return pulumi.get(self, "raw")

    @property
    @pulumi.getter
    def value(self) -> pulumi.Output[builtins.str]:
        """
        The value of the variable.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="variableType")
    def variable_type(self) -> pulumi.Output[builtins.str]:
        """
        The type of a variable. Valid values are: `env_var`, `file`.
        """
        return pulumi.get(self, "variable_type")

