# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProjectWikiPageArgs', 'ProjectWikiPage']

@pulumi.input_type
class ProjectWikiPageArgs:
    def __init__(__self__, *,
                 content: pulumi.Input[builtins.str],
                 project: pulumi.Input[builtins.str],
                 title: pulumi.Input[builtins.str],
                 format: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ProjectWikiPage resource.
        :param pulumi.Input[builtins.str] content: Content of the wiki page. Must be at least 1 character long.
        :param pulumi.Input[builtins.str] project: The ID or URL-encoded path of the project.
        :param pulumi.Input[builtins.str] title: Title of the wiki page.
        :param pulumi.Input[builtins.str] format: Format of the wiki page (auto-generated if not provided). Valid values are: `markdown`, `rdoc`, `asciidoc`, `org`.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "title", title)
        if format is not None:
            pulumi.set(__self__, "format", format)

    @property
    @pulumi.getter
    def content(self) -> pulumi.Input[builtins.str]:
        """
        Content of the wiki page. Must be at least 1 character long.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[builtins.str]:
        """
        The ID or URL-encoded path of the project.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[builtins.str]:
        """
        Title of the wiki page.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Format of the wiki page (auto-generated if not provided). Valid values are: `markdown`, `rdoc`, `asciidoc`, `org`.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "format", value)


@pulumi.input_type
class _ProjectWikiPageState:
    def __init__(__self__, *,
                 content: Optional[pulumi.Input[builtins.str]] = None,
                 encoding: Optional[pulumi.Input[builtins.str]] = None,
                 format: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 slug: Optional[pulumi.Input[builtins.str]] = None,
                 title: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ProjectWikiPage resources.
        :param pulumi.Input[builtins.str] content: Content of the wiki page. Must be at least 1 character long.
        :param pulumi.Input[builtins.str] encoding: The encoding used for the wiki page content.
        :param pulumi.Input[builtins.str] format: Format of the wiki page (auto-generated if not provided). Valid values are: `markdown`, `rdoc`, `asciidoc`, `org`.
        :param pulumi.Input[builtins.str] project: The ID or URL-encoded path of the project.
        :param pulumi.Input[builtins.str] slug: Slug of the wiki page.
        :param pulumi.Input[builtins.str] title: Title of the wiki page.
        """
        if content is not None:
            pulumi.set(__self__, "content", content)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if slug is not None:
            pulumi.set(__self__, "slug", slug)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Content of the wiki page. Must be at least 1 character long.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter
    def encoding(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The encoding used for the wiki page content.
        """
        return pulumi.get(self, "encoding")

    @encoding.setter
    def encoding(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "encoding", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Format of the wiki page (auto-generated if not provided). Valid values are: `markdown`, `rdoc`, `asciidoc`, `org`.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID or URL-encoded path of the project.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def slug(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Slug of the wiki page.
        """
        return pulumi.get(self, "slug")

    @slug.setter
    def slug(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "slug", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Title of the wiki page.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "title", value)


@pulumi.type_token("gitlab:index/projectWikiPage:ProjectWikiPage")
class ProjectWikiPage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content: Optional[pulumi.Input[builtins.str]] = None,
                 format: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 title: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        The `ProjectWikiPage` resource allows managing the lifecycle of a project wiki page.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/wikis/)

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_project_wiki_page`. For example:

        terraform

        import {

          to = gitlab_project_wiki_page.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        You can import gitlab_project_wiki_page state using the project ID, e.g.

        ```sh
        $ pulumi import gitlab:index/projectWikiPage:ProjectWikiPage test 12345:my-wiki-page
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] content: Content of the wiki page. Must be at least 1 character long.
        :param pulumi.Input[builtins.str] format: Format of the wiki page (auto-generated if not provided). Valid values are: `markdown`, `rdoc`, `asciidoc`, `org`.
        :param pulumi.Input[builtins.str] project: The ID or URL-encoded path of the project.
        :param pulumi.Input[builtins.str] title: Title of the wiki page.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectWikiPageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `ProjectWikiPage` resource allows managing the lifecycle of a project wiki page.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/wikis/)

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_project_wiki_page`. For example:

        terraform

        import {

          to = gitlab_project_wiki_page.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        You can import gitlab_project_wiki_page state using the project ID, e.g.

        ```sh
        $ pulumi import gitlab:index/projectWikiPage:ProjectWikiPage test 12345:my-wiki-page
        ```

        :param str resource_name: The name of the resource.
        :param ProjectWikiPageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectWikiPageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content: Optional[pulumi.Input[builtins.str]] = None,
                 format: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 title: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectWikiPageArgs.__new__(ProjectWikiPageArgs)

            if content is None and not opts.urn:
                raise TypeError("Missing required property 'content'")
            __props__.__dict__["content"] = content
            __props__.__dict__["format"] = format
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            if title is None and not opts.urn:
                raise TypeError("Missing required property 'title'")
            __props__.__dict__["title"] = title
            __props__.__dict__["encoding"] = None
            __props__.__dict__["slug"] = None
        super(ProjectWikiPage, __self__).__init__(
            'gitlab:index/projectWikiPage:ProjectWikiPage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            content: Optional[pulumi.Input[builtins.str]] = None,
            encoding: Optional[pulumi.Input[builtins.str]] = None,
            format: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            slug: Optional[pulumi.Input[builtins.str]] = None,
            title: Optional[pulumi.Input[builtins.str]] = None) -> 'ProjectWikiPage':
        """
        Get an existing ProjectWikiPage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] content: Content of the wiki page. Must be at least 1 character long.
        :param pulumi.Input[builtins.str] encoding: The encoding used for the wiki page content.
        :param pulumi.Input[builtins.str] format: Format of the wiki page (auto-generated if not provided). Valid values are: `markdown`, `rdoc`, `asciidoc`, `org`.
        :param pulumi.Input[builtins.str] project: The ID or URL-encoded path of the project.
        :param pulumi.Input[builtins.str] slug: Slug of the wiki page.
        :param pulumi.Input[builtins.str] title: Title of the wiki page.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectWikiPageState.__new__(_ProjectWikiPageState)

        __props__.__dict__["content"] = content
        __props__.__dict__["encoding"] = encoding
        __props__.__dict__["format"] = format
        __props__.__dict__["project"] = project
        __props__.__dict__["slug"] = slug
        __props__.__dict__["title"] = title
        return ProjectWikiPage(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def content(self) -> pulumi.Output[builtins.str]:
        """
        Content of the wiki page. Must be at least 1 character long.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def encoding(self) -> pulumi.Output[builtins.str]:
        """
        The encoding used for the wiki page content.
        """
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter
    def format(self) -> pulumi.Output[builtins.str]:
        """
        Format of the wiki page (auto-generated if not provided). Valid values are: `markdown`, `rdoc`, `asciidoc`, `org`.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID or URL-encoded path of the project.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def slug(self) -> pulumi.Output[builtins.str]:
        """
        Slug of the wiki page.
        """
        return pulumi.get(self, "slug")

    @property
    @pulumi.getter
    def title(self) -> pulumi.Output[builtins.str]:
        """
        Title of the wiki page.
        """
        return pulumi.get(self, "title")

