# Copyright 2024 PsiQuantum, Corp.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""The integrations submodule permits LaTeX pretty-printing, and implements Jupyter notebook widgets."""
from .latex import routine_to_latex

__all__ = ["routine_to_latex"]

try:
    from .jupyter.routine_explorer import explore_routine

    __all__.append("explore_routine")
except ImportError:
    pass
