# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from ... import _utilities
from . import outputs
from ... import core as _core
from ... import meta as _meta

__all__ = [
    'ControllerRevision',
    'DaemonSet',
    'DaemonSetCondition',
    'DaemonSetConditionPatch',
    'DaemonSetSpec',
    'DaemonSetSpecPatch',
    'DaemonSetStatus',
    'DaemonSetStatusPatch',
    'DaemonSetUpdateStrategy',
    'DaemonSetUpdateStrategyPatch',
    'Deployment',
    'DeploymentCondition',
    'DeploymentConditionPatch',
    'DeploymentSpec',
    'DeploymentSpecPatch',
    'DeploymentStatus',
    'DeploymentStatusPatch',
    'DeploymentStrategy',
    'DeploymentStrategyPatch',
    'ReplicaSet',
    'ReplicaSetCondition',
    'ReplicaSetConditionPatch',
    'ReplicaSetSpec',
    'ReplicaSetSpecPatch',
    'ReplicaSetStatus',
    'ReplicaSetStatusPatch',
    'RollingUpdateDaemonSet',
    'RollingUpdateDaemonSetPatch',
    'RollingUpdateDeployment',
    'RollingUpdateDeploymentPatch',
    'RollingUpdateStatefulSetStrategy',
    'RollingUpdateStatefulSetStrategyPatch',
    'StatefulSet',
    'StatefulSetCondition',
    'StatefulSetConditionPatch',
    'StatefulSetOrdinals',
    'StatefulSetOrdinalsPatch',
    'StatefulSetPersistentVolumeClaimRetentionPolicy',
    'StatefulSetPersistentVolumeClaimRetentionPolicyPatch',
    'StatefulSetSpec',
    'StatefulSetSpecPatch',
    'StatefulSetStatus',
    'StatefulSetStatusPatch',
    'StatefulSetUpdateStrategy',
    'StatefulSetUpdateStrategyPatch',
]

@pulumi.output_type
class ControllerRevision(dict):
    """
    ControllerRevision implements an immutable snapshot of state data. Clients are responsible for serializing and deserializing the objects that contain their internal state. Once a ControllerRevision has been successfully created, it can not be updated. The API Server will fail validation of all requests that attempt to mutate the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However, it may be subject to name and representation changes in future releases, and clients should not depend on its stability. It is primarily for internal use by controllers.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ControllerRevision. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ControllerRevision.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ControllerRevision.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 revision: _builtins.int,
                 api_version: Optional[_builtins.str] = None,
                 data: Optional[Any] = None,
                 kind: Optional[_builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None):
        """
        ControllerRevision implements an immutable snapshot of state data. Clients are responsible for serializing and deserializing the objects that contain their internal state. Once a ControllerRevision has been successfully created, it can not be updated. The API Server will fail validation of all requests that attempt to mutate the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However, it may be subject to name and representation changes in future releases, and clients should not depend on its stability. It is primarily for internal use by controllers.
        :param _builtins.int revision: Revision indicates the revision of the state represented by Data.
        :param _builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param Any data: Data is the serialized representation of the state.
        :param _builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        pulumi.set(__self__, "revision", revision)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'apps/v1')
        if data is not None:
            pulumi.set(__self__, "data", data)
        if kind is not None:
            pulumi.set(__self__, "kind", 'ControllerRevision')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @_builtins.property
    @pulumi.getter
    def revision(self) -> _builtins.int:
        """
        Revision indicates the revision of the state represented by Data.
        """
        return pulumi.get(self, "revision")

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[_builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[Any]:
        """
        Data is the serialized representation of the state.
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[_builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")


@pulumi.output_type
class DaemonSet(dict):
    """
    DaemonSet represents the configuration of a daemon set.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DaemonSet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DaemonSet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DaemonSet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[_builtins.str] = None,
                 kind: Optional[_builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.DaemonSetSpec'] = None,
                 status: Optional['outputs.DaemonSetStatus'] = None):
        """
        DaemonSet represents the configuration of a daemon set.
        :param _builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param _builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param 'DaemonSetSpecArgs' spec: The desired behavior of this daemon set. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        :param 'DaemonSetStatusArgs' status: The current status of this daemon set. This data may be out of date by some window of time. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'apps/v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'DaemonSet')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[_builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[_builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional['outputs.DaemonSetSpec']:
        """
        The desired behavior of this daemon set. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "spec")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional['outputs.DaemonSetStatus']:
        """
        The current status of this daemon set. This data may be out of date by some window of time. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class DaemonSetCondition(dict):
    """
    DaemonSetCondition describes the state of a DaemonSet at a certain point.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastTransitionTime":
            suggest = "last_transition_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DaemonSetCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DaemonSetCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DaemonSetCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status: _builtins.str,
                 type: _builtins.str,
                 last_transition_time: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None):
        """
        DaemonSetCondition describes the state of a DaemonSet at a certain point.
        :param _builtins.str status: Status of the condition, one of True, False, Unknown.
        :param _builtins.str type: Type of DaemonSet condition.
        :param _builtins.str last_transition_time: Last time the condition transitioned from one status to another.
        :param _builtins.str message: A human readable message indicating details about the transition.
        :param _builtins.str reason: The reason for the condition's last transition.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of DaemonSet condition.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[_builtins.str]:
        """
        Last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        A human readable message indicating details about the transition.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        The reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")


@pulumi.output_type
class DaemonSetConditionPatch(dict):
    """
    DaemonSetCondition describes the state of a DaemonSet at a certain point.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastTransitionTime":
            suggest = "last_transition_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DaemonSetConditionPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DaemonSetConditionPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DaemonSetConditionPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_transition_time: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        DaemonSetCondition describes the state of a DaemonSet at a certain point.
        :param _builtins.str last_transition_time: Last time the condition transitioned from one status to another.
        :param _builtins.str message: A human readable message indicating details about the transition.
        :param _builtins.str reason: The reason for the condition's last transition.
        :param _builtins.str status: Status of the condition, one of True, False, Unknown.
        :param _builtins.str type: Type of DaemonSet condition.
        """
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[_builtins.str]:
        """
        Last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        A human readable message indicating details about the transition.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        The reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of DaemonSet condition.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class DaemonSetSpec(dict):
    """
    DaemonSetSpec is the specification of a daemon set.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minReadySeconds":
            suggest = "min_ready_seconds"
        elif key == "revisionHistoryLimit":
            suggest = "revision_history_limit"
        elif key == "updateStrategy":
            suggest = "update_strategy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DaemonSetSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DaemonSetSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DaemonSetSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 selector: '_meta.v1.outputs.LabelSelector',
                 template: '_core.v1.outputs.PodTemplateSpec',
                 min_ready_seconds: Optional[_builtins.int] = None,
                 revision_history_limit: Optional[_builtins.int] = None,
                 update_strategy: Optional['outputs.DaemonSetUpdateStrategy'] = None):
        """
        DaemonSetSpec is the specification of a daemon set.
        :param '_meta.v1.LabelSelectorArgs' selector: A label query over pods that are managed by the daemon set. Must match in order to be controlled. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        :param '_core.v1.PodTemplateSpecArgs' template: An object that describes the pod that will be created. The DaemonSet will create exactly one copy of this pod on every node that matches the template's node selector (or on every node if no node selector is specified). The only allowed template.spec.restartPolicy value is "Always". More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
        :param _builtins.int min_ready_seconds: The minimum number of seconds for which a newly created DaemonSet pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready).
        :param _builtins.int revision_history_limit: The number of old history to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.
        :param 'DaemonSetUpdateStrategyArgs' update_strategy: An update strategy to replace existing DaemonSet pods with new pods.
        """
        pulumi.set(__self__, "selector", selector)
        pulumi.set(__self__, "template", template)
        if min_ready_seconds is not None:
            pulumi.set(__self__, "min_ready_seconds", min_ready_seconds)
        if revision_history_limit is not None:
            pulumi.set(__self__, "revision_history_limit", revision_history_limit)
        if update_strategy is not None:
            pulumi.set(__self__, "update_strategy", update_strategy)

    @_builtins.property
    @pulumi.getter
    def selector(self) -> '_meta.v1.outputs.LabelSelector':
        """
        A label query over pods that are managed by the daemon set. Must match in order to be controlled. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        """
        return pulumi.get(self, "selector")

    @_builtins.property
    @pulumi.getter
    def template(self) -> '_core.v1.outputs.PodTemplateSpec':
        """
        An object that describes the pod that will be created. The DaemonSet will create exactly one copy of this pod on every node that matches the template's node selector (or on every node if no node selector is specified). The only allowed template.spec.restartPolicy value is "Always". More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
        """
        return pulumi.get(self, "template")

    @_builtins.property
    @pulumi.getter(name="minReadySeconds")
    def min_ready_seconds(self) -> Optional[_builtins.int]:
        """
        The minimum number of seconds for which a newly created DaemonSet pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready).
        """
        return pulumi.get(self, "min_ready_seconds")

    @_builtins.property
    @pulumi.getter(name="revisionHistoryLimit")
    def revision_history_limit(self) -> Optional[_builtins.int]:
        """
        The number of old history to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.
        """
        return pulumi.get(self, "revision_history_limit")

    @_builtins.property
    @pulumi.getter(name="updateStrategy")
    def update_strategy(self) -> Optional['outputs.DaemonSetUpdateStrategy']:
        """
        An update strategy to replace existing DaemonSet pods with new pods.
        """
        return pulumi.get(self, "update_strategy")


@pulumi.output_type
class DaemonSetSpecPatch(dict):
    """
    DaemonSetSpec is the specification of a daemon set.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minReadySeconds":
            suggest = "min_ready_seconds"
        elif key == "revisionHistoryLimit":
            suggest = "revision_history_limit"
        elif key == "updateStrategy":
            suggest = "update_strategy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DaemonSetSpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DaemonSetSpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DaemonSetSpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 min_ready_seconds: Optional[_builtins.int] = None,
                 revision_history_limit: Optional[_builtins.int] = None,
                 selector: Optional['_meta.v1.outputs.LabelSelectorPatch'] = None,
                 template: Optional['_core.v1.outputs.PodTemplateSpecPatch'] = None,
                 update_strategy: Optional['outputs.DaemonSetUpdateStrategyPatch'] = None):
        """
        DaemonSetSpec is the specification of a daemon set.
        :param _builtins.int min_ready_seconds: The minimum number of seconds for which a newly created DaemonSet pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready).
        :param _builtins.int revision_history_limit: The number of old history to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.
        :param '_meta.v1.LabelSelectorPatchArgs' selector: A label query over pods that are managed by the daemon set. Must match in order to be controlled. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        :param '_core.v1.PodTemplateSpecPatchArgs' template: An object that describes the pod that will be created. The DaemonSet will create exactly one copy of this pod on every node that matches the template's node selector (or on every node if no node selector is specified). The only allowed template.spec.restartPolicy value is "Always". More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
        :param 'DaemonSetUpdateStrategyPatchArgs' update_strategy: An update strategy to replace existing DaemonSet pods with new pods.
        """
        if min_ready_seconds is not None:
            pulumi.set(__self__, "min_ready_seconds", min_ready_seconds)
        if revision_history_limit is not None:
            pulumi.set(__self__, "revision_history_limit", revision_history_limit)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if update_strategy is not None:
            pulumi.set(__self__, "update_strategy", update_strategy)

    @_builtins.property
    @pulumi.getter(name="minReadySeconds")
    def min_ready_seconds(self) -> Optional[_builtins.int]:
        """
        The minimum number of seconds for which a newly created DaemonSet pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready).
        """
        return pulumi.get(self, "min_ready_seconds")

    @_builtins.property
    @pulumi.getter(name="revisionHistoryLimit")
    def revision_history_limit(self) -> Optional[_builtins.int]:
        """
        The number of old history to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.
        """
        return pulumi.get(self, "revision_history_limit")

    @_builtins.property
    @pulumi.getter
    def selector(self) -> Optional['_meta.v1.outputs.LabelSelectorPatch']:
        """
        A label query over pods that are managed by the daemon set. Must match in order to be controlled. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        """
        return pulumi.get(self, "selector")

    @_builtins.property
    @pulumi.getter
    def template(self) -> Optional['_core.v1.outputs.PodTemplateSpecPatch']:
        """
        An object that describes the pod that will be created. The DaemonSet will create exactly one copy of this pod on every node that matches the template's node selector (or on every node if no node selector is specified). The only allowed template.spec.restartPolicy value is "Always". More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
        """
        return pulumi.get(self, "template")

    @_builtins.property
    @pulumi.getter(name="updateStrategy")
    def update_strategy(self) -> Optional['outputs.DaemonSetUpdateStrategyPatch']:
        """
        An update strategy to replace existing DaemonSet pods with new pods.
        """
        return pulumi.get(self, "update_strategy")


@pulumi.output_type
class DaemonSetStatus(dict):
    """
    DaemonSetStatus represents the current status of a daemon set.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "currentNumberScheduled":
            suggest = "current_number_scheduled"
        elif key == "desiredNumberScheduled":
            suggest = "desired_number_scheduled"
        elif key == "numberMisscheduled":
            suggest = "number_misscheduled"
        elif key == "numberReady":
            suggest = "number_ready"
        elif key == "collisionCount":
            suggest = "collision_count"
        elif key == "numberAvailable":
            suggest = "number_available"
        elif key == "numberUnavailable":
            suggest = "number_unavailable"
        elif key == "observedGeneration":
            suggest = "observed_generation"
        elif key == "updatedNumberScheduled":
            suggest = "updated_number_scheduled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DaemonSetStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DaemonSetStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DaemonSetStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 current_number_scheduled: _builtins.int,
                 desired_number_scheduled: _builtins.int,
                 number_misscheduled: _builtins.int,
                 number_ready: _builtins.int,
                 collision_count: Optional[_builtins.int] = None,
                 conditions: Optional[Sequence['outputs.DaemonSetCondition']] = None,
                 number_available: Optional[_builtins.int] = None,
                 number_unavailable: Optional[_builtins.int] = None,
                 observed_generation: Optional[_builtins.int] = None,
                 updated_number_scheduled: Optional[_builtins.int] = None):
        """
        DaemonSetStatus represents the current status of a daemon set.
        :param _builtins.int current_number_scheduled: The number of nodes that are running at least 1 daemon pod and are supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
        :param _builtins.int desired_number_scheduled: The total number of nodes that should be running the daemon pod (including nodes correctly running the daemon pod). More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
        :param _builtins.int number_misscheduled: The number of nodes that are running the daemon pod, but are not supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
        :param _builtins.int number_ready: numberReady is the number of nodes that should be running the daemon pod and have one or more of the daemon pod running with a Ready Condition.
        :param _builtins.int collision_count: Count of hash collisions for the DaemonSet. The DaemonSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.
        :param Sequence['DaemonSetConditionArgs'] conditions: Represents the latest available observations of a DaemonSet's current state.
        :param _builtins.int number_available: The number of nodes that should be running the daemon pod and have one or more of the daemon pod running and available (ready for at least spec.minReadySeconds)
        :param _builtins.int number_unavailable: The number of nodes that should be running the daemon pod and have none of the daemon pod running and available (ready for at least spec.minReadySeconds)
        :param _builtins.int observed_generation: The most recent generation observed by the daemon set controller.
        :param _builtins.int updated_number_scheduled: The total number of nodes that are running updated daemon pod
        """
        pulumi.set(__self__, "current_number_scheduled", current_number_scheduled)
        pulumi.set(__self__, "desired_number_scheduled", desired_number_scheduled)
        pulumi.set(__self__, "number_misscheduled", number_misscheduled)
        pulumi.set(__self__, "number_ready", number_ready)
        if collision_count is not None:
            pulumi.set(__self__, "collision_count", collision_count)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if number_available is not None:
            pulumi.set(__self__, "number_available", number_available)
        if number_unavailable is not None:
            pulumi.set(__self__, "number_unavailable", number_unavailable)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if updated_number_scheduled is not None:
            pulumi.set(__self__, "updated_number_scheduled", updated_number_scheduled)

    @_builtins.property
    @pulumi.getter(name="currentNumberScheduled")
    def current_number_scheduled(self) -> _builtins.int:
        """
        The number of nodes that are running at least 1 daemon pod and are supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
        """
        return pulumi.get(self, "current_number_scheduled")

    @_builtins.property
    @pulumi.getter(name="desiredNumberScheduled")
    def desired_number_scheduled(self) -> _builtins.int:
        """
        The total number of nodes that should be running the daemon pod (including nodes correctly running the daemon pod). More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
        """
        return pulumi.get(self, "desired_number_scheduled")

    @_builtins.property
    @pulumi.getter(name="numberMisscheduled")
    def number_misscheduled(self) -> _builtins.int:
        """
        The number of nodes that are running the daemon pod, but are not supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
        """
        return pulumi.get(self, "number_misscheduled")

    @_builtins.property
    @pulumi.getter(name="numberReady")
    def number_ready(self) -> _builtins.int:
        """
        numberReady is the number of nodes that should be running the daemon pod and have one or more of the daemon pod running with a Ready Condition.
        """
        return pulumi.get(self, "number_ready")

    @_builtins.property
    @pulumi.getter(name="collisionCount")
    def collision_count(self) -> Optional[_builtins.int]:
        """
        Count of hash collisions for the DaemonSet. The DaemonSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.
        """
        return pulumi.get(self, "collision_count")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.DaemonSetCondition']]:
        """
        Represents the latest available observations of a DaemonSet's current state.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="numberAvailable")
    def number_available(self) -> Optional[_builtins.int]:
        """
        The number of nodes that should be running the daemon pod and have one or more of the daemon pod running and available (ready for at least spec.minReadySeconds)
        """
        return pulumi.get(self, "number_available")

    @_builtins.property
    @pulumi.getter(name="numberUnavailable")
    def number_unavailable(self) -> Optional[_builtins.int]:
        """
        The number of nodes that should be running the daemon pod and have none of the daemon pod running and available (ready for at least spec.minReadySeconds)
        """
        return pulumi.get(self, "number_unavailable")

    @_builtins.property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[_builtins.int]:
        """
        The most recent generation observed by the daemon set controller.
        """
        return pulumi.get(self, "observed_generation")

    @_builtins.property
    @pulumi.getter(name="updatedNumberScheduled")
    def updated_number_scheduled(self) -> Optional[_builtins.int]:
        """
        The total number of nodes that are running updated daemon pod
        """
        return pulumi.get(self, "updated_number_scheduled")


@pulumi.output_type
class DaemonSetStatusPatch(dict):
    """
    DaemonSetStatus represents the current status of a daemon set.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "collisionCount":
            suggest = "collision_count"
        elif key == "currentNumberScheduled":
            suggest = "current_number_scheduled"
        elif key == "desiredNumberScheduled":
            suggest = "desired_number_scheduled"
        elif key == "numberAvailable":
            suggest = "number_available"
        elif key == "numberMisscheduled":
            suggest = "number_misscheduled"
        elif key == "numberReady":
            suggest = "number_ready"
        elif key == "numberUnavailable":
            suggest = "number_unavailable"
        elif key == "observedGeneration":
            suggest = "observed_generation"
        elif key == "updatedNumberScheduled":
            suggest = "updated_number_scheduled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DaemonSetStatusPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DaemonSetStatusPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DaemonSetStatusPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 collision_count: Optional[_builtins.int] = None,
                 conditions: Optional[Sequence['outputs.DaemonSetConditionPatch']] = None,
                 current_number_scheduled: Optional[_builtins.int] = None,
                 desired_number_scheduled: Optional[_builtins.int] = None,
                 number_available: Optional[_builtins.int] = None,
                 number_misscheduled: Optional[_builtins.int] = None,
                 number_ready: Optional[_builtins.int] = None,
                 number_unavailable: Optional[_builtins.int] = None,
                 observed_generation: Optional[_builtins.int] = None,
                 updated_number_scheduled: Optional[_builtins.int] = None):
        """
        DaemonSetStatus represents the current status of a daemon set.
        :param _builtins.int collision_count: Count of hash collisions for the DaemonSet. The DaemonSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.
        :param Sequence['DaemonSetConditionPatchArgs'] conditions: Represents the latest available observations of a DaemonSet's current state.
        :param _builtins.int current_number_scheduled: The number of nodes that are running at least 1 daemon pod and are supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
        :param _builtins.int desired_number_scheduled: The total number of nodes that should be running the daemon pod (including nodes correctly running the daemon pod). More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
        :param _builtins.int number_available: The number of nodes that should be running the daemon pod and have one or more of the daemon pod running and available (ready for at least spec.minReadySeconds)
        :param _builtins.int number_misscheduled: The number of nodes that are running the daemon pod, but are not supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
        :param _builtins.int number_ready: numberReady is the number of nodes that should be running the daemon pod and have one or more of the daemon pod running with a Ready Condition.
        :param _builtins.int number_unavailable: The number of nodes that should be running the daemon pod and have none of the daemon pod running and available (ready for at least spec.minReadySeconds)
        :param _builtins.int observed_generation: The most recent generation observed by the daemon set controller.
        :param _builtins.int updated_number_scheduled: The total number of nodes that are running updated daemon pod
        """
        if collision_count is not None:
            pulumi.set(__self__, "collision_count", collision_count)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if current_number_scheduled is not None:
            pulumi.set(__self__, "current_number_scheduled", current_number_scheduled)
        if desired_number_scheduled is not None:
            pulumi.set(__self__, "desired_number_scheduled", desired_number_scheduled)
        if number_available is not None:
            pulumi.set(__self__, "number_available", number_available)
        if number_misscheduled is not None:
            pulumi.set(__self__, "number_misscheduled", number_misscheduled)
        if number_ready is not None:
            pulumi.set(__self__, "number_ready", number_ready)
        if number_unavailable is not None:
            pulumi.set(__self__, "number_unavailable", number_unavailable)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if updated_number_scheduled is not None:
            pulumi.set(__self__, "updated_number_scheduled", updated_number_scheduled)

    @_builtins.property
    @pulumi.getter(name="collisionCount")
    def collision_count(self) -> Optional[_builtins.int]:
        """
        Count of hash collisions for the DaemonSet. The DaemonSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.
        """
        return pulumi.get(self, "collision_count")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.DaemonSetConditionPatch']]:
        """
        Represents the latest available observations of a DaemonSet's current state.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="currentNumberScheduled")
    def current_number_scheduled(self) -> Optional[_builtins.int]:
        """
        The number of nodes that are running at least 1 daemon pod and are supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
        """
        return pulumi.get(self, "current_number_scheduled")

    @_builtins.property
    @pulumi.getter(name="desiredNumberScheduled")
    def desired_number_scheduled(self) -> Optional[_builtins.int]:
        """
        The total number of nodes that should be running the daemon pod (including nodes correctly running the daemon pod). More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
        """
        return pulumi.get(self, "desired_number_scheduled")

    @_builtins.property
    @pulumi.getter(name="numberAvailable")
    def number_available(self) -> Optional[_builtins.int]:
        """
        The number of nodes that should be running the daemon pod and have one or more of the daemon pod running and available (ready for at least spec.minReadySeconds)
        """
        return pulumi.get(self, "number_available")

    @_builtins.property
    @pulumi.getter(name="numberMisscheduled")
    def number_misscheduled(self) -> Optional[_builtins.int]:
        """
        The number of nodes that are running the daemon pod, but are not supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/
        """
        return pulumi.get(self, "number_misscheduled")

    @_builtins.property
    @pulumi.getter(name="numberReady")
    def number_ready(self) -> Optional[_builtins.int]:
        """
        numberReady is the number of nodes that should be running the daemon pod and have one or more of the daemon pod running with a Ready Condition.
        """
        return pulumi.get(self, "number_ready")

    @_builtins.property
    @pulumi.getter(name="numberUnavailable")
    def number_unavailable(self) -> Optional[_builtins.int]:
        """
        The number of nodes that should be running the daemon pod and have none of the daemon pod running and available (ready for at least spec.minReadySeconds)
        """
        return pulumi.get(self, "number_unavailable")

    @_builtins.property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[_builtins.int]:
        """
        The most recent generation observed by the daemon set controller.
        """
        return pulumi.get(self, "observed_generation")

    @_builtins.property
    @pulumi.getter(name="updatedNumberScheduled")
    def updated_number_scheduled(self) -> Optional[_builtins.int]:
        """
        The total number of nodes that are running updated daemon pod
        """
        return pulumi.get(self, "updated_number_scheduled")


@pulumi.output_type
class DaemonSetUpdateStrategy(dict):
    """
    DaemonSetUpdateStrategy is a struct used to control the update strategy for a DaemonSet.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rollingUpdate":
            suggest = "rolling_update"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DaemonSetUpdateStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DaemonSetUpdateStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DaemonSetUpdateStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rolling_update: Optional['outputs.RollingUpdateDaemonSet'] = None,
                 type: Optional[_builtins.str] = None):
        """
        DaemonSetUpdateStrategy is a struct used to control the update strategy for a DaemonSet.
        :param 'RollingUpdateDaemonSetArgs' rolling_update: Rolling update config params. Present only if type = "RollingUpdate".
        :param _builtins.str type: Type of daemon set update. Can be "RollingUpdate" or "OnDelete". Default is RollingUpdate.
        """
        if rolling_update is not None:
            pulumi.set(__self__, "rolling_update", rolling_update)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="rollingUpdate")
    def rolling_update(self) -> Optional['outputs.RollingUpdateDaemonSet']:
        """
        Rolling update config params. Present only if type = "RollingUpdate".
        """
        return pulumi.get(self, "rolling_update")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of daemon set update. Can be "RollingUpdate" or "OnDelete". Default is RollingUpdate.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class DaemonSetUpdateStrategyPatch(dict):
    """
    DaemonSetUpdateStrategy is a struct used to control the update strategy for a DaemonSet.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rollingUpdate":
            suggest = "rolling_update"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DaemonSetUpdateStrategyPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DaemonSetUpdateStrategyPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DaemonSetUpdateStrategyPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rolling_update: Optional['outputs.RollingUpdateDaemonSetPatch'] = None,
                 type: Optional[_builtins.str] = None):
        """
        DaemonSetUpdateStrategy is a struct used to control the update strategy for a DaemonSet.
        :param 'RollingUpdateDaemonSetPatchArgs' rolling_update: Rolling update config params. Present only if type = "RollingUpdate".
        :param _builtins.str type: Type of daemon set update. Can be "RollingUpdate" or "OnDelete". Default is RollingUpdate.
        """
        if rolling_update is not None:
            pulumi.set(__self__, "rolling_update", rolling_update)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="rollingUpdate")
    def rolling_update(self) -> Optional['outputs.RollingUpdateDaemonSetPatch']:
        """
        Rolling update config params. Present only if type = "RollingUpdate".
        """
        return pulumi.get(self, "rolling_update")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of daemon set update. Can be "RollingUpdate" or "OnDelete". Default is RollingUpdate.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class Deployment(dict):
    """
    Deployment enables declarative updates for Pods and ReplicaSets.

    This resource waits until its status is ready before registering success
    for create/update, and populating output properties from the current state of the resource.
    The following conditions are used to determine whether the resource creation has
    succeeded or failed:

    1. The Deployment has begun to be updated by the Deployment controller. If the current
       generation of the Deployment is > 1, then this means that the current generation must
       be different from the generation reported by the last outputs.
    2. There exists a ReplicaSet whose revision is equal to the current revision of the
       Deployment.
    3. The Deployment's '.status.conditions' has a status of type 'Available' whose 'status'
       member is set to 'True'.
    4. If the Deployment has generation > 1, then '.status.conditions' has a status of type
       'Progressing', whose 'status' member is set to 'True', and whose 'reason' is
       'NewReplicaSetAvailable'. For generation <= 1, this status field does not exist,
       because it doesn't do a rollout (i.e., it simply creates the Deployment and
       corresponding ReplicaSet), and therefore there is no rollout to mark as 'Progressing'.

    If the Deployment has not reached a Ready state after 10 minutes, it will
    time out and mark the resource update as Failed. You can override the default timeout value
    by setting the 'customTimeouts' option on the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Deployment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Deployment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Deployment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[_builtins.str] = None,
                 kind: Optional[_builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.DeploymentSpec'] = None,
                 status: Optional['outputs.DeploymentStatus'] = None):
        """
        Deployment enables declarative updates for Pods and ReplicaSets.

        This resource waits until its status is ready before registering success
        for create/update, and populating output properties from the current state of the resource.
        The following conditions are used to determine whether the resource creation has
        succeeded or failed:

        1. The Deployment has begun to be updated by the Deployment controller. If the current
           generation of the Deployment is > 1, then this means that the current generation must
           be different from the generation reported by the last outputs.
        2. There exists a ReplicaSet whose revision is equal to the current revision of the
           Deployment.
        3. The Deployment's '.status.conditions' has a status of type 'Available' whose 'status'
           member is set to 'True'.
        4. If the Deployment has generation > 1, then '.status.conditions' has a status of type
           'Progressing', whose 'status' member is set to 'True', and whose 'reason' is
           'NewReplicaSetAvailable'. For generation <= 1, this status field does not exist,
           because it doesn't do a rollout (i.e., it simply creates the Deployment and
           corresponding ReplicaSet), and therefore there is no rollout to mark as 'Progressing'.

        If the Deployment has not reached a Ready state after 10 minutes, it will
        time out and mark the resource update as Failed. You can override the default timeout value
        by setting the 'customTimeouts' option on the resource.
        :param _builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param _builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param 'DeploymentSpecArgs' spec: Specification of the desired behavior of the Deployment.
        :param 'DeploymentStatusArgs' status: Most recently observed status of the Deployment.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'apps/v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'Deployment')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[_builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[_builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional['outputs.DeploymentSpec']:
        """
        Specification of the desired behavior of the Deployment.
        """
        return pulumi.get(self, "spec")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional['outputs.DeploymentStatus']:
        """
        Most recently observed status of the Deployment.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class DeploymentCondition(dict):
    """
    DeploymentCondition describes the state of a deployment at a certain point.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastTransitionTime":
            suggest = "last_transition_time"
        elif key == "lastUpdateTime":
            suggest = "last_update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status: _builtins.str,
                 type: _builtins.str,
                 last_transition_time: Optional[_builtins.str] = None,
                 last_update_time: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None):
        """
        DeploymentCondition describes the state of a deployment at a certain point.
        :param _builtins.str status: Status of the condition, one of True, False, Unknown.
        :param _builtins.str type: Type of deployment condition.
        :param _builtins.str last_transition_time: Last time the condition transitioned from one status to another.
        :param _builtins.str last_update_time: The last time this condition was updated.
        :param _builtins.str message: A human readable message indicating details about the transition.
        :param _builtins.str reason: The reason for the condition's last transition.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if last_update_time is not None:
            pulumi.set(__self__, "last_update_time", last_update_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of deployment condition.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[_builtins.str]:
        """
        Last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @_builtins.property
    @pulumi.getter(name="lastUpdateTime")
    def last_update_time(self) -> Optional[_builtins.str]:
        """
        The last time this condition was updated.
        """
        return pulumi.get(self, "last_update_time")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        A human readable message indicating details about the transition.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        The reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")


@pulumi.output_type
class DeploymentConditionPatch(dict):
    """
    DeploymentCondition describes the state of a deployment at a certain point.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastTransitionTime":
            suggest = "last_transition_time"
        elif key == "lastUpdateTime":
            suggest = "last_update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentConditionPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentConditionPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentConditionPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_transition_time: Optional[_builtins.str] = None,
                 last_update_time: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        DeploymentCondition describes the state of a deployment at a certain point.
        :param _builtins.str last_transition_time: Last time the condition transitioned from one status to another.
        :param _builtins.str last_update_time: The last time this condition was updated.
        :param _builtins.str message: A human readable message indicating details about the transition.
        :param _builtins.str reason: The reason for the condition's last transition.
        :param _builtins.str status: Status of the condition, one of True, False, Unknown.
        :param _builtins.str type: Type of deployment condition.
        """
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if last_update_time is not None:
            pulumi.set(__self__, "last_update_time", last_update_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[_builtins.str]:
        """
        Last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @_builtins.property
    @pulumi.getter(name="lastUpdateTime")
    def last_update_time(self) -> Optional[_builtins.str]:
        """
        The last time this condition was updated.
        """
        return pulumi.get(self, "last_update_time")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        A human readable message indicating details about the transition.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        The reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of deployment condition.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class DeploymentSpec(dict):
    """
    DeploymentSpec is the specification of the desired behavior of the Deployment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minReadySeconds":
            suggest = "min_ready_seconds"
        elif key == "progressDeadlineSeconds":
            suggest = "progress_deadline_seconds"
        elif key == "revisionHistoryLimit":
            suggest = "revision_history_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 selector: '_meta.v1.outputs.LabelSelector',
                 template: '_core.v1.outputs.PodTemplateSpec',
                 min_ready_seconds: Optional[_builtins.int] = None,
                 paused: Optional[_builtins.bool] = None,
                 progress_deadline_seconds: Optional[_builtins.int] = None,
                 replicas: Optional[_builtins.int] = None,
                 revision_history_limit: Optional[_builtins.int] = None,
                 strategy: Optional['outputs.DeploymentStrategy'] = None):
        """
        DeploymentSpec is the specification of the desired behavior of the Deployment.
        :param '_meta.v1.LabelSelectorArgs' selector: Label selector for pods. Existing ReplicaSets whose pods are selected by this will be the ones affected by this deployment. It must match the pod template's labels.
        :param '_core.v1.PodTemplateSpecArgs' template: Template describes the pods that will be created. The only allowed template.spec.restartPolicy value is "Always".
        :param _builtins.int min_ready_seconds: Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        :param _builtins.bool paused: Indicates that the deployment is paused.
        :param _builtins.int progress_deadline_seconds: The maximum time in seconds for a deployment to make progress before it is considered to be failed. The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Note that progress will not be estimated during the time a deployment is paused. Defaults to 600s.
        :param _builtins.int replicas: Number of desired pods. This is a pointer to distinguish between explicit zero and not specified. Defaults to 1.
        :param _builtins.int revision_history_limit: The number of old ReplicaSets to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.
        :param 'DeploymentStrategyArgs' strategy: The deployment strategy to use to replace existing pods with new ones.
        """
        pulumi.set(__self__, "selector", selector)
        pulumi.set(__self__, "template", template)
        if min_ready_seconds is not None:
            pulumi.set(__self__, "min_ready_seconds", min_ready_seconds)
        if paused is not None:
            pulumi.set(__self__, "paused", paused)
        if progress_deadline_seconds is not None:
            pulumi.set(__self__, "progress_deadline_seconds", progress_deadline_seconds)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if revision_history_limit is not None:
            pulumi.set(__self__, "revision_history_limit", revision_history_limit)
        if strategy is not None:
            pulumi.set(__self__, "strategy", strategy)

    @_builtins.property
    @pulumi.getter
    def selector(self) -> '_meta.v1.outputs.LabelSelector':
        """
        Label selector for pods. Existing ReplicaSets whose pods are selected by this will be the ones affected by this deployment. It must match the pod template's labels.
        """
        return pulumi.get(self, "selector")

    @_builtins.property
    @pulumi.getter
    def template(self) -> '_core.v1.outputs.PodTemplateSpec':
        """
        Template describes the pods that will be created. The only allowed template.spec.restartPolicy value is "Always".
        """
        return pulumi.get(self, "template")

    @_builtins.property
    @pulumi.getter(name="minReadySeconds")
    def min_ready_seconds(self) -> Optional[_builtins.int]:
        """
        Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        """
        return pulumi.get(self, "min_ready_seconds")

    @_builtins.property
    @pulumi.getter
    def paused(self) -> Optional[_builtins.bool]:
        """
        Indicates that the deployment is paused.
        """
        return pulumi.get(self, "paused")

    @_builtins.property
    @pulumi.getter(name="progressDeadlineSeconds")
    def progress_deadline_seconds(self) -> Optional[_builtins.int]:
        """
        The maximum time in seconds for a deployment to make progress before it is considered to be failed. The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Note that progress will not be estimated during the time a deployment is paused. Defaults to 600s.
        """
        return pulumi.get(self, "progress_deadline_seconds")

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> Optional[_builtins.int]:
        """
        Number of desired pods. This is a pointer to distinguish between explicit zero and not specified. Defaults to 1.
        """
        return pulumi.get(self, "replicas")

    @_builtins.property
    @pulumi.getter(name="revisionHistoryLimit")
    def revision_history_limit(self) -> Optional[_builtins.int]:
        """
        The number of old ReplicaSets to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.
        """
        return pulumi.get(self, "revision_history_limit")

    @_builtins.property
    @pulumi.getter
    def strategy(self) -> Optional['outputs.DeploymentStrategy']:
        """
        The deployment strategy to use to replace existing pods with new ones.
        """
        return pulumi.get(self, "strategy")


@pulumi.output_type
class DeploymentSpecPatch(dict):
    """
    DeploymentSpec is the specification of the desired behavior of the Deployment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minReadySeconds":
            suggest = "min_ready_seconds"
        elif key == "progressDeadlineSeconds":
            suggest = "progress_deadline_seconds"
        elif key == "revisionHistoryLimit":
            suggest = "revision_history_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentSpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentSpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentSpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 min_ready_seconds: Optional[_builtins.int] = None,
                 paused: Optional[_builtins.bool] = None,
                 progress_deadline_seconds: Optional[_builtins.int] = None,
                 replicas: Optional[_builtins.int] = None,
                 revision_history_limit: Optional[_builtins.int] = None,
                 selector: Optional['_meta.v1.outputs.LabelSelectorPatch'] = None,
                 strategy: Optional['outputs.DeploymentStrategyPatch'] = None,
                 template: Optional['_core.v1.outputs.PodTemplateSpecPatch'] = None):
        """
        DeploymentSpec is the specification of the desired behavior of the Deployment.
        :param _builtins.int min_ready_seconds: Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        :param _builtins.bool paused: Indicates that the deployment is paused.
        :param _builtins.int progress_deadline_seconds: The maximum time in seconds for a deployment to make progress before it is considered to be failed. The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Note that progress will not be estimated during the time a deployment is paused. Defaults to 600s.
        :param _builtins.int replicas: Number of desired pods. This is a pointer to distinguish between explicit zero and not specified. Defaults to 1.
        :param _builtins.int revision_history_limit: The number of old ReplicaSets to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.
        :param '_meta.v1.LabelSelectorPatchArgs' selector: Label selector for pods. Existing ReplicaSets whose pods are selected by this will be the ones affected by this deployment. It must match the pod template's labels.
        :param 'DeploymentStrategyPatchArgs' strategy: The deployment strategy to use to replace existing pods with new ones.
        :param '_core.v1.PodTemplateSpecPatchArgs' template: Template describes the pods that will be created. The only allowed template.spec.restartPolicy value is "Always".
        """
        if min_ready_seconds is not None:
            pulumi.set(__self__, "min_ready_seconds", min_ready_seconds)
        if paused is not None:
            pulumi.set(__self__, "paused", paused)
        if progress_deadline_seconds is not None:
            pulumi.set(__self__, "progress_deadline_seconds", progress_deadline_seconds)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if revision_history_limit is not None:
            pulumi.set(__self__, "revision_history_limit", revision_history_limit)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if strategy is not None:
            pulumi.set(__self__, "strategy", strategy)
        if template is not None:
            pulumi.set(__self__, "template", template)

    @_builtins.property
    @pulumi.getter(name="minReadySeconds")
    def min_ready_seconds(self) -> Optional[_builtins.int]:
        """
        Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        """
        return pulumi.get(self, "min_ready_seconds")

    @_builtins.property
    @pulumi.getter
    def paused(self) -> Optional[_builtins.bool]:
        """
        Indicates that the deployment is paused.
        """
        return pulumi.get(self, "paused")

    @_builtins.property
    @pulumi.getter(name="progressDeadlineSeconds")
    def progress_deadline_seconds(self) -> Optional[_builtins.int]:
        """
        The maximum time in seconds for a deployment to make progress before it is considered to be failed. The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Note that progress will not be estimated during the time a deployment is paused. Defaults to 600s.
        """
        return pulumi.get(self, "progress_deadline_seconds")

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> Optional[_builtins.int]:
        """
        Number of desired pods. This is a pointer to distinguish between explicit zero and not specified. Defaults to 1.
        """
        return pulumi.get(self, "replicas")

    @_builtins.property
    @pulumi.getter(name="revisionHistoryLimit")
    def revision_history_limit(self) -> Optional[_builtins.int]:
        """
        The number of old ReplicaSets to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.
        """
        return pulumi.get(self, "revision_history_limit")

    @_builtins.property
    @pulumi.getter
    def selector(self) -> Optional['_meta.v1.outputs.LabelSelectorPatch']:
        """
        Label selector for pods. Existing ReplicaSets whose pods are selected by this will be the ones affected by this deployment. It must match the pod template's labels.
        """
        return pulumi.get(self, "selector")

    @_builtins.property
    @pulumi.getter
    def strategy(self) -> Optional['outputs.DeploymentStrategyPatch']:
        """
        The deployment strategy to use to replace existing pods with new ones.
        """
        return pulumi.get(self, "strategy")

    @_builtins.property
    @pulumi.getter
    def template(self) -> Optional['_core.v1.outputs.PodTemplateSpecPatch']:
        """
        Template describes the pods that will be created. The only allowed template.spec.restartPolicy value is "Always".
        """
        return pulumi.get(self, "template")


@pulumi.output_type
class DeploymentStatus(dict):
    """
    DeploymentStatus is the most recently observed status of the Deployment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availableReplicas":
            suggest = "available_replicas"
        elif key == "collisionCount":
            suggest = "collision_count"
        elif key == "observedGeneration":
            suggest = "observed_generation"
        elif key == "readyReplicas":
            suggest = "ready_replicas"
        elif key == "terminatingReplicas":
            suggest = "terminating_replicas"
        elif key == "unavailableReplicas":
            suggest = "unavailable_replicas"
        elif key == "updatedReplicas":
            suggest = "updated_replicas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 available_replicas: Optional[_builtins.int] = None,
                 collision_count: Optional[_builtins.int] = None,
                 conditions: Optional[Sequence['outputs.DeploymentCondition']] = None,
                 observed_generation: Optional[_builtins.int] = None,
                 ready_replicas: Optional[_builtins.int] = None,
                 replicas: Optional[_builtins.int] = None,
                 terminating_replicas: Optional[_builtins.int] = None,
                 unavailable_replicas: Optional[_builtins.int] = None,
                 updated_replicas: Optional[_builtins.int] = None):
        """
        DeploymentStatus is the most recently observed status of the Deployment.
        :param _builtins.int available_replicas: Total number of available non-terminating pods (ready for at least minReadySeconds) targeted by this deployment.
        :param _builtins.int collision_count: Count of hash collisions for the Deployment. The Deployment controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ReplicaSet.
        :param Sequence['DeploymentConditionArgs'] conditions: Represents the latest available observations of a deployment's current state.
        :param _builtins.int observed_generation: The generation observed by the deployment controller.
        :param _builtins.int ready_replicas: Total number of non-terminating pods targeted by this Deployment with a Ready Condition.
        :param _builtins.int replicas: Total number of non-terminating pods targeted by this deployment (their labels match the selector).
        :param _builtins.int terminating_replicas: Total number of terminating pods targeted by this deployment. Terminating pods have a non-null .metadata.deletionTimestamp and have not yet reached the Failed or Succeeded .status.phase.
               
               This is an alpha field. Enable DeploymentReplicaSetTerminatingReplicas to be able to use this field.
        :param _builtins.int unavailable_replicas: Total number of unavailable pods targeted by this deployment. This is the total number of pods that are still required for the deployment to have 100% available capacity. They may either be pods that are running but not yet available or pods that still have not been created.
        :param _builtins.int updated_replicas: Total number of non-terminating pods targeted by this deployment that have the desired template spec.
        """
        if available_replicas is not None:
            pulumi.set(__self__, "available_replicas", available_replicas)
        if collision_count is not None:
            pulumi.set(__self__, "collision_count", collision_count)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if ready_replicas is not None:
            pulumi.set(__self__, "ready_replicas", ready_replicas)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if terminating_replicas is not None:
            pulumi.set(__self__, "terminating_replicas", terminating_replicas)
        if unavailable_replicas is not None:
            pulumi.set(__self__, "unavailable_replicas", unavailable_replicas)
        if updated_replicas is not None:
            pulumi.set(__self__, "updated_replicas", updated_replicas)

    @_builtins.property
    @pulumi.getter(name="availableReplicas")
    def available_replicas(self) -> Optional[_builtins.int]:
        """
        Total number of available non-terminating pods (ready for at least minReadySeconds) targeted by this deployment.
        """
        return pulumi.get(self, "available_replicas")

    @_builtins.property
    @pulumi.getter(name="collisionCount")
    def collision_count(self) -> Optional[_builtins.int]:
        """
        Count of hash collisions for the Deployment. The Deployment controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ReplicaSet.
        """
        return pulumi.get(self, "collision_count")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.DeploymentCondition']]:
        """
        Represents the latest available observations of a deployment's current state.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[_builtins.int]:
        """
        The generation observed by the deployment controller.
        """
        return pulumi.get(self, "observed_generation")

    @_builtins.property
    @pulumi.getter(name="readyReplicas")
    def ready_replicas(self) -> Optional[_builtins.int]:
        """
        Total number of non-terminating pods targeted by this Deployment with a Ready Condition.
        """
        return pulumi.get(self, "ready_replicas")

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> Optional[_builtins.int]:
        """
        Total number of non-terminating pods targeted by this deployment (their labels match the selector).
        """
        return pulumi.get(self, "replicas")

    @_builtins.property
    @pulumi.getter(name="terminatingReplicas")
    def terminating_replicas(self) -> Optional[_builtins.int]:
        """
        Total number of terminating pods targeted by this deployment. Terminating pods have a non-null .metadata.deletionTimestamp and have not yet reached the Failed or Succeeded .status.phase.

        This is an alpha field. Enable DeploymentReplicaSetTerminatingReplicas to be able to use this field.
        """
        return pulumi.get(self, "terminating_replicas")

    @_builtins.property
    @pulumi.getter(name="unavailableReplicas")
    def unavailable_replicas(self) -> Optional[_builtins.int]:
        """
        Total number of unavailable pods targeted by this deployment. This is the total number of pods that are still required for the deployment to have 100% available capacity. They may either be pods that are running but not yet available or pods that still have not been created.
        """
        return pulumi.get(self, "unavailable_replicas")

    @_builtins.property
    @pulumi.getter(name="updatedReplicas")
    def updated_replicas(self) -> Optional[_builtins.int]:
        """
        Total number of non-terminating pods targeted by this deployment that have the desired template spec.
        """
        return pulumi.get(self, "updated_replicas")


@pulumi.output_type
class DeploymentStatusPatch(dict):
    """
    DeploymentStatus is the most recently observed status of the Deployment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availableReplicas":
            suggest = "available_replicas"
        elif key == "collisionCount":
            suggest = "collision_count"
        elif key == "observedGeneration":
            suggest = "observed_generation"
        elif key == "readyReplicas":
            suggest = "ready_replicas"
        elif key == "terminatingReplicas":
            suggest = "terminating_replicas"
        elif key == "unavailableReplicas":
            suggest = "unavailable_replicas"
        elif key == "updatedReplicas":
            suggest = "updated_replicas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentStatusPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentStatusPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentStatusPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 available_replicas: Optional[_builtins.int] = None,
                 collision_count: Optional[_builtins.int] = None,
                 conditions: Optional[Sequence['outputs.DeploymentConditionPatch']] = None,
                 observed_generation: Optional[_builtins.int] = None,
                 ready_replicas: Optional[_builtins.int] = None,
                 replicas: Optional[_builtins.int] = None,
                 terminating_replicas: Optional[_builtins.int] = None,
                 unavailable_replicas: Optional[_builtins.int] = None,
                 updated_replicas: Optional[_builtins.int] = None):
        """
        DeploymentStatus is the most recently observed status of the Deployment.
        :param _builtins.int available_replicas: Total number of available non-terminating pods (ready for at least minReadySeconds) targeted by this deployment.
        :param _builtins.int collision_count: Count of hash collisions for the Deployment. The Deployment controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ReplicaSet.
        :param Sequence['DeploymentConditionPatchArgs'] conditions: Represents the latest available observations of a deployment's current state.
        :param _builtins.int observed_generation: The generation observed by the deployment controller.
        :param _builtins.int ready_replicas: Total number of non-terminating pods targeted by this Deployment with a Ready Condition.
        :param _builtins.int replicas: Total number of non-terminating pods targeted by this deployment (their labels match the selector).
        :param _builtins.int terminating_replicas: Total number of terminating pods targeted by this deployment. Terminating pods have a non-null .metadata.deletionTimestamp and have not yet reached the Failed or Succeeded .status.phase.
               
               This is an alpha field. Enable DeploymentReplicaSetTerminatingReplicas to be able to use this field.
        :param _builtins.int unavailable_replicas: Total number of unavailable pods targeted by this deployment. This is the total number of pods that are still required for the deployment to have 100% available capacity. They may either be pods that are running but not yet available or pods that still have not been created.
        :param _builtins.int updated_replicas: Total number of non-terminating pods targeted by this deployment that have the desired template spec.
        """
        if available_replicas is not None:
            pulumi.set(__self__, "available_replicas", available_replicas)
        if collision_count is not None:
            pulumi.set(__self__, "collision_count", collision_count)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if ready_replicas is not None:
            pulumi.set(__self__, "ready_replicas", ready_replicas)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if terminating_replicas is not None:
            pulumi.set(__self__, "terminating_replicas", terminating_replicas)
        if unavailable_replicas is not None:
            pulumi.set(__self__, "unavailable_replicas", unavailable_replicas)
        if updated_replicas is not None:
            pulumi.set(__self__, "updated_replicas", updated_replicas)

    @_builtins.property
    @pulumi.getter(name="availableReplicas")
    def available_replicas(self) -> Optional[_builtins.int]:
        """
        Total number of available non-terminating pods (ready for at least minReadySeconds) targeted by this deployment.
        """
        return pulumi.get(self, "available_replicas")

    @_builtins.property
    @pulumi.getter(name="collisionCount")
    def collision_count(self) -> Optional[_builtins.int]:
        """
        Count of hash collisions for the Deployment. The Deployment controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ReplicaSet.
        """
        return pulumi.get(self, "collision_count")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.DeploymentConditionPatch']]:
        """
        Represents the latest available observations of a deployment's current state.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[_builtins.int]:
        """
        The generation observed by the deployment controller.
        """
        return pulumi.get(self, "observed_generation")

    @_builtins.property
    @pulumi.getter(name="readyReplicas")
    def ready_replicas(self) -> Optional[_builtins.int]:
        """
        Total number of non-terminating pods targeted by this Deployment with a Ready Condition.
        """
        return pulumi.get(self, "ready_replicas")

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> Optional[_builtins.int]:
        """
        Total number of non-terminating pods targeted by this deployment (their labels match the selector).
        """
        return pulumi.get(self, "replicas")

    @_builtins.property
    @pulumi.getter(name="terminatingReplicas")
    def terminating_replicas(self) -> Optional[_builtins.int]:
        """
        Total number of terminating pods targeted by this deployment. Terminating pods have a non-null .metadata.deletionTimestamp and have not yet reached the Failed or Succeeded .status.phase.

        This is an alpha field. Enable DeploymentReplicaSetTerminatingReplicas to be able to use this field.
        """
        return pulumi.get(self, "terminating_replicas")

    @_builtins.property
    @pulumi.getter(name="unavailableReplicas")
    def unavailable_replicas(self) -> Optional[_builtins.int]:
        """
        Total number of unavailable pods targeted by this deployment. This is the total number of pods that are still required for the deployment to have 100% available capacity. They may either be pods that are running but not yet available or pods that still have not been created.
        """
        return pulumi.get(self, "unavailable_replicas")

    @_builtins.property
    @pulumi.getter(name="updatedReplicas")
    def updated_replicas(self) -> Optional[_builtins.int]:
        """
        Total number of non-terminating pods targeted by this deployment that have the desired template spec.
        """
        return pulumi.get(self, "updated_replicas")


@pulumi.output_type
class DeploymentStrategy(dict):
    """
    DeploymentStrategy describes how to replace existing pods with new ones.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rollingUpdate":
            suggest = "rolling_update"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rolling_update: Optional['outputs.RollingUpdateDeployment'] = None,
                 type: Optional[_builtins.str] = None):
        """
        DeploymentStrategy describes how to replace existing pods with new ones.
        :param 'RollingUpdateDeploymentArgs' rolling_update: Rolling update config params. Present only if DeploymentStrategyType = RollingUpdate.
        :param _builtins.str type: Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
        """
        if rolling_update is not None:
            pulumi.set(__self__, "rolling_update", rolling_update)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="rollingUpdate")
    def rolling_update(self) -> Optional['outputs.RollingUpdateDeployment']:
        """
        Rolling update config params. Present only if DeploymentStrategyType = RollingUpdate.
        """
        return pulumi.get(self, "rolling_update")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class DeploymentStrategyPatch(dict):
    """
    DeploymentStrategy describes how to replace existing pods with new ones.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rollingUpdate":
            suggest = "rolling_update"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentStrategyPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentStrategyPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentStrategyPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rolling_update: Optional['outputs.RollingUpdateDeploymentPatch'] = None,
                 type: Optional[_builtins.str] = None):
        """
        DeploymentStrategy describes how to replace existing pods with new ones.
        :param 'RollingUpdateDeploymentPatchArgs' rolling_update: Rolling update config params. Present only if DeploymentStrategyType = RollingUpdate.
        :param _builtins.str type: Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
        """
        if rolling_update is not None:
            pulumi.set(__self__, "rolling_update", rolling_update)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="rollingUpdate")
    def rolling_update(self) -> Optional['outputs.RollingUpdateDeploymentPatch']:
        """
        Rolling update config params. Present only if DeploymentStrategyType = RollingUpdate.
        """
        return pulumi.get(self, "rolling_update")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ReplicaSet(dict):
    """
    ReplicaSet ensures that a specified number of pod replicas are running at any given time.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicaSet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicaSet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicaSet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[_builtins.str] = None,
                 kind: Optional[_builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.ReplicaSetSpec'] = None,
                 status: Optional['outputs.ReplicaSetStatus'] = None):
        """
        ReplicaSet ensures that a specified number of pod replicas are running at any given time.
        :param _builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param _builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: If the Labels of a ReplicaSet are empty, they are defaulted to be the same as the Pod(s) that the ReplicaSet manages. Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param 'ReplicaSetSpecArgs' spec: Spec defines the specification of the desired behavior of the ReplicaSet. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        :param 'ReplicaSetStatusArgs' status: Status is the most recently observed status of the ReplicaSet. This data may be out of date by some window of time. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'apps/v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'ReplicaSet')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[_builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[_builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        If the Labels of a ReplicaSet are empty, they are defaulted to be the same as the Pod(s) that the ReplicaSet manages. Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional['outputs.ReplicaSetSpec']:
        """
        Spec defines the specification of the desired behavior of the ReplicaSet. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "spec")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional['outputs.ReplicaSetStatus']:
        """
        Status is the most recently observed status of the ReplicaSet. This data may be out of date by some window of time. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ReplicaSetCondition(dict):
    """
    ReplicaSetCondition describes the state of a replica set at a certain point.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastTransitionTime":
            suggest = "last_transition_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicaSetCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicaSetCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicaSetCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status: _builtins.str,
                 type: _builtins.str,
                 last_transition_time: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None):
        """
        ReplicaSetCondition describes the state of a replica set at a certain point.
        :param _builtins.str status: Status of the condition, one of True, False, Unknown.
        :param _builtins.str type: Type of replica set condition.
        :param _builtins.str last_transition_time: The last time the condition transitioned from one status to another.
        :param _builtins.str message: A human readable message indicating details about the transition.
        :param _builtins.str reason: The reason for the condition's last transition.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of replica set condition.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[_builtins.str]:
        """
        The last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        A human readable message indicating details about the transition.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        The reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")


@pulumi.output_type
class ReplicaSetConditionPatch(dict):
    """
    ReplicaSetCondition describes the state of a replica set at a certain point.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastTransitionTime":
            suggest = "last_transition_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicaSetConditionPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicaSetConditionPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicaSetConditionPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_transition_time: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        ReplicaSetCondition describes the state of a replica set at a certain point.
        :param _builtins.str last_transition_time: The last time the condition transitioned from one status to another.
        :param _builtins.str message: A human readable message indicating details about the transition.
        :param _builtins.str reason: The reason for the condition's last transition.
        :param _builtins.str status: Status of the condition, one of True, False, Unknown.
        :param _builtins.str type: Type of replica set condition.
        """
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[_builtins.str]:
        """
        The last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        A human readable message indicating details about the transition.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        The reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of replica set condition.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ReplicaSetSpec(dict):
    """
    ReplicaSetSpec is the specification of a ReplicaSet.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minReadySeconds":
            suggest = "min_ready_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicaSetSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicaSetSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicaSetSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 selector: '_meta.v1.outputs.LabelSelector',
                 min_ready_seconds: Optional[_builtins.int] = None,
                 replicas: Optional[_builtins.int] = None,
                 template: Optional['_core.v1.outputs.PodTemplateSpec'] = None):
        """
        ReplicaSetSpec is the specification of a ReplicaSet.
        :param '_meta.v1.LabelSelectorArgs' selector: Selector is a label query over pods that should match the replica count. Label keys and values that must match in order to be controlled by this replica set. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        :param _builtins.int min_ready_seconds: Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        :param _builtins.int replicas: Replicas is the number of desired pods. This is a pointer to distinguish between explicit zero and unspecified. Defaults to 1. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicaset
        :param '_core.v1.PodTemplateSpecArgs' template: Template is the object that describes the pod that will be created if insufficient replicas are detected. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicaset/#pod-template
        """
        pulumi.set(__self__, "selector", selector)
        if min_ready_seconds is not None:
            pulumi.set(__self__, "min_ready_seconds", min_ready_seconds)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if template is not None:
            pulumi.set(__self__, "template", template)

    @_builtins.property
    @pulumi.getter
    def selector(self) -> '_meta.v1.outputs.LabelSelector':
        """
        Selector is a label query over pods that should match the replica count. Label keys and values that must match in order to be controlled by this replica set. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        """
        return pulumi.get(self, "selector")

    @_builtins.property
    @pulumi.getter(name="minReadySeconds")
    def min_ready_seconds(self) -> Optional[_builtins.int]:
        """
        Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        """
        return pulumi.get(self, "min_ready_seconds")

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> Optional[_builtins.int]:
        """
        Replicas is the number of desired pods. This is a pointer to distinguish between explicit zero and unspecified. Defaults to 1. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicaset
        """
        return pulumi.get(self, "replicas")

    @_builtins.property
    @pulumi.getter
    def template(self) -> Optional['_core.v1.outputs.PodTemplateSpec']:
        """
        Template is the object that describes the pod that will be created if insufficient replicas are detected. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicaset/#pod-template
        """
        return pulumi.get(self, "template")


@pulumi.output_type
class ReplicaSetSpecPatch(dict):
    """
    ReplicaSetSpec is the specification of a ReplicaSet.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minReadySeconds":
            suggest = "min_ready_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicaSetSpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicaSetSpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicaSetSpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 min_ready_seconds: Optional[_builtins.int] = None,
                 replicas: Optional[_builtins.int] = None,
                 selector: Optional['_meta.v1.outputs.LabelSelectorPatch'] = None,
                 template: Optional['_core.v1.outputs.PodTemplateSpecPatch'] = None):
        """
        ReplicaSetSpec is the specification of a ReplicaSet.
        :param _builtins.int min_ready_seconds: Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        :param _builtins.int replicas: Replicas is the number of desired pods. This is a pointer to distinguish between explicit zero and unspecified. Defaults to 1. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicaset
        :param '_meta.v1.LabelSelectorPatchArgs' selector: Selector is a label query over pods that should match the replica count. Label keys and values that must match in order to be controlled by this replica set. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        :param '_core.v1.PodTemplateSpecPatchArgs' template: Template is the object that describes the pod that will be created if insufficient replicas are detected. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicaset/#pod-template
        """
        if min_ready_seconds is not None:
            pulumi.set(__self__, "min_ready_seconds", min_ready_seconds)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if template is not None:
            pulumi.set(__self__, "template", template)

    @_builtins.property
    @pulumi.getter(name="minReadySeconds")
    def min_ready_seconds(self) -> Optional[_builtins.int]:
        """
        Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        """
        return pulumi.get(self, "min_ready_seconds")

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> Optional[_builtins.int]:
        """
        Replicas is the number of desired pods. This is a pointer to distinguish between explicit zero and unspecified. Defaults to 1. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicaset
        """
        return pulumi.get(self, "replicas")

    @_builtins.property
    @pulumi.getter
    def selector(self) -> Optional['_meta.v1.outputs.LabelSelectorPatch']:
        """
        Selector is a label query over pods that should match the replica count. Label keys and values that must match in order to be controlled by this replica set. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        """
        return pulumi.get(self, "selector")

    @_builtins.property
    @pulumi.getter
    def template(self) -> Optional['_core.v1.outputs.PodTemplateSpecPatch']:
        """
        Template is the object that describes the pod that will be created if insufficient replicas are detected. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicaset/#pod-template
        """
        return pulumi.get(self, "template")


@pulumi.output_type
class ReplicaSetStatus(dict):
    """
    ReplicaSetStatus represents the current status of a ReplicaSet.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availableReplicas":
            suggest = "available_replicas"
        elif key == "fullyLabeledReplicas":
            suggest = "fully_labeled_replicas"
        elif key == "observedGeneration":
            suggest = "observed_generation"
        elif key == "readyReplicas":
            suggest = "ready_replicas"
        elif key == "terminatingReplicas":
            suggest = "terminating_replicas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicaSetStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicaSetStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicaSetStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 replicas: _builtins.int,
                 available_replicas: Optional[_builtins.int] = None,
                 conditions: Optional[Sequence['outputs.ReplicaSetCondition']] = None,
                 fully_labeled_replicas: Optional[_builtins.int] = None,
                 observed_generation: Optional[_builtins.int] = None,
                 ready_replicas: Optional[_builtins.int] = None,
                 terminating_replicas: Optional[_builtins.int] = None):
        """
        ReplicaSetStatus represents the current status of a ReplicaSet.
        :param _builtins.int replicas: Replicas is the most recently observed number of non-terminating pods. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicaset
        :param _builtins.int available_replicas: The number of available non-terminating pods (ready for at least minReadySeconds) for this replica set.
        :param Sequence['ReplicaSetConditionArgs'] conditions: Represents the latest available observations of a replica set's current state.
        :param _builtins.int fully_labeled_replicas: The number of non-terminating pods that have labels matching the labels of the pod template of the replicaset.
        :param _builtins.int observed_generation: ObservedGeneration reflects the generation of the most recently observed ReplicaSet.
        :param _builtins.int ready_replicas: The number of non-terminating pods targeted by this ReplicaSet with a Ready Condition.
        :param _builtins.int terminating_replicas: The number of terminating pods for this replica set. Terminating pods have a non-null .metadata.deletionTimestamp and have not yet reached the Failed or Succeeded .status.phase.
               
               This is an alpha field. Enable DeploymentReplicaSetTerminatingReplicas to be able to use this field.
        """
        pulumi.set(__self__, "replicas", replicas)
        if available_replicas is not None:
            pulumi.set(__self__, "available_replicas", available_replicas)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if fully_labeled_replicas is not None:
            pulumi.set(__self__, "fully_labeled_replicas", fully_labeled_replicas)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if ready_replicas is not None:
            pulumi.set(__self__, "ready_replicas", ready_replicas)
        if terminating_replicas is not None:
            pulumi.set(__self__, "terminating_replicas", terminating_replicas)

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> _builtins.int:
        """
        Replicas is the most recently observed number of non-terminating pods. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicaset
        """
        return pulumi.get(self, "replicas")

    @_builtins.property
    @pulumi.getter(name="availableReplicas")
    def available_replicas(self) -> Optional[_builtins.int]:
        """
        The number of available non-terminating pods (ready for at least minReadySeconds) for this replica set.
        """
        return pulumi.get(self, "available_replicas")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.ReplicaSetCondition']]:
        """
        Represents the latest available observations of a replica set's current state.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="fullyLabeledReplicas")
    def fully_labeled_replicas(self) -> Optional[_builtins.int]:
        """
        The number of non-terminating pods that have labels matching the labels of the pod template of the replicaset.
        """
        return pulumi.get(self, "fully_labeled_replicas")

    @_builtins.property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[_builtins.int]:
        """
        ObservedGeneration reflects the generation of the most recently observed ReplicaSet.
        """
        return pulumi.get(self, "observed_generation")

    @_builtins.property
    @pulumi.getter(name="readyReplicas")
    def ready_replicas(self) -> Optional[_builtins.int]:
        """
        The number of non-terminating pods targeted by this ReplicaSet with a Ready Condition.
        """
        return pulumi.get(self, "ready_replicas")

    @_builtins.property
    @pulumi.getter(name="terminatingReplicas")
    def terminating_replicas(self) -> Optional[_builtins.int]:
        """
        The number of terminating pods for this replica set. Terminating pods have a non-null .metadata.deletionTimestamp and have not yet reached the Failed or Succeeded .status.phase.

        This is an alpha field. Enable DeploymentReplicaSetTerminatingReplicas to be able to use this field.
        """
        return pulumi.get(self, "terminating_replicas")


@pulumi.output_type
class ReplicaSetStatusPatch(dict):
    """
    ReplicaSetStatus represents the current status of a ReplicaSet.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availableReplicas":
            suggest = "available_replicas"
        elif key == "fullyLabeledReplicas":
            suggest = "fully_labeled_replicas"
        elif key == "observedGeneration":
            suggest = "observed_generation"
        elif key == "readyReplicas":
            suggest = "ready_replicas"
        elif key == "terminatingReplicas":
            suggest = "terminating_replicas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicaSetStatusPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicaSetStatusPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicaSetStatusPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 available_replicas: Optional[_builtins.int] = None,
                 conditions: Optional[Sequence['outputs.ReplicaSetConditionPatch']] = None,
                 fully_labeled_replicas: Optional[_builtins.int] = None,
                 observed_generation: Optional[_builtins.int] = None,
                 ready_replicas: Optional[_builtins.int] = None,
                 replicas: Optional[_builtins.int] = None,
                 terminating_replicas: Optional[_builtins.int] = None):
        """
        ReplicaSetStatus represents the current status of a ReplicaSet.
        :param _builtins.int available_replicas: The number of available non-terminating pods (ready for at least minReadySeconds) for this replica set.
        :param Sequence['ReplicaSetConditionPatchArgs'] conditions: Represents the latest available observations of a replica set's current state.
        :param _builtins.int fully_labeled_replicas: The number of non-terminating pods that have labels matching the labels of the pod template of the replicaset.
        :param _builtins.int observed_generation: ObservedGeneration reflects the generation of the most recently observed ReplicaSet.
        :param _builtins.int ready_replicas: The number of non-terminating pods targeted by this ReplicaSet with a Ready Condition.
        :param _builtins.int replicas: Replicas is the most recently observed number of non-terminating pods. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicaset
        :param _builtins.int terminating_replicas: The number of terminating pods for this replica set. Terminating pods have a non-null .metadata.deletionTimestamp and have not yet reached the Failed or Succeeded .status.phase.
               
               This is an alpha field. Enable DeploymentReplicaSetTerminatingReplicas to be able to use this field.
        """
        if available_replicas is not None:
            pulumi.set(__self__, "available_replicas", available_replicas)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if fully_labeled_replicas is not None:
            pulumi.set(__self__, "fully_labeled_replicas", fully_labeled_replicas)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if ready_replicas is not None:
            pulumi.set(__self__, "ready_replicas", ready_replicas)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if terminating_replicas is not None:
            pulumi.set(__self__, "terminating_replicas", terminating_replicas)

    @_builtins.property
    @pulumi.getter(name="availableReplicas")
    def available_replicas(self) -> Optional[_builtins.int]:
        """
        The number of available non-terminating pods (ready for at least minReadySeconds) for this replica set.
        """
        return pulumi.get(self, "available_replicas")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.ReplicaSetConditionPatch']]:
        """
        Represents the latest available observations of a replica set's current state.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="fullyLabeledReplicas")
    def fully_labeled_replicas(self) -> Optional[_builtins.int]:
        """
        The number of non-terminating pods that have labels matching the labels of the pod template of the replicaset.
        """
        return pulumi.get(self, "fully_labeled_replicas")

    @_builtins.property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[_builtins.int]:
        """
        ObservedGeneration reflects the generation of the most recently observed ReplicaSet.
        """
        return pulumi.get(self, "observed_generation")

    @_builtins.property
    @pulumi.getter(name="readyReplicas")
    def ready_replicas(self) -> Optional[_builtins.int]:
        """
        The number of non-terminating pods targeted by this ReplicaSet with a Ready Condition.
        """
        return pulumi.get(self, "ready_replicas")

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> Optional[_builtins.int]:
        """
        Replicas is the most recently observed number of non-terminating pods. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicaset
        """
        return pulumi.get(self, "replicas")

    @_builtins.property
    @pulumi.getter(name="terminatingReplicas")
    def terminating_replicas(self) -> Optional[_builtins.int]:
        """
        The number of terminating pods for this replica set. Terminating pods have a non-null .metadata.deletionTimestamp and have not yet reached the Failed or Succeeded .status.phase.

        This is an alpha field. Enable DeploymentReplicaSetTerminatingReplicas to be able to use this field.
        """
        return pulumi.get(self, "terminating_replicas")


@pulumi.output_type
class RollingUpdateDaemonSet(dict):
    """
    Spec to control the desired behavior of daemon set rolling update.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxSurge":
            suggest = "max_surge"
        elif key == "maxUnavailable":
            suggest = "max_unavailable"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RollingUpdateDaemonSet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RollingUpdateDaemonSet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RollingUpdateDaemonSet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_surge: Optional[Any] = None,
                 max_unavailable: Optional[Any] = None):
        """
        Spec to control the desired behavior of daemon set rolling update.
        :param Union[_builtins.int, _builtins.str] max_surge: The maximum number of nodes with an existing available DaemonSet pod that can have an updated DaemonSet pod during during an update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up to a minimum of 1. Default value is 0. Example: when this is set to 30%, at most 30% of the total number of nodes that should be running the daemon pod (i.e. status.desiredNumberScheduled) can have their a new pod created before the old pod is marked as deleted. The update starts by launching new pods on 30% of nodes. Once an updated pod is available (Ready for at least minReadySeconds) the old DaemonSet pod on that node is marked deleted. If the old pod becomes unavailable for any reason (Ready transitions to false, is evicted, or is drained) an updated pod is immediatedly created on that node without considering surge limits. Allowing surge implies the possibility that the resources consumed by the daemonset on any given node can double if the readiness check fails, and so resource intensive daemonsets should take into account that they may cause evictions during disruption.
        :param Union[_builtins.int, _builtins.str] max_unavailable: The maximum number of DaemonSet pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of total number of DaemonSet pods at the start of the update (ex: 10%). Absolute number is calculated from percentage by rounding up. This cannot be 0 if MaxSurge is 0 Default value is 1. Example: when this is set to 30%, at most 30% of the total number of nodes that should be running the daemon pod (i.e. status.desiredNumberScheduled) can have their pods stopped for an update at any given time. The update starts by stopping at most 30% of those DaemonSet pods and then brings up new DaemonSet pods in their place. Once the new pods are available, it then proceeds onto other DaemonSet pods, thus ensuring that at least 70% of original number of DaemonSet pods are available at all times during the update.
        """
        if max_surge is not None:
            pulumi.set(__self__, "max_surge", max_surge)
        if max_unavailable is not None:
            pulumi.set(__self__, "max_unavailable", max_unavailable)

    @_builtins.property
    @pulumi.getter(name="maxSurge")
    def max_surge(self) -> Optional[Any]:
        """
        The maximum number of nodes with an existing available DaemonSet pod that can have an updated DaemonSet pod during during an update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up to a minimum of 1. Default value is 0. Example: when this is set to 30%, at most 30% of the total number of nodes that should be running the daemon pod (i.e. status.desiredNumberScheduled) can have their a new pod created before the old pod is marked as deleted. The update starts by launching new pods on 30% of nodes. Once an updated pod is available (Ready for at least minReadySeconds) the old DaemonSet pod on that node is marked deleted. If the old pod becomes unavailable for any reason (Ready transitions to false, is evicted, or is drained) an updated pod is immediatedly created on that node without considering surge limits. Allowing surge implies the possibility that the resources consumed by the daemonset on any given node can double if the readiness check fails, and so resource intensive daemonsets should take into account that they may cause evictions during disruption.
        """
        return pulumi.get(self, "max_surge")

    @_builtins.property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> Optional[Any]:
        """
        The maximum number of DaemonSet pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of total number of DaemonSet pods at the start of the update (ex: 10%). Absolute number is calculated from percentage by rounding up. This cannot be 0 if MaxSurge is 0 Default value is 1. Example: when this is set to 30%, at most 30% of the total number of nodes that should be running the daemon pod (i.e. status.desiredNumberScheduled) can have their pods stopped for an update at any given time. The update starts by stopping at most 30% of those DaemonSet pods and then brings up new DaemonSet pods in their place. Once the new pods are available, it then proceeds onto other DaemonSet pods, thus ensuring that at least 70% of original number of DaemonSet pods are available at all times during the update.
        """
        return pulumi.get(self, "max_unavailable")


@pulumi.output_type
class RollingUpdateDaemonSetPatch(dict):
    """
    Spec to control the desired behavior of daemon set rolling update.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxSurge":
            suggest = "max_surge"
        elif key == "maxUnavailable":
            suggest = "max_unavailable"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RollingUpdateDaemonSetPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RollingUpdateDaemonSetPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RollingUpdateDaemonSetPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_surge: Optional[Any] = None,
                 max_unavailable: Optional[Any] = None):
        """
        Spec to control the desired behavior of daemon set rolling update.
        :param Union[_builtins.int, _builtins.str] max_surge: The maximum number of nodes with an existing available DaemonSet pod that can have an updated DaemonSet pod during during an update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up to a minimum of 1. Default value is 0. Example: when this is set to 30%, at most 30% of the total number of nodes that should be running the daemon pod (i.e. status.desiredNumberScheduled) can have their a new pod created before the old pod is marked as deleted. The update starts by launching new pods on 30% of nodes. Once an updated pod is available (Ready for at least minReadySeconds) the old DaemonSet pod on that node is marked deleted. If the old pod becomes unavailable for any reason (Ready transitions to false, is evicted, or is drained) an updated pod is immediatedly created on that node without considering surge limits. Allowing surge implies the possibility that the resources consumed by the daemonset on any given node can double if the readiness check fails, and so resource intensive daemonsets should take into account that they may cause evictions during disruption.
        :param Union[_builtins.int, _builtins.str] max_unavailable: The maximum number of DaemonSet pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of total number of DaemonSet pods at the start of the update (ex: 10%). Absolute number is calculated from percentage by rounding up. This cannot be 0 if MaxSurge is 0 Default value is 1. Example: when this is set to 30%, at most 30% of the total number of nodes that should be running the daemon pod (i.e. status.desiredNumberScheduled) can have their pods stopped for an update at any given time. The update starts by stopping at most 30% of those DaemonSet pods and then brings up new DaemonSet pods in their place. Once the new pods are available, it then proceeds onto other DaemonSet pods, thus ensuring that at least 70% of original number of DaemonSet pods are available at all times during the update.
        """
        if max_surge is not None:
            pulumi.set(__self__, "max_surge", max_surge)
        if max_unavailable is not None:
            pulumi.set(__self__, "max_unavailable", max_unavailable)

    @_builtins.property
    @pulumi.getter(name="maxSurge")
    def max_surge(self) -> Optional[Any]:
        """
        The maximum number of nodes with an existing available DaemonSet pod that can have an updated DaemonSet pod during during an update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up to a minimum of 1. Default value is 0. Example: when this is set to 30%, at most 30% of the total number of nodes that should be running the daemon pod (i.e. status.desiredNumberScheduled) can have their a new pod created before the old pod is marked as deleted. The update starts by launching new pods on 30% of nodes. Once an updated pod is available (Ready for at least minReadySeconds) the old DaemonSet pod on that node is marked deleted. If the old pod becomes unavailable for any reason (Ready transitions to false, is evicted, or is drained) an updated pod is immediatedly created on that node without considering surge limits. Allowing surge implies the possibility that the resources consumed by the daemonset on any given node can double if the readiness check fails, and so resource intensive daemonsets should take into account that they may cause evictions during disruption.
        """
        return pulumi.get(self, "max_surge")

    @_builtins.property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> Optional[Any]:
        """
        The maximum number of DaemonSet pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of total number of DaemonSet pods at the start of the update (ex: 10%). Absolute number is calculated from percentage by rounding up. This cannot be 0 if MaxSurge is 0 Default value is 1. Example: when this is set to 30%, at most 30% of the total number of nodes that should be running the daemon pod (i.e. status.desiredNumberScheduled) can have their pods stopped for an update at any given time. The update starts by stopping at most 30% of those DaemonSet pods and then brings up new DaemonSet pods in their place. Once the new pods are available, it then proceeds onto other DaemonSet pods, thus ensuring that at least 70% of original number of DaemonSet pods are available at all times during the update.
        """
        return pulumi.get(self, "max_unavailable")


@pulumi.output_type
class RollingUpdateDeployment(dict):
    """
    Spec to control the desired behavior of rolling update.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxSurge":
            suggest = "max_surge"
        elif key == "maxUnavailable":
            suggest = "max_unavailable"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RollingUpdateDeployment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RollingUpdateDeployment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RollingUpdateDeployment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_surge: Optional[Any] = None,
                 max_unavailable: Optional[Any] = None):
        """
        Spec to control the desired behavior of rolling update.
        :param Union[_builtins.int, _builtins.str] max_surge: The maximum number of pods that can be scheduled above the desired number of pods. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up. Defaults to 25%. Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when the rolling update starts, such that the total number of old and new pods do not exceed 130% of desired pods. Once old pods have been killed, new ReplicaSet can be scaled up further, ensuring that total number of pods running at any time during the update is at most 130% of desired pods.
        :param Union[_builtins.int, _builtins.str] max_unavailable: The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding down. This can not be 0 if MaxSurge is 0. Defaults to 25%. Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods immediately when the rolling update starts. Once new pods are ready, old ReplicaSet can be scaled down further, followed by scaling up the new ReplicaSet, ensuring that the total number of pods available at all times during the update is at least 70% of desired pods.
        """
        if max_surge is not None:
            pulumi.set(__self__, "max_surge", max_surge)
        if max_unavailable is not None:
            pulumi.set(__self__, "max_unavailable", max_unavailable)

    @_builtins.property
    @pulumi.getter(name="maxSurge")
    def max_surge(self) -> Optional[Any]:
        """
        The maximum number of pods that can be scheduled above the desired number of pods. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up. Defaults to 25%. Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when the rolling update starts, such that the total number of old and new pods do not exceed 130% of desired pods. Once old pods have been killed, new ReplicaSet can be scaled up further, ensuring that total number of pods running at any time during the update is at most 130% of desired pods.
        """
        return pulumi.get(self, "max_surge")

    @_builtins.property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> Optional[Any]:
        """
        The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding down. This can not be 0 if MaxSurge is 0. Defaults to 25%. Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods immediately when the rolling update starts. Once new pods are ready, old ReplicaSet can be scaled down further, followed by scaling up the new ReplicaSet, ensuring that the total number of pods available at all times during the update is at least 70% of desired pods.
        """
        return pulumi.get(self, "max_unavailable")


@pulumi.output_type
class RollingUpdateDeploymentPatch(dict):
    """
    Spec to control the desired behavior of rolling update.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxSurge":
            suggest = "max_surge"
        elif key == "maxUnavailable":
            suggest = "max_unavailable"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RollingUpdateDeploymentPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RollingUpdateDeploymentPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RollingUpdateDeploymentPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_surge: Optional[Any] = None,
                 max_unavailable: Optional[Any] = None):
        """
        Spec to control the desired behavior of rolling update.
        :param Union[_builtins.int, _builtins.str] max_surge: The maximum number of pods that can be scheduled above the desired number of pods. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up. Defaults to 25%. Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when the rolling update starts, such that the total number of old and new pods do not exceed 130% of desired pods. Once old pods have been killed, new ReplicaSet can be scaled up further, ensuring that total number of pods running at any time during the update is at most 130% of desired pods.
        :param Union[_builtins.int, _builtins.str] max_unavailable: The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding down. This can not be 0 if MaxSurge is 0. Defaults to 25%. Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods immediately when the rolling update starts. Once new pods are ready, old ReplicaSet can be scaled down further, followed by scaling up the new ReplicaSet, ensuring that the total number of pods available at all times during the update is at least 70% of desired pods.
        """
        if max_surge is not None:
            pulumi.set(__self__, "max_surge", max_surge)
        if max_unavailable is not None:
            pulumi.set(__self__, "max_unavailable", max_unavailable)

    @_builtins.property
    @pulumi.getter(name="maxSurge")
    def max_surge(self) -> Optional[Any]:
        """
        The maximum number of pods that can be scheduled above the desired number of pods. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up. Defaults to 25%. Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when the rolling update starts, such that the total number of old and new pods do not exceed 130% of desired pods. Once old pods have been killed, new ReplicaSet can be scaled up further, ensuring that total number of pods running at any time during the update is at most 130% of desired pods.
        """
        return pulumi.get(self, "max_surge")

    @_builtins.property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> Optional[Any]:
        """
        The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding down. This can not be 0 if MaxSurge is 0. Defaults to 25%. Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods immediately when the rolling update starts. Once new pods are ready, old ReplicaSet can be scaled down further, followed by scaling up the new ReplicaSet, ensuring that the total number of pods available at all times during the update is at least 70% of desired pods.
        """
        return pulumi.get(self, "max_unavailable")


@pulumi.output_type
class RollingUpdateStatefulSetStrategy(dict):
    """
    RollingUpdateStatefulSetStrategy is used to communicate parameter for RollingUpdateStatefulSetStrategyType.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxUnavailable":
            suggest = "max_unavailable"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RollingUpdateStatefulSetStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RollingUpdateStatefulSetStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RollingUpdateStatefulSetStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_unavailable: Optional[Any] = None,
                 partition: Optional[_builtins.int] = None):
        """
        RollingUpdateStatefulSetStrategy is used to communicate parameter for RollingUpdateStatefulSetStrategyType.
        :param Union[_builtins.int, _builtins.str] max_unavailable: The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding up. This can not be 0. Defaults to 1. This field is alpha-level and is only honored by servers that enable the MaxUnavailableStatefulSet feature. The field applies to all pods in the range 0 to Replicas-1. That means if there is any unavailable pod in the range 0 to Replicas-1, it will be counted towards MaxUnavailable.
        :param _builtins.int partition: Partition indicates the ordinal at which the StatefulSet should be partitioned for updates. During a rolling update, all pods from ordinal Replicas-1 to Partition are updated. All pods from ordinal Partition-1 to 0 remain untouched. This is helpful in being able to do a canary based deployment. The default value is 0.
        """
        if max_unavailable is not None:
            pulumi.set(__self__, "max_unavailable", max_unavailable)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)

    @_builtins.property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> Optional[Any]:
        """
        The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding up. This can not be 0. Defaults to 1. This field is alpha-level and is only honored by servers that enable the MaxUnavailableStatefulSet feature. The field applies to all pods in the range 0 to Replicas-1. That means if there is any unavailable pod in the range 0 to Replicas-1, it will be counted towards MaxUnavailable.
        """
        return pulumi.get(self, "max_unavailable")

    @_builtins.property
    @pulumi.getter
    def partition(self) -> Optional[_builtins.int]:
        """
        Partition indicates the ordinal at which the StatefulSet should be partitioned for updates. During a rolling update, all pods from ordinal Replicas-1 to Partition are updated. All pods from ordinal Partition-1 to 0 remain untouched. This is helpful in being able to do a canary based deployment. The default value is 0.
        """
        return pulumi.get(self, "partition")


@pulumi.output_type
class RollingUpdateStatefulSetStrategyPatch(dict):
    """
    RollingUpdateStatefulSetStrategy is used to communicate parameter for RollingUpdateStatefulSetStrategyType.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxUnavailable":
            suggest = "max_unavailable"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RollingUpdateStatefulSetStrategyPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RollingUpdateStatefulSetStrategyPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RollingUpdateStatefulSetStrategyPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_unavailable: Optional[Any] = None,
                 partition: Optional[_builtins.int] = None):
        """
        RollingUpdateStatefulSetStrategy is used to communicate parameter for RollingUpdateStatefulSetStrategyType.
        :param Union[_builtins.int, _builtins.str] max_unavailable: The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding up. This can not be 0. Defaults to 1. This field is alpha-level and is only honored by servers that enable the MaxUnavailableStatefulSet feature. The field applies to all pods in the range 0 to Replicas-1. That means if there is any unavailable pod in the range 0 to Replicas-1, it will be counted towards MaxUnavailable.
        :param _builtins.int partition: Partition indicates the ordinal at which the StatefulSet should be partitioned for updates. During a rolling update, all pods from ordinal Replicas-1 to Partition are updated. All pods from ordinal Partition-1 to 0 remain untouched. This is helpful in being able to do a canary based deployment. The default value is 0.
        """
        if max_unavailable is not None:
            pulumi.set(__self__, "max_unavailable", max_unavailable)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)

    @_builtins.property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> Optional[Any]:
        """
        The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding up. This can not be 0. Defaults to 1. This field is alpha-level and is only honored by servers that enable the MaxUnavailableStatefulSet feature. The field applies to all pods in the range 0 to Replicas-1. That means if there is any unavailable pod in the range 0 to Replicas-1, it will be counted towards MaxUnavailable.
        """
        return pulumi.get(self, "max_unavailable")

    @_builtins.property
    @pulumi.getter
    def partition(self) -> Optional[_builtins.int]:
        """
        Partition indicates the ordinal at which the StatefulSet should be partitioned for updates. During a rolling update, all pods from ordinal Replicas-1 to Partition are updated. All pods from ordinal Partition-1 to 0 remain untouched. This is helpful in being able to do a canary based deployment. The default value is 0.
        """
        return pulumi.get(self, "partition")


@pulumi.output_type
class StatefulSet(dict):
    """
    StatefulSet represents a set of pods with consistent identities. Identities are defined as:
      - Network: A single stable DNS and hostname.
      - Storage: As many VolumeClaims as requested.

    The StatefulSet guarantees that a given network identity will always map to the same storage identity.

    This resource waits until its status is ready before registering success
    for create/update, and populating output properties from the current state of the resource.
    The following conditions are used to determine whether the resource creation has
    succeeded or failed:

    1. The value of 'spec.replicas' matches '.status.replicas', '.status.currentReplicas',
       and '.status.readyReplicas'.
    2. The value of '.status.updateRevision' matches '.status.currentRevision'.

    If the StatefulSet has not reached a Ready state after 10 minutes, it will
    time out and mark the resource update as Failed. You can override the default timeout value
    by setting the 'customTimeouts' option on the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StatefulSet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StatefulSet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StatefulSet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[_builtins.str] = None,
                 kind: Optional[_builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.StatefulSetSpec'] = None,
                 status: Optional['outputs.StatefulSetStatus'] = None):
        """
        StatefulSet represents a set of pods with consistent identities. Identities are defined as:
          - Network: A single stable DNS and hostname.
          - Storage: As many VolumeClaims as requested.

        The StatefulSet guarantees that a given network identity will always map to the same storage identity.

        This resource waits until its status is ready before registering success
        for create/update, and populating output properties from the current state of the resource.
        The following conditions are used to determine whether the resource creation has
        succeeded or failed:

        1. The value of 'spec.replicas' matches '.status.replicas', '.status.currentReplicas',
           and '.status.readyReplicas'.
        2. The value of '.status.updateRevision' matches '.status.currentRevision'.

        If the StatefulSet has not reached a Ready state after 10 minutes, it will
        time out and mark the resource update as Failed. You can override the default timeout value
        by setting the 'customTimeouts' option on the resource.
        :param _builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param _builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param 'StatefulSetSpecArgs' spec: Spec defines the desired identities of pods in this set.
        :param 'StatefulSetStatusArgs' status: Status is the current status of Pods in this StatefulSet. This data may be out of date by some window of time.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'apps/v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'StatefulSet')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[_builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[_builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional['outputs.StatefulSetSpec']:
        """
        Spec defines the desired identities of pods in this set.
        """
        return pulumi.get(self, "spec")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional['outputs.StatefulSetStatus']:
        """
        Status is the current status of Pods in this StatefulSet. This data may be out of date by some window of time.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class StatefulSetCondition(dict):
    """
    StatefulSetCondition describes the state of a statefulset at a certain point.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastTransitionTime":
            suggest = "last_transition_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StatefulSetCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StatefulSetCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StatefulSetCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status: _builtins.str,
                 type: _builtins.str,
                 last_transition_time: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None):
        """
        StatefulSetCondition describes the state of a statefulset at a certain point.
        :param _builtins.str status: Status of the condition, one of True, False, Unknown.
        :param _builtins.str type: Type of statefulset condition.
        :param _builtins.str last_transition_time: Last time the condition transitioned from one status to another.
        :param _builtins.str message: A human readable message indicating details about the transition.
        :param _builtins.str reason: The reason for the condition's last transition.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of statefulset condition.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[_builtins.str]:
        """
        Last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        A human readable message indicating details about the transition.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        The reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")


@pulumi.output_type
class StatefulSetConditionPatch(dict):
    """
    StatefulSetCondition describes the state of a statefulset at a certain point.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastTransitionTime":
            suggest = "last_transition_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StatefulSetConditionPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StatefulSetConditionPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StatefulSetConditionPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_transition_time: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        StatefulSetCondition describes the state of a statefulset at a certain point.
        :param _builtins.str last_transition_time: Last time the condition transitioned from one status to another.
        :param _builtins.str message: A human readable message indicating details about the transition.
        :param _builtins.str reason: The reason for the condition's last transition.
        :param _builtins.str status: Status of the condition, one of True, False, Unknown.
        :param _builtins.str type: Type of statefulset condition.
        """
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[_builtins.str]:
        """
        Last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        A human readable message indicating details about the transition.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        The reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of statefulset condition.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class StatefulSetOrdinals(dict):
    """
    StatefulSetOrdinals describes the policy used for replica ordinal assignment in this StatefulSet.
    """
    def __init__(__self__, *,
                 start: Optional[_builtins.int] = None):
        """
        StatefulSetOrdinals describes the policy used for replica ordinal assignment in this StatefulSet.
        :param _builtins.int start: start is the number representing the first replica's index. It may be used to number replicas from an alternate index (eg: 1-indexed) over the default 0-indexed names, or to orchestrate progressive movement of replicas from one StatefulSet to another. If set, replica indices will be in the range:
                 [.spec.ordinals.start, .spec.ordinals.start + .spec.replicas).
               If unset, defaults to 0. Replica indices will be in the range:
                 [0, .spec.replicas).
        """
        if start is not None:
            pulumi.set(__self__, "start", start)

    @_builtins.property
    @pulumi.getter
    def start(self) -> Optional[_builtins.int]:
        """
        start is the number representing the first replica's index. It may be used to number replicas from an alternate index (eg: 1-indexed) over the default 0-indexed names, or to orchestrate progressive movement of replicas from one StatefulSet to another. If set, replica indices will be in the range:
          [.spec.ordinals.start, .spec.ordinals.start + .spec.replicas).
        If unset, defaults to 0. Replica indices will be in the range:
          [0, .spec.replicas).
        """
        return pulumi.get(self, "start")


@pulumi.output_type
class StatefulSetOrdinalsPatch(dict):
    """
    StatefulSetOrdinals describes the policy used for replica ordinal assignment in this StatefulSet.
    """
    def __init__(__self__, *,
                 start: Optional[_builtins.int] = None):
        """
        StatefulSetOrdinals describes the policy used for replica ordinal assignment in this StatefulSet.
        :param _builtins.int start: start is the number representing the first replica's index. It may be used to number replicas from an alternate index (eg: 1-indexed) over the default 0-indexed names, or to orchestrate progressive movement of replicas from one StatefulSet to another. If set, replica indices will be in the range:
                 [.spec.ordinals.start, .spec.ordinals.start + .spec.replicas).
               If unset, defaults to 0. Replica indices will be in the range:
                 [0, .spec.replicas).
        """
        if start is not None:
            pulumi.set(__self__, "start", start)

    @_builtins.property
    @pulumi.getter
    def start(self) -> Optional[_builtins.int]:
        """
        start is the number representing the first replica's index. It may be used to number replicas from an alternate index (eg: 1-indexed) over the default 0-indexed names, or to orchestrate progressive movement of replicas from one StatefulSet to another. If set, replica indices will be in the range:
          [.spec.ordinals.start, .spec.ordinals.start + .spec.replicas).
        If unset, defaults to 0. Replica indices will be in the range:
          [0, .spec.replicas).
        """
        return pulumi.get(self, "start")


@pulumi.output_type
class StatefulSetPersistentVolumeClaimRetentionPolicy(dict):
    """
    StatefulSetPersistentVolumeClaimRetentionPolicy describes the policy used for PVCs created from the StatefulSet VolumeClaimTemplates.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "whenDeleted":
            suggest = "when_deleted"
        elif key == "whenScaled":
            suggest = "when_scaled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StatefulSetPersistentVolumeClaimRetentionPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StatefulSetPersistentVolumeClaimRetentionPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StatefulSetPersistentVolumeClaimRetentionPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 when_deleted: Optional[_builtins.str] = None,
                 when_scaled: Optional[_builtins.str] = None):
        """
        StatefulSetPersistentVolumeClaimRetentionPolicy describes the policy used for PVCs created from the StatefulSet VolumeClaimTemplates.
        :param _builtins.str when_deleted: WhenDeleted specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet is deleted. The default policy of `Retain` causes PVCs to not be affected by StatefulSet deletion. The `Delete` policy causes those PVCs to be deleted.
        :param _builtins.str when_scaled: WhenScaled specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet is scaled down. The default policy of `Retain` causes PVCs to not be affected by a scaledown. The `Delete` policy causes the associated PVCs for any excess pods above the replica count to be deleted.
        """
        if when_deleted is not None:
            pulumi.set(__self__, "when_deleted", when_deleted)
        if when_scaled is not None:
            pulumi.set(__self__, "when_scaled", when_scaled)

    @_builtins.property
    @pulumi.getter(name="whenDeleted")
    def when_deleted(self) -> Optional[_builtins.str]:
        """
        WhenDeleted specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet is deleted. The default policy of `Retain` causes PVCs to not be affected by StatefulSet deletion. The `Delete` policy causes those PVCs to be deleted.
        """
        return pulumi.get(self, "when_deleted")

    @_builtins.property
    @pulumi.getter(name="whenScaled")
    def when_scaled(self) -> Optional[_builtins.str]:
        """
        WhenScaled specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet is scaled down. The default policy of `Retain` causes PVCs to not be affected by a scaledown. The `Delete` policy causes the associated PVCs for any excess pods above the replica count to be deleted.
        """
        return pulumi.get(self, "when_scaled")


@pulumi.output_type
class StatefulSetPersistentVolumeClaimRetentionPolicyPatch(dict):
    """
    StatefulSetPersistentVolumeClaimRetentionPolicy describes the policy used for PVCs created from the StatefulSet VolumeClaimTemplates.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "whenDeleted":
            suggest = "when_deleted"
        elif key == "whenScaled":
            suggest = "when_scaled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StatefulSetPersistentVolumeClaimRetentionPolicyPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StatefulSetPersistentVolumeClaimRetentionPolicyPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StatefulSetPersistentVolumeClaimRetentionPolicyPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 when_deleted: Optional[_builtins.str] = None,
                 when_scaled: Optional[_builtins.str] = None):
        """
        StatefulSetPersistentVolumeClaimRetentionPolicy describes the policy used for PVCs created from the StatefulSet VolumeClaimTemplates.
        :param _builtins.str when_deleted: WhenDeleted specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet is deleted. The default policy of `Retain` causes PVCs to not be affected by StatefulSet deletion. The `Delete` policy causes those PVCs to be deleted.
        :param _builtins.str when_scaled: WhenScaled specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet is scaled down. The default policy of `Retain` causes PVCs to not be affected by a scaledown. The `Delete` policy causes the associated PVCs for any excess pods above the replica count to be deleted.
        """
        if when_deleted is not None:
            pulumi.set(__self__, "when_deleted", when_deleted)
        if when_scaled is not None:
            pulumi.set(__self__, "when_scaled", when_scaled)

    @_builtins.property
    @pulumi.getter(name="whenDeleted")
    def when_deleted(self) -> Optional[_builtins.str]:
        """
        WhenDeleted specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet is deleted. The default policy of `Retain` causes PVCs to not be affected by StatefulSet deletion. The `Delete` policy causes those PVCs to be deleted.
        """
        return pulumi.get(self, "when_deleted")

    @_builtins.property
    @pulumi.getter(name="whenScaled")
    def when_scaled(self) -> Optional[_builtins.str]:
        """
        WhenScaled specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet is scaled down. The default policy of `Retain` causes PVCs to not be affected by a scaledown. The `Delete` policy causes the associated PVCs for any excess pods above the replica count to be deleted.
        """
        return pulumi.get(self, "when_scaled")


@pulumi.output_type
class StatefulSetSpec(dict):
    """
    A StatefulSetSpec is the specification of a StatefulSet.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minReadySeconds":
            suggest = "min_ready_seconds"
        elif key == "persistentVolumeClaimRetentionPolicy":
            suggest = "persistent_volume_claim_retention_policy"
        elif key == "podManagementPolicy":
            suggest = "pod_management_policy"
        elif key == "revisionHistoryLimit":
            suggest = "revision_history_limit"
        elif key == "serviceName":
            suggest = "service_name"
        elif key == "updateStrategy":
            suggest = "update_strategy"
        elif key == "volumeClaimTemplates":
            suggest = "volume_claim_templates"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StatefulSetSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StatefulSetSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StatefulSetSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 selector: '_meta.v1.outputs.LabelSelector',
                 template: '_core.v1.outputs.PodTemplateSpec',
                 min_ready_seconds: Optional[_builtins.int] = None,
                 ordinals: Optional['outputs.StatefulSetOrdinals'] = None,
                 persistent_volume_claim_retention_policy: Optional['outputs.StatefulSetPersistentVolumeClaimRetentionPolicy'] = None,
                 pod_management_policy: Optional[_builtins.str] = None,
                 replicas: Optional[_builtins.int] = None,
                 revision_history_limit: Optional[_builtins.int] = None,
                 service_name: Optional[_builtins.str] = None,
                 update_strategy: Optional['outputs.StatefulSetUpdateStrategy'] = None,
                 volume_claim_templates: Optional[Sequence['_core.v1.outputs.PersistentVolumeClaim']] = None):
        """
        A StatefulSetSpec is the specification of a StatefulSet.
        :param '_meta.v1.LabelSelectorArgs' selector: selector is a label query over pods that should match the replica count. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        :param '_core.v1.PodTemplateSpecArgs' template: template is the object that describes the pod that will be created if insufficient replicas are detected. Each pod stamped out by the StatefulSet will fulfill this Template, but have a unique identity from the rest of the StatefulSet. Each pod will be named with the format <statefulsetname>-<podindex>. For example, a pod in a StatefulSet named "web" with index number "3" would be named "web-3". The only allowed template.spec.restartPolicy value is "Always".
        :param _builtins.int min_ready_seconds: Minimum number of seconds for which a newly created pod should be ready without any of its container crashing for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        :param 'StatefulSetOrdinalsArgs' ordinals: ordinals controls the numbering of replica indices in a StatefulSet. The default ordinals behavior assigns a "0" index to the first replica and increments the index by one for each additional replica requested.
        :param 'StatefulSetPersistentVolumeClaimRetentionPolicyArgs' persistent_volume_claim_retention_policy: persistentVolumeClaimRetentionPolicy describes the lifecycle of persistent volume claims created from volumeClaimTemplates. By default, all persistent volume claims are created as needed and retained until manually deleted. This policy allows the lifecycle to be altered, for example by deleting persistent volume claims when their stateful set is deleted, or when their pod is scaled down.
        :param _builtins.str pod_management_policy: podManagementPolicy controls how pods are created during initial scale up, when replacing pods on nodes, or when scaling down. The default policy is `OrderedReady`, where pods are created in increasing order (pod-0, then pod-1, etc) and the controller will wait until each pod is ready before continuing. When scaling down, the pods are removed in the opposite order. The alternative policy is `Parallel` which will create pods in parallel to match the desired scale without waiting, and on scale down will delete all pods at once.
        :param _builtins.int replicas: replicas is the desired number of replicas of the given Template. These are replicas in the sense that they are instantiations of the same Template, but individual replicas also have a consistent identity. If unspecified, defaults to 1.
        :param _builtins.int revision_history_limit: revisionHistoryLimit is the maximum number of revisions that will be maintained in the StatefulSet's revision history. The revision history consists of all revisions not represented by a currently applied StatefulSetSpec version. The default value is 10.
        :param _builtins.str service_name: serviceName is the name of the service that governs this StatefulSet. This service must exist before the StatefulSet, and is responsible for the network identity of the set. Pods get DNS/hostnames that follow the pattern: pod-specific-string.serviceName.default.svc.cluster.local where "pod-specific-string" is managed by the StatefulSet controller.
        :param 'StatefulSetUpdateStrategyArgs' update_strategy: updateStrategy indicates the StatefulSetUpdateStrategy that will be employed to update Pods in the StatefulSet when a revision is made to Template.
        :param Sequence['_core.v1.PersistentVolumeClaimArgs'] volume_claim_templates: volumeClaimTemplates is a list of claims that pods are allowed to reference. The StatefulSet controller is responsible for mapping network identities to claims in a way that maintains the identity of a pod. Every claim in this list must have at least one matching (by name) volumeMount in one container in the template. A claim in this list takes precedence over any volumes in the template, with the same name.
        """
        pulumi.set(__self__, "selector", selector)
        pulumi.set(__self__, "template", template)
        if min_ready_seconds is not None:
            pulumi.set(__self__, "min_ready_seconds", min_ready_seconds)
        if ordinals is not None:
            pulumi.set(__self__, "ordinals", ordinals)
        if persistent_volume_claim_retention_policy is not None:
            pulumi.set(__self__, "persistent_volume_claim_retention_policy", persistent_volume_claim_retention_policy)
        if pod_management_policy is not None:
            pulumi.set(__self__, "pod_management_policy", pod_management_policy)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if revision_history_limit is not None:
            pulumi.set(__self__, "revision_history_limit", revision_history_limit)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if update_strategy is not None:
            pulumi.set(__self__, "update_strategy", update_strategy)
        if volume_claim_templates is not None:
            pulumi.set(__self__, "volume_claim_templates", volume_claim_templates)

    @_builtins.property
    @pulumi.getter
    def selector(self) -> '_meta.v1.outputs.LabelSelector':
        """
        selector is a label query over pods that should match the replica count. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        """
        return pulumi.get(self, "selector")

    @_builtins.property
    @pulumi.getter
    def template(self) -> '_core.v1.outputs.PodTemplateSpec':
        """
        template is the object that describes the pod that will be created if insufficient replicas are detected. Each pod stamped out by the StatefulSet will fulfill this Template, but have a unique identity from the rest of the StatefulSet. Each pod will be named with the format <statefulsetname>-<podindex>. For example, a pod in a StatefulSet named "web" with index number "3" would be named "web-3". The only allowed template.spec.restartPolicy value is "Always".
        """
        return pulumi.get(self, "template")

    @_builtins.property
    @pulumi.getter(name="minReadySeconds")
    def min_ready_seconds(self) -> Optional[_builtins.int]:
        """
        Minimum number of seconds for which a newly created pod should be ready without any of its container crashing for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        """
        return pulumi.get(self, "min_ready_seconds")

    @_builtins.property
    @pulumi.getter
    def ordinals(self) -> Optional['outputs.StatefulSetOrdinals']:
        """
        ordinals controls the numbering of replica indices in a StatefulSet. The default ordinals behavior assigns a "0" index to the first replica and increments the index by one for each additional replica requested.
        """
        return pulumi.get(self, "ordinals")

    @_builtins.property
    @pulumi.getter(name="persistentVolumeClaimRetentionPolicy")
    def persistent_volume_claim_retention_policy(self) -> Optional['outputs.StatefulSetPersistentVolumeClaimRetentionPolicy']:
        """
        persistentVolumeClaimRetentionPolicy describes the lifecycle of persistent volume claims created from volumeClaimTemplates. By default, all persistent volume claims are created as needed and retained until manually deleted. This policy allows the lifecycle to be altered, for example by deleting persistent volume claims when their stateful set is deleted, or when their pod is scaled down.
        """
        return pulumi.get(self, "persistent_volume_claim_retention_policy")

    @_builtins.property
    @pulumi.getter(name="podManagementPolicy")
    def pod_management_policy(self) -> Optional[_builtins.str]:
        """
        podManagementPolicy controls how pods are created during initial scale up, when replacing pods on nodes, or when scaling down. The default policy is `OrderedReady`, where pods are created in increasing order (pod-0, then pod-1, etc) and the controller will wait until each pod is ready before continuing. When scaling down, the pods are removed in the opposite order. The alternative policy is `Parallel` which will create pods in parallel to match the desired scale without waiting, and on scale down will delete all pods at once.
        """
        return pulumi.get(self, "pod_management_policy")

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> Optional[_builtins.int]:
        """
        replicas is the desired number of replicas of the given Template. These are replicas in the sense that they are instantiations of the same Template, but individual replicas also have a consistent identity. If unspecified, defaults to 1.
        """
        return pulumi.get(self, "replicas")

    @_builtins.property
    @pulumi.getter(name="revisionHistoryLimit")
    def revision_history_limit(self) -> Optional[_builtins.int]:
        """
        revisionHistoryLimit is the maximum number of revisions that will be maintained in the StatefulSet's revision history. The revision history consists of all revisions not represented by a currently applied StatefulSetSpec version. The default value is 10.
        """
        return pulumi.get(self, "revision_history_limit")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[_builtins.str]:
        """
        serviceName is the name of the service that governs this StatefulSet. This service must exist before the StatefulSet, and is responsible for the network identity of the set. Pods get DNS/hostnames that follow the pattern: pod-specific-string.serviceName.default.svc.cluster.local where "pod-specific-string" is managed by the StatefulSet controller.
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter(name="updateStrategy")
    def update_strategy(self) -> Optional['outputs.StatefulSetUpdateStrategy']:
        """
        updateStrategy indicates the StatefulSetUpdateStrategy that will be employed to update Pods in the StatefulSet when a revision is made to Template.
        """
        return pulumi.get(self, "update_strategy")

    @_builtins.property
    @pulumi.getter(name="volumeClaimTemplates")
    def volume_claim_templates(self) -> Optional[Sequence['_core.v1.outputs.PersistentVolumeClaim']]:
        """
        volumeClaimTemplates is a list of claims that pods are allowed to reference. The StatefulSet controller is responsible for mapping network identities to claims in a way that maintains the identity of a pod. Every claim in this list must have at least one matching (by name) volumeMount in one container in the template. A claim in this list takes precedence over any volumes in the template, with the same name.
        """
        return pulumi.get(self, "volume_claim_templates")


@pulumi.output_type
class StatefulSetSpecPatch(dict):
    """
    A StatefulSetSpec is the specification of a StatefulSet.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minReadySeconds":
            suggest = "min_ready_seconds"
        elif key == "persistentVolumeClaimRetentionPolicy":
            suggest = "persistent_volume_claim_retention_policy"
        elif key == "podManagementPolicy":
            suggest = "pod_management_policy"
        elif key == "revisionHistoryLimit":
            suggest = "revision_history_limit"
        elif key == "serviceName":
            suggest = "service_name"
        elif key == "updateStrategy":
            suggest = "update_strategy"
        elif key == "volumeClaimTemplates":
            suggest = "volume_claim_templates"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StatefulSetSpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StatefulSetSpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StatefulSetSpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 min_ready_seconds: Optional[_builtins.int] = None,
                 ordinals: Optional['outputs.StatefulSetOrdinalsPatch'] = None,
                 persistent_volume_claim_retention_policy: Optional['outputs.StatefulSetPersistentVolumeClaimRetentionPolicyPatch'] = None,
                 pod_management_policy: Optional[_builtins.str] = None,
                 replicas: Optional[_builtins.int] = None,
                 revision_history_limit: Optional[_builtins.int] = None,
                 selector: Optional['_meta.v1.outputs.LabelSelectorPatch'] = None,
                 service_name: Optional[_builtins.str] = None,
                 template: Optional['_core.v1.outputs.PodTemplateSpecPatch'] = None,
                 update_strategy: Optional['outputs.StatefulSetUpdateStrategyPatch'] = None,
                 volume_claim_templates: Optional[Sequence['_core.v1.outputs.PersistentVolumeClaimPatch']] = None):
        """
        A StatefulSetSpec is the specification of a StatefulSet.
        :param _builtins.int min_ready_seconds: Minimum number of seconds for which a newly created pod should be ready without any of its container crashing for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        :param 'StatefulSetOrdinalsPatchArgs' ordinals: ordinals controls the numbering of replica indices in a StatefulSet. The default ordinals behavior assigns a "0" index to the first replica and increments the index by one for each additional replica requested.
        :param 'StatefulSetPersistentVolumeClaimRetentionPolicyPatchArgs' persistent_volume_claim_retention_policy: persistentVolumeClaimRetentionPolicy describes the lifecycle of persistent volume claims created from volumeClaimTemplates. By default, all persistent volume claims are created as needed and retained until manually deleted. This policy allows the lifecycle to be altered, for example by deleting persistent volume claims when their stateful set is deleted, or when their pod is scaled down.
        :param _builtins.str pod_management_policy: podManagementPolicy controls how pods are created during initial scale up, when replacing pods on nodes, or when scaling down. The default policy is `OrderedReady`, where pods are created in increasing order (pod-0, then pod-1, etc) and the controller will wait until each pod is ready before continuing. When scaling down, the pods are removed in the opposite order. The alternative policy is `Parallel` which will create pods in parallel to match the desired scale without waiting, and on scale down will delete all pods at once.
        :param _builtins.int replicas: replicas is the desired number of replicas of the given Template. These are replicas in the sense that they are instantiations of the same Template, but individual replicas also have a consistent identity. If unspecified, defaults to 1.
        :param _builtins.int revision_history_limit: revisionHistoryLimit is the maximum number of revisions that will be maintained in the StatefulSet's revision history. The revision history consists of all revisions not represented by a currently applied StatefulSetSpec version. The default value is 10.
        :param '_meta.v1.LabelSelectorPatchArgs' selector: selector is a label query over pods that should match the replica count. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        :param _builtins.str service_name: serviceName is the name of the service that governs this StatefulSet. This service must exist before the StatefulSet, and is responsible for the network identity of the set. Pods get DNS/hostnames that follow the pattern: pod-specific-string.serviceName.default.svc.cluster.local where "pod-specific-string" is managed by the StatefulSet controller.
        :param '_core.v1.PodTemplateSpecPatchArgs' template: template is the object that describes the pod that will be created if insufficient replicas are detected. Each pod stamped out by the StatefulSet will fulfill this Template, but have a unique identity from the rest of the StatefulSet. Each pod will be named with the format <statefulsetname>-<podindex>. For example, a pod in a StatefulSet named "web" with index number "3" would be named "web-3". The only allowed template.spec.restartPolicy value is "Always".
        :param 'StatefulSetUpdateStrategyPatchArgs' update_strategy: updateStrategy indicates the StatefulSetUpdateStrategy that will be employed to update Pods in the StatefulSet when a revision is made to Template.
        :param Sequence['_core.v1.PersistentVolumeClaimPatchArgs'] volume_claim_templates: volumeClaimTemplates is a list of claims that pods are allowed to reference. The StatefulSet controller is responsible for mapping network identities to claims in a way that maintains the identity of a pod. Every claim in this list must have at least one matching (by name) volumeMount in one container in the template. A claim in this list takes precedence over any volumes in the template, with the same name.
        """
        if min_ready_seconds is not None:
            pulumi.set(__self__, "min_ready_seconds", min_ready_seconds)
        if ordinals is not None:
            pulumi.set(__self__, "ordinals", ordinals)
        if persistent_volume_claim_retention_policy is not None:
            pulumi.set(__self__, "persistent_volume_claim_retention_policy", persistent_volume_claim_retention_policy)
        if pod_management_policy is not None:
            pulumi.set(__self__, "pod_management_policy", pod_management_policy)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if revision_history_limit is not None:
            pulumi.set(__self__, "revision_history_limit", revision_history_limit)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if update_strategy is not None:
            pulumi.set(__self__, "update_strategy", update_strategy)
        if volume_claim_templates is not None:
            pulumi.set(__self__, "volume_claim_templates", volume_claim_templates)

    @_builtins.property
    @pulumi.getter(name="minReadySeconds")
    def min_ready_seconds(self) -> Optional[_builtins.int]:
        """
        Minimum number of seconds for which a newly created pod should be ready without any of its container crashing for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)
        """
        return pulumi.get(self, "min_ready_seconds")

    @_builtins.property
    @pulumi.getter
    def ordinals(self) -> Optional['outputs.StatefulSetOrdinalsPatch']:
        """
        ordinals controls the numbering of replica indices in a StatefulSet. The default ordinals behavior assigns a "0" index to the first replica and increments the index by one for each additional replica requested.
        """
        return pulumi.get(self, "ordinals")

    @_builtins.property
    @pulumi.getter(name="persistentVolumeClaimRetentionPolicy")
    def persistent_volume_claim_retention_policy(self) -> Optional['outputs.StatefulSetPersistentVolumeClaimRetentionPolicyPatch']:
        """
        persistentVolumeClaimRetentionPolicy describes the lifecycle of persistent volume claims created from volumeClaimTemplates. By default, all persistent volume claims are created as needed and retained until manually deleted. This policy allows the lifecycle to be altered, for example by deleting persistent volume claims when their stateful set is deleted, or when their pod is scaled down.
        """
        return pulumi.get(self, "persistent_volume_claim_retention_policy")

    @_builtins.property
    @pulumi.getter(name="podManagementPolicy")
    def pod_management_policy(self) -> Optional[_builtins.str]:
        """
        podManagementPolicy controls how pods are created during initial scale up, when replacing pods on nodes, or when scaling down. The default policy is `OrderedReady`, where pods are created in increasing order (pod-0, then pod-1, etc) and the controller will wait until each pod is ready before continuing. When scaling down, the pods are removed in the opposite order. The alternative policy is `Parallel` which will create pods in parallel to match the desired scale without waiting, and on scale down will delete all pods at once.
        """
        return pulumi.get(self, "pod_management_policy")

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> Optional[_builtins.int]:
        """
        replicas is the desired number of replicas of the given Template. These are replicas in the sense that they are instantiations of the same Template, but individual replicas also have a consistent identity. If unspecified, defaults to 1.
        """
        return pulumi.get(self, "replicas")

    @_builtins.property
    @pulumi.getter(name="revisionHistoryLimit")
    def revision_history_limit(self) -> Optional[_builtins.int]:
        """
        revisionHistoryLimit is the maximum number of revisions that will be maintained in the StatefulSet's revision history. The revision history consists of all revisions not represented by a currently applied StatefulSetSpec version. The default value is 10.
        """
        return pulumi.get(self, "revision_history_limit")

    @_builtins.property
    @pulumi.getter
    def selector(self) -> Optional['_meta.v1.outputs.LabelSelectorPatch']:
        """
        selector is a label query over pods that should match the replica count. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
        """
        return pulumi.get(self, "selector")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[_builtins.str]:
        """
        serviceName is the name of the service that governs this StatefulSet. This service must exist before the StatefulSet, and is responsible for the network identity of the set. Pods get DNS/hostnames that follow the pattern: pod-specific-string.serviceName.default.svc.cluster.local where "pod-specific-string" is managed by the StatefulSet controller.
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter
    def template(self) -> Optional['_core.v1.outputs.PodTemplateSpecPatch']:
        """
        template is the object that describes the pod that will be created if insufficient replicas are detected. Each pod stamped out by the StatefulSet will fulfill this Template, but have a unique identity from the rest of the StatefulSet. Each pod will be named with the format <statefulsetname>-<podindex>. For example, a pod in a StatefulSet named "web" with index number "3" would be named "web-3". The only allowed template.spec.restartPolicy value is "Always".
        """
        return pulumi.get(self, "template")

    @_builtins.property
    @pulumi.getter(name="updateStrategy")
    def update_strategy(self) -> Optional['outputs.StatefulSetUpdateStrategyPatch']:
        """
        updateStrategy indicates the StatefulSetUpdateStrategy that will be employed to update Pods in the StatefulSet when a revision is made to Template.
        """
        return pulumi.get(self, "update_strategy")

    @_builtins.property
    @pulumi.getter(name="volumeClaimTemplates")
    def volume_claim_templates(self) -> Optional[Sequence['_core.v1.outputs.PersistentVolumeClaimPatch']]:
        """
        volumeClaimTemplates is a list of claims that pods are allowed to reference. The StatefulSet controller is responsible for mapping network identities to claims in a way that maintains the identity of a pod. Every claim in this list must have at least one matching (by name) volumeMount in one container in the template. A claim in this list takes precedence over any volumes in the template, with the same name.
        """
        return pulumi.get(self, "volume_claim_templates")


@pulumi.output_type
class StatefulSetStatus(dict):
    """
    StatefulSetStatus represents the current state of a StatefulSet.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availableReplicas":
            suggest = "available_replicas"
        elif key == "collisionCount":
            suggest = "collision_count"
        elif key == "currentReplicas":
            suggest = "current_replicas"
        elif key == "currentRevision":
            suggest = "current_revision"
        elif key == "observedGeneration":
            suggest = "observed_generation"
        elif key == "readyReplicas":
            suggest = "ready_replicas"
        elif key == "updateRevision":
            suggest = "update_revision"
        elif key == "updatedReplicas":
            suggest = "updated_replicas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StatefulSetStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StatefulSetStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StatefulSetStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 replicas: _builtins.int,
                 available_replicas: Optional[_builtins.int] = None,
                 collision_count: Optional[_builtins.int] = None,
                 conditions: Optional[Sequence['outputs.StatefulSetCondition']] = None,
                 current_replicas: Optional[_builtins.int] = None,
                 current_revision: Optional[_builtins.str] = None,
                 observed_generation: Optional[_builtins.int] = None,
                 ready_replicas: Optional[_builtins.int] = None,
                 update_revision: Optional[_builtins.str] = None,
                 updated_replicas: Optional[_builtins.int] = None):
        """
        StatefulSetStatus represents the current state of a StatefulSet.
        :param _builtins.int replicas: replicas is the number of Pods created by the StatefulSet controller.
        :param _builtins.int available_replicas: Total number of available pods (ready for at least minReadySeconds) targeted by this statefulset.
        :param _builtins.int collision_count: collisionCount is the count of hash collisions for the StatefulSet. The StatefulSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.
        :param Sequence['StatefulSetConditionArgs'] conditions: Represents the latest available observations of a statefulset's current state.
        :param _builtins.int current_replicas: currentReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by currentRevision.
        :param _builtins.str current_revision: currentRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [0,currentReplicas).
        :param _builtins.int observed_generation: observedGeneration is the most recent generation observed for this StatefulSet. It corresponds to the StatefulSet's generation, which is updated on mutation by the API Server.
        :param _builtins.int ready_replicas: readyReplicas is the number of pods created for this StatefulSet with a Ready Condition.
        :param _builtins.str update_revision: updateRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [replicas-updatedReplicas,replicas)
        :param _builtins.int updated_replicas: updatedReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by updateRevision.
        """
        pulumi.set(__self__, "replicas", replicas)
        if available_replicas is not None:
            pulumi.set(__self__, "available_replicas", available_replicas)
        if collision_count is not None:
            pulumi.set(__self__, "collision_count", collision_count)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if current_replicas is not None:
            pulumi.set(__self__, "current_replicas", current_replicas)
        if current_revision is not None:
            pulumi.set(__self__, "current_revision", current_revision)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if ready_replicas is not None:
            pulumi.set(__self__, "ready_replicas", ready_replicas)
        if update_revision is not None:
            pulumi.set(__self__, "update_revision", update_revision)
        if updated_replicas is not None:
            pulumi.set(__self__, "updated_replicas", updated_replicas)

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> _builtins.int:
        """
        replicas is the number of Pods created by the StatefulSet controller.
        """
        return pulumi.get(self, "replicas")

    @_builtins.property
    @pulumi.getter(name="availableReplicas")
    def available_replicas(self) -> Optional[_builtins.int]:
        """
        Total number of available pods (ready for at least minReadySeconds) targeted by this statefulset.
        """
        return pulumi.get(self, "available_replicas")

    @_builtins.property
    @pulumi.getter(name="collisionCount")
    def collision_count(self) -> Optional[_builtins.int]:
        """
        collisionCount is the count of hash collisions for the StatefulSet. The StatefulSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.
        """
        return pulumi.get(self, "collision_count")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.StatefulSetCondition']]:
        """
        Represents the latest available observations of a statefulset's current state.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="currentReplicas")
    def current_replicas(self) -> Optional[_builtins.int]:
        """
        currentReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by currentRevision.
        """
        return pulumi.get(self, "current_replicas")

    @_builtins.property
    @pulumi.getter(name="currentRevision")
    def current_revision(self) -> Optional[_builtins.str]:
        """
        currentRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [0,currentReplicas).
        """
        return pulumi.get(self, "current_revision")

    @_builtins.property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[_builtins.int]:
        """
        observedGeneration is the most recent generation observed for this StatefulSet. It corresponds to the StatefulSet's generation, which is updated on mutation by the API Server.
        """
        return pulumi.get(self, "observed_generation")

    @_builtins.property
    @pulumi.getter(name="readyReplicas")
    def ready_replicas(self) -> Optional[_builtins.int]:
        """
        readyReplicas is the number of pods created for this StatefulSet with a Ready Condition.
        """
        return pulumi.get(self, "ready_replicas")

    @_builtins.property
    @pulumi.getter(name="updateRevision")
    def update_revision(self) -> Optional[_builtins.str]:
        """
        updateRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [replicas-updatedReplicas,replicas)
        """
        return pulumi.get(self, "update_revision")

    @_builtins.property
    @pulumi.getter(name="updatedReplicas")
    def updated_replicas(self) -> Optional[_builtins.int]:
        """
        updatedReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by updateRevision.
        """
        return pulumi.get(self, "updated_replicas")


@pulumi.output_type
class StatefulSetStatusPatch(dict):
    """
    StatefulSetStatus represents the current state of a StatefulSet.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availableReplicas":
            suggest = "available_replicas"
        elif key == "collisionCount":
            suggest = "collision_count"
        elif key == "currentReplicas":
            suggest = "current_replicas"
        elif key == "currentRevision":
            suggest = "current_revision"
        elif key == "observedGeneration":
            suggest = "observed_generation"
        elif key == "readyReplicas":
            suggest = "ready_replicas"
        elif key == "updateRevision":
            suggest = "update_revision"
        elif key == "updatedReplicas":
            suggest = "updated_replicas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StatefulSetStatusPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StatefulSetStatusPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StatefulSetStatusPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 available_replicas: Optional[_builtins.int] = None,
                 collision_count: Optional[_builtins.int] = None,
                 conditions: Optional[Sequence['outputs.StatefulSetConditionPatch']] = None,
                 current_replicas: Optional[_builtins.int] = None,
                 current_revision: Optional[_builtins.str] = None,
                 observed_generation: Optional[_builtins.int] = None,
                 ready_replicas: Optional[_builtins.int] = None,
                 replicas: Optional[_builtins.int] = None,
                 update_revision: Optional[_builtins.str] = None,
                 updated_replicas: Optional[_builtins.int] = None):
        """
        StatefulSetStatus represents the current state of a StatefulSet.
        :param _builtins.int available_replicas: Total number of available pods (ready for at least minReadySeconds) targeted by this statefulset.
        :param _builtins.int collision_count: collisionCount is the count of hash collisions for the StatefulSet. The StatefulSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.
        :param Sequence['StatefulSetConditionPatchArgs'] conditions: Represents the latest available observations of a statefulset's current state.
        :param _builtins.int current_replicas: currentReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by currentRevision.
        :param _builtins.str current_revision: currentRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [0,currentReplicas).
        :param _builtins.int observed_generation: observedGeneration is the most recent generation observed for this StatefulSet. It corresponds to the StatefulSet's generation, which is updated on mutation by the API Server.
        :param _builtins.int ready_replicas: readyReplicas is the number of pods created for this StatefulSet with a Ready Condition.
        :param _builtins.int replicas: replicas is the number of Pods created by the StatefulSet controller.
        :param _builtins.str update_revision: updateRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [replicas-updatedReplicas,replicas)
        :param _builtins.int updated_replicas: updatedReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by updateRevision.
        """
        if available_replicas is not None:
            pulumi.set(__self__, "available_replicas", available_replicas)
        if collision_count is not None:
            pulumi.set(__self__, "collision_count", collision_count)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if current_replicas is not None:
            pulumi.set(__self__, "current_replicas", current_replicas)
        if current_revision is not None:
            pulumi.set(__self__, "current_revision", current_revision)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if ready_replicas is not None:
            pulumi.set(__self__, "ready_replicas", ready_replicas)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if update_revision is not None:
            pulumi.set(__self__, "update_revision", update_revision)
        if updated_replicas is not None:
            pulumi.set(__self__, "updated_replicas", updated_replicas)

    @_builtins.property
    @pulumi.getter(name="availableReplicas")
    def available_replicas(self) -> Optional[_builtins.int]:
        """
        Total number of available pods (ready for at least minReadySeconds) targeted by this statefulset.
        """
        return pulumi.get(self, "available_replicas")

    @_builtins.property
    @pulumi.getter(name="collisionCount")
    def collision_count(self) -> Optional[_builtins.int]:
        """
        collisionCount is the count of hash collisions for the StatefulSet. The StatefulSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.
        """
        return pulumi.get(self, "collision_count")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.StatefulSetConditionPatch']]:
        """
        Represents the latest available observations of a statefulset's current state.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="currentReplicas")
    def current_replicas(self) -> Optional[_builtins.int]:
        """
        currentReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by currentRevision.
        """
        return pulumi.get(self, "current_replicas")

    @_builtins.property
    @pulumi.getter(name="currentRevision")
    def current_revision(self) -> Optional[_builtins.str]:
        """
        currentRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [0,currentReplicas).
        """
        return pulumi.get(self, "current_revision")

    @_builtins.property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[_builtins.int]:
        """
        observedGeneration is the most recent generation observed for this StatefulSet. It corresponds to the StatefulSet's generation, which is updated on mutation by the API Server.
        """
        return pulumi.get(self, "observed_generation")

    @_builtins.property
    @pulumi.getter(name="readyReplicas")
    def ready_replicas(self) -> Optional[_builtins.int]:
        """
        readyReplicas is the number of pods created for this StatefulSet with a Ready Condition.
        """
        return pulumi.get(self, "ready_replicas")

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> Optional[_builtins.int]:
        """
        replicas is the number of Pods created by the StatefulSet controller.
        """
        return pulumi.get(self, "replicas")

    @_builtins.property
    @pulumi.getter(name="updateRevision")
    def update_revision(self) -> Optional[_builtins.str]:
        """
        updateRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [replicas-updatedReplicas,replicas)
        """
        return pulumi.get(self, "update_revision")

    @_builtins.property
    @pulumi.getter(name="updatedReplicas")
    def updated_replicas(self) -> Optional[_builtins.int]:
        """
        updatedReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by updateRevision.
        """
        return pulumi.get(self, "updated_replicas")


@pulumi.output_type
class StatefulSetUpdateStrategy(dict):
    """
    StatefulSetUpdateStrategy indicates the strategy that the StatefulSet controller will use to perform updates. It includes any additional parameters necessary to perform the update for the indicated strategy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rollingUpdate":
            suggest = "rolling_update"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StatefulSetUpdateStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StatefulSetUpdateStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StatefulSetUpdateStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rolling_update: Optional['outputs.RollingUpdateStatefulSetStrategy'] = None,
                 type: Optional[_builtins.str] = None):
        """
        StatefulSetUpdateStrategy indicates the strategy that the StatefulSet controller will use to perform updates. It includes any additional parameters necessary to perform the update for the indicated strategy.
        :param 'RollingUpdateStatefulSetStrategyArgs' rolling_update: RollingUpdate is used to communicate parameters when Type is RollingUpdateStatefulSetStrategyType.
        :param _builtins.str type: Type indicates the type of the StatefulSetUpdateStrategy. Default is RollingUpdate.
        """
        if rolling_update is not None:
            pulumi.set(__self__, "rolling_update", rolling_update)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="rollingUpdate")
    def rolling_update(self) -> Optional['outputs.RollingUpdateStatefulSetStrategy']:
        """
        RollingUpdate is used to communicate parameters when Type is RollingUpdateStatefulSetStrategyType.
        """
        return pulumi.get(self, "rolling_update")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type indicates the type of the StatefulSetUpdateStrategy. Default is RollingUpdate.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class StatefulSetUpdateStrategyPatch(dict):
    """
    StatefulSetUpdateStrategy indicates the strategy that the StatefulSet controller will use to perform updates. It includes any additional parameters necessary to perform the update for the indicated strategy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rollingUpdate":
            suggest = "rolling_update"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StatefulSetUpdateStrategyPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StatefulSetUpdateStrategyPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StatefulSetUpdateStrategyPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rolling_update: Optional['outputs.RollingUpdateStatefulSetStrategyPatch'] = None,
                 type: Optional[_builtins.str] = None):
        """
        StatefulSetUpdateStrategy indicates the strategy that the StatefulSet controller will use to perform updates. It includes any additional parameters necessary to perform the update for the indicated strategy.
        :param 'RollingUpdateStatefulSetStrategyPatchArgs' rolling_update: RollingUpdate is used to communicate parameters when Type is RollingUpdateStatefulSetStrategyType.
        :param _builtins.str type: Type indicates the type of the StatefulSetUpdateStrategy. Default is RollingUpdate.
        """
        if rolling_update is not None:
            pulumi.set(__self__, "rolling_update", rolling_update)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="rollingUpdate")
    def rolling_update(self) -> Optional['outputs.RollingUpdateStatefulSetStrategyPatch']:
        """
        RollingUpdate is used to communicate parameters when Type is RollingUpdateStatefulSetStrategyType.
        """
        return pulumi.get(self, "rolling_update")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type indicates the type of the StatefulSetUpdateStrategy. Default is RollingUpdate.
        """
        return pulumi.get(self, "type")


