# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from ... import _utilities
from . import outputs
from ... import meta as _meta

__all__ = [
    'LeaseCandidate',
    'LeaseCandidateSpec',
    'LeaseCandidateSpecPatch',
]

@pulumi.output_type
class LeaseCandidate(dict):
    """
    LeaseCandidate defines a candidate for a Lease object. Candidates are created such that coordinated leader election will pick the best leader from the list of candidates.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LeaseCandidate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LeaseCandidate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LeaseCandidate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[_builtins.str] = None,
                 kind: Optional[_builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.LeaseCandidateSpec'] = None):
        """
        LeaseCandidate defines a candidate for a Lease object. Candidates are created such that coordinated leader election will pick the best leader from the list of candidates.
        :param _builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param _builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param 'LeaseCandidateSpecArgs' spec: spec contains the specification of the Lease. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'coordination.k8s.io/v1alpha1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'LeaseCandidate')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[_builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[_builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional['outputs.LeaseCandidateSpec']:
        """
        spec contains the specification of the Lease. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "spec")


@pulumi.output_type
class LeaseCandidateSpec(dict):
    """
    LeaseCandidateSpec is a specification of a Lease.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "leaseName":
            suggest = "lease_name"
        elif key == "preferredStrategies":
            suggest = "preferred_strategies"
        elif key == "binaryVersion":
            suggest = "binary_version"
        elif key == "emulationVersion":
            suggest = "emulation_version"
        elif key == "pingTime":
            suggest = "ping_time"
        elif key == "renewTime":
            suggest = "renew_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LeaseCandidateSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LeaseCandidateSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LeaseCandidateSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lease_name: _builtins.str,
                 preferred_strategies: Sequence[_builtins.str],
                 binary_version: Optional[_builtins.str] = None,
                 emulation_version: Optional[_builtins.str] = None,
                 ping_time: Optional[_builtins.str] = None,
                 renew_time: Optional[_builtins.str] = None):
        """
        LeaseCandidateSpec is a specification of a Lease.
        :param _builtins.str lease_name: LeaseName is the name of the lease for which this candidate is contending. This field is immutable.
        :param Sequence[_builtins.str] preferred_strategies: PreferredStrategies indicates the list of strategies for picking the leader for coordinated leader election. The list is ordered, and the first strategy supersedes all other strategies. The list is used by coordinated leader election to make a decision about the final election strategy. This follows as - If all clients have strategy X as the first element in this list, strategy X will be used. - If a candidate has strategy [X] and another candidate has strategy [Y, X], Y supersedes X and strategy Y
                 will be used.
               - If a candidate has strategy [X, Y] and another candidate has strategy [Y, X], this is a user error and leader
                 election will not operate the Lease until resolved.
               (Alpha) Using this field requires the CoordinatedLeaderElection feature gate to be enabled.
        :param _builtins.str binary_version: BinaryVersion is the binary version. It must be in a semver format without leading `v`. This field is required when strategy is "OldestEmulationVersion"
        :param _builtins.str emulation_version: EmulationVersion is the emulation version. It must be in a semver format without leading `v`. EmulationVersion must be less than or equal to BinaryVersion. This field is required when strategy is "OldestEmulationVersion"
        :param _builtins.str ping_time: PingTime is the last time that the server has requested the LeaseCandidate to renew. It is only done during leader election to check if any LeaseCandidates have become ineligible. When PingTime is updated, the LeaseCandidate will respond by updating RenewTime.
        :param _builtins.str renew_time: RenewTime is the time that the LeaseCandidate was last updated. Any time a Lease needs to do leader election, the PingTime field is updated to signal to the LeaseCandidate that they should update the RenewTime. Old LeaseCandidate objects are also garbage collected if it has been hours since the last renew. The PingTime field is updated regularly to prevent garbage collection for still active LeaseCandidates.
        """
        pulumi.set(__self__, "lease_name", lease_name)
        pulumi.set(__self__, "preferred_strategies", preferred_strategies)
        if binary_version is not None:
            pulumi.set(__self__, "binary_version", binary_version)
        if emulation_version is not None:
            pulumi.set(__self__, "emulation_version", emulation_version)
        if ping_time is not None:
            pulumi.set(__self__, "ping_time", ping_time)
        if renew_time is not None:
            pulumi.set(__self__, "renew_time", renew_time)

    @_builtins.property
    @pulumi.getter(name="leaseName")
    def lease_name(self) -> _builtins.str:
        """
        LeaseName is the name of the lease for which this candidate is contending. This field is immutable.
        """
        return pulumi.get(self, "lease_name")

    @_builtins.property
    @pulumi.getter(name="preferredStrategies")
    def preferred_strategies(self) -> Sequence[_builtins.str]:
        """
        PreferredStrategies indicates the list of strategies for picking the leader for coordinated leader election. The list is ordered, and the first strategy supersedes all other strategies. The list is used by coordinated leader election to make a decision about the final election strategy. This follows as - If all clients have strategy X as the first element in this list, strategy X will be used. - If a candidate has strategy [X] and another candidate has strategy [Y, X], Y supersedes X and strategy Y
          will be used.
        - If a candidate has strategy [X, Y] and another candidate has strategy [Y, X], this is a user error and leader
          election will not operate the Lease until resolved.
        (Alpha) Using this field requires the CoordinatedLeaderElection feature gate to be enabled.
        """
        return pulumi.get(self, "preferred_strategies")

    @_builtins.property
    @pulumi.getter(name="binaryVersion")
    def binary_version(self) -> Optional[_builtins.str]:
        """
        BinaryVersion is the binary version. It must be in a semver format without leading `v`. This field is required when strategy is "OldestEmulationVersion"
        """
        return pulumi.get(self, "binary_version")

    @_builtins.property
    @pulumi.getter(name="emulationVersion")
    def emulation_version(self) -> Optional[_builtins.str]:
        """
        EmulationVersion is the emulation version. It must be in a semver format without leading `v`. EmulationVersion must be less than or equal to BinaryVersion. This field is required when strategy is "OldestEmulationVersion"
        """
        return pulumi.get(self, "emulation_version")

    @_builtins.property
    @pulumi.getter(name="pingTime")
    def ping_time(self) -> Optional[_builtins.str]:
        """
        PingTime is the last time that the server has requested the LeaseCandidate to renew. It is only done during leader election to check if any LeaseCandidates have become ineligible. When PingTime is updated, the LeaseCandidate will respond by updating RenewTime.
        """
        return pulumi.get(self, "ping_time")

    @_builtins.property
    @pulumi.getter(name="renewTime")
    def renew_time(self) -> Optional[_builtins.str]:
        """
        RenewTime is the time that the LeaseCandidate was last updated. Any time a Lease needs to do leader election, the PingTime field is updated to signal to the LeaseCandidate that they should update the RenewTime. Old LeaseCandidate objects are also garbage collected if it has been hours since the last renew. The PingTime field is updated regularly to prevent garbage collection for still active LeaseCandidates.
        """
        return pulumi.get(self, "renew_time")


@pulumi.output_type
class LeaseCandidateSpecPatch(dict):
    """
    LeaseCandidateSpec is a specification of a Lease.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "binaryVersion":
            suggest = "binary_version"
        elif key == "emulationVersion":
            suggest = "emulation_version"
        elif key == "leaseName":
            suggest = "lease_name"
        elif key == "pingTime":
            suggest = "ping_time"
        elif key == "preferredStrategies":
            suggest = "preferred_strategies"
        elif key == "renewTime":
            suggest = "renew_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LeaseCandidateSpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LeaseCandidateSpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LeaseCandidateSpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 binary_version: Optional[_builtins.str] = None,
                 emulation_version: Optional[_builtins.str] = None,
                 lease_name: Optional[_builtins.str] = None,
                 ping_time: Optional[_builtins.str] = None,
                 preferred_strategies: Optional[Sequence[_builtins.str]] = None,
                 renew_time: Optional[_builtins.str] = None):
        """
        LeaseCandidateSpec is a specification of a Lease.
        :param _builtins.str binary_version: BinaryVersion is the binary version. It must be in a semver format without leading `v`. This field is required when strategy is "OldestEmulationVersion"
        :param _builtins.str emulation_version: EmulationVersion is the emulation version. It must be in a semver format without leading `v`. EmulationVersion must be less than or equal to BinaryVersion. This field is required when strategy is "OldestEmulationVersion"
        :param _builtins.str lease_name: LeaseName is the name of the lease for which this candidate is contending. This field is immutable.
        :param _builtins.str ping_time: PingTime is the last time that the server has requested the LeaseCandidate to renew. It is only done during leader election to check if any LeaseCandidates have become ineligible. When PingTime is updated, the LeaseCandidate will respond by updating RenewTime.
        :param Sequence[_builtins.str] preferred_strategies: PreferredStrategies indicates the list of strategies for picking the leader for coordinated leader election. The list is ordered, and the first strategy supersedes all other strategies. The list is used by coordinated leader election to make a decision about the final election strategy. This follows as - If all clients have strategy X as the first element in this list, strategy X will be used. - If a candidate has strategy [X] and another candidate has strategy [Y, X], Y supersedes X and strategy Y
                 will be used.
               - If a candidate has strategy [X, Y] and another candidate has strategy [Y, X], this is a user error and leader
                 election will not operate the Lease until resolved.
               (Alpha) Using this field requires the CoordinatedLeaderElection feature gate to be enabled.
        :param _builtins.str renew_time: RenewTime is the time that the LeaseCandidate was last updated. Any time a Lease needs to do leader election, the PingTime field is updated to signal to the LeaseCandidate that they should update the RenewTime. Old LeaseCandidate objects are also garbage collected if it has been hours since the last renew. The PingTime field is updated regularly to prevent garbage collection for still active LeaseCandidates.
        """
        if binary_version is not None:
            pulumi.set(__self__, "binary_version", binary_version)
        if emulation_version is not None:
            pulumi.set(__self__, "emulation_version", emulation_version)
        if lease_name is not None:
            pulumi.set(__self__, "lease_name", lease_name)
        if ping_time is not None:
            pulumi.set(__self__, "ping_time", ping_time)
        if preferred_strategies is not None:
            pulumi.set(__self__, "preferred_strategies", preferred_strategies)
        if renew_time is not None:
            pulumi.set(__self__, "renew_time", renew_time)

    @_builtins.property
    @pulumi.getter(name="binaryVersion")
    def binary_version(self) -> Optional[_builtins.str]:
        """
        BinaryVersion is the binary version. It must be in a semver format without leading `v`. This field is required when strategy is "OldestEmulationVersion"
        """
        return pulumi.get(self, "binary_version")

    @_builtins.property
    @pulumi.getter(name="emulationVersion")
    def emulation_version(self) -> Optional[_builtins.str]:
        """
        EmulationVersion is the emulation version. It must be in a semver format without leading `v`. EmulationVersion must be less than or equal to BinaryVersion. This field is required when strategy is "OldestEmulationVersion"
        """
        return pulumi.get(self, "emulation_version")

    @_builtins.property
    @pulumi.getter(name="leaseName")
    def lease_name(self) -> Optional[_builtins.str]:
        """
        LeaseName is the name of the lease for which this candidate is contending. This field is immutable.
        """
        return pulumi.get(self, "lease_name")

    @_builtins.property
    @pulumi.getter(name="pingTime")
    def ping_time(self) -> Optional[_builtins.str]:
        """
        PingTime is the last time that the server has requested the LeaseCandidate to renew. It is only done during leader election to check if any LeaseCandidates have become ineligible. When PingTime is updated, the LeaseCandidate will respond by updating RenewTime.
        """
        return pulumi.get(self, "ping_time")

    @_builtins.property
    @pulumi.getter(name="preferredStrategies")
    def preferred_strategies(self) -> Optional[Sequence[_builtins.str]]:
        """
        PreferredStrategies indicates the list of strategies for picking the leader for coordinated leader election. The list is ordered, and the first strategy supersedes all other strategies. The list is used by coordinated leader election to make a decision about the final election strategy. This follows as - If all clients have strategy X as the first element in this list, strategy X will be used. - If a candidate has strategy [X] and another candidate has strategy [Y, X], Y supersedes X and strategy Y
          will be used.
        - If a candidate has strategy [X, Y] and another candidate has strategy [Y, X], this is a user error and leader
          election will not operate the Lease until resolved.
        (Alpha) Using this field requires the CoordinatedLeaderElection feature gate to be enabled.
        """
        return pulumi.get(self, "preferred_strategies")

    @_builtins.property
    @pulumi.getter(name="renewTime")
    def renew_time(self) -> Optional[_builtins.str]:
        """
        RenewTime is the time that the LeaseCandidate was last updated. Any time a Lease needs to do leader election, the PingTime field is updated to signal to the LeaseCandidate that they should update the RenewTime. Old LeaseCandidate objects are also garbage collected if it has been hours since the last renew. The PingTime field is updated regularly to prevent garbage collection for still active LeaseCandidates.
        """
        return pulumi.get(self, "renew_time")


