# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from ... import _utilities
from . import outputs
from ... import meta as _meta
from ._enums import *

__all__ = [
    'AWSElasticBlockStoreVolumeSource',
    'AWSElasticBlockStoreVolumeSourcePatch',
    'Affinity',
    'AffinityPatch',
    'AppArmorProfile',
    'AppArmorProfilePatch',
    'AttachedVolume',
    'AttachedVolumePatch',
    'AzureDiskVolumeSource',
    'AzureDiskVolumeSourcePatch',
    'AzureFilePersistentVolumeSource',
    'AzureFilePersistentVolumeSourcePatch',
    'AzureFileVolumeSource',
    'AzureFileVolumeSourcePatch',
    'CSIPersistentVolumeSource',
    'CSIPersistentVolumeSourcePatch',
    'CSIVolumeSource',
    'CSIVolumeSourcePatch',
    'Capabilities',
    'CapabilitiesPatch',
    'CephFSPersistentVolumeSource',
    'CephFSPersistentVolumeSourcePatch',
    'CephFSVolumeSource',
    'CephFSVolumeSourcePatch',
    'CinderPersistentVolumeSource',
    'CinderPersistentVolumeSourcePatch',
    'CinderVolumeSource',
    'CinderVolumeSourcePatch',
    'ClaimSource',
    'ClaimSourcePatch',
    'ClientIPConfig',
    'ClientIPConfigPatch',
    'ClusterTrustBundleProjection',
    'ClusterTrustBundleProjectionPatch',
    'ConfigMap',
    'ConfigMapEnvSource',
    'ConfigMapEnvSourcePatch',
    'ConfigMapKeySelector',
    'ConfigMapKeySelectorPatch',
    'ConfigMapNodeConfigSource',
    'ConfigMapNodeConfigSourcePatch',
    'ConfigMapProjection',
    'ConfigMapProjectionPatch',
    'ConfigMapVolumeSource',
    'ConfigMapVolumeSourcePatch',
    'Container',
    'ContainerImage',
    'ContainerImagePatch',
    'ContainerPatch',
    'ContainerPort',
    'ContainerPortPatch',
    'ContainerResizePolicy',
    'ContainerResizePolicyPatch',
    'ContainerState',
    'ContainerStatePatch',
    'ContainerStateRunning',
    'ContainerStateRunningPatch',
    'ContainerStateTerminated',
    'ContainerStateTerminatedPatch',
    'ContainerStateWaiting',
    'ContainerStateWaitingPatch',
    'ContainerStatus',
    'ContainerStatusPatch',
    'ContainerUser',
    'ContainerUserPatch',
    'DaemonEndpoint',
    'DaemonEndpointPatch',
    'DownwardAPIProjection',
    'DownwardAPIProjectionPatch',
    'DownwardAPIVolumeFile',
    'DownwardAPIVolumeFilePatch',
    'DownwardAPIVolumeSource',
    'DownwardAPIVolumeSourcePatch',
    'EmptyDirVolumeSource',
    'EmptyDirVolumeSourcePatch',
    'EndpointAddress',
    'EndpointAddressPatch',
    'EndpointPort',
    'EndpointPortPatch',
    'EndpointSubset',
    'EndpointSubsetPatch',
    'Endpoints',
    'EnvFromSource',
    'EnvFromSourcePatch',
    'EnvVar',
    'EnvVarPatch',
    'EnvVarSource',
    'EnvVarSourcePatch',
    'EphemeralContainer',
    'EphemeralContainerPatch',
    'EphemeralVolumeSource',
    'EphemeralVolumeSourcePatch',
    'Event',
    'EventSeries',
    'EventSeriesPatch',
    'EventSource',
    'EventSourcePatch',
    'ExecAction',
    'ExecActionPatch',
    'FCVolumeSource',
    'FCVolumeSourcePatch',
    'FlexPersistentVolumeSource',
    'FlexPersistentVolumeSourcePatch',
    'FlexVolumeSource',
    'FlexVolumeSourcePatch',
    'FlockerVolumeSource',
    'FlockerVolumeSourcePatch',
    'GCEPersistentDiskVolumeSource',
    'GCEPersistentDiskVolumeSourcePatch',
    'GRPCAction',
    'GRPCActionPatch',
    'GitRepoVolumeSource',
    'GitRepoVolumeSourcePatch',
    'GlusterfsPersistentVolumeSource',
    'GlusterfsPersistentVolumeSourcePatch',
    'GlusterfsVolumeSource',
    'GlusterfsVolumeSourcePatch',
    'HTTPGetAction',
    'HTTPGetActionPatch',
    'HTTPHeader',
    'HTTPHeaderPatch',
    'HostAlias',
    'HostAliasPatch',
    'HostIP',
    'HostIPPatch',
    'HostPathVolumeSource',
    'HostPathVolumeSourcePatch',
    'ISCSIPersistentVolumeSource',
    'ISCSIPersistentVolumeSourcePatch',
    'ISCSIVolumeSource',
    'ISCSIVolumeSourcePatch',
    'ImageVolumeSource',
    'ImageVolumeSourcePatch',
    'KeyToPath',
    'KeyToPathPatch',
    'Lifecycle',
    'LifecycleHandler',
    'LifecycleHandlerPatch',
    'LifecyclePatch',
    'LimitRange',
    'LimitRangeItem',
    'LimitRangeItemPatch',
    'LimitRangeSpec',
    'LimitRangeSpecPatch',
    'LinuxContainerUser',
    'LinuxContainerUserPatch',
    'LoadBalancerIngress',
    'LoadBalancerIngressPatch',
    'LoadBalancerStatus',
    'LoadBalancerStatusPatch',
    'LocalObjectReference',
    'LocalObjectReferencePatch',
    'LocalVolumeSource',
    'LocalVolumeSourcePatch',
    'ModifyVolumeStatus',
    'ModifyVolumeStatusPatch',
    'NFSVolumeSource',
    'NFSVolumeSourcePatch',
    'Namespace',
    'NamespaceCondition',
    'NamespaceConditionPatch',
    'NamespaceSpec',
    'NamespaceSpecPatch',
    'NamespaceStatus',
    'NamespaceStatusPatch',
    'Node',
    'NodeAddress',
    'NodeAddressPatch',
    'NodeAffinity',
    'NodeAffinityPatch',
    'NodeCondition',
    'NodeConditionPatch',
    'NodeConfigSource',
    'NodeConfigSourcePatch',
    'NodeConfigStatus',
    'NodeConfigStatusPatch',
    'NodeDaemonEndpoints',
    'NodeDaemonEndpointsPatch',
    'NodeFeatures',
    'NodeFeaturesPatch',
    'NodeRuntimeHandler',
    'NodeRuntimeHandlerFeatures',
    'NodeRuntimeHandlerFeaturesPatch',
    'NodeRuntimeHandlerPatch',
    'NodeSelector',
    'NodeSelectorPatch',
    'NodeSelectorRequirement',
    'NodeSelectorRequirementPatch',
    'NodeSelectorTerm',
    'NodeSelectorTermPatch',
    'NodeSpec',
    'NodeSpecPatch',
    'NodeStatus',
    'NodeStatusPatch',
    'NodeSwapStatus',
    'NodeSwapStatusPatch',
    'NodeSystemInfo',
    'NodeSystemInfoPatch',
    'ObjectFieldSelector',
    'ObjectFieldSelectorPatch',
    'ObjectReference',
    'ObjectReferencePatch',
    'PersistentVolume',
    'PersistentVolumeClaim',
    'PersistentVolumeClaimCondition',
    'PersistentVolumeClaimConditionPatch',
    'PersistentVolumeClaimPatch',
    'PersistentVolumeClaimSpec',
    'PersistentVolumeClaimSpecPatch',
    'PersistentVolumeClaimStatus',
    'PersistentVolumeClaimStatusPatch',
    'PersistentVolumeClaimTemplate',
    'PersistentVolumeClaimTemplatePatch',
    'PersistentVolumeClaimVolumeSource',
    'PersistentVolumeClaimVolumeSourcePatch',
    'PersistentVolumeSpec',
    'PersistentVolumeSpecPatch',
    'PersistentVolumeStatus',
    'PersistentVolumeStatusPatch',
    'PhotonPersistentDiskVolumeSource',
    'PhotonPersistentDiskVolumeSourcePatch',
    'Pod',
    'PodAffinity',
    'PodAffinityPatch',
    'PodAffinityTerm',
    'PodAffinityTermPatch',
    'PodAntiAffinity',
    'PodAntiAffinityPatch',
    'PodCondition',
    'PodConditionPatch',
    'PodDNSConfig',
    'PodDNSConfigOption',
    'PodDNSConfigOptionPatch',
    'PodDNSConfigPatch',
    'PodIP',
    'PodIPPatch',
    'PodOS',
    'PodOSPatch',
    'PodReadinessGate',
    'PodReadinessGatePatch',
    'PodResourceClaim',
    'PodResourceClaimPatch',
    'PodResourceClaimStatus',
    'PodResourceClaimStatusPatch',
    'PodSchedulingGate',
    'PodSchedulingGatePatch',
    'PodSecurityContext',
    'PodSecurityContextPatch',
    'PodSpec',
    'PodSpecPatch',
    'PodStatus',
    'PodStatusPatch',
    'PodTemplate',
    'PodTemplateSpec',
    'PodTemplateSpecPatch',
    'PortStatus',
    'PortStatusPatch',
    'PortworxVolumeSource',
    'PortworxVolumeSourcePatch',
    'PreferredSchedulingTerm',
    'PreferredSchedulingTermPatch',
    'Probe',
    'ProbePatch',
    'ProjectedVolumeSource',
    'ProjectedVolumeSourcePatch',
    'QuobyteVolumeSource',
    'QuobyteVolumeSourcePatch',
    'RBDPersistentVolumeSource',
    'RBDPersistentVolumeSourcePatch',
    'RBDVolumeSource',
    'RBDVolumeSourcePatch',
    'ReplicationController',
    'ReplicationControllerCondition',
    'ReplicationControllerConditionPatch',
    'ReplicationControllerSpec',
    'ReplicationControllerSpecPatch',
    'ReplicationControllerStatus',
    'ReplicationControllerStatusPatch',
    'ResourceClaim',
    'ResourceClaimPatch',
    'ResourceFieldSelector',
    'ResourceFieldSelectorPatch',
    'ResourceHealth',
    'ResourceHealthPatch',
    'ResourceQuota',
    'ResourceQuotaSpec',
    'ResourceQuotaSpecPatch',
    'ResourceQuotaStatus',
    'ResourceQuotaStatusPatch',
    'ResourceRequirements',
    'ResourceRequirementsPatch',
    'ResourceStatus',
    'ResourceStatusPatch',
    'SELinuxOptions',
    'SELinuxOptionsPatch',
    'ScaleIOPersistentVolumeSource',
    'ScaleIOPersistentVolumeSourcePatch',
    'ScaleIOVolumeSource',
    'ScaleIOVolumeSourcePatch',
    'ScopeSelector',
    'ScopeSelectorPatch',
    'ScopedResourceSelectorRequirement',
    'ScopedResourceSelectorRequirementPatch',
    'SeccompProfile',
    'SeccompProfilePatch',
    'Secret',
    'SecretEnvSource',
    'SecretEnvSourcePatch',
    'SecretKeySelector',
    'SecretKeySelectorPatch',
    'SecretProjection',
    'SecretProjectionPatch',
    'SecretReference',
    'SecretReferencePatch',
    'SecretVolumeSource',
    'SecretVolumeSourcePatch',
    'SecurityContext',
    'SecurityContextPatch',
    'Service',
    'ServiceAccount',
    'ServiceAccountTokenProjection',
    'ServiceAccountTokenProjectionPatch',
    'ServicePort',
    'ServicePortPatch',
    'ServiceSpec',
    'ServiceSpecPatch',
    'ServiceStatus',
    'ServiceStatusPatch',
    'SessionAffinityConfig',
    'SessionAffinityConfigPatch',
    'SleepAction',
    'SleepActionPatch',
    'StorageOSPersistentVolumeSource',
    'StorageOSPersistentVolumeSourcePatch',
    'StorageOSVolumeSource',
    'StorageOSVolumeSourcePatch',
    'Sysctl',
    'SysctlPatch',
    'TCPSocketAction',
    'TCPSocketActionPatch',
    'Taint',
    'TaintPatch',
    'Toleration',
    'TolerationPatch',
    'TopologySelectorLabelRequirement',
    'TopologySelectorLabelRequirementPatch',
    'TopologySelectorTerm',
    'TopologySelectorTermPatch',
    'TopologySpreadConstraint',
    'TopologySpreadConstraintPatch',
    'TypedLocalObjectReference',
    'TypedLocalObjectReferencePatch',
    'TypedObjectReference',
    'TypedObjectReferencePatch',
    'Volume',
    'VolumeDevice',
    'VolumeDevicePatch',
    'VolumeMount',
    'VolumeMountPatch',
    'VolumeMountStatus',
    'VolumeMountStatusPatch',
    'VolumeNodeAffinity',
    'VolumeNodeAffinityPatch',
    'VolumePatch',
    'VolumeProjection',
    'VolumeProjectionPatch',
    'VolumeResourceRequirements',
    'VolumeResourceRequirementsPatch',
    'VsphereVirtualDiskVolumeSource',
    'VsphereVirtualDiskVolumeSourcePatch',
    'WeightedPodAffinityTerm',
    'WeightedPodAffinityTermPatch',
    'WindowsSecurityContextOptions',
    'WindowsSecurityContextOptionsPatch',
]

@pulumi.output_type
class AWSElasticBlockStoreVolumeSource(dict):
    """
    Represents a Persistent Disk resource in AWS.

    An AWS EBS disk must exist before mounting to a container. The disk must also be in the same AWS zone as the kubelet. An AWS EBS disk can only be mounted as read/write once. AWS EBS volumes support ownership management and SELinux relabeling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "volumeID":
            suggest = "volume_id"
        elif key == "fsType":
            suggest = "fs_type"
        elif key == "readOnly":
            suggest = "read_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AWSElasticBlockStoreVolumeSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AWSElasticBlockStoreVolumeSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AWSElasticBlockStoreVolumeSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 volume_id: _builtins.str,
                 fs_type: Optional[_builtins.str] = None,
                 partition: Optional[_builtins.int] = None,
                 read_only: Optional[_builtins.bool] = None):
        """
        Represents a Persistent Disk resource in AWS.

        An AWS EBS disk must exist before mounting to a container. The disk must also be in the same AWS zone as the kubelet. An AWS EBS disk can only be mounted as read/write once. AWS EBS volumes support ownership management and SELinux relabeling.
        :param _builtins.str volume_id: volumeID is unique ID of the persistent disk resource in AWS (Amazon EBS volume). More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        :param _builtins.str fs_type: fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        :param _builtins.int partition: partition is the partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty).
        :param _builtins.bool read_only: readOnly value true will force the readOnly setting in VolumeMounts. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        """
        pulumi.set(__self__, "volume_id", volume_id)
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @_builtins.property
    @pulumi.getter(name="volumeID")
    def volume_id(self) -> _builtins.str:
        """
        volumeID is unique ID of the persistent disk resource in AWS (Amazon EBS volume). More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        """
        return pulumi.get(self, "volume_id")

    @_builtins.property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[_builtins.str]:
        """
        fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        """
        return pulumi.get(self, "fs_type")

    @_builtins.property
    @pulumi.getter
    def partition(self) -> Optional[_builtins.int]:
        """
        partition is the partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty).
        """
        return pulumi.get(self, "partition")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        readOnly value true will force the readOnly setting in VolumeMounts. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        """
        return pulumi.get(self, "read_only")


@pulumi.output_type
class AWSElasticBlockStoreVolumeSourcePatch(dict):
    """
    Represents a Persistent Disk resource in AWS.

    An AWS EBS disk must exist before mounting to a container. The disk must also be in the same AWS zone as the kubelet. An AWS EBS disk can only be mounted as read/write once. AWS EBS volumes support ownership management and SELinux relabeling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fsType":
            suggest = "fs_type"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "volumeID":
            suggest = "volume_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AWSElasticBlockStoreVolumeSourcePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AWSElasticBlockStoreVolumeSourcePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AWSElasticBlockStoreVolumeSourcePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fs_type: Optional[_builtins.str] = None,
                 partition: Optional[_builtins.int] = None,
                 read_only: Optional[_builtins.bool] = None,
                 volume_id: Optional[_builtins.str] = None):
        """
        Represents a Persistent Disk resource in AWS.

        An AWS EBS disk must exist before mounting to a container. The disk must also be in the same AWS zone as the kubelet. An AWS EBS disk can only be mounted as read/write once. AWS EBS volumes support ownership management and SELinux relabeling.
        :param _builtins.str fs_type: fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        :param _builtins.int partition: partition is the partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty).
        :param _builtins.bool read_only: readOnly value true will force the readOnly setting in VolumeMounts. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        :param _builtins.str volume_id: volumeID is unique ID of the persistent disk resource in AWS (Amazon EBS volume). More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        """
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)

    @_builtins.property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[_builtins.str]:
        """
        fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        """
        return pulumi.get(self, "fs_type")

    @_builtins.property
    @pulumi.getter
    def partition(self) -> Optional[_builtins.int]:
        """
        partition is the partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty).
        """
        return pulumi.get(self, "partition")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        readOnly value true will force the readOnly setting in VolumeMounts. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter(name="volumeID")
    def volume_id(self) -> Optional[_builtins.str]:
        """
        volumeID is unique ID of the persistent disk resource in AWS (Amazon EBS volume). More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        """
        return pulumi.get(self, "volume_id")


@pulumi.output_type
class Affinity(dict):
    """
    Affinity is a group of affinity scheduling rules.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeAffinity":
            suggest = "node_affinity"
        elif key == "podAffinity":
            suggest = "pod_affinity"
        elif key == "podAntiAffinity":
            suggest = "pod_anti_affinity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Affinity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Affinity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Affinity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_affinity: Optional['outputs.NodeAffinity'] = None,
                 pod_affinity: Optional['outputs.PodAffinity'] = None,
                 pod_anti_affinity: Optional['outputs.PodAntiAffinity'] = None):
        """
        Affinity is a group of affinity scheduling rules.
        :param 'NodeAffinityArgs' node_affinity: Describes node affinity scheduling rules for the pod.
        :param 'PodAffinityArgs' pod_affinity: Describes pod affinity scheduling rules (e.g. co-locate this pod in the same node, zone, etc. as some other pod(s)).
        :param 'PodAntiAffinityArgs' pod_anti_affinity: Describes pod anti-affinity scheduling rules (e.g. avoid putting this pod in the same node, zone, etc. as some other pod(s)).
        """
        if node_affinity is not None:
            pulumi.set(__self__, "node_affinity", node_affinity)
        if pod_affinity is not None:
            pulumi.set(__self__, "pod_affinity", pod_affinity)
        if pod_anti_affinity is not None:
            pulumi.set(__self__, "pod_anti_affinity", pod_anti_affinity)

    @_builtins.property
    @pulumi.getter(name="nodeAffinity")
    def node_affinity(self) -> Optional['outputs.NodeAffinity']:
        """
        Describes node affinity scheduling rules for the pod.
        """
        return pulumi.get(self, "node_affinity")

    @_builtins.property
    @pulumi.getter(name="podAffinity")
    def pod_affinity(self) -> Optional['outputs.PodAffinity']:
        """
        Describes pod affinity scheduling rules (e.g. co-locate this pod in the same node, zone, etc. as some other pod(s)).
        """
        return pulumi.get(self, "pod_affinity")

    @_builtins.property
    @pulumi.getter(name="podAntiAffinity")
    def pod_anti_affinity(self) -> Optional['outputs.PodAntiAffinity']:
        """
        Describes pod anti-affinity scheduling rules (e.g. avoid putting this pod in the same node, zone, etc. as some other pod(s)).
        """
        return pulumi.get(self, "pod_anti_affinity")


@pulumi.output_type
class AffinityPatch(dict):
    """
    Affinity is a group of affinity scheduling rules.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeAffinity":
            suggest = "node_affinity"
        elif key == "podAffinity":
            suggest = "pod_affinity"
        elif key == "podAntiAffinity":
            suggest = "pod_anti_affinity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AffinityPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AffinityPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AffinityPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_affinity: Optional['outputs.NodeAffinityPatch'] = None,
                 pod_affinity: Optional['outputs.PodAffinityPatch'] = None,
                 pod_anti_affinity: Optional['outputs.PodAntiAffinityPatch'] = None):
        """
        Affinity is a group of affinity scheduling rules.
        :param 'NodeAffinityPatchArgs' node_affinity: Describes node affinity scheduling rules for the pod.
        :param 'PodAffinityPatchArgs' pod_affinity: Describes pod affinity scheduling rules (e.g. co-locate this pod in the same node, zone, etc. as some other pod(s)).
        :param 'PodAntiAffinityPatchArgs' pod_anti_affinity: Describes pod anti-affinity scheduling rules (e.g. avoid putting this pod in the same node, zone, etc. as some other pod(s)).
        """
        if node_affinity is not None:
            pulumi.set(__self__, "node_affinity", node_affinity)
        if pod_affinity is not None:
            pulumi.set(__self__, "pod_affinity", pod_affinity)
        if pod_anti_affinity is not None:
            pulumi.set(__self__, "pod_anti_affinity", pod_anti_affinity)

    @_builtins.property
    @pulumi.getter(name="nodeAffinity")
    def node_affinity(self) -> Optional['outputs.NodeAffinityPatch']:
        """
        Describes node affinity scheduling rules for the pod.
        """
        return pulumi.get(self, "node_affinity")

    @_builtins.property
    @pulumi.getter(name="podAffinity")
    def pod_affinity(self) -> Optional['outputs.PodAffinityPatch']:
        """
        Describes pod affinity scheduling rules (e.g. co-locate this pod in the same node, zone, etc. as some other pod(s)).
        """
        return pulumi.get(self, "pod_affinity")

    @_builtins.property
    @pulumi.getter(name="podAntiAffinity")
    def pod_anti_affinity(self) -> Optional['outputs.PodAntiAffinityPatch']:
        """
        Describes pod anti-affinity scheduling rules (e.g. avoid putting this pod in the same node, zone, etc. as some other pod(s)).
        """
        return pulumi.get(self, "pod_anti_affinity")


@pulumi.output_type
class AppArmorProfile(dict):
    """
    AppArmorProfile defines a pod or container's AppArmor settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localhostProfile":
            suggest = "localhost_profile"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppArmorProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppArmorProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppArmorProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 localhost_profile: Optional[_builtins.str] = None):
        """
        AppArmorProfile defines a pod or container's AppArmor settings.
        :param _builtins.str type: type indicates which kind of AppArmor profile will be applied. Valid options are:
                 Localhost - a profile pre-loaded on the node.
                 RuntimeDefault - the container runtime's default profile.
                 Unconfined - no AppArmor enforcement.
        :param _builtins.str localhost_profile: localhostProfile indicates a profile loaded on the node that should be used. The profile must be preconfigured on the node to work. Must match the loaded name of the profile. Must be set if and only if type is "Localhost".
        """
        pulumi.set(__self__, "type", type)
        if localhost_profile is not None:
            pulumi.set(__self__, "localhost_profile", localhost_profile)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        type indicates which kind of AppArmor profile will be applied. Valid options are:
          Localhost - a profile pre-loaded on the node.
          RuntimeDefault - the container runtime's default profile.
          Unconfined - no AppArmor enforcement.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="localhostProfile")
    def localhost_profile(self) -> Optional[_builtins.str]:
        """
        localhostProfile indicates a profile loaded on the node that should be used. The profile must be preconfigured on the node to work. Must match the loaded name of the profile. Must be set if and only if type is "Localhost".
        """
        return pulumi.get(self, "localhost_profile")


@pulumi.output_type
class AppArmorProfilePatch(dict):
    """
    AppArmorProfile defines a pod or container's AppArmor settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localhostProfile":
            suggest = "localhost_profile"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppArmorProfilePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppArmorProfilePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppArmorProfilePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 localhost_profile: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        AppArmorProfile defines a pod or container's AppArmor settings.
        :param _builtins.str localhost_profile: localhostProfile indicates a profile loaded on the node that should be used. The profile must be preconfigured on the node to work. Must match the loaded name of the profile. Must be set if and only if type is "Localhost".
        :param _builtins.str type: type indicates which kind of AppArmor profile will be applied. Valid options are:
                 Localhost - a profile pre-loaded on the node.
                 RuntimeDefault - the container runtime's default profile.
                 Unconfined - no AppArmor enforcement.
        """
        if localhost_profile is not None:
            pulumi.set(__self__, "localhost_profile", localhost_profile)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="localhostProfile")
    def localhost_profile(self) -> Optional[_builtins.str]:
        """
        localhostProfile indicates a profile loaded on the node that should be used. The profile must be preconfigured on the node to work. Must match the loaded name of the profile. Must be set if and only if type is "Localhost".
        """
        return pulumi.get(self, "localhost_profile")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        type indicates which kind of AppArmor profile will be applied. Valid options are:
          Localhost - a profile pre-loaded on the node.
          RuntimeDefault - the container runtime's default profile.
          Unconfined - no AppArmor enforcement.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class AttachedVolume(dict):
    """
    AttachedVolume describes a volume attached to a node
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "devicePath":
            suggest = "device_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AttachedVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AttachedVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AttachedVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_path: _builtins.str,
                 name: _builtins.str):
        """
        AttachedVolume describes a volume attached to a node
        :param _builtins.str device_path: DevicePath represents the device path where the volume should be available
        :param _builtins.str name: Name of the attached volume
        """
        pulumi.set(__self__, "device_path", device_path)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="devicePath")
    def device_path(self) -> _builtins.str:
        """
        DevicePath represents the device path where the volume should be available
        """
        return pulumi.get(self, "device_path")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the attached volume
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class AttachedVolumePatch(dict):
    """
    AttachedVolume describes a volume attached to a node
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "devicePath":
            suggest = "device_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AttachedVolumePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AttachedVolumePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AttachedVolumePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_path: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None):
        """
        AttachedVolume describes a volume attached to a node
        :param _builtins.str device_path: DevicePath represents the device path where the volume should be available
        :param _builtins.str name: Name of the attached volume
        """
        if device_path is not None:
            pulumi.set(__self__, "device_path", device_path)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="devicePath")
    def device_path(self) -> Optional[_builtins.str]:
        """
        DevicePath represents the device path where the volume should be available
        """
        return pulumi.get(self, "device_path")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the attached volume
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class AzureDiskVolumeSource(dict):
    """
    AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskName":
            suggest = "disk_name"
        elif key == "diskURI":
            suggest = "disk_uri"
        elif key == "cachingMode":
            suggest = "caching_mode"
        elif key == "fsType":
            suggest = "fs_type"
        elif key == "readOnly":
            suggest = "read_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureDiskVolumeSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureDiskVolumeSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureDiskVolumeSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_name: _builtins.str,
                 disk_uri: _builtins.str,
                 caching_mode: Optional[_builtins.str] = None,
                 fs_type: Optional[_builtins.str] = None,
                 kind: Optional[_builtins.str] = None,
                 read_only: Optional[_builtins.bool] = None):
        """
        AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.
        :param _builtins.str disk_name: diskName is the Name of the data disk in the blob storage
        :param _builtins.str disk_uri: diskURI is the URI of data disk in the blob storage
        :param _builtins.str caching_mode: cachingMode is the Host Caching mode: None, Read Only, Read Write.
        :param _builtins.str fs_type: fsType is Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
        :param _builtins.str kind: kind expected values are Shared: multiple blob disks per storage account  Dedicated: single blob disk per storage account  Managed: azure managed data disk (only in managed availability set). defaults to shared
        :param _builtins.bool read_only: readOnly Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        """
        pulumi.set(__self__, "disk_name", disk_name)
        pulumi.set(__self__, "disk_uri", disk_uri)
        if caching_mode is not None:
            pulumi.set(__self__, "caching_mode", caching_mode)
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @_builtins.property
    @pulumi.getter(name="diskName")
    def disk_name(self) -> _builtins.str:
        """
        diskName is the Name of the data disk in the blob storage
        """
        return pulumi.get(self, "disk_name")

    @_builtins.property
    @pulumi.getter(name="diskURI")
    def disk_uri(self) -> _builtins.str:
        """
        diskURI is the URI of data disk in the blob storage
        """
        return pulumi.get(self, "disk_uri")

    @_builtins.property
    @pulumi.getter(name="cachingMode")
    def caching_mode(self) -> Optional[_builtins.str]:
        """
        cachingMode is the Host Caching mode: None, Read Only, Read Write.
        """
        return pulumi.get(self, "caching_mode")

    @_builtins.property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[_builtins.str]:
        """
        fsType is Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
        """
        return pulumi.get(self, "fs_type")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[_builtins.str]:
        """
        kind expected values are Shared: multiple blob disks per storage account  Dedicated: single blob disk per storage account  Managed: azure managed data disk (only in managed availability set). defaults to shared
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        readOnly Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        """
        return pulumi.get(self, "read_only")


@pulumi.output_type
class AzureDiskVolumeSourcePatch(dict):
    """
    AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cachingMode":
            suggest = "caching_mode"
        elif key == "diskName":
            suggest = "disk_name"
        elif key == "diskURI":
            suggest = "disk_uri"
        elif key == "fsType":
            suggest = "fs_type"
        elif key == "readOnly":
            suggest = "read_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureDiskVolumeSourcePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureDiskVolumeSourcePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureDiskVolumeSourcePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 caching_mode: Optional[_builtins.str] = None,
                 disk_name: Optional[_builtins.str] = None,
                 disk_uri: Optional[_builtins.str] = None,
                 fs_type: Optional[_builtins.str] = None,
                 kind: Optional[_builtins.str] = None,
                 read_only: Optional[_builtins.bool] = None):
        """
        AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.
        :param _builtins.str caching_mode: cachingMode is the Host Caching mode: None, Read Only, Read Write.
        :param _builtins.str disk_name: diskName is the Name of the data disk in the blob storage
        :param _builtins.str disk_uri: diskURI is the URI of data disk in the blob storage
        :param _builtins.str fs_type: fsType is Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
        :param _builtins.str kind: kind expected values are Shared: multiple blob disks per storage account  Dedicated: single blob disk per storage account  Managed: azure managed data disk (only in managed availability set). defaults to shared
        :param _builtins.bool read_only: readOnly Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        """
        if caching_mode is not None:
            pulumi.set(__self__, "caching_mode", caching_mode)
        if disk_name is not None:
            pulumi.set(__self__, "disk_name", disk_name)
        if disk_uri is not None:
            pulumi.set(__self__, "disk_uri", disk_uri)
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @_builtins.property
    @pulumi.getter(name="cachingMode")
    def caching_mode(self) -> Optional[_builtins.str]:
        """
        cachingMode is the Host Caching mode: None, Read Only, Read Write.
        """
        return pulumi.get(self, "caching_mode")

    @_builtins.property
    @pulumi.getter(name="diskName")
    def disk_name(self) -> Optional[_builtins.str]:
        """
        diskName is the Name of the data disk in the blob storage
        """
        return pulumi.get(self, "disk_name")

    @_builtins.property
    @pulumi.getter(name="diskURI")
    def disk_uri(self) -> Optional[_builtins.str]:
        """
        diskURI is the URI of data disk in the blob storage
        """
        return pulumi.get(self, "disk_uri")

    @_builtins.property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[_builtins.str]:
        """
        fsType is Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
        """
        return pulumi.get(self, "fs_type")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[_builtins.str]:
        """
        kind expected values are Shared: multiple blob disks per storage account  Dedicated: single blob disk per storage account  Managed: azure managed data disk (only in managed availability set). defaults to shared
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        readOnly Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        """
        return pulumi.get(self, "read_only")


@pulumi.output_type
class AzureFilePersistentVolumeSource(dict):
    """
    AzureFile represents an Azure File Service mount on the host and bind mount to the pod.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretName":
            suggest = "secret_name"
        elif key == "shareName":
            suggest = "share_name"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "secretNamespace":
            suggest = "secret_namespace"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureFilePersistentVolumeSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureFilePersistentVolumeSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureFilePersistentVolumeSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_name: _builtins.str,
                 share_name: _builtins.str,
                 read_only: Optional[_builtins.bool] = None,
                 secret_namespace: Optional[_builtins.str] = None):
        """
        AzureFile represents an Azure File Service mount on the host and bind mount to the pod.
        :param _builtins.str secret_name: secretName is the name of secret that contains Azure Storage Account Name and Key
        :param _builtins.str share_name: shareName is the azure Share Name
        :param _builtins.bool read_only: readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        :param _builtins.str secret_namespace: secretNamespace is the namespace of the secret that contains Azure Storage Account Name and Key default is the same as the Pod
        """
        pulumi.set(__self__, "secret_name", secret_name)
        pulumi.set(__self__, "share_name", share_name)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if secret_namespace is not None:
            pulumi.set(__self__, "secret_namespace", secret_namespace)

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> _builtins.str:
        """
        secretName is the name of secret that contains Azure Storage Account Name and Key
        """
        return pulumi.get(self, "secret_name")

    @_builtins.property
    @pulumi.getter(name="shareName")
    def share_name(self) -> _builtins.str:
        """
        shareName is the azure Share Name
        """
        return pulumi.get(self, "share_name")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter(name="secretNamespace")
    def secret_namespace(self) -> Optional[_builtins.str]:
        """
        secretNamespace is the namespace of the secret that contains Azure Storage Account Name and Key default is the same as the Pod
        """
        return pulumi.get(self, "secret_namespace")


@pulumi.output_type
class AzureFilePersistentVolumeSourcePatch(dict):
    """
    AzureFile represents an Azure File Service mount on the host and bind mount to the pod.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "readOnly":
            suggest = "read_only"
        elif key == "secretName":
            suggest = "secret_name"
        elif key == "secretNamespace":
            suggest = "secret_namespace"
        elif key == "shareName":
            suggest = "share_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureFilePersistentVolumeSourcePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureFilePersistentVolumeSourcePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureFilePersistentVolumeSourcePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 read_only: Optional[_builtins.bool] = None,
                 secret_name: Optional[_builtins.str] = None,
                 secret_namespace: Optional[_builtins.str] = None,
                 share_name: Optional[_builtins.str] = None):
        """
        AzureFile represents an Azure File Service mount on the host and bind mount to the pod.
        :param _builtins.bool read_only: readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        :param _builtins.str secret_name: secretName is the name of secret that contains Azure Storage Account Name and Key
        :param _builtins.str secret_namespace: secretNamespace is the namespace of the secret that contains Azure Storage Account Name and Key default is the same as the Pod
        :param _builtins.str share_name: shareName is the azure Share Name
        """
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)
        if secret_namespace is not None:
            pulumi.set(__self__, "secret_namespace", secret_namespace)
        if share_name is not None:
            pulumi.set(__self__, "share_name", share_name)

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[_builtins.str]:
        """
        secretName is the name of secret that contains Azure Storage Account Name and Key
        """
        return pulumi.get(self, "secret_name")

    @_builtins.property
    @pulumi.getter(name="secretNamespace")
    def secret_namespace(self) -> Optional[_builtins.str]:
        """
        secretNamespace is the namespace of the secret that contains Azure Storage Account Name and Key default is the same as the Pod
        """
        return pulumi.get(self, "secret_namespace")

    @_builtins.property
    @pulumi.getter(name="shareName")
    def share_name(self) -> Optional[_builtins.str]:
        """
        shareName is the azure Share Name
        """
        return pulumi.get(self, "share_name")


@pulumi.output_type
class AzureFileVolumeSource(dict):
    """
    AzureFile represents an Azure File Service mount on the host and bind mount to the pod.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretName":
            suggest = "secret_name"
        elif key == "shareName":
            suggest = "share_name"
        elif key == "readOnly":
            suggest = "read_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureFileVolumeSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureFileVolumeSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureFileVolumeSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_name: _builtins.str,
                 share_name: _builtins.str,
                 read_only: Optional[_builtins.bool] = None):
        """
        AzureFile represents an Azure File Service mount on the host and bind mount to the pod.
        :param _builtins.str secret_name: secretName is the  name of secret that contains Azure Storage Account Name and Key
        :param _builtins.str share_name: shareName is the azure share Name
        :param _builtins.bool read_only: readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        """
        pulumi.set(__self__, "secret_name", secret_name)
        pulumi.set(__self__, "share_name", share_name)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> _builtins.str:
        """
        secretName is the  name of secret that contains Azure Storage Account Name and Key
        """
        return pulumi.get(self, "secret_name")

    @_builtins.property
    @pulumi.getter(name="shareName")
    def share_name(self) -> _builtins.str:
        """
        shareName is the azure share Name
        """
        return pulumi.get(self, "share_name")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        """
        return pulumi.get(self, "read_only")


@pulumi.output_type
class AzureFileVolumeSourcePatch(dict):
    """
    AzureFile represents an Azure File Service mount on the host and bind mount to the pod.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "readOnly":
            suggest = "read_only"
        elif key == "secretName":
            suggest = "secret_name"
        elif key == "shareName":
            suggest = "share_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureFileVolumeSourcePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureFileVolumeSourcePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureFileVolumeSourcePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 read_only: Optional[_builtins.bool] = None,
                 secret_name: Optional[_builtins.str] = None,
                 share_name: Optional[_builtins.str] = None):
        """
        AzureFile represents an Azure File Service mount on the host and bind mount to the pod.
        :param _builtins.bool read_only: readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        :param _builtins.str secret_name: secretName is the  name of secret that contains Azure Storage Account Name and Key
        :param _builtins.str share_name: shareName is the azure share Name
        """
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)
        if share_name is not None:
            pulumi.set(__self__, "share_name", share_name)

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[_builtins.str]:
        """
        secretName is the  name of secret that contains Azure Storage Account Name and Key
        """
        return pulumi.get(self, "secret_name")

    @_builtins.property
    @pulumi.getter(name="shareName")
    def share_name(self) -> Optional[_builtins.str]:
        """
        shareName is the azure share Name
        """
        return pulumi.get(self, "share_name")


@pulumi.output_type
class CSIPersistentVolumeSource(dict):
    """
    Represents storage that is managed by an external CSI volume driver
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "volumeHandle":
            suggest = "volume_handle"
        elif key == "controllerExpandSecretRef":
            suggest = "controller_expand_secret_ref"
        elif key == "controllerPublishSecretRef":
            suggest = "controller_publish_secret_ref"
        elif key == "fsType":
            suggest = "fs_type"
        elif key == "nodeExpandSecretRef":
            suggest = "node_expand_secret_ref"
        elif key == "nodePublishSecretRef":
            suggest = "node_publish_secret_ref"
        elif key == "nodeStageSecretRef":
            suggest = "node_stage_secret_ref"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "volumeAttributes":
            suggest = "volume_attributes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CSIPersistentVolumeSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CSIPersistentVolumeSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CSIPersistentVolumeSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 driver: _builtins.str,
                 volume_handle: _builtins.str,
                 controller_expand_secret_ref: Optional['outputs.SecretReference'] = None,
                 controller_publish_secret_ref: Optional['outputs.SecretReference'] = None,
                 fs_type: Optional[_builtins.str] = None,
                 node_expand_secret_ref: Optional['outputs.SecretReference'] = None,
                 node_publish_secret_ref: Optional['outputs.SecretReference'] = None,
                 node_stage_secret_ref: Optional['outputs.SecretReference'] = None,
                 read_only: Optional[_builtins.bool] = None,
                 volume_attributes: Optional[Mapping[str, _builtins.str]] = None):
        """
        Represents storage that is managed by an external CSI volume driver
        :param _builtins.str driver: driver is the name of the driver to use for this volume. Required.
        :param _builtins.str volume_handle: volumeHandle is the unique volume name returned by the CSI volume plugin’s CreateVolume to refer to the volume on all subsequent calls. Required.
        :param 'SecretReferenceArgs' controller_expand_secret_ref: controllerExpandSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI ControllerExpandVolume call. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
        :param 'SecretReferenceArgs' controller_publish_secret_ref: controllerPublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI ControllerPublishVolume and ControllerUnpublishVolume calls. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
        :param _builtins.str fs_type: fsType to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs".
        :param 'SecretReferenceArgs' node_expand_secret_ref: nodeExpandSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodeExpandVolume call. This field is optional, may be omitted if no secret is required. If the secret object contains more than one secret, all secrets are passed.
        :param 'SecretReferenceArgs' node_publish_secret_ref: nodePublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume calls. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
        :param 'SecretReferenceArgs' node_stage_secret_ref: nodeStageSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodeStageVolume and NodeStageVolume and NodeUnstageVolume calls. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
        :param _builtins.bool read_only: readOnly value to pass to ControllerPublishVolumeRequest. Defaults to false (read/write).
        :param Mapping[str, _builtins.str] volume_attributes: volumeAttributes of the volume to publish.
        """
        pulumi.set(__self__, "driver", driver)
        pulumi.set(__self__, "volume_handle", volume_handle)
        if controller_expand_secret_ref is not None:
            pulumi.set(__self__, "controller_expand_secret_ref", controller_expand_secret_ref)
        if controller_publish_secret_ref is not None:
            pulumi.set(__self__, "controller_publish_secret_ref", controller_publish_secret_ref)
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if node_expand_secret_ref is not None:
            pulumi.set(__self__, "node_expand_secret_ref", node_expand_secret_ref)
        if node_publish_secret_ref is not None:
            pulumi.set(__self__, "node_publish_secret_ref", node_publish_secret_ref)
        if node_stage_secret_ref is not None:
            pulumi.set(__self__, "node_stage_secret_ref", node_stage_secret_ref)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if volume_attributes is not None:
            pulumi.set(__self__, "volume_attributes", volume_attributes)

    @_builtins.property
    @pulumi.getter
    def driver(self) -> _builtins.str:
        """
        driver is the name of the driver to use for this volume. Required.
        """
        return pulumi.get(self, "driver")

    @_builtins.property
    @pulumi.getter(name="volumeHandle")
    def volume_handle(self) -> _builtins.str:
        """
        volumeHandle is the unique volume name returned by the CSI volume plugin’s CreateVolume to refer to the volume on all subsequent calls. Required.
        """
        return pulumi.get(self, "volume_handle")

    @_builtins.property
    @pulumi.getter(name="controllerExpandSecretRef")
    def controller_expand_secret_ref(self) -> Optional['outputs.SecretReference']:
        """
        controllerExpandSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI ControllerExpandVolume call. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
        """
        return pulumi.get(self, "controller_expand_secret_ref")

    @_builtins.property
    @pulumi.getter(name="controllerPublishSecretRef")
    def controller_publish_secret_ref(self) -> Optional['outputs.SecretReference']:
        """
        controllerPublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI ControllerPublishVolume and ControllerUnpublishVolume calls. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
        """
        return pulumi.get(self, "controller_publish_secret_ref")

    @_builtins.property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[_builtins.str]:
        """
        fsType to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs".
        """
        return pulumi.get(self, "fs_type")

    @_builtins.property
    @pulumi.getter(name="nodeExpandSecretRef")
    def node_expand_secret_ref(self) -> Optional['outputs.SecretReference']:
        """
        nodeExpandSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodeExpandVolume call. This field is optional, may be omitted if no secret is required. If the secret object contains more than one secret, all secrets are passed.
        """
        return pulumi.get(self, "node_expand_secret_ref")

    @_builtins.property
    @pulumi.getter(name="nodePublishSecretRef")
    def node_publish_secret_ref(self) -> Optional['outputs.SecretReference']:
        """
        nodePublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume calls. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
        """
        return pulumi.get(self, "node_publish_secret_ref")

    @_builtins.property
    @pulumi.getter(name="nodeStageSecretRef")
    def node_stage_secret_ref(self) -> Optional['outputs.SecretReference']:
        """
        nodeStageSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodeStageVolume and NodeStageVolume and NodeUnstageVolume calls. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
        """
        return pulumi.get(self, "node_stage_secret_ref")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        readOnly value to pass to ControllerPublishVolumeRequest. Defaults to false (read/write).
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter(name="volumeAttributes")
    def volume_attributes(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        volumeAttributes of the volume to publish.
        """
        return pulumi.get(self, "volume_attributes")


@pulumi.output_type
class CSIPersistentVolumeSourcePatch(dict):
    """
    Represents storage that is managed by an external CSI volume driver
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "controllerExpandSecretRef":
            suggest = "controller_expand_secret_ref"
        elif key == "controllerPublishSecretRef":
            suggest = "controller_publish_secret_ref"
        elif key == "fsType":
            suggest = "fs_type"
        elif key == "nodeExpandSecretRef":
            suggest = "node_expand_secret_ref"
        elif key == "nodePublishSecretRef":
            suggest = "node_publish_secret_ref"
        elif key == "nodeStageSecretRef":
            suggest = "node_stage_secret_ref"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "volumeAttributes":
            suggest = "volume_attributes"
        elif key == "volumeHandle":
            suggest = "volume_handle"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CSIPersistentVolumeSourcePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CSIPersistentVolumeSourcePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CSIPersistentVolumeSourcePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 controller_expand_secret_ref: Optional['outputs.SecretReferencePatch'] = None,
                 controller_publish_secret_ref: Optional['outputs.SecretReferencePatch'] = None,
                 driver: Optional[_builtins.str] = None,
                 fs_type: Optional[_builtins.str] = None,
                 node_expand_secret_ref: Optional['outputs.SecretReferencePatch'] = None,
                 node_publish_secret_ref: Optional['outputs.SecretReferencePatch'] = None,
                 node_stage_secret_ref: Optional['outputs.SecretReferencePatch'] = None,
                 read_only: Optional[_builtins.bool] = None,
                 volume_attributes: Optional[Mapping[str, _builtins.str]] = None,
                 volume_handle: Optional[_builtins.str] = None):
        """
        Represents storage that is managed by an external CSI volume driver
        :param 'SecretReferencePatchArgs' controller_expand_secret_ref: controllerExpandSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI ControllerExpandVolume call. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
        :param 'SecretReferencePatchArgs' controller_publish_secret_ref: controllerPublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI ControllerPublishVolume and ControllerUnpublishVolume calls. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
        :param _builtins.str driver: driver is the name of the driver to use for this volume. Required.
        :param _builtins.str fs_type: fsType to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs".
        :param 'SecretReferencePatchArgs' node_expand_secret_ref: nodeExpandSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodeExpandVolume call. This field is optional, may be omitted if no secret is required. If the secret object contains more than one secret, all secrets are passed.
        :param 'SecretReferencePatchArgs' node_publish_secret_ref: nodePublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume calls. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
        :param 'SecretReferencePatchArgs' node_stage_secret_ref: nodeStageSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodeStageVolume and NodeStageVolume and NodeUnstageVolume calls. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
        :param _builtins.bool read_only: readOnly value to pass to ControllerPublishVolumeRequest. Defaults to false (read/write).
        :param Mapping[str, _builtins.str] volume_attributes: volumeAttributes of the volume to publish.
        :param _builtins.str volume_handle: volumeHandle is the unique volume name returned by the CSI volume plugin’s CreateVolume to refer to the volume on all subsequent calls. Required.
        """
        if controller_expand_secret_ref is not None:
            pulumi.set(__self__, "controller_expand_secret_ref", controller_expand_secret_ref)
        if controller_publish_secret_ref is not None:
            pulumi.set(__self__, "controller_publish_secret_ref", controller_publish_secret_ref)
        if driver is not None:
            pulumi.set(__self__, "driver", driver)
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if node_expand_secret_ref is not None:
            pulumi.set(__self__, "node_expand_secret_ref", node_expand_secret_ref)
        if node_publish_secret_ref is not None:
            pulumi.set(__self__, "node_publish_secret_ref", node_publish_secret_ref)
        if node_stage_secret_ref is not None:
            pulumi.set(__self__, "node_stage_secret_ref", node_stage_secret_ref)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if volume_attributes is not None:
            pulumi.set(__self__, "volume_attributes", volume_attributes)
        if volume_handle is not None:
            pulumi.set(__self__, "volume_handle", volume_handle)

    @_builtins.property
    @pulumi.getter(name="controllerExpandSecretRef")
    def controller_expand_secret_ref(self) -> Optional['outputs.SecretReferencePatch']:
        """
        controllerExpandSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI ControllerExpandVolume call. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
        """
        return pulumi.get(self, "controller_expand_secret_ref")

    @_builtins.property
    @pulumi.getter(name="controllerPublishSecretRef")
    def controller_publish_secret_ref(self) -> Optional['outputs.SecretReferencePatch']:
        """
        controllerPublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI ControllerPublishVolume and ControllerUnpublishVolume calls. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
        """
        return pulumi.get(self, "controller_publish_secret_ref")

    @_builtins.property
    @pulumi.getter
    def driver(self) -> Optional[_builtins.str]:
        """
        driver is the name of the driver to use for this volume. Required.
        """
        return pulumi.get(self, "driver")

    @_builtins.property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[_builtins.str]:
        """
        fsType to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs".
        """
        return pulumi.get(self, "fs_type")

    @_builtins.property
    @pulumi.getter(name="nodeExpandSecretRef")
    def node_expand_secret_ref(self) -> Optional['outputs.SecretReferencePatch']:
        """
        nodeExpandSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodeExpandVolume call. This field is optional, may be omitted if no secret is required. If the secret object contains more than one secret, all secrets are passed.
        """
        return pulumi.get(self, "node_expand_secret_ref")

    @_builtins.property
    @pulumi.getter(name="nodePublishSecretRef")
    def node_publish_secret_ref(self) -> Optional['outputs.SecretReferencePatch']:
        """
        nodePublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume calls. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
        """
        return pulumi.get(self, "node_publish_secret_ref")

    @_builtins.property
    @pulumi.getter(name="nodeStageSecretRef")
    def node_stage_secret_ref(self) -> Optional['outputs.SecretReferencePatch']:
        """
        nodeStageSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodeStageVolume and NodeStageVolume and NodeUnstageVolume calls. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.
        """
        return pulumi.get(self, "node_stage_secret_ref")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        readOnly value to pass to ControllerPublishVolumeRequest. Defaults to false (read/write).
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter(name="volumeAttributes")
    def volume_attributes(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        volumeAttributes of the volume to publish.
        """
        return pulumi.get(self, "volume_attributes")

    @_builtins.property
    @pulumi.getter(name="volumeHandle")
    def volume_handle(self) -> Optional[_builtins.str]:
        """
        volumeHandle is the unique volume name returned by the CSI volume plugin’s CreateVolume to refer to the volume on all subsequent calls. Required.
        """
        return pulumi.get(self, "volume_handle")


@pulumi.output_type
class CSIVolumeSource(dict):
    """
    Represents a source location of a volume to mount, managed by an external CSI driver
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fsType":
            suggest = "fs_type"
        elif key == "nodePublishSecretRef":
            suggest = "node_publish_secret_ref"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "volumeAttributes":
            suggest = "volume_attributes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CSIVolumeSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CSIVolumeSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CSIVolumeSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 driver: _builtins.str,
                 fs_type: Optional[_builtins.str] = None,
                 node_publish_secret_ref: Optional['outputs.LocalObjectReference'] = None,
                 read_only: Optional[_builtins.bool] = None,
                 volume_attributes: Optional[Mapping[str, _builtins.str]] = None):
        """
        Represents a source location of a volume to mount, managed by an external CSI driver
        :param _builtins.str driver: driver is the name of the CSI driver that handles this volume. Consult with your admin for the correct name as registered in the cluster.
        :param _builtins.str fs_type: fsType to mount. Ex. "ext4", "xfs", "ntfs". If not provided, the empty value is passed to the associated CSI driver which will determine the default filesystem to apply.
        :param 'LocalObjectReferenceArgs' node_publish_secret_ref: nodePublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume calls. This field is optional, and  may be empty if no secret is required. If the secret object contains more than one secret, all secret references are passed.
        :param _builtins.bool read_only: readOnly specifies a read-only configuration for the volume. Defaults to false (read/write).
        :param Mapping[str, _builtins.str] volume_attributes: volumeAttributes stores driver-specific properties that are passed to the CSI driver. Consult your driver's documentation for supported values.
        """
        pulumi.set(__self__, "driver", driver)
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if node_publish_secret_ref is not None:
            pulumi.set(__self__, "node_publish_secret_ref", node_publish_secret_ref)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if volume_attributes is not None:
            pulumi.set(__self__, "volume_attributes", volume_attributes)

    @_builtins.property
    @pulumi.getter
    def driver(self) -> _builtins.str:
        """
        driver is the name of the CSI driver that handles this volume. Consult with your admin for the correct name as registered in the cluster.
        """
        return pulumi.get(self, "driver")

    @_builtins.property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[_builtins.str]:
        """
        fsType to mount. Ex. "ext4", "xfs", "ntfs". If not provided, the empty value is passed to the associated CSI driver which will determine the default filesystem to apply.
        """
        return pulumi.get(self, "fs_type")

    @_builtins.property
    @pulumi.getter(name="nodePublishSecretRef")
    def node_publish_secret_ref(self) -> Optional['outputs.LocalObjectReference']:
        """
        nodePublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume calls. This field is optional, and  may be empty if no secret is required. If the secret object contains more than one secret, all secret references are passed.
        """
        return pulumi.get(self, "node_publish_secret_ref")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        readOnly specifies a read-only configuration for the volume. Defaults to false (read/write).
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter(name="volumeAttributes")
    def volume_attributes(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        volumeAttributes stores driver-specific properties that are passed to the CSI driver. Consult your driver's documentation for supported values.
        """
        return pulumi.get(self, "volume_attributes")


@pulumi.output_type
class CSIVolumeSourcePatch(dict):
    """
    Represents a source location of a volume to mount, managed by an external CSI driver
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fsType":
            suggest = "fs_type"
        elif key == "nodePublishSecretRef":
            suggest = "node_publish_secret_ref"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "volumeAttributes":
            suggest = "volume_attributes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CSIVolumeSourcePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CSIVolumeSourcePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CSIVolumeSourcePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 driver: Optional[_builtins.str] = None,
                 fs_type: Optional[_builtins.str] = None,
                 node_publish_secret_ref: Optional['outputs.LocalObjectReferencePatch'] = None,
                 read_only: Optional[_builtins.bool] = None,
                 volume_attributes: Optional[Mapping[str, _builtins.str]] = None):
        """
        Represents a source location of a volume to mount, managed by an external CSI driver
        :param _builtins.str driver: driver is the name of the CSI driver that handles this volume. Consult with your admin for the correct name as registered in the cluster.
        :param _builtins.str fs_type: fsType to mount. Ex. "ext4", "xfs", "ntfs". If not provided, the empty value is passed to the associated CSI driver which will determine the default filesystem to apply.
        :param 'LocalObjectReferencePatchArgs' node_publish_secret_ref: nodePublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume calls. This field is optional, and  may be empty if no secret is required. If the secret object contains more than one secret, all secret references are passed.
        :param _builtins.bool read_only: readOnly specifies a read-only configuration for the volume. Defaults to false (read/write).
        :param Mapping[str, _builtins.str] volume_attributes: volumeAttributes stores driver-specific properties that are passed to the CSI driver. Consult your driver's documentation for supported values.
        """
        if driver is not None:
            pulumi.set(__self__, "driver", driver)
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if node_publish_secret_ref is not None:
            pulumi.set(__self__, "node_publish_secret_ref", node_publish_secret_ref)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if volume_attributes is not None:
            pulumi.set(__self__, "volume_attributes", volume_attributes)

    @_builtins.property
    @pulumi.getter
    def driver(self) -> Optional[_builtins.str]:
        """
        driver is the name of the CSI driver that handles this volume. Consult with your admin for the correct name as registered in the cluster.
        """
        return pulumi.get(self, "driver")

    @_builtins.property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[_builtins.str]:
        """
        fsType to mount. Ex. "ext4", "xfs", "ntfs". If not provided, the empty value is passed to the associated CSI driver which will determine the default filesystem to apply.
        """
        return pulumi.get(self, "fs_type")

    @_builtins.property
    @pulumi.getter(name="nodePublishSecretRef")
    def node_publish_secret_ref(self) -> Optional['outputs.LocalObjectReferencePatch']:
        """
        nodePublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume calls. This field is optional, and  may be empty if no secret is required. If the secret object contains more than one secret, all secret references are passed.
        """
        return pulumi.get(self, "node_publish_secret_ref")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        readOnly specifies a read-only configuration for the volume. Defaults to false (read/write).
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter(name="volumeAttributes")
    def volume_attributes(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        volumeAttributes stores driver-specific properties that are passed to the CSI driver. Consult your driver's documentation for supported values.
        """
        return pulumi.get(self, "volume_attributes")


@pulumi.output_type
class Capabilities(dict):
    """
    Adds and removes POSIX capabilities from running containers.
    """
    def __init__(__self__, *,
                 add: Optional[Sequence[_builtins.str]] = None,
                 drop: Optional[Sequence[_builtins.str]] = None):
        """
        Adds and removes POSIX capabilities from running containers.
        :param Sequence[_builtins.str] add: Added capabilities
        :param Sequence[_builtins.str] drop: Removed capabilities
        """
        if add is not None:
            pulumi.set(__self__, "add", add)
        if drop is not None:
            pulumi.set(__self__, "drop", drop)

    @_builtins.property
    @pulumi.getter
    def add(self) -> Optional[Sequence[_builtins.str]]:
        """
        Added capabilities
        """
        return pulumi.get(self, "add")

    @_builtins.property
    @pulumi.getter
    def drop(self) -> Optional[Sequence[_builtins.str]]:
        """
        Removed capabilities
        """
        return pulumi.get(self, "drop")


@pulumi.output_type
class CapabilitiesPatch(dict):
    """
    Adds and removes POSIX capabilities from running containers.
    """
    def __init__(__self__, *,
                 add: Optional[Sequence[_builtins.str]] = None,
                 drop: Optional[Sequence[_builtins.str]] = None):
        """
        Adds and removes POSIX capabilities from running containers.
        :param Sequence[_builtins.str] add: Added capabilities
        :param Sequence[_builtins.str] drop: Removed capabilities
        """
        if add is not None:
            pulumi.set(__self__, "add", add)
        if drop is not None:
            pulumi.set(__self__, "drop", drop)

    @_builtins.property
    @pulumi.getter
    def add(self) -> Optional[Sequence[_builtins.str]]:
        """
        Added capabilities
        """
        return pulumi.get(self, "add")

    @_builtins.property
    @pulumi.getter
    def drop(self) -> Optional[Sequence[_builtins.str]]:
        """
        Removed capabilities
        """
        return pulumi.get(self, "drop")


@pulumi.output_type
class CephFSPersistentVolumeSource(dict):
    """
    Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs volumes do not support ownership management or SELinux relabeling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "readOnly":
            suggest = "read_only"
        elif key == "secretFile":
            suggest = "secret_file"
        elif key == "secretRef":
            suggest = "secret_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CephFSPersistentVolumeSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CephFSPersistentVolumeSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CephFSPersistentVolumeSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 monitors: Sequence[_builtins.str],
                 path: Optional[_builtins.str] = None,
                 read_only: Optional[_builtins.bool] = None,
                 secret_file: Optional[_builtins.str] = None,
                 secret_ref: Optional['outputs.SecretReference'] = None,
                 user: Optional[_builtins.str] = None):
        """
        Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs volumes do not support ownership management or SELinux relabeling.
        :param Sequence[_builtins.str] monitors: monitors is Required: Monitors is a collection of Ceph monitors More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        :param _builtins.str path: path is Optional: Used as the mounted root, rather than the full Ceph tree, default is /
        :param _builtins.bool read_only: readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        :param _builtins.str secret_file: secretFile is Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        :param 'SecretReferenceArgs' secret_ref: secretRef is Optional: SecretRef is reference to the authentication secret for User, default is empty. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        :param _builtins.str user: user is Optional: User is the rados user name, default is admin More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        """
        pulumi.set(__self__, "monitors", monitors)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if secret_file is not None:
            pulumi.set(__self__, "secret_file", secret_file)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter
    def monitors(self) -> Sequence[_builtins.str]:
        """
        monitors is Required: Monitors is a collection of Ceph monitors More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        """
        return pulumi.get(self, "monitors")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        path is Optional: Used as the mounted root, rather than the full Ceph tree, default is /
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter(name="secretFile")
    def secret_file(self) -> Optional[_builtins.str]:
        """
        secretFile is Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        """
        return pulumi.get(self, "secret_file")

    @_builtins.property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional['outputs.SecretReference']:
        """
        secretRef is Optional: SecretRef is reference to the authentication secret for User, default is empty. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        """
        return pulumi.get(self, "secret_ref")

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[_builtins.str]:
        """
        user is Optional: User is the rados user name, default is admin More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class CephFSPersistentVolumeSourcePatch(dict):
    """
    Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs volumes do not support ownership management or SELinux relabeling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "readOnly":
            suggest = "read_only"
        elif key == "secretFile":
            suggest = "secret_file"
        elif key == "secretRef":
            suggest = "secret_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CephFSPersistentVolumeSourcePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CephFSPersistentVolumeSourcePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CephFSPersistentVolumeSourcePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 monitors: Optional[Sequence[_builtins.str]] = None,
                 path: Optional[_builtins.str] = None,
                 read_only: Optional[_builtins.bool] = None,
                 secret_file: Optional[_builtins.str] = None,
                 secret_ref: Optional['outputs.SecretReferencePatch'] = None,
                 user: Optional[_builtins.str] = None):
        """
        Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs volumes do not support ownership management or SELinux relabeling.
        :param Sequence[_builtins.str] monitors: monitors is Required: Monitors is a collection of Ceph monitors More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        :param _builtins.str path: path is Optional: Used as the mounted root, rather than the full Ceph tree, default is /
        :param _builtins.bool read_only: readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        :param _builtins.str secret_file: secretFile is Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        :param 'SecretReferencePatchArgs' secret_ref: secretRef is Optional: SecretRef is reference to the authentication secret for User, default is empty. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        :param _builtins.str user: user is Optional: User is the rados user name, default is admin More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        """
        if monitors is not None:
            pulumi.set(__self__, "monitors", monitors)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if secret_file is not None:
            pulumi.set(__self__, "secret_file", secret_file)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter
    def monitors(self) -> Optional[Sequence[_builtins.str]]:
        """
        monitors is Required: Monitors is a collection of Ceph monitors More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        """
        return pulumi.get(self, "monitors")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        path is Optional: Used as the mounted root, rather than the full Ceph tree, default is /
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter(name="secretFile")
    def secret_file(self) -> Optional[_builtins.str]:
        """
        secretFile is Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        """
        return pulumi.get(self, "secret_file")

    @_builtins.property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional['outputs.SecretReferencePatch']:
        """
        secretRef is Optional: SecretRef is reference to the authentication secret for User, default is empty. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        """
        return pulumi.get(self, "secret_ref")

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[_builtins.str]:
        """
        user is Optional: User is the rados user name, default is admin More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class CephFSVolumeSource(dict):
    """
    Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs volumes do not support ownership management or SELinux relabeling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "readOnly":
            suggest = "read_only"
        elif key == "secretFile":
            suggest = "secret_file"
        elif key == "secretRef":
            suggest = "secret_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CephFSVolumeSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CephFSVolumeSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CephFSVolumeSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 monitors: Sequence[_builtins.str],
                 path: Optional[_builtins.str] = None,
                 read_only: Optional[_builtins.bool] = None,
                 secret_file: Optional[_builtins.str] = None,
                 secret_ref: Optional['outputs.LocalObjectReference'] = None,
                 user: Optional[_builtins.str] = None):
        """
        Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs volumes do not support ownership management or SELinux relabeling.
        :param Sequence[_builtins.str] monitors: monitors is Required: Monitors is a collection of Ceph monitors More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        :param _builtins.str path: path is Optional: Used as the mounted root, rather than the full Ceph tree, default is /
        :param _builtins.bool read_only: readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        :param _builtins.str secret_file: secretFile is Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        :param 'LocalObjectReferenceArgs' secret_ref: secretRef is Optional: SecretRef is reference to the authentication secret for User, default is empty. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        :param _builtins.str user: user is optional: User is the rados user name, default is admin More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        """
        pulumi.set(__self__, "monitors", monitors)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if secret_file is not None:
            pulumi.set(__self__, "secret_file", secret_file)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter
    def monitors(self) -> Sequence[_builtins.str]:
        """
        monitors is Required: Monitors is a collection of Ceph monitors More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        """
        return pulumi.get(self, "monitors")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        path is Optional: Used as the mounted root, rather than the full Ceph tree, default is /
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter(name="secretFile")
    def secret_file(self) -> Optional[_builtins.str]:
        """
        secretFile is Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        """
        return pulumi.get(self, "secret_file")

    @_builtins.property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional['outputs.LocalObjectReference']:
        """
        secretRef is Optional: SecretRef is reference to the authentication secret for User, default is empty. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        """
        return pulumi.get(self, "secret_ref")

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[_builtins.str]:
        """
        user is optional: User is the rados user name, default is admin More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class CephFSVolumeSourcePatch(dict):
    """
    Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs volumes do not support ownership management or SELinux relabeling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "readOnly":
            suggest = "read_only"
        elif key == "secretFile":
            suggest = "secret_file"
        elif key == "secretRef":
            suggest = "secret_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CephFSVolumeSourcePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CephFSVolumeSourcePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CephFSVolumeSourcePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 monitors: Optional[Sequence[_builtins.str]] = None,
                 path: Optional[_builtins.str] = None,
                 read_only: Optional[_builtins.bool] = None,
                 secret_file: Optional[_builtins.str] = None,
                 secret_ref: Optional['outputs.LocalObjectReferencePatch'] = None,
                 user: Optional[_builtins.str] = None):
        """
        Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs volumes do not support ownership management or SELinux relabeling.
        :param Sequence[_builtins.str] monitors: monitors is Required: Monitors is a collection of Ceph monitors More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        :param _builtins.str path: path is Optional: Used as the mounted root, rather than the full Ceph tree, default is /
        :param _builtins.bool read_only: readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        :param _builtins.str secret_file: secretFile is Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        :param 'LocalObjectReferencePatchArgs' secret_ref: secretRef is Optional: SecretRef is reference to the authentication secret for User, default is empty. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        :param _builtins.str user: user is optional: User is the rados user name, default is admin More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        """
        if monitors is not None:
            pulumi.set(__self__, "monitors", monitors)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if secret_file is not None:
            pulumi.set(__self__, "secret_file", secret_file)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter
    def monitors(self) -> Optional[Sequence[_builtins.str]]:
        """
        monitors is Required: Monitors is a collection of Ceph monitors More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        """
        return pulumi.get(self, "monitors")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        path is Optional: Used as the mounted root, rather than the full Ceph tree, default is /
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter(name="secretFile")
    def secret_file(self) -> Optional[_builtins.str]:
        """
        secretFile is Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        """
        return pulumi.get(self, "secret_file")

    @_builtins.property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional['outputs.LocalObjectReferencePatch']:
        """
        secretRef is Optional: SecretRef is reference to the authentication secret for User, default is empty. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        """
        return pulumi.get(self, "secret_ref")

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[_builtins.str]:
        """
        user is optional: User is the rados user name, default is admin More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class CinderPersistentVolumeSource(dict):
    """
    Represents a cinder volume resource in Openstack. A Cinder volume must exist before mounting to a container. The volume must also be in the same region as the kubelet. Cinder volumes support ownership management and SELinux relabeling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "volumeID":
            suggest = "volume_id"
        elif key == "fsType":
            suggest = "fs_type"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "secretRef":
            suggest = "secret_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CinderPersistentVolumeSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CinderPersistentVolumeSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CinderPersistentVolumeSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 volume_id: _builtins.str,
                 fs_type: Optional[_builtins.str] = None,
                 read_only: Optional[_builtins.bool] = None,
                 secret_ref: Optional['outputs.SecretReference'] = None):
        """
        Represents a cinder volume resource in Openstack. A Cinder volume must exist before mounting to a container. The volume must also be in the same region as the kubelet. Cinder volumes support ownership management and SELinux relabeling.
        :param _builtins.str volume_id: volumeID used to identify the volume in cinder. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        :param _builtins.str fs_type: fsType Filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        :param _builtins.bool read_only: readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        :param 'SecretReferenceArgs' secret_ref: secretRef is Optional: points to a secret object containing parameters used to connect to OpenStack.
        """
        pulumi.set(__self__, "volume_id", volume_id)
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)

    @_builtins.property
    @pulumi.getter(name="volumeID")
    def volume_id(self) -> _builtins.str:
        """
        volumeID used to identify the volume in cinder. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        """
        return pulumi.get(self, "volume_id")

    @_builtins.property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[_builtins.str]:
        """
        fsType Filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        """
        return pulumi.get(self, "fs_type")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional['outputs.SecretReference']:
        """
        secretRef is Optional: points to a secret object containing parameters used to connect to OpenStack.
        """
        return pulumi.get(self, "secret_ref")


@pulumi.output_type
class CinderPersistentVolumeSourcePatch(dict):
    """
    Represents a cinder volume resource in Openstack. A Cinder volume must exist before mounting to a container. The volume must also be in the same region as the kubelet. Cinder volumes support ownership management and SELinux relabeling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fsType":
            suggest = "fs_type"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "secretRef":
            suggest = "secret_ref"
        elif key == "volumeID":
            suggest = "volume_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CinderPersistentVolumeSourcePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CinderPersistentVolumeSourcePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CinderPersistentVolumeSourcePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fs_type: Optional[_builtins.str] = None,
                 read_only: Optional[_builtins.bool] = None,
                 secret_ref: Optional['outputs.SecretReferencePatch'] = None,
                 volume_id: Optional[_builtins.str] = None):
        """
        Represents a cinder volume resource in Openstack. A Cinder volume must exist before mounting to a container. The volume must also be in the same region as the kubelet. Cinder volumes support ownership management and SELinux relabeling.
        :param _builtins.str fs_type: fsType Filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        :param _builtins.bool read_only: readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        :param 'SecretReferencePatchArgs' secret_ref: secretRef is Optional: points to a secret object containing parameters used to connect to OpenStack.
        :param _builtins.str volume_id: volumeID used to identify the volume in cinder. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        """
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)

    @_builtins.property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[_builtins.str]:
        """
        fsType Filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        """
        return pulumi.get(self, "fs_type")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional['outputs.SecretReferencePatch']:
        """
        secretRef is Optional: points to a secret object containing parameters used to connect to OpenStack.
        """
        return pulumi.get(self, "secret_ref")

    @_builtins.property
    @pulumi.getter(name="volumeID")
    def volume_id(self) -> Optional[_builtins.str]:
        """
        volumeID used to identify the volume in cinder. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        """
        return pulumi.get(self, "volume_id")


@pulumi.output_type
class CinderVolumeSource(dict):
    """
    Represents a cinder volume resource in Openstack. A Cinder volume must exist before mounting to a container. The volume must also be in the same region as the kubelet. Cinder volumes support ownership management and SELinux relabeling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "volumeID":
            suggest = "volume_id"
        elif key == "fsType":
            suggest = "fs_type"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "secretRef":
            suggest = "secret_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CinderVolumeSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CinderVolumeSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CinderVolumeSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 volume_id: _builtins.str,
                 fs_type: Optional[_builtins.str] = None,
                 read_only: Optional[_builtins.bool] = None,
                 secret_ref: Optional['outputs.LocalObjectReference'] = None):
        """
        Represents a cinder volume resource in Openstack. A Cinder volume must exist before mounting to a container. The volume must also be in the same region as the kubelet. Cinder volumes support ownership management and SELinux relabeling.
        :param _builtins.str volume_id: volumeID used to identify the volume in cinder. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        :param _builtins.str fs_type: fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        :param _builtins.bool read_only: readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        :param 'LocalObjectReferenceArgs' secret_ref: secretRef is optional: points to a secret object containing parameters used to connect to OpenStack.
        """
        pulumi.set(__self__, "volume_id", volume_id)
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)

    @_builtins.property
    @pulumi.getter(name="volumeID")
    def volume_id(self) -> _builtins.str:
        """
        volumeID used to identify the volume in cinder. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        """
        return pulumi.get(self, "volume_id")

    @_builtins.property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[_builtins.str]:
        """
        fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        """
        return pulumi.get(self, "fs_type")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional['outputs.LocalObjectReference']:
        """
        secretRef is optional: points to a secret object containing parameters used to connect to OpenStack.
        """
        return pulumi.get(self, "secret_ref")


@pulumi.output_type
class CinderVolumeSourcePatch(dict):
    """
    Represents a cinder volume resource in Openstack. A Cinder volume must exist before mounting to a container. The volume must also be in the same region as the kubelet. Cinder volumes support ownership management and SELinux relabeling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fsType":
            suggest = "fs_type"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "secretRef":
            suggest = "secret_ref"
        elif key == "volumeID":
            suggest = "volume_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CinderVolumeSourcePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CinderVolumeSourcePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CinderVolumeSourcePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fs_type: Optional[_builtins.str] = None,
                 read_only: Optional[_builtins.bool] = None,
                 secret_ref: Optional['outputs.LocalObjectReferencePatch'] = None,
                 volume_id: Optional[_builtins.str] = None):
        """
        Represents a cinder volume resource in Openstack. A Cinder volume must exist before mounting to a container. The volume must also be in the same region as the kubelet. Cinder volumes support ownership management and SELinux relabeling.
        :param _builtins.str fs_type: fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        :param _builtins.bool read_only: readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        :param 'LocalObjectReferencePatchArgs' secret_ref: secretRef is optional: points to a secret object containing parameters used to connect to OpenStack.
        :param _builtins.str volume_id: volumeID used to identify the volume in cinder. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        """
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)

    @_builtins.property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[_builtins.str]:
        """
        fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        """
        return pulumi.get(self, "fs_type")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional['outputs.LocalObjectReferencePatch']:
        """
        secretRef is optional: points to a secret object containing parameters used to connect to OpenStack.
        """
        return pulumi.get(self, "secret_ref")

    @_builtins.property
    @pulumi.getter(name="volumeID")
    def volume_id(self) -> Optional[_builtins.str]:
        """
        volumeID used to identify the volume in cinder. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        """
        return pulumi.get(self, "volume_id")


@pulumi.output_type
class ClaimSource(dict):
    """
    ClaimSource describes a reference to a ResourceClaim.

    Exactly one of these fields should be set.  Consumers of this type must treat an empty object as if it has an unknown value.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceClaimName":
            suggest = "resource_claim_name"
        elif key == "resourceClaimTemplateName":
            suggest = "resource_claim_template_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClaimSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClaimSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClaimSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_claim_name: Optional[_builtins.str] = None,
                 resource_claim_template_name: Optional[_builtins.str] = None):
        """
        ClaimSource describes a reference to a ResourceClaim.

        Exactly one of these fields should be set.  Consumers of this type must treat an empty object as if it has an unknown value.
        :param _builtins.str resource_claim_name: ResourceClaimName is the name of a ResourceClaim object in the same namespace as this pod.
        :param _builtins.str resource_claim_template_name: ResourceClaimTemplateName is the name of a ResourceClaimTemplate object in the same namespace as this pod.
               
               The template will be used to create a new ResourceClaim, which will be bound to this pod. When this pod is deleted, the ResourceClaim will also be deleted. The name of the ResourceClaim will be <pod name>-<resource name>, where <resource name> is the PodResourceClaim.Name. Pod validation will reject the pod if the concatenated name is not valid for a ResourceClaim (e.g. too long).
               
               An existing ResourceClaim with that name that is not owned by the pod will not be used for the pod to avoid using an unrelated resource by mistake. Scheduling and pod startup are then blocked until the unrelated ResourceClaim is removed.
               
               This field is immutable and no changes will be made to the corresponding ResourceClaim by the control plane after creating the ResourceClaim.
        """
        if resource_claim_name is not None:
            pulumi.set(__self__, "resource_claim_name", resource_claim_name)
        if resource_claim_template_name is not None:
            pulumi.set(__self__, "resource_claim_template_name", resource_claim_template_name)

    @_builtins.property
    @pulumi.getter(name="resourceClaimName")
    def resource_claim_name(self) -> Optional[_builtins.str]:
        """
        ResourceClaimName is the name of a ResourceClaim object in the same namespace as this pod.
        """
        return pulumi.get(self, "resource_claim_name")

    @_builtins.property
    @pulumi.getter(name="resourceClaimTemplateName")
    def resource_claim_template_name(self) -> Optional[_builtins.str]:
        """
        ResourceClaimTemplateName is the name of a ResourceClaimTemplate object in the same namespace as this pod.

        The template will be used to create a new ResourceClaim, which will be bound to this pod. When this pod is deleted, the ResourceClaim will also be deleted. The name of the ResourceClaim will be <pod name>-<resource name>, where <resource name> is the PodResourceClaim.Name. Pod validation will reject the pod if the concatenated name is not valid for a ResourceClaim (e.g. too long).

        An existing ResourceClaim with that name that is not owned by the pod will not be used for the pod to avoid using an unrelated resource by mistake. Scheduling and pod startup are then blocked until the unrelated ResourceClaim is removed.

        This field is immutable and no changes will be made to the corresponding ResourceClaim by the control plane after creating the ResourceClaim.
        """
        return pulumi.get(self, "resource_claim_template_name")


@pulumi.output_type
class ClaimSourcePatch(dict):
    """
    ClaimSource describes a reference to a ResourceClaim.

    Exactly one of these fields should be set.  Consumers of this type must treat an empty object as if it has an unknown value.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceClaimName":
            suggest = "resource_claim_name"
        elif key == "resourceClaimTemplateName":
            suggest = "resource_claim_template_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClaimSourcePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClaimSourcePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClaimSourcePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_claim_name: Optional[_builtins.str] = None,
                 resource_claim_template_name: Optional[_builtins.str] = None):
        """
        ClaimSource describes a reference to a ResourceClaim.

        Exactly one of these fields should be set.  Consumers of this type must treat an empty object as if it has an unknown value.
        :param _builtins.str resource_claim_name: ResourceClaimName is the name of a ResourceClaim object in the same namespace as this pod.
        :param _builtins.str resource_claim_template_name: ResourceClaimTemplateName is the name of a ResourceClaimTemplate object in the same namespace as this pod.
               
               The template will be used to create a new ResourceClaim, which will be bound to this pod. When this pod is deleted, the ResourceClaim will also be deleted. The name of the ResourceClaim will be <pod name>-<resource name>, where <resource name> is the PodResourceClaim.Name. Pod validation will reject the pod if the concatenated name is not valid for a ResourceClaim (e.g. too long).
               
               An existing ResourceClaim with that name that is not owned by the pod will not be used for the pod to avoid using an unrelated resource by mistake. Scheduling and pod startup are then blocked until the unrelated ResourceClaim is removed.
               
               This field is immutable and no changes will be made to the corresponding ResourceClaim by the control plane after creating the ResourceClaim.
        """
        if resource_claim_name is not None:
            pulumi.set(__self__, "resource_claim_name", resource_claim_name)
        if resource_claim_template_name is not None:
            pulumi.set(__self__, "resource_claim_template_name", resource_claim_template_name)

    @_builtins.property
    @pulumi.getter(name="resourceClaimName")
    def resource_claim_name(self) -> Optional[_builtins.str]:
        """
        ResourceClaimName is the name of a ResourceClaim object in the same namespace as this pod.
        """
        return pulumi.get(self, "resource_claim_name")

    @_builtins.property
    @pulumi.getter(name="resourceClaimTemplateName")
    def resource_claim_template_name(self) -> Optional[_builtins.str]:
        """
        ResourceClaimTemplateName is the name of a ResourceClaimTemplate object in the same namespace as this pod.

        The template will be used to create a new ResourceClaim, which will be bound to this pod. When this pod is deleted, the ResourceClaim will also be deleted. The name of the ResourceClaim will be <pod name>-<resource name>, where <resource name> is the PodResourceClaim.Name. Pod validation will reject the pod if the concatenated name is not valid for a ResourceClaim (e.g. too long).

        An existing ResourceClaim with that name that is not owned by the pod will not be used for the pod to avoid using an unrelated resource by mistake. Scheduling and pod startup are then blocked until the unrelated ResourceClaim is removed.

        This field is immutable and no changes will be made to the corresponding ResourceClaim by the control plane after creating the ResourceClaim.
        """
        return pulumi.get(self, "resource_claim_template_name")


@pulumi.output_type
class ClientIPConfig(dict):
    """
    ClientIPConfig represents the configurations of Client IP based session affinity.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientIPConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientIPConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientIPConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 timeout_seconds: Optional[_builtins.int] = None):
        """
        ClientIPConfig represents the configurations of Client IP based session affinity.
        :param _builtins.int timeout_seconds: timeoutSeconds specifies the seconds of ClientIP type session sticky time. The value must be >0 && <=86400(for 1 day) if ServiceAffinity == "ClientIP". Default value is 10800(for 3 hours).
        """
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @_builtins.property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[_builtins.int]:
        """
        timeoutSeconds specifies the seconds of ClientIP type session sticky time. The value must be >0 && <=86400(for 1 day) if ServiceAffinity == "ClientIP". Default value is 10800(for 3 hours).
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class ClientIPConfigPatch(dict):
    """
    ClientIPConfig represents the configurations of Client IP based session affinity.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientIPConfigPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientIPConfigPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientIPConfigPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 timeout_seconds: Optional[_builtins.int] = None):
        """
        ClientIPConfig represents the configurations of Client IP based session affinity.
        :param _builtins.int timeout_seconds: timeoutSeconds specifies the seconds of ClientIP type session sticky time. The value must be >0 && <=86400(for 1 day) if ServiceAffinity == "ClientIP". Default value is 10800(for 3 hours).
        """
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @_builtins.property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[_builtins.int]:
        """
        timeoutSeconds specifies the seconds of ClientIP type session sticky time. The value must be >0 && <=86400(for 1 day) if ServiceAffinity == "ClientIP". Default value is 10800(for 3 hours).
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class ClusterTrustBundleProjection(dict):
    """
    ClusterTrustBundleProjection describes how to select a set of ClusterTrustBundle objects and project their contents into the pod filesystem.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "labelSelector":
            suggest = "label_selector"
        elif key == "signerName":
            suggest = "signer_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterTrustBundleProjection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterTrustBundleProjection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterTrustBundleProjection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path: _builtins.str,
                 label_selector: Optional['_meta.v1.outputs.LabelSelector'] = None,
                 name: Optional[_builtins.str] = None,
                 optional: Optional[_builtins.bool] = None,
                 signer_name: Optional[_builtins.str] = None):
        """
        ClusterTrustBundleProjection describes how to select a set of ClusterTrustBundle objects and project their contents into the pod filesystem.
        :param _builtins.str path: Relative path from the volume root to write the bundle.
        :param '_meta.v1.LabelSelectorArgs' label_selector: Select all ClusterTrustBundles that match this label selector.  Only has effect if signerName is set.  Mutually-exclusive with name.  If unset, interpreted as "match nothing".  If set but empty, interpreted as "match everything".
        :param _builtins.str name: Select a single ClusterTrustBundle by object name.  Mutually-exclusive with signerName and labelSelector.
        :param _builtins.bool optional: If true, don't block pod startup if the referenced ClusterTrustBundle(s) aren't available.  If using name, then the named ClusterTrustBundle is allowed not to exist.  If using signerName, then the combination of signerName and labelSelector is allowed to match zero ClusterTrustBundles.
        :param _builtins.str signer_name: Select all ClusterTrustBundles that match this signer name. Mutually-exclusive with name.  The contents of all selected ClusterTrustBundles will be unified and deduplicated.
        """
        pulumi.set(__self__, "path", path)
        if label_selector is not None:
            pulumi.set(__self__, "label_selector", label_selector)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if optional is not None:
            pulumi.set(__self__, "optional", optional)
        if signer_name is not None:
            pulumi.set(__self__, "signer_name", signer_name)

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        Relative path from the volume root to write the bundle.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="labelSelector")
    def label_selector(self) -> Optional['_meta.v1.outputs.LabelSelector']:
        """
        Select all ClusterTrustBundles that match this label selector.  Only has effect if signerName is set.  Mutually-exclusive with name.  If unset, interpreted as "match nothing".  If set but empty, interpreted as "match everything".
        """
        return pulumi.get(self, "label_selector")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Select a single ClusterTrustBundle by object name.  Mutually-exclusive with signerName and labelSelector.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def optional(self) -> Optional[_builtins.bool]:
        """
        If true, don't block pod startup if the referenced ClusterTrustBundle(s) aren't available.  If using name, then the named ClusterTrustBundle is allowed not to exist.  If using signerName, then the combination of signerName and labelSelector is allowed to match zero ClusterTrustBundles.
        """
        return pulumi.get(self, "optional")

    @_builtins.property
    @pulumi.getter(name="signerName")
    def signer_name(self) -> Optional[_builtins.str]:
        """
        Select all ClusterTrustBundles that match this signer name. Mutually-exclusive with name.  The contents of all selected ClusterTrustBundles will be unified and deduplicated.
        """
        return pulumi.get(self, "signer_name")


@pulumi.output_type
class ClusterTrustBundleProjectionPatch(dict):
    """
    ClusterTrustBundleProjection describes how to select a set of ClusterTrustBundle objects and project their contents into the pod filesystem.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "labelSelector":
            suggest = "label_selector"
        elif key == "signerName":
            suggest = "signer_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterTrustBundleProjectionPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterTrustBundleProjectionPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterTrustBundleProjectionPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 label_selector: Optional['_meta.v1.outputs.LabelSelectorPatch'] = None,
                 name: Optional[_builtins.str] = None,
                 optional: Optional[_builtins.bool] = None,
                 path: Optional[_builtins.str] = None,
                 signer_name: Optional[_builtins.str] = None):
        """
        ClusterTrustBundleProjection describes how to select a set of ClusterTrustBundle objects and project their contents into the pod filesystem.
        :param '_meta.v1.LabelSelectorPatchArgs' label_selector: Select all ClusterTrustBundles that match this label selector.  Only has effect if signerName is set.  Mutually-exclusive with name.  If unset, interpreted as "match nothing".  If set but empty, interpreted as "match everything".
        :param _builtins.str name: Select a single ClusterTrustBundle by object name.  Mutually-exclusive with signerName and labelSelector.
        :param _builtins.bool optional: If true, don't block pod startup if the referenced ClusterTrustBundle(s) aren't available.  If using name, then the named ClusterTrustBundle is allowed not to exist.  If using signerName, then the combination of signerName and labelSelector is allowed to match zero ClusterTrustBundles.
        :param _builtins.str path: Relative path from the volume root to write the bundle.
        :param _builtins.str signer_name: Select all ClusterTrustBundles that match this signer name. Mutually-exclusive with name.  The contents of all selected ClusterTrustBundles will be unified and deduplicated.
        """
        if label_selector is not None:
            pulumi.set(__self__, "label_selector", label_selector)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if optional is not None:
            pulumi.set(__self__, "optional", optional)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if signer_name is not None:
            pulumi.set(__self__, "signer_name", signer_name)

    @_builtins.property
    @pulumi.getter(name="labelSelector")
    def label_selector(self) -> Optional['_meta.v1.outputs.LabelSelectorPatch']:
        """
        Select all ClusterTrustBundles that match this label selector.  Only has effect if signerName is set.  Mutually-exclusive with name.  If unset, interpreted as "match nothing".  If set but empty, interpreted as "match everything".
        """
        return pulumi.get(self, "label_selector")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Select a single ClusterTrustBundle by object name.  Mutually-exclusive with signerName and labelSelector.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def optional(self) -> Optional[_builtins.bool]:
        """
        If true, don't block pod startup if the referenced ClusterTrustBundle(s) aren't available.  If using name, then the named ClusterTrustBundle is allowed not to exist.  If using signerName, then the combination of signerName and labelSelector is allowed to match zero ClusterTrustBundles.
        """
        return pulumi.get(self, "optional")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        Relative path from the volume root to write the bundle.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="signerName")
    def signer_name(self) -> Optional[_builtins.str]:
        """
        Select all ClusterTrustBundles that match this signer name. Mutually-exclusive with name.  The contents of all selected ClusterTrustBundles will be unified and deduplicated.
        """
        return pulumi.get(self, "signer_name")


@pulumi.output_type
class ConfigMap(dict):
    """
    ConfigMap holds configuration data for pods to consume.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"
        elif key == "binaryData":
            suggest = "binary_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigMap. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigMap.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigMap.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[_builtins.str] = None,
                 binary_data: Optional[Mapping[str, _builtins.str]] = None,
                 data: Optional[Mapping[str, _builtins.str]] = None,
                 immutable: Optional[_builtins.bool] = None,
                 kind: Optional[_builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None):
        """
        ConfigMap holds configuration data for pods to consume.
        :param _builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param Mapping[str, _builtins.str] binary_data: BinaryData contains the binary data. Each key must consist of alphanumeric characters, '-', '_' or '.'. BinaryData can contain byte sequences that are not in the UTF-8 range. The keys stored in BinaryData must not overlap with the ones in the Data field, this is enforced during validation process. Using this field will require 1.10+ apiserver and kubelet.
        :param Mapping[str, _builtins.str] data: Data contains the configuration data. Each key must consist of alphanumeric characters, '-', '_' or '.'. Values with non-UTF-8 byte sequences must use the BinaryData field. The keys stored in Data must not overlap with the keys in the BinaryData field, this is enforced during validation process.
        :param _builtins.bool immutable: Immutable, if set to true, ensures that data stored in the ConfigMap cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Defaulted to nil.
        :param _builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'v1')
        if binary_data is not None:
            pulumi.set(__self__, "binary_data", binary_data)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if immutable is not None:
            pulumi.set(__self__, "immutable", immutable)
        if kind is not None:
            pulumi.set(__self__, "kind", 'ConfigMap')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[_builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter(name="binaryData")
    def binary_data(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        BinaryData contains the binary data. Each key must consist of alphanumeric characters, '-', '_' or '.'. BinaryData can contain byte sequences that are not in the UTF-8 range. The keys stored in BinaryData must not overlap with the ones in the Data field, this is enforced during validation process. Using this field will require 1.10+ apiserver and kubelet.
        """
        return pulumi.get(self, "binary_data")

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Data contains the configuration data. Each key must consist of alphanumeric characters, '-', '_' or '.'. Values with non-UTF-8 byte sequences must use the BinaryData field. The keys stored in Data must not overlap with the keys in the BinaryData field, this is enforced during validation process.
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter
    def immutable(self) -> Optional[_builtins.bool]:
        """
        Immutable, if set to true, ensures that data stored in the ConfigMap cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Defaulted to nil.
        """
        return pulumi.get(self, "immutable")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[_builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")


@pulumi.output_type
class ConfigMapEnvSource(dict):
    """
    ConfigMapEnvSource selects a ConfigMap to populate the environment variables with.

    The contents of the target ConfigMap's Data field will represent the key-value pairs as environment variables.
    """
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 optional: Optional[_builtins.bool] = None):
        """
        ConfigMapEnvSource selects a ConfigMap to populate the environment variables with.

        The contents of the target ConfigMap's Data field will represent the key-value pairs as environment variables.
        :param _builtins.str name: Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        :param _builtins.bool optional: Specify whether the ConfigMap must be defined
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if optional is not None:
            pulumi.set(__self__, "optional", optional)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def optional(self) -> Optional[_builtins.bool]:
        """
        Specify whether the ConfigMap must be defined
        """
        return pulumi.get(self, "optional")


@pulumi.output_type
class ConfigMapEnvSourcePatch(dict):
    """
    ConfigMapEnvSource selects a ConfigMap to populate the environment variables with.

    The contents of the target ConfigMap's Data field will represent the key-value pairs as environment variables.
    """
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 optional: Optional[_builtins.bool] = None):
        """
        ConfigMapEnvSource selects a ConfigMap to populate the environment variables with.

        The contents of the target ConfigMap's Data field will represent the key-value pairs as environment variables.
        :param _builtins.str name: Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        :param _builtins.bool optional: Specify whether the ConfigMap must be defined
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if optional is not None:
            pulumi.set(__self__, "optional", optional)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def optional(self) -> Optional[_builtins.bool]:
        """
        Specify whether the ConfigMap must be defined
        """
        return pulumi.get(self, "optional")


@pulumi.output_type
class ConfigMapKeySelector(dict):
    """
    Selects a key from a ConfigMap.
    """
    def __init__(__self__, *,
                 key: _builtins.str,
                 name: Optional[_builtins.str] = None,
                 optional: Optional[_builtins.bool] = None):
        """
        Selects a key from a ConfigMap.
        :param _builtins.str key: The key to select.
        :param _builtins.str name: Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        :param _builtins.bool optional: Specify whether the ConfigMap or its key must be defined
        """
        pulumi.set(__self__, "key", key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if optional is not None:
            pulumi.set(__self__, "optional", optional)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The key to select.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def optional(self) -> Optional[_builtins.bool]:
        """
        Specify whether the ConfigMap or its key must be defined
        """
        return pulumi.get(self, "optional")


@pulumi.output_type
class ConfigMapKeySelectorPatch(dict):
    """
    Selects a key from a ConfigMap.
    """
    def __init__(__self__, *,
                 key: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 optional: Optional[_builtins.bool] = None):
        """
        Selects a key from a ConfigMap.
        :param _builtins.str key: The key to select.
        :param _builtins.str name: Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        :param _builtins.bool optional: Specify whether the ConfigMap or its key must be defined
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if optional is not None:
            pulumi.set(__self__, "optional", optional)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        The key to select.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def optional(self) -> Optional[_builtins.bool]:
        """
        Specify whether the ConfigMap or its key must be defined
        """
        return pulumi.get(self, "optional")


@pulumi.output_type
class ConfigMapNodeConfigSource(dict):
    """
    ConfigMapNodeConfigSource contains the information to reference a ConfigMap as a config source for the Node. This API is deprecated since 1.22: https://git.k8s.io/enhancements/keps/sig-node/281-dynamic-kubelet-configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kubeletConfigKey":
            suggest = "kubelet_config_key"
        elif key == "resourceVersion":
            suggest = "resource_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigMapNodeConfigSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigMapNodeConfigSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigMapNodeConfigSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kubelet_config_key: _builtins.str,
                 name: _builtins.str,
                 namespace: _builtins.str,
                 resource_version: Optional[_builtins.str] = None,
                 uid: Optional[_builtins.str] = None):
        """
        ConfigMapNodeConfigSource contains the information to reference a ConfigMap as a config source for the Node. This API is deprecated since 1.22: https://git.k8s.io/enhancements/keps/sig-node/281-dynamic-kubelet-configuration
        :param _builtins.str kubelet_config_key: KubeletConfigKey declares which key of the referenced ConfigMap corresponds to the KubeletConfiguration structure This field is required in all cases.
        :param _builtins.str name: Name is the metadata.name of the referenced ConfigMap. This field is required in all cases.
        :param _builtins.str namespace: Namespace is the metadata.namespace of the referenced ConfigMap. This field is required in all cases.
        :param _builtins.str resource_version: ResourceVersion is the metadata.ResourceVersion of the referenced ConfigMap. This field is forbidden in Node.Spec, and required in Node.Status.
        :param _builtins.str uid: UID is the metadata.UID of the referenced ConfigMap. This field is forbidden in Node.Spec, and required in Node.Status.
        """
        pulumi.set(__self__, "kubelet_config_key", kubelet_config_key)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        if resource_version is not None:
            pulumi.set(__self__, "resource_version", resource_version)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @_builtins.property
    @pulumi.getter(name="kubeletConfigKey")
    def kubelet_config_key(self) -> _builtins.str:
        """
        KubeletConfigKey declares which key of the referenced ConfigMap corresponds to the KubeletConfiguration structure This field is required in all cases.
        """
        return pulumi.get(self, "kubelet_config_key")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name is the metadata.name of the referenced ConfigMap. This field is required in all cases.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        Namespace is the metadata.namespace of the referenced ConfigMap. This field is required in all cases.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="resourceVersion")
    def resource_version(self) -> Optional[_builtins.str]:
        """
        ResourceVersion is the metadata.ResourceVersion of the referenced ConfigMap. This field is forbidden in Node.Spec, and required in Node.Status.
        """
        return pulumi.get(self, "resource_version")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[_builtins.str]:
        """
        UID is the metadata.UID of the referenced ConfigMap. This field is forbidden in Node.Spec, and required in Node.Status.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class ConfigMapNodeConfigSourcePatch(dict):
    """
    ConfigMapNodeConfigSource contains the information to reference a ConfigMap as a config source for the Node. This API is deprecated since 1.22: https://git.k8s.io/enhancements/keps/sig-node/281-dynamic-kubelet-configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kubeletConfigKey":
            suggest = "kubelet_config_key"
        elif key == "resourceVersion":
            suggest = "resource_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigMapNodeConfigSourcePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigMapNodeConfigSourcePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigMapNodeConfigSourcePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kubelet_config_key: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 namespace: Optional[_builtins.str] = None,
                 resource_version: Optional[_builtins.str] = None,
                 uid: Optional[_builtins.str] = None):
        """
        ConfigMapNodeConfigSource contains the information to reference a ConfigMap as a config source for the Node. This API is deprecated since 1.22: https://git.k8s.io/enhancements/keps/sig-node/281-dynamic-kubelet-configuration
        :param _builtins.str kubelet_config_key: KubeletConfigKey declares which key of the referenced ConfigMap corresponds to the KubeletConfiguration structure This field is required in all cases.
        :param _builtins.str name: Name is the metadata.name of the referenced ConfigMap. This field is required in all cases.
        :param _builtins.str namespace: Namespace is the metadata.namespace of the referenced ConfigMap. This field is required in all cases.
        :param _builtins.str resource_version: ResourceVersion is the metadata.ResourceVersion of the referenced ConfigMap. This field is forbidden in Node.Spec, and required in Node.Status.
        :param _builtins.str uid: UID is the metadata.UID of the referenced ConfigMap. This field is forbidden in Node.Spec, and required in Node.Status.
        """
        if kubelet_config_key is not None:
            pulumi.set(__self__, "kubelet_config_key", kubelet_config_key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if resource_version is not None:
            pulumi.set(__self__, "resource_version", resource_version)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @_builtins.property
    @pulumi.getter(name="kubeletConfigKey")
    def kubelet_config_key(self) -> Optional[_builtins.str]:
        """
        KubeletConfigKey declares which key of the referenced ConfigMap corresponds to the KubeletConfiguration structure This field is required in all cases.
        """
        return pulumi.get(self, "kubelet_config_key")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name is the metadata.name of the referenced ConfigMap. This field is required in all cases.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        Namespace is the metadata.namespace of the referenced ConfigMap. This field is required in all cases.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="resourceVersion")
    def resource_version(self) -> Optional[_builtins.str]:
        """
        ResourceVersion is the metadata.ResourceVersion of the referenced ConfigMap. This field is forbidden in Node.Spec, and required in Node.Status.
        """
        return pulumi.get(self, "resource_version")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[_builtins.str]:
        """
        UID is the metadata.UID of the referenced ConfigMap. This field is forbidden in Node.Spec, and required in Node.Status.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class ConfigMapProjection(dict):
    """
    Adapts a ConfigMap into a projected volume.

    The contents of the target ConfigMap's Data field will be presented in a projected volume as files using the keys in the Data field as the file names, unless the items element is populated with specific mappings of keys to paths. Note that this is identical to a configmap volume source without the default mode.
    """
    def __init__(__self__, *,
                 items: Optional[Sequence['outputs.KeyToPath']] = None,
                 name: Optional[_builtins.str] = None,
                 optional: Optional[_builtins.bool] = None):
        """
        Adapts a ConfigMap into a projected volume.

        The contents of the target ConfigMap's Data field will be presented in a projected volume as files using the keys in the Data field as the file names, unless the items element is populated with specific mappings of keys to paths. Note that this is identical to a configmap volume source without the default mode.
        :param Sequence['KeyToPathArgs'] items: items if unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.
        :param _builtins.str name: Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        :param _builtins.bool optional: optional specify whether the ConfigMap or its keys must be defined
        """
        if items is not None:
            pulumi.set(__self__, "items", items)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if optional is not None:
            pulumi.set(__self__, "optional", optional)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Optional[Sequence['outputs.KeyToPath']]:
        """
        items if unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.
        """
        return pulumi.get(self, "items")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def optional(self) -> Optional[_builtins.bool]:
        """
        optional specify whether the ConfigMap or its keys must be defined
        """
        return pulumi.get(self, "optional")


@pulumi.output_type
class ConfigMapProjectionPatch(dict):
    """
    Adapts a ConfigMap into a projected volume.

    The contents of the target ConfigMap's Data field will be presented in a projected volume as files using the keys in the Data field as the file names, unless the items element is populated with specific mappings of keys to paths. Note that this is identical to a configmap volume source without the default mode.
    """
    def __init__(__self__, *,
                 items: Optional[Sequence['outputs.KeyToPathPatch']] = None,
                 name: Optional[_builtins.str] = None,
                 optional: Optional[_builtins.bool] = None):
        """
        Adapts a ConfigMap into a projected volume.

        The contents of the target ConfigMap's Data field will be presented in a projected volume as files using the keys in the Data field as the file names, unless the items element is populated with specific mappings of keys to paths. Note that this is identical to a configmap volume source without the default mode.
        :param Sequence['KeyToPathPatchArgs'] items: items if unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.
        :param _builtins.str name: Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        :param _builtins.bool optional: optional specify whether the ConfigMap or its keys must be defined
        """
        if items is not None:
            pulumi.set(__self__, "items", items)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if optional is not None:
            pulumi.set(__self__, "optional", optional)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Optional[Sequence['outputs.KeyToPathPatch']]:
        """
        items if unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.
        """
        return pulumi.get(self, "items")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def optional(self) -> Optional[_builtins.bool]:
        """
        optional specify whether the ConfigMap or its keys must be defined
        """
        return pulumi.get(self, "optional")


@pulumi.output_type
class ConfigMapVolumeSource(dict):
    """
    Adapts a ConfigMap into a volume.

    The contents of the target ConfigMap's Data field will be presented in a volume as files using the keys in the Data field as the file names, unless the items element is populated with specific mappings of keys to paths. ConfigMap volumes support ownership management and SELinux relabeling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultMode":
            suggest = "default_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigMapVolumeSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigMapVolumeSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigMapVolumeSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_mode: Optional[_builtins.int] = None,
                 items: Optional[Sequence['outputs.KeyToPath']] = None,
                 name: Optional[_builtins.str] = None,
                 optional: Optional[_builtins.bool] = None):
        """
        Adapts a ConfigMap into a volume.

        The contents of the target ConfigMap's Data field will be presented in a volume as files using the keys in the Data field as the file names, unless the items element is populated with specific mappings of keys to paths. ConfigMap volumes support ownership management and SELinux relabeling.
        :param _builtins.int default_mode: defaultMode is optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param Sequence['KeyToPathArgs'] items: items if unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.
        :param _builtins.str name: Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        :param _builtins.bool optional: optional specify whether the ConfigMap or its keys must be defined
        """
        if default_mode is not None:
            pulumi.set(__self__, "default_mode", default_mode)
        if items is not None:
            pulumi.set(__self__, "items", items)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if optional is not None:
            pulumi.set(__self__, "optional", optional)

    @_builtins.property
    @pulumi.getter(name="defaultMode")
    def default_mode(self) -> Optional[_builtins.int]:
        """
        defaultMode is optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        """
        return pulumi.get(self, "default_mode")

    @_builtins.property
    @pulumi.getter
    def items(self) -> Optional[Sequence['outputs.KeyToPath']]:
        """
        items if unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.
        """
        return pulumi.get(self, "items")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def optional(self) -> Optional[_builtins.bool]:
        """
        optional specify whether the ConfigMap or its keys must be defined
        """
        return pulumi.get(self, "optional")


@pulumi.output_type
class ConfigMapVolumeSourcePatch(dict):
    """
    Adapts a ConfigMap into a volume.

    The contents of the target ConfigMap's Data field will be presented in a volume as files using the keys in the Data field as the file names, unless the items element is populated with specific mappings of keys to paths. ConfigMap volumes support ownership management and SELinux relabeling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultMode":
            suggest = "default_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigMapVolumeSourcePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigMapVolumeSourcePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigMapVolumeSourcePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_mode: Optional[_builtins.int] = None,
                 items: Optional[Sequence['outputs.KeyToPathPatch']] = None,
                 name: Optional[_builtins.str] = None,
                 optional: Optional[_builtins.bool] = None):
        """
        Adapts a ConfigMap into a volume.

        The contents of the target ConfigMap's Data field will be presented in a volume as files using the keys in the Data field as the file names, unless the items element is populated with specific mappings of keys to paths. ConfigMap volumes support ownership management and SELinux relabeling.
        :param _builtins.int default_mode: defaultMode is optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param Sequence['KeyToPathPatchArgs'] items: items if unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.
        :param _builtins.str name: Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        :param _builtins.bool optional: optional specify whether the ConfigMap or its keys must be defined
        """
        if default_mode is not None:
            pulumi.set(__self__, "default_mode", default_mode)
        if items is not None:
            pulumi.set(__self__, "items", items)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if optional is not None:
            pulumi.set(__self__, "optional", optional)

    @_builtins.property
    @pulumi.getter(name="defaultMode")
    def default_mode(self) -> Optional[_builtins.int]:
        """
        defaultMode is optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        """
        return pulumi.get(self, "default_mode")

    @_builtins.property
    @pulumi.getter
    def items(self) -> Optional[Sequence['outputs.KeyToPathPatch']]:
        """
        items if unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.
        """
        return pulumi.get(self, "items")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def optional(self) -> Optional[_builtins.bool]:
        """
        optional specify whether the ConfigMap or its keys must be defined
        """
        return pulumi.get(self, "optional")


@pulumi.output_type
class Container(dict):
    """
    A single application container that you want to run within a pod.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "envFrom":
            suggest = "env_from"
        elif key == "imagePullPolicy":
            suggest = "image_pull_policy"
        elif key == "livenessProbe":
            suggest = "liveness_probe"
        elif key == "readinessProbe":
            suggest = "readiness_probe"
        elif key == "resizePolicy":
            suggest = "resize_policy"
        elif key == "restartPolicy":
            suggest = "restart_policy"
        elif key == "securityContext":
            suggest = "security_context"
        elif key == "startupProbe":
            suggest = "startup_probe"
        elif key == "stdinOnce":
            suggest = "stdin_once"
        elif key == "terminationMessagePath":
            suggest = "termination_message_path"
        elif key == "terminationMessagePolicy":
            suggest = "termination_message_policy"
        elif key == "volumeDevices":
            suggest = "volume_devices"
        elif key == "volumeMounts":
            suggest = "volume_mounts"
        elif key == "workingDir":
            suggest = "working_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Container. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Container.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Container.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 args: Optional[Sequence[_builtins.str]] = None,
                 command: Optional[Sequence[_builtins.str]] = None,
                 env: Optional[Sequence['outputs.EnvVar']] = None,
                 env_from: Optional[Sequence['outputs.EnvFromSource']] = None,
                 image: Optional[_builtins.str] = None,
                 image_pull_policy: Optional[_builtins.str] = None,
                 lifecycle: Optional['outputs.Lifecycle'] = None,
                 liveness_probe: Optional['outputs.Probe'] = None,
                 ports: Optional[Sequence['outputs.ContainerPort']] = None,
                 readiness_probe: Optional['outputs.Probe'] = None,
                 resize_policy: Optional[Sequence['outputs.ContainerResizePolicy']] = None,
                 resources: Optional['outputs.ResourceRequirements'] = None,
                 restart_policy: Optional[_builtins.str] = None,
                 security_context: Optional['outputs.SecurityContext'] = None,
                 startup_probe: Optional['outputs.Probe'] = None,
                 stdin: Optional[_builtins.bool] = None,
                 stdin_once: Optional[_builtins.bool] = None,
                 termination_message_path: Optional[_builtins.str] = None,
                 termination_message_policy: Optional[_builtins.str] = None,
                 tty: Optional[_builtins.bool] = None,
                 volume_devices: Optional[Sequence['outputs.VolumeDevice']] = None,
                 volume_mounts: Optional[Sequence['outputs.VolumeMount']] = None,
                 working_dir: Optional[_builtins.str] = None):
        """
        A single application container that you want to run within a pod.
        :param _builtins.str name: Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.
        :param Sequence[_builtins.str] args: Arguments to the entrypoint. The container image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param Sequence[_builtins.str] command: Entrypoint array. Not executed within a shell. The container image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param Sequence['EnvVarArgs'] env: List of environment variables to set in the container. Cannot be updated.
        :param Sequence['EnvFromSourceArgs'] env_from: List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.
        :param _builtins.str image: Container image name. More info: https://kubernetes.io/docs/concepts/containers/images This field is optional to allow higher level config management to default or override container images in workload controllers like Deployments and StatefulSets.
        :param _builtins.str image_pull_policy: Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images
        :param 'LifecycleArgs' lifecycle: Actions that the management system should take in response to container lifecycle events. Cannot be updated.
        :param 'ProbeArgs' liveness_probe: Periodic probe of container liveness. Container will be restarted if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param Sequence['ContainerPortArgs'] ports: List of ports to expose from the container. Not specifying a port here DOES NOT prevent that port from being exposed. Any port which is listening on the default "0.0.0.0" address inside a container will be accessible from the network. Modifying this array with strategic merge patch may corrupt the data. For more information See https://github.com/kubernetes/kubernetes/issues/108255. Cannot be updated.
        :param 'ProbeArgs' readiness_probe: Periodic probe of container service readiness. Container will be removed from service endpoints if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param Sequence['ContainerResizePolicyArgs'] resize_policy: Resources resize policy for the container.
        :param 'ResourceRequirementsArgs' resources: Compute Resources required by this container. Cannot be updated. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
        :param _builtins.str restart_policy: RestartPolicy defines the restart behavior of individual containers in a pod. This field may only be set for init containers, and the only allowed value is "Always". For non-init containers or when this field is not specified, the restart behavior is defined by the Pod's restart policy and the container type. Setting the RestartPolicy as "Always" for the init container will have the following effect: this init container will be continually restarted on exit until all regular containers have terminated. Once all regular containers have completed, all init containers with restartPolicy "Always" will be shut down. This lifecycle differs from normal init containers and is often referred to as a "sidecar" container. Although this init container still starts in the init container sequence, it does not wait for the container to complete before proceeding to the next init container. Instead, the next init container starts immediately after this init container is started, or after any startupProbe has successfully completed.
        :param 'SecurityContextArgs' security_context: SecurityContext defines the security options the container should be run with. If set, the fields of SecurityContext override the equivalent fields of PodSecurityContext. More info: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/
        :param 'ProbeArgs' startup_probe: StartupProbe indicates that the Pod has successfully initialized. If specified, no other probes are executed until this completes successfully. If this probe fails, the Pod will be restarted, just as if the livenessProbe failed. This can be used to provide different probe parameters at the beginning of a Pod's lifecycle, when it might take a long time to load data or warm a cache, than during steady-state operation. This cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param _builtins.bool stdin: Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false.
        :param _builtins.bool stdin_once: Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false
        :param _builtins.str termination_message_path: Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated.
        :param _builtins.str termination_message_policy: Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.
        :param _builtins.bool tty: Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false.
        :param Sequence['VolumeDeviceArgs'] volume_devices: volumeDevices is the list of block devices to be used by the container.
        :param Sequence['VolumeMountArgs'] volume_mounts: Pod volumes to mount into the container's filesystem. Cannot be updated.
        :param _builtins.str working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.
        """
        pulumi.set(__self__, "name", name)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if env is not None:
            pulumi.set(__self__, "env", env)
        if env_from is not None:
            pulumi.set(__self__, "env_from", env_from)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if image_pull_policy is not None:
            pulumi.set(__self__, "image_pull_policy", image_pull_policy)
        if lifecycle is not None:
            pulumi.set(__self__, "lifecycle", lifecycle)
        if liveness_probe is not None:
            pulumi.set(__self__, "liveness_probe", liveness_probe)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if readiness_probe is not None:
            pulumi.set(__self__, "readiness_probe", readiness_probe)
        if resize_policy is not None:
            pulumi.set(__self__, "resize_policy", resize_policy)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if restart_policy is not None:
            pulumi.set(__self__, "restart_policy", restart_policy)
        if security_context is not None:
            pulumi.set(__self__, "security_context", security_context)
        if startup_probe is not None:
            pulumi.set(__self__, "startup_probe", startup_probe)
        if stdin is not None:
            pulumi.set(__self__, "stdin", stdin)
        if stdin_once is not None:
            pulumi.set(__self__, "stdin_once", stdin_once)
        if termination_message_path is not None:
            pulumi.set(__self__, "termination_message_path", termination_message_path)
        if termination_message_policy is not None:
            pulumi.set(__self__, "termination_message_policy", termination_message_policy)
        if tty is not None:
            pulumi.set(__self__, "tty", tty)
        if volume_devices is not None:
            pulumi.set(__self__, "volume_devices", volume_devices)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[Sequence[_builtins.str]]:
        """
        Arguments to the entrypoint. The container image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter
    def command(self) -> Optional[Sequence[_builtins.str]]:
        """
        Entrypoint array. Not executed within a shell. The container image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        """
        return pulumi.get(self, "command")

    @_builtins.property
    @pulumi.getter
    def env(self) -> Optional[Sequence['outputs.EnvVar']]:
        """
        List of environment variables to set in the container. Cannot be updated.
        """
        return pulumi.get(self, "env")

    @_builtins.property
    @pulumi.getter(name="envFrom")
    def env_from(self) -> Optional[Sequence['outputs.EnvFromSource']]:
        """
        List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.
        """
        return pulumi.get(self, "env_from")

    @_builtins.property
    @pulumi.getter
    def image(self) -> Optional[_builtins.str]:
        """
        Container image name. More info: https://kubernetes.io/docs/concepts/containers/images This field is optional to allow higher level config management to default or override container images in workload controllers like Deployments and StatefulSets.
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter(name="imagePullPolicy")
    def image_pull_policy(self) -> Optional[_builtins.str]:
        """
        Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images
        """
        return pulumi.get(self, "image_pull_policy")

    @_builtins.property
    @pulumi.getter
    def lifecycle(self) -> Optional['outputs.Lifecycle']:
        """
        Actions that the management system should take in response to container lifecycle events. Cannot be updated.
        """
        return pulumi.get(self, "lifecycle")

    @_builtins.property
    @pulumi.getter(name="livenessProbe")
    def liveness_probe(self) -> Optional['outputs.Probe']:
        """
        Periodic probe of container liveness. Container will be restarted if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "liveness_probe")

    @_builtins.property
    @pulumi.getter
    def ports(self) -> Optional[Sequence['outputs.ContainerPort']]:
        """
        List of ports to expose from the container. Not specifying a port here DOES NOT prevent that port from being exposed. Any port which is listening on the default "0.0.0.0" address inside a container will be accessible from the network. Modifying this array with strategic merge patch may corrupt the data. For more information See https://github.com/kubernetes/kubernetes/issues/108255. Cannot be updated.
        """
        return pulumi.get(self, "ports")

    @_builtins.property
    @pulumi.getter(name="readinessProbe")
    def readiness_probe(self) -> Optional['outputs.Probe']:
        """
        Periodic probe of container service readiness. Container will be removed from service endpoints if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "readiness_probe")

    @_builtins.property
    @pulumi.getter(name="resizePolicy")
    def resize_policy(self) -> Optional[Sequence['outputs.ContainerResizePolicy']]:
        """
        Resources resize policy for the container.
        """
        return pulumi.get(self, "resize_policy")

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Optional['outputs.ResourceRequirements']:
        """
        Compute Resources required by this container. Cannot be updated. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
        """
        return pulumi.get(self, "resources")

    @_builtins.property
    @pulumi.getter(name="restartPolicy")
    def restart_policy(self) -> Optional[_builtins.str]:
        """
        RestartPolicy defines the restart behavior of individual containers in a pod. This field may only be set for init containers, and the only allowed value is "Always". For non-init containers or when this field is not specified, the restart behavior is defined by the Pod's restart policy and the container type. Setting the RestartPolicy as "Always" for the init container will have the following effect: this init container will be continually restarted on exit until all regular containers have terminated. Once all regular containers have completed, all init containers with restartPolicy "Always" will be shut down. This lifecycle differs from normal init containers and is often referred to as a "sidecar" container. Although this init container still starts in the init container sequence, it does not wait for the container to complete before proceeding to the next init container. Instead, the next init container starts immediately after this init container is started, or after any startupProbe has successfully completed.
        """
        return pulumi.get(self, "restart_policy")

    @_builtins.property
    @pulumi.getter(name="securityContext")
    def security_context(self) -> Optional['outputs.SecurityContext']:
        """
        SecurityContext defines the security options the container should be run with. If set, the fields of SecurityContext override the equivalent fields of PodSecurityContext. More info: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/
        """
        return pulumi.get(self, "security_context")

    @_builtins.property
    @pulumi.getter(name="startupProbe")
    def startup_probe(self) -> Optional['outputs.Probe']:
        """
        StartupProbe indicates that the Pod has successfully initialized. If specified, no other probes are executed until this completes successfully. If this probe fails, the Pod will be restarted, just as if the livenessProbe failed. This can be used to provide different probe parameters at the beginning of a Pod's lifecycle, when it might take a long time to load data or warm a cache, than during steady-state operation. This cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "startup_probe")

    @_builtins.property
    @pulumi.getter
    def stdin(self) -> Optional[_builtins.bool]:
        """
        Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false.
        """
        return pulumi.get(self, "stdin")

    @_builtins.property
    @pulumi.getter(name="stdinOnce")
    def stdin_once(self) -> Optional[_builtins.bool]:
        """
        Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false
        """
        return pulumi.get(self, "stdin_once")

    @_builtins.property
    @pulumi.getter(name="terminationMessagePath")
    def termination_message_path(self) -> Optional[_builtins.str]:
        """
        Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated.
        """
        return pulumi.get(self, "termination_message_path")

    @_builtins.property
    @pulumi.getter(name="terminationMessagePolicy")
    def termination_message_policy(self) -> Optional[_builtins.str]:
        """
        Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.
        """
        return pulumi.get(self, "termination_message_policy")

    @_builtins.property
    @pulumi.getter
    def tty(self) -> Optional[_builtins.bool]:
        """
        Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false.
        """
        return pulumi.get(self, "tty")

    @_builtins.property
    @pulumi.getter(name="volumeDevices")
    def volume_devices(self) -> Optional[Sequence['outputs.VolumeDevice']]:
        """
        volumeDevices is the list of block devices to be used by the container.
        """
        return pulumi.get(self, "volume_devices")

    @_builtins.property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[Sequence['outputs.VolumeMount']]:
        """
        Pod volumes to mount into the container's filesystem. Cannot be updated.
        """
        return pulumi.get(self, "volume_mounts")

    @_builtins.property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> Optional[_builtins.str]:
        """
        Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.
        """
        return pulumi.get(self, "working_dir")


@pulumi.output_type
class ContainerImage(dict):
    """
    Describe a container image
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sizeBytes":
            suggest = "size_bytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerImage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerImage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerImage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 names: Sequence[_builtins.str],
                 size_bytes: Optional[_builtins.int] = None):
        """
        Describe a container image
        :param Sequence[_builtins.str] names: Names by which this image is known. e.g. ["kubernetes.example/hyperkube:v1.0.7", "cloud-vendor.registry.example/cloud-vendor/hyperkube:v1.0.7"]
        :param _builtins.int size_bytes: The size of the image in bytes.
        """
        pulumi.set(__self__, "names", names)
        if size_bytes is not None:
            pulumi.set(__self__, "size_bytes", size_bytes)

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        Names by which this image is known. e.g. ["kubernetes.example/hyperkube:v1.0.7", "cloud-vendor.registry.example/cloud-vendor/hyperkube:v1.0.7"]
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="sizeBytes")
    def size_bytes(self) -> Optional[_builtins.int]:
        """
        The size of the image in bytes.
        """
        return pulumi.get(self, "size_bytes")


@pulumi.output_type
class ContainerImagePatch(dict):
    """
    Describe a container image
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sizeBytes":
            suggest = "size_bytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerImagePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerImagePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerImagePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 names: Optional[Sequence[_builtins.str]] = None,
                 size_bytes: Optional[_builtins.int] = None):
        """
        Describe a container image
        :param Sequence[_builtins.str] names: Names by which this image is known. e.g. ["kubernetes.example/hyperkube:v1.0.7", "cloud-vendor.registry.example/cloud-vendor/hyperkube:v1.0.7"]
        :param _builtins.int size_bytes: The size of the image in bytes.
        """
        if names is not None:
            pulumi.set(__self__, "names", names)
        if size_bytes is not None:
            pulumi.set(__self__, "size_bytes", size_bytes)

    @_builtins.property
    @pulumi.getter
    def names(self) -> Optional[Sequence[_builtins.str]]:
        """
        Names by which this image is known. e.g. ["kubernetes.example/hyperkube:v1.0.7", "cloud-vendor.registry.example/cloud-vendor/hyperkube:v1.0.7"]
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="sizeBytes")
    def size_bytes(self) -> Optional[_builtins.int]:
        """
        The size of the image in bytes.
        """
        return pulumi.get(self, "size_bytes")


@pulumi.output_type
class ContainerPatch(dict):
    """
    A single application container that you want to run within a pod.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "envFrom":
            suggest = "env_from"
        elif key == "imagePullPolicy":
            suggest = "image_pull_policy"
        elif key == "livenessProbe":
            suggest = "liveness_probe"
        elif key == "readinessProbe":
            suggest = "readiness_probe"
        elif key == "resizePolicy":
            suggest = "resize_policy"
        elif key == "restartPolicy":
            suggest = "restart_policy"
        elif key == "securityContext":
            suggest = "security_context"
        elif key == "startupProbe":
            suggest = "startup_probe"
        elif key == "stdinOnce":
            suggest = "stdin_once"
        elif key == "terminationMessagePath":
            suggest = "termination_message_path"
        elif key == "terminationMessagePolicy":
            suggest = "termination_message_policy"
        elif key == "volumeDevices":
            suggest = "volume_devices"
        elif key == "volumeMounts":
            suggest = "volume_mounts"
        elif key == "workingDir":
            suggest = "working_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 args: Optional[Sequence[_builtins.str]] = None,
                 command: Optional[Sequence[_builtins.str]] = None,
                 env: Optional[Sequence['outputs.EnvVarPatch']] = None,
                 env_from: Optional[Sequence['outputs.EnvFromSourcePatch']] = None,
                 image: Optional[_builtins.str] = None,
                 image_pull_policy: Optional[_builtins.str] = None,
                 lifecycle: Optional['outputs.LifecyclePatch'] = None,
                 liveness_probe: Optional['outputs.ProbePatch'] = None,
                 name: Optional[_builtins.str] = None,
                 ports: Optional[Sequence['outputs.ContainerPortPatch']] = None,
                 readiness_probe: Optional['outputs.ProbePatch'] = None,
                 resize_policy: Optional[Sequence['outputs.ContainerResizePolicyPatch']] = None,
                 resources: Optional['outputs.ResourceRequirementsPatch'] = None,
                 restart_policy: Optional[_builtins.str] = None,
                 security_context: Optional['outputs.SecurityContextPatch'] = None,
                 startup_probe: Optional['outputs.ProbePatch'] = None,
                 stdin: Optional[_builtins.bool] = None,
                 stdin_once: Optional[_builtins.bool] = None,
                 termination_message_path: Optional[_builtins.str] = None,
                 termination_message_policy: Optional[_builtins.str] = None,
                 tty: Optional[_builtins.bool] = None,
                 volume_devices: Optional[Sequence['outputs.VolumeDevicePatch']] = None,
                 volume_mounts: Optional[Sequence['outputs.VolumeMountPatch']] = None,
                 working_dir: Optional[_builtins.str] = None):
        """
        A single application container that you want to run within a pod.
        :param Sequence[_builtins.str] args: Arguments to the entrypoint. The container image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param Sequence[_builtins.str] command: Entrypoint array. Not executed within a shell. The container image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param Sequence['EnvVarPatchArgs'] env: List of environment variables to set in the container. Cannot be updated.
        :param Sequence['EnvFromSourcePatchArgs'] env_from: List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.
        :param _builtins.str image: Container image name. More info: https://kubernetes.io/docs/concepts/containers/images This field is optional to allow higher level config management to default or override container images in workload controllers like Deployments and StatefulSets.
        :param _builtins.str image_pull_policy: Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images
        :param 'LifecyclePatchArgs' lifecycle: Actions that the management system should take in response to container lifecycle events. Cannot be updated.
        :param 'ProbePatchArgs' liveness_probe: Periodic probe of container liveness. Container will be restarted if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param _builtins.str name: Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.
        :param Sequence['ContainerPortPatchArgs'] ports: List of ports to expose from the container. Not specifying a port here DOES NOT prevent that port from being exposed. Any port which is listening on the default "0.0.0.0" address inside a container will be accessible from the network. Modifying this array with strategic merge patch may corrupt the data. For more information See https://github.com/kubernetes/kubernetes/issues/108255. Cannot be updated.
        :param 'ProbePatchArgs' readiness_probe: Periodic probe of container service readiness. Container will be removed from service endpoints if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param Sequence['ContainerResizePolicyPatchArgs'] resize_policy: Resources resize policy for the container.
        :param 'ResourceRequirementsPatchArgs' resources: Compute Resources required by this container. Cannot be updated. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
        :param _builtins.str restart_policy: RestartPolicy defines the restart behavior of individual containers in a pod. This field may only be set for init containers, and the only allowed value is "Always". For non-init containers or when this field is not specified, the restart behavior is defined by the Pod's restart policy and the container type. Setting the RestartPolicy as "Always" for the init container will have the following effect: this init container will be continually restarted on exit until all regular containers have terminated. Once all regular containers have completed, all init containers with restartPolicy "Always" will be shut down. This lifecycle differs from normal init containers and is often referred to as a "sidecar" container. Although this init container still starts in the init container sequence, it does not wait for the container to complete before proceeding to the next init container. Instead, the next init container starts immediately after this init container is started, or after any startupProbe has successfully completed.
        :param 'SecurityContextPatchArgs' security_context: SecurityContext defines the security options the container should be run with. If set, the fields of SecurityContext override the equivalent fields of PodSecurityContext. More info: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/
        :param 'ProbePatchArgs' startup_probe: StartupProbe indicates that the Pod has successfully initialized. If specified, no other probes are executed until this completes successfully. If this probe fails, the Pod will be restarted, just as if the livenessProbe failed. This can be used to provide different probe parameters at the beginning of a Pod's lifecycle, when it might take a long time to load data or warm a cache, than during steady-state operation. This cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param _builtins.bool stdin: Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false.
        :param _builtins.bool stdin_once: Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false
        :param _builtins.str termination_message_path: Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated.
        :param _builtins.str termination_message_policy: Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.
        :param _builtins.bool tty: Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false.
        :param Sequence['VolumeDevicePatchArgs'] volume_devices: volumeDevices is the list of block devices to be used by the container.
        :param Sequence['VolumeMountPatchArgs'] volume_mounts: Pod volumes to mount into the container's filesystem. Cannot be updated.
        :param _builtins.str working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.
        """
        if args is not None:
            pulumi.set(__self__, "args", args)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if env is not None:
            pulumi.set(__self__, "env", env)
        if env_from is not None:
            pulumi.set(__self__, "env_from", env_from)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if image_pull_policy is not None:
            pulumi.set(__self__, "image_pull_policy", image_pull_policy)
        if lifecycle is not None:
            pulumi.set(__self__, "lifecycle", lifecycle)
        if liveness_probe is not None:
            pulumi.set(__self__, "liveness_probe", liveness_probe)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if readiness_probe is not None:
            pulumi.set(__self__, "readiness_probe", readiness_probe)
        if resize_policy is not None:
            pulumi.set(__self__, "resize_policy", resize_policy)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if restart_policy is not None:
            pulumi.set(__self__, "restart_policy", restart_policy)
        if security_context is not None:
            pulumi.set(__self__, "security_context", security_context)
        if startup_probe is not None:
            pulumi.set(__self__, "startup_probe", startup_probe)
        if stdin is not None:
            pulumi.set(__self__, "stdin", stdin)
        if stdin_once is not None:
            pulumi.set(__self__, "stdin_once", stdin_once)
        if termination_message_path is not None:
            pulumi.set(__self__, "termination_message_path", termination_message_path)
        if termination_message_policy is not None:
            pulumi.set(__self__, "termination_message_policy", termination_message_policy)
        if tty is not None:
            pulumi.set(__self__, "tty", tty)
        if volume_devices is not None:
            pulumi.set(__self__, "volume_devices", volume_devices)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[Sequence[_builtins.str]]:
        """
        Arguments to the entrypoint. The container image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter
    def command(self) -> Optional[Sequence[_builtins.str]]:
        """
        Entrypoint array. Not executed within a shell. The container image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        """
        return pulumi.get(self, "command")

    @_builtins.property
    @pulumi.getter
    def env(self) -> Optional[Sequence['outputs.EnvVarPatch']]:
        """
        List of environment variables to set in the container. Cannot be updated.
        """
        return pulumi.get(self, "env")

    @_builtins.property
    @pulumi.getter(name="envFrom")
    def env_from(self) -> Optional[Sequence['outputs.EnvFromSourcePatch']]:
        """
        List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.
        """
        return pulumi.get(self, "env_from")

    @_builtins.property
    @pulumi.getter
    def image(self) -> Optional[_builtins.str]:
        """
        Container image name. More info: https://kubernetes.io/docs/concepts/containers/images This field is optional to allow higher level config management to default or override container images in workload controllers like Deployments and StatefulSets.
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter(name="imagePullPolicy")
    def image_pull_policy(self) -> Optional[_builtins.str]:
        """
        Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images
        """
        return pulumi.get(self, "image_pull_policy")

    @_builtins.property
    @pulumi.getter
    def lifecycle(self) -> Optional['outputs.LifecyclePatch']:
        """
        Actions that the management system should take in response to container lifecycle events. Cannot be updated.
        """
        return pulumi.get(self, "lifecycle")

    @_builtins.property
    @pulumi.getter(name="livenessProbe")
    def liveness_probe(self) -> Optional['outputs.ProbePatch']:
        """
        Periodic probe of container liveness. Container will be restarted if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "liveness_probe")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def ports(self) -> Optional[Sequence['outputs.ContainerPortPatch']]:
        """
        List of ports to expose from the container. Not specifying a port here DOES NOT prevent that port from being exposed. Any port which is listening on the default "0.0.0.0" address inside a container will be accessible from the network. Modifying this array with strategic merge patch may corrupt the data. For more information See https://github.com/kubernetes/kubernetes/issues/108255. Cannot be updated.
        """
        return pulumi.get(self, "ports")

    @_builtins.property
    @pulumi.getter(name="readinessProbe")
    def readiness_probe(self) -> Optional['outputs.ProbePatch']:
        """
        Periodic probe of container service readiness. Container will be removed from service endpoints if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "readiness_probe")

    @_builtins.property
    @pulumi.getter(name="resizePolicy")
    def resize_policy(self) -> Optional[Sequence['outputs.ContainerResizePolicyPatch']]:
        """
        Resources resize policy for the container.
        """
        return pulumi.get(self, "resize_policy")

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Optional['outputs.ResourceRequirementsPatch']:
        """
        Compute Resources required by this container. Cannot be updated. More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
        """
        return pulumi.get(self, "resources")

    @_builtins.property
    @pulumi.getter(name="restartPolicy")
    def restart_policy(self) -> Optional[_builtins.str]:
        """
        RestartPolicy defines the restart behavior of individual containers in a pod. This field may only be set for init containers, and the only allowed value is "Always". For non-init containers or when this field is not specified, the restart behavior is defined by the Pod's restart policy and the container type. Setting the RestartPolicy as "Always" for the init container will have the following effect: this init container will be continually restarted on exit until all regular containers have terminated. Once all regular containers have completed, all init containers with restartPolicy "Always" will be shut down. This lifecycle differs from normal init containers and is often referred to as a "sidecar" container. Although this init container still starts in the init container sequence, it does not wait for the container to complete before proceeding to the next init container. Instead, the next init container starts immediately after this init container is started, or after any startupProbe has successfully completed.
        """
        return pulumi.get(self, "restart_policy")

    @_builtins.property
    @pulumi.getter(name="securityContext")
    def security_context(self) -> Optional['outputs.SecurityContextPatch']:
        """
        SecurityContext defines the security options the container should be run with. If set, the fields of SecurityContext override the equivalent fields of PodSecurityContext. More info: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/
        """
        return pulumi.get(self, "security_context")

    @_builtins.property
    @pulumi.getter(name="startupProbe")
    def startup_probe(self) -> Optional['outputs.ProbePatch']:
        """
        StartupProbe indicates that the Pod has successfully initialized. If specified, no other probes are executed until this completes successfully. If this probe fails, the Pod will be restarted, just as if the livenessProbe failed. This can be used to provide different probe parameters at the beginning of a Pod's lifecycle, when it might take a long time to load data or warm a cache, than during steady-state operation. This cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "startup_probe")

    @_builtins.property
    @pulumi.getter
    def stdin(self) -> Optional[_builtins.bool]:
        """
        Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false.
        """
        return pulumi.get(self, "stdin")

    @_builtins.property
    @pulumi.getter(name="stdinOnce")
    def stdin_once(self) -> Optional[_builtins.bool]:
        """
        Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false
        """
        return pulumi.get(self, "stdin_once")

    @_builtins.property
    @pulumi.getter(name="terminationMessagePath")
    def termination_message_path(self) -> Optional[_builtins.str]:
        """
        Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated.
        """
        return pulumi.get(self, "termination_message_path")

    @_builtins.property
    @pulumi.getter(name="terminationMessagePolicy")
    def termination_message_policy(self) -> Optional[_builtins.str]:
        """
        Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.
        """
        return pulumi.get(self, "termination_message_policy")

    @_builtins.property
    @pulumi.getter
    def tty(self) -> Optional[_builtins.bool]:
        """
        Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false.
        """
        return pulumi.get(self, "tty")

    @_builtins.property
    @pulumi.getter(name="volumeDevices")
    def volume_devices(self) -> Optional[Sequence['outputs.VolumeDevicePatch']]:
        """
        volumeDevices is the list of block devices to be used by the container.
        """
        return pulumi.get(self, "volume_devices")

    @_builtins.property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[Sequence['outputs.VolumeMountPatch']]:
        """
        Pod volumes to mount into the container's filesystem. Cannot be updated.
        """
        return pulumi.get(self, "volume_mounts")

    @_builtins.property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> Optional[_builtins.str]:
        """
        Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.
        """
        return pulumi.get(self, "working_dir")


@pulumi.output_type
class ContainerPort(dict):
    """
    ContainerPort represents a network port in a single container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerPort":
            suggest = "container_port"
        elif key == "hostIP":
            suggest = "host_ip"
        elif key == "hostPort":
            suggest = "host_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerPort. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerPort.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerPort.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_port: _builtins.int,
                 host_ip: Optional[_builtins.str] = None,
                 host_port: Optional[_builtins.int] = None,
                 name: Optional[_builtins.str] = None,
                 protocol: Optional[_builtins.str] = None):
        """
        ContainerPort represents a network port in a single container.
        :param _builtins.int container_port: Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.
        :param _builtins.str host_ip: What host IP to bind the external port to.
        :param _builtins.int host_port: Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this.
        :param _builtins.str name: If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services.
        :param _builtins.str protocol: Protocol for port. Must be UDP, TCP, or SCTP. Defaults to "TCP".
        """
        pulumi.set(__self__, "container_port", container_port)
        if host_ip is not None:
            pulumi.set(__self__, "host_ip", host_ip)
        if host_port is not None:
            pulumi.set(__self__, "host_port", host_port)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> _builtins.int:
        """
        Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.
        """
        return pulumi.get(self, "container_port")

    @_builtins.property
    @pulumi.getter(name="hostIP")
    def host_ip(self) -> Optional[_builtins.str]:
        """
        What host IP to bind the external port to.
        """
        return pulumi.get(self, "host_ip")

    @_builtins.property
    @pulumi.getter(name="hostPort")
    def host_port(self) -> Optional[_builtins.int]:
        """
        Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this.
        """
        return pulumi.get(self, "host_port")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        """
        Protocol for port. Must be UDP, TCP, or SCTP. Defaults to "TCP".
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class ContainerPortPatch(dict):
    """
    ContainerPort represents a network port in a single container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerPort":
            suggest = "container_port"
        elif key == "hostIP":
            suggest = "host_ip"
        elif key == "hostPort":
            suggest = "host_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerPortPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerPortPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerPortPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_port: Optional[_builtins.int] = None,
                 host_ip: Optional[_builtins.str] = None,
                 host_port: Optional[_builtins.int] = None,
                 name: Optional[_builtins.str] = None,
                 protocol: Optional[_builtins.str] = None):
        """
        ContainerPort represents a network port in a single container.
        :param _builtins.int container_port: Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.
        :param _builtins.str host_ip: What host IP to bind the external port to.
        :param _builtins.int host_port: Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this.
        :param _builtins.str name: If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services.
        :param _builtins.str protocol: Protocol for port. Must be UDP, TCP, or SCTP. Defaults to "TCP".
        """
        if container_port is not None:
            pulumi.set(__self__, "container_port", container_port)
        if host_ip is not None:
            pulumi.set(__self__, "host_ip", host_ip)
        if host_port is not None:
            pulumi.set(__self__, "host_port", host_port)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> Optional[_builtins.int]:
        """
        Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.
        """
        return pulumi.get(self, "container_port")

    @_builtins.property
    @pulumi.getter(name="hostIP")
    def host_ip(self) -> Optional[_builtins.str]:
        """
        What host IP to bind the external port to.
        """
        return pulumi.get(self, "host_ip")

    @_builtins.property
    @pulumi.getter(name="hostPort")
    def host_port(self) -> Optional[_builtins.int]:
        """
        Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this.
        """
        return pulumi.get(self, "host_port")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        """
        Protocol for port. Must be UDP, TCP, or SCTP. Defaults to "TCP".
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class ContainerResizePolicy(dict):
    """
    ContainerResizePolicy represents resource resize policy for the container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceName":
            suggest = "resource_name"
        elif key == "restartPolicy":
            suggest = "restart_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerResizePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerResizePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerResizePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_name: _builtins.str,
                 restart_policy: _builtins.str):
        """
        ContainerResizePolicy represents resource resize policy for the container.
        :param _builtins.str resource_name: Name of the resource to which this resource resize policy applies. Supported values: cpu, memory.
        :param _builtins.str restart_policy: Restart policy to apply when specified resource is resized. If not specified, it defaults to NotRequired.
        """
        pulumi.set(__self__, "resource_name", resource_name)
        pulumi.set(__self__, "restart_policy", restart_policy)

    @_builtins.property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> _builtins.str:
        """
        Name of the resource to which this resource resize policy applies. Supported values: cpu, memory.
        """
        return pulumi.get(self, "resource_name")

    @_builtins.property
    @pulumi.getter(name="restartPolicy")
    def restart_policy(self) -> _builtins.str:
        """
        Restart policy to apply when specified resource is resized. If not specified, it defaults to NotRequired.
        """
        return pulumi.get(self, "restart_policy")


@pulumi.output_type
class ContainerResizePolicyPatch(dict):
    """
    ContainerResizePolicy represents resource resize policy for the container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceName":
            suggest = "resource_name"
        elif key == "restartPolicy":
            suggest = "restart_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerResizePolicyPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerResizePolicyPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerResizePolicyPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_name: Optional[_builtins.str] = None,
                 restart_policy: Optional[_builtins.str] = None):
        """
        ContainerResizePolicy represents resource resize policy for the container.
        :param _builtins.str resource_name: Name of the resource to which this resource resize policy applies. Supported values: cpu, memory.
        :param _builtins.str restart_policy: Restart policy to apply when specified resource is resized. If not specified, it defaults to NotRequired.
        """
        if resource_name is not None:
            pulumi.set(__self__, "resource_name", resource_name)
        if restart_policy is not None:
            pulumi.set(__self__, "restart_policy", restart_policy)

    @_builtins.property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> Optional[_builtins.str]:
        """
        Name of the resource to which this resource resize policy applies. Supported values: cpu, memory.
        """
        return pulumi.get(self, "resource_name")

    @_builtins.property
    @pulumi.getter(name="restartPolicy")
    def restart_policy(self) -> Optional[_builtins.str]:
        """
        Restart policy to apply when specified resource is resized. If not specified, it defaults to NotRequired.
        """
        return pulumi.get(self, "restart_policy")


@pulumi.output_type
class ContainerState(dict):
    """
    ContainerState holds a possible state of container. Only one of its members may be specified. If none of them is specified, the default one is ContainerStateWaiting.
    """
    def __init__(__self__, *,
                 running: Optional['outputs.ContainerStateRunning'] = None,
                 terminated: Optional['outputs.ContainerStateTerminated'] = None,
                 waiting: Optional['outputs.ContainerStateWaiting'] = None):
        """
        ContainerState holds a possible state of container. Only one of its members may be specified. If none of them is specified, the default one is ContainerStateWaiting.
        :param 'ContainerStateRunningArgs' running: Details about a running container
        :param 'ContainerStateTerminatedArgs' terminated: Details about a terminated container
        :param 'ContainerStateWaitingArgs' waiting: Details about a waiting container
        """
        if running is not None:
            pulumi.set(__self__, "running", running)
        if terminated is not None:
            pulumi.set(__self__, "terminated", terminated)
        if waiting is not None:
            pulumi.set(__self__, "waiting", waiting)

    @_builtins.property
    @pulumi.getter
    def running(self) -> Optional['outputs.ContainerStateRunning']:
        """
        Details about a running container
        """
        return pulumi.get(self, "running")

    @_builtins.property
    @pulumi.getter
    def terminated(self) -> Optional['outputs.ContainerStateTerminated']:
        """
        Details about a terminated container
        """
        return pulumi.get(self, "terminated")

    @_builtins.property
    @pulumi.getter
    def waiting(self) -> Optional['outputs.ContainerStateWaiting']:
        """
        Details about a waiting container
        """
        return pulumi.get(self, "waiting")


@pulumi.output_type
class ContainerStatePatch(dict):
    """
    ContainerState holds a possible state of container. Only one of its members may be specified. If none of them is specified, the default one is ContainerStateWaiting.
    """
    def __init__(__self__, *,
                 running: Optional['outputs.ContainerStateRunningPatch'] = None,
                 terminated: Optional['outputs.ContainerStateTerminatedPatch'] = None,
                 waiting: Optional['outputs.ContainerStateWaitingPatch'] = None):
        """
        ContainerState holds a possible state of container. Only one of its members may be specified. If none of them is specified, the default one is ContainerStateWaiting.
        :param 'ContainerStateRunningPatchArgs' running: Details about a running container
        :param 'ContainerStateTerminatedPatchArgs' terminated: Details about a terminated container
        :param 'ContainerStateWaitingPatchArgs' waiting: Details about a waiting container
        """
        if running is not None:
            pulumi.set(__self__, "running", running)
        if terminated is not None:
            pulumi.set(__self__, "terminated", terminated)
        if waiting is not None:
            pulumi.set(__self__, "waiting", waiting)

    @_builtins.property
    @pulumi.getter
    def running(self) -> Optional['outputs.ContainerStateRunningPatch']:
        """
        Details about a running container
        """
        return pulumi.get(self, "running")

    @_builtins.property
    @pulumi.getter
    def terminated(self) -> Optional['outputs.ContainerStateTerminatedPatch']:
        """
        Details about a terminated container
        """
        return pulumi.get(self, "terminated")

    @_builtins.property
    @pulumi.getter
    def waiting(self) -> Optional['outputs.ContainerStateWaitingPatch']:
        """
        Details about a waiting container
        """
        return pulumi.get(self, "waiting")


@pulumi.output_type
class ContainerStateRunning(dict):
    """
    ContainerStateRunning is a running state of a container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startedAt":
            suggest = "started_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerStateRunning. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerStateRunning.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerStateRunning.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 started_at: Optional[_builtins.str] = None):
        """
        ContainerStateRunning is a running state of a container.
        :param _builtins.str started_at: Time at which the container was last (re-)started
        """
        if started_at is not None:
            pulumi.set(__self__, "started_at", started_at)

    @_builtins.property
    @pulumi.getter(name="startedAt")
    def started_at(self) -> Optional[_builtins.str]:
        """
        Time at which the container was last (re-)started
        """
        return pulumi.get(self, "started_at")


@pulumi.output_type
class ContainerStateRunningPatch(dict):
    """
    ContainerStateRunning is a running state of a container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startedAt":
            suggest = "started_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerStateRunningPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerStateRunningPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerStateRunningPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 started_at: Optional[_builtins.str] = None):
        """
        ContainerStateRunning is a running state of a container.
        :param _builtins.str started_at: Time at which the container was last (re-)started
        """
        if started_at is not None:
            pulumi.set(__self__, "started_at", started_at)

    @_builtins.property
    @pulumi.getter(name="startedAt")
    def started_at(self) -> Optional[_builtins.str]:
        """
        Time at which the container was last (re-)started
        """
        return pulumi.get(self, "started_at")


@pulumi.output_type
class ContainerStateTerminated(dict):
    """
    ContainerStateTerminated is a terminated state of a container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exitCode":
            suggest = "exit_code"
        elif key == "containerID":
            suggest = "container_id"
        elif key == "finishedAt":
            suggest = "finished_at"
        elif key == "startedAt":
            suggest = "started_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerStateTerminated. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerStateTerminated.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerStateTerminated.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exit_code: _builtins.int,
                 container_id: Optional[_builtins.str] = None,
                 finished_at: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None,
                 signal: Optional[_builtins.int] = None,
                 started_at: Optional[_builtins.str] = None):
        """
        ContainerStateTerminated is a terminated state of a container.
        :param _builtins.int exit_code: Exit status from the last termination of the container
        :param _builtins.str container_id: Container's ID in the format '<type>://<container_id>'
        :param _builtins.str finished_at: Time at which the container last terminated
        :param _builtins.str message: Message regarding the last termination of the container
        :param _builtins.str reason: (brief) reason from the last termination of the container
        :param _builtins.int signal: Signal from the last termination of the container
        :param _builtins.str started_at: Time at which previous execution of the container started
        """
        pulumi.set(__self__, "exit_code", exit_code)
        if container_id is not None:
            pulumi.set(__self__, "container_id", container_id)
        if finished_at is not None:
            pulumi.set(__self__, "finished_at", finished_at)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if signal is not None:
            pulumi.set(__self__, "signal", signal)
        if started_at is not None:
            pulumi.set(__self__, "started_at", started_at)

    @_builtins.property
    @pulumi.getter(name="exitCode")
    def exit_code(self) -> _builtins.int:
        """
        Exit status from the last termination of the container
        """
        return pulumi.get(self, "exit_code")

    @_builtins.property
    @pulumi.getter(name="containerID")
    def container_id(self) -> Optional[_builtins.str]:
        """
        Container's ID in the format '<type>://<container_id>'
        """
        return pulumi.get(self, "container_id")

    @_builtins.property
    @pulumi.getter(name="finishedAt")
    def finished_at(self) -> Optional[_builtins.str]:
        """
        Time at which the container last terminated
        """
        return pulumi.get(self, "finished_at")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        Message regarding the last termination of the container
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        (brief) reason from the last termination of the container
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter
    def signal(self) -> Optional[_builtins.int]:
        """
        Signal from the last termination of the container
        """
        return pulumi.get(self, "signal")

    @_builtins.property
    @pulumi.getter(name="startedAt")
    def started_at(self) -> Optional[_builtins.str]:
        """
        Time at which previous execution of the container started
        """
        return pulumi.get(self, "started_at")


@pulumi.output_type
class ContainerStateTerminatedPatch(dict):
    """
    ContainerStateTerminated is a terminated state of a container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerID":
            suggest = "container_id"
        elif key == "exitCode":
            suggest = "exit_code"
        elif key == "finishedAt":
            suggest = "finished_at"
        elif key == "startedAt":
            suggest = "started_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerStateTerminatedPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerStateTerminatedPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerStateTerminatedPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_id: Optional[_builtins.str] = None,
                 exit_code: Optional[_builtins.int] = None,
                 finished_at: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None,
                 signal: Optional[_builtins.int] = None,
                 started_at: Optional[_builtins.str] = None):
        """
        ContainerStateTerminated is a terminated state of a container.
        :param _builtins.str container_id: Container's ID in the format '<type>://<container_id>'
        :param _builtins.int exit_code: Exit status from the last termination of the container
        :param _builtins.str finished_at: Time at which the container last terminated
        :param _builtins.str message: Message regarding the last termination of the container
        :param _builtins.str reason: (brief) reason from the last termination of the container
        :param _builtins.int signal: Signal from the last termination of the container
        :param _builtins.str started_at: Time at which previous execution of the container started
        """
        if container_id is not None:
            pulumi.set(__self__, "container_id", container_id)
        if exit_code is not None:
            pulumi.set(__self__, "exit_code", exit_code)
        if finished_at is not None:
            pulumi.set(__self__, "finished_at", finished_at)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if signal is not None:
            pulumi.set(__self__, "signal", signal)
        if started_at is not None:
            pulumi.set(__self__, "started_at", started_at)

    @_builtins.property
    @pulumi.getter(name="containerID")
    def container_id(self) -> Optional[_builtins.str]:
        """
        Container's ID in the format '<type>://<container_id>'
        """
        return pulumi.get(self, "container_id")

    @_builtins.property
    @pulumi.getter(name="exitCode")
    def exit_code(self) -> Optional[_builtins.int]:
        """
        Exit status from the last termination of the container
        """
        return pulumi.get(self, "exit_code")

    @_builtins.property
    @pulumi.getter(name="finishedAt")
    def finished_at(self) -> Optional[_builtins.str]:
        """
        Time at which the container last terminated
        """
        return pulumi.get(self, "finished_at")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        Message regarding the last termination of the container
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        (brief) reason from the last termination of the container
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter
    def signal(self) -> Optional[_builtins.int]:
        """
        Signal from the last termination of the container
        """
        return pulumi.get(self, "signal")

    @_builtins.property
    @pulumi.getter(name="startedAt")
    def started_at(self) -> Optional[_builtins.str]:
        """
        Time at which previous execution of the container started
        """
        return pulumi.get(self, "started_at")


@pulumi.output_type
class ContainerStateWaiting(dict):
    """
    ContainerStateWaiting is a waiting state of a container.
    """
    def __init__(__self__, *,
                 message: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None):
        """
        ContainerStateWaiting is a waiting state of a container.
        :param _builtins.str message: Message regarding why the container is not yet running.
        :param _builtins.str reason: (brief) reason the container is not yet running.
        """
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        Message regarding why the container is not yet running.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        (brief) reason the container is not yet running.
        """
        return pulumi.get(self, "reason")


@pulumi.output_type
class ContainerStateWaitingPatch(dict):
    """
    ContainerStateWaiting is a waiting state of a container.
    """
    def __init__(__self__, *,
                 message: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None):
        """
        ContainerStateWaiting is a waiting state of a container.
        :param _builtins.str message: Message regarding why the container is not yet running.
        :param _builtins.str reason: (brief) reason the container is not yet running.
        """
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        Message regarding why the container is not yet running.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        (brief) reason the container is not yet running.
        """
        return pulumi.get(self, "reason")


@pulumi.output_type
class ContainerStatus(dict):
    """
    ContainerStatus contains details for the current status of this container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageID":
            suggest = "image_id"
        elif key == "restartCount":
            suggest = "restart_count"
        elif key == "allocatedResources":
            suggest = "allocated_resources"
        elif key == "allocatedResourcesStatus":
            suggest = "allocated_resources_status"
        elif key == "containerID":
            suggest = "container_id"
        elif key == "lastState":
            suggest = "last_state"
        elif key == "stopSignal":
            suggest = "stop_signal"
        elif key == "volumeMounts":
            suggest = "volume_mounts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image: _builtins.str,
                 image_id: _builtins.str,
                 name: _builtins.str,
                 ready: _builtins.bool,
                 restart_count: _builtins.int,
                 allocated_resources: Optional[Mapping[str, _builtins.str]] = None,
                 allocated_resources_status: Optional[Sequence['outputs.ResourceStatus']] = None,
                 container_id: Optional[_builtins.str] = None,
                 last_state: Optional['outputs.ContainerState'] = None,
                 resources: Optional['outputs.ResourceRequirements'] = None,
                 started: Optional[_builtins.bool] = None,
                 state: Optional['outputs.ContainerState'] = None,
                 stop_signal: Optional[_builtins.str] = None,
                 user: Optional['outputs.ContainerUser'] = None,
                 volume_mounts: Optional[Sequence['outputs.VolumeMountStatus']] = None):
        """
        ContainerStatus contains details for the current status of this container.
        :param _builtins.str image: Image is the name of container image that the container is running. The container image may not match the image used in the PodSpec, as it may have been resolved by the runtime. More info: https://kubernetes.io/docs/concepts/containers/images.
        :param _builtins.str image_id: ImageID is the image ID of the container's image. The image ID may not match the image ID of the image used in the PodSpec, as it may have been resolved by the runtime.
        :param _builtins.str name: Name is a DNS_LABEL representing the unique name of the container. Each container in a pod must have a unique name across all container types. Cannot be updated.
        :param _builtins.bool ready: Ready specifies whether the container is currently passing its readiness check. The value will change as readiness probes keep executing. If no readiness probes are specified, this field defaults to true once the container is fully started (see Started field).
               
               The value is typically used to determine whether a container is ready to accept traffic.
        :param _builtins.int restart_count: RestartCount holds the number of times the container has been restarted. Kubelet makes an effort to always increment the value, but there are cases when the state may be lost due to node restarts and then the value may be reset to 0. The value is never negative.
        :param Mapping[str, _builtins.str] allocated_resources: AllocatedResources represents the compute resources allocated for this container by the node. Kubelet sets this value to Container.Resources.Requests upon successful pod admission and after successfully admitting desired pod resize.
        :param Sequence['ResourceStatusArgs'] allocated_resources_status: AllocatedResourcesStatus represents the status of various resources allocated for this Pod.
        :param _builtins.str container_id: ContainerID is the ID of the container in the format '<type>://<container_id>'. Where type is a container runtime identifier, returned from Version call of CRI API (for example "containerd").
        :param 'ContainerStateArgs' last_state: LastTerminationState holds the last termination state of the container to help debug container crashes and restarts. This field is not populated if the container is still running and RestartCount is 0.
        :param 'ResourceRequirementsArgs' resources: Resources represents the compute resource requests and limits that have been successfully enacted on the running container after it has been started or has been successfully resized.
        :param _builtins.bool started: Started indicates whether the container has finished its postStart lifecycle hook and passed its startup probe. Initialized as false, becomes true after startupProbe is considered successful. Resets to false when the container is restarted, or if kubelet loses state temporarily. In both cases, startup probes will run again. Is always true when no startupProbe is defined and container is running and has passed the postStart lifecycle hook. The null value must be treated the same as false.
        :param 'ContainerStateArgs' state: State holds details about the container's current condition.
        :param _builtins.str stop_signal: StopSignal reports the effective stop signal for this container
        :param 'ContainerUserArgs' user: User represents user identity information initially attached to the first process of the container
        :param Sequence['VolumeMountStatusArgs'] volume_mounts: Status of volume mounts.
        """
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "ready", ready)
        pulumi.set(__self__, "restart_count", restart_count)
        if allocated_resources is not None:
            pulumi.set(__self__, "allocated_resources", allocated_resources)
        if allocated_resources_status is not None:
            pulumi.set(__self__, "allocated_resources_status", allocated_resources_status)
        if container_id is not None:
            pulumi.set(__self__, "container_id", container_id)
        if last_state is not None:
            pulumi.set(__self__, "last_state", last_state)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if started is not None:
            pulumi.set(__self__, "started", started)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if stop_signal is not None:
            pulumi.set(__self__, "stop_signal", stop_signal)
        if user is not None:
            pulumi.set(__self__, "user", user)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)

    @_builtins.property
    @pulumi.getter
    def image(self) -> _builtins.str:
        """
        Image is the name of container image that the container is running. The container image may not match the image used in the PodSpec, as it may have been resolved by the runtime. More info: https://kubernetes.io/docs/concepts/containers/images.
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter(name="imageID")
    def image_id(self) -> _builtins.str:
        """
        ImageID is the image ID of the container's image. The image ID may not match the image ID of the image used in the PodSpec, as it may have been resolved by the runtime.
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name is a DNS_LABEL representing the unique name of the container. Each container in a pod must have a unique name across all container types. Cannot be updated.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def ready(self) -> _builtins.bool:
        """
        Ready specifies whether the container is currently passing its readiness check. The value will change as readiness probes keep executing. If no readiness probes are specified, this field defaults to true once the container is fully started (see Started field).

        The value is typically used to determine whether a container is ready to accept traffic.
        """
        return pulumi.get(self, "ready")

    @_builtins.property
    @pulumi.getter(name="restartCount")
    def restart_count(self) -> _builtins.int:
        """
        RestartCount holds the number of times the container has been restarted. Kubelet makes an effort to always increment the value, but there are cases when the state may be lost due to node restarts and then the value may be reset to 0. The value is never negative.
        """
        return pulumi.get(self, "restart_count")

    @_builtins.property
    @pulumi.getter(name="allocatedResources")
    def allocated_resources(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        AllocatedResources represents the compute resources allocated for this container by the node. Kubelet sets this value to Container.Resources.Requests upon successful pod admission and after successfully admitting desired pod resize.
        """
        return pulumi.get(self, "allocated_resources")

    @_builtins.property
    @pulumi.getter(name="allocatedResourcesStatus")
    def allocated_resources_status(self) -> Optional[Sequence['outputs.ResourceStatus']]:
        """
        AllocatedResourcesStatus represents the status of various resources allocated for this Pod.
        """
        return pulumi.get(self, "allocated_resources_status")

    @_builtins.property
    @pulumi.getter(name="containerID")
    def container_id(self) -> Optional[_builtins.str]:
        """
        ContainerID is the ID of the container in the format '<type>://<container_id>'. Where type is a container runtime identifier, returned from Version call of CRI API (for example "containerd").
        """
        return pulumi.get(self, "container_id")

    @_builtins.property
    @pulumi.getter(name="lastState")
    def last_state(self) -> Optional['outputs.ContainerState']:
        """
        LastTerminationState holds the last termination state of the container to help debug container crashes and restarts. This field is not populated if the container is still running and RestartCount is 0.
        """
        return pulumi.get(self, "last_state")

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Optional['outputs.ResourceRequirements']:
        """
        Resources represents the compute resource requests and limits that have been successfully enacted on the running container after it has been started or has been successfully resized.
        """
        return pulumi.get(self, "resources")

    @_builtins.property
    @pulumi.getter
    def started(self) -> Optional[_builtins.bool]:
        """
        Started indicates whether the container has finished its postStart lifecycle hook and passed its startup probe. Initialized as false, becomes true after startupProbe is considered successful. Resets to false when the container is restarted, or if kubelet loses state temporarily. In both cases, startup probes will run again. Is always true when no startupProbe is defined and container is running and has passed the postStart lifecycle hook. The null value must be treated the same as false.
        """
        return pulumi.get(self, "started")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional['outputs.ContainerState']:
        """
        State holds details about the container's current condition.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="stopSignal")
    def stop_signal(self) -> Optional[_builtins.str]:
        """
        StopSignal reports the effective stop signal for this container
        """
        return pulumi.get(self, "stop_signal")

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional['outputs.ContainerUser']:
        """
        User represents user identity information initially attached to the first process of the container
        """
        return pulumi.get(self, "user")

    @_builtins.property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[Sequence['outputs.VolumeMountStatus']]:
        """
        Status of volume mounts.
        """
        return pulumi.get(self, "volume_mounts")


@pulumi.output_type
class ContainerStatusPatch(dict):
    """
    ContainerStatus contains details for the current status of this container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allocatedResources":
            suggest = "allocated_resources"
        elif key == "allocatedResourcesStatus":
            suggest = "allocated_resources_status"
        elif key == "containerID":
            suggest = "container_id"
        elif key == "imageID":
            suggest = "image_id"
        elif key == "lastState":
            suggest = "last_state"
        elif key == "restartCount":
            suggest = "restart_count"
        elif key == "stopSignal":
            suggest = "stop_signal"
        elif key == "volumeMounts":
            suggest = "volume_mounts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerStatusPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerStatusPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerStatusPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocated_resources: Optional[Mapping[str, _builtins.str]] = None,
                 allocated_resources_status: Optional[Sequence['outputs.ResourceStatusPatch']] = None,
                 container_id: Optional[_builtins.str] = None,
                 image: Optional[_builtins.str] = None,
                 image_id: Optional[_builtins.str] = None,
                 last_state: Optional['outputs.ContainerStatePatch'] = None,
                 name: Optional[_builtins.str] = None,
                 ready: Optional[_builtins.bool] = None,
                 resources: Optional['outputs.ResourceRequirementsPatch'] = None,
                 restart_count: Optional[_builtins.int] = None,
                 started: Optional[_builtins.bool] = None,
                 state: Optional['outputs.ContainerStatePatch'] = None,
                 stop_signal: Optional[_builtins.str] = None,
                 user: Optional['outputs.ContainerUserPatch'] = None,
                 volume_mounts: Optional[Sequence['outputs.VolumeMountStatusPatch']] = None):
        """
        ContainerStatus contains details for the current status of this container.
        :param Mapping[str, _builtins.str] allocated_resources: AllocatedResources represents the compute resources allocated for this container by the node. Kubelet sets this value to Container.Resources.Requests upon successful pod admission and after successfully admitting desired pod resize.
        :param Sequence['ResourceStatusPatchArgs'] allocated_resources_status: AllocatedResourcesStatus represents the status of various resources allocated for this Pod.
        :param _builtins.str container_id: ContainerID is the ID of the container in the format '<type>://<container_id>'. Where type is a container runtime identifier, returned from Version call of CRI API (for example "containerd").
        :param _builtins.str image: Image is the name of container image that the container is running. The container image may not match the image used in the PodSpec, as it may have been resolved by the runtime. More info: https://kubernetes.io/docs/concepts/containers/images.
        :param _builtins.str image_id: ImageID is the image ID of the container's image. The image ID may not match the image ID of the image used in the PodSpec, as it may have been resolved by the runtime.
        :param 'ContainerStatePatchArgs' last_state: LastTerminationState holds the last termination state of the container to help debug container crashes and restarts. This field is not populated if the container is still running and RestartCount is 0.
        :param _builtins.str name: Name is a DNS_LABEL representing the unique name of the container. Each container in a pod must have a unique name across all container types. Cannot be updated.
        :param _builtins.bool ready: Ready specifies whether the container is currently passing its readiness check. The value will change as readiness probes keep executing. If no readiness probes are specified, this field defaults to true once the container is fully started (see Started field).
               
               The value is typically used to determine whether a container is ready to accept traffic.
        :param 'ResourceRequirementsPatchArgs' resources: Resources represents the compute resource requests and limits that have been successfully enacted on the running container after it has been started or has been successfully resized.
        :param _builtins.int restart_count: RestartCount holds the number of times the container has been restarted. Kubelet makes an effort to always increment the value, but there are cases when the state may be lost due to node restarts and then the value may be reset to 0. The value is never negative.
        :param _builtins.bool started: Started indicates whether the container has finished its postStart lifecycle hook and passed its startup probe. Initialized as false, becomes true after startupProbe is considered successful. Resets to false when the container is restarted, or if kubelet loses state temporarily. In both cases, startup probes will run again. Is always true when no startupProbe is defined and container is running and has passed the postStart lifecycle hook. The null value must be treated the same as false.
        :param 'ContainerStatePatchArgs' state: State holds details about the container's current condition.
        :param _builtins.str stop_signal: StopSignal reports the effective stop signal for this container
        :param 'ContainerUserPatchArgs' user: User represents user identity information initially attached to the first process of the container
        :param Sequence['VolumeMountStatusPatchArgs'] volume_mounts: Status of volume mounts.
        """
        if allocated_resources is not None:
            pulumi.set(__self__, "allocated_resources", allocated_resources)
        if allocated_resources_status is not None:
            pulumi.set(__self__, "allocated_resources_status", allocated_resources_status)
        if container_id is not None:
            pulumi.set(__self__, "container_id", container_id)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if last_state is not None:
            pulumi.set(__self__, "last_state", last_state)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ready is not None:
            pulumi.set(__self__, "ready", ready)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if restart_count is not None:
            pulumi.set(__self__, "restart_count", restart_count)
        if started is not None:
            pulumi.set(__self__, "started", started)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if stop_signal is not None:
            pulumi.set(__self__, "stop_signal", stop_signal)
        if user is not None:
            pulumi.set(__self__, "user", user)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)

    @_builtins.property
    @pulumi.getter(name="allocatedResources")
    def allocated_resources(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        AllocatedResources represents the compute resources allocated for this container by the node. Kubelet sets this value to Container.Resources.Requests upon successful pod admission and after successfully admitting desired pod resize.
        """
        return pulumi.get(self, "allocated_resources")

    @_builtins.property
    @pulumi.getter(name="allocatedResourcesStatus")
    def allocated_resources_status(self) -> Optional[Sequence['outputs.ResourceStatusPatch']]:
        """
        AllocatedResourcesStatus represents the status of various resources allocated for this Pod.
        """
        return pulumi.get(self, "allocated_resources_status")

    @_builtins.property
    @pulumi.getter(name="containerID")
    def container_id(self) -> Optional[_builtins.str]:
        """
        ContainerID is the ID of the container in the format '<type>://<container_id>'. Where type is a container runtime identifier, returned from Version call of CRI API (for example "containerd").
        """
        return pulumi.get(self, "container_id")

    @_builtins.property
    @pulumi.getter
    def image(self) -> Optional[_builtins.str]:
        """
        Image is the name of container image that the container is running. The container image may not match the image used in the PodSpec, as it may have been resolved by the runtime. More info: https://kubernetes.io/docs/concepts/containers/images.
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter(name="imageID")
    def image_id(self) -> Optional[_builtins.str]:
        """
        ImageID is the image ID of the container's image. The image ID may not match the image ID of the image used in the PodSpec, as it may have been resolved by the runtime.
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="lastState")
    def last_state(self) -> Optional['outputs.ContainerStatePatch']:
        """
        LastTerminationState holds the last termination state of the container to help debug container crashes and restarts. This field is not populated if the container is still running and RestartCount is 0.
        """
        return pulumi.get(self, "last_state")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name is a DNS_LABEL representing the unique name of the container. Each container in a pod must have a unique name across all container types. Cannot be updated.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def ready(self) -> Optional[_builtins.bool]:
        """
        Ready specifies whether the container is currently passing its readiness check. The value will change as readiness probes keep executing. If no readiness probes are specified, this field defaults to true once the container is fully started (see Started field).

        The value is typically used to determine whether a container is ready to accept traffic.
        """
        return pulumi.get(self, "ready")

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Optional['outputs.ResourceRequirementsPatch']:
        """
        Resources represents the compute resource requests and limits that have been successfully enacted on the running container after it has been started or has been successfully resized.
        """
        return pulumi.get(self, "resources")

    @_builtins.property
    @pulumi.getter(name="restartCount")
    def restart_count(self) -> Optional[_builtins.int]:
        """
        RestartCount holds the number of times the container has been restarted. Kubelet makes an effort to always increment the value, but there are cases when the state may be lost due to node restarts and then the value may be reset to 0. The value is never negative.
        """
        return pulumi.get(self, "restart_count")

    @_builtins.property
    @pulumi.getter
    def started(self) -> Optional[_builtins.bool]:
        """
        Started indicates whether the container has finished its postStart lifecycle hook and passed its startup probe. Initialized as false, becomes true after startupProbe is considered successful. Resets to false when the container is restarted, or if kubelet loses state temporarily. In both cases, startup probes will run again. Is always true when no startupProbe is defined and container is running and has passed the postStart lifecycle hook. The null value must be treated the same as false.
        """
        return pulumi.get(self, "started")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional['outputs.ContainerStatePatch']:
        """
        State holds details about the container's current condition.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="stopSignal")
    def stop_signal(self) -> Optional[_builtins.str]:
        """
        StopSignal reports the effective stop signal for this container
        """
        return pulumi.get(self, "stop_signal")

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional['outputs.ContainerUserPatch']:
        """
        User represents user identity information initially attached to the first process of the container
        """
        return pulumi.get(self, "user")

    @_builtins.property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[Sequence['outputs.VolumeMountStatusPatch']]:
        """
        Status of volume mounts.
        """
        return pulumi.get(self, "volume_mounts")


@pulumi.output_type
class ContainerUser(dict):
    """
    ContainerUser represents user identity information
    """
    def __init__(__self__, *,
                 linux: Optional['outputs.LinuxContainerUser'] = None):
        """
        ContainerUser represents user identity information
        :param 'LinuxContainerUserArgs' linux: Linux holds user identity information initially attached to the first process of the containers in Linux. Note that the actual running identity can be changed if the process has enough privilege to do so.
        """
        if linux is not None:
            pulumi.set(__self__, "linux", linux)

    @_builtins.property
    @pulumi.getter
    def linux(self) -> Optional['outputs.LinuxContainerUser']:
        """
        Linux holds user identity information initially attached to the first process of the containers in Linux. Note that the actual running identity can be changed if the process has enough privilege to do so.
        """
        return pulumi.get(self, "linux")


@pulumi.output_type
class ContainerUserPatch(dict):
    """
    ContainerUser represents user identity information
    """
    def __init__(__self__, *,
                 linux: Optional['outputs.LinuxContainerUserPatch'] = None):
        """
        ContainerUser represents user identity information
        :param 'LinuxContainerUserPatchArgs' linux: Linux holds user identity information initially attached to the first process of the containers in Linux. Note that the actual running identity can be changed if the process has enough privilege to do so.
        """
        if linux is not None:
            pulumi.set(__self__, "linux", linux)

    @_builtins.property
    @pulumi.getter
    def linux(self) -> Optional['outputs.LinuxContainerUserPatch']:
        """
        Linux holds user identity information initially attached to the first process of the containers in Linux. Note that the actual running identity can be changed if the process has enough privilege to do so.
        """
        return pulumi.get(self, "linux")


@pulumi.output_type
class DaemonEndpoint(dict):
    """
    DaemonEndpoint contains information about a single Daemon endpoint.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "Port":
            suggest = "port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DaemonEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DaemonEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DaemonEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: _builtins.int):
        """
        DaemonEndpoint contains information about a single Daemon endpoint.
        :param _builtins.int port: Port number of the given endpoint.
        """
        pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="Port")
    def port(self) -> _builtins.int:
        """
        Port number of the given endpoint.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class DaemonEndpointPatch(dict):
    """
    DaemonEndpoint contains information about a single Daemon endpoint.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "Port":
            suggest = "port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DaemonEndpointPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DaemonEndpointPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DaemonEndpointPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: Optional[_builtins.int] = None):
        """
        DaemonEndpoint contains information about a single Daemon endpoint.
        :param _builtins.int port: Port number of the given endpoint.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="Port")
    def port(self) -> Optional[_builtins.int]:
        """
        Port number of the given endpoint.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class DownwardAPIProjection(dict):
    """
    Represents downward API info for projecting into a projected volume. Note that this is identical to a downwardAPI volume source without the default mode.
    """
    def __init__(__self__, *,
                 items: Optional[Sequence['outputs.DownwardAPIVolumeFile']] = None):
        """
        Represents downward API info for projecting into a projected volume. Note that this is identical to a downwardAPI volume source without the default mode.
        :param Sequence['DownwardAPIVolumeFileArgs'] items: Items is a list of DownwardAPIVolume file
        """
        if items is not None:
            pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Optional[Sequence['outputs.DownwardAPIVolumeFile']]:
        """
        Items is a list of DownwardAPIVolume file
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class DownwardAPIProjectionPatch(dict):
    """
    Represents downward API info for projecting into a projected volume. Note that this is identical to a downwardAPI volume source without the default mode.
    """
    def __init__(__self__, *,
                 items: Optional[Sequence['outputs.DownwardAPIVolumeFilePatch']] = None):
        """
        Represents downward API info for projecting into a projected volume. Note that this is identical to a downwardAPI volume source without the default mode.
        :param Sequence['DownwardAPIVolumeFilePatchArgs'] items: Items is a list of DownwardAPIVolume file
        """
        if items is not None:
            pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Optional[Sequence['outputs.DownwardAPIVolumeFilePatch']]:
        """
        Items is a list of DownwardAPIVolume file
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class DownwardAPIVolumeFile(dict):
    """
    DownwardAPIVolumeFile represents information to create the file containing the pod field
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldRef":
            suggest = "field_ref"
        elif key == "resourceFieldRef":
            suggest = "resource_field_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DownwardAPIVolumeFile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DownwardAPIVolumeFile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DownwardAPIVolumeFile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path: _builtins.str,
                 field_ref: Optional['outputs.ObjectFieldSelector'] = None,
                 mode: Optional[_builtins.int] = None,
                 resource_field_ref: Optional['outputs.ResourceFieldSelector'] = None):
        """
        DownwardAPIVolumeFile represents information to create the file containing the pod field
        :param _builtins.str path: Required: Path is  the relative path name of the file to be created. Must not be absolute or contain the '..' path. Must be utf-8 encoded. The first item of the relative path must not start with '..'
        :param 'ObjectFieldSelectorArgs' field_ref: Required: Selects a field of the pod: only annotations, labels, name, namespace and uid are supported.
        :param _builtins.int mode: Optional: mode bits used to set permissions on this file, must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param 'ResourceFieldSelectorArgs' resource_field_ref: Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, requests.cpu and requests.memory) are currently supported.
        """
        pulumi.set(__self__, "path", path)
        if field_ref is not None:
            pulumi.set(__self__, "field_ref", field_ref)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if resource_field_ref is not None:
            pulumi.set(__self__, "resource_field_ref", resource_field_ref)

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        Required: Path is  the relative path name of the file to be created. Must not be absolute or contain the '..' path. Must be utf-8 encoded. The first item of the relative path must not start with '..'
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="fieldRef")
    def field_ref(self) -> Optional['outputs.ObjectFieldSelector']:
        """
        Required: Selects a field of the pod: only annotations, labels, name, namespace and uid are supported.
        """
        return pulumi.get(self, "field_ref")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[_builtins.int]:
        """
        Optional: mode bits used to set permissions on this file, must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter(name="resourceFieldRef")
    def resource_field_ref(self) -> Optional['outputs.ResourceFieldSelector']:
        """
        Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, requests.cpu and requests.memory) are currently supported.
        """
        return pulumi.get(self, "resource_field_ref")


@pulumi.output_type
class DownwardAPIVolumeFilePatch(dict):
    """
    DownwardAPIVolumeFile represents information to create the file containing the pod field
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldRef":
            suggest = "field_ref"
        elif key == "resourceFieldRef":
            suggest = "resource_field_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DownwardAPIVolumeFilePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DownwardAPIVolumeFilePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DownwardAPIVolumeFilePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_ref: Optional['outputs.ObjectFieldSelectorPatch'] = None,
                 mode: Optional[_builtins.int] = None,
                 path: Optional[_builtins.str] = None,
                 resource_field_ref: Optional['outputs.ResourceFieldSelectorPatch'] = None):
        """
        DownwardAPIVolumeFile represents information to create the file containing the pod field
        :param 'ObjectFieldSelectorPatchArgs' field_ref: Required: Selects a field of the pod: only annotations, labels, name, namespace and uid are supported.
        :param _builtins.int mode: Optional: mode bits used to set permissions on this file, must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param _builtins.str path: Required: Path is  the relative path name of the file to be created. Must not be absolute or contain the '..' path. Must be utf-8 encoded. The first item of the relative path must not start with '..'
        :param 'ResourceFieldSelectorPatchArgs' resource_field_ref: Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, requests.cpu and requests.memory) are currently supported.
        """
        if field_ref is not None:
            pulumi.set(__self__, "field_ref", field_ref)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if resource_field_ref is not None:
            pulumi.set(__self__, "resource_field_ref", resource_field_ref)

    @_builtins.property
    @pulumi.getter(name="fieldRef")
    def field_ref(self) -> Optional['outputs.ObjectFieldSelectorPatch']:
        """
        Required: Selects a field of the pod: only annotations, labels, name, namespace and uid are supported.
        """
        return pulumi.get(self, "field_ref")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[_builtins.int]:
        """
        Optional: mode bits used to set permissions on this file, must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        Required: Path is  the relative path name of the file to be created. Must not be absolute or contain the '..' path. Must be utf-8 encoded. The first item of the relative path must not start with '..'
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="resourceFieldRef")
    def resource_field_ref(self) -> Optional['outputs.ResourceFieldSelectorPatch']:
        """
        Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, requests.cpu and requests.memory) are currently supported.
        """
        return pulumi.get(self, "resource_field_ref")


@pulumi.output_type
class DownwardAPIVolumeSource(dict):
    """
    DownwardAPIVolumeSource represents a volume containing downward API info. Downward API volumes support ownership management and SELinux relabeling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultMode":
            suggest = "default_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DownwardAPIVolumeSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DownwardAPIVolumeSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DownwardAPIVolumeSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_mode: Optional[_builtins.int] = None,
                 items: Optional[Sequence['outputs.DownwardAPIVolumeFile']] = None):
        """
        DownwardAPIVolumeSource represents a volume containing downward API info. Downward API volumes support ownership management and SELinux relabeling.
        :param _builtins.int default_mode: Optional: mode bits to use on created files by default. Must be a Optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param Sequence['DownwardAPIVolumeFileArgs'] items: Items is a list of downward API volume file
        """
        if default_mode is not None:
            pulumi.set(__self__, "default_mode", default_mode)
        if items is not None:
            pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter(name="defaultMode")
    def default_mode(self) -> Optional[_builtins.int]:
        """
        Optional: mode bits to use on created files by default. Must be a Optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        """
        return pulumi.get(self, "default_mode")

    @_builtins.property
    @pulumi.getter
    def items(self) -> Optional[Sequence['outputs.DownwardAPIVolumeFile']]:
        """
        Items is a list of downward API volume file
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class DownwardAPIVolumeSourcePatch(dict):
    """
    DownwardAPIVolumeSource represents a volume containing downward API info. Downward API volumes support ownership management and SELinux relabeling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultMode":
            suggest = "default_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DownwardAPIVolumeSourcePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DownwardAPIVolumeSourcePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DownwardAPIVolumeSourcePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_mode: Optional[_builtins.int] = None,
                 items: Optional[Sequence['outputs.DownwardAPIVolumeFilePatch']] = None):
        """
        DownwardAPIVolumeSource represents a volume containing downward API info. Downward API volumes support ownership management and SELinux relabeling.
        :param _builtins.int default_mode: Optional: mode bits to use on created files by default. Must be a Optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param Sequence['DownwardAPIVolumeFilePatchArgs'] items: Items is a list of downward API volume file
        """
        if default_mode is not None:
            pulumi.set(__self__, "default_mode", default_mode)
        if items is not None:
            pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter(name="defaultMode")
    def default_mode(self) -> Optional[_builtins.int]:
        """
        Optional: mode bits to use on created files by default. Must be a Optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        """
        return pulumi.get(self, "default_mode")

    @_builtins.property
    @pulumi.getter
    def items(self) -> Optional[Sequence['outputs.DownwardAPIVolumeFilePatch']]:
        """
        Items is a list of downward API volume file
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class EmptyDirVolumeSource(dict):
    """
    Represents an empty directory for a pod. Empty directory volumes support ownership management and SELinux relabeling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sizeLimit":
            suggest = "size_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EmptyDirVolumeSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EmptyDirVolumeSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EmptyDirVolumeSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 medium: Optional[_builtins.str] = None,
                 size_limit: Optional[_builtins.str] = None):
        """
        Represents an empty directory for a pod. Empty directory volumes support ownership management and SELinux relabeling.
        :param _builtins.str medium: medium represents what type of storage medium should back this directory. The default is "" which means to use the node's default medium. Must be an empty string (default) or Memory. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir
        :param _builtins.str size_limit: sizeLimit is the total amount of local storage required for this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. The default is nil which means that the limit is undefined. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir
        """
        if medium is not None:
            pulumi.set(__self__, "medium", medium)
        if size_limit is not None:
            pulumi.set(__self__, "size_limit", size_limit)

    @_builtins.property
    @pulumi.getter
    def medium(self) -> Optional[_builtins.str]:
        """
        medium represents what type of storage medium should back this directory. The default is "" which means to use the node's default medium. Must be an empty string (default) or Memory. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir
        """
        return pulumi.get(self, "medium")

    @_builtins.property
    @pulumi.getter(name="sizeLimit")
    def size_limit(self) -> Optional[_builtins.str]:
        """
        sizeLimit is the total amount of local storage required for this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. The default is nil which means that the limit is undefined. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir
        """
        return pulumi.get(self, "size_limit")


@pulumi.output_type
class EmptyDirVolumeSourcePatch(dict):
    """
    Represents an empty directory for a pod. Empty directory volumes support ownership management and SELinux relabeling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sizeLimit":
            suggest = "size_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EmptyDirVolumeSourcePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EmptyDirVolumeSourcePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EmptyDirVolumeSourcePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 medium: Optional[_builtins.str] = None,
                 size_limit: Optional[_builtins.str] = None):
        """
        Represents an empty directory for a pod. Empty directory volumes support ownership management and SELinux relabeling.
        :param _builtins.str medium: medium represents what type of storage medium should back this directory. The default is "" which means to use the node's default medium. Must be an empty string (default) or Memory. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir
        :param _builtins.str size_limit: sizeLimit is the total amount of local storage required for this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. The default is nil which means that the limit is undefined. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir
        """
        if medium is not None:
            pulumi.set(__self__, "medium", medium)
        if size_limit is not None:
            pulumi.set(__self__, "size_limit", size_limit)

    @_builtins.property
    @pulumi.getter
    def medium(self) -> Optional[_builtins.str]:
        """
        medium represents what type of storage medium should back this directory. The default is "" which means to use the node's default medium. Must be an empty string (default) or Memory. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir
        """
        return pulumi.get(self, "medium")

    @_builtins.property
    @pulumi.getter(name="sizeLimit")
    def size_limit(self) -> Optional[_builtins.str]:
        """
        sizeLimit is the total amount of local storage required for this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. The default is nil which means that the limit is undefined. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir
        """
        return pulumi.get(self, "size_limit")


@pulumi.output_type
class EndpointAddress(dict):
    """
    EndpointAddress is a tuple that describes single IP address. Deprecated: This API is deprecated in v1.33+.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeName":
            suggest = "node_name"
        elif key == "targetRef":
            suggest = "target_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointAddress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointAddress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointAddress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip: _builtins.str,
                 hostname: Optional[_builtins.str] = None,
                 node_name: Optional[_builtins.str] = None,
                 target_ref: Optional['outputs.ObjectReference'] = None):
        """
        EndpointAddress is a tuple that describes single IP address. Deprecated: This API is deprecated in v1.33+.
        :param _builtins.str ip: The IP of this endpoint. May not be loopback (127.0.0.0/8 or ::1), link-local (169.254.0.0/16 or fe80::/10), or link-local multicast (224.0.0.0/24 or ff02::/16).
        :param _builtins.str hostname: The Hostname of this endpoint
        :param _builtins.str node_name: Optional: Node hosting this endpoint. This can be used to determine endpoints local to a node.
        :param 'ObjectReferenceArgs' target_ref: Reference to object providing the endpoint.
        """
        pulumi.set(__self__, "ip", ip)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if node_name is not None:
            pulumi.set(__self__, "node_name", node_name)
        if target_ref is not None:
            pulumi.set(__self__, "target_ref", target_ref)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        The IP of this endpoint. May not be loopback (127.0.0.0/8 or ::1), link-local (169.254.0.0/16 or fe80::/10), or link-local multicast (224.0.0.0/24 or ff02::/16).
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[_builtins.str]:
        """
        The Hostname of this endpoint
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> Optional[_builtins.str]:
        """
        Optional: Node hosting this endpoint. This can be used to determine endpoints local to a node.
        """
        return pulumi.get(self, "node_name")

    @_builtins.property
    @pulumi.getter(name="targetRef")
    def target_ref(self) -> Optional['outputs.ObjectReference']:
        """
        Reference to object providing the endpoint.
        """
        return pulumi.get(self, "target_ref")


@pulumi.output_type
class EndpointAddressPatch(dict):
    """
    EndpointAddress is a tuple that describes single IP address. Deprecated: This API is deprecated in v1.33+.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeName":
            suggest = "node_name"
        elif key == "targetRef":
            suggest = "target_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointAddressPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointAddressPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointAddressPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hostname: Optional[_builtins.str] = None,
                 ip: Optional[_builtins.str] = None,
                 node_name: Optional[_builtins.str] = None,
                 target_ref: Optional['outputs.ObjectReferencePatch'] = None):
        """
        EndpointAddress is a tuple that describes single IP address. Deprecated: This API is deprecated in v1.33+.
        :param _builtins.str hostname: The Hostname of this endpoint
        :param _builtins.str ip: The IP of this endpoint. May not be loopback (127.0.0.0/8 or ::1), link-local (169.254.0.0/16 or fe80::/10), or link-local multicast (224.0.0.0/24 or ff02::/16).
        :param _builtins.str node_name: Optional: Node hosting this endpoint. This can be used to determine endpoints local to a node.
        :param 'ObjectReferencePatchArgs' target_ref: Reference to object providing the endpoint.
        """
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if node_name is not None:
            pulumi.set(__self__, "node_name", node_name)
        if target_ref is not None:
            pulumi.set(__self__, "target_ref", target_ref)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[_builtins.str]:
        """
        The Hostname of this endpoint
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[_builtins.str]:
        """
        The IP of this endpoint. May not be loopback (127.0.0.0/8 or ::1), link-local (169.254.0.0/16 or fe80::/10), or link-local multicast (224.0.0.0/24 or ff02::/16).
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> Optional[_builtins.str]:
        """
        Optional: Node hosting this endpoint. This can be used to determine endpoints local to a node.
        """
        return pulumi.get(self, "node_name")

    @_builtins.property
    @pulumi.getter(name="targetRef")
    def target_ref(self) -> Optional['outputs.ObjectReferencePatch']:
        """
        Reference to object providing the endpoint.
        """
        return pulumi.get(self, "target_ref")


@pulumi.output_type
class EndpointPort(dict):
    """
    EndpointPort is a tuple that describes a single port. Deprecated: This API is deprecated in v1.33+.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appProtocol":
            suggest = "app_protocol"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointPort. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointPort.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointPort.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: _builtins.int,
                 app_protocol: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 protocol: Optional[_builtins.str] = None):
        """
        EndpointPort is a tuple that describes a single port. Deprecated: This API is deprecated in v1.33+.
        :param _builtins.int port: The port number of the endpoint.
        :param _builtins.str app_protocol: The application protocol for this port. This is used as a hint for implementations to offer richer behavior for protocols that they understand. This field follows standard Kubernetes label syntax. Valid values are either:
               
               * Un-prefixed protocol names - reserved for IANA standard service names (as per RFC-6335 and https://www.iana.org/assignments/service-names).
               
               * Kubernetes-defined prefixed names:
                 * 'kubernetes.io/h2c' - HTTP/2 prior knowledge over cleartext as described in https://www.rfc-editor.org/rfc/rfc9113.html#name-starting-http-2-with-prior-
                 * 'kubernetes.io/ws'  - WebSocket over cleartext as described in https://www.rfc-editor.org/rfc/rfc6455
                 * 'kubernetes.io/wss' - WebSocket over TLS as described in https://www.rfc-editor.org/rfc/rfc6455
               
               * Other protocols should use implementation-defined prefixed names such as mycompany.com/my-custom-protocol.
        :param _builtins.str name: The name of this port.  This must match the 'name' field in the corresponding ServicePort. Must be a DNS_LABEL. Optional only if one port is defined.
        :param _builtins.str protocol: The IP protocol for this port. Must be UDP, TCP, or SCTP. Default is TCP.
        """
        pulumi.set(__self__, "port", port)
        if app_protocol is not None:
            pulumi.set(__self__, "app_protocol", app_protocol)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port number of the endpoint.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="appProtocol")
    def app_protocol(self) -> Optional[_builtins.str]:
        """
        The application protocol for this port. This is used as a hint for implementations to offer richer behavior for protocols that they understand. This field follows standard Kubernetes label syntax. Valid values are either:

        * Un-prefixed protocol names - reserved for IANA standard service names (as per RFC-6335 and https://www.iana.org/assignments/service-names).

        * Kubernetes-defined prefixed names:
          * 'kubernetes.io/h2c' - HTTP/2 prior knowledge over cleartext as described in https://www.rfc-editor.org/rfc/rfc9113.html#name-starting-http-2-with-prior-
          * 'kubernetes.io/ws'  - WebSocket over cleartext as described in https://www.rfc-editor.org/rfc/rfc6455
          * 'kubernetes.io/wss' - WebSocket over TLS as described in https://www.rfc-editor.org/rfc/rfc6455

        * Other protocols should use implementation-defined prefixed names such as mycompany.com/my-custom-protocol.
        """
        return pulumi.get(self, "app_protocol")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of this port.  This must match the 'name' field in the corresponding ServicePort. Must be a DNS_LABEL. Optional only if one port is defined.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        """
        The IP protocol for this port. Must be UDP, TCP, or SCTP. Default is TCP.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class EndpointPortPatch(dict):
    """
    EndpointPort is a tuple that describes a single port. Deprecated: This API is deprecated in v1.33+.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appProtocol":
            suggest = "app_protocol"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointPortPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointPortPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointPortPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_protocol: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 protocol: Optional[_builtins.str] = None):
        """
        EndpointPort is a tuple that describes a single port. Deprecated: This API is deprecated in v1.33+.
        :param _builtins.str app_protocol: The application protocol for this port. This is used as a hint for implementations to offer richer behavior for protocols that they understand. This field follows standard Kubernetes label syntax. Valid values are either:
               
               * Un-prefixed protocol names - reserved for IANA standard service names (as per RFC-6335 and https://www.iana.org/assignments/service-names).
               
               * Kubernetes-defined prefixed names:
                 * 'kubernetes.io/h2c' - HTTP/2 prior knowledge over cleartext as described in https://www.rfc-editor.org/rfc/rfc9113.html#name-starting-http-2-with-prior-
                 * 'kubernetes.io/ws'  - WebSocket over cleartext as described in https://www.rfc-editor.org/rfc/rfc6455
                 * 'kubernetes.io/wss' - WebSocket over TLS as described in https://www.rfc-editor.org/rfc/rfc6455
               
               * Other protocols should use implementation-defined prefixed names such as mycompany.com/my-custom-protocol.
        :param _builtins.str name: The name of this port.  This must match the 'name' field in the corresponding ServicePort. Must be a DNS_LABEL. Optional only if one port is defined.
        :param _builtins.int port: The port number of the endpoint.
        :param _builtins.str protocol: The IP protocol for this port. Must be UDP, TCP, or SCTP. Default is TCP.
        """
        if app_protocol is not None:
            pulumi.set(__self__, "app_protocol", app_protocol)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter(name="appProtocol")
    def app_protocol(self) -> Optional[_builtins.str]:
        """
        The application protocol for this port. This is used as a hint for implementations to offer richer behavior for protocols that they understand. This field follows standard Kubernetes label syntax. Valid values are either:

        * Un-prefixed protocol names - reserved for IANA standard service names (as per RFC-6335 and https://www.iana.org/assignments/service-names).

        * Kubernetes-defined prefixed names:
          * 'kubernetes.io/h2c' - HTTP/2 prior knowledge over cleartext as described in https://www.rfc-editor.org/rfc/rfc9113.html#name-starting-http-2-with-prior-
          * 'kubernetes.io/ws'  - WebSocket over cleartext as described in https://www.rfc-editor.org/rfc/rfc6455
          * 'kubernetes.io/wss' - WebSocket over TLS as described in https://www.rfc-editor.org/rfc/rfc6455

        * Other protocols should use implementation-defined prefixed names such as mycompany.com/my-custom-protocol.
        """
        return pulumi.get(self, "app_protocol")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of this port.  This must match the 'name' field in the corresponding ServicePort. Must be a DNS_LABEL. Optional only if one port is defined.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The port number of the endpoint.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        """
        The IP protocol for this port. Must be UDP, TCP, or SCTP. Default is TCP.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class EndpointSubset(dict):
    """
    EndpointSubset is a group of addresses with a common set of ports. The expanded set of endpoints is the Cartesian product of Addresses x Ports. For example, given:

    	{
    	  Addresses: [{"ip": "10.10.1.1"}, {"ip": "10.10.2.2"}],
    	  Ports:     [{"name": "a", "port": 8675}, {"name": "b", "port": 309}]
    	}

    The resulting set of endpoints can be viewed as:

    	a: [ 10.10.1.1:8675, 10.10.2.2:8675 ],
    	b: [ 10.10.1.1:309, 10.10.2.2:309 ]

    Deprecated: This API is deprecated in v1.33+.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "notReadyAddresses":
            suggest = "not_ready_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointSubset. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointSubset.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointSubset.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 addresses: Optional[Sequence['outputs.EndpointAddress']] = None,
                 not_ready_addresses: Optional[Sequence['outputs.EndpointAddress']] = None,
                 ports: Optional[Sequence['outputs.EndpointPort']] = None):
        """
        EndpointSubset is a group of addresses with a common set of ports. The expanded set of endpoints is the Cartesian product of Addresses x Ports. For example, given:

        	{
        	  Addresses: [{"ip": "10.10.1.1"}, {"ip": "10.10.2.2"}],
        	  Ports:     [{"name": "a", "port": 8675}, {"name": "b", "port": 309}]
        	}

        The resulting set of endpoints can be viewed as:

        	a: [ 10.10.1.1:8675, 10.10.2.2:8675 ],
        	b: [ 10.10.1.1:309, 10.10.2.2:309 ]

        Deprecated: This API is deprecated in v1.33+.
        :param Sequence['EndpointAddressArgs'] addresses: IP addresses which offer the related ports that are marked as ready. These endpoints should be considered safe for load balancers and clients to utilize.
        :param Sequence['EndpointAddressArgs'] not_ready_addresses: IP addresses which offer the related ports but are not currently marked as ready because they have not yet finished starting, have recently failed a readiness check, or have recently failed a liveness check.
        :param Sequence['EndpointPortArgs'] ports: Port numbers available on the related IP addresses.
        """
        if addresses is not None:
            pulumi.set(__self__, "addresses", addresses)
        if not_ready_addresses is not None:
            pulumi.set(__self__, "not_ready_addresses", not_ready_addresses)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)

    @_builtins.property
    @pulumi.getter
    def addresses(self) -> Optional[Sequence['outputs.EndpointAddress']]:
        """
        IP addresses which offer the related ports that are marked as ready. These endpoints should be considered safe for load balancers and clients to utilize.
        """
        return pulumi.get(self, "addresses")

    @_builtins.property
    @pulumi.getter(name="notReadyAddresses")
    def not_ready_addresses(self) -> Optional[Sequence['outputs.EndpointAddress']]:
        """
        IP addresses which offer the related ports but are not currently marked as ready because they have not yet finished starting, have recently failed a readiness check, or have recently failed a liveness check.
        """
        return pulumi.get(self, "not_ready_addresses")

    @_builtins.property
    @pulumi.getter
    def ports(self) -> Optional[Sequence['outputs.EndpointPort']]:
        """
        Port numbers available on the related IP addresses.
        """
        return pulumi.get(self, "ports")


@pulumi.output_type
class EndpointSubsetPatch(dict):
    """
    EndpointSubset is a group of addresses with a common set of ports. The expanded set of endpoints is the Cartesian product of Addresses x Ports. For example, given:

    	{
    	  Addresses: [{"ip": "10.10.1.1"}, {"ip": "10.10.2.2"}],
    	  Ports:     [{"name": "a", "port": 8675}, {"name": "b", "port": 309}]
    	}

    The resulting set of endpoints can be viewed as:

    	a: [ 10.10.1.1:8675, 10.10.2.2:8675 ],
    	b: [ 10.10.1.1:309, 10.10.2.2:309 ]

    Deprecated: This API is deprecated in v1.33+.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "notReadyAddresses":
            suggest = "not_ready_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointSubsetPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointSubsetPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointSubsetPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 addresses: Optional[Sequence['outputs.EndpointAddressPatch']] = None,
                 not_ready_addresses: Optional[Sequence['outputs.EndpointAddressPatch']] = None,
                 ports: Optional[Sequence['outputs.EndpointPortPatch']] = None):
        """
        EndpointSubset is a group of addresses with a common set of ports. The expanded set of endpoints is the Cartesian product of Addresses x Ports. For example, given:

        	{
        	  Addresses: [{"ip": "10.10.1.1"}, {"ip": "10.10.2.2"}],
        	  Ports:     [{"name": "a", "port": 8675}, {"name": "b", "port": 309}]
        	}

        The resulting set of endpoints can be viewed as:

        	a: [ 10.10.1.1:8675, 10.10.2.2:8675 ],
        	b: [ 10.10.1.1:309, 10.10.2.2:309 ]

        Deprecated: This API is deprecated in v1.33+.
        :param Sequence['EndpointAddressPatchArgs'] addresses: IP addresses which offer the related ports that are marked as ready. These endpoints should be considered safe for load balancers and clients to utilize.
        :param Sequence['EndpointAddressPatchArgs'] not_ready_addresses: IP addresses which offer the related ports but are not currently marked as ready because they have not yet finished starting, have recently failed a readiness check, or have recently failed a liveness check.
        :param Sequence['EndpointPortPatchArgs'] ports: Port numbers available on the related IP addresses.
        """
        if addresses is not None:
            pulumi.set(__self__, "addresses", addresses)
        if not_ready_addresses is not None:
            pulumi.set(__self__, "not_ready_addresses", not_ready_addresses)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)

    @_builtins.property
    @pulumi.getter
    def addresses(self) -> Optional[Sequence['outputs.EndpointAddressPatch']]:
        """
        IP addresses which offer the related ports that are marked as ready. These endpoints should be considered safe for load balancers and clients to utilize.
        """
        return pulumi.get(self, "addresses")

    @_builtins.property
    @pulumi.getter(name="notReadyAddresses")
    def not_ready_addresses(self) -> Optional[Sequence['outputs.EndpointAddressPatch']]:
        """
        IP addresses which offer the related ports but are not currently marked as ready because they have not yet finished starting, have recently failed a readiness check, or have recently failed a liveness check.
        """
        return pulumi.get(self, "not_ready_addresses")

    @_builtins.property
    @pulumi.getter
    def ports(self) -> Optional[Sequence['outputs.EndpointPortPatch']]:
        """
        Port numbers available on the related IP addresses.
        """
        return pulumi.get(self, "ports")


@pulumi.output_type
class Endpoints(dict):
    """
    Endpoints is a collection of endpoints that implement the actual service. Example:

    	 Name: "mysvc",
    	 Subsets: [
    	   {
    	     Addresses: [{"ip": "10.10.1.1"}, {"ip": "10.10.2.2"}],
    	     Ports: [{"name": "a", "port": 8675}, {"name": "b", "port": 309}]
    	   },
    	   {
    	     Addresses: [{"ip": "10.10.3.3"}],
    	     Ports: [{"name": "a", "port": 93}, {"name": "b", "port": 76}]
    	   },
    	]

    Endpoints is a legacy API and does not contain information about all Service features. Use discoveryv1.EndpointSlice for complete information about Service endpoints.

    Deprecated: This API is deprecated in v1.33+. Use discoveryv1.EndpointSlice.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Endpoints. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Endpoints.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Endpoints.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[_builtins.str] = None,
                 kind: Optional[_builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 subsets: Optional[Sequence['outputs.EndpointSubset']] = None):
        """
        Endpoints is a collection of endpoints that implement the actual service. Example:

        	 Name: "mysvc",
        	 Subsets: [
        	   {
        	     Addresses: [{"ip": "10.10.1.1"}, {"ip": "10.10.2.2"}],
        	     Ports: [{"name": "a", "port": 8675}, {"name": "b", "port": 309}]
        	   },
        	   {
        	     Addresses: [{"ip": "10.10.3.3"}],
        	     Ports: [{"name": "a", "port": 93}, {"name": "b", "port": 76}]
        	   },
        	]

        Endpoints is a legacy API and does not contain information about all Service features. Use discoveryv1.EndpointSlice for complete information about Service endpoints.

        Deprecated: This API is deprecated in v1.33+. Use discoveryv1.EndpointSlice.
        :param _builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param _builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param Sequence['EndpointSubsetArgs'] subsets: The set of all endpoints is the union of all subsets. Addresses are placed into subsets according to the IPs they share. A single address with multiple ports, some of which are ready and some of which are not (because they come from different containers) will result in the address being displayed in different subsets for the different ports. No address will appear in both Addresses and NotReadyAddresses in the same subset. Sets of addresses and ports that comprise a service.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'Endpoints')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if subsets is not None:
            pulumi.set(__self__, "subsets", subsets)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[_builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[_builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def subsets(self) -> Optional[Sequence['outputs.EndpointSubset']]:
        """
        The set of all endpoints is the union of all subsets. Addresses are placed into subsets according to the IPs they share. A single address with multiple ports, some of which are ready and some of which are not (because they come from different containers) will result in the address being displayed in different subsets for the different ports. No address will appear in both Addresses and NotReadyAddresses in the same subset. Sets of addresses and ports that comprise a service.
        """
        return pulumi.get(self, "subsets")


@pulumi.output_type
class EnvFromSource(dict):
    """
    EnvFromSource represents the source of a set of ConfigMaps or Secrets
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configMapRef":
            suggest = "config_map_ref"
        elif key == "secretRef":
            suggest = "secret_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvFromSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvFromSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvFromSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_map_ref: Optional['outputs.ConfigMapEnvSource'] = None,
                 prefix: Optional[_builtins.str] = None,
                 secret_ref: Optional['outputs.SecretEnvSource'] = None):
        """
        EnvFromSource represents the source of a set of ConfigMaps or Secrets
        :param 'ConfigMapEnvSourceArgs' config_map_ref: The ConfigMap to select from
        :param _builtins.str prefix: Optional text to prepend to the name of each environment variable. Must be a C_IDENTIFIER.
        :param 'SecretEnvSourceArgs' secret_ref: The Secret to select from
        """
        if config_map_ref is not None:
            pulumi.set(__self__, "config_map_ref", config_map_ref)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)

    @_builtins.property
    @pulumi.getter(name="configMapRef")
    def config_map_ref(self) -> Optional['outputs.ConfigMapEnvSource']:
        """
        The ConfigMap to select from
        """
        return pulumi.get(self, "config_map_ref")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> Optional[_builtins.str]:
        """
        Optional text to prepend to the name of each environment variable. Must be a C_IDENTIFIER.
        """
        return pulumi.get(self, "prefix")

    @_builtins.property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional['outputs.SecretEnvSource']:
        """
        The Secret to select from
        """
        return pulumi.get(self, "secret_ref")


@pulumi.output_type
class EnvFromSourcePatch(dict):
    """
    EnvFromSource represents the source of a set of ConfigMaps or Secrets
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configMapRef":
            suggest = "config_map_ref"
        elif key == "secretRef":
            suggest = "secret_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvFromSourcePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvFromSourcePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvFromSourcePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_map_ref: Optional['outputs.ConfigMapEnvSourcePatch'] = None,
                 prefix: Optional[_builtins.str] = None,
                 secret_ref: Optional['outputs.SecretEnvSourcePatch'] = None):
        """
        EnvFromSource represents the source of a set of ConfigMaps or Secrets
        :param 'ConfigMapEnvSourcePatchArgs' config_map_ref: The ConfigMap to select from
        :param _builtins.str prefix: Optional text to prepend to the name of each environment variable. Must be a C_IDENTIFIER.
        :param 'SecretEnvSourcePatchArgs' secret_ref: The Secret to select from
        """
        if config_map_ref is not None:
            pulumi.set(__self__, "config_map_ref", config_map_ref)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)

    @_builtins.property
    @pulumi.getter(name="configMapRef")
    def config_map_ref(self) -> Optional['outputs.ConfigMapEnvSourcePatch']:
        """
        The ConfigMap to select from
        """
        return pulumi.get(self, "config_map_ref")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> Optional[_builtins.str]:
        """
        Optional text to prepend to the name of each environment variable. Must be a C_IDENTIFIER.
        """
        return pulumi.get(self, "prefix")

    @_builtins.property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional['outputs.SecretEnvSourcePatch']:
        """
        The Secret to select from
        """
        return pulumi.get(self, "secret_ref")


@pulumi.output_type
class EnvVar(dict):
    """
    EnvVar represents an environment variable present in a Container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueFrom":
            suggest = "value_from"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvVar. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvVar.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvVar.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 value: Optional[_builtins.str] = None,
                 value_from: Optional['outputs.EnvVarSource'] = None):
        """
        EnvVar represents an environment variable present in a Container.
        :param _builtins.str name: Name of the environment variable. Must be a C_IDENTIFIER.
        :param _builtins.str value: Variable references $(VAR_NAME) are expanded using the previously defined environment variables in the container and any service environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "".
        :param 'EnvVarSourceArgs' value_from: Source for the environment variable's value. Cannot be used if value is not empty.
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_from is not None:
            pulumi.set(__self__, "value_from", value_from)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the environment variable. Must be a C_IDENTIFIER.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        Variable references $(VAR_NAME) are expanded using the previously defined environment variables in the container and any service environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "".
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter(name="valueFrom")
    def value_from(self) -> Optional['outputs.EnvVarSource']:
        """
        Source for the environment variable's value. Cannot be used if value is not empty.
        """
        return pulumi.get(self, "value_from")


@pulumi.output_type
class EnvVarPatch(dict):
    """
    EnvVar represents an environment variable present in a Container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueFrom":
            suggest = "value_from"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvVarPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvVarPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvVarPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None,
                 value_from: Optional['outputs.EnvVarSourcePatch'] = None):
        """
        EnvVar represents an environment variable present in a Container.
        :param _builtins.str name: Name of the environment variable. Must be a C_IDENTIFIER.
        :param _builtins.str value: Variable references $(VAR_NAME) are expanded using the previously defined environment variables in the container and any service environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "".
        :param 'EnvVarSourcePatchArgs' value_from: Source for the environment variable's value. Cannot be used if value is not empty.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_from is not None:
            pulumi.set(__self__, "value_from", value_from)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the environment variable. Must be a C_IDENTIFIER.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        Variable references $(VAR_NAME) are expanded using the previously defined environment variables in the container and any service environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "".
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter(name="valueFrom")
    def value_from(self) -> Optional['outputs.EnvVarSourcePatch']:
        """
        Source for the environment variable's value. Cannot be used if value is not empty.
        """
        return pulumi.get(self, "value_from")


@pulumi.output_type
class EnvVarSource(dict):
    """
    EnvVarSource represents a source for the value of an EnvVar.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configMapKeyRef":
            suggest = "config_map_key_ref"
        elif key == "fieldRef":
            suggest = "field_ref"
        elif key == "resourceFieldRef":
            suggest = "resource_field_ref"
        elif key == "secretKeyRef":
            suggest = "secret_key_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvVarSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvVarSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvVarSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_map_key_ref: Optional['outputs.ConfigMapKeySelector'] = None,
                 field_ref: Optional['outputs.ObjectFieldSelector'] = None,
                 resource_field_ref: Optional['outputs.ResourceFieldSelector'] = None,
                 secret_key_ref: Optional['outputs.SecretKeySelector'] = None):
        """
        EnvVarSource represents a source for the value of an EnvVar.
        :param 'ConfigMapKeySelectorArgs' config_map_key_ref: Selects a key of a ConfigMap.
        :param 'ObjectFieldSelectorArgs' field_ref: Selects a field of the pod: supports metadata.name, metadata.namespace, `metadata.labels['<KEY>']`, `metadata.annotations['<KEY>']`, spec.nodeName, spec.serviceAccountName, status.hostIP, status.podIP, status.podIPs.
        :param 'ResourceFieldSelectorArgs' resource_field_ref: Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, limits.ephemeral-storage, requests.cpu, requests.memory and requests.ephemeral-storage) are currently supported.
        :param 'SecretKeySelectorArgs' secret_key_ref: Selects a key of a secret in the pod's namespace
        """
        if config_map_key_ref is not None:
            pulumi.set(__self__, "config_map_key_ref", config_map_key_ref)
        if field_ref is not None:
            pulumi.set(__self__, "field_ref", field_ref)
        if resource_field_ref is not None:
            pulumi.set(__self__, "resource_field_ref", resource_field_ref)
        if secret_key_ref is not None:
            pulumi.set(__self__, "secret_key_ref", secret_key_ref)

    @_builtins.property
    @pulumi.getter(name="configMapKeyRef")
    def config_map_key_ref(self) -> Optional['outputs.ConfigMapKeySelector']:
        """
        Selects a key of a ConfigMap.
        """
        return pulumi.get(self, "config_map_key_ref")

    @_builtins.property
    @pulumi.getter(name="fieldRef")
    def field_ref(self) -> Optional['outputs.ObjectFieldSelector']:
        """
        Selects a field of the pod: supports metadata.name, metadata.namespace, `metadata.labels['<KEY>']`, `metadata.annotations['<KEY>']`, spec.nodeName, spec.serviceAccountName, status.hostIP, status.podIP, status.podIPs.
        """
        return pulumi.get(self, "field_ref")

    @_builtins.property
    @pulumi.getter(name="resourceFieldRef")
    def resource_field_ref(self) -> Optional['outputs.ResourceFieldSelector']:
        """
        Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, limits.ephemeral-storage, requests.cpu, requests.memory and requests.ephemeral-storage) are currently supported.
        """
        return pulumi.get(self, "resource_field_ref")

    @_builtins.property
    @pulumi.getter(name="secretKeyRef")
    def secret_key_ref(self) -> Optional['outputs.SecretKeySelector']:
        """
        Selects a key of a secret in the pod's namespace
        """
        return pulumi.get(self, "secret_key_ref")


@pulumi.output_type
class EnvVarSourcePatch(dict):
    """
    EnvVarSource represents a source for the value of an EnvVar.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configMapKeyRef":
            suggest = "config_map_key_ref"
        elif key == "fieldRef":
            suggest = "field_ref"
        elif key == "resourceFieldRef":
            suggest = "resource_field_ref"
        elif key == "secretKeyRef":
            suggest = "secret_key_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvVarSourcePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvVarSourcePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvVarSourcePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_map_key_ref: Optional['outputs.ConfigMapKeySelectorPatch'] = None,
                 field_ref: Optional['outputs.ObjectFieldSelectorPatch'] = None,
                 resource_field_ref: Optional['outputs.ResourceFieldSelectorPatch'] = None,
                 secret_key_ref: Optional['outputs.SecretKeySelectorPatch'] = None):
        """
        EnvVarSource represents a source for the value of an EnvVar.
        :param 'ConfigMapKeySelectorPatchArgs' config_map_key_ref: Selects a key of a ConfigMap.
        :param 'ObjectFieldSelectorPatchArgs' field_ref: Selects a field of the pod: supports metadata.name, metadata.namespace, `metadata.labels['<KEY>']`, `metadata.annotations['<KEY>']`, spec.nodeName, spec.serviceAccountName, status.hostIP, status.podIP, status.podIPs.
        :param 'ResourceFieldSelectorPatchArgs' resource_field_ref: Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, limits.ephemeral-storage, requests.cpu, requests.memory and requests.ephemeral-storage) are currently supported.
        :param 'SecretKeySelectorPatchArgs' secret_key_ref: Selects a key of a secret in the pod's namespace
        """
        if config_map_key_ref is not None:
            pulumi.set(__self__, "config_map_key_ref", config_map_key_ref)
        if field_ref is not None:
            pulumi.set(__self__, "field_ref", field_ref)
        if resource_field_ref is not None:
            pulumi.set(__self__, "resource_field_ref", resource_field_ref)
        if secret_key_ref is not None:
            pulumi.set(__self__, "secret_key_ref", secret_key_ref)

    @_builtins.property
    @pulumi.getter(name="configMapKeyRef")
    def config_map_key_ref(self) -> Optional['outputs.ConfigMapKeySelectorPatch']:
        """
        Selects a key of a ConfigMap.
        """
        return pulumi.get(self, "config_map_key_ref")

    @_builtins.property
    @pulumi.getter(name="fieldRef")
    def field_ref(self) -> Optional['outputs.ObjectFieldSelectorPatch']:
        """
        Selects a field of the pod: supports metadata.name, metadata.namespace, `metadata.labels['<KEY>']`, `metadata.annotations['<KEY>']`, spec.nodeName, spec.serviceAccountName, status.hostIP, status.podIP, status.podIPs.
        """
        return pulumi.get(self, "field_ref")

    @_builtins.property
    @pulumi.getter(name="resourceFieldRef")
    def resource_field_ref(self) -> Optional['outputs.ResourceFieldSelectorPatch']:
        """
        Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, limits.ephemeral-storage, requests.cpu, requests.memory and requests.ephemeral-storage) are currently supported.
        """
        return pulumi.get(self, "resource_field_ref")

    @_builtins.property
    @pulumi.getter(name="secretKeyRef")
    def secret_key_ref(self) -> Optional['outputs.SecretKeySelectorPatch']:
        """
        Selects a key of a secret in the pod's namespace
        """
        return pulumi.get(self, "secret_key_ref")


@pulumi.output_type
class EphemeralContainer(dict):
    """
    An EphemeralContainer is a temporary container that you may add to an existing Pod for user-initiated activities such as debugging. Ephemeral containers have no resource or scheduling guarantees, and they will not be restarted when they exit or when a Pod is removed or restarted. The kubelet may evict a Pod if an ephemeral container causes the Pod to exceed its resource allocation.

    To add an ephemeral container, use the ephemeralcontainers subresource of an existing Pod. Ephemeral containers may not be removed or restarted.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "envFrom":
            suggest = "env_from"
        elif key == "imagePullPolicy":
            suggest = "image_pull_policy"
        elif key == "livenessProbe":
            suggest = "liveness_probe"
        elif key == "readinessProbe":
            suggest = "readiness_probe"
        elif key == "resizePolicy":
            suggest = "resize_policy"
        elif key == "restartPolicy":
            suggest = "restart_policy"
        elif key == "securityContext":
            suggest = "security_context"
        elif key == "startupProbe":
            suggest = "startup_probe"
        elif key == "stdinOnce":
            suggest = "stdin_once"
        elif key == "targetContainerName":
            suggest = "target_container_name"
        elif key == "terminationMessagePath":
            suggest = "termination_message_path"
        elif key == "terminationMessagePolicy":
            suggest = "termination_message_policy"
        elif key == "volumeDevices":
            suggest = "volume_devices"
        elif key == "volumeMounts":
            suggest = "volume_mounts"
        elif key == "workingDir":
            suggest = "working_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EphemeralContainer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EphemeralContainer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EphemeralContainer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 args: Optional[Sequence[_builtins.str]] = None,
                 command: Optional[Sequence[_builtins.str]] = None,
                 env: Optional[Sequence['outputs.EnvVar']] = None,
                 env_from: Optional[Sequence['outputs.EnvFromSource']] = None,
                 image: Optional[_builtins.str] = None,
                 image_pull_policy: Optional[_builtins.str] = None,
                 lifecycle: Optional['outputs.Lifecycle'] = None,
                 liveness_probe: Optional['outputs.Probe'] = None,
                 ports: Optional[Sequence['outputs.ContainerPort']] = None,
                 readiness_probe: Optional['outputs.Probe'] = None,
                 resize_policy: Optional[Sequence['outputs.ContainerResizePolicy']] = None,
                 resources: Optional['outputs.ResourceRequirements'] = None,
                 restart_policy: Optional[_builtins.str] = None,
                 security_context: Optional['outputs.SecurityContext'] = None,
                 startup_probe: Optional['outputs.Probe'] = None,
                 stdin: Optional[_builtins.bool] = None,
                 stdin_once: Optional[_builtins.bool] = None,
                 target_container_name: Optional[_builtins.str] = None,
                 termination_message_path: Optional[_builtins.str] = None,
                 termination_message_policy: Optional[_builtins.str] = None,
                 tty: Optional[_builtins.bool] = None,
                 volume_devices: Optional[Sequence['outputs.VolumeDevice']] = None,
                 volume_mounts: Optional[Sequence['outputs.VolumeMount']] = None,
                 working_dir: Optional[_builtins.str] = None):
        """
        An EphemeralContainer is a temporary container that you may add to an existing Pod for user-initiated activities such as debugging. Ephemeral containers have no resource or scheduling guarantees, and they will not be restarted when they exit or when a Pod is removed or restarted. The kubelet may evict a Pod if an ephemeral container causes the Pod to exceed its resource allocation.

        To add an ephemeral container, use the ephemeralcontainers subresource of an existing Pod. Ephemeral containers may not be removed or restarted.
        :param _builtins.str name: Name of the ephemeral container specified as a DNS_LABEL. This name must be unique among all containers, init containers and ephemeral containers.
        :param Sequence[_builtins.str] args: Arguments to the entrypoint. The image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param Sequence[_builtins.str] command: Entrypoint array. Not executed within a shell. The image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param Sequence['EnvVarArgs'] env: List of environment variables to set in the container. Cannot be updated.
        :param Sequence['EnvFromSourceArgs'] env_from: List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.
        :param _builtins.str image: Container image name. More info: https://kubernetes.io/docs/concepts/containers/images
        :param _builtins.str image_pull_policy: Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images
        :param 'LifecycleArgs' lifecycle: Lifecycle is not allowed for ephemeral containers.
        :param 'ProbeArgs' liveness_probe: Probes are not allowed for ephemeral containers.
        :param Sequence['ContainerPortArgs'] ports: Ports are not allowed for ephemeral containers.
        :param 'ProbeArgs' readiness_probe: Probes are not allowed for ephemeral containers.
        :param Sequence['ContainerResizePolicyArgs'] resize_policy: Resources resize policy for the container.
        :param 'ResourceRequirementsArgs' resources: Resources are not allowed for ephemeral containers. Ephemeral containers use spare resources already allocated to the pod.
        :param _builtins.str restart_policy: Restart policy for the container to manage the restart behavior of each container within a pod. This may only be set for init containers. You cannot set this field on ephemeral containers.
        :param 'SecurityContextArgs' security_context: Optional: SecurityContext defines the security options the ephemeral container should be run with. If set, the fields of SecurityContext override the equivalent fields of PodSecurityContext.
        :param 'ProbeArgs' startup_probe: Probes are not allowed for ephemeral containers.
        :param _builtins.bool stdin: Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false.
        :param _builtins.bool stdin_once: Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false
        :param _builtins.str target_container_name: If set, the name of the container from PodSpec that this ephemeral container targets. The ephemeral container will be run in the namespaces (IPC, PID, etc) of this container. If not set then the ephemeral container uses the namespaces configured in the Pod spec.
               
               The container runtime must implement support for this feature. If the runtime does not support namespace targeting then the result of setting this field is undefined.
        :param _builtins.str termination_message_path: Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated.
        :param _builtins.str termination_message_policy: Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.
        :param _builtins.bool tty: Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false.
        :param Sequence['VolumeDeviceArgs'] volume_devices: volumeDevices is the list of block devices to be used by the container.
        :param Sequence['VolumeMountArgs'] volume_mounts: Pod volumes to mount into the container's filesystem. Subpath mounts are not allowed for ephemeral containers. Cannot be updated.
        :param _builtins.str working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.
        """
        pulumi.set(__self__, "name", name)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if env is not None:
            pulumi.set(__self__, "env", env)
        if env_from is not None:
            pulumi.set(__self__, "env_from", env_from)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if image_pull_policy is not None:
            pulumi.set(__self__, "image_pull_policy", image_pull_policy)
        if lifecycle is not None:
            pulumi.set(__self__, "lifecycle", lifecycle)
        if liveness_probe is not None:
            pulumi.set(__self__, "liveness_probe", liveness_probe)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if readiness_probe is not None:
            pulumi.set(__self__, "readiness_probe", readiness_probe)
        if resize_policy is not None:
            pulumi.set(__self__, "resize_policy", resize_policy)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if restart_policy is not None:
            pulumi.set(__self__, "restart_policy", restart_policy)
        if security_context is not None:
            pulumi.set(__self__, "security_context", security_context)
        if startup_probe is not None:
            pulumi.set(__self__, "startup_probe", startup_probe)
        if stdin is not None:
            pulumi.set(__self__, "stdin", stdin)
        if stdin_once is not None:
            pulumi.set(__self__, "stdin_once", stdin_once)
        if target_container_name is not None:
            pulumi.set(__self__, "target_container_name", target_container_name)
        if termination_message_path is not None:
            pulumi.set(__self__, "termination_message_path", termination_message_path)
        if termination_message_policy is not None:
            pulumi.set(__self__, "termination_message_policy", termination_message_policy)
        if tty is not None:
            pulumi.set(__self__, "tty", tty)
        if volume_devices is not None:
            pulumi.set(__self__, "volume_devices", volume_devices)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the ephemeral container specified as a DNS_LABEL. This name must be unique among all containers, init containers and ephemeral containers.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[Sequence[_builtins.str]]:
        """
        Arguments to the entrypoint. The image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter
    def command(self) -> Optional[Sequence[_builtins.str]]:
        """
        Entrypoint array. Not executed within a shell. The image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        """
        return pulumi.get(self, "command")

    @_builtins.property
    @pulumi.getter
    def env(self) -> Optional[Sequence['outputs.EnvVar']]:
        """
        List of environment variables to set in the container. Cannot be updated.
        """
        return pulumi.get(self, "env")

    @_builtins.property
    @pulumi.getter(name="envFrom")
    def env_from(self) -> Optional[Sequence['outputs.EnvFromSource']]:
        """
        List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.
        """
        return pulumi.get(self, "env_from")

    @_builtins.property
    @pulumi.getter
    def image(self) -> Optional[_builtins.str]:
        """
        Container image name. More info: https://kubernetes.io/docs/concepts/containers/images
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter(name="imagePullPolicy")
    def image_pull_policy(self) -> Optional[_builtins.str]:
        """
        Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images
        """
        return pulumi.get(self, "image_pull_policy")

    @_builtins.property
    @pulumi.getter
    def lifecycle(self) -> Optional['outputs.Lifecycle']:
        """
        Lifecycle is not allowed for ephemeral containers.
        """
        return pulumi.get(self, "lifecycle")

    @_builtins.property
    @pulumi.getter(name="livenessProbe")
    def liveness_probe(self) -> Optional['outputs.Probe']:
        """
        Probes are not allowed for ephemeral containers.
        """
        return pulumi.get(self, "liveness_probe")

    @_builtins.property
    @pulumi.getter
    def ports(self) -> Optional[Sequence['outputs.ContainerPort']]:
        """
        Ports are not allowed for ephemeral containers.
        """
        return pulumi.get(self, "ports")

    @_builtins.property
    @pulumi.getter(name="readinessProbe")
    def readiness_probe(self) -> Optional['outputs.Probe']:
        """
        Probes are not allowed for ephemeral containers.
        """
        return pulumi.get(self, "readiness_probe")

    @_builtins.property
    @pulumi.getter(name="resizePolicy")
    def resize_policy(self) -> Optional[Sequence['outputs.ContainerResizePolicy']]:
        """
        Resources resize policy for the container.
        """
        return pulumi.get(self, "resize_policy")

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Optional['outputs.ResourceRequirements']:
        """
        Resources are not allowed for ephemeral containers. Ephemeral containers use spare resources already allocated to the pod.
        """
        return pulumi.get(self, "resources")

    @_builtins.property
    @pulumi.getter(name="restartPolicy")
    def restart_policy(self) -> Optional[_builtins.str]:
        """
        Restart policy for the container to manage the restart behavior of each container within a pod. This may only be set for init containers. You cannot set this field on ephemeral containers.
        """
        return pulumi.get(self, "restart_policy")

    @_builtins.property
    @pulumi.getter(name="securityContext")
    def security_context(self) -> Optional['outputs.SecurityContext']:
        """
        Optional: SecurityContext defines the security options the ephemeral container should be run with. If set, the fields of SecurityContext override the equivalent fields of PodSecurityContext.
        """
        return pulumi.get(self, "security_context")

    @_builtins.property
    @pulumi.getter(name="startupProbe")
    def startup_probe(self) -> Optional['outputs.Probe']:
        """
        Probes are not allowed for ephemeral containers.
        """
        return pulumi.get(self, "startup_probe")

    @_builtins.property
    @pulumi.getter
    def stdin(self) -> Optional[_builtins.bool]:
        """
        Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false.
        """
        return pulumi.get(self, "stdin")

    @_builtins.property
    @pulumi.getter(name="stdinOnce")
    def stdin_once(self) -> Optional[_builtins.bool]:
        """
        Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false
        """
        return pulumi.get(self, "stdin_once")

    @_builtins.property
    @pulumi.getter(name="targetContainerName")
    def target_container_name(self) -> Optional[_builtins.str]:
        """
        If set, the name of the container from PodSpec that this ephemeral container targets. The ephemeral container will be run in the namespaces (IPC, PID, etc) of this container. If not set then the ephemeral container uses the namespaces configured in the Pod spec.

        The container runtime must implement support for this feature. If the runtime does not support namespace targeting then the result of setting this field is undefined.
        """
        return pulumi.get(self, "target_container_name")

    @_builtins.property
    @pulumi.getter(name="terminationMessagePath")
    def termination_message_path(self) -> Optional[_builtins.str]:
        """
        Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated.
        """
        return pulumi.get(self, "termination_message_path")

    @_builtins.property
    @pulumi.getter(name="terminationMessagePolicy")
    def termination_message_policy(self) -> Optional[_builtins.str]:
        """
        Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.
        """
        return pulumi.get(self, "termination_message_policy")

    @_builtins.property
    @pulumi.getter
    def tty(self) -> Optional[_builtins.bool]:
        """
        Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false.
        """
        return pulumi.get(self, "tty")

    @_builtins.property
    @pulumi.getter(name="volumeDevices")
    def volume_devices(self) -> Optional[Sequence['outputs.VolumeDevice']]:
        """
        volumeDevices is the list of block devices to be used by the container.
        """
        return pulumi.get(self, "volume_devices")

    @_builtins.property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[Sequence['outputs.VolumeMount']]:
        """
        Pod volumes to mount into the container's filesystem. Subpath mounts are not allowed for ephemeral containers. Cannot be updated.
        """
        return pulumi.get(self, "volume_mounts")

    @_builtins.property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> Optional[_builtins.str]:
        """
        Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.
        """
        return pulumi.get(self, "working_dir")


@pulumi.output_type
class EphemeralContainerPatch(dict):
    """
    An EphemeralContainer is a temporary container that you may add to an existing Pod for user-initiated activities such as debugging. Ephemeral containers have no resource or scheduling guarantees, and they will not be restarted when they exit or when a Pod is removed or restarted. The kubelet may evict a Pod if an ephemeral container causes the Pod to exceed its resource allocation.

    To add an ephemeral container, use the ephemeralcontainers subresource of an existing Pod. Ephemeral containers may not be removed or restarted.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "envFrom":
            suggest = "env_from"
        elif key == "imagePullPolicy":
            suggest = "image_pull_policy"
        elif key == "livenessProbe":
            suggest = "liveness_probe"
        elif key == "readinessProbe":
            suggest = "readiness_probe"
        elif key == "resizePolicy":
            suggest = "resize_policy"
        elif key == "restartPolicy":
            suggest = "restart_policy"
        elif key == "securityContext":
            suggest = "security_context"
        elif key == "startupProbe":
            suggest = "startup_probe"
        elif key == "stdinOnce":
            suggest = "stdin_once"
        elif key == "targetContainerName":
            suggest = "target_container_name"
        elif key == "terminationMessagePath":
            suggest = "termination_message_path"
        elif key == "terminationMessagePolicy":
            suggest = "termination_message_policy"
        elif key == "volumeDevices":
            suggest = "volume_devices"
        elif key == "volumeMounts":
            suggest = "volume_mounts"
        elif key == "workingDir":
            suggest = "working_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EphemeralContainerPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EphemeralContainerPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EphemeralContainerPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 args: Optional[Sequence[_builtins.str]] = None,
                 command: Optional[Sequence[_builtins.str]] = None,
                 env: Optional[Sequence['outputs.EnvVarPatch']] = None,
                 env_from: Optional[Sequence['outputs.EnvFromSourcePatch']] = None,
                 image: Optional[_builtins.str] = None,
                 image_pull_policy: Optional[_builtins.str] = None,
                 lifecycle: Optional['outputs.LifecyclePatch'] = None,
                 liveness_probe: Optional['outputs.ProbePatch'] = None,
                 name: Optional[_builtins.str] = None,
                 ports: Optional[Sequence['outputs.ContainerPortPatch']] = None,
                 readiness_probe: Optional['outputs.ProbePatch'] = None,
                 resize_policy: Optional[Sequence['outputs.ContainerResizePolicyPatch']] = None,
                 resources: Optional['outputs.ResourceRequirementsPatch'] = None,
                 restart_policy: Optional[_builtins.str] = None,
                 security_context: Optional['outputs.SecurityContextPatch'] = None,
                 startup_probe: Optional['outputs.ProbePatch'] = None,
                 stdin: Optional[_builtins.bool] = None,
                 stdin_once: Optional[_builtins.bool] = None,
                 target_container_name: Optional[_builtins.str] = None,
                 termination_message_path: Optional[_builtins.str] = None,
                 termination_message_policy: Optional[_builtins.str] = None,
                 tty: Optional[_builtins.bool] = None,
                 volume_devices: Optional[Sequence['outputs.VolumeDevicePatch']] = None,
                 volume_mounts: Optional[Sequence['outputs.VolumeMountPatch']] = None,
                 working_dir: Optional[_builtins.str] = None):
        """
        An EphemeralContainer is a temporary container that you may add to an existing Pod for user-initiated activities such as debugging. Ephemeral containers have no resource or scheduling guarantees, and they will not be restarted when they exit or when a Pod is removed or restarted. The kubelet may evict a Pod if an ephemeral container causes the Pod to exceed its resource allocation.

        To add an ephemeral container, use the ephemeralcontainers subresource of an existing Pod. Ephemeral containers may not be removed or restarted.
        :param Sequence[_builtins.str] args: Arguments to the entrypoint. The image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param Sequence[_builtins.str] command: Entrypoint array. Not executed within a shell. The image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param Sequence['EnvVarPatchArgs'] env: List of environment variables to set in the container. Cannot be updated.
        :param Sequence['EnvFromSourcePatchArgs'] env_from: List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.
        :param _builtins.str image: Container image name. More info: https://kubernetes.io/docs/concepts/containers/images
        :param _builtins.str image_pull_policy: Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images
        :param 'LifecyclePatchArgs' lifecycle: Lifecycle is not allowed for ephemeral containers.
        :param 'ProbePatchArgs' liveness_probe: Probes are not allowed for ephemeral containers.
        :param _builtins.str name: Name of the ephemeral container specified as a DNS_LABEL. This name must be unique among all containers, init containers and ephemeral containers.
        :param Sequence['ContainerPortPatchArgs'] ports: Ports are not allowed for ephemeral containers.
        :param 'ProbePatchArgs' readiness_probe: Probes are not allowed for ephemeral containers.
        :param Sequence['ContainerResizePolicyPatchArgs'] resize_policy: Resources resize policy for the container.
        :param 'ResourceRequirementsPatchArgs' resources: Resources are not allowed for ephemeral containers. Ephemeral containers use spare resources already allocated to the pod.
        :param _builtins.str restart_policy: Restart policy for the container to manage the restart behavior of each container within a pod. This may only be set for init containers. You cannot set this field on ephemeral containers.
        :param 'SecurityContextPatchArgs' security_context: Optional: SecurityContext defines the security options the ephemeral container should be run with. If set, the fields of SecurityContext override the equivalent fields of PodSecurityContext.
        :param 'ProbePatchArgs' startup_probe: Probes are not allowed for ephemeral containers.
        :param _builtins.bool stdin: Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false.
        :param _builtins.bool stdin_once: Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false
        :param _builtins.str target_container_name: If set, the name of the container from PodSpec that this ephemeral container targets. The ephemeral container will be run in the namespaces (IPC, PID, etc) of this container. If not set then the ephemeral container uses the namespaces configured in the Pod spec.
               
               The container runtime must implement support for this feature. If the runtime does not support namespace targeting then the result of setting this field is undefined.
        :param _builtins.str termination_message_path: Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated.
        :param _builtins.str termination_message_policy: Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.
        :param _builtins.bool tty: Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false.
        :param Sequence['VolumeDevicePatchArgs'] volume_devices: volumeDevices is the list of block devices to be used by the container.
        :param Sequence['VolumeMountPatchArgs'] volume_mounts: Pod volumes to mount into the container's filesystem. Subpath mounts are not allowed for ephemeral containers. Cannot be updated.
        :param _builtins.str working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.
        """
        if args is not None:
            pulumi.set(__self__, "args", args)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if env is not None:
            pulumi.set(__self__, "env", env)
        if env_from is not None:
            pulumi.set(__self__, "env_from", env_from)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if image_pull_policy is not None:
            pulumi.set(__self__, "image_pull_policy", image_pull_policy)
        if lifecycle is not None:
            pulumi.set(__self__, "lifecycle", lifecycle)
        if liveness_probe is not None:
            pulumi.set(__self__, "liveness_probe", liveness_probe)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if readiness_probe is not None:
            pulumi.set(__self__, "readiness_probe", readiness_probe)
        if resize_policy is not None:
            pulumi.set(__self__, "resize_policy", resize_policy)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if restart_policy is not None:
            pulumi.set(__self__, "restart_policy", restart_policy)
        if security_context is not None:
            pulumi.set(__self__, "security_context", security_context)
        if startup_probe is not None:
            pulumi.set(__self__, "startup_probe", startup_probe)
        if stdin is not None:
            pulumi.set(__self__, "stdin", stdin)
        if stdin_once is not None:
            pulumi.set(__self__, "stdin_once", stdin_once)
        if target_container_name is not None:
            pulumi.set(__self__, "target_container_name", target_container_name)
        if termination_message_path is not None:
            pulumi.set(__self__, "termination_message_path", termination_message_path)
        if termination_message_policy is not None:
            pulumi.set(__self__, "termination_message_policy", termination_message_policy)
        if tty is not None:
            pulumi.set(__self__, "tty", tty)
        if volume_devices is not None:
            pulumi.set(__self__, "volume_devices", volume_devices)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[Sequence[_builtins.str]]:
        """
        Arguments to the entrypoint. The image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter
    def command(self) -> Optional[Sequence[_builtins.str]]:
        """
        Entrypoint array. Not executed within a shell. The image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        """
        return pulumi.get(self, "command")

    @_builtins.property
    @pulumi.getter
    def env(self) -> Optional[Sequence['outputs.EnvVarPatch']]:
        """
        List of environment variables to set in the container. Cannot be updated.
        """
        return pulumi.get(self, "env")

    @_builtins.property
    @pulumi.getter(name="envFrom")
    def env_from(self) -> Optional[Sequence['outputs.EnvFromSourcePatch']]:
        """
        List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.
        """
        return pulumi.get(self, "env_from")

    @_builtins.property
    @pulumi.getter
    def image(self) -> Optional[_builtins.str]:
        """
        Container image name. More info: https://kubernetes.io/docs/concepts/containers/images
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter(name="imagePullPolicy")
    def image_pull_policy(self) -> Optional[_builtins.str]:
        """
        Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images
        """
        return pulumi.get(self, "image_pull_policy")

    @_builtins.property
    @pulumi.getter
    def lifecycle(self) -> Optional['outputs.LifecyclePatch']:
        """
        Lifecycle is not allowed for ephemeral containers.
        """
        return pulumi.get(self, "lifecycle")

    @_builtins.property
    @pulumi.getter(name="livenessProbe")
    def liveness_probe(self) -> Optional['outputs.ProbePatch']:
        """
        Probes are not allowed for ephemeral containers.
        """
        return pulumi.get(self, "liveness_probe")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the ephemeral container specified as a DNS_LABEL. This name must be unique among all containers, init containers and ephemeral containers.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def ports(self) -> Optional[Sequence['outputs.ContainerPortPatch']]:
        """
        Ports are not allowed for ephemeral containers.
        """
        return pulumi.get(self, "ports")

    @_builtins.property
    @pulumi.getter(name="readinessProbe")
    def readiness_probe(self) -> Optional['outputs.ProbePatch']:
        """
        Probes are not allowed for ephemeral containers.
        """
        return pulumi.get(self, "readiness_probe")

    @_builtins.property
    @pulumi.getter(name="resizePolicy")
    def resize_policy(self) -> Optional[Sequence['outputs.ContainerResizePolicyPatch']]:
        """
        Resources resize policy for the container.
        """
        return pulumi.get(self, "resize_policy")

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Optional['outputs.ResourceRequirementsPatch']:
        """
        Resources are not allowed for ephemeral containers. Ephemeral containers use spare resources already allocated to the pod.
        """
        return pulumi.get(self, "resources")

    @_builtins.property
    @pulumi.getter(name="restartPolicy")
    def restart_policy(self) -> Optional[_builtins.str]:
        """
        Restart policy for the container to manage the restart behavior of each container within a pod. This may only be set for init containers. You cannot set this field on ephemeral containers.
        """
        return pulumi.get(self, "restart_policy")

    @_builtins.property
    @pulumi.getter(name="securityContext")
    def security_context(self) -> Optional['outputs.SecurityContextPatch']:
        """
        Optional: SecurityContext defines the security options the ephemeral container should be run with. If set, the fields of SecurityContext override the equivalent fields of PodSecurityContext.
        """
        return pulumi.get(self, "security_context")

    @_builtins.property
    @pulumi.getter(name="startupProbe")
    def startup_probe(self) -> Optional['outputs.ProbePatch']:
        """
        Probes are not allowed for ephemeral containers.
        """
        return pulumi.get(self, "startup_probe")

    @_builtins.property
    @pulumi.getter
    def stdin(self) -> Optional[_builtins.bool]:
        """
        Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false.
        """
        return pulumi.get(self, "stdin")

    @_builtins.property
    @pulumi.getter(name="stdinOnce")
    def stdin_once(self) -> Optional[_builtins.bool]:
        """
        Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false
        """
        return pulumi.get(self, "stdin_once")

    @_builtins.property
    @pulumi.getter(name="targetContainerName")
    def target_container_name(self) -> Optional[_builtins.str]:
        """
        If set, the name of the container from PodSpec that this ephemeral container targets. The ephemeral container will be run in the namespaces (IPC, PID, etc) of this container. If not set then the ephemeral container uses the namespaces configured in the Pod spec.

        The container runtime must implement support for this feature. If the runtime does not support namespace targeting then the result of setting this field is undefined.
        """
        return pulumi.get(self, "target_container_name")

    @_builtins.property
    @pulumi.getter(name="terminationMessagePath")
    def termination_message_path(self) -> Optional[_builtins.str]:
        """
        Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated.
        """
        return pulumi.get(self, "termination_message_path")

    @_builtins.property
    @pulumi.getter(name="terminationMessagePolicy")
    def termination_message_policy(self) -> Optional[_builtins.str]:
        """
        Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.
        """
        return pulumi.get(self, "termination_message_policy")

    @_builtins.property
    @pulumi.getter
    def tty(self) -> Optional[_builtins.bool]:
        """
        Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false.
        """
        return pulumi.get(self, "tty")

    @_builtins.property
    @pulumi.getter(name="volumeDevices")
    def volume_devices(self) -> Optional[Sequence['outputs.VolumeDevicePatch']]:
        """
        volumeDevices is the list of block devices to be used by the container.
        """
        return pulumi.get(self, "volume_devices")

    @_builtins.property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[Sequence['outputs.VolumeMountPatch']]:
        """
        Pod volumes to mount into the container's filesystem. Subpath mounts are not allowed for ephemeral containers. Cannot be updated.
        """
        return pulumi.get(self, "volume_mounts")

    @_builtins.property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> Optional[_builtins.str]:
        """
        Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.
        """
        return pulumi.get(self, "working_dir")


@pulumi.output_type
class EphemeralVolumeSource(dict):
    """
    Represents an ephemeral volume that is handled by a normal storage driver.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "readOnly":
            suggest = "read_only"
        elif key == "volumeClaimTemplate":
            suggest = "volume_claim_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EphemeralVolumeSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EphemeralVolumeSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EphemeralVolumeSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 read_only: Optional[_builtins.bool] = None,
                 volume_claim_template: Optional['outputs.PersistentVolumeClaimTemplate'] = None):
        """
        Represents an ephemeral volume that is handled by a normal storage driver.
        :param _builtins.bool read_only: Specifies a read-only configuration for the volume. Defaults to false (read/write).
        :param 'PersistentVolumeClaimTemplateArgs' volume_claim_template: Will be used to create a stand-alone PVC to provision the volume. The pod in which this EphemeralVolumeSource is embedded will be the owner of the PVC, i.e. the PVC will be deleted together with the pod.  The name of the PVC will be `<pod name>-<volume name>` where `<volume name>` is the name from the `PodSpec.Volumes` array entry. Pod validation will reject the pod if the concatenated name is not valid for a PVC (for example, too long).
               
               An existing PVC with that name that is not owned by the pod will *not* be used for the pod to avoid using an unrelated volume by mistake. Starting the pod is then blocked until the unrelated PVC is removed. If such a pre-created PVC is meant to be used by the pod, the PVC has to updated with an owner reference to the pod once the pod exists. Normally this should not be necessary, but it may be useful when manually reconstructing a broken cluster.
               
               This field is read-only and no changes will be made by Kubernetes to the PVC after it has been created.
               
               Required, must not be nil.
        """
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if volume_claim_template is not None:
            pulumi.set(__self__, "volume_claim_template", volume_claim_template)

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        Specifies a read-only configuration for the volume. Defaults to false (read/write).
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter(name="volumeClaimTemplate")
    def volume_claim_template(self) -> Optional['outputs.PersistentVolumeClaimTemplate']:
        """
        Will be used to create a stand-alone PVC to provision the volume. The pod in which this EphemeralVolumeSource is embedded will be the owner of the PVC, i.e. the PVC will be deleted together with the pod.  The name of the PVC will be `<pod name>-<volume name>` where `<volume name>` is the name from the `PodSpec.Volumes` array entry. Pod validation will reject the pod if the concatenated name is not valid for a PVC (for example, too long).

        An existing PVC with that name that is not owned by the pod will *not* be used for the pod to avoid using an unrelated volume by mistake. Starting the pod is then blocked until the unrelated PVC is removed. If such a pre-created PVC is meant to be used by the pod, the PVC has to updated with an owner reference to the pod once the pod exists. Normally this should not be necessary, but it may be useful when manually reconstructing a broken cluster.

        This field is read-only and no changes will be made by Kubernetes to the PVC after it has been created.

        Required, must not be nil.
        """
        return pulumi.get(self, "volume_claim_template")


@pulumi.output_type
class EphemeralVolumeSourcePatch(dict):
    """
    Represents an ephemeral volume that is handled by a normal storage driver.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "readOnly":
            suggest = "read_only"
        elif key == "volumeClaimTemplate":
            suggest = "volume_claim_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EphemeralVolumeSourcePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EphemeralVolumeSourcePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EphemeralVolumeSourcePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 read_only: Optional[_builtins.bool] = None,
                 volume_claim_template: Optional['outputs.PersistentVolumeClaimTemplatePatch'] = None):
        """
        Represents an ephemeral volume that is handled by a normal storage driver.
        :param _builtins.bool read_only: Specifies a read-only configuration for the volume. Defaults to false (read/write).
        :param 'PersistentVolumeClaimTemplatePatchArgs' volume_claim_template: Will be used to create a stand-alone PVC to provision the volume. The pod in which this EphemeralVolumeSource is embedded will be the owner of the PVC, i.e. the PVC will be deleted together with the pod.  The name of the PVC will be `<pod name>-<volume name>` where `<volume name>` is the name from the `PodSpec.Volumes` array entry. Pod validation will reject the pod if the concatenated name is not valid for a PVC (for example, too long).
               
               An existing PVC with that name that is not owned by the pod will *not* be used for the pod to avoid using an unrelated volume by mistake. Starting the pod is then blocked until the unrelated PVC is removed. If such a pre-created PVC is meant to be used by the pod, the PVC has to updated with an owner reference to the pod once the pod exists. Normally this should not be necessary, but it may be useful when manually reconstructing a broken cluster.
               
               This field is read-only and no changes will be made by Kubernetes to the PVC after it has been created.
               
               Required, must not be nil.
        """
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if volume_claim_template is not None:
            pulumi.set(__self__, "volume_claim_template", volume_claim_template)

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        Specifies a read-only configuration for the volume. Defaults to false (read/write).
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter(name="volumeClaimTemplate")
    def volume_claim_template(self) -> Optional['outputs.PersistentVolumeClaimTemplatePatch']:
        """
        Will be used to create a stand-alone PVC to provision the volume. The pod in which this EphemeralVolumeSource is embedded will be the owner of the PVC, i.e. the PVC will be deleted together with the pod.  The name of the PVC will be `<pod name>-<volume name>` where `<volume name>` is the name from the `PodSpec.Volumes` array entry. Pod validation will reject the pod if the concatenated name is not valid for a PVC (for example, too long).

        An existing PVC with that name that is not owned by the pod will *not* be used for the pod to avoid using an unrelated volume by mistake. Starting the pod is then blocked until the unrelated PVC is removed. If such a pre-created PVC is meant to be used by the pod, the PVC has to updated with an owner reference to the pod once the pod exists. Normally this should not be necessary, but it may be useful when manually reconstructing a broken cluster.

        This field is read-only and no changes will be made by Kubernetes to the PVC after it has been created.

        Required, must not be nil.
        """
        return pulumi.get(self, "volume_claim_template")


@pulumi.output_type
class Event(dict):
    """
    Event is a report of an event somewhere in the cluster.  Events have a limited retention time and triggers and messages may evolve with time.  Event consumers should not rely on the timing of an event with a given Reason reflecting a consistent underlying trigger, or the continued existence of events with that Reason.  Events should be treated as informative, best-effort, supplemental data.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "involvedObject":
            suggest = "involved_object"
        elif key == "apiVersion":
            suggest = "api_version"
        elif key == "eventTime":
            suggest = "event_time"
        elif key == "firstTimestamp":
            suggest = "first_timestamp"
        elif key == "lastTimestamp":
            suggest = "last_timestamp"
        elif key == "reportingComponent":
            suggest = "reporting_component"
        elif key == "reportingInstance":
            suggest = "reporting_instance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Event. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Event.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Event.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 involved_object: 'outputs.ObjectReference',
                 metadata: '_meta.v1.outputs.ObjectMeta',
                 action: Optional[_builtins.str] = None,
                 api_version: Optional[_builtins.str] = None,
                 count: Optional[_builtins.int] = None,
                 event_time: Optional[_builtins.str] = None,
                 first_timestamp: Optional[_builtins.str] = None,
                 kind: Optional[_builtins.str] = None,
                 last_timestamp: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None,
                 related: Optional['outputs.ObjectReference'] = None,
                 reporting_component: Optional[_builtins.str] = None,
                 reporting_instance: Optional[_builtins.str] = None,
                 series: Optional['outputs.EventSeries'] = None,
                 source: Optional['outputs.EventSource'] = None,
                 type: Optional[_builtins.str] = None):
        """
        Event is a report of an event somewhere in the cluster.  Events have a limited retention time and triggers and messages may evolve with time.  Event consumers should not rely on the timing of an event with a given Reason reflecting a consistent underlying trigger, or the continued existence of events with that Reason.  Events should be treated as informative, best-effort, supplemental data.
        :param 'ObjectReferenceArgs' involved_object: The object that this event is about.
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param _builtins.str action: What action was taken/failed regarding to the Regarding object.
        :param _builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param _builtins.int count: The number of times this event has occurred.
        :param _builtins.str event_time: Time when this Event was first observed.
        :param _builtins.str first_timestamp: The time at which the event was first recorded. (Time of server receipt is in TypeMeta.)
        :param _builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param _builtins.str last_timestamp: The time at which the most recent occurrence of this event was recorded.
        :param _builtins.str message: A human-readable description of the status of this operation.
        :param _builtins.str reason: This should be a short, machine understandable string that gives the reason for the transition into the object's current status.
        :param 'ObjectReferenceArgs' related: Optional secondary object for more complex actions.
        :param _builtins.str reporting_component: Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`.
        :param _builtins.str reporting_instance: ID of the controller instance, e.g. `kubelet-xyzf`.
        :param 'EventSeriesArgs' series: Data about the Event series this event represents or nil if it's a singleton Event.
        :param 'EventSourceArgs' source: The component reporting this event. Should be a short machine understandable string.
        :param _builtins.str type: Type of this event (Normal, Warning), new types could be added in the future
        """
        pulumi.set(__self__, "involved_object", involved_object)
        pulumi.set(__self__, "metadata", metadata)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'v1')
        if count is not None:
            pulumi.set(__self__, "count", count)
        if event_time is not None:
            pulumi.set(__self__, "event_time", event_time)
        if first_timestamp is not None:
            pulumi.set(__self__, "first_timestamp", first_timestamp)
        if kind is not None:
            pulumi.set(__self__, "kind", 'Event')
        if last_timestamp is not None:
            pulumi.set(__self__, "last_timestamp", last_timestamp)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if related is not None:
            pulumi.set(__self__, "related", related)
        if reporting_component is not None:
            pulumi.set(__self__, "reporting_component", reporting_component)
        if reporting_instance is not None:
            pulumi.set(__self__, "reporting_instance", reporting_instance)
        if series is not None:
            pulumi.set(__self__, "series", series)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="involvedObject")
    def involved_object(self) -> 'outputs.ObjectReference':
        """
        The object that this event is about.
        """
        return pulumi.get(self, "involved_object")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> '_meta.v1.outputs.ObjectMeta':
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[_builtins.str]:
        """
        What action was taken/failed regarding to the Regarding object.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[_builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def count(self) -> Optional[_builtins.int]:
        """
        The number of times this event has occurred.
        """
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter(name="eventTime")
    def event_time(self) -> Optional[_builtins.str]:
        """
        Time when this Event was first observed.
        """
        return pulumi.get(self, "event_time")

    @_builtins.property
    @pulumi.getter(name="firstTimestamp")
    def first_timestamp(self) -> Optional[_builtins.str]:
        """
        The time at which the event was first recorded. (Time of server receipt is in TypeMeta.)
        """
        return pulumi.get(self, "first_timestamp")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[_builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter(name="lastTimestamp")
    def last_timestamp(self) -> Optional[_builtins.str]:
        """
        The time at which the most recent occurrence of this event was recorded.
        """
        return pulumi.get(self, "last_timestamp")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        A human-readable description of the status of this operation.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        This should be a short, machine understandable string that gives the reason for the transition into the object's current status.
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter
    def related(self) -> Optional['outputs.ObjectReference']:
        """
        Optional secondary object for more complex actions.
        """
        return pulumi.get(self, "related")

    @_builtins.property
    @pulumi.getter(name="reportingComponent")
    def reporting_component(self) -> Optional[_builtins.str]:
        """
        Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`.
        """
        return pulumi.get(self, "reporting_component")

    @_builtins.property
    @pulumi.getter(name="reportingInstance")
    def reporting_instance(self) -> Optional[_builtins.str]:
        """
        ID of the controller instance, e.g. `kubelet-xyzf`.
        """
        return pulumi.get(self, "reporting_instance")

    @_builtins.property
    @pulumi.getter
    def series(self) -> Optional['outputs.EventSeries']:
        """
        Data about the Event series this event represents or nil if it's a singleton Event.
        """
        return pulumi.get(self, "series")

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional['outputs.EventSource']:
        """
        The component reporting this event. Should be a short machine understandable string.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of this event (Normal, Warning), new types could be added in the future
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class EventSeries(dict):
    """
    EventSeries contain information on series of events, i.e. thing that was/is happening continuously for some time.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastObservedTime":
            suggest = "last_observed_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSeries. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSeries.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSeries.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: Optional[_builtins.int] = None,
                 last_observed_time: Optional[_builtins.str] = None,
                 state: Optional[_builtins.str] = None):
        """
        EventSeries contain information on series of events, i.e. thing that was/is happening continuously for some time.
        :param _builtins.int count: Number of occurrences in this series up to the last heartbeat time
        :param _builtins.str last_observed_time: Time of the last occurrence observed
        :param _builtins.str state: State of this Series: Ongoing or Finished Deprecated. Planned removal for 1.18
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if last_observed_time is not None:
            pulumi.set(__self__, "last_observed_time", last_observed_time)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def count(self) -> Optional[_builtins.int]:
        """
        Number of occurrences in this series up to the last heartbeat time
        """
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter(name="lastObservedTime")
    def last_observed_time(self) -> Optional[_builtins.str]:
        """
        Time of the last occurrence observed
        """
        return pulumi.get(self, "last_observed_time")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        State of this Series: Ongoing or Finished Deprecated. Planned removal for 1.18
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class EventSeriesPatch(dict):
    """
    EventSeries contain information on series of events, i.e. thing that was/is happening continuously for some time.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastObservedTime":
            suggest = "last_observed_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventSeriesPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventSeriesPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventSeriesPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: Optional[_builtins.int] = None,
                 last_observed_time: Optional[_builtins.str] = None,
                 state: Optional[_builtins.str] = None):
        """
        EventSeries contain information on series of events, i.e. thing that was/is happening continuously for some time.
        :param _builtins.int count: Number of occurrences in this series up to the last heartbeat time
        :param _builtins.str last_observed_time: Time of the last occurrence observed
        :param _builtins.str state: State of this Series: Ongoing or Finished Deprecated. Planned removal for 1.18
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if last_observed_time is not None:
            pulumi.set(__self__, "last_observed_time", last_observed_time)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def count(self) -> Optional[_builtins.int]:
        """
        Number of occurrences in this series up to the last heartbeat time
        """
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter(name="lastObservedTime")
    def last_observed_time(self) -> Optional[_builtins.str]:
        """
        Time of the last occurrence observed
        """
        return pulumi.get(self, "last_observed_time")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        State of this Series: Ongoing or Finished Deprecated. Planned removal for 1.18
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class EventSource(dict):
    """
    EventSource contains information for an event.
    """
    def __init__(__self__, *,
                 component: Optional[_builtins.str] = None,
                 host: Optional[_builtins.str] = None):
        """
        EventSource contains information for an event.
        :param _builtins.str component: Component from which the event is generated.
        :param _builtins.str host: Node name on which the event is generated.
        """
        if component is not None:
            pulumi.set(__self__, "component", component)
        if host is not None:
            pulumi.set(__self__, "host", host)

    @_builtins.property
    @pulumi.getter
    def component(self) -> Optional[_builtins.str]:
        """
        Component from which the event is generated.
        """
        return pulumi.get(self, "component")

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[_builtins.str]:
        """
        Node name on which the event is generated.
        """
        return pulumi.get(self, "host")


@pulumi.output_type
class EventSourcePatch(dict):
    """
    EventSource contains information for an event.
    """
    def __init__(__self__, *,
                 component: Optional[_builtins.str] = None,
                 host: Optional[_builtins.str] = None):
        """
        EventSource contains information for an event.
        :param _builtins.str component: Component from which the event is generated.
        :param _builtins.str host: Node name on which the event is generated.
        """
        if component is not None:
            pulumi.set(__self__, "component", component)
        if host is not None:
            pulumi.set(__self__, "host", host)

    @_builtins.property
    @pulumi.getter
    def component(self) -> Optional[_builtins.str]:
        """
        Component from which the event is generated.
        """
        return pulumi.get(self, "component")

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[_builtins.str]:
        """
        Node name on which the event is generated.
        """
        return pulumi.get(self, "host")


@pulumi.output_type
class ExecAction(dict):
    """
    ExecAction describes a "run in container" action.
    """
    def __init__(__self__, *,
                 command: Optional[Sequence[_builtins.str]] = None):
        """
        ExecAction describes a "run in container" action.
        :param Sequence[_builtins.str] command: Command is the command line to execute inside the container, the working directory for the command  is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
        """
        if command is not None:
            pulumi.set(__self__, "command", command)

    @_builtins.property
    @pulumi.getter
    def command(self) -> Optional[Sequence[_builtins.str]]:
        """
        Command is the command line to execute inside the container, the working directory for the command  is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
        """
        return pulumi.get(self, "command")


@pulumi.output_type
class ExecActionPatch(dict):
    """
    ExecAction describes a "run in container" action.
    """
    def __init__(__self__, *,
                 command: Optional[Sequence[_builtins.str]] = None):
        """
        ExecAction describes a "run in container" action.
        :param Sequence[_builtins.str] command: Command is the command line to execute inside the container, the working directory for the command  is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
        """
        if command is not None:
            pulumi.set(__self__, "command", command)

    @_builtins.property
    @pulumi.getter
    def command(self) -> Optional[Sequence[_builtins.str]]:
        """
        Command is the command line to execute inside the container, the working directory for the command  is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
        """
        return pulumi.get(self, "command")


@pulumi.output_type
class FCVolumeSource(dict):
    """
    Represents a Fibre Channel volume. Fibre Channel volumes can only be mounted as read/write once. Fibre Channel volumes support ownership management and SELinux relabeling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fsType":
            suggest = "fs_type"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "targetWWNs":
            suggest = "target_wwns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FCVolumeSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FCVolumeSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FCVolumeSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fs_type: Optional[_builtins.str] = None,
                 lun: Optional[_builtins.int] = None,
                 read_only: Optional[_builtins.bool] = None,
                 target_wwns: Optional[Sequence[_builtins.str]] = None,
                 wwids: Optional[Sequence[_builtins.str]] = None):
        """
        Represents a Fibre Channel volume. Fibre Channel volumes can only be mounted as read/write once. Fibre Channel volumes support ownership management and SELinux relabeling.
        :param _builtins.str fs_type: fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
        :param _builtins.int lun: lun is Optional: FC target lun number
        :param _builtins.bool read_only: readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        :param Sequence[_builtins.str] target_wwns: targetWWNs is Optional: FC target worldwide names (WWNs)
        :param Sequence[_builtins.str] wwids: wwids Optional: FC volume world wide identifiers (wwids) Either wwids or combination of targetWWNs and lun must be set, but not both simultaneously.
        """
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if lun is not None:
            pulumi.set(__self__, "lun", lun)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if target_wwns is not None:
            pulumi.set(__self__, "target_wwns", target_wwns)
        if wwids is not None:
            pulumi.set(__self__, "wwids", wwids)

    @_builtins.property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[_builtins.str]:
        """
        fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
        """
        return pulumi.get(self, "fs_type")

    @_builtins.property
    @pulumi.getter
    def lun(self) -> Optional[_builtins.int]:
        """
        lun is Optional: FC target lun number
        """
        return pulumi.get(self, "lun")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter(name="targetWWNs")
    def target_wwns(self) -> Optional[Sequence[_builtins.str]]:
        """
        targetWWNs is Optional: FC target worldwide names (WWNs)
        """
        return pulumi.get(self, "target_wwns")

    @_builtins.property
    @pulumi.getter
    def wwids(self) -> Optional[Sequence[_builtins.str]]:
        """
        wwids Optional: FC volume world wide identifiers (wwids) Either wwids or combination of targetWWNs and lun must be set, but not both simultaneously.
        """
        return pulumi.get(self, "wwids")


@pulumi.output_type
class FCVolumeSourcePatch(dict):
    """
    Represents a Fibre Channel volume. Fibre Channel volumes can only be mounted as read/write once. Fibre Channel volumes support ownership management and SELinux relabeling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fsType":
            suggest = "fs_type"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "targetWWNs":
            suggest = "target_wwns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FCVolumeSourcePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FCVolumeSourcePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FCVolumeSourcePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fs_type: Optional[_builtins.str] = None,
                 lun: Optional[_builtins.int] = None,
                 read_only: Optional[_builtins.bool] = None,
                 target_wwns: Optional[Sequence[_builtins.str]] = None,
                 wwids: Optional[Sequence[_builtins.str]] = None):
        """
        Represents a Fibre Channel volume. Fibre Channel volumes can only be mounted as read/write once. Fibre Channel volumes support ownership management and SELinux relabeling.
        :param _builtins.str fs_type: fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
        :param _builtins.int lun: lun is Optional: FC target lun number
        :param _builtins.bool read_only: readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        :param Sequence[_builtins.str] target_wwns: targetWWNs is Optional: FC target worldwide names (WWNs)
        :param Sequence[_builtins.str] wwids: wwids Optional: FC volume world wide identifiers (wwids) Either wwids or combination of targetWWNs and lun must be set, but not both simultaneously.
        """
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if lun is not None:
            pulumi.set(__self__, "lun", lun)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if target_wwns is not None:
            pulumi.set(__self__, "target_wwns", target_wwns)
        if wwids is not None:
            pulumi.set(__self__, "wwids", wwids)

    @_builtins.property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[_builtins.str]:
        """
        fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
        """
        return pulumi.get(self, "fs_type")

    @_builtins.property
    @pulumi.getter
    def lun(self) -> Optional[_builtins.int]:
        """
        lun is Optional: FC target lun number
        """
        return pulumi.get(self, "lun")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        readOnly is Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter(name="targetWWNs")
    def target_wwns(self) -> Optional[Sequence[_builtins.str]]:
        """
        targetWWNs is Optional: FC target worldwide names (WWNs)
        """
        return pulumi.get(self, "target_wwns")

    @_builtins.property
    @pulumi.getter
    def wwids(self) -> Optional[Sequence[_builtins.str]]:
        """
        wwids Optional: FC volume world wide identifiers (wwids) Either wwids or combination of targetWWNs and lun must be set, but not both simultaneously.
        """
        return pulumi.get(self, "wwids")


@pulumi.output_type
class FlexPersistentVolumeSource(dict):
    """
    FlexPersistentVolumeSource represents a generic persistent volume resource that is provisioned/attached using an exec based plugin.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fsType":
            suggest = "fs_type"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "secretRef":
            suggest = "secret_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlexPersistentVolumeSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlexPersistentVolumeSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlexPersistentVolumeSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 driver: _builtins.str,
                 fs_type: Optional[_builtins.str] = None,
                 options: Optional[Mapping[str, _builtins.str]] = None,
                 read_only: Optional[_builtins.bool] = None,
                 secret_ref: Optional['outputs.SecretReference'] = None):
        """
        FlexPersistentVolumeSource represents a generic persistent volume resource that is provisioned/attached using an exec based plugin.
        :param _builtins.str driver: driver is the name of the driver to use for this volume.
        :param _builtins.str fs_type: fsType is the Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.
        :param Mapping[str, _builtins.str] options: options is Optional: this field holds extra command options if any.
        :param _builtins.bool read_only: readOnly is Optional: defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        :param 'SecretReferenceArgs' secret_ref: secretRef is Optional: SecretRef is reference to the secret object containing sensitive information to pass to the plugin scripts. This may be empty if no secret object is specified. If the secret object contains more than one secret, all secrets are passed to the plugin scripts.
        """
        pulumi.set(__self__, "driver", driver)
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)

    @_builtins.property
    @pulumi.getter
    def driver(self) -> _builtins.str:
        """
        driver is the name of the driver to use for this volume.
        """
        return pulumi.get(self, "driver")

    @_builtins.property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[_builtins.str]:
        """
        fsType is the Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.
        """
        return pulumi.get(self, "fs_type")

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        options is Optional: this field holds extra command options if any.
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        readOnly is Optional: defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional['outputs.SecretReference']:
        """
        secretRef is Optional: SecretRef is reference to the secret object containing sensitive information to pass to the plugin scripts. This may be empty if no secret object is specified. If the secret object contains more than one secret, all secrets are passed to the plugin scripts.
        """
        return pulumi.get(self, "secret_ref")


@pulumi.output_type
class FlexPersistentVolumeSourcePatch(dict):
    """
    FlexPersistentVolumeSource represents a generic persistent volume resource that is provisioned/attached using an exec based plugin.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fsType":
            suggest = "fs_type"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "secretRef":
            suggest = "secret_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlexPersistentVolumeSourcePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlexPersistentVolumeSourcePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlexPersistentVolumeSourcePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 driver: Optional[_builtins.str] = None,
                 fs_type: Optional[_builtins.str] = None,
                 options: Optional[Mapping[str, _builtins.str]] = None,
                 read_only: Optional[_builtins.bool] = None,
                 secret_ref: Optional['outputs.SecretReferencePatch'] = None):
        """
        FlexPersistentVolumeSource represents a generic persistent volume resource that is provisioned/attached using an exec based plugin.
        :param _builtins.str driver: driver is the name of the driver to use for this volume.
        :param _builtins.str fs_type: fsType is the Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.
        :param Mapping[str, _builtins.str] options: options is Optional: this field holds extra command options if any.
        :param _builtins.bool read_only: readOnly is Optional: defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        :param 'SecretReferencePatchArgs' secret_ref: secretRef is Optional: SecretRef is reference to the secret object containing sensitive information to pass to the plugin scripts. This may be empty if no secret object is specified. If the secret object contains more than one secret, all secrets are passed to the plugin scripts.
        """
        if driver is not None:
            pulumi.set(__self__, "driver", driver)
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)

    @_builtins.property
    @pulumi.getter
    def driver(self) -> Optional[_builtins.str]:
        """
        driver is the name of the driver to use for this volume.
        """
        return pulumi.get(self, "driver")

    @_builtins.property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[_builtins.str]:
        """
        fsType is the Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.
        """
        return pulumi.get(self, "fs_type")

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        options is Optional: this field holds extra command options if any.
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        readOnly is Optional: defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional['outputs.SecretReferencePatch']:
        """
        secretRef is Optional: SecretRef is reference to the secret object containing sensitive information to pass to the plugin scripts. This may be empty if no secret object is specified. If the secret object contains more than one secret, all secrets are passed to the plugin scripts.
        """
        return pulumi.get(self, "secret_ref")


@pulumi.output_type
class FlexVolumeSource(dict):
    """
    FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fsType":
            suggest = "fs_type"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "secretRef":
            suggest = "secret_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlexVolumeSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlexVolumeSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlexVolumeSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 driver: _builtins.str,
                 fs_type: Optional[_builtins.str] = None,
                 options: Optional[Mapping[str, _builtins.str]] = None,
                 read_only: Optional[_builtins.bool] = None,
                 secret_ref: Optional['outputs.LocalObjectReference'] = None):
        """
        FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin.
        :param _builtins.str driver: driver is the name of the driver to use for this volume.
        :param _builtins.str fs_type: fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.
        :param Mapping[str, _builtins.str] options: options is Optional: this field holds extra command options if any.
        :param _builtins.bool read_only: readOnly is Optional: defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        :param 'LocalObjectReferenceArgs' secret_ref: secretRef is Optional: secretRef is reference to the secret object containing sensitive information to pass to the plugin scripts. This may be empty if no secret object is specified. If the secret object contains more than one secret, all secrets are passed to the plugin scripts.
        """
        pulumi.set(__self__, "driver", driver)
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)

    @_builtins.property
    @pulumi.getter
    def driver(self) -> _builtins.str:
        """
        driver is the name of the driver to use for this volume.
        """
        return pulumi.get(self, "driver")

    @_builtins.property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[_builtins.str]:
        """
        fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.
        """
        return pulumi.get(self, "fs_type")

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        options is Optional: this field holds extra command options if any.
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        readOnly is Optional: defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional['outputs.LocalObjectReference']:
        """
        secretRef is Optional: secretRef is reference to the secret object containing sensitive information to pass to the plugin scripts. This may be empty if no secret object is specified. If the secret object contains more than one secret, all secrets are passed to the plugin scripts.
        """
        return pulumi.get(self, "secret_ref")


@pulumi.output_type
class FlexVolumeSourcePatch(dict):
    """
    FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fsType":
            suggest = "fs_type"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "secretRef":
            suggest = "secret_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlexVolumeSourcePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlexVolumeSourcePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlexVolumeSourcePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 driver: Optional[_builtins.str] = None,
                 fs_type: Optional[_builtins.str] = None,
                 options: Optional[Mapping[str, _builtins.str]] = None,
                 read_only: Optional[_builtins.bool] = None,
                 secret_ref: Optional['outputs.LocalObjectReferencePatch'] = None):
        """
        FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin.
        :param _builtins.str driver: driver is the name of the driver to use for this volume.
        :param _builtins.str fs_type: fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.
        :param Mapping[str, _builtins.str] options: options is Optional: this field holds extra command options if any.
        :param _builtins.bool read_only: readOnly is Optional: defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        :param 'LocalObjectReferencePatchArgs' secret_ref: secretRef is Optional: secretRef is reference to the secret object containing sensitive information to pass to the plugin scripts. This may be empty if no secret object is specified. If the secret object contains more than one secret, all secrets are passed to the plugin scripts.
        """
        if driver is not None:
            pulumi.set(__self__, "driver", driver)
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)

    @_builtins.property
    @pulumi.getter
    def driver(self) -> Optional[_builtins.str]:
        """
        driver is the name of the driver to use for this volume.
        """
        return pulumi.get(self, "driver")

    @_builtins.property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[_builtins.str]:
        """
        fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.
        """
        return pulumi.get(self, "fs_type")

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        options is Optional: this field holds extra command options if any.
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        readOnly is Optional: defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional['outputs.LocalObjectReferencePatch']:
        """
        secretRef is Optional: secretRef is reference to the secret object containing sensitive information to pass to the plugin scripts. This may be empty if no secret object is specified. If the secret object contains more than one secret, all secrets are passed to the plugin scripts.
        """
        return pulumi.get(self, "secret_ref")


@pulumi.output_type
class FlockerVolumeSource(dict):
    """
    Represents a Flocker volume mounted by the Flocker agent. One and only one of datasetName and datasetUUID should be set. Flocker volumes do not support ownership management or SELinux relabeling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetName":
            suggest = "dataset_name"
        elif key == "datasetUUID":
            suggest = "dataset_uuid"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlockerVolumeSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlockerVolumeSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlockerVolumeSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_name: Optional[_builtins.str] = None,
                 dataset_uuid: Optional[_builtins.str] = None):
        """
        Represents a Flocker volume mounted by the Flocker agent. One and only one of datasetName and datasetUUID should be set. Flocker volumes do not support ownership management or SELinux relabeling.
        :param _builtins.str dataset_name: datasetName is Name of the dataset stored as metadata -> name on the dataset for Flocker should be considered as deprecated
        :param _builtins.str dataset_uuid: datasetUUID is the UUID of the dataset. This is unique identifier of a Flocker dataset
        """
        if dataset_name is not None:
            pulumi.set(__self__, "dataset_name", dataset_name)
        if dataset_uuid is not None:
            pulumi.set(__self__, "dataset_uuid", dataset_uuid)

    @_builtins.property
    @pulumi.getter(name="datasetName")
    def dataset_name(self) -> Optional[_builtins.str]:
        """
        datasetName is Name of the dataset stored as metadata -> name on the dataset for Flocker should be considered as deprecated
        """
        return pulumi.get(self, "dataset_name")

    @_builtins.property
    @pulumi.getter(name="datasetUUID")
    def dataset_uuid(self) -> Optional[_builtins.str]:
        """
        datasetUUID is the UUID of the dataset. This is unique identifier of a Flocker dataset
        """
        return pulumi.get(self, "dataset_uuid")


@pulumi.output_type
class FlockerVolumeSourcePatch(dict):
    """
    Represents a Flocker volume mounted by the Flocker agent. One and only one of datasetName and datasetUUID should be set. Flocker volumes do not support ownership management or SELinux relabeling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetName":
            suggest = "dataset_name"
        elif key == "datasetUUID":
            suggest = "dataset_uuid"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlockerVolumeSourcePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlockerVolumeSourcePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlockerVolumeSourcePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_name: Optional[_builtins.str] = None,
                 dataset_uuid: Optional[_builtins.str] = None):
        """
        Represents a Flocker volume mounted by the Flocker agent. One and only one of datasetName and datasetUUID should be set. Flocker volumes do not support ownership management or SELinux relabeling.
        :param _builtins.str dataset_name: datasetName is Name of the dataset stored as metadata -> name on the dataset for Flocker should be considered as deprecated
        :param _builtins.str dataset_uuid: datasetUUID is the UUID of the dataset. This is unique identifier of a Flocker dataset
        """
        if dataset_name is not None:
            pulumi.set(__self__, "dataset_name", dataset_name)
        if dataset_uuid is not None:
            pulumi.set(__self__, "dataset_uuid", dataset_uuid)

    @_builtins.property
    @pulumi.getter(name="datasetName")
    def dataset_name(self) -> Optional[_builtins.str]:
        """
        datasetName is Name of the dataset stored as metadata -> name on the dataset for Flocker should be considered as deprecated
        """
        return pulumi.get(self, "dataset_name")

    @_builtins.property
    @pulumi.getter(name="datasetUUID")
    def dataset_uuid(self) -> Optional[_builtins.str]:
        """
        datasetUUID is the UUID of the dataset. This is unique identifier of a Flocker dataset
        """
        return pulumi.get(self, "dataset_uuid")


@pulumi.output_type
class GCEPersistentDiskVolumeSource(dict):
    """
    Represents a Persistent Disk resource in Google Compute Engine.

    A GCE PD must exist before mounting to a container. The disk must also be in the same GCE project and zone as the kubelet. A GCE PD can only be mounted as read/write once or read-only many times. GCE PDs support ownership management and SELinux relabeling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pdName":
            suggest = "pd_name"
        elif key == "fsType":
            suggest = "fs_type"
        elif key == "readOnly":
            suggest = "read_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GCEPersistentDiskVolumeSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GCEPersistentDiskVolumeSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GCEPersistentDiskVolumeSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pd_name: _builtins.str,
                 fs_type: Optional[_builtins.str] = None,
                 partition: Optional[_builtins.int] = None,
                 read_only: Optional[_builtins.bool] = None):
        """
        Represents a Persistent Disk resource in Google Compute Engine.

        A GCE PD must exist before mounting to a container. The disk must also be in the same GCE project and zone as the kubelet. A GCE PD can only be mounted as read/write once or read-only many times. GCE PDs support ownership management and SELinux relabeling.
        :param _builtins.str pd_name: pdName is unique name of the PD resource in GCE. Used to identify the disk in GCE. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        :param _builtins.str fs_type: fsType is filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        :param _builtins.int partition: partition is the partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        :param _builtins.bool read_only: readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        """
        pulumi.set(__self__, "pd_name", pd_name)
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @_builtins.property
    @pulumi.getter(name="pdName")
    def pd_name(self) -> _builtins.str:
        """
        pdName is unique name of the PD resource in GCE. Used to identify the disk in GCE. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        """
        return pulumi.get(self, "pd_name")

    @_builtins.property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[_builtins.str]:
        """
        fsType is filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        """
        return pulumi.get(self, "fs_type")

    @_builtins.property
    @pulumi.getter
    def partition(self) -> Optional[_builtins.int]:
        """
        partition is the partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        """
        return pulumi.get(self, "partition")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        """
        return pulumi.get(self, "read_only")


@pulumi.output_type
class GCEPersistentDiskVolumeSourcePatch(dict):
    """
    Represents a Persistent Disk resource in Google Compute Engine.

    A GCE PD must exist before mounting to a container. The disk must also be in the same GCE project and zone as the kubelet. A GCE PD can only be mounted as read/write once or read-only many times. GCE PDs support ownership management and SELinux relabeling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fsType":
            suggest = "fs_type"
        elif key == "pdName":
            suggest = "pd_name"
        elif key == "readOnly":
            suggest = "read_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GCEPersistentDiskVolumeSourcePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GCEPersistentDiskVolumeSourcePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GCEPersistentDiskVolumeSourcePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fs_type: Optional[_builtins.str] = None,
                 partition: Optional[_builtins.int] = None,
                 pd_name: Optional[_builtins.str] = None,
                 read_only: Optional[_builtins.bool] = None):
        """
        Represents a Persistent Disk resource in Google Compute Engine.

        A GCE PD must exist before mounting to a container. The disk must also be in the same GCE project and zone as the kubelet. A GCE PD can only be mounted as read/write once or read-only many times. GCE PDs support ownership management and SELinux relabeling.
        :param _builtins.str fs_type: fsType is filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        :param _builtins.int partition: partition is the partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        :param _builtins.str pd_name: pdName is unique name of the PD resource in GCE. Used to identify the disk in GCE. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        :param _builtins.bool read_only: readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        """
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if pd_name is not None:
            pulumi.set(__self__, "pd_name", pd_name)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @_builtins.property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[_builtins.str]:
        """
        fsType is filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        """
        return pulumi.get(self, "fs_type")

    @_builtins.property
    @pulumi.getter
    def partition(self) -> Optional[_builtins.int]:
        """
        partition is the partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        """
        return pulumi.get(self, "partition")

    @_builtins.property
    @pulumi.getter(name="pdName")
    def pd_name(self) -> Optional[_builtins.str]:
        """
        pdName is unique name of the PD resource in GCE. Used to identify the disk in GCE. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        """
        return pulumi.get(self, "pd_name")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        """
        return pulumi.get(self, "read_only")


@pulumi.output_type
class GRPCAction(dict):
    """
    GRPCAction specifies an action involving a GRPC service.
    """
    def __init__(__self__, *,
                 port: _builtins.int,
                 service: Optional[_builtins.str] = None):
        """
        GRPCAction specifies an action involving a GRPC service.
        :param _builtins.int port: Port number of the gRPC service. Number must be in the range 1 to 65535.
        :param _builtins.str service: Service is the name of the service to place in the gRPC HealthCheckRequest (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
               
               If this is not specified, the default behavior is defined by gRPC.
        """
        pulumi.set(__self__, "port", port)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Port number of the gRPC service. Number must be in the range 1 to 65535.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def service(self) -> Optional[_builtins.str]:
        """
        Service is the name of the service to place in the gRPC HealthCheckRequest (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).

        If this is not specified, the default behavior is defined by gRPC.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class GRPCActionPatch(dict):
    """
    GRPCAction specifies an action involving a GRPC service.
    """
    def __init__(__self__, *,
                 port: Optional[_builtins.int] = None,
                 service: Optional[_builtins.str] = None):
        """
        GRPCAction specifies an action involving a GRPC service.
        :param _builtins.int port: Port number of the gRPC service. Number must be in the range 1 to 65535.
        :param _builtins.str service: Service is the name of the service to place in the gRPC HealthCheckRequest (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
               
               If this is not specified, the default behavior is defined by gRPC.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Port number of the gRPC service. Number must be in the range 1 to 65535.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def service(self) -> Optional[_builtins.str]:
        """
        Service is the name of the service to place in the gRPC HealthCheckRequest (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).

        If this is not specified, the default behavior is defined by gRPC.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class GitRepoVolumeSource(dict):
    """
    Represents a volume that is populated with the contents of a git repository. Git repo volumes do not support ownership management. Git repo volumes support SELinux relabeling.

    DEPRECATED: GitRepo is deprecated. To provision a container with a git repo, mount an EmptyDir into an InitContainer that clones the repo using git, then mount the EmptyDir into the Pod's container.
    """
    def __init__(__self__, *,
                 repository: _builtins.str,
                 directory: Optional[_builtins.str] = None,
                 revision: Optional[_builtins.str] = None):
        """
        Represents a volume that is populated with the contents of a git repository. Git repo volumes do not support ownership management. Git repo volumes support SELinux relabeling.

        DEPRECATED: GitRepo is deprecated. To provision a container with a git repo, mount an EmptyDir into an InitContainer that clones the repo using git, then mount the EmptyDir into the Pod's container.
        :param _builtins.str repository: repository is the URL
        :param _builtins.str directory: directory is the target directory name. Must not contain or start with '..'.  If '.' is supplied, the volume directory will be the git repository.  Otherwise, if specified, the volume will contain the git repository in the subdirectory with the given name.
        :param _builtins.str revision: revision is the commit hash for the specified revision.
        """
        pulumi.set(__self__, "repository", repository)
        if directory is not None:
            pulumi.set(__self__, "directory", directory)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)

    @_builtins.property
    @pulumi.getter
    def repository(self) -> _builtins.str:
        """
        repository is the URL
        """
        return pulumi.get(self, "repository")

    @_builtins.property
    @pulumi.getter
    def directory(self) -> Optional[_builtins.str]:
        """
        directory is the target directory name. Must not contain or start with '..'.  If '.' is supplied, the volume directory will be the git repository.  Otherwise, if specified, the volume will contain the git repository in the subdirectory with the given name.
        """
        return pulumi.get(self, "directory")

    @_builtins.property
    @pulumi.getter
    def revision(self) -> Optional[_builtins.str]:
        """
        revision is the commit hash for the specified revision.
        """
        return pulumi.get(self, "revision")


@pulumi.output_type
class GitRepoVolumeSourcePatch(dict):
    """
    Represents a volume that is populated with the contents of a git repository. Git repo volumes do not support ownership management. Git repo volumes support SELinux relabeling.

    DEPRECATED: GitRepo is deprecated. To provision a container with a git repo, mount an EmptyDir into an InitContainer that clones the repo using git, then mount the EmptyDir into the Pod's container.
    """
    def __init__(__self__, *,
                 directory: Optional[_builtins.str] = None,
                 repository: Optional[_builtins.str] = None,
                 revision: Optional[_builtins.str] = None):
        """
        Represents a volume that is populated with the contents of a git repository. Git repo volumes do not support ownership management. Git repo volumes support SELinux relabeling.

        DEPRECATED: GitRepo is deprecated. To provision a container with a git repo, mount an EmptyDir into an InitContainer that clones the repo using git, then mount the EmptyDir into the Pod's container.
        :param _builtins.str directory: directory is the target directory name. Must not contain or start with '..'.  If '.' is supplied, the volume directory will be the git repository.  Otherwise, if specified, the volume will contain the git repository in the subdirectory with the given name.
        :param _builtins.str repository: repository is the URL
        :param _builtins.str revision: revision is the commit hash for the specified revision.
        """
        if directory is not None:
            pulumi.set(__self__, "directory", directory)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)

    @_builtins.property
    @pulumi.getter
    def directory(self) -> Optional[_builtins.str]:
        """
        directory is the target directory name. Must not contain or start with '..'.  If '.' is supplied, the volume directory will be the git repository.  Otherwise, if specified, the volume will contain the git repository in the subdirectory with the given name.
        """
        return pulumi.get(self, "directory")

    @_builtins.property
    @pulumi.getter
    def repository(self) -> Optional[_builtins.str]:
        """
        repository is the URL
        """
        return pulumi.get(self, "repository")

    @_builtins.property
    @pulumi.getter
    def revision(self) -> Optional[_builtins.str]:
        """
        revision is the commit hash for the specified revision.
        """
        return pulumi.get(self, "revision")


@pulumi.output_type
class GlusterfsPersistentVolumeSource(dict):
    """
    Represents a Glusterfs mount that lasts the lifetime of a pod. Glusterfs volumes do not support ownership management or SELinux relabeling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointsNamespace":
            suggest = "endpoints_namespace"
        elif key == "readOnly":
            suggest = "read_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlusterfsPersistentVolumeSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlusterfsPersistentVolumeSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlusterfsPersistentVolumeSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoints: _builtins.str,
                 path: _builtins.str,
                 endpoints_namespace: Optional[_builtins.str] = None,
                 read_only: Optional[_builtins.bool] = None):
        """
        Represents a Glusterfs mount that lasts the lifetime of a pod. Glusterfs volumes do not support ownership management or SELinux relabeling.
        :param _builtins.str endpoints: endpoints is the endpoint name that details Glusterfs topology. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        :param _builtins.str path: path is the Glusterfs volume path. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        :param _builtins.str endpoints_namespace: endpointsNamespace is the namespace that contains Glusterfs endpoint. If this field is empty, the EndpointNamespace defaults to the same namespace as the bound PVC. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        :param _builtins.bool read_only: readOnly here will force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        """
        pulumi.set(__self__, "endpoints", endpoints)
        pulumi.set(__self__, "path", path)
        if endpoints_namespace is not None:
            pulumi.set(__self__, "endpoints_namespace", endpoints_namespace)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @_builtins.property
    @pulumi.getter
    def endpoints(self) -> _builtins.str:
        """
        endpoints is the endpoint name that details Glusterfs topology. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        """
        return pulumi.get(self, "endpoints")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        path is the Glusterfs volume path. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="endpointsNamespace")
    def endpoints_namespace(self) -> Optional[_builtins.str]:
        """
        endpointsNamespace is the namespace that contains Glusterfs endpoint. If this field is empty, the EndpointNamespace defaults to the same namespace as the bound PVC. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        """
        return pulumi.get(self, "endpoints_namespace")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        readOnly here will force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        """
        return pulumi.get(self, "read_only")


@pulumi.output_type
class GlusterfsPersistentVolumeSourcePatch(dict):
    """
    Represents a Glusterfs mount that lasts the lifetime of a pod. Glusterfs volumes do not support ownership management or SELinux relabeling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointsNamespace":
            suggest = "endpoints_namespace"
        elif key == "readOnly":
            suggest = "read_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlusterfsPersistentVolumeSourcePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlusterfsPersistentVolumeSourcePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlusterfsPersistentVolumeSourcePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoints: Optional[_builtins.str] = None,
                 endpoints_namespace: Optional[_builtins.str] = None,
                 path: Optional[_builtins.str] = None,
                 read_only: Optional[_builtins.bool] = None):
        """
        Represents a Glusterfs mount that lasts the lifetime of a pod. Glusterfs volumes do not support ownership management or SELinux relabeling.
        :param _builtins.str endpoints: endpoints is the endpoint name that details Glusterfs topology. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        :param _builtins.str endpoints_namespace: endpointsNamespace is the namespace that contains Glusterfs endpoint. If this field is empty, the EndpointNamespace defaults to the same namespace as the bound PVC. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        :param _builtins.str path: path is the Glusterfs volume path. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        :param _builtins.bool read_only: readOnly here will force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        """
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if endpoints_namespace is not None:
            pulumi.set(__self__, "endpoints_namespace", endpoints_namespace)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @_builtins.property
    @pulumi.getter
    def endpoints(self) -> Optional[_builtins.str]:
        """
        endpoints is the endpoint name that details Glusterfs topology. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        """
        return pulumi.get(self, "endpoints")

    @_builtins.property
    @pulumi.getter(name="endpointsNamespace")
    def endpoints_namespace(self) -> Optional[_builtins.str]:
        """
        endpointsNamespace is the namespace that contains Glusterfs endpoint. If this field is empty, the EndpointNamespace defaults to the same namespace as the bound PVC. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        """
        return pulumi.get(self, "endpoints_namespace")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        path is the Glusterfs volume path. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        readOnly here will force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        """
        return pulumi.get(self, "read_only")


@pulumi.output_type
class GlusterfsVolumeSource(dict):
    """
    Represents a Glusterfs mount that lasts the lifetime of a pod. Glusterfs volumes do not support ownership management or SELinux relabeling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "readOnly":
            suggest = "read_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlusterfsVolumeSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlusterfsVolumeSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlusterfsVolumeSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoints: _builtins.str,
                 path: _builtins.str,
                 read_only: Optional[_builtins.bool] = None):
        """
        Represents a Glusterfs mount that lasts the lifetime of a pod. Glusterfs volumes do not support ownership management or SELinux relabeling.
        :param _builtins.str endpoints: endpoints is the endpoint name that details Glusterfs topology. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        :param _builtins.str path: path is the Glusterfs volume path. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        :param _builtins.bool read_only: readOnly here will force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        """
        pulumi.set(__self__, "endpoints", endpoints)
        pulumi.set(__self__, "path", path)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @_builtins.property
    @pulumi.getter
    def endpoints(self) -> _builtins.str:
        """
        endpoints is the endpoint name that details Glusterfs topology. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        """
        return pulumi.get(self, "endpoints")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        path is the Glusterfs volume path. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        readOnly here will force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        """
        return pulumi.get(self, "read_only")


@pulumi.output_type
class GlusterfsVolumeSourcePatch(dict):
    """
    Represents a Glusterfs mount that lasts the lifetime of a pod. Glusterfs volumes do not support ownership management or SELinux relabeling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "readOnly":
            suggest = "read_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlusterfsVolumeSourcePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlusterfsVolumeSourcePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlusterfsVolumeSourcePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoints: Optional[_builtins.str] = None,
                 path: Optional[_builtins.str] = None,
                 read_only: Optional[_builtins.bool] = None):
        """
        Represents a Glusterfs mount that lasts the lifetime of a pod. Glusterfs volumes do not support ownership management or SELinux relabeling.
        :param _builtins.str endpoints: endpoints is the endpoint name that details Glusterfs topology. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        :param _builtins.str path: path is the Glusterfs volume path. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        :param _builtins.bool read_only: readOnly here will force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        """
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @_builtins.property
    @pulumi.getter
    def endpoints(self) -> Optional[_builtins.str]:
        """
        endpoints is the endpoint name that details Glusterfs topology. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        """
        return pulumi.get(self, "endpoints")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        path is the Glusterfs volume path. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        readOnly here will force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
        """
        return pulumi.get(self, "read_only")


@pulumi.output_type
class HTTPGetAction(dict):
    """
    HTTPGetAction describes an action based on HTTP Get requests.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpHeaders":
            suggest = "http_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HTTPGetAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HTTPGetAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HTTPGetAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: Any,
                 host: Optional[_builtins.str] = None,
                 http_headers: Optional[Sequence['outputs.HTTPHeader']] = None,
                 path: Optional[_builtins.str] = None,
                 scheme: Optional[_builtins.str] = None):
        """
        HTTPGetAction describes an action based on HTTP Get requests.
        :param Union[_builtins.int, _builtins.str] port: Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
        :param _builtins.str host: Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
        :param Sequence['HTTPHeaderArgs'] http_headers: Custom headers to set in the request. HTTP allows repeated headers.
        :param _builtins.str path: Path to access on the HTTP server.
        :param _builtins.str scheme: Scheme to use for connecting to the host. Defaults to HTTP.
        """
        pulumi.set(__self__, "port", port)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if http_headers is not None:
            pulumi.set(__self__, "http_headers", http_headers)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if scheme is not None:
            pulumi.set(__self__, "scheme", scheme)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Any:
        """
        Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[_builtins.str]:
        """
        Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Optional[Sequence['outputs.HTTPHeader']]:
        """
        Custom headers to set in the request. HTTP allows repeated headers.
        """
        return pulumi.get(self, "http_headers")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        Path to access on the HTTP server.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def scheme(self) -> Optional[_builtins.str]:
        """
        Scheme to use for connecting to the host. Defaults to HTTP.
        """
        return pulumi.get(self, "scheme")


@pulumi.output_type
class HTTPGetActionPatch(dict):
    """
    HTTPGetAction describes an action based on HTTP Get requests.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpHeaders":
            suggest = "http_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HTTPGetActionPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HTTPGetActionPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HTTPGetActionPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host: Optional[_builtins.str] = None,
                 http_headers: Optional[Sequence['outputs.HTTPHeaderPatch']] = None,
                 path: Optional[_builtins.str] = None,
                 port: Optional[Any] = None,
                 scheme: Optional[_builtins.str] = None):
        """
        HTTPGetAction describes an action based on HTTP Get requests.
        :param _builtins.str host: Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
        :param Sequence['HTTPHeaderPatchArgs'] http_headers: Custom headers to set in the request. HTTP allows repeated headers.
        :param _builtins.str path: Path to access on the HTTP server.
        :param Union[_builtins.int, _builtins.str] port: Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
        :param _builtins.str scheme: Scheme to use for connecting to the host. Defaults to HTTP.
        """
        if host is not None:
            pulumi.set(__self__, "host", host)
        if http_headers is not None:
            pulumi.set(__self__, "http_headers", http_headers)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if scheme is not None:
            pulumi.set(__self__, "scheme", scheme)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[_builtins.str]:
        """
        Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Optional[Sequence['outputs.HTTPHeaderPatch']]:
        """
        Custom headers to set in the request. HTTP allows repeated headers.
        """
        return pulumi.get(self, "http_headers")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        Path to access on the HTTP server.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[Any]:
        """
        Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def scheme(self) -> Optional[_builtins.str]:
        """
        Scheme to use for connecting to the host. Defaults to HTTP.
        """
        return pulumi.get(self, "scheme")


@pulumi.output_type
class HTTPHeader(dict):
    """
    HTTPHeader describes a custom header to be used in HTTP probes
    """
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        HTTPHeader describes a custom header to be used in HTTP probes
        :param _builtins.str name: The header field name. This will be canonicalized upon output, so case-variant names will be understood as the same header.
        :param _builtins.str value: The header field value
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The header field name. This will be canonicalized upon output, so case-variant names will be understood as the same header.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The header field value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class HTTPHeaderPatch(dict):
    """
    HTTPHeader describes a custom header to be used in HTTP probes
    """
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        HTTPHeader describes a custom header to be used in HTTP probes
        :param _builtins.str name: The header field name. This will be canonicalized upon output, so case-variant names will be understood as the same header.
        :param _builtins.str value: The header field value
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The header field name. This will be canonicalized upon output, so case-variant names will be understood as the same header.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The header field value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class HostAlias(dict):
    """
    HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
    """
    def __init__(__self__, *,
                 ip: _builtins.str,
                 hostnames: Optional[Sequence[_builtins.str]] = None):
        """
        HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param _builtins.str ip: IP address of the host file entry.
        :param Sequence[_builtins.str] hostnames: Hostnames for the above IP address.
        """
        pulumi.set(__self__, "ip", ip)
        if hostnames is not None:
            pulumi.set(__self__, "hostnames", hostnames)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        IP address of the host file entry.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def hostnames(self) -> Optional[Sequence[_builtins.str]]:
        """
        Hostnames for the above IP address.
        """
        return pulumi.get(self, "hostnames")


@pulumi.output_type
class HostAliasPatch(dict):
    """
    HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
    """
    def __init__(__self__, *,
                 hostnames: Optional[Sequence[_builtins.str]] = None,
                 ip: Optional[_builtins.str] = None):
        """
        HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
        :param Sequence[_builtins.str] hostnames: Hostnames for the above IP address.
        :param _builtins.str ip: IP address of the host file entry.
        """
        if hostnames is not None:
            pulumi.set(__self__, "hostnames", hostnames)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)

    @_builtins.property
    @pulumi.getter
    def hostnames(self) -> Optional[Sequence[_builtins.str]]:
        """
        Hostnames for the above IP address.
        """
        return pulumi.get(self, "hostnames")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[_builtins.str]:
        """
        IP address of the host file entry.
        """
        return pulumi.get(self, "ip")


@pulumi.output_type
class HostIP(dict):
    """
    HostIP represents a single IP address allocated to the host.
    """
    def __init__(__self__, *,
                 ip: _builtins.str):
        """
        HostIP represents a single IP address allocated to the host.
        :param _builtins.str ip: IP is the IP address assigned to the host
        """
        pulumi.set(__self__, "ip", ip)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        IP is the IP address assigned to the host
        """
        return pulumi.get(self, "ip")


@pulumi.output_type
class HostIPPatch(dict):
    """
    HostIP represents a single IP address allocated to the host.
    """
    def __init__(__self__, *,
                 ip: Optional[_builtins.str] = None):
        """
        HostIP represents a single IP address allocated to the host.
        :param _builtins.str ip: IP is the IP address assigned to the host
        """
        if ip is not None:
            pulumi.set(__self__, "ip", ip)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[_builtins.str]:
        """
        IP is the IP address assigned to the host
        """
        return pulumi.get(self, "ip")


@pulumi.output_type
class HostPathVolumeSource(dict):
    """
    Represents a host path mapped into a pod. Host path volumes do not support ownership management or SELinux relabeling.
    """
    def __init__(__self__, *,
                 path: _builtins.str,
                 type: Optional[_builtins.str] = None):
        """
        Represents a host path mapped into a pod. Host path volumes do not support ownership management or SELinux relabeling.
        :param _builtins.str path: path of the directory on the host. If the path is a symlink, it will follow the link to the real path. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
        :param _builtins.str type: type for HostPath Volume Defaults to "" More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
        """
        pulumi.set(__self__, "path", path)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        path of the directory on the host. If the path is a symlink, it will follow the link to the real path. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        type for HostPath Volume Defaults to "" More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class HostPathVolumeSourcePatch(dict):
    """
    Represents a host path mapped into a pod. Host path volumes do not support ownership management or SELinux relabeling.
    """
    def __init__(__self__, *,
                 path: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        Represents a host path mapped into a pod. Host path volumes do not support ownership management or SELinux relabeling.
        :param _builtins.str path: path of the directory on the host. If the path is a symlink, it will follow the link to the real path. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
        :param _builtins.str type: type for HostPath Volume Defaults to "" More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
        """
        if path is not None:
            pulumi.set(__self__, "path", path)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        path of the directory on the host. If the path is a symlink, it will follow the link to the real path. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        type for HostPath Volume Defaults to "" More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ISCSIPersistentVolumeSource(dict):
    """
    ISCSIPersistentVolumeSource represents an ISCSI disk. ISCSI volumes can only be mounted as read/write once. ISCSI volumes support ownership management and SELinux relabeling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetPortal":
            suggest = "target_portal"
        elif key == "chapAuthDiscovery":
            suggest = "chap_auth_discovery"
        elif key == "chapAuthSession":
            suggest = "chap_auth_session"
        elif key == "fsType":
            suggest = "fs_type"
        elif key == "initiatorName":
            suggest = "initiator_name"
        elif key == "iscsiInterface":
            suggest = "iscsi_interface"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "secretRef":
            suggest = "secret_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ISCSIPersistentVolumeSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ISCSIPersistentVolumeSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ISCSIPersistentVolumeSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 iqn: _builtins.str,
                 lun: _builtins.int,
                 target_portal: _builtins.str,
                 chap_auth_discovery: Optional[_builtins.bool] = None,
                 chap_auth_session: Optional[_builtins.bool] = None,
                 fs_type: Optional[_builtins.str] = None,
                 initiator_name: Optional[_builtins.str] = None,
                 iscsi_interface: Optional[_builtins.str] = None,
                 portals: Optional[Sequence[_builtins.str]] = None,
                 read_only: Optional[_builtins.bool] = None,
                 secret_ref: Optional['outputs.SecretReference'] = None):
        """
        ISCSIPersistentVolumeSource represents an ISCSI disk. ISCSI volumes can only be mounted as read/write once. ISCSI volumes support ownership management and SELinux relabeling.
        :param _builtins.str iqn: iqn is Target iSCSI Qualified Name.
        :param _builtins.int lun: lun is iSCSI Target Lun number.
        :param _builtins.str target_portal: targetPortal is iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
        :param _builtins.bool chap_auth_discovery: chapAuthDiscovery defines whether support iSCSI Discovery CHAP authentication
        :param _builtins.bool chap_auth_session: chapAuthSession defines whether support iSCSI Session CHAP authentication
        :param _builtins.str fs_type: fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi
        :param _builtins.str initiator_name: initiatorName is the custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface <target portal>:<volume name> will be created for the connection.
        :param _builtins.str iscsi_interface: iscsiInterface is the interface Name that uses an iSCSI transport. Defaults to 'default' (tcp).
        :param Sequence[_builtins.str] portals: portals is the iSCSI Target Portal List. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
        :param _builtins.bool read_only: readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false.
        :param 'SecretReferenceArgs' secret_ref: secretRef is the CHAP Secret for iSCSI target and initiator authentication
        """
        pulumi.set(__self__, "iqn", iqn)
        pulumi.set(__self__, "lun", lun)
        pulumi.set(__self__, "target_portal", target_portal)
        if chap_auth_discovery is not None:
            pulumi.set(__self__, "chap_auth_discovery", chap_auth_discovery)
        if chap_auth_session is not None:
            pulumi.set(__self__, "chap_auth_session", chap_auth_session)
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if initiator_name is not None:
            pulumi.set(__self__, "initiator_name", initiator_name)
        if iscsi_interface is not None:
            pulumi.set(__self__, "iscsi_interface", iscsi_interface)
        if portals is not None:
            pulumi.set(__self__, "portals", portals)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)

    @_builtins.property
    @pulumi.getter
    def iqn(self) -> _builtins.str:
        """
        iqn is Target iSCSI Qualified Name.
        """
        return pulumi.get(self, "iqn")

    @_builtins.property
    @pulumi.getter
    def lun(self) -> _builtins.int:
        """
        lun is iSCSI Target Lun number.
        """
        return pulumi.get(self, "lun")

    @_builtins.property
    @pulumi.getter(name="targetPortal")
    def target_portal(self) -> _builtins.str:
        """
        targetPortal is iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
        """
        return pulumi.get(self, "target_portal")

    @_builtins.property
    @pulumi.getter(name="chapAuthDiscovery")
    def chap_auth_discovery(self) -> Optional[_builtins.bool]:
        """
        chapAuthDiscovery defines whether support iSCSI Discovery CHAP authentication
        """
        return pulumi.get(self, "chap_auth_discovery")

    @_builtins.property
    @pulumi.getter(name="chapAuthSession")
    def chap_auth_session(self) -> Optional[_builtins.bool]:
        """
        chapAuthSession defines whether support iSCSI Session CHAP authentication
        """
        return pulumi.get(self, "chap_auth_session")

    @_builtins.property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[_builtins.str]:
        """
        fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi
        """
        return pulumi.get(self, "fs_type")

    @_builtins.property
    @pulumi.getter(name="initiatorName")
    def initiator_name(self) -> Optional[_builtins.str]:
        """
        initiatorName is the custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface <target portal>:<volume name> will be created for the connection.
        """
        return pulumi.get(self, "initiator_name")

    @_builtins.property
    @pulumi.getter(name="iscsiInterface")
    def iscsi_interface(self) -> Optional[_builtins.str]:
        """
        iscsiInterface is the interface Name that uses an iSCSI transport. Defaults to 'default' (tcp).
        """
        return pulumi.get(self, "iscsi_interface")

    @_builtins.property
    @pulumi.getter
    def portals(self) -> Optional[Sequence[_builtins.str]]:
        """
        portals is the iSCSI Target Portal List. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
        """
        return pulumi.get(self, "portals")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false.
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional['outputs.SecretReference']:
        """
        secretRef is the CHAP Secret for iSCSI target and initiator authentication
        """
        return pulumi.get(self, "secret_ref")


@pulumi.output_type
class ISCSIPersistentVolumeSourcePatch(dict):
    """
    ISCSIPersistentVolumeSource represents an ISCSI disk. ISCSI volumes can only be mounted as read/write once. ISCSI volumes support ownership management and SELinux relabeling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "chapAuthDiscovery":
            suggest = "chap_auth_discovery"
        elif key == "chapAuthSession":
            suggest = "chap_auth_session"
        elif key == "fsType":
            suggest = "fs_type"
        elif key == "initiatorName":
            suggest = "initiator_name"
        elif key == "iscsiInterface":
            suggest = "iscsi_interface"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "secretRef":
            suggest = "secret_ref"
        elif key == "targetPortal":
            suggest = "target_portal"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ISCSIPersistentVolumeSourcePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ISCSIPersistentVolumeSourcePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ISCSIPersistentVolumeSourcePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 chap_auth_discovery: Optional[_builtins.bool] = None,
                 chap_auth_session: Optional[_builtins.bool] = None,
                 fs_type: Optional[_builtins.str] = None,
                 initiator_name: Optional[_builtins.str] = None,
                 iqn: Optional[_builtins.str] = None,
                 iscsi_interface: Optional[_builtins.str] = None,
                 lun: Optional[_builtins.int] = None,
                 portals: Optional[Sequence[_builtins.str]] = None,
                 read_only: Optional[_builtins.bool] = None,
                 secret_ref: Optional['outputs.SecretReferencePatch'] = None,
                 target_portal: Optional[_builtins.str] = None):
        """
        ISCSIPersistentVolumeSource represents an ISCSI disk. ISCSI volumes can only be mounted as read/write once. ISCSI volumes support ownership management and SELinux relabeling.
        :param _builtins.bool chap_auth_discovery: chapAuthDiscovery defines whether support iSCSI Discovery CHAP authentication
        :param _builtins.bool chap_auth_session: chapAuthSession defines whether support iSCSI Session CHAP authentication
        :param _builtins.str fs_type: fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi
        :param _builtins.str initiator_name: initiatorName is the custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface <target portal>:<volume name> will be created for the connection.
        :param _builtins.str iqn: iqn is Target iSCSI Qualified Name.
        :param _builtins.str iscsi_interface: iscsiInterface is the interface Name that uses an iSCSI transport. Defaults to 'default' (tcp).
        :param _builtins.int lun: lun is iSCSI Target Lun number.
        :param Sequence[_builtins.str] portals: portals is the iSCSI Target Portal List. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
        :param _builtins.bool read_only: readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false.
        :param 'SecretReferencePatchArgs' secret_ref: secretRef is the CHAP Secret for iSCSI target and initiator authentication
        :param _builtins.str target_portal: targetPortal is iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
        """
        if chap_auth_discovery is not None:
            pulumi.set(__self__, "chap_auth_discovery", chap_auth_discovery)
        if chap_auth_session is not None:
            pulumi.set(__self__, "chap_auth_session", chap_auth_session)
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if initiator_name is not None:
            pulumi.set(__self__, "initiator_name", initiator_name)
        if iqn is not None:
            pulumi.set(__self__, "iqn", iqn)
        if iscsi_interface is not None:
            pulumi.set(__self__, "iscsi_interface", iscsi_interface)
        if lun is not None:
            pulumi.set(__self__, "lun", lun)
        if portals is not None:
            pulumi.set(__self__, "portals", portals)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)
        if target_portal is not None:
            pulumi.set(__self__, "target_portal", target_portal)

    @_builtins.property
    @pulumi.getter(name="chapAuthDiscovery")
    def chap_auth_discovery(self) -> Optional[_builtins.bool]:
        """
        chapAuthDiscovery defines whether support iSCSI Discovery CHAP authentication
        """
        return pulumi.get(self, "chap_auth_discovery")

    @_builtins.property
    @pulumi.getter(name="chapAuthSession")
    def chap_auth_session(self) -> Optional[_builtins.bool]:
        """
        chapAuthSession defines whether support iSCSI Session CHAP authentication
        """
        return pulumi.get(self, "chap_auth_session")

    @_builtins.property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[_builtins.str]:
        """
        fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi
        """
        return pulumi.get(self, "fs_type")

    @_builtins.property
    @pulumi.getter(name="initiatorName")
    def initiator_name(self) -> Optional[_builtins.str]:
        """
        initiatorName is the custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface <target portal>:<volume name> will be created for the connection.
        """
        return pulumi.get(self, "initiator_name")

    @_builtins.property
    @pulumi.getter
    def iqn(self) -> Optional[_builtins.str]:
        """
        iqn is Target iSCSI Qualified Name.
        """
        return pulumi.get(self, "iqn")

    @_builtins.property
    @pulumi.getter(name="iscsiInterface")
    def iscsi_interface(self) -> Optional[_builtins.str]:
        """
        iscsiInterface is the interface Name that uses an iSCSI transport. Defaults to 'default' (tcp).
        """
        return pulumi.get(self, "iscsi_interface")

    @_builtins.property
    @pulumi.getter
    def lun(self) -> Optional[_builtins.int]:
        """
        lun is iSCSI Target Lun number.
        """
        return pulumi.get(self, "lun")

    @_builtins.property
    @pulumi.getter
    def portals(self) -> Optional[Sequence[_builtins.str]]:
        """
        portals is the iSCSI Target Portal List. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
        """
        return pulumi.get(self, "portals")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false.
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional['outputs.SecretReferencePatch']:
        """
        secretRef is the CHAP Secret for iSCSI target and initiator authentication
        """
        return pulumi.get(self, "secret_ref")

    @_builtins.property
    @pulumi.getter(name="targetPortal")
    def target_portal(self) -> Optional[_builtins.str]:
        """
        targetPortal is iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
        """
        return pulumi.get(self, "target_portal")


@pulumi.output_type
class ISCSIVolumeSource(dict):
    """
    Represents an ISCSI disk. ISCSI volumes can only be mounted as read/write once. ISCSI volumes support ownership management and SELinux relabeling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetPortal":
            suggest = "target_portal"
        elif key == "chapAuthDiscovery":
            suggest = "chap_auth_discovery"
        elif key == "chapAuthSession":
            suggest = "chap_auth_session"
        elif key == "fsType":
            suggest = "fs_type"
        elif key == "initiatorName":
            suggest = "initiator_name"
        elif key == "iscsiInterface":
            suggest = "iscsi_interface"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "secretRef":
            suggest = "secret_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ISCSIVolumeSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ISCSIVolumeSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ISCSIVolumeSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 iqn: _builtins.str,
                 lun: _builtins.int,
                 target_portal: _builtins.str,
                 chap_auth_discovery: Optional[_builtins.bool] = None,
                 chap_auth_session: Optional[_builtins.bool] = None,
                 fs_type: Optional[_builtins.str] = None,
                 initiator_name: Optional[_builtins.str] = None,
                 iscsi_interface: Optional[_builtins.str] = None,
                 portals: Optional[Sequence[_builtins.str]] = None,
                 read_only: Optional[_builtins.bool] = None,
                 secret_ref: Optional['outputs.LocalObjectReference'] = None):
        """
        Represents an ISCSI disk. ISCSI volumes can only be mounted as read/write once. ISCSI volumes support ownership management and SELinux relabeling.
        :param _builtins.str iqn: iqn is the target iSCSI Qualified Name.
        :param _builtins.int lun: lun represents iSCSI Target Lun number.
        :param _builtins.str target_portal: targetPortal is iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
        :param _builtins.bool chap_auth_discovery: chapAuthDiscovery defines whether support iSCSI Discovery CHAP authentication
        :param _builtins.bool chap_auth_session: chapAuthSession defines whether support iSCSI Session CHAP authentication
        :param _builtins.str fs_type: fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi
        :param _builtins.str initiator_name: initiatorName is the custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface <target portal>:<volume name> will be created for the connection.
        :param _builtins.str iscsi_interface: iscsiInterface is the interface Name that uses an iSCSI transport. Defaults to 'default' (tcp).
        :param Sequence[_builtins.str] portals: portals is the iSCSI Target Portal List. The portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
        :param _builtins.bool read_only: readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false.
        :param 'LocalObjectReferenceArgs' secret_ref: secretRef is the CHAP Secret for iSCSI target and initiator authentication
        """
        pulumi.set(__self__, "iqn", iqn)
        pulumi.set(__self__, "lun", lun)
        pulumi.set(__self__, "target_portal", target_portal)
        if chap_auth_discovery is not None:
            pulumi.set(__self__, "chap_auth_discovery", chap_auth_discovery)
        if chap_auth_session is not None:
            pulumi.set(__self__, "chap_auth_session", chap_auth_session)
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if initiator_name is not None:
            pulumi.set(__self__, "initiator_name", initiator_name)
        if iscsi_interface is not None:
            pulumi.set(__self__, "iscsi_interface", iscsi_interface)
        if portals is not None:
            pulumi.set(__self__, "portals", portals)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)

    @_builtins.property
    @pulumi.getter
    def iqn(self) -> _builtins.str:
        """
        iqn is the target iSCSI Qualified Name.
        """
        return pulumi.get(self, "iqn")

    @_builtins.property
    @pulumi.getter
    def lun(self) -> _builtins.int:
        """
        lun represents iSCSI Target Lun number.
        """
        return pulumi.get(self, "lun")

    @_builtins.property
    @pulumi.getter(name="targetPortal")
    def target_portal(self) -> _builtins.str:
        """
        targetPortal is iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
        """
        return pulumi.get(self, "target_portal")

    @_builtins.property
    @pulumi.getter(name="chapAuthDiscovery")
    def chap_auth_discovery(self) -> Optional[_builtins.bool]:
        """
        chapAuthDiscovery defines whether support iSCSI Discovery CHAP authentication
        """
        return pulumi.get(self, "chap_auth_discovery")

    @_builtins.property
    @pulumi.getter(name="chapAuthSession")
    def chap_auth_session(self) -> Optional[_builtins.bool]:
        """
        chapAuthSession defines whether support iSCSI Session CHAP authentication
        """
        return pulumi.get(self, "chap_auth_session")

    @_builtins.property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[_builtins.str]:
        """
        fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi
        """
        return pulumi.get(self, "fs_type")

    @_builtins.property
    @pulumi.getter(name="initiatorName")
    def initiator_name(self) -> Optional[_builtins.str]:
        """
        initiatorName is the custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface <target portal>:<volume name> will be created for the connection.
        """
        return pulumi.get(self, "initiator_name")

    @_builtins.property
    @pulumi.getter(name="iscsiInterface")
    def iscsi_interface(self) -> Optional[_builtins.str]:
        """
        iscsiInterface is the interface Name that uses an iSCSI transport. Defaults to 'default' (tcp).
        """
        return pulumi.get(self, "iscsi_interface")

    @_builtins.property
    @pulumi.getter
    def portals(self) -> Optional[Sequence[_builtins.str]]:
        """
        portals is the iSCSI Target Portal List. The portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
        """
        return pulumi.get(self, "portals")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false.
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional['outputs.LocalObjectReference']:
        """
        secretRef is the CHAP Secret for iSCSI target and initiator authentication
        """
        return pulumi.get(self, "secret_ref")


@pulumi.output_type
class ISCSIVolumeSourcePatch(dict):
    """
    Represents an ISCSI disk. ISCSI volumes can only be mounted as read/write once. ISCSI volumes support ownership management and SELinux relabeling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "chapAuthDiscovery":
            suggest = "chap_auth_discovery"
        elif key == "chapAuthSession":
            suggest = "chap_auth_session"
        elif key == "fsType":
            suggest = "fs_type"
        elif key == "initiatorName":
            suggest = "initiator_name"
        elif key == "iscsiInterface":
            suggest = "iscsi_interface"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "secretRef":
            suggest = "secret_ref"
        elif key == "targetPortal":
            suggest = "target_portal"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ISCSIVolumeSourcePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ISCSIVolumeSourcePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ISCSIVolumeSourcePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 chap_auth_discovery: Optional[_builtins.bool] = None,
                 chap_auth_session: Optional[_builtins.bool] = None,
                 fs_type: Optional[_builtins.str] = None,
                 initiator_name: Optional[_builtins.str] = None,
                 iqn: Optional[_builtins.str] = None,
                 iscsi_interface: Optional[_builtins.str] = None,
                 lun: Optional[_builtins.int] = None,
                 portals: Optional[Sequence[_builtins.str]] = None,
                 read_only: Optional[_builtins.bool] = None,
                 secret_ref: Optional['outputs.LocalObjectReferencePatch'] = None,
                 target_portal: Optional[_builtins.str] = None):
        """
        Represents an ISCSI disk. ISCSI volumes can only be mounted as read/write once. ISCSI volumes support ownership management and SELinux relabeling.
        :param _builtins.bool chap_auth_discovery: chapAuthDiscovery defines whether support iSCSI Discovery CHAP authentication
        :param _builtins.bool chap_auth_session: chapAuthSession defines whether support iSCSI Session CHAP authentication
        :param _builtins.str fs_type: fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi
        :param _builtins.str initiator_name: initiatorName is the custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface <target portal>:<volume name> will be created for the connection.
        :param _builtins.str iqn: iqn is the target iSCSI Qualified Name.
        :param _builtins.str iscsi_interface: iscsiInterface is the interface Name that uses an iSCSI transport. Defaults to 'default' (tcp).
        :param _builtins.int lun: lun represents iSCSI Target Lun number.
        :param Sequence[_builtins.str] portals: portals is the iSCSI Target Portal List. The portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
        :param _builtins.bool read_only: readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false.
        :param 'LocalObjectReferencePatchArgs' secret_ref: secretRef is the CHAP Secret for iSCSI target and initiator authentication
        :param _builtins.str target_portal: targetPortal is iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
        """
        if chap_auth_discovery is not None:
            pulumi.set(__self__, "chap_auth_discovery", chap_auth_discovery)
        if chap_auth_session is not None:
            pulumi.set(__self__, "chap_auth_session", chap_auth_session)
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if initiator_name is not None:
            pulumi.set(__self__, "initiator_name", initiator_name)
        if iqn is not None:
            pulumi.set(__self__, "iqn", iqn)
        if iscsi_interface is not None:
            pulumi.set(__self__, "iscsi_interface", iscsi_interface)
        if lun is not None:
            pulumi.set(__self__, "lun", lun)
        if portals is not None:
            pulumi.set(__self__, "portals", portals)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)
        if target_portal is not None:
            pulumi.set(__self__, "target_portal", target_portal)

    @_builtins.property
    @pulumi.getter(name="chapAuthDiscovery")
    def chap_auth_discovery(self) -> Optional[_builtins.bool]:
        """
        chapAuthDiscovery defines whether support iSCSI Discovery CHAP authentication
        """
        return pulumi.get(self, "chap_auth_discovery")

    @_builtins.property
    @pulumi.getter(name="chapAuthSession")
    def chap_auth_session(self) -> Optional[_builtins.bool]:
        """
        chapAuthSession defines whether support iSCSI Session CHAP authentication
        """
        return pulumi.get(self, "chap_auth_session")

    @_builtins.property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[_builtins.str]:
        """
        fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi
        """
        return pulumi.get(self, "fs_type")

    @_builtins.property
    @pulumi.getter(name="initiatorName")
    def initiator_name(self) -> Optional[_builtins.str]:
        """
        initiatorName is the custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface <target portal>:<volume name> will be created for the connection.
        """
        return pulumi.get(self, "initiator_name")

    @_builtins.property
    @pulumi.getter
    def iqn(self) -> Optional[_builtins.str]:
        """
        iqn is the target iSCSI Qualified Name.
        """
        return pulumi.get(self, "iqn")

    @_builtins.property
    @pulumi.getter(name="iscsiInterface")
    def iscsi_interface(self) -> Optional[_builtins.str]:
        """
        iscsiInterface is the interface Name that uses an iSCSI transport. Defaults to 'default' (tcp).
        """
        return pulumi.get(self, "iscsi_interface")

    @_builtins.property
    @pulumi.getter
    def lun(self) -> Optional[_builtins.int]:
        """
        lun represents iSCSI Target Lun number.
        """
        return pulumi.get(self, "lun")

    @_builtins.property
    @pulumi.getter
    def portals(self) -> Optional[Sequence[_builtins.str]]:
        """
        portals is the iSCSI Target Portal List. The portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
        """
        return pulumi.get(self, "portals")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false.
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional['outputs.LocalObjectReferencePatch']:
        """
        secretRef is the CHAP Secret for iSCSI target and initiator authentication
        """
        return pulumi.get(self, "secret_ref")

    @_builtins.property
    @pulumi.getter(name="targetPortal")
    def target_portal(self) -> Optional[_builtins.str]:
        """
        targetPortal is iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
        """
        return pulumi.get(self, "target_portal")


@pulumi.output_type
class ImageVolumeSource(dict):
    """
    ImageVolumeSource represents a image volume resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pullPolicy":
            suggest = "pull_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageVolumeSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageVolumeSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageVolumeSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pull_policy: Optional[_builtins.str] = None,
                 reference: Optional[_builtins.str] = None):
        """
        ImageVolumeSource represents a image volume resource.
        :param _builtins.str pull_policy: Policy for pulling OCI objects. Possible values are: Always: the kubelet always attempts to pull the reference. Container creation will fail If the pull fails. Never: the kubelet never pulls the reference and only uses a local image or artifact. Container creation will fail if the reference isn't present. IfNotPresent: the kubelet pulls if the reference isn't already present on disk. Container creation will fail if the reference isn't present and the pull fails. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise.
        :param _builtins.str reference: Required: Image or artifact reference to be used. Behaves in the same way as pod.spec.containers[*].image. Pull secrets will be assembled in the same way as for the container image by looking up node credentials, SA image pull secrets, and pod spec image pull secrets. More info: https://kubernetes.io/docs/concepts/containers/images This field is optional to allow higher level config management to default or override container images in workload controllers like Deployments and StatefulSets.
        """
        if pull_policy is not None:
            pulumi.set(__self__, "pull_policy", pull_policy)
        if reference is not None:
            pulumi.set(__self__, "reference", reference)

    @_builtins.property
    @pulumi.getter(name="pullPolicy")
    def pull_policy(self) -> Optional[_builtins.str]:
        """
        Policy for pulling OCI objects. Possible values are: Always: the kubelet always attempts to pull the reference. Container creation will fail If the pull fails. Never: the kubelet never pulls the reference and only uses a local image or artifact. Container creation will fail if the reference isn't present. IfNotPresent: the kubelet pulls if the reference isn't already present on disk. Container creation will fail if the reference isn't present and the pull fails. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise.
        """
        return pulumi.get(self, "pull_policy")

    @_builtins.property
    @pulumi.getter
    def reference(self) -> Optional[_builtins.str]:
        """
        Required: Image or artifact reference to be used. Behaves in the same way as pod.spec.containers[*].image. Pull secrets will be assembled in the same way as for the container image by looking up node credentials, SA image pull secrets, and pod spec image pull secrets. More info: https://kubernetes.io/docs/concepts/containers/images This field is optional to allow higher level config management to default or override container images in workload controllers like Deployments and StatefulSets.
        """
        return pulumi.get(self, "reference")


@pulumi.output_type
class ImageVolumeSourcePatch(dict):
    """
    ImageVolumeSource represents a image volume resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pullPolicy":
            suggest = "pull_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageVolumeSourcePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageVolumeSourcePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageVolumeSourcePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pull_policy: Optional[_builtins.str] = None,
                 reference: Optional[_builtins.str] = None):
        """
        ImageVolumeSource represents a image volume resource.
        :param _builtins.str pull_policy: Policy for pulling OCI objects. Possible values are: Always: the kubelet always attempts to pull the reference. Container creation will fail If the pull fails. Never: the kubelet never pulls the reference and only uses a local image or artifact. Container creation will fail if the reference isn't present. IfNotPresent: the kubelet pulls if the reference isn't already present on disk. Container creation will fail if the reference isn't present and the pull fails. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise.
        :param _builtins.str reference: Required: Image or artifact reference to be used. Behaves in the same way as pod.spec.containers[*].image. Pull secrets will be assembled in the same way as for the container image by looking up node credentials, SA image pull secrets, and pod spec image pull secrets. More info: https://kubernetes.io/docs/concepts/containers/images This field is optional to allow higher level config management to default or override container images in workload controllers like Deployments and StatefulSets.
        """
        if pull_policy is not None:
            pulumi.set(__self__, "pull_policy", pull_policy)
        if reference is not None:
            pulumi.set(__self__, "reference", reference)

    @_builtins.property
    @pulumi.getter(name="pullPolicy")
    def pull_policy(self) -> Optional[_builtins.str]:
        """
        Policy for pulling OCI objects. Possible values are: Always: the kubelet always attempts to pull the reference. Container creation will fail If the pull fails. Never: the kubelet never pulls the reference and only uses a local image or artifact. Container creation will fail if the reference isn't present. IfNotPresent: the kubelet pulls if the reference isn't already present on disk. Container creation will fail if the reference isn't present and the pull fails. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise.
        """
        return pulumi.get(self, "pull_policy")

    @_builtins.property
    @pulumi.getter
    def reference(self) -> Optional[_builtins.str]:
        """
        Required: Image or artifact reference to be used. Behaves in the same way as pod.spec.containers[*].image. Pull secrets will be assembled in the same way as for the container image by looking up node credentials, SA image pull secrets, and pod spec image pull secrets. More info: https://kubernetes.io/docs/concepts/containers/images This field is optional to allow higher level config management to default or override container images in workload controllers like Deployments and StatefulSets.
        """
        return pulumi.get(self, "reference")


@pulumi.output_type
class KeyToPath(dict):
    """
    Maps a string key to a path within a volume.
    """
    def __init__(__self__, *,
                 key: _builtins.str,
                 path: _builtins.str,
                 mode: Optional[_builtins.int] = None):
        """
        Maps a string key to a path within a volume.
        :param _builtins.str key: key is the key to project.
        :param _builtins.str path: path is the relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
        :param _builtins.int mode: mode is Optional: mode bits used to set permissions on this file. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "path", path)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        key is the key to project.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        path is the relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[_builtins.int]:
        """
        mode is Optional: mode bits used to set permissions on this file. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class KeyToPathPatch(dict):
    """
    Maps a string key to a path within a volume.
    """
    def __init__(__self__, *,
                 key: Optional[_builtins.str] = None,
                 mode: Optional[_builtins.int] = None,
                 path: Optional[_builtins.str] = None):
        """
        Maps a string key to a path within a volume.
        :param _builtins.str key: key is the key to project.
        :param _builtins.int mode: mode is Optional: mode bits used to set permissions on this file. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param _builtins.str path: path is the relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        key is the key to project.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[_builtins.int]:
        """
        mode is Optional: mode bits used to set permissions on this file. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        path is the relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class Lifecycle(dict):
    """
    Lifecycle describes actions that the management system should take in response to container lifecycle events. For the PostStart and PreStop lifecycle handlers, management of the container blocks until the action is complete, unless the container process fails, in which case the handler is aborted.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "postStart":
            suggest = "post_start"
        elif key == "preStop":
            suggest = "pre_stop"
        elif key == "stopSignal":
            suggest = "stop_signal"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Lifecycle. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Lifecycle.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Lifecycle.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 post_start: Optional['outputs.LifecycleHandler'] = None,
                 pre_stop: Optional['outputs.LifecycleHandler'] = None,
                 stop_signal: Optional[_builtins.str] = None):
        """
        Lifecycle describes actions that the management system should take in response to container lifecycle events. For the PostStart and PreStop lifecycle handlers, management of the container blocks until the action is complete, unless the container process fails, in which case the handler is aborted.
        :param 'LifecycleHandlerArgs' post_start: PostStart is called immediately after a container is created. If the handler fails, the container is terminated and restarted according to its restart policy. Other management of the container blocks until the hook completes. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks
        :param 'LifecycleHandlerArgs' pre_stop: PreStop is called immediately before a container is terminated due to an API request or management event such as liveness/startup probe failure, preemption, resource contention, etc. The handler is not called if the container crashes or exits. The Pod's termination grace period countdown begins before the PreStop hook is executed. Regardless of the outcome of the handler, the container will eventually terminate within the Pod's termination grace period (unless delayed by finalizers). Other management of the container blocks until the hook completes or until the termination grace period is reached. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks
        :param _builtins.str stop_signal: StopSignal defines which signal will be sent to a container when it is being stopped. If not specified, the default is defined by the container runtime in use. StopSignal can only be set for Pods with a non-empty .spec.os.name
        """
        if post_start is not None:
            pulumi.set(__self__, "post_start", post_start)
        if pre_stop is not None:
            pulumi.set(__self__, "pre_stop", pre_stop)
        if stop_signal is not None:
            pulumi.set(__self__, "stop_signal", stop_signal)

    @_builtins.property
    @pulumi.getter(name="postStart")
    def post_start(self) -> Optional['outputs.LifecycleHandler']:
        """
        PostStart is called immediately after a container is created. If the handler fails, the container is terminated and restarted according to its restart policy. Other management of the container blocks until the hook completes. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks
        """
        return pulumi.get(self, "post_start")

    @_builtins.property
    @pulumi.getter(name="preStop")
    def pre_stop(self) -> Optional['outputs.LifecycleHandler']:
        """
        PreStop is called immediately before a container is terminated due to an API request or management event such as liveness/startup probe failure, preemption, resource contention, etc. The handler is not called if the container crashes or exits. The Pod's termination grace period countdown begins before the PreStop hook is executed. Regardless of the outcome of the handler, the container will eventually terminate within the Pod's termination grace period (unless delayed by finalizers). Other management of the container blocks until the hook completes or until the termination grace period is reached. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks
        """
        return pulumi.get(self, "pre_stop")

    @_builtins.property
    @pulumi.getter(name="stopSignal")
    def stop_signal(self) -> Optional[_builtins.str]:
        """
        StopSignal defines which signal will be sent to a container when it is being stopped. If not specified, the default is defined by the container runtime in use. StopSignal can only be set for Pods with a non-empty .spec.os.name
        """
        return pulumi.get(self, "stop_signal")


@pulumi.output_type
class LifecycleHandler(dict):
    """
    LifecycleHandler defines a specific action that should be taken in a lifecycle hook. One and only one of the fields, except TCPSocket must be specified.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exec":
            suggest = "exec_"
        elif key == "httpGet":
            suggest = "http_get"
        elif key == "tcpSocket":
            suggest = "tcp_socket"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecycleHandler. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecycleHandler.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecycleHandler.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exec_: Optional['outputs.ExecAction'] = None,
                 http_get: Optional['outputs.HTTPGetAction'] = None,
                 sleep: Optional['outputs.SleepAction'] = None,
                 tcp_socket: Optional['outputs.TCPSocketAction'] = None):
        """
        LifecycleHandler defines a specific action that should be taken in a lifecycle hook. One and only one of the fields, except TCPSocket must be specified.
        :param 'ExecActionArgs' exec_: Exec specifies a command to execute in the container.
        :param 'HTTPGetActionArgs' http_get: HTTPGet specifies an HTTP GET request to perform.
        :param 'SleepActionArgs' sleep: Sleep represents a duration that the container should sleep.
        :param 'TCPSocketActionArgs' tcp_socket: Deprecated. TCPSocket is NOT supported as a LifecycleHandler and kept for backward compatibility. There is no validation of this field and lifecycle hooks will fail at runtime when it is specified.
        """
        if exec_ is not None:
            pulumi.set(__self__, "exec_", exec_)
        if http_get is not None:
            pulumi.set(__self__, "http_get", http_get)
        if sleep is not None:
            pulumi.set(__self__, "sleep", sleep)
        if tcp_socket is not None:
            pulumi.set(__self__, "tcp_socket", tcp_socket)

    @_builtins.property
    @pulumi.getter(name="exec")
    def exec_(self) -> Optional['outputs.ExecAction']:
        """
        Exec specifies a command to execute in the container.
        """
        return pulumi.get(self, "exec_")

    @_builtins.property
    @pulumi.getter(name="httpGet")
    def http_get(self) -> Optional['outputs.HTTPGetAction']:
        """
        HTTPGet specifies an HTTP GET request to perform.
        """
        return pulumi.get(self, "http_get")

    @_builtins.property
    @pulumi.getter
    def sleep(self) -> Optional['outputs.SleepAction']:
        """
        Sleep represents a duration that the container should sleep.
        """
        return pulumi.get(self, "sleep")

    @_builtins.property
    @pulumi.getter(name="tcpSocket")
    def tcp_socket(self) -> Optional['outputs.TCPSocketAction']:
        """
        Deprecated. TCPSocket is NOT supported as a LifecycleHandler and kept for backward compatibility. There is no validation of this field and lifecycle hooks will fail at runtime when it is specified.
        """
        return pulumi.get(self, "tcp_socket")


@pulumi.output_type
class LifecycleHandlerPatch(dict):
    """
    LifecycleHandler defines a specific action that should be taken in a lifecycle hook. One and only one of the fields, except TCPSocket must be specified.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exec":
            suggest = "exec_"
        elif key == "httpGet":
            suggest = "http_get"
        elif key == "tcpSocket":
            suggest = "tcp_socket"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecycleHandlerPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecycleHandlerPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecycleHandlerPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exec_: Optional['outputs.ExecActionPatch'] = None,
                 http_get: Optional['outputs.HTTPGetActionPatch'] = None,
                 sleep: Optional['outputs.SleepActionPatch'] = None,
                 tcp_socket: Optional['outputs.TCPSocketActionPatch'] = None):
        """
        LifecycleHandler defines a specific action that should be taken in a lifecycle hook. One and only one of the fields, except TCPSocket must be specified.
        :param 'ExecActionPatchArgs' exec_: Exec specifies a command to execute in the container.
        :param 'HTTPGetActionPatchArgs' http_get: HTTPGet specifies an HTTP GET request to perform.
        :param 'SleepActionPatchArgs' sleep: Sleep represents a duration that the container should sleep.
        :param 'TCPSocketActionPatchArgs' tcp_socket: Deprecated. TCPSocket is NOT supported as a LifecycleHandler and kept for backward compatibility. There is no validation of this field and lifecycle hooks will fail at runtime when it is specified.
        """
        if exec_ is not None:
            pulumi.set(__self__, "exec_", exec_)
        if http_get is not None:
            pulumi.set(__self__, "http_get", http_get)
        if sleep is not None:
            pulumi.set(__self__, "sleep", sleep)
        if tcp_socket is not None:
            pulumi.set(__self__, "tcp_socket", tcp_socket)

    @_builtins.property
    @pulumi.getter(name="exec")
    def exec_(self) -> Optional['outputs.ExecActionPatch']:
        """
        Exec specifies a command to execute in the container.
        """
        return pulumi.get(self, "exec_")

    @_builtins.property
    @pulumi.getter(name="httpGet")
    def http_get(self) -> Optional['outputs.HTTPGetActionPatch']:
        """
        HTTPGet specifies an HTTP GET request to perform.
        """
        return pulumi.get(self, "http_get")

    @_builtins.property
    @pulumi.getter
    def sleep(self) -> Optional['outputs.SleepActionPatch']:
        """
        Sleep represents a duration that the container should sleep.
        """
        return pulumi.get(self, "sleep")

    @_builtins.property
    @pulumi.getter(name="tcpSocket")
    def tcp_socket(self) -> Optional['outputs.TCPSocketActionPatch']:
        """
        Deprecated. TCPSocket is NOT supported as a LifecycleHandler and kept for backward compatibility. There is no validation of this field and lifecycle hooks will fail at runtime when it is specified.
        """
        return pulumi.get(self, "tcp_socket")


@pulumi.output_type
class LifecyclePatch(dict):
    """
    Lifecycle describes actions that the management system should take in response to container lifecycle events. For the PostStart and PreStop lifecycle handlers, management of the container blocks until the action is complete, unless the container process fails, in which case the handler is aborted.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "postStart":
            suggest = "post_start"
        elif key == "preStop":
            suggest = "pre_stop"
        elif key == "stopSignal":
            suggest = "stop_signal"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecyclePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecyclePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecyclePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 post_start: Optional['outputs.LifecycleHandlerPatch'] = None,
                 pre_stop: Optional['outputs.LifecycleHandlerPatch'] = None,
                 stop_signal: Optional[_builtins.str] = None):
        """
        Lifecycle describes actions that the management system should take in response to container lifecycle events. For the PostStart and PreStop lifecycle handlers, management of the container blocks until the action is complete, unless the container process fails, in which case the handler is aborted.
        :param 'LifecycleHandlerPatchArgs' post_start: PostStart is called immediately after a container is created. If the handler fails, the container is terminated and restarted according to its restart policy. Other management of the container blocks until the hook completes. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks
        :param 'LifecycleHandlerPatchArgs' pre_stop: PreStop is called immediately before a container is terminated due to an API request or management event such as liveness/startup probe failure, preemption, resource contention, etc. The handler is not called if the container crashes or exits. The Pod's termination grace period countdown begins before the PreStop hook is executed. Regardless of the outcome of the handler, the container will eventually terminate within the Pod's termination grace period (unless delayed by finalizers). Other management of the container blocks until the hook completes or until the termination grace period is reached. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks
        :param _builtins.str stop_signal: StopSignal defines which signal will be sent to a container when it is being stopped. If not specified, the default is defined by the container runtime in use. StopSignal can only be set for Pods with a non-empty .spec.os.name
        """
        if post_start is not None:
            pulumi.set(__self__, "post_start", post_start)
        if pre_stop is not None:
            pulumi.set(__self__, "pre_stop", pre_stop)
        if stop_signal is not None:
            pulumi.set(__self__, "stop_signal", stop_signal)

    @_builtins.property
    @pulumi.getter(name="postStart")
    def post_start(self) -> Optional['outputs.LifecycleHandlerPatch']:
        """
        PostStart is called immediately after a container is created. If the handler fails, the container is terminated and restarted according to its restart policy. Other management of the container blocks until the hook completes. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks
        """
        return pulumi.get(self, "post_start")

    @_builtins.property
    @pulumi.getter(name="preStop")
    def pre_stop(self) -> Optional['outputs.LifecycleHandlerPatch']:
        """
        PreStop is called immediately before a container is terminated due to an API request or management event such as liveness/startup probe failure, preemption, resource contention, etc. The handler is not called if the container crashes or exits. The Pod's termination grace period countdown begins before the PreStop hook is executed. Regardless of the outcome of the handler, the container will eventually terminate within the Pod's termination grace period (unless delayed by finalizers). Other management of the container blocks until the hook completes or until the termination grace period is reached. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks
        """
        return pulumi.get(self, "pre_stop")

    @_builtins.property
    @pulumi.getter(name="stopSignal")
    def stop_signal(self) -> Optional[_builtins.str]:
        """
        StopSignal defines which signal will be sent to a container when it is being stopped. If not specified, the default is defined by the container runtime in use. StopSignal can only be set for Pods with a non-empty .spec.os.name
        """
        return pulumi.get(self, "stop_signal")


@pulumi.output_type
class LimitRange(dict):
    """
    LimitRange sets resource usage limits for each kind of resource in a Namespace.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LimitRange. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LimitRange.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LimitRange.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[_builtins.str] = None,
                 kind: Optional[_builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.LimitRangeSpec'] = None):
        """
        LimitRange sets resource usage limits for each kind of resource in a Namespace.
        :param _builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param _builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param 'LimitRangeSpecArgs' spec: Spec defines the limits enforced. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'LimitRange')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[_builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[_builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional['outputs.LimitRangeSpec']:
        """
        Spec defines the limits enforced. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "spec")


@pulumi.output_type
class LimitRangeItem(dict):
    """
    LimitRangeItem defines a min/max usage limit for any resource that matches on kind.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultRequest":
            suggest = "default_request"
        elif key == "maxLimitRequestRatio":
            suggest = "max_limit_request_ratio"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LimitRangeItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LimitRangeItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LimitRangeItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 default: Optional[Mapping[str, _builtins.str]] = None,
                 default_request: Optional[Mapping[str, _builtins.str]] = None,
                 max: Optional[Mapping[str, _builtins.str]] = None,
                 max_limit_request_ratio: Optional[Mapping[str, _builtins.str]] = None,
                 min: Optional[Mapping[str, _builtins.str]] = None):
        """
        LimitRangeItem defines a min/max usage limit for any resource that matches on kind.
        :param _builtins.str type: Type of resource that this limit applies to.
        :param Mapping[str, _builtins.str] default: Default resource requirement limit value by resource name if resource limit is omitted.
        :param Mapping[str, _builtins.str] default_request: DefaultRequest is the default resource requirement request value by resource name if resource request is omitted.
        :param Mapping[str, _builtins.str] max: Max usage constraints on this kind by resource name.
        :param Mapping[str, _builtins.str] max_limit_request_ratio: MaxLimitRequestRatio if specified, the named resource must have a request and limit that are both non-zero where limit divided by request is less than or equal to the enumerated value; this represents the max burst for the named resource.
        :param Mapping[str, _builtins.str] min: Min usage constraints on this kind by resource name.
        """
        pulumi.set(__self__, "type", type)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if default_request is not None:
            pulumi.set(__self__, "default_request", default_request)
        if max is not None:
            pulumi.set(__self__, "max", max)
        if max_limit_request_ratio is not None:
            pulumi.set(__self__, "max_limit_request_ratio", max_limit_request_ratio)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of resource that this limit applies to.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def default(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Default resource requirement limit value by resource name if resource limit is omitted.
        """
        return pulumi.get(self, "default")

    @_builtins.property
    @pulumi.getter(name="defaultRequest")
    def default_request(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        DefaultRequest is the default resource requirement request value by resource name if resource request is omitted.
        """
        return pulumi.get(self, "default_request")

    @_builtins.property
    @pulumi.getter
    def max(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Max usage constraints on this kind by resource name.
        """
        return pulumi.get(self, "max")

    @_builtins.property
    @pulumi.getter(name="maxLimitRequestRatio")
    def max_limit_request_ratio(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        MaxLimitRequestRatio if specified, the named resource must have a request and limit that are both non-zero where limit divided by request is less than or equal to the enumerated value; this represents the max burst for the named resource.
        """
        return pulumi.get(self, "max_limit_request_ratio")

    @_builtins.property
    @pulumi.getter
    def min(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Min usage constraints on this kind by resource name.
        """
        return pulumi.get(self, "min")


@pulumi.output_type
class LimitRangeItemPatch(dict):
    """
    LimitRangeItem defines a min/max usage limit for any resource that matches on kind.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultRequest":
            suggest = "default_request"
        elif key == "maxLimitRequestRatio":
            suggest = "max_limit_request_ratio"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LimitRangeItemPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LimitRangeItemPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LimitRangeItemPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default: Optional[Mapping[str, _builtins.str]] = None,
                 default_request: Optional[Mapping[str, _builtins.str]] = None,
                 max: Optional[Mapping[str, _builtins.str]] = None,
                 max_limit_request_ratio: Optional[Mapping[str, _builtins.str]] = None,
                 min: Optional[Mapping[str, _builtins.str]] = None,
                 type: Optional[_builtins.str] = None):
        """
        LimitRangeItem defines a min/max usage limit for any resource that matches on kind.
        :param Mapping[str, _builtins.str] default: Default resource requirement limit value by resource name if resource limit is omitted.
        :param Mapping[str, _builtins.str] default_request: DefaultRequest is the default resource requirement request value by resource name if resource request is omitted.
        :param Mapping[str, _builtins.str] max: Max usage constraints on this kind by resource name.
        :param Mapping[str, _builtins.str] max_limit_request_ratio: MaxLimitRequestRatio if specified, the named resource must have a request and limit that are both non-zero where limit divided by request is less than or equal to the enumerated value; this represents the max burst for the named resource.
        :param Mapping[str, _builtins.str] min: Min usage constraints on this kind by resource name.
        :param _builtins.str type: Type of resource that this limit applies to.
        """
        if default is not None:
            pulumi.set(__self__, "default", default)
        if default_request is not None:
            pulumi.set(__self__, "default_request", default_request)
        if max is not None:
            pulumi.set(__self__, "max", max)
        if max_limit_request_ratio is not None:
            pulumi.set(__self__, "max_limit_request_ratio", max_limit_request_ratio)
        if min is not None:
            pulumi.set(__self__, "min", min)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def default(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Default resource requirement limit value by resource name if resource limit is omitted.
        """
        return pulumi.get(self, "default")

    @_builtins.property
    @pulumi.getter(name="defaultRequest")
    def default_request(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        DefaultRequest is the default resource requirement request value by resource name if resource request is omitted.
        """
        return pulumi.get(self, "default_request")

    @_builtins.property
    @pulumi.getter
    def max(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Max usage constraints on this kind by resource name.
        """
        return pulumi.get(self, "max")

    @_builtins.property
    @pulumi.getter(name="maxLimitRequestRatio")
    def max_limit_request_ratio(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        MaxLimitRequestRatio if specified, the named resource must have a request and limit that are both non-zero where limit divided by request is less than or equal to the enumerated value; this represents the max burst for the named resource.
        """
        return pulumi.get(self, "max_limit_request_ratio")

    @_builtins.property
    @pulumi.getter
    def min(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Min usage constraints on this kind by resource name.
        """
        return pulumi.get(self, "min")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of resource that this limit applies to.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class LimitRangeSpec(dict):
    """
    LimitRangeSpec defines a min/max usage limit for resources that match on kind.
    """
    def __init__(__self__, *,
                 limits: Sequence['outputs.LimitRangeItem']):
        """
        LimitRangeSpec defines a min/max usage limit for resources that match on kind.
        :param Sequence['LimitRangeItemArgs'] limits: Limits is the list of LimitRangeItem objects that are enforced.
        """
        pulumi.set(__self__, "limits", limits)

    @_builtins.property
    @pulumi.getter
    def limits(self) -> Sequence['outputs.LimitRangeItem']:
        """
        Limits is the list of LimitRangeItem objects that are enforced.
        """
        return pulumi.get(self, "limits")


@pulumi.output_type
class LimitRangeSpecPatch(dict):
    """
    LimitRangeSpec defines a min/max usage limit for resources that match on kind.
    """
    def __init__(__self__, *,
                 limits: Optional[Sequence['outputs.LimitRangeItemPatch']] = None):
        """
        LimitRangeSpec defines a min/max usage limit for resources that match on kind.
        :param Sequence['LimitRangeItemPatchArgs'] limits: Limits is the list of LimitRangeItem objects that are enforced.
        """
        if limits is not None:
            pulumi.set(__self__, "limits", limits)

    @_builtins.property
    @pulumi.getter
    def limits(self) -> Optional[Sequence['outputs.LimitRangeItemPatch']]:
        """
        Limits is the list of LimitRangeItem objects that are enforced.
        """
        return pulumi.get(self, "limits")


@pulumi.output_type
class LinuxContainerUser(dict):
    """
    LinuxContainerUser represents user identity information in Linux containers
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "supplementalGroups":
            suggest = "supplemental_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinuxContainerUser. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinuxContainerUser.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinuxContainerUser.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gid: _builtins.int,
                 uid: _builtins.int,
                 supplemental_groups: Optional[Sequence[_builtins.int]] = None):
        """
        LinuxContainerUser represents user identity information in Linux containers
        :param _builtins.int gid: GID is the primary gid initially attached to the first process in the container
        :param _builtins.int uid: UID is the primary uid initially attached to the first process in the container
        :param Sequence[_builtins.int] supplemental_groups: SupplementalGroups are the supplemental groups initially attached to the first process in the container
        """
        pulumi.set(__self__, "gid", gid)
        pulumi.set(__self__, "uid", uid)
        if supplemental_groups is not None:
            pulumi.set(__self__, "supplemental_groups", supplemental_groups)

    @_builtins.property
    @pulumi.getter
    def gid(self) -> _builtins.int:
        """
        GID is the primary gid initially attached to the first process in the container
        """
        return pulumi.get(self, "gid")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> _builtins.int:
        """
        UID is the primary uid initially attached to the first process in the container
        """
        return pulumi.get(self, "uid")

    @_builtins.property
    @pulumi.getter(name="supplementalGroups")
    def supplemental_groups(self) -> Optional[Sequence[_builtins.int]]:
        """
        SupplementalGroups are the supplemental groups initially attached to the first process in the container
        """
        return pulumi.get(self, "supplemental_groups")


@pulumi.output_type
class LinuxContainerUserPatch(dict):
    """
    LinuxContainerUser represents user identity information in Linux containers
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "supplementalGroups":
            suggest = "supplemental_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinuxContainerUserPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinuxContainerUserPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinuxContainerUserPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gid: Optional[_builtins.int] = None,
                 supplemental_groups: Optional[Sequence[_builtins.int]] = None,
                 uid: Optional[_builtins.int] = None):
        """
        LinuxContainerUser represents user identity information in Linux containers
        :param _builtins.int gid: GID is the primary gid initially attached to the first process in the container
        :param Sequence[_builtins.int] supplemental_groups: SupplementalGroups are the supplemental groups initially attached to the first process in the container
        :param _builtins.int uid: UID is the primary uid initially attached to the first process in the container
        """
        if gid is not None:
            pulumi.set(__self__, "gid", gid)
        if supplemental_groups is not None:
            pulumi.set(__self__, "supplemental_groups", supplemental_groups)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @_builtins.property
    @pulumi.getter
    def gid(self) -> Optional[_builtins.int]:
        """
        GID is the primary gid initially attached to the first process in the container
        """
        return pulumi.get(self, "gid")

    @_builtins.property
    @pulumi.getter(name="supplementalGroups")
    def supplemental_groups(self) -> Optional[Sequence[_builtins.int]]:
        """
        SupplementalGroups are the supplemental groups initially attached to the first process in the container
        """
        return pulumi.get(self, "supplemental_groups")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[_builtins.int]:
        """
        UID is the primary uid initially attached to the first process in the container
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class LoadBalancerIngress(dict):
    """
    LoadBalancerIngress represents the status of a load-balancer ingress point: traffic intended for the service should be sent to an ingress point.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipMode":
            suggest = "ip_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerIngress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerIngress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerIngress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hostname: Optional[_builtins.str] = None,
                 ip: Optional[_builtins.str] = None,
                 ip_mode: Optional[_builtins.str] = None,
                 ports: Optional[Sequence['outputs.PortStatus']] = None):
        """
        LoadBalancerIngress represents the status of a load-balancer ingress point: traffic intended for the service should be sent to an ingress point.
        :param _builtins.str hostname: Hostname is set for load-balancer ingress points that are DNS based (typically AWS load-balancers)
        :param _builtins.str ip: IP is set for load-balancer ingress points that are IP based (typically GCE or OpenStack load-balancers)
        :param _builtins.str ip_mode: IPMode specifies how the load-balancer IP behaves, and may only be specified when the ip field is specified. Setting this to "VIP" indicates that traffic is delivered to the node with the destination set to the load-balancer's IP and port. Setting this to "Proxy" indicates that traffic is delivered to the node or pod with the destination set to the node's IP and node port or the pod's IP and port. Service implementations may use this information to adjust traffic routing.
        :param Sequence['PortStatusArgs'] ports: Ports is a list of records of service ports If used, every port defined in the service should have an entry in it
        """
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_mode is not None:
            pulumi.set(__self__, "ip_mode", ip_mode)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[_builtins.str]:
        """
        Hostname is set for load-balancer ingress points that are DNS based (typically AWS load-balancers)
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[_builtins.str]:
        """
        IP is set for load-balancer ingress points that are IP based (typically GCE or OpenStack load-balancers)
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="ipMode")
    def ip_mode(self) -> Optional[_builtins.str]:
        """
        IPMode specifies how the load-balancer IP behaves, and may only be specified when the ip field is specified. Setting this to "VIP" indicates that traffic is delivered to the node with the destination set to the load-balancer's IP and port. Setting this to "Proxy" indicates that traffic is delivered to the node or pod with the destination set to the node's IP and node port or the pod's IP and port. Service implementations may use this information to adjust traffic routing.
        """
        return pulumi.get(self, "ip_mode")

    @_builtins.property
    @pulumi.getter
    def ports(self) -> Optional[Sequence['outputs.PortStatus']]:
        """
        Ports is a list of records of service ports If used, every port defined in the service should have an entry in it
        """
        return pulumi.get(self, "ports")


@pulumi.output_type
class LoadBalancerIngressPatch(dict):
    """
    LoadBalancerIngress represents the status of a load-balancer ingress point: traffic intended for the service should be sent to an ingress point.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipMode":
            suggest = "ip_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerIngressPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerIngressPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerIngressPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hostname: Optional[_builtins.str] = None,
                 ip: Optional[_builtins.str] = None,
                 ip_mode: Optional[_builtins.str] = None,
                 ports: Optional[Sequence['outputs.PortStatusPatch']] = None):
        """
        LoadBalancerIngress represents the status of a load-balancer ingress point: traffic intended for the service should be sent to an ingress point.
        :param _builtins.str hostname: Hostname is set for load-balancer ingress points that are DNS based (typically AWS load-balancers)
        :param _builtins.str ip: IP is set for load-balancer ingress points that are IP based (typically GCE or OpenStack load-balancers)
        :param _builtins.str ip_mode: IPMode specifies how the load-balancer IP behaves, and may only be specified when the ip field is specified. Setting this to "VIP" indicates that traffic is delivered to the node with the destination set to the load-balancer's IP and port. Setting this to "Proxy" indicates that traffic is delivered to the node or pod with the destination set to the node's IP and node port or the pod's IP and port. Service implementations may use this information to adjust traffic routing.
        :param Sequence['PortStatusPatchArgs'] ports: Ports is a list of records of service ports If used, every port defined in the service should have an entry in it
        """
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_mode is not None:
            pulumi.set(__self__, "ip_mode", ip_mode)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[_builtins.str]:
        """
        Hostname is set for load-balancer ingress points that are DNS based (typically AWS load-balancers)
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[_builtins.str]:
        """
        IP is set for load-balancer ingress points that are IP based (typically GCE or OpenStack load-balancers)
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="ipMode")
    def ip_mode(self) -> Optional[_builtins.str]:
        """
        IPMode specifies how the load-balancer IP behaves, and may only be specified when the ip field is specified. Setting this to "VIP" indicates that traffic is delivered to the node with the destination set to the load-balancer's IP and port. Setting this to "Proxy" indicates that traffic is delivered to the node or pod with the destination set to the node's IP and node port or the pod's IP and port. Service implementations may use this information to adjust traffic routing.
        """
        return pulumi.get(self, "ip_mode")

    @_builtins.property
    @pulumi.getter
    def ports(self) -> Optional[Sequence['outputs.PortStatusPatch']]:
        """
        Ports is a list of records of service ports If used, every port defined in the service should have an entry in it
        """
        return pulumi.get(self, "ports")


@pulumi.output_type
class LoadBalancerStatus(dict):
    """
    LoadBalancerStatus represents the status of a load-balancer.
    """
    def __init__(__self__, *,
                 ingress: Optional[Sequence['outputs.LoadBalancerIngress']] = None):
        """
        LoadBalancerStatus represents the status of a load-balancer.
        :param Sequence['LoadBalancerIngressArgs'] ingress: Ingress is a list containing ingress points for the load-balancer. Traffic intended for the service should be sent to these ingress points.
        """
        if ingress is not None:
            pulumi.set(__self__, "ingress", ingress)

    @_builtins.property
    @pulumi.getter
    def ingress(self) -> Optional[Sequence['outputs.LoadBalancerIngress']]:
        """
        Ingress is a list containing ingress points for the load-balancer. Traffic intended for the service should be sent to these ingress points.
        """
        return pulumi.get(self, "ingress")


@pulumi.output_type
class LoadBalancerStatusPatch(dict):
    """
    LoadBalancerStatus represents the status of a load-balancer.
    """
    def __init__(__self__, *,
                 ingress: Optional[Sequence['outputs.LoadBalancerIngressPatch']] = None):
        """
        LoadBalancerStatus represents the status of a load-balancer.
        :param Sequence['LoadBalancerIngressPatchArgs'] ingress: Ingress is a list containing ingress points for the load-balancer. Traffic intended for the service should be sent to these ingress points.
        """
        if ingress is not None:
            pulumi.set(__self__, "ingress", ingress)

    @_builtins.property
    @pulumi.getter
    def ingress(self) -> Optional[Sequence['outputs.LoadBalancerIngressPatch']]:
        """
        Ingress is a list containing ingress points for the load-balancer. Traffic intended for the service should be sent to these ingress points.
        """
        return pulumi.get(self, "ingress")


@pulumi.output_type
class LocalObjectReference(dict):
    """
    LocalObjectReference contains enough information to let you locate the referenced object inside the same namespace.
    """
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None):
        """
        LocalObjectReference contains enough information to let you locate the referenced object inside the same namespace.
        :param _builtins.str name: Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class LocalObjectReferencePatch(dict):
    """
    LocalObjectReference contains enough information to let you locate the referenced object inside the same namespace.
    """
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None):
        """
        LocalObjectReference contains enough information to let you locate the referenced object inside the same namespace.
        :param _builtins.str name: Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the referent. This field is effectively required, but due to backwards compatibility is allowed to be empty. Instances of this type with an empty value here are almost certainly wrong. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class LocalVolumeSource(dict):
    """
    Local represents directly-attached storage with node affinity
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fsType":
            suggest = "fs_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LocalVolumeSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LocalVolumeSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LocalVolumeSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path: _builtins.str,
                 fs_type: Optional[_builtins.str] = None):
        """
        Local represents directly-attached storage with node affinity
        :param _builtins.str path: path of the full path to the volume on the node. It can be either a directory or block device (disk, partition, ...).
        :param _builtins.str fs_type: fsType is the filesystem type to mount. It applies only when the Path is a block device. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default value is to auto-select a filesystem if unspecified.
        """
        pulumi.set(__self__, "path", path)
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        path of the full path to the volume on the node. It can be either a directory or block device (disk, partition, ...).
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[_builtins.str]:
        """
        fsType is the filesystem type to mount. It applies only when the Path is a block device. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default value is to auto-select a filesystem if unspecified.
        """
        return pulumi.get(self, "fs_type")


@pulumi.output_type
class LocalVolumeSourcePatch(dict):
    """
    Local represents directly-attached storage with node affinity
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fsType":
            suggest = "fs_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LocalVolumeSourcePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LocalVolumeSourcePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LocalVolumeSourcePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fs_type: Optional[_builtins.str] = None,
                 path: Optional[_builtins.str] = None):
        """
        Local represents directly-attached storage with node affinity
        :param _builtins.str fs_type: fsType is the filesystem type to mount. It applies only when the Path is a block device. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default value is to auto-select a filesystem if unspecified.
        :param _builtins.str path: path of the full path to the volume on the node. It can be either a directory or block device (disk, partition, ...).
        """
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @_builtins.property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[_builtins.str]:
        """
        fsType is the filesystem type to mount. It applies only when the Path is a block device. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default value is to auto-select a filesystem if unspecified.
        """
        return pulumi.get(self, "fs_type")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        path of the full path to the volume on the node. It can be either a directory or block device (disk, partition, ...).
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class ModifyVolumeStatus(dict):
    """
    ModifyVolumeStatus represents the status object of ControllerModifyVolume operation
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetVolumeAttributesClassName":
            suggest = "target_volume_attributes_class_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModifyVolumeStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModifyVolumeStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModifyVolumeStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status: _builtins.str,
                 target_volume_attributes_class_name: Optional[_builtins.str] = None):
        """
        ModifyVolumeStatus represents the status object of ControllerModifyVolume operation
        :param _builtins.str status: status is the status of the ControllerModifyVolume operation. It can be in any of following states:
                - Pending
                  Pending indicates that the PersistentVolumeClaim cannot be modified due to unmet requirements, such as
                  the specified VolumeAttributesClass not existing.
                - InProgress
                  InProgress indicates that the volume is being modified.
                - Infeasible
                 Infeasible indicates that the request has been rejected as invalid by the CSI driver. To
               	  resolve the error, a valid VolumeAttributesClass needs to be specified.
               Note: New statuses can be added in the future. Consumers should check for unknown statuses and fail appropriately.
        :param _builtins.str target_volume_attributes_class_name: targetVolumeAttributesClassName is the name of the VolumeAttributesClass the PVC currently being reconciled
        """
        pulumi.set(__self__, "status", status)
        if target_volume_attributes_class_name is not None:
            pulumi.set(__self__, "target_volume_attributes_class_name", target_volume_attributes_class_name)

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        status is the status of the ControllerModifyVolume operation. It can be in any of following states:
         - Pending
           Pending indicates that the PersistentVolumeClaim cannot be modified due to unmet requirements, such as
           the specified VolumeAttributesClass not existing.
         - InProgress
           InProgress indicates that the volume is being modified.
         - Infeasible
          Infeasible indicates that the request has been rejected as invalid by the CSI driver. To
        	  resolve the error, a valid VolumeAttributesClass needs to be specified.
        Note: New statuses can be added in the future. Consumers should check for unknown statuses and fail appropriately.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="targetVolumeAttributesClassName")
    def target_volume_attributes_class_name(self) -> Optional[_builtins.str]:
        """
        targetVolumeAttributesClassName is the name of the VolumeAttributesClass the PVC currently being reconciled
        """
        return pulumi.get(self, "target_volume_attributes_class_name")


@pulumi.output_type
class ModifyVolumeStatusPatch(dict):
    """
    ModifyVolumeStatus represents the status object of ControllerModifyVolume operation
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetVolumeAttributesClassName":
            suggest = "target_volume_attributes_class_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModifyVolumeStatusPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModifyVolumeStatusPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModifyVolumeStatusPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status: Optional[_builtins.str] = None,
                 target_volume_attributes_class_name: Optional[_builtins.str] = None):
        """
        ModifyVolumeStatus represents the status object of ControllerModifyVolume operation
        :param _builtins.str status: status is the status of the ControllerModifyVolume operation. It can be in any of following states:
                - Pending
                  Pending indicates that the PersistentVolumeClaim cannot be modified due to unmet requirements, such as
                  the specified VolumeAttributesClass not existing.
                - InProgress
                  InProgress indicates that the volume is being modified.
                - Infeasible
                 Infeasible indicates that the request has been rejected as invalid by the CSI driver. To
               	  resolve the error, a valid VolumeAttributesClass needs to be specified.
               Note: New statuses can be added in the future. Consumers should check for unknown statuses and fail appropriately.
        :param _builtins.str target_volume_attributes_class_name: targetVolumeAttributesClassName is the name of the VolumeAttributesClass the PVC currently being reconciled
        """
        if status is not None:
            pulumi.set(__self__, "status", status)
        if target_volume_attributes_class_name is not None:
            pulumi.set(__self__, "target_volume_attributes_class_name", target_volume_attributes_class_name)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        status is the status of the ControllerModifyVolume operation. It can be in any of following states:
         - Pending
           Pending indicates that the PersistentVolumeClaim cannot be modified due to unmet requirements, such as
           the specified VolumeAttributesClass not existing.
         - InProgress
           InProgress indicates that the volume is being modified.
         - Infeasible
          Infeasible indicates that the request has been rejected as invalid by the CSI driver. To
        	  resolve the error, a valid VolumeAttributesClass needs to be specified.
        Note: New statuses can be added in the future. Consumers should check for unknown statuses and fail appropriately.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="targetVolumeAttributesClassName")
    def target_volume_attributes_class_name(self) -> Optional[_builtins.str]:
        """
        targetVolumeAttributesClassName is the name of the VolumeAttributesClass the PVC currently being reconciled
        """
        return pulumi.get(self, "target_volume_attributes_class_name")


@pulumi.output_type
class NFSVolumeSource(dict):
    """
    Represents an NFS mount that lasts the lifetime of a pod. NFS volumes do not support ownership management or SELinux relabeling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "readOnly":
            suggest = "read_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NFSVolumeSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NFSVolumeSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NFSVolumeSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path: _builtins.str,
                 server: _builtins.str,
                 read_only: Optional[_builtins.bool] = None):
        """
        Represents an NFS mount that lasts the lifetime of a pod. NFS volumes do not support ownership management or SELinux relabeling.
        :param _builtins.str path: path that is exported by the NFS server. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
        :param _builtins.str server: server is the hostname or IP address of the NFS server. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
        :param _builtins.bool read_only: readOnly here will force the NFS export to be mounted with read-only permissions. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "server", server)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        path that is exported by the NFS server. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def server(self) -> _builtins.str:
        """
        server is the hostname or IP address of the NFS server. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
        """
        return pulumi.get(self, "server")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        readOnly here will force the NFS export to be mounted with read-only permissions. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
        """
        return pulumi.get(self, "read_only")


@pulumi.output_type
class NFSVolumeSourcePatch(dict):
    """
    Represents an NFS mount that lasts the lifetime of a pod. NFS volumes do not support ownership management or SELinux relabeling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "readOnly":
            suggest = "read_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NFSVolumeSourcePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NFSVolumeSourcePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NFSVolumeSourcePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path: Optional[_builtins.str] = None,
                 read_only: Optional[_builtins.bool] = None,
                 server: Optional[_builtins.str] = None):
        """
        Represents an NFS mount that lasts the lifetime of a pod. NFS volumes do not support ownership management or SELinux relabeling.
        :param _builtins.str path: path that is exported by the NFS server. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
        :param _builtins.bool read_only: readOnly here will force the NFS export to be mounted with read-only permissions. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
        :param _builtins.str server: server is the hostname or IP address of the NFS server. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
        """
        if path is not None:
            pulumi.set(__self__, "path", path)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if server is not None:
            pulumi.set(__self__, "server", server)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        path that is exported by the NFS server. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        readOnly here will force the NFS export to be mounted with read-only permissions. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter
    def server(self) -> Optional[_builtins.str]:
        """
        server is the hostname or IP address of the NFS server. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
        """
        return pulumi.get(self, "server")


@pulumi.output_type
class Namespace(dict):
    """
    Namespace provides a scope for Names. Use of multiple namespaces is optional.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Namespace. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Namespace.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Namespace.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[_builtins.str] = None,
                 kind: Optional[_builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.NamespaceSpec'] = None,
                 status: Optional['outputs.NamespaceStatus'] = None):
        """
        Namespace provides a scope for Names. Use of multiple namespaces is optional.
        :param _builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param _builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param 'NamespaceSpecArgs' spec: Spec defines the behavior of the Namespace. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        :param 'NamespaceStatusArgs' status: Status describes the current status of a Namespace. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'Namespace')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[_builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[_builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional['outputs.NamespaceSpec']:
        """
        Spec defines the behavior of the Namespace. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "spec")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional['outputs.NamespaceStatus']:
        """
        Status describes the current status of a Namespace. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class NamespaceCondition(dict):
    """
    NamespaceCondition contains details about state of namespace.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastTransitionTime":
            suggest = "last_transition_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NamespaceCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NamespaceCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NamespaceCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status: _builtins.str,
                 type: _builtins.str,
                 last_transition_time: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None):
        """
        NamespaceCondition contains details about state of namespace.
        :param _builtins.str status: Status of the condition, one of True, False, Unknown.
        :param _builtins.str type: Type of namespace controller condition.
        :param _builtins.str last_transition_time: Last time the condition transitioned from one status to another.
        :param _builtins.str message: Human-readable message indicating details about last transition.
        :param _builtins.str reason: Unique, one-word, CamelCase reason for the condition's last transition.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of namespace controller condition.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[_builtins.str]:
        """
        Last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        Human-readable message indicating details about last transition.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        Unique, one-word, CamelCase reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")


@pulumi.output_type
class NamespaceConditionPatch(dict):
    """
    NamespaceCondition contains details about state of namespace.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastTransitionTime":
            suggest = "last_transition_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NamespaceConditionPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NamespaceConditionPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NamespaceConditionPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_transition_time: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        NamespaceCondition contains details about state of namespace.
        :param _builtins.str last_transition_time: Last time the condition transitioned from one status to another.
        :param _builtins.str message: Human-readable message indicating details about last transition.
        :param _builtins.str reason: Unique, one-word, CamelCase reason for the condition's last transition.
        :param _builtins.str status: Status of the condition, one of True, False, Unknown.
        :param _builtins.str type: Type of namespace controller condition.
        """
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[_builtins.str]:
        """
        Last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        Human-readable message indicating details about last transition.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        Unique, one-word, CamelCase reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of namespace controller condition.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class NamespaceSpec(dict):
    """
    NamespaceSpec describes the attributes on a Namespace.
    """
    def __init__(__self__, *,
                 finalizers: Optional[Sequence[_builtins.str]] = None):
        """
        NamespaceSpec describes the attributes on a Namespace.
        :param Sequence[_builtins.str] finalizers: Finalizers is an opaque list of values that must be empty to permanently remove object from storage. More info: https://kubernetes.io/docs/tasks/administer-cluster/namespaces/
        """
        if finalizers is not None:
            pulumi.set(__self__, "finalizers", finalizers)

    @_builtins.property
    @pulumi.getter
    def finalizers(self) -> Optional[Sequence[_builtins.str]]:
        """
        Finalizers is an opaque list of values that must be empty to permanently remove object from storage. More info: https://kubernetes.io/docs/tasks/administer-cluster/namespaces/
        """
        return pulumi.get(self, "finalizers")


@pulumi.output_type
class NamespaceSpecPatch(dict):
    """
    NamespaceSpec describes the attributes on a Namespace.
    """
    def __init__(__self__, *,
                 finalizers: Optional[Sequence[_builtins.str]] = None):
        """
        NamespaceSpec describes the attributes on a Namespace.
        :param Sequence[_builtins.str] finalizers: Finalizers is an opaque list of values that must be empty to permanently remove object from storage. More info: https://kubernetes.io/docs/tasks/administer-cluster/namespaces/
        """
        if finalizers is not None:
            pulumi.set(__self__, "finalizers", finalizers)

    @_builtins.property
    @pulumi.getter
    def finalizers(self) -> Optional[Sequence[_builtins.str]]:
        """
        Finalizers is an opaque list of values that must be empty to permanently remove object from storage. More info: https://kubernetes.io/docs/tasks/administer-cluster/namespaces/
        """
        return pulumi.get(self, "finalizers")


@pulumi.output_type
class NamespaceStatus(dict):
    """
    NamespaceStatus is information about the current status of a Namespace.
    """
    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.NamespaceCondition']] = None,
                 phase: Optional[_builtins.str] = None):
        """
        NamespaceStatus is information about the current status of a Namespace.
        :param Sequence['NamespaceConditionArgs'] conditions: Represents the latest available observations of a namespace's current state.
        :param _builtins.str phase: Phase is the current lifecycle phase of the namespace. More info: https://kubernetes.io/docs/tasks/administer-cluster/namespaces/
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if phase is not None:
            pulumi.set(__self__, "phase", phase)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.NamespaceCondition']]:
        """
        Represents the latest available observations of a namespace's current state.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter
    def phase(self) -> Optional[_builtins.str]:
        """
        Phase is the current lifecycle phase of the namespace. More info: https://kubernetes.io/docs/tasks/administer-cluster/namespaces/
        """
        return pulumi.get(self, "phase")


@pulumi.output_type
class NamespaceStatusPatch(dict):
    """
    NamespaceStatus is information about the current status of a Namespace.
    """
    def __init__(__self__, *,
                 conditions: Optional[Sequence['outputs.NamespaceConditionPatch']] = None,
                 phase: Optional[_builtins.str] = None):
        """
        NamespaceStatus is information about the current status of a Namespace.
        :param Sequence['NamespaceConditionPatchArgs'] conditions: Represents the latest available observations of a namespace's current state.
        :param _builtins.str phase: Phase is the current lifecycle phase of the namespace. More info: https://kubernetes.io/docs/tasks/administer-cluster/namespaces/
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if phase is not None:
            pulumi.set(__self__, "phase", phase)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.NamespaceConditionPatch']]:
        """
        Represents the latest available observations of a namespace's current state.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter
    def phase(self) -> Optional[_builtins.str]:
        """
        Phase is the current lifecycle phase of the namespace. More info: https://kubernetes.io/docs/tasks/administer-cluster/namespaces/
        """
        return pulumi.get(self, "phase")


@pulumi.output_type
class Node(dict):
    """
    Node is a worker node in Kubernetes. Each node will have a unique identifier in the cache (i.e. in etcd).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Node. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Node.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Node.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[_builtins.str] = None,
                 kind: Optional[_builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.NodeSpec'] = None,
                 status: Optional['outputs.NodeStatus'] = None):
        """
        Node is a worker node in Kubernetes. Each node will have a unique identifier in the cache (i.e. in etcd).
        :param _builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param _builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param 'NodeSpecArgs' spec: Spec defines the behavior of a node. https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        :param 'NodeStatusArgs' status: Most recently observed status of the node. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'Node')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[_builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[_builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional['outputs.NodeSpec']:
        """
        Spec defines the behavior of a node. https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "spec")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional['outputs.NodeStatus']:
        """
        Most recently observed status of the node. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class NodeAddress(dict):
    """
    NodeAddress contains information for the node's address.
    """
    def __init__(__self__, *,
                 address: _builtins.str,
                 type: _builtins.str):
        """
        NodeAddress contains information for the node's address.
        :param _builtins.str address: The node address.
        :param _builtins.str type: Node address type, one of Hostname, ExternalIP or InternalIP.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The node address.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Node address type, one of Hostname, ExternalIP or InternalIP.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class NodeAddressPatch(dict):
    """
    NodeAddress contains information for the node's address.
    """
    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        NodeAddress contains information for the node's address.
        :param _builtins.str address: The node address.
        :param _builtins.str type: Node address type, one of Hostname, ExternalIP or InternalIP.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        The node address.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Node address type, one of Hostname, ExternalIP or InternalIP.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class NodeAffinity(dict):
    """
    Node affinity is a group of node affinity scheduling rules.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "preferredDuringSchedulingIgnoredDuringExecution":
            suggest = "preferred_during_scheduling_ignored_during_execution"
        elif key == "requiredDuringSchedulingIgnoredDuringExecution":
            suggest = "required_during_scheduling_ignored_during_execution"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeAffinity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeAffinity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeAffinity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 preferred_during_scheduling_ignored_during_execution: Optional[Sequence['outputs.PreferredSchedulingTerm']] = None,
                 required_during_scheduling_ignored_during_execution: Optional['outputs.NodeSelector'] = None):
        """
        Node affinity is a group of node affinity scheduling rules.
        :param Sequence['PreferredSchedulingTermArgs'] preferred_during_scheduling_ignored_during_execution: The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding "weight" to the sum if the node matches the corresponding matchExpressions; the node(s) with the highest sum are the most preferred.
        :param 'NodeSelectorArgs' required_during_scheduling_ignored_during_execution: If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to an update), the system may or may not try to eventually evict the pod from its node.
        """
        if preferred_during_scheduling_ignored_during_execution is not None:
            pulumi.set(__self__, "preferred_during_scheduling_ignored_during_execution", preferred_during_scheduling_ignored_during_execution)
        if required_during_scheduling_ignored_during_execution is not None:
            pulumi.set(__self__, "required_during_scheduling_ignored_during_execution", required_during_scheduling_ignored_during_execution)

    @_builtins.property
    @pulumi.getter(name="preferredDuringSchedulingIgnoredDuringExecution")
    def preferred_during_scheduling_ignored_during_execution(self) -> Optional[Sequence['outputs.PreferredSchedulingTerm']]:
        """
        The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding "weight" to the sum if the node matches the corresponding matchExpressions; the node(s) with the highest sum are the most preferred.
        """
        return pulumi.get(self, "preferred_during_scheduling_ignored_during_execution")

    @_builtins.property
    @pulumi.getter(name="requiredDuringSchedulingIgnoredDuringExecution")
    def required_during_scheduling_ignored_during_execution(self) -> Optional['outputs.NodeSelector']:
        """
        If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to an update), the system may or may not try to eventually evict the pod from its node.
        """
        return pulumi.get(self, "required_during_scheduling_ignored_during_execution")


@pulumi.output_type
class NodeAffinityPatch(dict):
    """
    Node affinity is a group of node affinity scheduling rules.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "preferredDuringSchedulingIgnoredDuringExecution":
            suggest = "preferred_during_scheduling_ignored_during_execution"
        elif key == "requiredDuringSchedulingIgnoredDuringExecution":
            suggest = "required_during_scheduling_ignored_during_execution"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeAffinityPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeAffinityPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeAffinityPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 preferred_during_scheduling_ignored_during_execution: Optional[Sequence['outputs.PreferredSchedulingTermPatch']] = None,
                 required_during_scheduling_ignored_during_execution: Optional['outputs.NodeSelectorPatch'] = None):
        """
        Node affinity is a group of node affinity scheduling rules.
        :param Sequence['PreferredSchedulingTermPatchArgs'] preferred_during_scheduling_ignored_during_execution: The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding "weight" to the sum if the node matches the corresponding matchExpressions; the node(s) with the highest sum are the most preferred.
        :param 'NodeSelectorPatchArgs' required_during_scheduling_ignored_during_execution: If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to an update), the system may or may not try to eventually evict the pod from its node.
        """
        if preferred_during_scheduling_ignored_during_execution is not None:
            pulumi.set(__self__, "preferred_during_scheduling_ignored_during_execution", preferred_during_scheduling_ignored_during_execution)
        if required_during_scheduling_ignored_during_execution is not None:
            pulumi.set(__self__, "required_during_scheduling_ignored_during_execution", required_during_scheduling_ignored_during_execution)

    @_builtins.property
    @pulumi.getter(name="preferredDuringSchedulingIgnoredDuringExecution")
    def preferred_during_scheduling_ignored_during_execution(self) -> Optional[Sequence['outputs.PreferredSchedulingTermPatch']]:
        """
        The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding "weight" to the sum if the node matches the corresponding matchExpressions; the node(s) with the highest sum are the most preferred.
        """
        return pulumi.get(self, "preferred_during_scheduling_ignored_during_execution")

    @_builtins.property
    @pulumi.getter(name="requiredDuringSchedulingIgnoredDuringExecution")
    def required_during_scheduling_ignored_during_execution(self) -> Optional['outputs.NodeSelectorPatch']:
        """
        If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to an update), the system may or may not try to eventually evict the pod from its node.
        """
        return pulumi.get(self, "required_during_scheduling_ignored_during_execution")


@pulumi.output_type
class NodeCondition(dict):
    """
    NodeCondition contains condition information for a node.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastHeartbeatTime":
            suggest = "last_heartbeat_time"
        elif key == "lastTransitionTime":
            suggest = "last_transition_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status: _builtins.str,
                 type: _builtins.str,
                 last_heartbeat_time: Optional[_builtins.str] = None,
                 last_transition_time: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None):
        """
        NodeCondition contains condition information for a node.
        :param _builtins.str status: Status of the condition, one of True, False, Unknown.
        :param _builtins.str type: Type of node condition.
        :param _builtins.str last_heartbeat_time: Last time we got an update on a given condition.
        :param _builtins.str last_transition_time: Last time the condition transit from one status to another.
        :param _builtins.str message: Human readable message indicating details about last transition.
        :param _builtins.str reason: (brief) reason for the condition's last transition.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if last_heartbeat_time is not None:
            pulumi.set(__self__, "last_heartbeat_time", last_heartbeat_time)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of node condition.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="lastHeartbeatTime")
    def last_heartbeat_time(self) -> Optional[_builtins.str]:
        """
        Last time we got an update on a given condition.
        """
        return pulumi.get(self, "last_heartbeat_time")

    @_builtins.property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[_builtins.str]:
        """
        Last time the condition transit from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        Human readable message indicating details about last transition.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        (brief) reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")


@pulumi.output_type
class NodeConditionPatch(dict):
    """
    NodeCondition contains condition information for a node.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastHeartbeatTime":
            suggest = "last_heartbeat_time"
        elif key == "lastTransitionTime":
            suggest = "last_transition_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeConditionPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeConditionPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeConditionPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_heartbeat_time: Optional[_builtins.str] = None,
                 last_transition_time: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        NodeCondition contains condition information for a node.
        :param _builtins.str last_heartbeat_time: Last time we got an update on a given condition.
        :param _builtins.str last_transition_time: Last time the condition transit from one status to another.
        :param _builtins.str message: Human readable message indicating details about last transition.
        :param _builtins.str reason: (brief) reason for the condition's last transition.
        :param _builtins.str status: Status of the condition, one of True, False, Unknown.
        :param _builtins.str type: Type of node condition.
        """
        if last_heartbeat_time is not None:
            pulumi.set(__self__, "last_heartbeat_time", last_heartbeat_time)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="lastHeartbeatTime")
    def last_heartbeat_time(self) -> Optional[_builtins.str]:
        """
        Last time we got an update on a given condition.
        """
        return pulumi.get(self, "last_heartbeat_time")

    @_builtins.property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[_builtins.str]:
        """
        Last time the condition transit from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        Human readable message indicating details about last transition.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        (brief) reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of node condition.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class NodeConfigSource(dict):
    """
    NodeConfigSource specifies a source of node configuration. Exactly one subfield (excluding metadata) must be non-nil. This API is deprecated since 1.22
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configMap":
            suggest = "config_map"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeConfigSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeConfigSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeConfigSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_map: Optional['outputs.ConfigMapNodeConfigSource'] = None):
        """
        NodeConfigSource specifies a source of node configuration. Exactly one subfield (excluding metadata) must be non-nil. This API is deprecated since 1.22
        :param 'ConfigMapNodeConfigSourceArgs' config_map: ConfigMap is a reference to a Node's ConfigMap
        """
        if config_map is not None:
            pulumi.set(__self__, "config_map", config_map)

    @_builtins.property
    @pulumi.getter(name="configMap")
    def config_map(self) -> Optional['outputs.ConfigMapNodeConfigSource']:
        """
        ConfigMap is a reference to a Node's ConfigMap
        """
        return pulumi.get(self, "config_map")


@pulumi.output_type
class NodeConfigSourcePatch(dict):
    """
    NodeConfigSource specifies a source of node configuration. Exactly one subfield (excluding metadata) must be non-nil. This API is deprecated since 1.22
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configMap":
            suggest = "config_map"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeConfigSourcePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeConfigSourcePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeConfigSourcePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_map: Optional['outputs.ConfigMapNodeConfigSourcePatch'] = None):
        """
        NodeConfigSource specifies a source of node configuration. Exactly one subfield (excluding metadata) must be non-nil. This API is deprecated since 1.22
        :param 'ConfigMapNodeConfigSourcePatchArgs' config_map: ConfigMap is a reference to a Node's ConfigMap
        """
        if config_map is not None:
            pulumi.set(__self__, "config_map", config_map)

    @_builtins.property
    @pulumi.getter(name="configMap")
    def config_map(self) -> Optional['outputs.ConfigMapNodeConfigSourcePatch']:
        """
        ConfigMap is a reference to a Node's ConfigMap
        """
        return pulumi.get(self, "config_map")


@pulumi.output_type
class NodeConfigStatus(dict):
    """
    NodeConfigStatus describes the status of the config assigned by Node.Spec.ConfigSource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastKnownGood":
            suggest = "last_known_good"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeConfigStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeConfigStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeConfigStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active: Optional['outputs.NodeConfigSource'] = None,
                 assigned: Optional['outputs.NodeConfigSource'] = None,
                 error: Optional[_builtins.str] = None,
                 last_known_good: Optional['outputs.NodeConfigSource'] = None):
        """
        NodeConfigStatus describes the status of the config assigned by Node.Spec.ConfigSource.
        :param 'NodeConfigSourceArgs' active: Active reports the checkpointed config the node is actively using. Active will represent either the current version of the Assigned config, or the current LastKnownGood config, depending on whether attempting to use the Assigned config results in an error.
        :param 'NodeConfigSourceArgs' assigned: Assigned reports the checkpointed config the node will try to use. When Node.Spec.ConfigSource is updated, the node checkpoints the associated config payload to local disk, along with a record indicating intended config. The node refers to this record to choose its config checkpoint, and reports this record in Assigned. Assigned only updates in the status after the record has been checkpointed to disk. When the Kubelet is restarted, it tries to make the Assigned config the Active config by loading and validating the checkpointed payload identified by Assigned.
        :param _builtins.str error: Error describes any problems reconciling the Spec.ConfigSource to the Active config. Errors may occur, for example, attempting to checkpoint Spec.ConfigSource to the local Assigned record, attempting to checkpoint the payload associated with Spec.ConfigSource, attempting to load or validate the Assigned config, etc. Errors may occur at different points while syncing config. Earlier errors (e.g. download or checkpointing errors) will not result in a rollback to LastKnownGood, and may resolve across Kubelet retries. Later errors (e.g. loading or validating a checkpointed config) will result in a rollback to LastKnownGood. In the latter case, it is usually possible to resolve the error by fixing the config assigned in Spec.ConfigSource. You can find additional information for debugging by searching the error message in the Kubelet log. Error is a human-readable description of the error state; machines can check whether or not Error is empty, but should not rely on the stability of the Error text across Kubelet versions.
        :param 'NodeConfigSourceArgs' last_known_good: LastKnownGood reports the checkpointed config the node will fall back to when it encounters an error attempting to use the Assigned config. The Assigned config becomes the LastKnownGood config when the node determines that the Assigned config is stable and correct. This is currently implemented as a 10-minute soak period starting when the local record of Assigned config is updated. If the Assigned config is Active at the end of this period, it becomes the LastKnownGood. Note that if Spec.ConfigSource is reset to nil (use local defaults), the LastKnownGood is also immediately reset to nil, because the local default config is always assumed good. You should not make assumptions about the node's method of determining config stability and correctness, as this may change or become configurable in the future.
        """
        if active is not None:
            pulumi.set(__self__, "active", active)
        if assigned is not None:
            pulumi.set(__self__, "assigned", assigned)
        if error is not None:
            pulumi.set(__self__, "error", error)
        if last_known_good is not None:
            pulumi.set(__self__, "last_known_good", last_known_good)

    @_builtins.property
    @pulumi.getter
    def active(self) -> Optional['outputs.NodeConfigSource']:
        """
        Active reports the checkpointed config the node is actively using. Active will represent either the current version of the Assigned config, or the current LastKnownGood config, depending on whether attempting to use the Assigned config results in an error.
        """
        return pulumi.get(self, "active")

    @_builtins.property
    @pulumi.getter
    def assigned(self) -> Optional['outputs.NodeConfigSource']:
        """
        Assigned reports the checkpointed config the node will try to use. When Node.Spec.ConfigSource is updated, the node checkpoints the associated config payload to local disk, along with a record indicating intended config. The node refers to this record to choose its config checkpoint, and reports this record in Assigned. Assigned only updates in the status after the record has been checkpointed to disk. When the Kubelet is restarted, it tries to make the Assigned config the Active config by loading and validating the checkpointed payload identified by Assigned.
        """
        return pulumi.get(self, "assigned")

    @_builtins.property
    @pulumi.getter
    def error(self) -> Optional[_builtins.str]:
        """
        Error describes any problems reconciling the Spec.ConfigSource to the Active config. Errors may occur, for example, attempting to checkpoint Spec.ConfigSource to the local Assigned record, attempting to checkpoint the payload associated with Spec.ConfigSource, attempting to load or validate the Assigned config, etc. Errors may occur at different points while syncing config. Earlier errors (e.g. download or checkpointing errors) will not result in a rollback to LastKnownGood, and may resolve across Kubelet retries. Later errors (e.g. loading or validating a checkpointed config) will result in a rollback to LastKnownGood. In the latter case, it is usually possible to resolve the error by fixing the config assigned in Spec.ConfigSource. You can find additional information for debugging by searching the error message in the Kubelet log. Error is a human-readable description of the error state; machines can check whether or not Error is empty, but should not rely on the stability of the Error text across Kubelet versions.
        """
        return pulumi.get(self, "error")

    @_builtins.property
    @pulumi.getter(name="lastKnownGood")
    def last_known_good(self) -> Optional['outputs.NodeConfigSource']:
        """
        LastKnownGood reports the checkpointed config the node will fall back to when it encounters an error attempting to use the Assigned config. The Assigned config becomes the LastKnownGood config when the node determines that the Assigned config is stable and correct. This is currently implemented as a 10-minute soak period starting when the local record of Assigned config is updated. If the Assigned config is Active at the end of this period, it becomes the LastKnownGood. Note that if Spec.ConfigSource is reset to nil (use local defaults), the LastKnownGood is also immediately reset to nil, because the local default config is always assumed good. You should not make assumptions about the node's method of determining config stability and correctness, as this may change or become configurable in the future.
        """
        return pulumi.get(self, "last_known_good")


@pulumi.output_type
class NodeConfigStatusPatch(dict):
    """
    NodeConfigStatus describes the status of the config assigned by Node.Spec.ConfigSource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastKnownGood":
            suggest = "last_known_good"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeConfigStatusPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeConfigStatusPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeConfigStatusPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active: Optional['outputs.NodeConfigSourcePatch'] = None,
                 assigned: Optional['outputs.NodeConfigSourcePatch'] = None,
                 error: Optional[_builtins.str] = None,
                 last_known_good: Optional['outputs.NodeConfigSourcePatch'] = None):
        """
        NodeConfigStatus describes the status of the config assigned by Node.Spec.ConfigSource.
        :param 'NodeConfigSourcePatchArgs' active: Active reports the checkpointed config the node is actively using. Active will represent either the current version of the Assigned config, or the current LastKnownGood config, depending on whether attempting to use the Assigned config results in an error.
        :param 'NodeConfigSourcePatchArgs' assigned: Assigned reports the checkpointed config the node will try to use. When Node.Spec.ConfigSource is updated, the node checkpoints the associated config payload to local disk, along with a record indicating intended config. The node refers to this record to choose its config checkpoint, and reports this record in Assigned. Assigned only updates in the status after the record has been checkpointed to disk. When the Kubelet is restarted, it tries to make the Assigned config the Active config by loading and validating the checkpointed payload identified by Assigned.
        :param _builtins.str error: Error describes any problems reconciling the Spec.ConfigSource to the Active config. Errors may occur, for example, attempting to checkpoint Spec.ConfigSource to the local Assigned record, attempting to checkpoint the payload associated with Spec.ConfigSource, attempting to load or validate the Assigned config, etc. Errors may occur at different points while syncing config. Earlier errors (e.g. download or checkpointing errors) will not result in a rollback to LastKnownGood, and may resolve across Kubelet retries. Later errors (e.g. loading or validating a checkpointed config) will result in a rollback to LastKnownGood. In the latter case, it is usually possible to resolve the error by fixing the config assigned in Spec.ConfigSource. You can find additional information for debugging by searching the error message in the Kubelet log. Error is a human-readable description of the error state; machines can check whether or not Error is empty, but should not rely on the stability of the Error text across Kubelet versions.
        :param 'NodeConfigSourcePatchArgs' last_known_good: LastKnownGood reports the checkpointed config the node will fall back to when it encounters an error attempting to use the Assigned config. The Assigned config becomes the LastKnownGood config when the node determines that the Assigned config is stable and correct. This is currently implemented as a 10-minute soak period starting when the local record of Assigned config is updated. If the Assigned config is Active at the end of this period, it becomes the LastKnownGood. Note that if Spec.ConfigSource is reset to nil (use local defaults), the LastKnownGood is also immediately reset to nil, because the local default config is always assumed good. You should not make assumptions about the node's method of determining config stability and correctness, as this may change or become configurable in the future.
        """
        if active is not None:
            pulumi.set(__self__, "active", active)
        if assigned is not None:
            pulumi.set(__self__, "assigned", assigned)
        if error is not None:
            pulumi.set(__self__, "error", error)
        if last_known_good is not None:
            pulumi.set(__self__, "last_known_good", last_known_good)

    @_builtins.property
    @pulumi.getter
    def active(self) -> Optional['outputs.NodeConfigSourcePatch']:
        """
        Active reports the checkpointed config the node is actively using. Active will represent either the current version of the Assigned config, or the current LastKnownGood config, depending on whether attempting to use the Assigned config results in an error.
        """
        return pulumi.get(self, "active")

    @_builtins.property
    @pulumi.getter
    def assigned(self) -> Optional['outputs.NodeConfigSourcePatch']:
        """
        Assigned reports the checkpointed config the node will try to use. When Node.Spec.ConfigSource is updated, the node checkpoints the associated config payload to local disk, along with a record indicating intended config. The node refers to this record to choose its config checkpoint, and reports this record in Assigned. Assigned only updates in the status after the record has been checkpointed to disk. When the Kubelet is restarted, it tries to make the Assigned config the Active config by loading and validating the checkpointed payload identified by Assigned.
        """
        return pulumi.get(self, "assigned")

    @_builtins.property
    @pulumi.getter
    def error(self) -> Optional[_builtins.str]:
        """
        Error describes any problems reconciling the Spec.ConfigSource to the Active config. Errors may occur, for example, attempting to checkpoint Spec.ConfigSource to the local Assigned record, attempting to checkpoint the payload associated with Spec.ConfigSource, attempting to load or validate the Assigned config, etc. Errors may occur at different points while syncing config. Earlier errors (e.g. download or checkpointing errors) will not result in a rollback to LastKnownGood, and may resolve across Kubelet retries. Later errors (e.g. loading or validating a checkpointed config) will result in a rollback to LastKnownGood. In the latter case, it is usually possible to resolve the error by fixing the config assigned in Spec.ConfigSource. You can find additional information for debugging by searching the error message in the Kubelet log. Error is a human-readable description of the error state; machines can check whether or not Error is empty, but should not rely on the stability of the Error text across Kubelet versions.
        """
        return pulumi.get(self, "error")

    @_builtins.property
    @pulumi.getter(name="lastKnownGood")
    def last_known_good(self) -> Optional['outputs.NodeConfigSourcePatch']:
        """
        LastKnownGood reports the checkpointed config the node will fall back to when it encounters an error attempting to use the Assigned config. The Assigned config becomes the LastKnownGood config when the node determines that the Assigned config is stable and correct. This is currently implemented as a 10-minute soak period starting when the local record of Assigned config is updated. If the Assigned config is Active at the end of this period, it becomes the LastKnownGood. Note that if Spec.ConfigSource is reset to nil (use local defaults), the LastKnownGood is also immediately reset to nil, because the local default config is always assumed good. You should not make assumptions about the node's method of determining config stability and correctness, as this may change or become configurable in the future.
        """
        return pulumi.get(self, "last_known_good")


@pulumi.output_type
class NodeDaemonEndpoints(dict):
    """
    NodeDaemonEndpoints lists ports opened by daemons running on the Node.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kubeletEndpoint":
            suggest = "kubelet_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeDaemonEndpoints. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeDaemonEndpoints.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeDaemonEndpoints.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kubelet_endpoint: Optional['outputs.DaemonEndpoint'] = None):
        """
        NodeDaemonEndpoints lists ports opened by daemons running on the Node.
        :param 'DaemonEndpointArgs' kubelet_endpoint: Endpoint on which Kubelet is listening.
        """
        if kubelet_endpoint is not None:
            pulumi.set(__self__, "kubelet_endpoint", kubelet_endpoint)

    @_builtins.property
    @pulumi.getter(name="kubeletEndpoint")
    def kubelet_endpoint(self) -> Optional['outputs.DaemonEndpoint']:
        """
        Endpoint on which Kubelet is listening.
        """
        return pulumi.get(self, "kubelet_endpoint")


@pulumi.output_type
class NodeDaemonEndpointsPatch(dict):
    """
    NodeDaemonEndpoints lists ports opened by daemons running on the Node.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kubeletEndpoint":
            suggest = "kubelet_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeDaemonEndpointsPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeDaemonEndpointsPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeDaemonEndpointsPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kubelet_endpoint: Optional['outputs.DaemonEndpointPatch'] = None):
        """
        NodeDaemonEndpoints lists ports opened by daemons running on the Node.
        :param 'DaemonEndpointPatchArgs' kubelet_endpoint: Endpoint on which Kubelet is listening.
        """
        if kubelet_endpoint is not None:
            pulumi.set(__self__, "kubelet_endpoint", kubelet_endpoint)

    @_builtins.property
    @pulumi.getter(name="kubeletEndpoint")
    def kubelet_endpoint(self) -> Optional['outputs.DaemonEndpointPatch']:
        """
        Endpoint on which Kubelet is listening.
        """
        return pulumi.get(self, "kubelet_endpoint")


@pulumi.output_type
class NodeFeatures(dict):
    """
    NodeFeatures describes the set of features implemented by the CRI implementation. The features contained in the NodeFeatures should depend only on the cri implementation independent of runtime handlers.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "supplementalGroupsPolicy":
            suggest = "supplemental_groups_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeFeatures. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeFeatures.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeFeatures.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 supplemental_groups_policy: Optional[_builtins.bool] = None):
        """
        NodeFeatures describes the set of features implemented by the CRI implementation. The features contained in the NodeFeatures should depend only on the cri implementation independent of runtime handlers.
        :param _builtins.bool supplemental_groups_policy: SupplementalGroupsPolicy is set to true if the runtime supports SupplementalGroupsPolicy and ContainerUser.
        """
        if supplemental_groups_policy is not None:
            pulumi.set(__self__, "supplemental_groups_policy", supplemental_groups_policy)

    @_builtins.property
    @pulumi.getter(name="supplementalGroupsPolicy")
    def supplemental_groups_policy(self) -> Optional[_builtins.bool]:
        """
        SupplementalGroupsPolicy is set to true if the runtime supports SupplementalGroupsPolicy and ContainerUser.
        """
        return pulumi.get(self, "supplemental_groups_policy")


@pulumi.output_type
class NodeFeaturesPatch(dict):
    """
    NodeFeatures describes the set of features implemented by the CRI implementation. The features contained in the NodeFeatures should depend only on the cri implementation independent of runtime handlers.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "supplementalGroupsPolicy":
            suggest = "supplemental_groups_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeFeaturesPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeFeaturesPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeFeaturesPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 supplemental_groups_policy: Optional[_builtins.bool] = None):
        """
        NodeFeatures describes the set of features implemented by the CRI implementation. The features contained in the NodeFeatures should depend only on the cri implementation independent of runtime handlers.
        :param _builtins.bool supplemental_groups_policy: SupplementalGroupsPolicy is set to true if the runtime supports SupplementalGroupsPolicy and ContainerUser.
        """
        if supplemental_groups_policy is not None:
            pulumi.set(__self__, "supplemental_groups_policy", supplemental_groups_policy)

    @_builtins.property
    @pulumi.getter(name="supplementalGroupsPolicy")
    def supplemental_groups_policy(self) -> Optional[_builtins.bool]:
        """
        SupplementalGroupsPolicy is set to true if the runtime supports SupplementalGroupsPolicy and ContainerUser.
        """
        return pulumi.get(self, "supplemental_groups_policy")


@pulumi.output_type
class NodeRuntimeHandler(dict):
    """
    NodeRuntimeHandler is a set of runtime handler information.
    """
    def __init__(__self__, *,
                 features: Optional['outputs.NodeRuntimeHandlerFeatures'] = None,
                 name: Optional[_builtins.str] = None):
        """
        NodeRuntimeHandler is a set of runtime handler information.
        :param 'NodeRuntimeHandlerFeaturesArgs' features: Supported features.
        :param _builtins.str name: Runtime handler name. Empty for the default runtime handler.
        """
        if features is not None:
            pulumi.set(__self__, "features", features)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def features(self) -> Optional['outputs.NodeRuntimeHandlerFeatures']:
        """
        Supported features.
        """
        return pulumi.get(self, "features")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Runtime handler name. Empty for the default runtime handler.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class NodeRuntimeHandlerFeatures(dict):
    """
    NodeRuntimeHandlerFeatures is a set of features implemented by the runtime handler.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recursiveReadOnlyMounts":
            suggest = "recursive_read_only_mounts"
        elif key == "userNamespaces":
            suggest = "user_namespaces"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeRuntimeHandlerFeatures. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeRuntimeHandlerFeatures.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeRuntimeHandlerFeatures.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 recursive_read_only_mounts: Optional[_builtins.bool] = None,
                 user_namespaces: Optional[_builtins.bool] = None):
        """
        NodeRuntimeHandlerFeatures is a set of features implemented by the runtime handler.
        :param _builtins.bool recursive_read_only_mounts: RecursiveReadOnlyMounts is set to true if the runtime handler supports RecursiveReadOnlyMounts.
        :param _builtins.bool user_namespaces: UserNamespaces is set to true if the runtime handler supports UserNamespaces, including for volumes.
        """
        if recursive_read_only_mounts is not None:
            pulumi.set(__self__, "recursive_read_only_mounts", recursive_read_only_mounts)
        if user_namespaces is not None:
            pulumi.set(__self__, "user_namespaces", user_namespaces)

    @_builtins.property
    @pulumi.getter(name="recursiveReadOnlyMounts")
    def recursive_read_only_mounts(self) -> Optional[_builtins.bool]:
        """
        RecursiveReadOnlyMounts is set to true if the runtime handler supports RecursiveReadOnlyMounts.
        """
        return pulumi.get(self, "recursive_read_only_mounts")

    @_builtins.property
    @pulumi.getter(name="userNamespaces")
    def user_namespaces(self) -> Optional[_builtins.bool]:
        """
        UserNamespaces is set to true if the runtime handler supports UserNamespaces, including for volumes.
        """
        return pulumi.get(self, "user_namespaces")


@pulumi.output_type
class NodeRuntimeHandlerFeaturesPatch(dict):
    """
    NodeRuntimeHandlerFeatures is a set of features implemented by the runtime handler.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recursiveReadOnlyMounts":
            suggest = "recursive_read_only_mounts"
        elif key == "userNamespaces":
            suggest = "user_namespaces"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeRuntimeHandlerFeaturesPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeRuntimeHandlerFeaturesPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeRuntimeHandlerFeaturesPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 recursive_read_only_mounts: Optional[_builtins.bool] = None,
                 user_namespaces: Optional[_builtins.bool] = None):
        """
        NodeRuntimeHandlerFeatures is a set of features implemented by the runtime handler.
        :param _builtins.bool recursive_read_only_mounts: RecursiveReadOnlyMounts is set to true if the runtime handler supports RecursiveReadOnlyMounts.
        :param _builtins.bool user_namespaces: UserNamespaces is set to true if the runtime handler supports UserNamespaces, including for volumes.
        """
        if recursive_read_only_mounts is not None:
            pulumi.set(__self__, "recursive_read_only_mounts", recursive_read_only_mounts)
        if user_namespaces is not None:
            pulumi.set(__self__, "user_namespaces", user_namespaces)

    @_builtins.property
    @pulumi.getter(name="recursiveReadOnlyMounts")
    def recursive_read_only_mounts(self) -> Optional[_builtins.bool]:
        """
        RecursiveReadOnlyMounts is set to true if the runtime handler supports RecursiveReadOnlyMounts.
        """
        return pulumi.get(self, "recursive_read_only_mounts")

    @_builtins.property
    @pulumi.getter(name="userNamespaces")
    def user_namespaces(self) -> Optional[_builtins.bool]:
        """
        UserNamespaces is set to true if the runtime handler supports UserNamespaces, including for volumes.
        """
        return pulumi.get(self, "user_namespaces")


@pulumi.output_type
class NodeRuntimeHandlerPatch(dict):
    """
    NodeRuntimeHandler is a set of runtime handler information.
    """
    def __init__(__self__, *,
                 features: Optional['outputs.NodeRuntimeHandlerFeaturesPatch'] = None,
                 name: Optional[_builtins.str] = None):
        """
        NodeRuntimeHandler is a set of runtime handler information.
        :param 'NodeRuntimeHandlerFeaturesPatchArgs' features: Supported features.
        :param _builtins.str name: Runtime handler name. Empty for the default runtime handler.
        """
        if features is not None:
            pulumi.set(__self__, "features", features)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def features(self) -> Optional['outputs.NodeRuntimeHandlerFeaturesPatch']:
        """
        Supported features.
        """
        return pulumi.get(self, "features")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Runtime handler name. Empty for the default runtime handler.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class NodeSelector(dict):
    """
    A node selector represents the union of the results of one or more label queries over a set of nodes; that is, it represents the OR of the selectors represented by the node selector terms.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeSelectorTerms":
            suggest = "node_selector_terms"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeSelector. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeSelector.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeSelector.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_selector_terms: Sequence['outputs.NodeSelectorTerm']):
        """
        A node selector represents the union of the results of one or more label queries over a set of nodes; that is, it represents the OR of the selectors represented by the node selector terms.
        :param Sequence['NodeSelectorTermArgs'] node_selector_terms: Required. A list of node selector terms. The terms are ORed.
        """
        pulumi.set(__self__, "node_selector_terms", node_selector_terms)

    @_builtins.property
    @pulumi.getter(name="nodeSelectorTerms")
    def node_selector_terms(self) -> Sequence['outputs.NodeSelectorTerm']:
        """
        Required. A list of node selector terms. The terms are ORed.
        """
        return pulumi.get(self, "node_selector_terms")


@pulumi.output_type
class NodeSelectorPatch(dict):
    """
    A node selector represents the union of the results of one or more label queries over a set of nodes; that is, it represents the OR of the selectors represented by the node selector terms.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeSelectorTerms":
            suggest = "node_selector_terms"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeSelectorPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeSelectorPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeSelectorPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_selector_terms: Optional[Sequence['outputs.NodeSelectorTermPatch']] = None):
        """
        A node selector represents the union of the results of one or more label queries over a set of nodes; that is, it represents the OR of the selectors represented by the node selector terms.
        :param Sequence['NodeSelectorTermPatchArgs'] node_selector_terms: Required. A list of node selector terms. The terms are ORed.
        """
        if node_selector_terms is not None:
            pulumi.set(__self__, "node_selector_terms", node_selector_terms)

    @_builtins.property
    @pulumi.getter(name="nodeSelectorTerms")
    def node_selector_terms(self) -> Optional[Sequence['outputs.NodeSelectorTermPatch']]:
        """
        Required. A list of node selector terms. The terms are ORed.
        """
        return pulumi.get(self, "node_selector_terms")


@pulumi.output_type
class NodeSelectorRequirement(dict):
    """
    A node selector requirement is a selector that contains values, a key, and an operator that relates the key and values.
    """
    def __init__(__self__, *,
                 key: _builtins.str,
                 operator: _builtins.str,
                 values: Optional[Sequence[_builtins.str]] = None):
        """
        A node selector requirement is a selector that contains values, a key, and an operator that relates the key and values.
        :param _builtins.str key: The label key that the selector applies to.
        :param _builtins.str operator: Represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.
        :param Sequence[_builtins.str] values: An array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. If the operator is Gt or Lt, the values array must have a single element, which will be interpreted as an integer. This array is replaced during a strategic merge patch.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "operator", operator)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The label key that the selector applies to.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        Represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[Sequence[_builtins.str]]:
        """
        An array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. If the operator is Gt or Lt, the values array must have a single element, which will be interpreted as an integer. This array is replaced during a strategic merge patch.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class NodeSelectorRequirementPatch(dict):
    """
    A node selector requirement is a selector that contains values, a key, and an operator that relates the key and values.
    """
    def __init__(__self__, *,
                 key: Optional[_builtins.str] = None,
                 operator: Optional[_builtins.str] = None,
                 values: Optional[Sequence[_builtins.str]] = None):
        """
        A node selector requirement is a selector that contains values, a key, and an operator that relates the key and values.
        :param _builtins.str key: The label key that the selector applies to.
        :param _builtins.str operator: Represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.
        :param Sequence[_builtins.str] values: An array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. If the operator is Gt or Lt, the values array must have a single element, which will be interpreted as an integer. This array is replaced during a strategic merge patch.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        The label key that the selector applies to.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> Optional[_builtins.str]:
        """
        Represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[Sequence[_builtins.str]]:
        """
        An array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. If the operator is Gt or Lt, the values array must have a single element, which will be interpreted as an integer. This array is replaced during a strategic merge patch.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class NodeSelectorTerm(dict):
    """
    A null or empty node selector term matches no objects. The requirements of them are ANDed. The TopologySelectorTerm type implements a subset of the NodeSelectorTerm.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchExpressions":
            suggest = "match_expressions"
        elif key == "matchFields":
            suggest = "match_fields"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeSelectorTerm. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeSelectorTerm.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeSelectorTerm.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_expressions: Optional[Sequence['outputs.NodeSelectorRequirement']] = None,
                 match_fields: Optional[Sequence['outputs.NodeSelectorRequirement']] = None):
        """
        A null or empty node selector term matches no objects. The requirements of them are ANDed. The TopologySelectorTerm type implements a subset of the NodeSelectorTerm.
        :param Sequence['NodeSelectorRequirementArgs'] match_expressions: A list of node selector requirements by node's labels.
        :param Sequence['NodeSelectorRequirementArgs'] match_fields: A list of node selector requirements by node's fields.
        """
        if match_expressions is not None:
            pulumi.set(__self__, "match_expressions", match_expressions)
        if match_fields is not None:
            pulumi.set(__self__, "match_fields", match_fields)

    @_builtins.property
    @pulumi.getter(name="matchExpressions")
    def match_expressions(self) -> Optional[Sequence['outputs.NodeSelectorRequirement']]:
        """
        A list of node selector requirements by node's labels.
        """
        return pulumi.get(self, "match_expressions")

    @_builtins.property
    @pulumi.getter(name="matchFields")
    def match_fields(self) -> Optional[Sequence['outputs.NodeSelectorRequirement']]:
        """
        A list of node selector requirements by node's fields.
        """
        return pulumi.get(self, "match_fields")


@pulumi.output_type
class NodeSelectorTermPatch(dict):
    """
    A null or empty node selector term matches no objects. The requirements of them are ANDed. The TopologySelectorTerm type implements a subset of the NodeSelectorTerm.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchExpressions":
            suggest = "match_expressions"
        elif key == "matchFields":
            suggest = "match_fields"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeSelectorTermPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeSelectorTermPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeSelectorTermPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_expressions: Optional[Sequence['outputs.NodeSelectorRequirementPatch']] = None,
                 match_fields: Optional[Sequence['outputs.NodeSelectorRequirementPatch']] = None):
        """
        A null or empty node selector term matches no objects. The requirements of them are ANDed. The TopologySelectorTerm type implements a subset of the NodeSelectorTerm.
        :param Sequence['NodeSelectorRequirementPatchArgs'] match_expressions: A list of node selector requirements by node's labels.
        :param Sequence['NodeSelectorRequirementPatchArgs'] match_fields: A list of node selector requirements by node's fields.
        """
        if match_expressions is not None:
            pulumi.set(__self__, "match_expressions", match_expressions)
        if match_fields is not None:
            pulumi.set(__self__, "match_fields", match_fields)

    @_builtins.property
    @pulumi.getter(name="matchExpressions")
    def match_expressions(self) -> Optional[Sequence['outputs.NodeSelectorRequirementPatch']]:
        """
        A list of node selector requirements by node's labels.
        """
        return pulumi.get(self, "match_expressions")

    @_builtins.property
    @pulumi.getter(name="matchFields")
    def match_fields(self) -> Optional[Sequence['outputs.NodeSelectorRequirementPatch']]:
        """
        A list of node selector requirements by node's fields.
        """
        return pulumi.get(self, "match_fields")


@pulumi.output_type
class NodeSpec(dict):
    """
    NodeSpec describes the attributes that a node is created with.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configSource":
            suggest = "config_source"
        elif key == "externalID":
            suggest = "external_id"
        elif key == "podCIDR":
            suggest = "pod_cidr"
        elif key == "podCIDRs":
            suggest = "pod_cidrs"
        elif key == "providerID":
            suggest = "provider_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_source: Optional['outputs.NodeConfigSource'] = None,
                 external_id: Optional[_builtins.str] = None,
                 pod_cidr: Optional[_builtins.str] = None,
                 pod_cidrs: Optional[Sequence[_builtins.str]] = None,
                 provider_id: Optional[_builtins.str] = None,
                 taints: Optional[Sequence['outputs.Taint']] = None,
                 unschedulable: Optional[_builtins.bool] = None):
        """
        NodeSpec describes the attributes that a node is created with.
        :param 'NodeConfigSourceArgs' config_source: Deprecated: Previously used to specify the source of the node's configuration for the DynamicKubeletConfig feature. This feature is removed.
        :param _builtins.str external_id: Deprecated. Not all kubelets will set this field. Remove field after 1.13. see: https://issues.k8s.io/61966
        :param _builtins.str pod_cidr: PodCIDR represents the pod IP range assigned to the node.
        :param Sequence[_builtins.str] pod_cidrs: podCIDRs represents the IP ranges assigned to the node for usage by Pods on that node. If this field is specified, the 0th entry must match the podCIDR field. It may contain at most 1 value for each of IPv4 and IPv6.
        :param _builtins.str provider_id: ID of the node assigned by the cloud provider in the format: <ProviderName>://<ProviderSpecificNodeID>
        :param Sequence['TaintArgs'] taints: If specified, the node's taints.
        :param _builtins.bool unschedulable: Unschedulable controls node schedulability of new pods. By default, node is schedulable. More info: https://kubernetes.io/docs/concepts/nodes/node/#manual-node-administration
        """
        if config_source is not None:
            pulumi.set(__self__, "config_source", config_source)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if pod_cidr is not None:
            pulumi.set(__self__, "pod_cidr", pod_cidr)
        if pod_cidrs is not None:
            pulumi.set(__self__, "pod_cidrs", pod_cidrs)
        if provider_id is not None:
            pulumi.set(__self__, "provider_id", provider_id)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if unschedulable is not None:
            pulumi.set(__self__, "unschedulable", unschedulable)

    @_builtins.property
    @pulumi.getter(name="configSource")
    def config_source(self) -> Optional['outputs.NodeConfigSource']:
        """
        Deprecated: Previously used to specify the source of the node's configuration for the DynamicKubeletConfig feature. This feature is removed.
        """
        return pulumi.get(self, "config_source")

    @_builtins.property
    @pulumi.getter(name="externalID")
    def external_id(self) -> Optional[_builtins.str]:
        """
        Deprecated. Not all kubelets will set this field. Remove field after 1.13. see: https://issues.k8s.io/61966
        """
        return pulumi.get(self, "external_id")

    @_builtins.property
    @pulumi.getter(name="podCIDR")
    def pod_cidr(self) -> Optional[_builtins.str]:
        """
        PodCIDR represents the pod IP range assigned to the node.
        """
        return pulumi.get(self, "pod_cidr")

    @_builtins.property
    @pulumi.getter(name="podCIDRs")
    def pod_cidrs(self) -> Optional[Sequence[_builtins.str]]:
        """
        podCIDRs represents the IP ranges assigned to the node for usage by Pods on that node. If this field is specified, the 0th entry must match the podCIDR field. It may contain at most 1 value for each of IPv4 and IPv6.
        """
        return pulumi.get(self, "pod_cidrs")

    @_builtins.property
    @pulumi.getter(name="providerID")
    def provider_id(self) -> Optional[_builtins.str]:
        """
        ID of the node assigned by the cloud provider in the format: <ProviderName>://<ProviderSpecificNodeID>
        """
        return pulumi.get(self, "provider_id")

    @_builtins.property
    @pulumi.getter
    def taints(self) -> Optional[Sequence['outputs.Taint']]:
        """
        If specified, the node's taints.
        """
        return pulumi.get(self, "taints")

    @_builtins.property
    @pulumi.getter
    def unschedulable(self) -> Optional[_builtins.bool]:
        """
        Unschedulable controls node schedulability of new pods. By default, node is schedulable. More info: https://kubernetes.io/docs/concepts/nodes/node/#manual-node-administration
        """
        return pulumi.get(self, "unschedulable")


@pulumi.output_type
class NodeSpecPatch(dict):
    """
    NodeSpec describes the attributes that a node is created with.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configSource":
            suggest = "config_source"
        elif key == "externalID":
            suggest = "external_id"
        elif key == "podCIDR":
            suggest = "pod_cidr"
        elif key == "podCIDRs":
            suggest = "pod_cidrs"
        elif key == "providerID":
            suggest = "provider_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeSpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeSpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeSpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_source: Optional['outputs.NodeConfigSourcePatch'] = None,
                 external_id: Optional[_builtins.str] = None,
                 pod_cidr: Optional[_builtins.str] = None,
                 pod_cidrs: Optional[Sequence[_builtins.str]] = None,
                 provider_id: Optional[_builtins.str] = None,
                 taints: Optional[Sequence['outputs.TaintPatch']] = None,
                 unschedulable: Optional[_builtins.bool] = None):
        """
        NodeSpec describes the attributes that a node is created with.
        :param 'NodeConfigSourcePatchArgs' config_source: Deprecated: Previously used to specify the source of the node's configuration for the DynamicKubeletConfig feature. This feature is removed.
        :param _builtins.str external_id: Deprecated. Not all kubelets will set this field. Remove field after 1.13. see: https://issues.k8s.io/61966
        :param _builtins.str pod_cidr: PodCIDR represents the pod IP range assigned to the node.
        :param Sequence[_builtins.str] pod_cidrs: podCIDRs represents the IP ranges assigned to the node for usage by Pods on that node. If this field is specified, the 0th entry must match the podCIDR field. It may contain at most 1 value for each of IPv4 and IPv6.
        :param _builtins.str provider_id: ID of the node assigned by the cloud provider in the format: <ProviderName>://<ProviderSpecificNodeID>
        :param Sequence['TaintPatchArgs'] taints: If specified, the node's taints.
        :param _builtins.bool unschedulable: Unschedulable controls node schedulability of new pods. By default, node is schedulable. More info: https://kubernetes.io/docs/concepts/nodes/node/#manual-node-administration
        """
        if config_source is not None:
            pulumi.set(__self__, "config_source", config_source)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if pod_cidr is not None:
            pulumi.set(__self__, "pod_cidr", pod_cidr)
        if pod_cidrs is not None:
            pulumi.set(__self__, "pod_cidrs", pod_cidrs)
        if provider_id is not None:
            pulumi.set(__self__, "provider_id", provider_id)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if unschedulable is not None:
            pulumi.set(__self__, "unschedulable", unschedulable)

    @_builtins.property
    @pulumi.getter(name="configSource")
    def config_source(self) -> Optional['outputs.NodeConfigSourcePatch']:
        """
        Deprecated: Previously used to specify the source of the node's configuration for the DynamicKubeletConfig feature. This feature is removed.
        """
        return pulumi.get(self, "config_source")

    @_builtins.property
    @pulumi.getter(name="externalID")
    def external_id(self) -> Optional[_builtins.str]:
        """
        Deprecated. Not all kubelets will set this field. Remove field after 1.13. see: https://issues.k8s.io/61966
        """
        return pulumi.get(self, "external_id")

    @_builtins.property
    @pulumi.getter(name="podCIDR")
    def pod_cidr(self) -> Optional[_builtins.str]:
        """
        PodCIDR represents the pod IP range assigned to the node.
        """
        return pulumi.get(self, "pod_cidr")

    @_builtins.property
    @pulumi.getter(name="podCIDRs")
    def pod_cidrs(self) -> Optional[Sequence[_builtins.str]]:
        """
        podCIDRs represents the IP ranges assigned to the node for usage by Pods on that node. If this field is specified, the 0th entry must match the podCIDR field. It may contain at most 1 value for each of IPv4 and IPv6.
        """
        return pulumi.get(self, "pod_cidrs")

    @_builtins.property
    @pulumi.getter(name="providerID")
    def provider_id(self) -> Optional[_builtins.str]:
        """
        ID of the node assigned by the cloud provider in the format: <ProviderName>://<ProviderSpecificNodeID>
        """
        return pulumi.get(self, "provider_id")

    @_builtins.property
    @pulumi.getter
    def taints(self) -> Optional[Sequence['outputs.TaintPatch']]:
        """
        If specified, the node's taints.
        """
        return pulumi.get(self, "taints")

    @_builtins.property
    @pulumi.getter
    def unschedulable(self) -> Optional[_builtins.bool]:
        """
        Unschedulable controls node schedulability of new pods. By default, node is schedulable. More info: https://kubernetes.io/docs/concepts/nodes/node/#manual-node-administration
        """
        return pulumi.get(self, "unschedulable")


@pulumi.output_type
class NodeStatus(dict):
    """
    NodeStatus is information about the current status of a node.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "daemonEndpoints":
            suggest = "daemon_endpoints"
        elif key == "nodeInfo":
            suggest = "node_info"
        elif key == "runtimeHandlers":
            suggest = "runtime_handlers"
        elif key == "volumesAttached":
            suggest = "volumes_attached"
        elif key == "volumesInUse":
            suggest = "volumes_in_use"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 addresses: Optional[Sequence['outputs.NodeAddress']] = None,
                 allocatable: Optional[Mapping[str, _builtins.str]] = None,
                 capacity: Optional[Mapping[str, _builtins.str]] = None,
                 conditions: Optional[Sequence['outputs.NodeCondition']] = None,
                 config: Optional['outputs.NodeConfigStatus'] = None,
                 daemon_endpoints: Optional['outputs.NodeDaemonEndpoints'] = None,
                 features: Optional['outputs.NodeFeatures'] = None,
                 images: Optional[Sequence['outputs.ContainerImage']] = None,
                 node_info: Optional['outputs.NodeSystemInfo'] = None,
                 phase: Optional[_builtins.str] = None,
                 runtime_handlers: Optional[Sequence['outputs.NodeRuntimeHandler']] = None,
                 volumes_attached: Optional[Sequence['outputs.AttachedVolume']] = None,
                 volumes_in_use: Optional[Sequence[_builtins.str]] = None):
        """
        NodeStatus is information about the current status of a node.
        :param Sequence['NodeAddressArgs'] addresses: List of addresses reachable to the node. Queried from cloud provider, if available. More info: https://kubernetes.io/docs/reference/node/node-status/#addresses Note: This field is declared as mergeable, but the merge key is not sufficiently unique, which can cause data corruption when it is merged. Callers should instead use a full-replacement patch. See https://pr.k8s.io/79391 for an example. Consumers should assume that addresses can change during the lifetime of a Node. However, there are some exceptions where this may not be possible, such as Pods that inherit a Node's address in its own status or consumers of the downward API (status.hostIP).
        :param Mapping[str, _builtins.str] allocatable: Allocatable represents the resources of a node that are available for scheduling. Defaults to Capacity.
        :param Mapping[str, _builtins.str] capacity: Capacity represents the total resources of a node. More info: https://kubernetes.io/docs/reference/node/node-status/#capacity
        :param Sequence['NodeConditionArgs'] conditions: Conditions is an array of current observed node conditions. More info: https://kubernetes.io/docs/reference/node/node-status/#condition
        :param 'NodeConfigStatusArgs' config: Status of the config assigned to the node via the dynamic Kubelet config feature.
        :param 'NodeDaemonEndpointsArgs' daemon_endpoints: Endpoints of daemons running on the Node.
        :param 'NodeFeaturesArgs' features: Features describes the set of features implemented by the CRI implementation.
        :param Sequence['ContainerImageArgs'] images: List of container images on this node
        :param 'NodeSystemInfoArgs' node_info: Set of ids/uuids to uniquely identify the node. More info: https://kubernetes.io/docs/reference/node/node-status/#info
        :param _builtins.str phase: NodePhase is the recently observed lifecycle phase of the node. More info: https://kubernetes.io/docs/concepts/nodes/node/#phase The field is never populated, and now is deprecated.
        :param Sequence['NodeRuntimeHandlerArgs'] runtime_handlers: The available runtime handlers.
        :param Sequence['AttachedVolumeArgs'] volumes_attached: List of volumes that are attached to the node.
        :param Sequence[_builtins.str] volumes_in_use: List of attachable volumes in use (mounted) by the node.
        """
        if addresses is not None:
            pulumi.set(__self__, "addresses", addresses)
        if allocatable is not None:
            pulumi.set(__self__, "allocatable", allocatable)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if daemon_endpoints is not None:
            pulumi.set(__self__, "daemon_endpoints", daemon_endpoints)
        if features is not None:
            pulumi.set(__self__, "features", features)
        if images is not None:
            pulumi.set(__self__, "images", images)
        if node_info is not None:
            pulumi.set(__self__, "node_info", node_info)
        if phase is not None:
            pulumi.set(__self__, "phase", phase)
        if runtime_handlers is not None:
            pulumi.set(__self__, "runtime_handlers", runtime_handlers)
        if volumes_attached is not None:
            pulumi.set(__self__, "volumes_attached", volumes_attached)
        if volumes_in_use is not None:
            pulumi.set(__self__, "volumes_in_use", volumes_in_use)

    @_builtins.property
    @pulumi.getter
    def addresses(self) -> Optional[Sequence['outputs.NodeAddress']]:
        """
        List of addresses reachable to the node. Queried from cloud provider, if available. More info: https://kubernetes.io/docs/reference/node/node-status/#addresses Note: This field is declared as mergeable, but the merge key is not sufficiently unique, which can cause data corruption when it is merged. Callers should instead use a full-replacement patch. See https://pr.k8s.io/79391 for an example. Consumers should assume that addresses can change during the lifetime of a Node. However, there are some exceptions where this may not be possible, such as Pods that inherit a Node's address in its own status or consumers of the downward API (status.hostIP).
        """
        return pulumi.get(self, "addresses")

    @_builtins.property
    @pulumi.getter
    def allocatable(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Allocatable represents the resources of a node that are available for scheduling. Defaults to Capacity.
        """
        return pulumi.get(self, "allocatable")

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Capacity represents the total resources of a node. More info: https://kubernetes.io/docs/reference/node/node-status/#capacity
        """
        return pulumi.get(self, "capacity")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.NodeCondition']]:
        """
        Conditions is an array of current observed node conditions. More info: https://kubernetes.io/docs/reference/node/node-status/#condition
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional['outputs.NodeConfigStatus']:
        """
        Status of the config assigned to the node via the dynamic Kubelet config feature.
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter(name="daemonEndpoints")
    def daemon_endpoints(self) -> Optional['outputs.NodeDaemonEndpoints']:
        """
        Endpoints of daemons running on the Node.
        """
        return pulumi.get(self, "daemon_endpoints")

    @_builtins.property
    @pulumi.getter
    def features(self) -> Optional['outputs.NodeFeatures']:
        """
        Features describes the set of features implemented by the CRI implementation.
        """
        return pulumi.get(self, "features")

    @_builtins.property
    @pulumi.getter
    def images(self) -> Optional[Sequence['outputs.ContainerImage']]:
        """
        List of container images on this node
        """
        return pulumi.get(self, "images")

    @_builtins.property
    @pulumi.getter(name="nodeInfo")
    def node_info(self) -> Optional['outputs.NodeSystemInfo']:
        """
        Set of ids/uuids to uniquely identify the node. More info: https://kubernetes.io/docs/reference/node/node-status/#info
        """
        return pulumi.get(self, "node_info")

    @_builtins.property
    @pulumi.getter
    def phase(self) -> Optional[_builtins.str]:
        """
        NodePhase is the recently observed lifecycle phase of the node. More info: https://kubernetes.io/docs/concepts/nodes/node/#phase The field is never populated, and now is deprecated.
        """
        return pulumi.get(self, "phase")

    @_builtins.property
    @pulumi.getter(name="runtimeHandlers")
    def runtime_handlers(self) -> Optional[Sequence['outputs.NodeRuntimeHandler']]:
        """
        The available runtime handlers.
        """
        return pulumi.get(self, "runtime_handlers")

    @_builtins.property
    @pulumi.getter(name="volumesAttached")
    def volumes_attached(self) -> Optional[Sequence['outputs.AttachedVolume']]:
        """
        List of volumes that are attached to the node.
        """
        return pulumi.get(self, "volumes_attached")

    @_builtins.property
    @pulumi.getter(name="volumesInUse")
    def volumes_in_use(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of attachable volumes in use (mounted) by the node.
        """
        return pulumi.get(self, "volumes_in_use")


@pulumi.output_type
class NodeStatusPatch(dict):
    """
    NodeStatus is information about the current status of a node.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "daemonEndpoints":
            suggest = "daemon_endpoints"
        elif key == "nodeInfo":
            suggest = "node_info"
        elif key == "runtimeHandlers":
            suggest = "runtime_handlers"
        elif key == "volumesAttached":
            suggest = "volumes_attached"
        elif key == "volumesInUse":
            suggest = "volumes_in_use"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeStatusPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeStatusPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeStatusPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 addresses: Optional[Sequence['outputs.NodeAddressPatch']] = None,
                 allocatable: Optional[Mapping[str, _builtins.str]] = None,
                 capacity: Optional[Mapping[str, _builtins.str]] = None,
                 conditions: Optional[Sequence['outputs.NodeConditionPatch']] = None,
                 config: Optional['outputs.NodeConfigStatusPatch'] = None,
                 daemon_endpoints: Optional['outputs.NodeDaemonEndpointsPatch'] = None,
                 features: Optional['outputs.NodeFeaturesPatch'] = None,
                 images: Optional[Sequence['outputs.ContainerImagePatch']] = None,
                 node_info: Optional['outputs.NodeSystemInfoPatch'] = None,
                 phase: Optional[_builtins.str] = None,
                 runtime_handlers: Optional[Sequence['outputs.NodeRuntimeHandlerPatch']] = None,
                 volumes_attached: Optional[Sequence['outputs.AttachedVolumePatch']] = None,
                 volumes_in_use: Optional[Sequence[_builtins.str]] = None):
        """
        NodeStatus is information about the current status of a node.
        :param Sequence['NodeAddressPatchArgs'] addresses: List of addresses reachable to the node. Queried from cloud provider, if available. More info: https://kubernetes.io/docs/reference/node/node-status/#addresses Note: This field is declared as mergeable, but the merge key is not sufficiently unique, which can cause data corruption when it is merged. Callers should instead use a full-replacement patch. See https://pr.k8s.io/79391 for an example. Consumers should assume that addresses can change during the lifetime of a Node. However, there are some exceptions where this may not be possible, such as Pods that inherit a Node's address in its own status or consumers of the downward API (status.hostIP).
        :param Mapping[str, _builtins.str] allocatable: Allocatable represents the resources of a node that are available for scheduling. Defaults to Capacity.
        :param Mapping[str, _builtins.str] capacity: Capacity represents the total resources of a node. More info: https://kubernetes.io/docs/reference/node/node-status/#capacity
        :param Sequence['NodeConditionPatchArgs'] conditions: Conditions is an array of current observed node conditions. More info: https://kubernetes.io/docs/reference/node/node-status/#condition
        :param 'NodeConfigStatusPatchArgs' config: Status of the config assigned to the node via the dynamic Kubelet config feature.
        :param 'NodeDaemonEndpointsPatchArgs' daemon_endpoints: Endpoints of daemons running on the Node.
        :param 'NodeFeaturesPatchArgs' features: Features describes the set of features implemented by the CRI implementation.
        :param Sequence['ContainerImagePatchArgs'] images: List of container images on this node
        :param 'NodeSystemInfoPatchArgs' node_info: Set of ids/uuids to uniquely identify the node. More info: https://kubernetes.io/docs/reference/node/node-status/#info
        :param _builtins.str phase: NodePhase is the recently observed lifecycle phase of the node. More info: https://kubernetes.io/docs/concepts/nodes/node/#phase The field is never populated, and now is deprecated.
        :param Sequence['NodeRuntimeHandlerPatchArgs'] runtime_handlers: The available runtime handlers.
        :param Sequence['AttachedVolumePatchArgs'] volumes_attached: List of volumes that are attached to the node.
        :param Sequence[_builtins.str] volumes_in_use: List of attachable volumes in use (mounted) by the node.
        """
        if addresses is not None:
            pulumi.set(__self__, "addresses", addresses)
        if allocatable is not None:
            pulumi.set(__self__, "allocatable", allocatable)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if daemon_endpoints is not None:
            pulumi.set(__self__, "daemon_endpoints", daemon_endpoints)
        if features is not None:
            pulumi.set(__self__, "features", features)
        if images is not None:
            pulumi.set(__self__, "images", images)
        if node_info is not None:
            pulumi.set(__self__, "node_info", node_info)
        if phase is not None:
            pulumi.set(__self__, "phase", phase)
        if runtime_handlers is not None:
            pulumi.set(__self__, "runtime_handlers", runtime_handlers)
        if volumes_attached is not None:
            pulumi.set(__self__, "volumes_attached", volumes_attached)
        if volumes_in_use is not None:
            pulumi.set(__self__, "volumes_in_use", volumes_in_use)

    @_builtins.property
    @pulumi.getter
    def addresses(self) -> Optional[Sequence['outputs.NodeAddressPatch']]:
        """
        List of addresses reachable to the node. Queried from cloud provider, if available. More info: https://kubernetes.io/docs/reference/node/node-status/#addresses Note: This field is declared as mergeable, but the merge key is not sufficiently unique, which can cause data corruption when it is merged. Callers should instead use a full-replacement patch. See https://pr.k8s.io/79391 for an example. Consumers should assume that addresses can change during the lifetime of a Node. However, there are some exceptions where this may not be possible, such as Pods that inherit a Node's address in its own status or consumers of the downward API (status.hostIP).
        """
        return pulumi.get(self, "addresses")

    @_builtins.property
    @pulumi.getter
    def allocatable(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Allocatable represents the resources of a node that are available for scheduling. Defaults to Capacity.
        """
        return pulumi.get(self, "allocatable")

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Capacity represents the total resources of a node. More info: https://kubernetes.io/docs/reference/node/node-status/#capacity
        """
        return pulumi.get(self, "capacity")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.NodeConditionPatch']]:
        """
        Conditions is an array of current observed node conditions. More info: https://kubernetes.io/docs/reference/node/node-status/#condition
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional['outputs.NodeConfigStatusPatch']:
        """
        Status of the config assigned to the node via the dynamic Kubelet config feature.
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter(name="daemonEndpoints")
    def daemon_endpoints(self) -> Optional['outputs.NodeDaemonEndpointsPatch']:
        """
        Endpoints of daemons running on the Node.
        """
        return pulumi.get(self, "daemon_endpoints")

    @_builtins.property
    @pulumi.getter
    def features(self) -> Optional['outputs.NodeFeaturesPatch']:
        """
        Features describes the set of features implemented by the CRI implementation.
        """
        return pulumi.get(self, "features")

    @_builtins.property
    @pulumi.getter
    def images(self) -> Optional[Sequence['outputs.ContainerImagePatch']]:
        """
        List of container images on this node
        """
        return pulumi.get(self, "images")

    @_builtins.property
    @pulumi.getter(name="nodeInfo")
    def node_info(self) -> Optional['outputs.NodeSystemInfoPatch']:
        """
        Set of ids/uuids to uniquely identify the node. More info: https://kubernetes.io/docs/reference/node/node-status/#info
        """
        return pulumi.get(self, "node_info")

    @_builtins.property
    @pulumi.getter
    def phase(self) -> Optional[_builtins.str]:
        """
        NodePhase is the recently observed lifecycle phase of the node. More info: https://kubernetes.io/docs/concepts/nodes/node/#phase The field is never populated, and now is deprecated.
        """
        return pulumi.get(self, "phase")

    @_builtins.property
    @pulumi.getter(name="runtimeHandlers")
    def runtime_handlers(self) -> Optional[Sequence['outputs.NodeRuntimeHandlerPatch']]:
        """
        The available runtime handlers.
        """
        return pulumi.get(self, "runtime_handlers")

    @_builtins.property
    @pulumi.getter(name="volumesAttached")
    def volumes_attached(self) -> Optional[Sequence['outputs.AttachedVolumePatch']]:
        """
        List of volumes that are attached to the node.
        """
        return pulumi.get(self, "volumes_attached")

    @_builtins.property
    @pulumi.getter(name="volumesInUse")
    def volumes_in_use(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of attachable volumes in use (mounted) by the node.
        """
        return pulumi.get(self, "volumes_in_use")


@pulumi.output_type
class NodeSwapStatus(dict):
    """
    NodeSwapStatus represents swap memory information.
    """
    def __init__(__self__, *,
                 capacity: Optional[_builtins.int] = None):
        """
        NodeSwapStatus represents swap memory information.
        :param _builtins.int capacity: Total amount of swap memory in bytes.
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> Optional[_builtins.int]:
        """
        Total amount of swap memory in bytes.
        """
        return pulumi.get(self, "capacity")


@pulumi.output_type
class NodeSwapStatusPatch(dict):
    """
    NodeSwapStatus represents swap memory information.
    """
    def __init__(__self__, *,
                 capacity: Optional[_builtins.int] = None):
        """
        NodeSwapStatus represents swap memory information.
        :param _builtins.int capacity: Total amount of swap memory in bytes.
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> Optional[_builtins.int]:
        """
        Total amount of swap memory in bytes.
        """
        return pulumi.get(self, "capacity")


@pulumi.output_type
class NodeSystemInfo(dict):
    """
    NodeSystemInfo is a set of ids/uuids to uniquely identify the node.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bootID":
            suggest = "boot_id"
        elif key == "containerRuntimeVersion":
            suggest = "container_runtime_version"
        elif key == "kernelVersion":
            suggest = "kernel_version"
        elif key == "kubeProxyVersion":
            suggest = "kube_proxy_version"
        elif key == "kubeletVersion":
            suggest = "kubelet_version"
        elif key == "machineID":
            suggest = "machine_id"
        elif key == "operatingSystem":
            suggest = "operating_system"
        elif key == "osImage":
            suggest = "os_image"
        elif key == "systemUUID":
            suggest = "system_uuid"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeSystemInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeSystemInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeSystemInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 architecture: _builtins.str,
                 boot_id: _builtins.str,
                 container_runtime_version: _builtins.str,
                 kernel_version: _builtins.str,
                 kube_proxy_version: _builtins.str,
                 kubelet_version: _builtins.str,
                 machine_id: _builtins.str,
                 operating_system: _builtins.str,
                 os_image: _builtins.str,
                 system_uuid: _builtins.str,
                 swap: Optional['outputs.NodeSwapStatus'] = None):
        """
        NodeSystemInfo is a set of ids/uuids to uniquely identify the node.
        :param _builtins.str architecture: The Architecture reported by the node
        :param _builtins.str boot_id: Boot ID reported by the node.
        :param _builtins.str container_runtime_version: ContainerRuntime Version reported by the node through runtime remote API (e.g. containerd://1.4.2).
        :param _builtins.str kernel_version: Kernel Version reported by the node from 'uname -r' (e.g. 3.16.0-0.bpo.4-amd64).
        :param _builtins.str kube_proxy_version: Deprecated: KubeProxy Version reported by the node.
        :param _builtins.str kubelet_version: Kubelet Version reported by the node.
        :param _builtins.str machine_id: MachineID reported by the node. For unique machine identification in the cluster this field is preferred. Learn more from man(5) machine-id: http://man7.org/linux/man-pages/man5/machine-id.5.html
        :param _builtins.str operating_system: The Operating System reported by the node
        :param _builtins.str os_image: OS Image reported by the node from /etc/os-release (e.g. Debian GNU/Linux 7 (wheezy)).
        :param _builtins.str system_uuid: SystemUUID reported by the node. For unique machine identification MachineID is preferred. This field is specific to Red Hat hosts https://access.redhat.com/documentation/en-us/red_hat_subscription_management/1/html/rhsm/uuid
        :param 'NodeSwapStatusArgs' swap: Swap Info reported by the node.
        """
        pulumi.set(__self__, "architecture", architecture)
        pulumi.set(__self__, "boot_id", boot_id)
        pulumi.set(__self__, "container_runtime_version", container_runtime_version)
        pulumi.set(__self__, "kernel_version", kernel_version)
        pulumi.set(__self__, "kube_proxy_version", kube_proxy_version)
        pulumi.set(__self__, "kubelet_version", kubelet_version)
        pulumi.set(__self__, "machine_id", machine_id)
        pulumi.set(__self__, "operating_system", operating_system)
        pulumi.set(__self__, "os_image", os_image)
        pulumi.set(__self__, "system_uuid", system_uuid)
        if swap is not None:
            pulumi.set(__self__, "swap", swap)

    @_builtins.property
    @pulumi.getter
    def architecture(self) -> _builtins.str:
        """
        The Architecture reported by the node
        """
        return pulumi.get(self, "architecture")

    @_builtins.property
    @pulumi.getter(name="bootID")
    def boot_id(self) -> _builtins.str:
        """
        Boot ID reported by the node.
        """
        return pulumi.get(self, "boot_id")

    @_builtins.property
    @pulumi.getter(name="containerRuntimeVersion")
    def container_runtime_version(self) -> _builtins.str:
        """
        ContainerRuntime Version reported by the node through runtime remote API (e.g. containerd://1.4.2).
        """
        return pulumi.get(self, "container_runtime_version")

    @_builtins.property
    @pulumi.getter(name="kernelVersion")
    def kernel_version(self) -> _builtins.str:
        """
        Kernel Version reported by the node from 'uname -r' (e.g. 3.16.0-0.bpo.4-amd64).
        """
        return pulumi.get(self, "kernel_version")

    @_builtins.property
    @pulumi.getter(name="kubeProxyVersion")
    def kube_proxy_version(self) -> _builtins.str:
        """
        Deprecated: KubeProxy Version reported by the node.
        """
        return pulumi.get(self, "kube_proxy_version")

    @_builtins.property
    @pulumi.getter(name="kubeletVersion")
    def kubelet_version(self) -> _builtins.str:
        """
        Kubelet Version reported by the node.
        """
        return pulumi.get(self, "kubelet_version")

    @_builtins.property
    @pulumi.getter(name="machineID")
    def machine_id(self) -> _builtins.str:
        """
        MachineID reported by the node. For unique machine identification in the cluster this field is preferred. Learn more from man(5) machine-id: http://man7.org/linux/man-pages/man5/machine-id.5.html
        """
        return pulumi.get(self, "machine_id")

    @_builtins.property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> _builtins.str:
        """
        The Operating System reported by the node
        """
        return pulumi.get(self, "operating_system")

    @_builtins.property
    @pulumi.getter(name="osImage")
    def os_image(self) -> _builtins.str:
        """
        OS Image reported by the node from /etc/os-release (e.g. Debian GNU/Linux 7 (wheezy)).
        """
        return pulumi.get(self, "os_image")

    @_builtins.property
    @pulumi.getter(name="systemUUID")
    def system_uuid(self) -> _builtins.str:
        """
        SystemUUID reported by the node. For unique machine identification MachineID is preferred. This field is specific to Red Hat hosts https://access.redhat.com/documentation/en-us/red_hat_subscription_management/1/html/rhsm/uuid
        """
        return pulumi.get(self, "system_uuid")

    @_builtins.property
    @pulumi.getter
    def swap(self) -> Optional['outputs.NodeSwapStatus']:
        """
        Swap Info reported by the node.
        """
        return pulumi.get(self, "swap")


@pulumi.output_type
class NodeSystemInfoPatch(dict):
    """
    NodeSystemInfo is a set of ids/uuids to uniquely identify the node.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bootID":
            suggest = "boot_id"
        elif key == "containerRuntimeVersion":
            suggest = "container_runtime_version"
        elif key == "kernelVersion":
            suggest = "kernel_version"
        elif key == "kubeProxyVersion":
            suggest = "kube_proxy_version"
        elif key == "kubeletVersion":
            suggest = "kubelet_version"
        elif key == "machineID":
            suggest = "machine_id"
        elif key == "operatingSystem":
            suggest = "operating_system"
        elif key == "osImage":
            suggest = "os_image"
        elif key == "systemUUID":
            suggest = "system_uuid"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeSystemInfoPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeSystemInfoPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeSystemInfoPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 architecture: Optional[_builtins.str] = None,
                 boot_id: Optional[_builtins.str] = None,
                 container_runtime_version: Optional[_builtins.str] = None,
                 kernel_version: Optional[_builtins.str] = None,
                 kube_proxy_version: Optional[_builtins.str] = None,
                 kubelet_version: Optional[_builtins.str] = None,
                 machine_id: Optional[_builtins.str] = None,
                 operating_system: Optional[_builtins.str] = None,
                 os_image: Optional[_builtins.str] = None,
                 swap: Optional['outputs.NodeSwapStatusPatch'] = None,
                 system_uuid: Optional[_builtins.str] = None):
        """
        NodeSystemInfo is a set of ids/uuids to uniquely identify the node.
        :param _builtins.str architecture: The Architecture reported by the node
        :param _builtins.str boot_id: Boot ID reported by the node.
        :param _builtins.str container_runtime_version: ContainerRuntime Version reported by the node through runtime remote API (e.g. containerd://1.4.2).
        :param _builtins.str kernel_version: Kernel Version reported by the node from 'uname -r' (e.g. 3.16.0-0.bpo.4-amd64).
        :param _builtins.str kube_proxy_version: Deprecated: KubeProxy Version reported by the node.
        :param _builtins.str kubelet_version: Kubelet Version reported by the node.
        :param _builtins.str machine_id: MachineID reported by the node. For unique machine identification in the cluster this field is preferred. Learn more from man(5) machine-id: http://man7.org/linux/man-pages/man5/machine-id.5.html
        :param _builtins.str operating_system: The Operating System reported by the node
        :param _builtins.str os_image: OS Image reported by the node from /etc/os-release (e.g. Debian GNU/Linux 7 (wheezy)).
        :param 'NodeSwapStatusPatchArgs' swap: Swap Info reported by the node.
        :param _builtins.str system_uuid: SystemUUID reported by the node. For unique machine identification MachineID is preferred. This field is specific to Red Hat hosts https://access.redhat.com/documentation/en-us/red_hat_subscription_management/1/html/rhsm/uuid
        """
        if architecture is not None:
            pulumi.set(__self__, "architecture", architecture)
        if boot_id is not None:
            pulumi.set(__self__, "boot_id", boot_id)
        if container_runtime_version is not None:
            pulumi.set(__self__, "container_runtime_version", container_runtime_version)
        if kernel_version is not None:
            pulumi.set(__self__, "kernel_version", kernel_version)
        if kube_proxy_version is not None:
            pulumi.set(__self__, "kube_proxy_version", kube_proxy_version)
        if kubelet_version is not None:
            pulumi.set(__self__, "kubelet_version", kubelet_version)
        if machine_id is not None:
            pulumi.set(__self__, "machine_id", machine_id)
        if operating_system is not None:
            pulumi.set(__self__, "operating_system", operating_system)
        if os_image is not None:
            pulumi.set(__self__, "os_image", os_image)
        if swap is not None:
            pulumi.set(__self__, "swap", swap)
        if system_uuid is not None:
            pulumi.set(__self__, "system_uuid", system_uuid)

    @_builtins.property
    @pulumi.getter
    def architecture(self) -> Optional[_builtins.str]:
        """
        The Architecture reported by the node
        """
        return pulumi.get(self, "architecture")

    @_builtins.property
    @pulumi.getter(name="bootID")
    def boot_id(self) -> Optional[_builtins.str]:
        """
        Boot ID reported by the node.
        """
        return pulumi.get(self, "boot_id")

    @_builtins.property
    @pulumi.getter(name="containerRuntimeVersion")
    def container_runtime_version(self) -> Optional[_builtins.str]:
        """
        ContainerRuntime Version reported by the node through runtime remote API (e.g. containerd://1.4.2).
        """
        return pulumi.get(self, "container_runtime_version")

    @_builtins.property
    @pulumi.getter(name="kernelVersion")
    def kernel_version(self) -> Optional[_builtins.str]:
        """
        Kernel Version reported by the node from 'uname -r' (e.g. 3.16.0-0.bpo.4-amd64).
        """
        return pulumi.get(self, "kernel_version")

    @_builtins.property
    @pulumi.getter(name="kubeProxyVersion")
    def kube_proxy_version(self) -> Optional[_builtins.str]:
        """
        Deprecated: KubeProxy Version reported by the node.
        """
        return pulumi.get(self, "kube_proxy_version")

    @_builtins.property
    @pulumi.getter(name="kubeletVersion")
    def kubelet_version(self) -> Optional[_builtins.str]:
        """
        Kubelet Version reported by the node.
        """
        return pulumi.get(self, "kubelet_version")

    @_builtins.property
    @pulumi.getter(name="machineID")
    def machine_id(self) -> Optional[_builtins.str]:
        """
        MachineID reported by the node. For unique machine identification in the cluster this field is preferred. Learn more from man(5) machine-id: http://man7.org/linux/man-pages/man5/machine-id.5.html
        """
        return pulumi.get(self, "machine_id")

    @_builtins.property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> Optional[_builtins.str]:
        """
        The Operating System reported by the node
        """
        return pulumi.get(self, "operating_system")

    @_builtins.property
    @pulumi.getter(name="osImage")
    def os_image(self) -> Optional[_builtins.str]:
        """
        OS Image reported by the node from /etc/os-release (e.g. Debian GNU/Linux 7 (wheezy)).
        """
        return pulumi.get(self, "os_image")

    @_builtins.property
    @pulumi.getter
    def swap(self) -> Optional['outputs.NodeSwapStatusPatch']:
        """
        Swap Info reported by the node.
        """
        return pulumi.get(self, "swap")

    @_builtins.property
    @pulumi.getter(name="systemUUID")
    def system_uuid(self) -> Optional[_builtins.str]:
        """
        SystemUUID reported by the node. For unique machine identification MachineID is preferred. This field is specific to Red Hat hosts https://access.redhat.com/documentation/en-us/red_hat_subscription_management/1/html/rhsm/uuid
        """
        return pulumi.get(self, "system_uuid")


@pulumi.output_type
class ObjectFieldSelector(dict):
    """
    ObjectFieldSelector selects an APIVersioned field of an object.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldPath":
            suggest = "field_path"
        elif key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectFieldSelector. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectFieldSelector.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectFieldSelector.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_path: _builtins.str,
                 api_version: Optional[_builtins.str] = None):
        """
        ObjectFieldSelector selects an APIVersioned field of an object.
        :param _builtins.str field_path: Path of the field to select in the specified API version.
        :param _builtins.str api_version: Version of the schema the FieldPath is written in terms of, defaults to "v1".
        """
        pulumi.set(__self__, "field_path", field_path)
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)

    @_builtins.property
    @pulumi.getter(name="fieldPath")
    def field_path(self) -> _builtins.str:
        """
        Path of the field to select in the specified API version.
        """
        return pulumi.get(self, "field_path")

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[_builtins.str]:
        """
        Version of the schema the FieldPath is written in terms of, defaults to "v1".
        """
        return pulumi.get(self, "api_version")


@pulumi.output_type
class ObjectFieldSelectorPatch(dict):
    """
    ObjectFieldSelector selects an APIVersioned field of an object.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"
        elif key == "fieldPath":
            suggest = "field_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectFieldSelectorPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectFieldSelectorPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectFieldSelectorPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[_builtins.str] = None,
                 field_path: Optional[_builtins.str] = None):
        """
        ObjectFieldSelector selects an APIVersioned field of an object.
        :param _builtins.str api_version: Version of the schema the FieldPath is written in terms of, defaults to "v1".
        :param _builtins.str field_path: Path of the field to select in the specified API version.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if field_path is not None:
            pulumi.set(__self__, "field_path", field_path)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[_builtins.str]:
        """
        Version of the schema the FieldPath is written in terms of, defaults to "v1".
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter(name="fieldPath")
    def field_path(self) -> Optional[_builtins.str]:
        """
        Path of the field to select in the specified API version.
        """
        return pulumi.get(self, "field_path")


@pulumi.output_type
class ObjectReference(dict):
    """
    ObjectReference contains enough information to let you inspect or modify the referred object.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"
        elif key == "fieldPath":
            suggest = "field_path"
        elif key == "resourceVersion":
            suggest = "resource_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectReference. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectReference.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectReference.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[_builtins.str] = None,
                 field_path: Optional[_builtins.str] = None,
                 kind: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 namespace: Optional[_builtins.str] = None,
                 resource_version: Optional[_builtins.str] = None,
                 uid: Optional[_builtins.str] = None):
        """
        ObjectReference contains enough information to let you inspect or modify the referred object.
        :param _builtins.str api_version: API version of the referent.
        :param _builtins.str field_path: If referring to a piece of an object instead of an entire object, this string should contain a valid JSON/Go field access statement, such as desiredState.manifest.containers[2]. For example, if the object reference is to a container within a pod, this would take on a value like: "spec.containers{name}" (where "name" refers to the name of the container that triggered the event) or if no container name is specified "spec.containers[2]" (container with index 2 in this pod). This syntax is chosen only to have some well-defined way of referencing a part of an object.
        :param _builtins.str kind: Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param _builtins.str name: Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        :param _builtins.str namespace: Namespace of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/
        :param _builtins.str resource_version: Specific resourceVersion to which this reference is made, if any. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency
        :param _builtins.str uid: UID of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#uids
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if field_path is not None:
            pulumi.set(__self__, "field_path", field_path)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if resource_version is not None:
            pulumi.set(__self__, "resource_version", resource_version)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[_builtins.str]:
        """
        API version of the referent.
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter(name="fieldPath")
    def field_path(self) -> Optional[_builtins.str]:
        """
        If referring to a piece of an object instead of an entire object, this string should contain a valid JSON/Go field access statement, such as desiredState.manifest.containers[2]. For example, if the object reference is to a container within a pod, this would take on a value like: "spec.containers{name}" (where "name" refers to the name of the container that triggered the event) or if no container name is specified "spec.containers[2]" (container with index 2 in this pod). This syntax is chosen only to have some well-defined way of referencing a part of an object.
        """
        return pulumi.get(self, "field_path")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[_builtins.str]:
        """
        Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        Namespace of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="resourceVersion")
    def resource_version(self) -> Optional[_builtins.str]:
        """
        Specific resourceVersion to which this reference is made, if any. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency
        """
        return pulumi.get(self, "resource_version")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[_builtins.str]:
        """
        UID of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#uids
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class ObjectReferencePatch(dict):
    """
    ObjectReference contains enough information to let you inspect or modify the referred object.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"
        elif key == "fieldPath":
            suggest = "field_path"
        elif key == "resourceVersion":
            suggest = "resource_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectReferencePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectReferencePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectReferencePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[_builtins.str] = None,
                 field_path: Optional[_builtins.str] = None,
                 kind: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 namespace: Optional[_builtins.str] = None,
                 resource_version: Optional[_builtins.str] = None,
                 uid: Optional[_builtins.str] = None):
        """
        ObjectReference contains enough information to let you inspect or modify the referred object.
        :param _builtins.str api_version: API version of the referent.
        :param _builtins.str field_path: If referring to a piece of an object instead of an entire object, this string should contain a valid JSON/Go field access statement, such as desiredState.manifest.containers[2]. For example, if the object reference is to a container within a pod, this would take on a value like: "spec.containers{name}" (where "name" refers to the name of the container that triggered the event) or if no container name is specified "spec.containers[2]" (container with index 2 in this pod). This syntax is chosen only to have some well-defined way of referencing a part of an object.
        :param _builtins.str kind: Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param _builtins.str name: Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        :param _builtins.str namespace: Namespace of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/
        :param _builtins.str resource_version: Specific resourceVersion to which this reference is made, if any. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency
        :param _builtins.str uid: UID of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#uids
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if field_path is not None:
            pulumi.set(__self__, "field_path", field_path)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if resource_version is not None:
            pulumi.set(__self__, "resource_version", resource_version)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[_builtins.str]:
        """
        API version of the referent.
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter(name="fieldPath")
    def field_path(self) -> Optional[_builtins.str]:
        """
        If referring to a piece of an object instead of an entire object, this string should contain a valid JSON/Go field access statement, such as desiredState.manifest.containers[2]. For example, if the object reference is to a container within a pod, this would take on a value like: "spec.containers{name}" (where "name" refers to the name of the container that triggered the event) or if no container name is specified "spec.containers[2]" (container with index 2 in this pod). This syntax is chosen only to have some well-defined way of referencing a part of an object.
        """
        return pulumi.get(self, "field_path")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[_builtins.str]:
        """
        Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        Namespace of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="resourceVersion")
    def resource_version(self) -> Optional[_builtins.str]:
        """
        Specific resourceVersion to which this reference is made, if any. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency
        """
        return pulumi.get(self, "resource_version")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[_builtins.str]:
        """
        UID of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#uids
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class PersistentVolume(dict):
    """
    PersistentVolume (PV) is a storage resource provisioned by an administrator. It is analogous to a node. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PersistentVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PersistentVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PersistentVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[_builtins.str] = None,
                 kind: Optional[_builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.PersistentVolumeSpec'] = None,
                 status: Optional['outputs.PersistentVolumeStatus'] = None):
        """
        PersistentVolume (PV) is a storage resource provisioned by an administrator. It is analogous to a node. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes
        :param _builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param _builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param 'PersistentVolumeSpecArgs' spec: spec defines a specification of a persistent volume owned by the cluster. Provisioned by an administrator. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistent-volumes
        :param 'PersistentVolumeStatusArgs' status: status represents the current information/status for the persistent volume. Populated by the system. Read-only. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistent-volumes
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'PersistentVolume')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[_builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[_builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional['outputs.PersistentVolumeSpec']:
        """
        spec defines a specification of a persistent volume owned by the cluster. Provisioned by an administrator. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistent-volumes
        """
        return pulumi.get(self, "spec")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional['outputs.PersistentVolumeStatus']:
        """
        status represents the current information/status for the persistent volume. Populated by the system. Read-only. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistent-volumes
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class PersistentVolumeClaim(dict):
    """
    PersistentVolumeClaim is a user's request for and claim to a persistent volume
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PersistentVolumeClaim. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PersistentVolumeClaim.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PersistentVolumeClaim.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[_builtins.str] = None,
                 kind: Optional[_builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.PersistentVolumeClaimSpec'] = None,
                 status: Optional['outputs.PersistentVolumeClaimStatus'] = None):
        """
        PersistentVolumeClaim is a user's request for and claim to a persistent volume
        :param _builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param _builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param 'PersistentVolumeClaimSpecArgs' spec: spec defines the desired characteristics of a volume requested by a pod author. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
        :param 'PersistentVolumeClaimStatusArgs' status: status represents the current information/status of a persistent volume claim. Read-only. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'PersistentVolumeClaim')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[_builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[_builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional['outputs.PersistentVolumeClaimSpec']:
        """
        spec defines the desired characteristics of a volume requested by a pod author. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
        """
        return pulumi.get(self, "spec")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional['outputs.PersistentVolumeClaimStatus']:
        """
        status represents the current information/status of a persistent volume claim. Read-only. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class PersistentVolumeClaimCondition(dict):
    """
    PersistentVolumeClaimCondition contains details about state of pvc
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastProbeTime":
            suggest = "last_probe_time"
        elif key == "lastTransitionTime":
            suggest = "last_transition_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PersistentVolumeClaimCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PersistentVolumeClaimCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PersistentVolumeClaimCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status: _builtins.str,
                 type: _builtins.str,
                 last_probe_time: Optional[_builtins.str] = None,
                 last_transition_time: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None):
        """
        PersistentVolumeClaimCondition contains details about state of pvc
        :param _builtins.str status: Status is the status of the condition. Can be True, False, Unknown. More info: https://kubernetes.io/docs/reference/kubernetes-api/config-and-storage-resources/persistent-volume-claim-v1/#:~:text=state%20of%20pvc-,conditions.status,-(string)%2C%20required
        :param _builtins.str type: Type is the type of the condition. More info: https://kubernetes.io/docs/reference/kubernetes-api/config-and-storage-resources/persistent-volume-claim-v1/#:~:text=set%20to%20%27ResizeStarted%27.-,PersistentVolumeClaimCondition,-contains%20details%20about
        :param _builtins.str last_probe_time: lastProbeTime is the time we probed the condition.
        :param _builtins.str last_transition_time: lastTransitionTime is the time the condition transitioned from one status to another.
        :param _builtins.str message: message is the human-readable message indicating details about last transition.
        :param _builtins.str reason: reason is a unique, this should be a short, machine understandable string that gives the reason for condition's last transition. If it reports "Resizing" that means the underlying persistent volume is being resized.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if last_probe_time is not None:
            pulumi.set(__self__, "last_probe_time", last_probe_time)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status is the status of the condition. Can be True, False, Unknown. More info: https://kubernetes.io/docs/reference/kubernetes-api/config-and-storage-resources/persistent-volume-claim-v1/#:~:text=state%20of%20pvc-,conditions.status,-(string)%2C%20required
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type is the type of the condition. More info: https://kubernetes.io/docs/reference/kubernetes-api/config-and-storage-resources/persistent-volume-claim-v1/#:~:text=set%20to%20%27ResizeStarted%27.-,PersistentVolumeClaimCondition,-contains%20details%20about
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="lastProbeTime")
    def last_probe_time(self) -> Optional[_builtins.str]:
        """
        lastProbeTime is the time we probed the condition.
        """
        return pulumi.get(self, "last_probe_time")

    @_builtins.property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[_builtins.str]:
        """
        lastTransitionTime is the time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        message is the human-readable message indicating details about last transition.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        reason is a unique, this should be a short, machine understandable string that gives the reason for condition's last transition. If it reports "Resizing" that means the underlying persistent volume is being resized.
        """
        return pulumi.get(self, "reason")


@pulumi.output_type
class PersistentVolumeClaimConditionPatch(dict):
    """
    PersistentVolumeClaimCondition contains details about state of pvc
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastProbeTime":
            suggest = "last_probe_time"
        elif key == "lastTransitionTime":
            suggest = "last_transition_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PersistentVolumeClaimConditionPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PersistentVolumeClaimConditionPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PersistentVolumeClaimConditionPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_probe_time: Optional[_builtins.str] = None,
                 last_transition_time: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        PersistentVolumeClaimCondition contains details about state of pvc
        :param _builtins.str last_probe_time: lastProbeTime is the time we probed the condition.
        :param _builtins.str last_transition_time: lastTransitionTime is the time the condition transitioned from one status to another.
        :param _builtins.str message: message is the human-readable message indicating details about last transition.
        :param _builtins.str reason: reason is a unique, this should be a short, machine understandable string that gives the reason for condition's last transition. If it reports "Resizing" that means the underlying persistent volume is being resized.
        :param _builtins.str status: Status is the status of the condition. Can be True, False, Unknown. More info: https://kubernetes.io/docs/reference/kubernetes-api/config-and-storage-resources/persistent-volume-claim-v1/#:~:text=state%20of%20pvc-,conditions.status,-(string)%2C%20required
        :param _builtins.str type: Type is the type of the condition. More info: https://kubernetes.io/docs/reference/kubernetes-api/config-and-storage-resources/persistent-volume-claim-v1/#:~:text=set%20to%20%27ResizeStarted%27.-,PersistentVolumeClaimCondition,-contains%20details%20about
        """
        if last_probe_time is not None:
            pulumi.set(__self__, "last_probe_time", last_probe_time)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="lastProbeTime")
    def last_probe_time(self) -> Optional[_builtins.str]:
        """
        lastProbeTime is the time we probed the condition.
        """
        return pulumi.get(self, "last_probe_time")

    @_builtins.property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[_builtins.str]:
        """
        lastTransitionTime is the time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        message is the human-readable message indicating details about last transition.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        reason is a unique, this should be a short, machine understandable string that gives the reason for condition's last transition. If it reports "Resizing" that means the underlying persistent volume is being resized.
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Status is the status of the condition. Can be True, False, Unknown. More info: https://kubernetes.io/docs/reference/kubernetes-api/config-and-storage-resources/persistent-volume-claim-v1/#:~:text=state%20of%20pvc-,conditions.status,-(string)%2C%20required
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type is the type of the condition. More info: https://kubernetes.io/docs/reference/kubernetes-api/config-and-storage-resources/persistent-volume-claim-v1/#:~:text=set%20to%20%27ResizeStarted%27.-,PersistentVolumeClaimCondition,-contains%20details%20about
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PersistentVolumeClaimPatch(dict):
    """
    PersistentVolumeClaim is a user's request for and claim to a persistent volume
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PersistentVolumeClaimPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PersistentVolumeClaimPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PersistentVolumeClaimPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[_builtins.str] = None,
                 kind: Optional[_builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMetaPatch'] = None,
                 spec: Optional['outputs.PersistentVolumeClaimSpecPatch'] = None,
                 status: Optional['outputs.PersistentVolumeClaimStatusPatch'] = None):
        """
        PersistentVolumeClaim is a user's request for and claim to a persistent volume
        :param _builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param _builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaPatchArgs' metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param 'PersistentVolumeClaimSpecPatchArgs' spec: spec defines the desired characteristics of a volume requested by a pod author. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
        :param 'PersistentVolumeClaimStatusPatchArgs' status: status represents the current information/status of a persistent volume claim. Read-only. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'PersistentVolumeClaim')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[_builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[_builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMetaPatch']:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional['outputs.PersistentVolumeClaimSpecPatch']:
        """
        spec defines the desired characteristics of a volume requested by a pod author. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
        """
        return pulumi.get(self, "spec")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional['outputs.PersistentVolumeClaimStatusPatch']:
        """
        status represents the current information/status of a persistent volume claim. Read-only. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class PersistentVolumeClaimSpec(dict):
    """
    PersistentVolumeClaimSpec describes the common attributes of storage devices and allows a Source for provider-specific attributes
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessModes":
            suggest = "access_modes"
        elif key == "dataSource":
            suggest = "data_source"
        elif key == "dataSourceRef":
            suggest = "data_source_ref"
        elif key == "storageClassName":
            suggest = "storage_class_name"
        elif key == "volumeAttributesClassName":
            suggest = "volume_attributes_class_name"
        elif key == "volumeMode":
            suggest = "volume_mode"
        elif key == "volumeName":
            suggest = "volume_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PersistentVolumeClaimSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PersistentVolumeClaimSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PersistentVolumeClaimSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_modes: Optional[Sequence[_builtins.str]] = None,
                 data_source: Optional['outputs.TypedLocalObjectReference'] = None,
                 data_source_ref: Optional['outputs.TypedObjectReference'] = None,
                 resources: Optional['outputs.VolumeResourceRequirements'] = None,
                 selector: Optional['_meta.v1.outputs.LabelSelector'] = None,
                 storage_class_name: Optional[_builtins.str] = None,
                 volume_attributes_class_name: Optional[_builtins.str] = None,
                 volume_mode: Optional[_builtins.str] = None,
                 volume_name: Optional[_builtins.str] = None):
        """
        PersistentVolumeClaimSpec describes the common attributes of storage devices and allows a Source for provider-specific attributes
        :param Sequence[_builtins.str] access_modes: accessModes contains the desired access modes the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
        :param 'TypedLocalObjectReferenceArgs' data_source: dataSource field can be used to specify either: * An existing VolumeSnapshot object (snapshot.storage.k8s.io/VolumeSnapshot) * An existing PVC (PersistentVolumeClaim) If the provisioner or an external controller can support the specified data source, it will create a new volume based on the contents of the specified data source. When the AnyVolumeDataSource feature gate is enabled, dataSource contents will be copied to dataSourceRef, and dataSourceRef contents will be copied to dataSource when dataSourceRef.namespace is not specified. If the namespace is specified, then dataSourceRef will not be copied to dataSource.
        :param 'TypedObjectReferenceArgs' data_source_ref: dataSourceRef specifies the object from which to populate the volume with data, if a non-empty volume is desired. This may be any object from a non-empty API group (non core object) or a PersistentVolumeClaim object. When this field is specified, volume binding will only succeed if the type of the specified object matches some installed volume populator or dynamic provisioner. This field will replace the functionality of the dataSource field and as such if both fields are non-empty, they must have the same value. For backwards compatibility, when namespace isn't specified in dataSourceRef, both fields (dataSource and dataSourceRef) will be set to the same value automatically if one of them is empty and the other is non-empty. When namespace is specified in dataSourceRef, dataSource isn't set to the same value and must be empty. There are three important differences between dataSource and dataSourceRef: * While dataSource only allows two specific types of objects, dataSourceRef
                 allows any non-core object, as well as PersistentVolumeClaim objects.
               * While dataSource ignores disallowed values (dropping them), dataSourceRef
                 preserves all values, and generates an error if a disallowed value is
                 specified.
               * While dataSource only allows local objects, dataSourceRef allows objects
                 in any namespaces.
               (Beta) Using this field requires the AnyVolumeDataSource feature gate to be enabled. (Alpha) Using the namespace field of dataSourceRef requires the CrossNamespaceVolumeDataSource feature gate to be enabled.
        :param 'VolumeResourceRequirementsArgs' resources: resources represents the minimum resources the volume should have. If RecoverVolumeExpansionFailure feature is enabled users are allowed to specify resource requirements that are lower than previous value but must still be higher than capacity recorded in the status field of the claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        :param '_meta.v1.LabelSelectorArgs' selector: selector is a label query over volumes to consider for binding.
        :param _builtins.str storage_class_name: storageClassName is the name of the StorageClass required by the claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1
        :param _builtins.str volume_attributes_class_name: volumeAttributesClassName may be used to set the VolumeAttributesClass used by this claim. If specified, the CSI driver will create or update the volume with the attributes defined in the corresponding VolumeAttributesClass. This has a different purpose than storageClassName, it can be changed after the claim is created. An empty string value means that no VolumeAttributesClass will be applied to the claim but it's not allowed to reset this field to empty string once it is set. If unspecified and the PersistentVolumeClaim is unbound, the default VolumeAttributesClass will be set by the persistentvolume controller if it exists. If the resource referred to by volumeAttributesClass does not exist, this PersistentVolumeClaim will be set to a Pending state, as reflected by the modifyVolumeStatus field, until such as a resource exists. More info: https://kubernetes.io/docs/concepts/storage/volume-attributes-classes/ (Beta) Using this field requires the VolumeAttributesClass feature gate to be enabled (off by default).
        :param _builtins.str volume_mode: volumeMode defines what type of volume is required by the claim. Value of Filesystem is implied when not included in claim spec.
        :param _builtins.str volume_name: volumeName is the binding reference to the PersistentVolume backing this claim.
        """
        if access_modes is not None:
            pulumi.set(__self__, "access_modes", access_modes)
        if data_source is not None:
            pulumi.set(__self__, "data_source", data_source)
        if data_source_ref is not None:
            pulumi.set(__self__, "data_source_ref", data_source_ref)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if storage_class_name is not None:
            pulumi.set(__self__, "storage_class_name", storage_class_name)
        if volume_attributes_class_name is not None:
            pulumi.set(__self__, "volume_attributes_class_name", volume_attributes_class_name)
        if volume_mode is not None:
            pulumi.set(__self__, "volume_mode", volume_mode)
        if volume_name is not None:
            pulumi.set(__self__, "volume_name", volume_name)

    @_builtins.property
    @pulumi.getter(name="accessModes")
    def access_modes(self) -> Optional[Sequence[_builtins.str]]:
        """
        accessModes contains the desired access modes the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
        """
        return pulumi.get(self, "access_modes")

    @_builtins.property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> Optional['outputs.TypedLocalObjectReference']:
        """
        dataSource field can be used to specify either: * An existing VolumeSnapshot object (snapshot.storage.k8s.io/VolumeSnapshot) * An existing PVC (PersistentVolumeClaim) If the provisioner or an external controller can support the specified data source, it will create a new volume based on the contents of the specified data source. When the AnyVolumeDataSource feature gate is enabled, dataSource contents will be copied to dataSourceRef, and dataSourceRef contents will be copied to dataSource when dataSourceRef.namespace is not specified. If the namespace is specified, then dataSourceRef will not be copied to dataSource.
        """
        return pulumi.get(self, "data_source")

    @_builtins.property
    @pulumi.getter(name="dataSourceRef")
    def data_source_ref(self) -> Optional['outputs.TypedObjectReference']:
        """
        dataSourceRef specifies the object from which to populate the volume with data, if a non-empty volume is desired. This may be any object from a non-empty API group (non core object) or a PersistentVolumeClaim object. When this field is specified, volume binding will only succeed if the type of the specified object matches some installed volume populator or dynamic provisioner. This field will replace the functionality of the dataSource field and as such if both fields are non-empty, they must have the same value. For backwards compatibility, when namespace isn't specified in dataSourceRef, both fields (dataSource and dataSourceRef) will be set to the same value automatically if one of them is empty and the other is non-empty. When namespace is specified in dataSourceRef, dataSource isn't set to the same value and must be empty. There are three important differences between dataSource and dataSourceRef: * While dataSource only allows two specific types of objects, dataSourceRef
          allows any non-core object, as well as PersistentVolumeClaim objects.
        * While dataSource ignores disallowed values (dropping them), dataSourceRef
          preserves all values, and generates an error if a disallowed value is
          specified.
        * While dataSource only allows local objects, dataSourceRef allows objects
          in any namespaces.
        (Beta) Using this field requires the AnyVolumeDataSource feature gate to be enabled. (Alpha) Using the namespace field of dataSourceRef requires the CrossNamespaceVolumeDataSource feature gate to be enabled.
        """
        return pulumi.get(self, "data_source_ref")

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Optional['outputs.VolumeResourceRequirements']:
        """
        resources represents the minimum resources the volume should have. If RecoverVolumeExpansionFailure feature is enabled users are allowed to specify resource requirements that are lower than previous value but must still be higher than capacity recorded in the status field of the claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        """
        return pulumi.get(self, "resources")

    @_builtins.property
    @pulumi.getter
    def selector(self) -> Optional['_meta.v1.outputs.LabelSelector']:
        """
        selector is a label query over volumes to consider for binding.
        """
        return pulumi.get(self, "selector")

    @_builtins.property
    @pulumi.getter(name="storageClassName")
    def storage_class_name(self) -> Optional[_builtins.str]:
        """
        storageClassName is the name of the StorageClass required by the claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1
        """
        return pulumi.get(self, "storage_class_name")

    @_builtins.property
    @pulumi.getter(name="volumeAttributesClassName")
    def volume_attributes_class_name(self) -> Optional[_builtins.str]:
        """
        volumeAttributesClassName may be used to set the VolumeAttributesClass used by this claim. If specified, the CSI driver will create or update the volume with the attributes defined in the corresponding VolumeAttributesClass. This has a different purpose than storageClassName, it can be changed after the claim is created. An empty string value means that no VolumeAttributesClass will be applied to the claim but it's not allowed to reset this field to empty string once it is set. If unspecified and the PersistentVolumeClaim is unbound, the default VolumeAttributesClass will be set by the persistentvolume controller if it exists. If the resource referred to by volumeAttributesClass does not exist, this PersistentVolumeClaim will be set to a Pending state, as reflected by the modifyVolumeStatus field, until such as a resource exists. More info: https://kubernetes.io/docs/concepts/storage/volume-attributes-classes/ (Beta) Using this field requires the VolumeAttributesClass feature gate to be enabled (off by default).
        """
        return pulumi.get(self, "volume_attributes_class_name")

    @_builtins.property
    @pulumi.getter(name="volumeMode")
    def volume_mode(self) -> Optional[_builtins.str]:
        """
        volumeMode defines what type of volume is required by the claim. Value of Filesystem is implied when not included in claim spec.
        """
        return pulumi.get(self, "volume_mode")

    @_builtins.property
    @pulumi.getter(name="volumeName")
    def volume_name(self) -> Optional[_builtins.str]:
        """
        volumeName is the binding reference to the PersistentVolume backing this claim.
        """
        return pulumi.get(self, "volume_name")


@pulumi.output_type
class PersistentVolumeClaimSpecPatch(dict):
    """
    PersistentVolumeClaimSpec describes the common attributes of storage devices and allows a Source for provider-specific attributes
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessModes":
            suggest = "access_modes"
        elif key == "dataSource":
            suggest = "data_source"
        elif key == "dataSourceRef":
            suggest = "data_source_ref"
        elif key == "storageClassName":
            suggest = "storage_class_name"
        elif key == "volumeAttributesClassName":
            suggest = "volume_attributes_class_name"
        elif key == "volumeMode":
            suggest = "volume_mode"
        elif key == "volumeName":
            suggest = "volume_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PersistentVolumeClaimSpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PersistentVolumeClaimSpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PersistentVolumeClaimSpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_modes: Optional[Sequence[_builtins.str]] = None,
                 data_source: Optional['outputs.TypedLocalObjectReferencePatch'] = None,
                 data_source_ref: Optional['outputs.TypedObjectReferencePatch'] = None,
                 resources: Optional['outputs.VolumeResourceRequirementsPatch'] = None,
                 selector: Optional['_meta.v1.outputs.LabelSelectorPatch'] = None,
                 storage_class_name: Optional[_builtins.str] = None,
                 volume_attributes_class_name: Optional[_builtins.str] = None,
                 volume_mode: Optional[_builtins.str] = None,
                 volume_name: Optional[_builtins.str] = None):
        """
        PersistentVolumeClaimSpec describes the common attributes of storage devices and allows a Source for provider-specific attributes
        :param Sequence[_builtins.str] access_modes: accessModes contains the desired access modes the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
        :param 'TypedLocalObjectReferencePatchArgs' data_source: dataSource field can be used to specify either: * An existing VolumeSnapshot object (snapshot.storage.k8s.io/VolumeSnapshot) * An existing PVC (PersistentVolumeClaim) If the provisioner or an external controller can support the specified data source, it will create a new volume based on the contents of the specified data source. When the AnyVolumeDataSource feature gate is enabled, dataSource contents will be copied to dataSourceRef, and dataSourceRef contents will be copied to dataSource when dataSourceRef.namespace is not specified. If the namespace is specified, then dataSourceRef will not be copied to dataSource.
        :param 'TypedObjectReferencePatchArgs' data_source_ref: dataSourceRef specifies the object from which to populate the volume with data, if a non-empty volume is desired. This may be any object from a non-empty API group (non core object) or a PersistentVolumeClaim object. When this field is specified, volume binding will only succeed if the type of the specified object matches some installed volume populator or dynamic provisioner. This field will replace the functionality of the dataSource field and as such if both fields are non-empty, they must have the same value. For backwards compatibility, when namespace isn't specified in dataSourceRef, both fields (dataSource and dataSourceRef) will be set to the same value automatically if one of them is empty and the other is non-empty. When namespace is specified in dataSourceRef, dataSource isn't set to the same value and must be empty. There are three important differences between dataSource and dataSourceRef: * While dataSource only allows two specific types of objects, dataSourceRef
                 allows any non-core object, as well as PersistentVolumeClaim objects.
               * While dataSource ignores disallowed values (dropping them), dataSourceRef
                 preserves all values, and generates an error if a disallowed value is
                 specified.
               * While dataSource only allows local objects, dataSourceRef allows objects
                 in any namespaces.
               (Beta) Using this field requires the AnyVolumeDataSource feature gate to be enabled. (Alpha) Using the namespace field of dataSourceRef requires the CrossNamespaceVolumeDataSource feature gate to be enabled.
        :param 'VolumeResourceRequirementsPatchArgs' resources: resources represents the minimum resources the volume should have. If RecoverVolumeExpansionFailure feature is enabled users are allowed to specify resource requirements that are lower than previous value but must still be higher than capacity recorded in the status field of the claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        :param '_meta.v1.LabelSelectorPatchArgs' selector: selector is a label query over volumes to consider for binding.
        :param _builtins.str storage_class_name: storageClassName is the name of the StorageClass required by the claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1
        :param _builtins.str volume_attributes_class_name: volumeAttributesClassName may be used to set the VolumeAttributesClass used by this claim. If specified, the CSI driver will create or update the volume with the attributes defined in the corresponding VolumeAttributesClass. This has a different purpose than storageClassName, it can be changed after the claim is created. An empty string value means that no VolumeAttributesClass will be applied to the claim but it's not allowed to reset this field to empty string once it is set. If unspecified and the PersistentVolumeClaim is unbound, the default VolumeAttributesClass will be set by the persistentvolume controller if it exists. If the resource referred to by volumeAttributesClass does not exist, this PersistentVolumeClaim will be set to a Pending state, as reflected by the modifyVolumeStatus field, until such as a resource exists. More info: https://kubernetes.io/docs/concepts/storage/volume-attributes-classes/ (Beta) Using this field requires the VolumeAttributesClass feature gate to be enabled (off by default).
        :param _builtins.str volume_mode: volumeMode defines what type of volume is required by the claim. Value of Filesystem is implied when not included in claim spec.
        :param _builtins.str volume_name: volumeName is the binding reference to the PersistentVolume backing this claim.
        """
        if access_modes is not None:
            pulumi.set(__self__, "access_modes", access_modes)
        if data_source is not None:
            pulumi.set(__self__, "data_source", data_source)
        if data_source_ref is not None:
            pulumi.set(__self__, "data_source_ref", data_source_ref)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if storage_class_name is not None:
            pulumi.set(__self__, "storage_class_name", storage_class_name)
        if volume_attributes_class_name is not None:
            pulumi.set(__self__, "volume_attributes_class_name", volume_attributes_class_name)
        if volume_mode is not None:
            pulumi.set(__self__, "volume_mode", volume_mode)
        if volume_name is not None:
            pulumi.set(__self__, "volume_name", volume_name)

    @_builtins.property
    @pulumi.getter(name="accessModes")
    def access_modes(self) -> Optional[Sequence[_builtins.str]]:
        """
        accessModes contains the desired access modes the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
        """
        return pulumi.get(self, "access_modes")

    @_builtins.property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> Optional['outputs.TypedLocalObjectReferencePatch']:
        """
        dataSource field can be used to specify either: * An existing VolumeSnapshot object (snapshot.storage.k8s.io/VolumeSnapshot) * An existing PVC (PersistentVolumeClaim) If the provisioner or an external controller can support the specified data source, it will create a new volume based on the contents of the specified data source. When the AnyVolumeDataSource feature gate is enabled, dataSource contents will be copied to dataSourceRef, and dataSourceRef contents will be copied to dataSource when dataSourceRef.namespace is not specified. If the namespace is specified, then dataSourceRef will not be copied to dataSource.
        """
        return pulumi.get(self, "data_source")

    @_builtins.property
    @pulumi.getter(name="dataSourceRef")
    def data_source_ref(self) -> Optional['outputs.TypedObjectReferencePatch']:
        """
        dataSourceRef specifies the object from which to populate the volume with data, if a non-empty volume is desired. This may be any object from a non-empty API group (non core object) or a PersistentVolumeClaim object. When this field is specified, volume binding will only succeed if the type of the specified object matches some installed volume populator or dynamic provisioner. This field will replace the functionality of the dataSource field and as such if both fields are non-empty, they must have the same value. For backwards compatibility, when namespace isn't specified in dataSourceRef, both fields (dataSource and dataSourceRef) will be set to the same value automatically if one of them is empty and the other is non-empty. When namespace is specified in dataSourceRef, dataSource isn't set to the same value and must be empty. There are three important differences between dataSource and dataSourceRef: * While dataSource only allows two specific types of objects, dataSourceRef
          allows any non-core object, as well as PersistentVolumeClaim objects.
        * While dataSource ignores disallowed values (dropping them), dataSourceRef
          preserves all values, and generates an error if a disallowed value is
          specified.
        * While dataSource only allows local objects, dataSourceRef allows objects
          in any namespaces.
        (Beta) Using this field requires the AnyVolumeDataSource feature gate to be enabled. (Alpha) Using the namespace field of dataSourceRef requires the CrossNamespaceVolumeDataSource feature gate to be enabled.
        """
        return pulumi.get(self, "data_source_ref")

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Optional['outputs.VolumeResourceRequirementsPatch']:
        """
        resources represents the minimum resources the volume should have. If RecoverVolumeExpansionFailure feature is enabled users are allowed to specify resource requirements that are lower than previous value but must still be higher than capacity recorded in the status field of the claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        """
        return pulumi.get(self, "resources")

    @_builtins.property
    @pulumi.getter
    def selector(self) -> Optional['_meta.v1.outputs.LabelSelectorPatch']:
        """
        selector is a label query over volumes to consider for binding.
        """
        return pulumi.get(self, "selector")

    @_builtins.property
    @pulumi.getter(name="storageClassName")
    def storage_class_name(self) -> Optional[_builtins.str]:
        """
        storageClassName is the name of the StorageClass required by the claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1
        """
        return pulumi.get(self, "storage_class_name")

    @_builtins.property
    @pulumi.getter(name="volumeAttributesClassName")
    def volume_attributes_class_name(self) -> Optional[_builtins.str]:
        """
        volumeAttributesClassName may be used to set the VolumeAttributesClass used by this claim. If specified, the CSI driver will create or update the volume with the attributes defined in the corresponding VolumeAttributesClass. This has a different purpose than storageClassName, it can be changed after the claim is created. An empty string value means that no VolumeAttributesClass will be applied to the claim but it's not allowed to reset this field to empty string once it is set. If unspecified and the PersistentVolumeClaim is unbound, the default VolumeAttributesClass will be set by the persistentvolume controller if it exists. If the resource referred to by volumeAttributesClass does not exist, this PersistentVolumeClaim will be set to a Pending state, as reflected by the modifyVolumeStatus field, until such as a resource exists. More info: https://kubernetes.io/docs/concepts/storage/volume-attributes-classes/ (Beta) Using this field requires the VolumeAttributesClass feature gate to be enabled (off by default).
        """
        return pulumi.get(self, "volume_attributes_class_name")

    @_builtins.property
    @pulumi.getter(name="volumeMode")
    def volume_mode(self) -> Optional[_builtins.str]:
        """
        volumeMode defines what type of volume is required by the claim. Value of Filesystem is implied when not included in claim spec.
        """
        return pulumi.get(self, "volume_mode")

    @_builtins.property
    @pulumi.getter(name="volumeName")
    def volume_name(self) -> Optional[_builtins.str]:
        """
        volumeName is the binding reference to the PersistentVolume backing this claim.
        """
        return pulumi.get(self, "volume_name")


@pulumi.output_type
class PersistentVolumeClaimStatus(dict):
    """
    PersistentVolumeClaimStatus is the current status of a persistent volume claim.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessModes":
            suggest = "access_modes"
        elif key == "allocatedResourceStatuses":
            suggest = "allocated_resource_statuses"
        elif key == "allocatedResources":
            suggest = "allocated_resources"
        elif key == "currentVolumeAttributesClassName":
            suggest = "current_volume_attributes_class_name"
        elif key == "modifyVolumeStatus":
            suggest = "modify_volume_status"
        elif key == "resizeStatus":
            suggest = "resize_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PersistentVolumeClaimStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PersistentVolumeClaimStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PersistentVolumeClaimStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_modes: Optional[Sequence[_builtins.str]] = None,
                 allocated_resource_statuses: Optional[Mapping[str, _builtins.str]] = None,
                 allocated_resources: Optional[Mapping[str, _builtins.str]] = None,
                 capacity: Optional[Mapping[str, _builtins.str]] = None,
                 conditions: Optional[Sequence['outputs.PersistentVolumeClaimCondition']] = None,
                 current_volume_attributes_class_name: Optional[_builtins.str] = None,
                 modify_volume_status: Optional['outputs.ModifyVolumeStatus'] = None,
                 phase: Optional[_builtins.str] = None,
                 resize_status: Optional[_builtins.str] = None):
        """
        PersistentVolumeClaimStatus is the current status of a persistent volume claim.
        :param Sequence[_builtins.str] access_modes: accessModes contains the actual access modes the volume backing the PVC has. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
        :param Mapping[str, _builtins.str] allocated_resource_statuses: allocatedResourceStatuses stores status of resource being resized for the given PVC. Key names follow standard Kubernetes label syntax. Valid values are either:
               	* Un-prefixed keys:
               		- storage - the capacity of the volume.
               	* Custom resources must use implementation-defined prefixed names such as "example.com/my-custom-resource"
               Apart from above values - keys that are unprefixed or have kubernetes.io prefix are considered reserved and hence may not be used.
               
               ClaimResourceStatus can be in any of following states:
               	- ControllerResizeInProgress:
               		State set when resize controller starts resizing the volume in control-plane.
               	- ControllerResizeFailed:
               		State set when resize has failed in resize controller with a terminal error.
               	- NodeResizePending:
               		State set when resize controller has finished resizing the volume but further resizing of
               		volume is needed on the node.
               	- NodeResizeInProgress:
               		State set when kubelet starts resizing the volume.
               	- NodeResizeFailed:
               		State set when resizing has failed in kubelet with a terminal error. Transient errors don't set
               		NodeResizeFailed.
               For example: if expanding a PVC for more capacity - this field can be one of the following states:
               	- pvc.status.allocatedResourceStatus['storage'] = "ControllerResizeInProgress"
                    - pvc.status.allocatedResourceStatus['storage'] = "ControllerResizeFailed"
                    - pvc.status.allocatedResourceStatus['storage'] = "NodeResizePending"
                    - pvc.status.allocatedResourceStatus['storage'] = "NodeResizeInProgress"
                    - pvc.status.allocatedResourceStatus['storage'] = "NodeResizeFailed"
               When this field is not set, it means that no resize operation is in progress for the given PVC.
               
               A controller that receives PVC update with previously unknown resourceName or ClaimResourceStatus should ignore the update for the purpose it was designed. For example - a controller that only is responsible for resizing capacity of the volume, should ignore PVC updates that change other valid resources associated with PVC.
               
               This is an alpha field and requires enabling RecoverVolumeExpansionFailure feature.
        :param Mapping[str, _builtins.str] allocated_resources: allocatedResources tracks the resources allocated to a PVC including its capacity. Key names follow standard Kubernetes label syntax. Valid values are either:
               	* Un-prefixed keys:
               		- storage - the capacity of the volume.
               	* Custom resources must use implementation-defined prefixed names such as "example.com/my-custom-resource"
               Apart from above values - keys that are unprefixed or have kubernetes.io prefix are considered reserved and hence may not be used.
               
               Capacity reported here may be larger than the actual capacity when a volume expansion operation is requested. For storage quota, the larger value from allocatedResources and PVC.spec.resources is used. If allocatedResources is not set, PVC.spec.resources alone is used for quota calculation. If a volume expansion capacity request is lowered, allocatedResources is only lowered if there are no expansion operations in progress and if the actual volume capacity is equal or lower than the requested capacity.
               
               A controller that receives PVC update with previously unknown resourceName should ignore the update for the purpose it was designed. For example - a controller that only is responsible for resizing capacity of the volume, should ignore PVC updates that change other valid resources associated with PVC.
               
               This is an alpha field and requires enabling RecoverVolumeExpansionFailure feature.
        :param Mapping[str, _builtins.str] capacity: capacity represents the actual resources of the underlying volume.
        :param Sequence['PersistentVolumeClaimConditionArgs'] conditions: conditions is the current Condition of persistent volume claim. If underlying persistent volume is being resized then the Condition will be set to 'Resizing'.
        :param _builtins.str current_volume_attributes_class_name: currentVolumeAttributesClassName is the current name of the VolumeAttributesClass the PVC is using. When unset, there is no VolumeAttributeClass applied to this PersistentVolumeClaim This is a beta field and requires enabling VolumeAttributesClass feature (off by default).
        :param 'ModifyVolumeStatusArgs' modify_volume_status: ModifyVolumeStatus represents the status object of ControllerModifyVolume operation. When this is unset, there is no ModifyVolume operation being attempted. This is a beta field and requires enabling VolumeAttributesClass feature (off by default).
        :param _builtins.str phase: phase represents the current phase of PersistentVolumeClaim.
        :param _builtins.str resize_status: resizeStatus stores status of resize operation. ResizeStatus is not set by default but when expansion is complete resizeStatus is set to empty string by resize controller or kubelet. This is an alpha field and requires enabling RecoverVolumeExpansionFailure feature.
        """
        if access_modes is not None:
            pulumi.set(__self__, "access_modes", access_modes)
        if allocated_resource_statuses is not None:
            pulumi.set(__self__, "allocated_resource_statuses", allocated_resource_statuses)
        if allocated_resources is not None:
            pulumi.set(__self__, "allocated_resources", allocated_resources)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if current_volume_attributes_class_name is not None:
            pulumi.set(__self__, "current_volume_attributes_class_name", current_volume_attributes_class_name)
        if modify_volume_status is not None:
            pulumi.set(__self__, "modify_volume_status", modify_volume_status)
        if phase is not None:
            pulumi.set(__self__, "phase", phase)
        if resize_status is not None:
            pulumi.set(__self__, "resize_status", resize_status)

    @_builtins.property
    @pulumi.getter(name="accessModes")
    def access_modes(self) -> Optional[Sequence[_builtins.str]]:
        """
        accessModes contains the actual access modes the volume backing the PVC has. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
        """
        return pulumi.get(self, "access_modes")

    @_builtins.property
    @pulumi.getter(name="allocatedResourceStatuses")
    def allocated_resource_statuses(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        allocatedResourceStatuses stores status of resource being resized for the given PVC. Key names follow standard Kubernetes label syntax. Valid values are either:
        	* Un-prefixed keys:
        		- storage - the capacity of the volume.
        	* Custom resources must use implementation-defined prefixed names such as "example.com/my-custom-resource"
        Apart from above values - keys that are unprefixed or have kubernetes.io prefix are considered reserved and hence may not be used.

        ClaimResourceStatus can be in any of following states:
        	- ControllerResizeInProgress:
        		State set when resize controller starts resizing the volume in control-plane.
        	- ControllerResizeFailed:
        		State set when resize has failed in resize controller with a terminal error.
        	- NodeResizePending:
        		State set when resize controller has finished resizing the volume but further resizing of
        		volume is needed on the node.
        	- NodeResizeInProgress:
        		State set when kubelet starts resizing the volume.
        	- NodeResizeFailed:
        		State set when resizing has failed in kubelet with a terminal error. Transient errors don't set
        		NodeResizeFailed.
        For example: if expanding a PVC for more capacity - this field can be one of the following states:
        	- pvc.status.allocatedResourceStatus['storage'] = "ControllerResizeInProgress"
             - pvc.status.allocatedResourceStatus['storage'] = "ControllerResizeFailed"
             - pvc.status.allocatedResourceStatus['storage'] = "NodeResizePending"
             - pvc.status.allocatedResourceStatus['storage'] = "NodeResizeInProgress"
             - pvc.status.allocatedResourceStatus['storage'] = "NodeResizeFailed"
        When this field is not set, it means that no resize operation is in progress for the given PVC.

        A controller that receives PVC update with previously unknown resourceName or ClaimResourceStatus should ignore the update for the purpose it was designed. For example - a controller that only is responsible for resizing capacity of the volume, should ignore PVC updates that change other valid resources associated with PVC.

        This is an alpha field and requires enabling RecoverVolumeExpansionFailure feature.
        """
        return pulumi.get(self, "allocated_resource_statuses")

    @_builtins.property
    @pulumi.getter(name="allocatedResources")
    def allocated_resources(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        allocatedResources tracks the resources allocated to a PVC including its capacity. Key names follow standard Kubernetes label syntax. Valid values are either:
        	* Un-prefixed keys:
        		- storage - the capacity of the volume.
        	* Custom resources must use implementation-defined prefixed names such as "example.com/my-custom-resource"
        Apart from above values - keys that are unprefixed or have kubernetes.io prefix are considered reserved and hence may not be used.

        Capacity reported here may be larger than the actual capacity when a volume expansion operation is requested. For storage quota, the larger value from allocatedResources and PVC.spec.resources is used. If allocatedResources is not set, PVC.spec.resources alone is used for quota calculation. If a volume expansion capacity request is lowered, allocatedResources is only lowered if there are no expansion operations in progress and if the actual volume capacity is equal or lower than the requested capacity.

        A controller that receives PVC update with previously unknown resourceName should ignore the update for the purpose it was designed. For example - a controller that only is responsible for resizing capacity of the volume, should ignore PVC updates that change other valid resources associated with PVC.

        This is an alpha field and requires enabling RecoverVolumeExpansionFailure feature.
        """
        return pulumi.get(self, "allocated_resources")

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        capacity represents the actual resources of the underlying volume.
        """
        return pulumi.get(self, "capacity")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.PersistentVolumeClaimCondition']]:
        """
        conditions is the current Condition of persistent volume claim. If underlying persistent volume is being resized then the Condition will be set to 'Resizing'.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="currentVolumeAttributesClassName")
    def current_volume_attributes_class_name(self) -> Optional[_builtins.str]:
        """
        currentVolumeAttributesClassName is the current name of the VolumeAttributesClass the PVC is using. When unset, there is no VolumeAttributeClass applied to this PersistentVolumeClaim This is a beta field and requires enabling VolumeAttributesClass feature (off by default).
        """
        return pulumi.get(self, "current_volume_attributes_class_name")

    @_builtins.property
    @pulumi.getter(name="modifyVolumeStatus")
    def modify_volume_status(self) -> Optional['outputs.ModifyVolumeStatus']:
        """
        ModifyVolumeStatus represents the status object of ControllerModifyVolume operation. When this is unset, there is no ModifyVolume operation being attempted. This is a beta field and requires enabling VolumeAttributesClass feature (off by default).
        """
        return pulumi.get(self, "modify_volume_status")

    @_builtins.property
    @pulumi.getter
    def phase(self) -> Optional[_builtins.str]:
        """
        phase represents the current phase of PersistentVolumeClaim.
        """
        return pulumi.get(self, "phase")

    @_builtins.property
    @pulumi.getter(name="resizeStatus")
    def resize_status(self) -> Optional[_builtins.str]:
        """
        resizeStatus stores status of resize operation. ResizeStatus is not set by default but when expansion is complete resizeStatus is set to empty string by resize controller or kubelet. This is an alpha field and requires enabling RecoverVolumeExpansionFailure feature.
        """
        return pulumi.get(self, "resize_status")


@pulumi.output_type
class PersistentVolumeClaimStatusPatch(dict):
    """
    PersistentVolumeClaimStatus is the current status of a persistent volume claim.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessModes":
            suggest = "access_modes"
        elif key == "allocatedResourceStatuses":
            suggest = "allocated_resource_statuses"
        elif key == "allocatedResources":
            suggest = "allocated_resources"
        elif key == "currentVolumeAttributesClassName":
            suggest = "current_volume_attributes_class_name"
        elif key == "modifyVolumeStatus":
            suggest = "modify_volume_status"
        elif key == "resizeStatus":
            suggest = "resize_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PersistentVolumeClaimStatusPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PersistentVolumeClaimStatusPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PersistentVolumeClaimStatusPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_modes: Optional[Sequence[_builtins.str]] = None,
                 allocated_resource_statuses: Optional[Mapping[str, _builtins.str]] = None,
                 allocated_resources: Optional[Mapping[str, _builtins.str]] = None,
                 capacity: Optional[Mapping[str, _builtins.str]] = None,
                 conditions: Optional[Sequence['outputs.PersistentVolumeClaimConditionPatch']] = None,
                 current_volume_attributes_class_name: Optional[_builtins.str] = None,
                 modify_volume_status: Optional['outputs.ModifyVolumeStatusPatch'] = None,
                 phase: Optional[_builtins.str] = None,
                 resize_status: Optional[_builtins.str] = None):
        """
        PersistentVolumeClaimStatus is the current status of a persistent volume claim.
        :param Sequence[_builtins.str] access_modes: accessModes contains the actual access modes the volume backing the PVC has. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
        :param Mapping[str, _builtins.str] allocated_resource_statuses: allocatedResourceStatuses stores status of resource being resized for the given PVC. Key names follow standard Kubernetes label syntax. Valid values are either:
               	* Un-prefixed keys:
               		- storage - the capacity of the volume.
               	* Custom resources must use implementation-defined prefixed names such as "example.com/my-custom-resource"
               Apart from above values - keys that are unprefixed or have kubernetes.io prefix are considered reserved and hence may not be used.
               
               ClaimResourceStatus can be in any of following states:
               	- ControllerResizeInProgress:
               		State set when resize controller starts resizing the volume in control-plane.
               	- ControllerResizeFailed:
               		State set when resize has failed in resize controller with a terminal error.
               	- NodeResizePending:
               		State set when resize controller has finished resizing the volume but further resizing of
               		volume is needed on the node.
               	- NodeResizeInProgress:
               		State set when kubelet starts resizing the volume.
               	- NodeResizeFailed:
               		State set when resizing has failed in kubelet with a terminal error. Transient errors don't set
               		NodeResizeFailed.
               For example: if expanding a PVC for more capacity - this field can be one of the following states:
               	- pvc.status.allocatedResourceStatus['storage'] = "ControllerResizeInProgress"
                    - pvc.status.allocatedResourceStatus['storage'] = "ControllerResizeFailed"
                    - pvc.status.allocatedResourceStatus['storage'] = "NodeResizePending"
                    - pvc.status.allocatedResourceStatus['storage'] = "NodeResizeInProgress"
                    - pvc.status.allocatedResourceStatus['storage'] = "NodeResizeFailed"
               When this field is not set, it means that no resize operation is in progress for the given PVC.
               
               A controller that receives PVC update with previously unknown resourceName or ClaimResourceStatus should ignore the update for the purpose it was designed. For example - a controller that only is responsible for resizing capacity of the volume, should ignore PVC updates that change other valid resources associated with PVC.
               
               This is an alpha field and requires enabling RecoverVolumeExpansionFailure feature.
        :param Mapping[str, _builtins.str] allocated_resources: allocatedResources tracks the resources allocated to a PVC including its capacity. Key names follow standard Kubernetes label syntax. Valid values are either:
               	* Un-prefixed keys:
               		- storage - the capacity of the volume.
               	* Custom resources must use implementation-defined prefixed names such as "example.com/my-custom-resource"
               Apart from above values - keys that are unprefixed or have kubernetes.io prefix are considered reserved and hence may not be used.
               
               Capacity reported here may be larger than the actual capacity when a volume expansion operation is requested. For storage quota, the larger value from allocatedResources and PVC.spec.resources is used. If allocatedResources is not set, PVC.spec.resources alone is used for quota calculation. If a volume expansion capacity request is lowered, allocatedResources is only lowered if there are no expansion operations in progress and if the actual volume capacity is equal or lower than the requested capacity.
               
               A controller that receives PVC update with previously unknown resourceName should ignore the update for the purpose it was designed. For example - a controller that only is responsible for resizing capacity of the volume, should ignore PVC updates that change other valid resources associated with PVC.
               
               This is an alpha field and requires enabling RecoverVolumeExpansionFailure feature.
        :param Mapping[str, _builtins.str] capacity: capacity represents the actual resources of the underlying volume.
        :param Sequence['PersistentVolumeClaimConditionPatchArgs'] conditions: conditions is the current Condition of persistent volume claim. If underlying persistent volume is being resized then the Condition will be set to 'Resizing'.
        :param _builtins.str current_volume_attributes_class_name: currentVolumeAttributesClassName is the current name of the VolumeAttributesClass the PVC is using. When unset, there is no VolumeAttributeClass applied to this PersistentVolumeClaim This is a beta field and requires enabling VolumeAttributesClass feature (off by default).
        :param 'ModifyVolumeStatusPatchArgs' modify_volume_status: ModifyVolumeStatus represents the status object of ControllerModifyVolume operation. When this is unset, there is no ModifyVolume operation being attempted. This is a beta field and requires enabling VolumeAttributesClass feature (off by default).
        :param _builtins.str phase: phase represents the current phase of PersistentVolumeClaim.
        :param _builtins.str resize_status: resizeStatus stores status of resize operation. ResizeStatus is not set by default but when expansion is complete resizeStatus is set to empty string by resize controller or kubelet. This is an alpha field and requires enabling RecoverVolumeExpansionFailure feature.
        """
        if access_modes is not None:
            pulumi.set(__self__, "access_modes", access_modes)
        if allocated_resource_statuses is not None:
            pulumi.set(__self__, "allocated_resource_statuses", allocated_resource_statuses)
        if allocated_resources is not None:
            pulumi.set(__self__, "allocated_resources", allocated_resources)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if current_volume_attributes_class_name is not None:
            pulumi.set(__self__, "current_volume_attributes_class_name", current_volume_attributes_class_name)
        if modify_volume_status is not None:
            pulumi.set(__self__, "modify_volume_status", modify_volume_status)
        if phase is not None:
            pulumi.set(__self__, "phase", phase)
        if resize_status is not None:
            pulumi.set(__self__, "resize_status", resize_status)

    @_builtins.property
    @pulumi.getter(name="accessModes")
    def access_modes(self) -> Optional[Sequence[_builtins.str]]:
        """
        accessModes contains the actual access modes the volume backing the PVC has. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
        """
        return pulumi.get(self, "access_modes")

    @_builtins.property
    @pulumi.getter(name="allocatedResourceStatuses")
    def allocated_resource_statuses(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        allocatedResourceStatuses stores status of resource being resized for the given PVC. Key names follow standard Kubernetes label syntax. Valid values are either:
        	* Un-prefixed keys:
        		- storage - the capacity of the volume.
        	* Custom resources must use implementation-defined prefixed names such as "example.com/my-custom-resource"
        Apart from above values - keys that are unprefixed or have kubernetes.io prefix are considered reserved and hence may not be used.

        ClaimResourceStatus can be in any of following states:
        	- ControllerResizeInProgress:
        		State set when resize controller starts resizing the volume in control-plane.
        	- ControllerResizeFailed:
        		State set when resize has failed in resize controller with a terminal error.
        	- NodeResizePending:
        		State set when resize controller has finished resizing the volume but further resizing of
        		volume is needed on the node.
        	- NodeResizeInProgress:
        		State set when kubelet starts resizing the volume.
        	- NodeResizeFailed:
        		State set when resizing has failed in kubelet with a terminal error. Transient errors don't set
        		NodeResizeFailed.
        For example: if expanding a PVC for more capacity - this field can be one of the following states:
        	- pvc.status.allocatedResourceStatus['storage'] = "ControllerResizeInProgress"
             - pvc.status.allocatedResourceStatus['storage'] = "ControllerResizeFailed"
             - pvc.status.allocatedResourceStatus['storage'] = "NodeResizePending"
             - pvc.status.allocatedResourceStatus['storage'] = "NodeResizeInProgress"
             - pvc.status.allocatedResourceStatus['storage'] = "NodeResizeFailed"
        When this field is not set, it means that no resize operation is in progress for the given PVC.

        A controller that receives PVC update with previously unknown resourceName or ClaimResourceStatus should ignore the update for the purpose it was designed. For example - a controller that only is responsible for resizing capacity of the volume, should ignore PVC updates that change other valid resources associated with PVC.

        This is an alpha field and requires enabling RecoverVolumeExpansionFailure feature.
        """
        return pulumi.get(self, "allocated_resource_statuses")

    @_builtins.property
    @pulumi.getter(name="allocatedResources")
    def allocated_resources(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        allocatedResources tracks the resources allocated to a PVC including its capacity. Key names follow standard Kubernetes label syntax. Valid values are either:
        	* Un-prefixed keys:
        		- storage - the capacity of the volume.
        	* Custom resources must use implementation-defined prefixed names such as "example.com/my-custom-resource"
        Apart from above values - keys that are unprefixed or have kubernetes.io prefix are considered reserved and hence may not be used.

        Capacity reported here may be larger than the actual capacity when a volume expansion operation is requested. For storage quota, the larger value from allocatedResources and PVC.spec.resources is used. If allocatedResources is not set, PVC.spec.resources alone is used for quota calculation. If a volume expansion capacity request is lowered, allocatedResources is only lowered if there are no expansion operations in progress and if the actual volume capacity is equal or lower than the requested capacity.

        A controller that receives PVC update with previously unknown resourceName should ignore the update for the purpose it was designed. For example - a controller that only is responsible for resizing capacity of the volume, should ignore PVC updates that change other valid resources associated with PVC.

        This is an alpha field and requires enabling RecoverVolumeExpansionFailure feature.
        """
        return pulumi.get(self, "allocated_resources")

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        capacity represents the actual resources of the underlying volume.
        """
        return pulumi.get(self, "capacity")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.PersistentVolumeClaimConditionPatch']]:
        """
        conditions is the current Condition of persistent volume claim. If underlying persistent volume is being resized then the Condition will be set to 'Resizing'.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="currentVolumeAttributesClassName")
    def current_volume_attributes_class_name(self) -> Optional[_builtins.str]:
        """
        currentVolumeAttributesClassName is the current name of the VolumeAttributesClass the PVC is using. When unset, there is no VolumeAttributeClass applied to this PersistentVolumeClaim This is a beta field and requires enabling VolumeAttributesClass feature (off by default).
        """
        return pulumi.get(self, "current_volume_attributes_class_name")

    @_builtins.property
    @pulumi.getter(name="modifyVolumeStatus")
    def modify_volume_status(self) -> Optional['outputs.ModifyVolumeStatusPatch']:
        """
        ModifyVolumeStatus represents the status object of ControllerModifyVolume operation. When this is unset, there is no ModifyVolume operation being attempted. This is a beta field and requires enabling VolumeAttributesClass feature (off by default).
        """
        return pulumi.get(self, "modify_volume_status")

    @_builtins.property
    @pulumi.getter
    def phase(self) -> Optional[_builtins.str]:
        """
        phase represents the current phase of PersistentVolumeClaim.
        """
        return pulumi.get(self, "phase")

    @_builtins.property
    @pulumi.getter(name="resizeStatus")
    def resize_status(self) -> Optional[_builtins.str]:
        """
        resizeStatus stores status of resize operation. ResizeStatus is not set by default but when expansion is complete resizeStatus is set to empty string by resize controller or kubelet. This is an alpha field and requires enabling RecoverVolumeExpansionFailure feature.
        """
        return pulumi.get(self, "resize_status")


@pulumi.output_type
class PersistentVolumeClaimTemplate(dict):
    """
    PersistentVolumeClaimTemplate is used to produce PersistentVolumeClaim objects as part of an EphemeralVolumeSource.
    """
    def __init__(__self__, *,
                 spec: 'outputs.PersistentVolumeClaimSpec',
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None):
        """
        PersistentVolumeClaimTemplate is used to produce PersistentVolumeClaim objects as part of an EphemeralVolumeSource.
        :param 'PersistentVolumeClaimSpecArgs' spec: The specification for the PersistentVolumeClaim. The entire content is copied unchanged into the PVC that gets created from this template. The same fields as in a PersistentVolumeClaim are also valid here.
        :param '_meta.v1.ObjectMetaArgs' metadata: May contain labels and annotations that will be copied into the PVC when creating it. No other fields are allowed and will be rejected during validation.
        """
        pulumi.set(__self__, "spec", spec)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @_builtins.property
    @pulumi.getter
    def spec(self) -> 'outputs.PersistentVolumeClaimSpec':
        """
        The specification for the PersistentVolumeClaim. The entire content is copied unchanged into the PVC that gets created from this template. The same fields as in a PersistentVolumeClaim are also valid here.
        """
        return pulumi.get(self, "spec")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        May contain labels and annotations that will be copied into the PVC when creating it. No other fields are allowed and will be rejected during validation.
        """
        return pulumi.get(self, "metadata")


@pulumi.output_type
class PersistentVolumeClaimTemplatePatch(dict):
    """
    PersistentVolumeClaimTemplate is used to produce PersistentVolumeClaim objects as part of an EphemeralVolumeSource.
    """
    def __init__(__self__, *,
                 metadata: Optional['_meta.v1.outputs.ObjectMetaPatch'] = None,
                 spec: Optional['outputs.PersistentVolumeClaimSpecPatch'] = None):
        """
        PersistentVolumeClaimTemplate is used to produce PersistentVolumeClaim objects as part of an EphemeralVolumeSource.
        :param '_meta.v1.ObjectMetaPatchArgs' metadata: May contain labels and annotations that will be copied into the PVC when creating it. No other fields are allowed and will be rejected during validation.
        :param 'PersistentVolumeClaimSpecPatchArgs' spec: The specification for the PersistentVolumeClaim. The entire content is copied unchanged into the PVC that gets created from this template. The same fields as in a PersistentVolumeClaim are also valid here.
        """
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMetaPatch']:
        """
        May contain labels and annotations that will be copied into the PVC when creating it. No other fields are allowed and will be rejected during validation.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional['outputs.PersistentVolumeClaimSpecPatch']:
        """
        The specification for the PersistentVolumeClaim. The entire content is copied unchanged into the PVC that gets created from this template. The same fields as in a PersistentVolumeClaim are also valid here.
        """
        return pulumi.get(self, "spec")


@pulumi.output_type
class PersistentVolumeClaimVolumeSource(dict):
    """
    PersistentVolumeClaimVolumeSource references the user's PVC in the same namespace. This volume finds the bound PV and mounts that volume for the pod. A PersistentVolumeClaimVolumeSource is, essentially, a wrapper around another type of volume that is owned by someone else (the system).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "claimName":
            suggest = "claim_name"
        elif key == "readOnly":
            suggest = "read_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PersistentVolumeClaimVolumeSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PersistentVolumeClaimVolumeSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PersistentVolumeClaimVolumeSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 claim_name: _builtins.str,
                 read_only: Optional[_builtins.bool] = None):
        """
        PersistentVolumeClaimVolumeSource references the user's PVC in the same namespace. This volume finds the bound PV and mounts that volume for the pod. A PersistentVolumeClaimVolumeSource is, essentially, a wrapper around another type of volume that is owned by someone else (the system).
        :param _builtins.str claim_name: claimName is the name of a PersistentVolumeClaim in the same namespace as the pod using this volume. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
        :param _builtins.bool read_only: readOnly Will force the ReadOnly setting in VolumeMounts. Default false.
        """
        pulumi.set(__self__, "claim_name", claim_name)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @_builtins.property
    @pulumi.getter(name="claimName")
    def claim_name(self) -> _builtins.str:
        """
        claimName is the name of a PersistentVolumeClaim in the same namespace as the pod using this volume. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
        """
        return pulumi.get(self, "claim_name")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        readOnly Will force the ReadOnly setting in VolumeMounts. Default false.
        """
        return pulumi.get(self, "read_only")


@pulumi.output_type
class PersistentVolumeClaimVolumeSourcePatch(dict):
    """
    PersistentVolumeClaimVolumeSource references the user's PVC in the same namespace. This volume finds the bound PV and mounts that volume for the pod. A PersistentVolumeClaimVolumeSource is, essentially, a wrapper around another type of volume that is owned by someone else (the system).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "claimName":
            suggest = "claim_name"
        elif key == "readOnly":
            suggest = "read_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PersistentVolumeClaimVolumeSourcePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PersistentVolumeClaimVolumeSourcePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PersistentVolumeClaimVolumeSourcePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 claim_name: Optional[_builtins.str] = None,
                 read_only: Optional[_builtins.bool] = None):
        """
        PersistentVolumeClaimVolumeSource references the user's PVC in the same namespace. This volume finds the bound PV and mounts that volume for the pod. A PersistentVolumeClaimVolumeSource is, essentially, a wrapper around another type of volume that is owned by someone else (the system).
        :param _builtins.str claim_name: claimName is the name of a PersistentVolumeClaim in the same namespace as the pod using this volume. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
        :param _builtins.bool read_only: readOnly Will force the ReadOnly setting in VolumeMounts. Default false.
        """
        if claim_name is not None:
            pulumi.set(__self__, "claim_name", claim_name)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @_builtins.property
    @pulumi.getter(name="claimName")
    def claim_name(self) -> Optional[_builtins.str]:
        """
        claimName is the name of a PersistentVolumeClaim in the same namespace as the pod using this volume. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
        """
        return pulumi.get(self, "claim_name")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        readOnly Will force the ReadOnly setting in VolumeMounts. Default false.
        """
        return pulumi.get(self, "read_only")


@pulumi.output_type
class PersistentVolumeSpec(dict):
    """
    PersistentVolumeSpec is the specification of a persistent volume.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessModes":
            suggest = "access_modes"
        elif key == "awsElasticBlockStore":
            suggest = "aws_elastic_block_store"
        elif key == "azureDisk":
            suggest = "azure_disk"
        elif key == "azureFile":
            suggest = "azure_file"
        elif key == "claimRef":
            suggest = "claim_ref"
        elif key == "flexVolume":
            suggest = "flex_volume"
        elif key == "gcePersistentDisk":
            suggest = "gce_persistent_disk"
        elif key == "hostPath":
            suggest = "host_path"
        elif key == "mountOptions":
            suggest = "mount_options"
        elif key == "nodeAffinity":
            suggest = "node_affinity"
        elif key == "persistentVolumeReclaimPolicy":
            suggest = "persistent_volume_reclaim_policy"
        elif key == "photonPersistentDisk":
            suggest = "photon_persistent_disk"
        elif key == "portworxVolume":
            suggest = "portworx_volume"
        elif key == "scaleIO":
            suggest = "scale_io"
        elif key == "storageClassName":
            suggest = "storage_class_name"
        elif key == "volumeAttributesClassName":
            suggest = "volume_attributes_class_name"
        elif key == "volumeMode":
            suggest = "volume_mode"
        elif key == "vsphereVolume":
            suggest = "vsphere_volume"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PersistentVolumeSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PersistentVolumeSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PersistentVolumeSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_modes: Optional[Sequence[_builtins.str]] = None,
                 aws_elastic_block_store: Optional['outputs.AWSElasticBlockStoreVolumeSource'] = None,
                 azure_disk: Optional['outputs.AzureDiskVolumeSource'] = None,
                 azure_file: Optional['outputs.AzureFilePersistentVolumeSource'] = None,
                 capacity: Optional[Mapping[str, _builtins.str]] = None,
                 cephfs: Optional['outputs.CephFSPersistentVolumeSource'] = None,
                 cinder: Optional['outputs.CinderPersistentVolumeSource'] = None,
                 claim_ref: Optional['outputs.ObjectReference'] = None,
                 csi: Optional['outputs.CSIPersistentVolumeSource'] = None,
                 fc: Optional['outputs.FCVolumeSource'] = None,
                 flex_volume: Optional['outputs.FlexPersistentVolumeSource'] = None,
                 flocker: Optional['outputs.FlockerVolumeSource'] = None,
                 gce_persistent_disk: Optional['outputs.GCEPersistentDiskVolumeSource'] = None,
                 glusterfs: Optional['outputs.GlusterfsPersistentVolumeSource'] = None,
                 host_path: Optional['outputs.HostPathVolumeSource'] = None,
                 iscsi: Optional['outputs.ISCSIPersistentVolumeSource'] = None,
                 local: Optional['outputs.LocalVolumeSource'] = None,
                 mount_options: Optional[Sequence[_builtins.str]] = None,
                 nfs: Optional['outputs.NFSVolumeSource'] = None,
                 node_affinity: Optional['outputs.VolumeNodeAffinity'] = None,
                 persistent_volume_reclaim_policy: Optional[_builtins.str] = None,
                 photon_persistent_disk: Optional['outputs.PhotonPersistentDiskVolumeSource'] = None,
                 portworx_volume: Optional['outputs.PortworxVolumeSource'] = None,
                 quobyte: Optional['outputs.QuobyteVolumeSource'] = None,
                 rbd: Optional['outputs.RBDPersistentVolumeSource'] = None,
                 scale_io: Optional['outputs.ScaleIOPersistentVolumeSource'] = None,
                 storage_class_name: Optional[_builtins.str] = None,
                 storageos: Optional['outputs.StorageOSPersistentVolumeSource'] = None,
                 volume_attributes_class_name: Optional[_builtins.str] = None,
                 volume_mode: Optional[_builtins.str] = None,
                 vsphere_volume: Optional['outputs.VsphereVirtualDiskVolumeSource'] = None):
        """
        PersistentVolumeSpec is the specification of a persistent volume.
        :param Sequence[_builtins.str] access_modes: accessModes contains all ways the volume can be mounted. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes
        :param 'AWSElasticBlockStoreVolumeSourceArgs' aws_elastic_block_store: awsElasticBlockStore represents an AWS Disk resource that is attached to a kubelet's host machine and then exposed to the pod. Deprecated: AWSElasticBlockStore is deprecated. All operations for the in-tree awsElasticBlockStore type are redirected to the ebs.csi.aws.com CSI driver. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        :param 'AzureDiskVolumeSourceArgs' azure_disk: azureDisk represents an Azure Data Disk mount on the host and bind mount to the pod. Deprecated: AzureDisk is deprecated. All operations for the in-tree azureDisk type are redirected to the disk.csi.azure.com CSI driver.
        :param 'AzureFilePersistentVolumeSourceArgs' azure_file: azureFile represents an Azure File Service mount on the host and bind mount to the pod. Deprecated: AzureFile is deprecated. All operations for the in-tree azureFile type are redirected to the file.csi.azure.com CSI driver.
        :param Mapping[str, _builtins.str] capacity: capacity is the description of the persistent volume's resources and capacity. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#capacity
        :param 'CephFSPersistentVolumeSourceArgs' cephfs: cephFS represents a Ceph FS mount on the host that shares a pod's lifetime. Deprecated: CephFS is deprecated and the in-tree cephfs type is no longer supported.
        :param 'CinderPersistentVolumeSourceArgs' cinder: cinder represents a cinder volume attached and mounted on kubelets host machine. Deprecated: Cinder is deprecated. All operations for the in-tree cinder type are redirected to the cinder.csi.openstack.org CSI driver. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        :param 'ObjectReferenceArgs' claim_ref: claimRef is part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim. Expected to be non-nil when bound. claim.VolumeName is the authoritative bind between PV and PVC. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#binding
        :param 'CSIPersistentVolumeSourceArgs' csi: csi represents storage that is handled by an external CSI driver.
        :param 'FCVolumeSourceArgs' fc: fc represents a Fibre Channel resource that is attached to a kubelet's host machine and then exposed to the pod.
        :param 'FlexPersistentVolumeSourceArgs' flex_volume: flexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin. Deprecated: FlexVolume is deprecated. Consider using a CSIDriver instead.
        :param 'FlockerVolumeSourceArgs' flocker: flocker represents a Flocker volume attached to a kubelet's host machine and exposed to the pod for its usage. This depends on the Flocker control service being running. Deprecated: Flocker is deprecated and the in-tree flocker type is no longer supported.
        :param 'GCEPersistentDiskVolumeSourceArgs' gce_persistent_disk: gcePersistentDisk represents a GCE Disk resource that is attached to a kubelet's host machine and then exposed to the pod. Provisioned by an admin. Deprecated: GCEPersistentDisk is deprecated. All operations for the in-tree gcePersistentDisk type are redirected to the pd.csi.storage.gke.io CSI driver. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        :param 'GlusterfsPersistentVolumeSourceArgs' glusterfs: glusterfs represents a Glusterfs volume that is attached to a host and exposed to the pod. Provisioned by an admin. Deprecated: Glusterfs is deprecated and the in-tree glusterfs type is no longer supported. More info: https://examples.k8s.io/volumes/glusterfs/README.md
        :param 'HostPathVolumeSourceArgs' host_path: hostPath represents a directory on the host. Provisioned by a developer or tester. This is useful for single-node development and testing only! On-host storage is not supported in any way and WILL NOT WORK in a multi-node cluster. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
        :param 'ISCSIPersistentVolumeSourceArgs' iscsi: iscsi represents an ISCSI Disk resource that is attached to a kubelet's host machine and then exposed to the pod. Provisioned by an admin.
        :param 'LocalVolumeSourceArgs' local: local represents directly-attached storage with node affinity
        :param Sequence[_builtins.str] mount_options: mountOptions is the list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#mount-options
        :param 'NFSVolumeSourceArgs' nfs: nfs represents an NFS mount on the host. Provisioned by an admin. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
        :param 'VolumeNodeAffinityArgs' node_affinity: nodeAffinity defines constraints that limit what nodes this volume can be accessed from. This field influences the scheduling of pods that use this volume.
        :param _builtins.str persistent_volume_reclaim_policy: persistentVolumeReclaimPolicy defines what happens to a persistent volume when released from its claim. Valid options are Retain (default for manually created PersistentVolumes), Delete (default for dynamically provisioned PersistentVolumes), and Recycle (deprecated). Recycle must be supported by the volume plugin underlying this PersistentVolume. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#reclaiming
        :param 'PhotonPersistentDiskVolumeSourceArgs' photon_persistent_disk: photonPersistentDisk represents a PhotonController persistent disk attached and mounted on kubelets host machine. Deprecated: PhotonPersistentDisk is deprecated and the in-tree photonPersistentDisk type is no longer supported.
        :param 'PortworxVolumeSourceArgs' portworx_volume: portworxVolume represents a portworx volume attached and mounted on kubelets host machine. Deprecated: PortworxVolume is deprecated. All operations for the in-tree portworxVolume type are redirected to the pxd.portworx.com CSI driver when the CSIMigrationPortworx feature-gate is on.
        :param 'QuobyteVolumeSourceArgs' quobyte: quobyte represents a Quobyte mount on the host that shares a pod's lifetime. Deprecated: Quobyte is deprecated and the in-tree quobyte type is no longer supported.
        :param 'RBDPersistentVolumeSourceArgs' rbd: rbd represents a Rados Block Device mount on the host that shares a pod's lifetime. Deprecated: RBD is deprecated and the in-tree rbd type is no longer supported. More info: https://examples.k8s.io/volumes/rbd/README.md
        :param 'ScaleIOPersistentVolumeSourceArgs' scale_io: scaleIO represents a ScaleIO persistent volume attached and mounted on Kubernetes nodes. Deprecated: ScaleIO is deprecated and the in-tree scaleIO type is no longer supported.
        :param _builtins.str storage_class_name: storageClassName is the name of StorageClass to which this persistent volume belongs. Empty value means that this volume does not belong to any StorageClass.
        :param 'StorageOSPersistentVolumeSourceArgs' storageos: storageOS represents a StorageOS volume that is attached to the kubelet's host machine and mounted into the pod. Deprecated: StorageOS is deprecated and the in-tree storageos type is no longer supported. More info: https://examples.k8s.io/volumes/storageos/README.md
        :param _builtins.str volume_attributes_class_name: Name of VolumeAttributesClass to which this persistent volume belongs. Empty value is not allowed. When this field is not set, it indicates that this volume does not belong to any VolumeAttributesClass. This field is mutable and can be changed by the CSI driver after a volume has been updated successfully to a new class. For an unbound PersistentVolume, the volumeAttributesClassName will be matched with unbound PersistentVolumeClaims during the binding process. This is a beta field and requires enabling VolumeAttributesClass feature (off by default).
        :param _builtins.str volume_mode: volumeMode defines if a volume is intended to be used with a formatted filesystem or to remain in raw block state. Value of Filesystem is implied when not included in spec.
        :param 'VsphereVirtualDiskVolumeSourceArgs' vsphere_volume: vsphereVolume represents a vSphere volume attached and mounted on kubelets host machine. Deprecated: VsphereVolume is deprecated. All operations for the in-tree vsphereVolume type are redirected to the csi.vsphere.vmware.com CSI driver.
        """
        if access_modes is not None:
            pulumi.set(__self__, "access_modes", access_modes)
        if aws_elastic_block_store is not None:
            pulumi.set(__self__, "aws_elastic_block_store", aws_elastic_block_store)
        if azure_disk is not None:
            pulumi.set(__self__, "azure_disk", azure_disk)
        if azure_file is not None:
            pulumi.set(__self__, "azure_file", azure_file)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if cephfs is not None:
            pulumi.set(__self__, "cephfs", cephfs)
        if cinder is not None:
            pulumi.set(__self__, "cinder", cinder)
        if claim_ref is not None:
            pulumi.set(__self__, "claim_ref", claim_ref)
        if csi is not None:
            pulumi.set(__self__, "csi", csi)
        if fc is not None:
            pulumi.set(__self__, "fc", fc)
        if flex_volume is not None:
            pulumi.set(__self__, "flex_volume", flex_volume)
        if flocker is not None:
            pulumi.set(__self__, "flocker", flocker)
        if gce_persistent_disk is not None:
            pulumi.set(__self__, "gce_persistent_disk", gce_persistent_disk)
        if glusterfs is not None:
            pulumi.set(__self__, "glusterfs", glusterfs)
        if host_path is not None:
            pulumi.set(__self__, "host_path", host_path)
        if iscsi is not None:
            pulumi.set(__self__, "iscsi", iscsi)
        if local is not None:
            pulumi.set(__self__, "local", local)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)
        if nfs is not None:
            pulumi.set(__self__, "nfs", nfs)
        if node_affinity is not None:
            pulumi.set(__self__, "node_affinity", node_affinity)
        if persistent_volume_reclaim_policy is not None:
            pulumi.set(__self__, "persistent_volume_reclaim_policy", persistent_volume_reclaim_policy)
        if photon_persistent_disk is not None:
            pulumi.set(__self__, "photon_persistent_disk", photon_persistent_disk)
        if portworx_volume is not None:
            pulumi.set(__self__, "portworx_volume", portworx_volume)
        if quobyte is not None:
            pulumi.set(__self__, "quobyte", quobyte)
        if rbd is not None:
            pulumi.set(__self__, "rbd", rbd)
        if scale_io is not None:
            pulumi.set(__self__, "scale_io", scale_io)
        if storage_class_name is not None:
            pulumi.set(__self__, "storage_class_name", storage_class_name)
        if storageos is not None:
            pulumi.set(__self__, "storageos", storageos)
        if volume_attributes_class_name is not None:
            pulumi.set(__self__, "volume_attributes_class_name", volume_attributes_class_name)
        if volume_mode is not None:
            pulumi.set(__self__, "volume_mode", volume_mode)
        if vsphere_volume is not None:
            pulumi.set(__self__, "vsphere_volume", vsphere_volume)

    @_builtins.property
    @pulumi.getter(name="accessModes")
    def access_modes(self) -> Optional[Sequence[_builtins.str]]:
        """
        accessModes contains all ways the volume can be mounted. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes
        """
        return pulumi.get(self, "access_modes")

    @_builtins.property
    @pulumi.getter(name="awsElasticBlockStore")
    def aws_elastic_block_store(self) -> Optional['outputs.AWSElasticBlockStoreVolumeSource']:
        """
        awsElasticBlockStore represents an AWS Disk resource that is attached to a kubelet's host machine and then exposed to the pod. Deprecated: AWSElasticBlockStore is deprecated. All operations for the in-tree awsElasticBlockStore type are redirected to the ebs.csi.aws.com CSI driver. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        """
        return pulumi.get(self, "aws_elastic_block_store")

    @_builtins.property
    @pulumi.getter(name="azureDisk")
    def azure_disk(self) -> Optional['outputs.AzureDiskVolumeSource']:
        """
        azureDisk represents an Azure Data Disk mount on the host and bind mount to the pod. Deprecated: AzureDisk is deprecated. All operations for the in-tree azureDisk type are redirected to the disk.csi.azure.com CSI driver.
        """
        return pulumi.get(self, "azure_disk")

    @_builtins.property
    @pulumi.getter(name="azureFile")
    def azure_file(self) -> Optional['outputs.AzureFilePersistentVolumeSource']:
        """
        azureFile represents an Azure File Service mount on the host and bind mount to the pod. Deprecated: AzureFile is deprecated. All operations for the in-tree azureFile type are redirected to the file.csi.azure.com CSI driver.
        """
        return pulumi.get(self, "azure_file")

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        capacity is the description of the persistent volume's resources and capacity. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#capacity
        """
        return pulumi.get(self, "capacity")

    @_builtins.property
    @pulumi.getter
    def cephfs(self) -> Optional['outputs.CephFSPersistentVolumeSource']:
        """
        cephFS represents a Ceph FS mount on the host that shares a pod's lifetime. Deprecated: CephFS is deprecated and the in-tree cephfs type is no longer supported.
        """
        return pulumi.get(self, "cephfs")

    @_builtins.property
    @pulumi.getter
    def cinder(self) -> Optional['outputs.CinderPersistentVolumeSource']:
        """
        cinder represents a cinder volume attached and mounted on kubelets host machine. Deprecated: Cinder is deprecated. All operations for the in-tree cinder type are redirected to the cinder.csi.openstack.org CSI driver. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        """
        return pulumi.get(self, "cinder")

    @_builtins.property
    @pulumi.getter(name="claimRef")
    def claim_ref(self) -> Optional['outputs.ObjectReference']:
        """
        claimRef is part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim. Expected to be non-nil when bound. claim.VolumeName is the authoritative bind between PV and PVC. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#binding
        """
        return pulumi.get(self, "claim_ref")

    @_builtins.property
    @pulumi.getter
    def csi(self) -> Optional['outputs.CSIPersistentVolumeSource']:
        """
        csi represents storage that is handled by an external CSI driver.
        """
        return pulumi.get(self, "csi")

    @_builtins.property
    @pulumi.getter
    def fc(self) -> Optional['outputs.FCVolumeSource']:
        """
        fc represents a Fibre Channel resource that is attached to a kubelet's host machine and then exposed to the pod.
        """
        return pulumi.get(self, "fc")

    @_builtins.property
    @pulumi.getter(name="flexVolume")
    def flex_volume(self) -> Optional['outputs.FlexPersistentVolumeSource']:
        """
        flexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin. Deprecated: FlexVolume is deprecated. Consider using a CSIDriver instead.
        """
        return pulumi.get(self, "flex_volume")

    @_builtins.property
    @pulumi.getter
    def flocker(self) -> Optional['outputs.FlockerVolumeSource']:
        """
        flocker represents a Flocker volume attached to a kubelet's host machine and exposed to the pod for its usage. This depends on the Flocker control service being running. Deprecated: Flocker is deprecated and the in-tree flocker type is no longer supported.
        """
        return pulumi.get(self, "flocker")

    @_builtins.property
    @pulumi.getter(name="gcePersistentDisk")
    def gce_persistent_disk(self) -> Optional['outputs.GCEPersistentDiskVolumeSource']:
        """
        gcePersistentDisk represents a GCE Disk resource that is attached to a kubelet's host machine and then exposed to the pod. Provisioned by an admin. Deprecated: GCEPersistentDisk is deprecated. All operations for the in-tree gcePersistentDisk type are redirected to the pd.csi.storage.gke.io CSI driver. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        """
        return pulumi.get(self, "gce_persistent_disk")

    @_builtins.property
    @pulumi.getter
    def glusterfs(self) -> Optional['outputs.GlusterfsPersistentVolumeSource']:
        """
        glusterfs represents a Glusterfs volume that is attached to a host and exposed to the pod. Provisioned by an admin. Deprecated: Glusterfs is deprecated and the in-tree glusterfs type is no longer supported. More info: https://examples.k8s.io/volumes/glusterfs/README.md
        """
        return pulumi.get(self, "glusterfs")

    @_builtins.property
    @pulumi.getter(name="hostPath")
    def host_path(self) -> Optional['outputs.HostPathVolumeSource']:
        """
        hostPath represents a directory on the host. Provisioned by a developer or tester. This is useful for single-node development and testing only! On-host storage is not supported in any way and WILL NOT WORK in a multi-node cluster. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
        """
        return pulumi.get(self, "host_path")

    @_builtins.property
    @pulumi.getter
    def iscsi(self) -> Optional['outputs.ISCSIPersistentVolumeSource']:
        """
        iscsi represents an ISCSI Disk resource that is attached to a kubelet's host machine and then exposed to the pod. Provisioned by an admin.
        """
        return pulumi.get(self, "iscsi")

    @_builtins.property
    @pulumi.getter
    def local(self) -> Optional['outputs.LocalVolumeSource']:
        """
        local represents directly-attached storage with node affinity
        """
        return pulumi.get(self, "local")

    @_builtins.property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[Sequence[_builtins.str]]:
        """
        mountOptions is the list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#mount-options
        """
        return pulumi.get(self, "mount_options")

    @_builtins.property
    @pulumi.getter
    def nfs(self) -> Optional['outputs.NFSVolumeSource']:
        """
        nfs represents an NFS mount on the host. Provisioned by an admin. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
        """
        return pulumi.get(self, "nfs")

    @_builtins.property
    @pulumi.getter(name="nodeAffinity")
    def node_affinity(self) -> Optional['outputs.VolumeNodeAffinity']:
        """
        nodeAffinity defines constraints that limit what nodes this volume can be accessed from. This field influences the scheduling of pods that use this volume.
        """
        return pulumi.get(self, "node_affinity")

    @_builtins.property
    @pulumi.getter(name="persistentVolumeReclaimPolicy")
    def persistent_volume_reclaim_policy(self) -> Optional[_builtins.str]:
        """
        persistentVolumeReclaimPolicy defines what happens to a persistent volume when released from its claim. Valid options are Retain (default for manually created PersistentVolumes), Delete (default for dynamically provisioned PersistentVolumes), and Recycle (deprecated). Recycle must be supported by the volume plugin underlying this PersistentVolume. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#reclaiming
        """
        return pulumi.get(self, "persistent_volume_reclaim_policy")

    @_builtins.property
    @pulumi.getter(name="photonPersistentDisk")
    def photon_persistent_disk(self) -> Optional['outputs.PhotonPersistentDiskVolumeSource']:
        """
        photonPersistentDisk represents a PhotonController persistent disk attached and mounted on kubelets host machine. Deprecated: PhotonPersistentDisk is deprecated and the in-tree photonPersistentDisk type is no longer supported.
        """
        return pulumi.get(self, "photon_persistent_disk")

    @_builtins.property
    @pulumi.getter(name="portworxVolume")
    def portworx_volume(self) -> Optional['outputs.PortworxVolumeSource']:
        """
        portworxVolume represents a portworx volume attached and mounted on kubelets host machine. Deprecated: PortworxVolume is deprecated. All operations for the in-tree portworxVolume type are redirected to the pxd.portworx.com CSI driver when the CSIMigrationPortworx feature-gate is on.
        """
        return pulumi.get(self, "portworx_volume")

    @_builtins.property
    @pulumi.getter
    def quobyte(self) -> Optional['outputs.QuobyteVolumeSource']:
        """
        quobyte represents a Quobyte mount on the host that shares a pod's lifetime. Deprecated: Quobyte is deprecated and the in-tree quobyte type is no longer supported.
        """
        return pulumi.get(self, "quobyte")

    @_builtins.property
    @pulumi.getter
    def rbd(self) -> Optional['outputs.RBDPersistentVolumeSource']:
        """
        rbd represents a Rados Block Device mount on the host that shares a pod's lifetime. Deprecated: RBD is deprecated and the in-tree rbd type is no longer supported. More info: https://examples.k8s.io/volumes/rbd/README.md
        """
        return pulumi.get(self, "rbd")

    @_builtins.property
    @pulumi.getter(name="scaleIO")
    def scale_io(self) -> Optional['outputs.ScaleIOPersistentVolumeSource']:
        """
        scaleIO represents a ScaleIO persistent volume attached and mounted on Kubernetes nodes. Deprecated: ScaleIO is deprecated and the in-tree scaleIO type is no longer supported.
        """
        return pulumi.get(self, "scale_io")

    @_builtins.property
    @pulumi.getter(name="storageClassName")
    def storage_class_name(self) -> Optional[_builtins.str]:
        """
        storageClassName is the name of StorageClass to which this persistent volume belongs. Empty value means that this volume does not belong to any StorageClass.
        """
        return pulumi.get(self, "storage_class_name")

    @_builtins.property
    @pulumi.getter
    def storageos(self) -> Optional['outputs.StorageOSPersistentVolumeSource']:
        """
        storageOS represents a StorageOS volume that is attached to the kubelet's host machine and mounted into the pod. Deprecated: StorageOS is deprecated and the in-tree storageos type is no longer supported. More info: https://examples.k8s.io/volumes/storageos/README.md
        """
        return pulumi.get(self, "storageos")

    @_builtins.property
    @pulumi.getter(name="volumeAttributesClassName")
    def volume_attributes_class_name(self) -> Optional[_builtins.str]:
        """
        Name of VolumeAttributesClass to which this persistent volume belongs. Empty value is not allowed. When this field is not set, it indicates that this volume does not belong to any VolumeAttributesClass. This field is mutable and can be changed by the CSI driver after a volume has been updated successfully to a new class. For an unbound PersistentVolume, the volumeAttributesClassName will be matched with unbound PersistentVolumeClaims during the binding process. This is a beta field and requires enabling VolumeAttributesClass feature (off by default).
        """
        return pulumi.get(self, "volume_attributes_class_name")

    @_builtins.property
    @pulumi.getter(name="volumeMode")
    def volume_mode(self) -> Optional[_builtins.str]:
        """
        volumeMode defines if a volume is intended to be used with a formatted filesystem or to remain in raw block state. Value of Filesystem is implied when not included in spec.
        """
        return pulumi.get(self, "volume_mode")

    @_builtins.property
    @pulumi.getter(name="vsphereVolume")
    def vsphere_volume(self) -> Optional['outputs.VsphereVirtualDiskVolumeSource']:
        """
        vsphereVolume represents a vSphere volume attached and mounted on kubelets host machine. Deprecated: VsphereVolume is deprecated. All operations for the in-tree vsphereVolume type are redirected to the csi.vsphere.vmware.com CSI driver.
        """
        return pulumi.get(self, "vsphere_volume")


@pulumi.output_type
class PersistentVolumeSpecPatch(dict):
    """
    PersistentVolumeSpec is the specification of a persistent volume.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessModes":
            suggest = "access_modes"
        elif key == "awsElasticBlockStore":
            suggest = "aws_elastic_block_store"
        elif key == "azureDisk":
            suggest = "azure_disk"
        elif key == "azureFile":
            suggest = "azure_file"
        elif key == "claimRef":
            suggest = "claim_ref"
        elif key == "flexVolume":
            suggest = "flex_volume"
        elif key == "gcePersistentDisk":
            suggest = "gce_persistent_disk"
        elif key == "hostPath":
            suggest = "host_path"
        elif key == "mountOptions":
            suggest = "mount_options"
        elif key == "nodeAffinity":
            suggest = "node_affinity"
        elif key == "persistentVolumeReclaimPolicy":
            suggest = "persistent_volume_reclaim_policy"
        elif key == "photonPersistentDisk":
            suggest = "photon_persistent_disk"
        elif key == "portworxVolume":
            suggest = "portworx_volume"
        elif key == "scaleIO":
            suggest = "scale_io"
        elif key == "storageClassName":
            suggest = "storage_class_name"
        elif key == "volumeAttributesClassName":
            suggest = "volume_attributes_class_name"
        elif key == "volumeMode":
            suggest = "volume_mode"
        elif key == "vsphereVolume":
            suggest = "vsphere_volume"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PersistentVolumeSpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PersistentVolumeSpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PersistentVolumeSpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_modes: Optional[Sequence[_builtins.str]] = None,
                 aws_elastic_block_store: Optional['outputs.AWSElasticBlockStoreVolumeSourcePatch'] = None,
                 azure_disk: Optional['outputs.AzureDiskVolumeSourcePatch'] = None,
                 azure_file: Optional['outputs.AzureFilePersistentVolumeSourcePatch'] = None,
                 capacity: Optional[Mapping[str, _builtins.str]] = None,
                 cephfs: Optional['outputs.CephFSPersistentVolumeSourcePatch'] = None,
                 cinder: Optional['outputs.CinderPersistentVolumeSourcePatch'] = None,
                 claim_ref: Optional['outputs.ObjectReferencePatch'] = None,
                 csi: Optional['outputs.CSIPersistentVolumeSourcePatch'] = None,
                 fc: Optional['outputs.FCVolumeSourcePatch'] = None,
                 flex_volume: Optional['outputs.FlexPersistentVolumeSourcePatch'] = None,
                 flocker: Optional['outputs.FlockerVolumeSourcePatch'] = None,
                 gce_persistent_disk: Optional['outputs.GCEPersistentDiskVolumeSourcePatch'] = None,
                 glusterfs: Optional['outputs.GlusterfsPersistentVolumeSourcePatch'] = None,
                 host_path: Optional['outputs.HostPathVolumeSourcePatch'] = None,
                 iscsi: Optional['outputs.ISCSIPersistentVolumeSourcePatch'] = None,
                 local: Optional['outputs.LocalVolumeSourcePatch'] = None,
                 mount_options: Optional[Sequence[_builtins.str]] = None,
                 nfs: Optional['outputs.NFSVolumeSourcePatch'] = None,
                 node_affinity: Optional['outputs.VolumeNodeAffinityPatch'] = None,
                 persistent_volume_reclaim_policy: Optional[_builtins.str] = None,
                 photon_persistent_disk: Optional['outputs.PhotonPersistentDiskVolumeSourcePatch'] = None,
                 portworx_volume: Optional['outputs.PortworxVolumeSourcePatch'] = None,
                 quobyte: Optional['outputs.QuobyteVolumeSourcePatch'] = None,
                 rbd: Optional['outputs.RBDPersistentVolumeSourcePatch'] = None,
                 scale_io: Optional['outputs.ScaleIOPersistentVolumeSourcePatch'] = None,
                 storage_class_name: Optional[_builtins.str] = None,
                 storageos: Optional['outputs.StorageOSPersistentVolumeSourcePatch'] = None,
                 volume_attributes_class_name: Optional[_builtins.str] = None,
                 volume_mode: Optional[_builtins.str] = None,
                 vsphere_volume: Optional['outputs.VsphereVirtualDiskVolumeSourcePatch'] = None):
        """
        PersistentVolumeSpec is the specification of a persistent volume.
        :param Sequence[_builtins.str] access_modes: accessModes contains all ways the volume can be mounted. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes
        :param 'AWSElasticBlockStoreVolumeSourcePatchArgs' aws_elastic_block_store: awsElasticBlockStore represents an AWS Disk resource that is attached to a kubelet's host machine and then exposed to the pod. Deprecated: AWSElasticBlockStore is deprecated. All operations for the in-tree awsElasticBlockStore type are redirected to the ebs.csi.aws.com CSI driver. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        :param 'AzureDiskVolumeSourcePatchArgs' azure_disk: azureDisk represents an Azure Data Disk mount on the host and bind mount to the pod. Deprecated: AzureDisk is deprecated. All operations for the in-tree azureDisk type are redirected to the disk.csi.azure.com CSI driver.
        :param 'AzureFilePersistentVolumeSourcePatchArgs' azure_file: azureFile represents an Azure File Service mount on the host and bind mount to the pod. Deprecated: AzureFile is deprecated. All operations for the in-tree azureFile type are redirected to the file.csi.azure.com CSI driver.
        :param Mapping[str, _builtins.str] capacity: capacity is the description of the persistent volume's resources and capacity. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#capacity
        :param 'CephFSPersistentVolumeSourcePatchArgs' cephfs: cephFS represents a Ceph FS mount on the host that shares a pod's lifetime. Deprecated: CephFS is deprecated and the in-tree cephfs type is no longer supported.
        :param 'CinderPersistentVolumeSourcePatchArgs' cinder: cinder represents a cinder volume attached and mounted on kubelets host machine. Deprecated: Cinder is deprecated. All operations for the in-tree cinder type are redirected to the cinder.csi.openstack.org CSI driver. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        :param 'ObjectReferencePatchArgs' claim_ref: claimRef is part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim. Expected to be non-nil when bound. claim.VolumeName is the authoritative bind between PV and PVC. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#binding
        :param 'CSIPersistentVolumeSourcePatchArgs' csi: csi represents storage that is handled by an external CSI driver.
        :param 'FCVolumeSourcePatchArgs' fc: fc represents a Fibre Channel resource that is attached to a kubelet's host machine and then exposed to the pod.
        :param 'FlexPersistentVolumeSourcePatchArgs' flex_volume: flexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin. Deprecated: FlexVolume is deprecated. Consider using a CSIDriver instead.
        :param 'FlockerVolumeSourcePatchArgs' flocker: flocker represents a Flocker volume attached to a kubelet's host machine and exposed to the pod for its usage. This depends on the Flocker control service being running. Deprecated: Flocker is deprecated and the in-tree flocker type is no longer supported.
        :param 'GCEPersistentDiskVolumeSourcePatchArgs' gce_persistent_disk: gcePersistentDisk represents a GCE Disk resource that is attached to a kubelet's host machine and then exposed to the pod. Provisioned by an admin. Deprecated: GCEPersistentDisk is deprecated. All operations for the in-tree gcePersistentDisk type are redirected to the pd.csi.storage.gke.io CSI driver. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        :param 'GlusterfsPersistentVolumeSourcePatchArgs' glusterfs: glusterfs represents a Glusterfs volume that is attached to a host and exposed to the pod. Provisioned by an admin. Deprecated: Glusterfs is deprecated and the in-tree glusterfs type is no longer supported. More info: https://examples.k8s.io/volumes/glusterfs/README.md
        :param 'HostPathVolumeSourcePatchArgs' host_path: hostPath represents a directory on the host. Provisioned by a developer or tester. This is useful for single-node development and testing only! On-host storage is not supported in any way and WILL NOT WORK in a multi-node cluster. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
        :param 'ISCSIPersistentVolumeSourcePatchArgs' iscsi: iscsi represents an ISCSI Disk resource that is attached to a kubelet's host machine and then exposed to the pod. Provisioned by an admin.
        :param 'LocalVolumeSourcePatchArgs' local: local represents directly-attached storage with node affinity
        :param Sequence[_builtins.str] mount_options: mountOptions is the list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#mount-options
        :param 'NFSVolumeSourcePatchArgs' nfs: nfs represents an NFS mount on the host. Provisioned by an admin. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
        :param 'VolumeNodeAffinityPatchArgs' node_affinity: nodeAffinity defines constraints that limit what nodes this volume can be accessed from. This field influences the scheduling of pods that use this volume.
        :param _builtins.str persistent_volume_reclaim_policy: persistentVolumeReclaimPolicy defines what happens to a persistent volume when released from its claim. Valid options are Retain (default for manually created PersistentVolumes), Delete (default for dynamically provisioned PersistentVolumes), and Recycle (deprecated). Recycle must be supported by the volume plugin underlying this PersistentVolume. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#reclaiming
        :param 'PhotonPersistentDiskVolumeSourcePatchArgs' photon_persistent_disk: photonPersistentDisk represents a PhotonController persistent disk attached and mounted on kubelets host machine. Deprecated: PhotonPersistentDisk is deprecated and the in-tree photonPersistentDisk type is no longer supported.
        :param 'PortworxVolumeSourcePatchArgs' portworx_volume: portworxVolume represents a portworx volume attached and mounted on kubelets host machine. Deprecated: PortworxVolume is deprecated. All operations for the in-tree portworxVolume type are redirected to the pxd.portworx.com CSI driver when the CSIMigrationPortworx feature-gate is on.
        :param 'QuobyteVolumeSourcePatchArgs' quobyte: quobyte represents a Quobyte mount on the host that shares a pod's lifetime. Deprecated: Quobyte is deprecated and the in-tree quobyte type is no longer supported.
        :param 'RBDPersistentVolumeSourcePatchArgs' rbd: rbd represents a Rados Block Device mount on the host that shares a pod's lifetime. Deprecated: RBD is deprecated and the in-tree rbd type is no longer supported. More info: https://examples.k8s.io/volumes/rbd/README.md
        :param 'ScaleIOPersistentVolumeSourcePatchArgs' scale_io: scaleIO represents a ScaleIO persistent volume attached and mounted on Kubernetes nodes. Deprecated: ScaleIO is deprecated and the in-tree scaleIO type is no longer supported.
        :param _builtins.str storage_class_name: storageClassName is the name of StorageClass to which this persistent volume belongs. Empty value means that this volume does not belong to any StorageClass.
        :param 'StorageOSPersistentVolumeSourcePatchArgs' storageos: storageOS represents a StorageOS volume that is attached to the kubelet's host machine and mounted into the pod. Deprecated: StorageOS is deprecated and the in-tree storageos type is no longer supported. More info: https://examples.k8s.io/volumes/storageos/README.md
        :param _builtins.str volume_attributes_class_name: Name of VolumeAttributesClass to which this persistent volume belongs. Empty value is not allowed. When this field is not set, it indicates that this volume does not belong to any VolumeAttributesClass. This field is mutable and can be changed by the CSI driver after a volume has been updated successfully to a new class. For an unbound PersistentVolume, the volumeAttributesClassName will be matched with unbound PersistentVolumeClaims during the binding process. This is a beta field and requires enabling VolumeAttributesClass feature (off by default).
        :param _builtins.str volume_mode: volumeMode defines if a volume is intended to be used with a formatted filesystem or to remain in raw block state. Value of Filesystem is implied when not included in spec.
        :param 'VsphereVirtualDiskVolumeSourcePatchArgs' vsphere_volume: vsphereVolume represents a vSphere volume attached and mounted on kubelets host machine. Deprecated: VsphereVolume is deprecated. All operations for the in-tree vsphereVolume type are redirected to the csi.vsphere.vmware.com CSI driver.
        """
        if access_modes is not None:
            pulumi.set(__self__, "access_modes", access_modes)
        if aws_elastic_block_store is not None:
            pulumi.set(__self__, "aws_elastic_block_store", aws_elastic_block_store)
        if azure_disk is not None:
            pulumi.set(__self__, "azure_disk", azure_disk)
        if azure_file is not None:
            pulumi.set(__self__, "azure_file", azure_file)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if cephfs is not None:
            pulumi.set(__self__, "cephfs", cephfs)
        if cinder is not None:
            pulumi.set(__self__, "cinder", cinder)
        if claim_ref is not None:
            pulumi.set(__self__, "claim_ref", claim_ref)
        if csi is not None:
            pulumi.set(__self__, "csi", csi)
        if fc is not None:
            pulumi.set(__self__, "fc", fc)
        if flex_volume is not None:
            pulumi.set(__self__, "flex_volume", flex_volume)
        if flocker is not None:
            pulumi.set(__self__, "flocker", flocker)
        if gce_persistent_disk is not None:
            pulumi.set(__self__, "gce_persistent_disk", gce_persistent_disk)
        if glusterfs is not None:
            pulumi.set(__self__, "glusterfs", glusterfs)
        if host_path is not None:
            pulumi.set(__self__, "host_path", host_path)
        if iscsi is not None:
            pulumi.set(__self__, "iscsi", iscsi)
        if local is not None:
            pulumi.set(__self__, "local", local)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)
        if nfs is not None:
            pulumi.set(__self__, "nfs", nfs)
        if node_affinity is not None:
            pulumi.set(__self__, "node_affinity", node_affinity)
        if persistent_volume_reclaim_policy is not None:
            pulumi.set(__self__, "persistent_volume_reclaim_policy", persistent_volume_reclaim_policy)
        if photon_persistent_disk is not None:
            pulumi.set(__self__, "photon_persistent_disk", photon_persistent_disk)
        if portworx_volume is not None:
            pulumi.set(__self__, "portworx_volume", portworx_volume)
        if quobyte is not None:
            pulumi.set(__self__, "quobyte", quobyte)
        if rbd is not None:
            pulumi.set(__self__, "rbd", rbd)
        if scale_io is not None:
            pulumi.set(__self__, "scale_io", scale_io)
        if storage_class_name is not None:
            pulumi.set(__self__, "storage_class_name", storage_class_name)
        if storageos is not None:
            pulumi.set(__self__, "storageos", storageos)
        if volume_attributes_class_name is not None:
            pulumi.set(__self__, "volume_attributes_class_name", volume_attributes_class_name)
        if volume_mode is not None:
            pulumi.set(__self__, "volume_mode", volume_mode)
        if vsphere_volume is not None:
            pulumi.set(__self__, "vsphere_volume", vsphere_volume)

    @_builtins.property
    @pulumi.getter(name="accessModes")
    def access_modes(self) -> Optional[Sequence[_builtins.str]]:
        """
        accessModes contains all ways the volume can be mounted. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes
        """
        return pulumi.get(self, "access_modes")

    @_builtins.property
    @pulumi.getter(name="awsElasticBlockStore")
    def aws_elastic_block_store(self) -> Optional['outputs.AWSElasticBlockStoreVolumeSourcePatch']:
        """
        awsElasticBlockStore represents an AWS Disk resource that is attached to a kubelet's host machine and then exposed to the pod. Deprecated: AWSElasticBlockStore is deprecated. All operations for the in-tree awsElasticBlockStore type are redirected to the ebs.csi.aws.com CSI driver. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
        """
        return pulumi.get(self, "aws_elastic_block_store")

    @_builtins.property
    @pulumi.getter(name="azureDisk")
    def azure_disk(self) -> Optional['outputs.AzureDiskVolumeSourcePatch']:
        """
        azureDisk represents an Azure Data Disk mount on the host and bind mount to the pod. Deprecated: AzureDisk is deprecated. All operations for the in-tree azureDisk type are redirected to the disk.csi.azure.com CSI driver.
        """
        return pulumi.get(self, "azure_disk")

    @_builtins.property
    @pulumi.getter(name="azureFile")
    def azure_file(self) -> Optional['outputs.AzureFilePersistentVolumeSourcePatch']:
        """
        azureFile represents an Azure File Service mount on the host and bind mount to the pod. Deprecated: AzureFile is deprecated. All operations for the in-tree azureFile type are redirected to the file.csi.azure.com CSI driver.
        """
        return pulumi.get(self, "azure_file")

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        capacity is the description of the persistent volume's resources and capacity. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#capacity
        """
        return pulumi.get(self, "capacity")

    @_builtins.property
    @pulumi.getter
    def cephfs(self) -> Optional['outputs.CephFSPersistentVolumeSourcePatch']:
        """
        cephFS represents a Ceph FS mount on the host that shares a pod's lifetime. Deprecated: CephFS is deprecated and the in-tree cephfs type is no longer supported.
        """
        return pulumi.get(self, "cephfs")

    @_builtins.property
    @pulumi.getter
    def cinder(self) -> Optional['outputs.CinderPersistentVolumeSourcePatch']:
        """
        cinder represents a cinder volume attached and mounted on kubelets host machine. Deprecated: Cinder is deprecated. All operations for the in-tree cinder type are redirected to the cinder.csi.openstack.org CSI driver. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
        """
        return pulumi.get(self, "cinder")

    @_builtins.property
    @pulumi.getter(name="claimRef")
    def claim_ref(self) -> Optional['outputs.ObjectReferencePatch']:
        """
        claimRef is part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim. Expected to be non-nil when bound. claim.VolumeName is the authoritative bind between PV and PVC. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#binding
        """
        return pulumi.get(self, "claim_ref")

    @_builtins.property
    @pulumi.getter
    def csi(self) -> Optional['outputs.CSIPersistentVolumeSourcePatch']:
        """
        csi represents storage that is handled by an external CSI driver.
        """
        return pulumi.get(self, "csi")

    @_builtins.property
    @pulumi.getter
    def fc(self) -> Optional['outputs.FCVolumeSourcePatch']:
        """
        fc represents a Fibre Channel resource that is attached to a kubelet's host machine and then exposed to the pod.
        """
        return pulumi.get(self, "fc")

    @_builtins.property
    @pulumi.getter(name="flexVolume")
    def flex_volume(self) -> Optional['outputs.FlexPersistentVolumeSourcePatch']:
        """
        flexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin. Deprecated: FlexVolume is deprecated. Consider using a CSIDriver instead.
        """
        return pulumi.get(self, "flex_volume")

    @_builtins.property
    @pulumi.getter
    def flocker(self) -> Optional['outputs.FlockerVolumeSourcePatch']:
        """
        flocker represents a Flocker volume attached to a kubelet's host machine and exposed to the pod for its usage. This depends on the Flocker control service being running. Deprecated: Flocker is deprecated and the in-tree flocker type is no longer supported.
        """
        return pulumi.get(self, "flocker")

    @_builtins.property
    @pulumi.getter(name="gcePersistentDisk")
    def gce_persistent_disk(self) -> Optional['outputs.GCEPersistentDiskVolumeSourcePatch']:
        """
        gcePersistentDisk represents a GCE Disk resource that is attached to a kubelet's host machine and then exposed to the pod. Provisioned by an admin. Deprecated: GCEPersistentDisk is deprecated. All operations for the in-tree gcePersistentDisk type are redirected to the pd.csi.storage.gke.io CSI driver. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
        """
        return pulumi.get(self, "gce_persistent_disk")

    @_builtins.property
    @pulumi.getter
    def glusterfs(self) -> Optional['outputs.GlusterfsPersistentVolumeSourcePatch']:
        """
        glusterfs represents a Glusterfs volume that is attached to a host and exposed to the pod. Provisioned by an admin. Deprecated: Glusterfs is deprecated and the in-tree glusterfs type is no longer supported. More info: https://examples.k8s.io/volumes/glusterfs/README.md
        """
        return pulumi.get(self, "glusterfs")

    @_builtins.property
    @pulumi.getter(name="hostPath")
    def host_path(self) -> Optional['outputs.HostPathVolumeSourcePatch']:
        """
        hostPath represents a directory on the host. Provisioned by a developer or tester. This is useful for single-node development and testing only! On-host storage is not supported in any way and WILL NOT WORK in a multi-node cluster. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
        """
        return pulumi.get(self, "host_path")

    @_builtins.property
    @pulumi.getter
    def iscsi(self) -> Optional['outputs.ISCSIPersistentVolumeSourcePatch']:
        """
        iscsi represents an ISCSI Disk resource that is attached to a kubelet's host machine and then exposed to the pod. Provisioned by an admin.
        """
        return pulumi.get(self, "iscsi")

    @_builtins.property
    @pulumi.getter
    def local(self) -> Optional['outputs.LocalVolumeSourcePatch']:
        """
        local represents directly-attached storage with node affinity
        """
        return pulumi.get(self, "local")

    @_builtins.property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[Sequence[_builtins.str]]:
        """
        mountOptions is the list of mount options, e.g. ["ro", "soft"]. Not validated - mount will simply fail if one is invalid. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#mount-options
        """
        return pulumi.get(self, "mount_options")

    @_builtins.property
    @pulumi.getter
    def nfs(self) -> Optional['outputs.NFSVolumeSourcePatch']:
        """
        nfs represents an NFS mount on the host. Provisioned by an admin. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
        """
        return pulumi.get(self, "nfs")

    @_builtins.property
    @pulumi.getter(name="nodeAffinity")
    def node_affinity(self) -> Optional['outputs.VolumeNodeAffinityPatch']:
        """
        nodeAffinity defines constraints that limit what nodes this volume can be accessed from. This field influences the scheduling of pods that use this volume.
        """
        return pulumi.get(self, "node_affinity")

    @_builtins.property
    @pulumi.getter(name="persistentVolumeReclaimPolicy")
    def persistent_volume_reclaim_policy(self) -> Optional[_builtins.str]:
        """
        persistentVolumeReclaimPolicy defines what happens to a persistent volume when released from its claim. Valid options are Retain (default for manually created PersistentVolumes), Delete (default for dynamically provisioned PersistentVolumes), and Recycle (deprecated). Recycle must be supported by the volume plugin underlying this PersistentVolume. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#reclaiming
        """
        return pulumi.get(self, "persistent_volume_reclaim_policy")

    @_builtins.property
    @pulumi.getter(name="photonPersistentDisk")
    def photon_persistent_disk(self) -> Optional['outputs.PhotonPersistentDiskVolumeSourcePatch']:
        """
        photonPersistentDisk represents a PhotonController persistent disk attached and mounted on kubelets host machine. Deprecated: PhotonPersistentDisk is deprecated and the in-tree photonPersistentDisk type is no longer supported.
        """
        return pulumi.get(self, "photon_persistent_disk")

    @_builtins.property
    @pulumi.getter(name="portworxVolume")
    def portworx_volume(self) -> Optional['outputs.PortworxVolumeSourcePatch']:
        """
        portworxVolume represents a portworx volume attached and mounted on kubelets host machine. Deprecated: PortworxVolume is deprecated. All operations for the in-tree portworxVolume type are redirected to the pxd.portworx.com CSI driver when the CSIMigrationPortworx feature-gate is on.
        """
        return pulumi.get(self, "portworx_volume")

    @_builtins.property
    @pulumi.getter
    def quobyte(self) -> Optional['outputs.QuobyteVolumeSourcePatch']:
        """
        quobyte represents a Quobyte mount on the host that shares a pod's lifetime. Deprecated: Quobyte is deprecated and the in-tree quobyte type is no longer supported.
        """
        return pulumi.get(self, "quobyte")

    @_builtins.property
    @pulumi.getter
    def rbd(self) -> Optional['outputs.RBDPersistentVolumeSourcePatch']:
        """
        rbd represents a Rados Block Device mount on the host that shares a pod's lifetime. Deprecated: RBD is deprecated and the in-tree rbd type is no longer supported. More info: https://examples.k8s.io/volumes/rbd/README.md
        """
        return pulumi.get(self, "rbd")

    @_builtins.property
    @pulumi.getter(name="scaleIO")
    def scale_io(self) -> Optional['outputs.ScaleIOPersistentVolumeSourcePatch']:
        """
        scaleIO represents a ScaleIO persistent volume attached and mounted on Kubernetes nodes. Deprecated: ScaleIO is deprecated and the in-tree scaleIO type is no longer supported.
        """
        return pulumi.get(self, "scale_io")

    @_builtins.property
    @pulumi.getter(name="storageClassName")
    def storage_class_name(self) -> Optional[_builtins.str]:
        """
        storageClassName is the name of StorageClass to which this persistent volume belongs. Empty value means that this volume does not belong to any StorageClass.
        """
        return pulumi.get(self, "storage_class_name")

    @_builtins.property
    @pulumi.getter
    def storageos(self) -> Optional['outputs.StorageOSPersistentVolumeSourcePatch']:
        """
        storageOS represents a StorageOS volume that is attached to the kubelet's host machine and mounted into the pod. Deprecated: StorageOS is deprecated and the in-tree storageos type is no longer supported. More info: https://examples.k8s.io/volumes/storageos/README.md
        """
        return pulumi.get(self, "storageos")

    @_builtins.property
    @pulumi.getter(name="volumeAttributesClassName")
    def volume_attributes_class_name(self) -> Optional[_builtins.str]:
        """
        Name of VolumeAttributesClass to which this persistent volume belongs. Empty value is not allowed. When this field is not set, it indicates that this volume does not belong to any VolumeAttributesClass. This field is mutable and can be changed by the CSI driver after a volume has been updated successfully to a new class. For an unbound PersistentVolume, the volumeAttributesClassName will be matched with unbound PersistentVolumeClaims during the binding process. This is a beta field and requires enabling VolumeAttributesClass feature (off by default).
        """
        return pulumi.get(self, "volume_attributes_class_name")

    @_builtins.property
    @pulumi.getter(name="volumeMode")
    def volume_mode(self) -> Optional[_builtins.str]:
        """
        volumeMode defines if a volume is intended to be used with a formatted filesystem or to remain in raw block state. Value of Filesystem is implied when not included in spec.
        """
        return pulumi.get(self, "volume_mode")

    @_builtins.property
    @pulumi.getter(name="vsphereVolume")
    def vsphere_volume(self) -> Optional['outputs.VsphereVirtualDiskVolumeSourcePatch']:
        """
        vsphereVolume represents a vSphere volume attached and mounted on kubelets host machine. Deprecated: VsphereVolume is deprecated. All operations for the in-tree vsphereVolume type are redirected to the csi.vsphere.vmware.com CSI driver.
        """
        return pulumi.get(self, "vsphere_volume")


@pulumi.output_type
class PersistentVolumeStatus(dict):
    """
    PersistentVolumeStatus is the current status of a persistent volume.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastPhaseTransitionTime":
            suggest = "last_phase_transition_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PersistentVolumeStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PersistentVolumeStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PersistentVolumeStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_phase_transition_time: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 phase: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None):
        """
        PersistentVolumeStatus is the current status of a persistent volume.
        :param _builtins.str last_phase_transition_time: lastPhaseTransitionTime is the time the phase transitioned from one to another and automatically resets to current time everytime a volume phase transitions.
        :param _builtins.str message: message is a human-readable message indicating details about why the volume is in this state.
        :param _builtins.str phase: phase indicates if a volume is available, bound to a claim, or released by a claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#phase
        :param _builtins.str reason: reason is a brief CamelCase string that describes any failure and is meant for machine parsing and tidy display in the CLI.
        """
        if last_phase_transition_time is not None:
            pulumi.set(__self__, "last_phase_transition_time", last_phase_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if phase is not None:
            pulumi.set(__self__, "phase", phase)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @_builtins.property
    @pulumi.getter(name="lastPhaseTransitionTime")
    def last_phase_transition_time(self) -> Optional[_builtins.str]:
        """
        lastPhaseTransitionTime is the time the phase transitioned from one to another and automatically resets to current time everytime a volume phase transitions.
        """
        return pulumi.get(self, "last_phase_transition_time")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        message is a human-readable message indicating details about why the volume is in this state.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def phase(self) -> Optional[_builtins.str]:
        """
        phase indicates if a volume is available, bound to a claim, or released by a claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#phase
        """
        return pulumi.get(self, "phase")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        reason is a brief CamelCase string that describes any failure and is meant for machine parsing and tidy display in the CLI.
        """
        return pulumi.get(self, "reason")


@pulumi.output_type
class PersistentVolumeStatusPatch(dict):
    """
    PersistentVolumeStatus is the current status of a persistent volume.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastPhaseTransitionTime":
            suggest = "last_phase_transition_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PersistentVolumeStatusPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PersistentVolumeStatusPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PersistentVolumeStatusPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_phase_transition_time: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 phase: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None):
        """
        PersistentVolumeStatus is the current status of a persistent volume.
        :param _builtins.str last_phase_transition_time: lastPhaseTransitionTime is the time the phase transitioned from one to another and automatically resets to current time everytime a volume phase transitions.
        :param _builtins.str message: message is a human-readable message indicating details about why the volume is in this state.
        :param _builtins.str phase: phase indicates if a volume is available, bound to a claim, or released by a claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#phase
        :param _builtins.str reason: reason is a brief CamelCase string that describes any failure and is meant for machine parsing and tidy display in the CLI.
        """
        if last_phase_transition_time is not None:
            pulumi.set(__self__, "last_phase_transition_time", last_phase_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if phase is not None:
            pulumi.set(__self__, "phase", phase)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @_builtins.property
    @pulumi.getter(name="lastPhaseTransitionTime")
    def last_phase_transition_time(self) -> Optional[_builtins.str]:
        """
        lastPhaseTransitionTime is the time the phase transitioned from one to another and automatically resets to current time everytime a volume phase transitions.
        """
        return pulumi.get(self, "last_phase_transition_time")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        message is a human-readable message indicating details about why the volume is in this state.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def phase(self) -> Optional[_builtins.str]:
        """
        phase indicates if a volume is available, bound to a claim, or released by a claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#phase
        """
        return pulumi.get(self, "phase")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        reason is a brief CamelCase string that describes any failure and is meant for machine parsing and tidy display in the CLI.
        """
        return pulumi.get(self, "reason")


@pulumi.output_type
class PhotonPersistentDiskVolumeSource(dict):
    """
    Represents a Photon Controller persistent disk resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pdID":
            suggest = "pd_id"
        elif key == "fsType":
            suggest = "fs_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PhotonPersistentDiskVolumeSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PhotonPersistentDiskVolumeSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PhotonPersistentDiskVolumeSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pd_id: _builtins.str,
                 fs_type: Optional[_builtins.str] = None):
        """
        Represents a Photon Controller persistent disk resource.
        :param _builtins.str pd_id: pdID is the ID that identifies Photon Controller persistent disk
        :param _builtins.str fs_type: fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
        """
        pulumi.set(__self__, "pd_id", pd_id)
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)

    @_builtins.property
    @pulumi.getter(name="pdID")
    def pd_id(self) -> _builtins.str:
        """
        pdID is the ID that identifies Photon Controller persistent disk
        """
        return pulumi.get(self, "pd_id")

    @_builtins.property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[_builtins.str]:
        """
        fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
        """
        return pulumi.get(self, "fs_type")


@pulumi.output_type
class PhotonPersistentDiskVolumeSourcePatch(dict):
    """
    Represents a Photon Controller persistent disk resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fsType":
            suggest = "fs_type"
        elif key == "pdID":
            suggest = "pd_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PhotonPersistentDiskVolumeSourcePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PhotonPersistentDiskVolumeSourcePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PhotonPersistentDiskVolumeSourcePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fs_type: Optional[_builtins.str] = None,
                 pd_id: Optional[_builtins.str] = None):
        """
        Represents a Photon Controller persistent disk resource.
        :param _builtins.str fs_type: fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
        :param _builtins.str pd_id: pdID is the ID that identifies Photon Controller persistent disk
        """
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if pd_id is not None:
            pulumi.set(__self__, "pd_id", pd_id)

    @_builtins.property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[_builtins.str]:
        """
        fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
        """
        return pulumi.get(self, "fs_type")

    @_builtins.property
    @pulumi.getter(name="pdID")
    def pd_id(self) -> Optional[_builtins.str]:
        """
        pdID is the ID that identifies Photon Controller persistent disk
        """
        return pulumi.get(self, "pd_id")


@pulumi.output_type
class Pod(dict):
    """
    Pod is a collection of containers that can run on a host. This resource is created by clients and scheduled onto hosts.

    This resource waits until its status is ready before registering success
    for create/update, and populating output properties from the current state of the resource.
    The following conditions are used to determine whether the resource creation has
    succeeded or failed:

    1. The Pod is scheduled ("PodScheduled"" '.status.condition' is true).
    2. The Pod is initialized ("Initialized" '.status.condition' is true).
    3. The Pod is ready ("Ready" '.status.condition' is true) and the '.status.phase' is
       set to "Running".
    Or (for Jobs): The Pod succeeded ('.status.phase' set to "Succeeded").

    If the Pod has not reached a Ready state after 10 minutes, it will
    time out and mark the resource update as Failed. You can override the default timeout value
    by setting the 'customTimeouts' option on the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Pod. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Pod.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Pod.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[_builtins.str] = None,
                 kind: Optional[_builtins.str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.PodSpec'] = None,
                 status: Optional['outputs.PodStatus'] = None):
        """
        Pod is a collection of containers that can run on a host. This resource is created by clients and scheduled onto hosts.

        This resource waits until its status is ready before registering success
        for create/update, and populating output properties from the current state of the resource.
        The following conditions are used to determine whether the resource creation has
        succeeded or failed:

        1. The Pod is scheduled ("PodScheduled"" '.status.condition' is true).
        2. The Pod is initialized ("Initialized" '.status.condition' is true).
        3. The Pod is ready ("Ready" '.status.condition' is true) and the '.status.phase' is
           set to "Running".
        Or (for Jobs): The Pod succeeded ('.status.phase' set to "Succeeded").

        If the Pod has not reached a Ready state after 10 minutes, it will
        time out and mark the resource update as Failed. You can override the default timeout value
        by setting the 'customTimeouts' option on the resource.
        :param _builtins.str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param _builtins.str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param 'PodSpecArgs' spec: Specification of the desired behavior of the pod. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        :param 'PodStatusArgs' status: Most recently observed status of the pod. This data may not be up to date. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'Pod')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[_builtins.str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[_builtins.str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional['outputs.PodSpec']:
        """
        Specification of the desired behavior of the pod. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "spec")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional['outputs.PodStatus']:
        """
        Most recently observed status of the pod. This data may not be up to date. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class PodAffinity(dict):
    """
    Pod affinity is a group of inter pod affinity scheduling rules.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "preferredDuringSchedulingIgnoredDuringExecution":
            suggest = "preferred_during_scheduling_ignored_during_execution"
        elif key == "requiredDuringSchedulingIgnoredDuringExecution":
            suggest = "required_during_scheduling_ignored_during_execution"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PodAffinity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PodAffinity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PodAffinity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 preferred_during_scheduling_ignored_during_execution: Optional[Sequence['outputs.WeightedPodAffinityTerm']] = None,
                 required_during_scheduling_ignored_during_execution: Optional[Sequence['outputs.PodAffinityTerm']] = None):
        """
        Pod affinity is a group of inter pod affinity scheduling rules.
        :param Sequence['WeightedPodAffinityTermArgs'] preferred_during_scheduling_ignored_during_execution: The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding "weight" to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred.
        :param Sequence['PodAffinityTermArgs'] required_during_scheduling_ignored_during_execution: If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied.
        """
        if preferred_during_scheduling_ignored_during_execution is not None:
            pulumi.set(__self__, "preferred_during_scheduling_ignored_during_execution", preferred_during_scheduling_ignored_during_execution)
        if required_during_scheduling_ignored_during_execution is not None:
            pulumi.set(__self__, "required_during_scheduling_ignored_during_execution", required_during_scheduling_ignored_during_execution)

    @_builtins.property
    @pulumi.getter(name="preferredDuringSchedulingIgnoredDuringExecution")
    def preferred_during_scheduling_ignored_during_execution(self) -> Optional[Sequence['outputs.WeightedPodAffinityTerm']]:
        """
        The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding "weight" to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred.
        """
        return pulumi.get(self, "preferred_during_scheduling_ignored_during_execution")

    @_builtins.property
    @pulumi.getter(name="requiredDuringSchedulingIgnoredDuringExecution")
    def required_during_scheduling_ignored_during_execution(self) -> Optional[Sequence['outputs.PodAffinityTerm']]:
        """
        If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied.
        """
        return pulumi.get(self, "required_during_scheduling_ignored_during_execution")


@pulumi.output_type
class PodAffinityPatch(dict):
    """
    Pod affinity is a group of inter pod affinity scheduling rules.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "preferredDuringSchedulingIgnoredDuringExecution":
            suggest = "preferred_during_scheduling_ignored_during_execution"
        elif key == "requiredDuringSchedulingIgnoredDuringExecution":
            suggest = "required_during_scheduling_ignored_during_execution"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PodAffinityPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PodAffinityPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PodAffinityPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 preferred_during_scheduling_ignored_during_execution: Optional[Sequence['outputs.WeightedPodAffinityTermPatch']] = None,
                 required_during_scheduling_ignored_during_execution: Optional[Sequence['outputs.PodAffinityTermPatch']] = None):
        """
        Pod affinity is a group of inter pod affinity scheduling rules.
        :param Sequence['WeightedPodAffinityTermPatchArgs'] preferred_during_scheduling_ignored_during_execution: The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding "weight" to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred.
        :param Sequence['PodAffinityTermPatchArgs'] required_during_scheduling_ignored_during_execution: If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied.
        """
        if preferred_during_scheduling_ignored_during_execution is not None:
            pulumi.set(__self__, "preferred_during_scheduling_ignored_during_execution", preferred_during_scheduling_ignored_during_execution)
        if required_during_scheduling_ignored_during_execution is not None:
            pulumi.set(__self__, "required_during_scheduling_ignored_during_execution", required_during_scheduling_ignored_during_execution)

    @_builtins.property
    @pulumi.getter(name="preferredDuringSchedulingIgnoredDuringExecution")
    def preferred_during_scheduling_ignored_during_execution(self) -> Optional[Sequence['outputs.WeightedPodAffinityTermPatch']]:
        """
        The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding "weight" to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred.
        """
        return pulumi.get(self, "preferred_during_scheduling_ignored_during_execution")

    @_builtins.property
    @pulumi.getter(name="requiredDuringSchedulingIgnoredDuringExecution")
    def required_during_scheduling_ignored_during_execution(self) -> Optional[Sequence['outputs.PodAffinityTermPatch']]:
        """
        If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied.
        """
        return pulumi.get(self, "required_during_scheduling_ignored_during_execution")


@pulumi.output_type
class PodAffinityTerm(dict):
    """
    Defines a set of pods (namely those matching the labelSelector relative to the given namespace(s)) that this pod should be co-located (affinity) or not co-located (anti-affinity) with, where co-located is defined as running on a node whose value of the label with key <topologyKey> matches that of any node on which a pod of the set of pods is running
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "topologyKey":
            suggest = "topology_key"
        elif key == "labelSelector":
            suggest = "label_selector"
        elif key == "matchLabelKeys":
            suggest = "match_label_keys"
        elif key == "mismatchLabelKeys":
            suggest = "mismatch_label_keys"
        elif key == "namespaceSelector":
            suggest = "namespace_selector"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PodAffinityTerm. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PodAffinityTerm.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PodAffinityTerm.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 topology_key: _builtins.str,
                 label_selector: Optional['_meta.v1.outputs.LabelSelector'] = None,
                 match_label_keys: Optional[Sequence[_builtins.str]] = None,
                 mismatch_label_keys: Optional[Sequence[_builtins.str]] = None,
                 namespace_selector: Optional['_meta.v1.outputs.LabelSelector'] = None,
                 namespaces: Optional[Sequence[_builtins.str]] = None):
        """
        Defines a set of pods (namely those matching the labelSelector relative to the given namespace(s)) that this pod should be co-located (affinity) or not co-located (anti-affinity) with, where co-located is defined as running on a node whose value of the label with key <topologyKey> matches that of any node on which a pod of the set of pods is running
        :param _builtins.str topology_key: This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching the labelSelector in the specified namespaces, where co-located is defined as running on a node whose value of the label with key topologyKey matches that of any node on which any of the selected pods is running. Empty topologyKey is not allowed.
        :param '_meta.v1.LabelSelectorArgs' label_selector: A label query over a set of resources, in this case pods. If it's null, this PodAffinityTerm matches with no Pods.
        :param Sequence[_builtins.str] match_label_keys: MatchLabelKeys is a set of pod label keys to select which pods will be taken into consideration. The keys are used to lookup values from the incoming pod labels, those key-value labels are merged with `labelSelector` as `key in (value)` to select the group of existing pods which pods will be taken into consideration for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming pod labels will be ignored. The default value is empty. The same key is forbidden to exist in both matchLabelKeys and labelSelector. Also, matchLabelKeys cannot be set when labelSelector isn't set.
        :param Sequence[_builtins.str] mismatch_label_keys: MismatchLabelKeys is a set of pod label keys to select which pods will be taken into consideration. The keys are used to lookup values from the incoming pod labels, those key-value labels are merged with `labelSelector` as `key notin (value)` to select the group of existing pods which pods will be taken into consideration for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming pod labels will be ignored. The default value is empty. The same key is forbidden to exist in both mismatchLabelKeys and labelSelector. Also, mismatchLabelKeys cannot be set when labelSelector isn't set.
        :param '_meta.v1.LabelSelectorArgs' namespace_selector: A label query over the set of namespaces that the term applies to. The term is applied to the union of the namespaces selected by this field and the ones listed in the namespaces field. null selector and null or empty namespaces list means "this pod's namespace". An empty selector ({}) matches all namespaces.
        :param Sequence[_builtins.str] namespaces: namespaces specifies a static list of namespace names that the term applies to. The term is applied to the union of the namespaces listed in this field and the ones selected by namespaceSelector. null or empty namespaces list and null namespaceSelector means "this pod's namespace".
        """
        pulumi.set(__self__, "topology_key", topology_key)
        if label_selector is not None:
            pulumi.set(__self__, "label_selector", label_selector)
        if match_label_keys is not None:
            pulumi.set(__self__, "match_label_keys", match_label_keys)
        if mismatch_label_keys is not None:
            pulumi.set(__self__, "mismatch_label_keys", mismatch_label_keys)
        if namespace_selector is not None:
            pulumi.set(__self__, "namespace_selector", namespace_selector)
        if namespaces is not None:
            pulumi.set(__self__, "namespaces", namespaces)

    @_builtins.property
    @pulumi.getter(name="topologyKey")
    def topology_key(self) -> _builtins.str:
        """
        This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching the labelSelector in the specified namespaces, where co-located is defined as running on a node whose value of the label with key topologyKey matches that of any node on which any of the selected pods is running. Empty topologyKey is not allowed.
        """
        return pulumi.get(self, "topology_key")

    @_builtins.property
    @pulumi.getter(name="labelSelector")
    def label_selector(self) -> Optional['_meta.v1.outputs.LabelSelector']:
        """
        A label query over a set of resources, in this case pods. If it's null, this PodAffinityTerm matches with no Pods.
        """
        return pulumi.get(self, "label_selector")

    @_builtins.property
    @pulumi.getter(name="matchLabelKeys")
    def match_label_keys(self) -> Optional[Sequence[_builtins.str]]:
        """
        MatchLabelKeys is a set of pod label keys to select which pods will be taken into consideration. The keys are used to lookup values from the incoming pod labels, those key-value labels are merged with `labelSelector` as `key in (value)` to select the group of existing pods which pods will be taken into consideration for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming pod labels will be ignored. The default value is empty. The same key is forbidden to exist in both matchLabelKeys and labelSelector. Also, matchLabelKeys cannot be set when labelSelector isn't set.
        """
        return pulumi.get(self, "match_label_keys")

    @_builtins.property
    @pulumi.getter(name="mismatchLabelKeys")
    def mismatch_label_keys(self) -> Optional[Sequence[_builtins.str]]:
        """
        MismatchLabelKeys is a set of pod label keys to select which pods will be taken into consideration. The keys are used to lookup values from the incoming pod labels, those key-value labels are merged with `labelSelector` as `key notin (value)` to select the group of existing pods which pods will be taken into consideration for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming pod labels will be ignored. The default value is empty. The same key is forbidden to exist in both mismatchLabelKeys and labelSelector. Also, mismatchLabelKeys cannot be set when labelSelector isn't set.
        """
        return pulumi.get(self, "mismatch_label_keys")

    @_builtins.property
    @pulumi.getter(name="namespaceSelector")
    def namespace_selector(self) -> Optional['_meta.v1.outputs.LabelSelector']:
        """
        A label query over the set of namespaces that the term applies to. The term is applied to the union of the namespaces selected by this field and the ones listed in the namespaces field. null selector and null or empty namespaces list means "this pod's namespace". An empty selector ({}) matches all namespaces.
        """
        return pulumi.get(self, "namespace_selector")

    @_builtins.property
    @pulumi.getter
    def namespaces(self) -> Optional[Sequence[_builtins.str]]:
        """
        namespaces specifies a static list of namespace names that the term applies to. The term is applied to the union of the namespaces listed in this field and the ones selected by namespaceSelector. null or empty namespaces list and null namespaceSelector means "this pod's namespace".
        """
        return pulumi.get(self, "namespaces")


@pulumi.output_type
class PodAffinityTermPatch(dict):
    """
    Defines a set of pods (namely those matching the labelSelector relative to the given namespace(s)) that this pod should be co-located (affinity) or not co-located (anti-affinity) with, where co-located is defined as running on a node whose value of the label with key <topologyKey> matches that of any node on which a pod of the set of pods is running
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "labelSelector":
            suggest = "label_selector"
        elif key == "matchLabelKeys":
            suggest = "match_label_keys"
        elif key == "mismatchLabelKeys":
            suggest = "mismatch_label_keys"
        elif key == "namespaceSelector":
            suggest = "namespace_selector"
        elif key == "topologyKey":
            suggest = "topology_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PodAffinityTermPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PodAffinityTermPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PodAffinityTermPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 label_selector: Optional['_meta.v1.outputs.LabelSelectorPatch'] = None,
                 match_label_keys: Optional[Sequence[_builtins.str]] = None,
                 mismatch_label_keys: Optional[Sequence[_builtins.str]] = None,
                 namespace_selector: Optional['_meta.v1.outputs.LabelSelectorPatch'] = None,
                 namespaces: Optional[Sequence[_builtins.str]] = None,
                 topology_key: Optional[_builtins.str] = None):
        """
        Defines a set of pods (namely those matching the labelSelector relative to the given namespace(s)) that this pod should be co-located (affinity) or not co-located (anti-affinity) with, where co-located is defined as running on a node whose value of the label with key <topologyKey> matches that of any node on which a pod of the set of pods is running
        :param '_meta.v1.LabelSelectorPatchArgs' label_selector: A label query over a set of resources, in this case pods. If it's null, this PodAffinityTerm matches with no Pods.
        :param Sequence[_builtins.str] match_label_keys: MatchLabelKeys is a set of pod label keys to select which pods will be taken into consideration. The keys are used to lookup values from the incoming pod labels, those key-value labels are merged with `labelSelector` as `key in (value)` to select the group of existing pods which pods will be taken into consideration for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming pod labels will be ignored. The default value is empty. The same key is forbidden to exist in both matchLabelKeys and labelSelector. Also, matchLabelKeys cannot be set when labelSelector isn't set.
        :param Sequence[_builtins.str] mismatch_label_keys: MismatchLabelKeys is a set of pod label keys to select which pods will be taken into consideration. The keys are used to lookup values from the incoming pod labels, those key-value labels are merged with `labelSelector` as `key notin (value)` to select the group of existing pods which pods will be taken into consideration for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming pod labels will be ignored. The default value is empty. The same key is forbidden to exist in both mismatchLabelKeys and labelSelector. Also, mismatchLabelKeys cannot be set when labelSelector isn't set.
        :param '_meta.v1.LabelSelectorPatchArgs' namespace_selector: A label query over the set of namespaces that the term applies to. The term is applied to the union of the namespaces selected by this field and the ones listed in the namespaces field. null selector and null or empty namespaces list means "this pod's namespace". An empty selector ({}) matches all namespaces.
        :param Sequence[_builtins.str] namespaces: namespaces specifies a static list of namespace names that the term applies to. The term is applied to the union of the namespaces listed in this field and the ones selected by namespaceSelector. null or empty namespaces list and null namespaceSelector means "this pod's namespace".
        :param _builtins.str topology_key: This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching the labelSelector in the specified namespaces, where co-located is defined as running on a node whose value of the label with key topologyKey matches that of any node on which any of the selected pods is running. Empty topologyKey is not allowed.
        """
        if label_selector is not None:
            pulumi.set(__self__, "label_selector", label_selector)
        if match_label_keys is not None:
            pulumi.set(__self__, "match_label_keys", match_label_keys)
        if mismatch_label_keys is not None:
            pulumi.set(__self__, "mismatch_label_keys", mismatch_label_keys)
        if namespace_selector is not None:
            pulumi.set(__self__, "namespace_selector", namespace_selector)
        if namespaces is not None:
            pulumi.set(__self__, "namespaces", namespaces)
        if topology_key is not None:
            pulumi.set(__self__, "topology_key", topology_key)

    @_builtins.property
    @pulumi.getter(name="labelSelector")
    def label_selector(self) -> Optional['_meta.v1.outputs.LabelSelectorPatch']:
        """
        A label query over a set of resources, in this case pods. If it's null, this PodAffinityTerm matches with no Pods.
        """
        return pulumi.get(self, "label_selector")

    @_builtins.property
    @pulumi.getter(name="matchLabelKeys")
    def match_label_keys(self) -> Optional[Sequence[_builtins.str]]:
        """
        MatchLabelKeys is a set of pod label keys to select which pods will be taken into consideration. The keys are used to lookup values from the incoming pod labels, those key-value labels are merged with `labelSelector` as `key in (value)` to select the group of existing pods which pods will be taken into consideration for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming pod labels will be ignored. The default value is empty. The same key is forbidden to exist in both matchLabelKeys and labelSelector. Also, matchLabelKeys cannot be set when labelSelector isn't set.
        """
        return pulumi.get(self, "match_label_keys")

    @_builtins.property
    @pulumi.getter(name="mismatchLabelKeys")
    def mismatch_label_keys(self) -> Optional[Sequence[_builtins.str]]:
        """
        MismatchLabelKeys is a set of pod label keys to select which pods will be taken into consideration. The keys are used to lookup values from the incoming pod labels, those key-value labels are merged with `labelSelector` as `key notin (value)` to select the group of existing pods which pods will be taken into consideration for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming pod labels will be ignored. The default value is empty. The same key is forbidden to exist in both mismatchLabelKeys and labelSelector. Also, mismatchLabelKeys cannot be set when labelSelector isn't set.
        """
        return pulumi.get(self, "mismatch_label_keys")

    @_builtins.property
    @pulumi.getter(name="namespaceSelector")
    def namespace_selector(self) -> Optional['_meta.v1.outputs.LabelSelectorPatch']:
        """
        A label query over the set of namespaces that the term applies to. The term is applied to the union of the namespaces selected by this field and the ones listed in the namespaces field. null selector and null or empty namespaces list means "this pod's namespace". An empty selector ({}) matches all namespaces.
        """
        return pulumi.get(self, "namespace_selector")

    @_builtins.property
    @pulumi.getter
    def namespaces(self) -> Optional[Sequence[_builtins.str]]:
        """
        namespaces specifies a static list of namespace names that the term applies to. The term is applied to the union of the namespaces listed in this field and the ones selected by namespaceSelector. null or empty namespaces list and null namespaceSelector means "this pod's namespace".
        """
        return pulumi.get(self, "namespaces")

    @_builtins.property
    @pulumi.getter(name="topologyKey")
    def topology_key(self) -> Optional[_builtins.str]:
        """
        This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching the labelSelector in the specified namespaces, where co-located is defined as running on a node whose value of the label with key topologyKey matches that of any node on which any of the selected pods is running. Empty topologyKey is not allowed.
        """
        return pulumi.get(self, "topology_key")


@pulumi.output_type
class PodAntiAffinity(dict):
    """
    Pod anti affinity is a group of inter pod anti affinity scheduling rules.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "preferredDuringSchedulingIgnoredDuringExecution":
            suggest = "preferred_during_scheduling_ignored_during_execution"
        elif key == "requiredDuringSchedulingIgnoredDuringExecution":
            suggest = "required_during_scheduling_ignored_during_execution"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PodAntiAffinity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PodAntiAffinity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PodAntiAffinity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 preferred_during_scheduling_ignored_during_execution: Optional[Sequence['outputs.WeightedPodAffinityTerm']] = None,
                 required_during_scheduling_ignored_during_execution: Optional[Sequence['outputs.PodAffinityTerm']] = None):
        """
        Pod anti affinity is a group of inter pod anti affinity scheduling rules.
        :param Sequence['WeightedPodAffinityTermArgs'] preferred_during_scheduling_ignored_during_execution: The scheduler will prefer to schedule pods to nodes that satisfy the anti-affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling anti-affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding "weight" to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred.
        :param Sequence['PodAffinityTermArgs'] required_during_scheduling_ignored_during_execution: If the anti-affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the anti-affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied.
        """
        if preferred_during_scheduling_ignored_during_execution is not None:
            pulumi.set(__self__, "preferred_during_scheduling_ignored_during_execution", preferred_during_scheduling_ignored_during_execution)
        if required_during_scheduling_ignored_during_execution is not None:
            pulumi.set(__self__, "required_during_scheduling_ignored_during_execution", required_during_scheduling_ignored_during_execution)

    @_builtins.property
    @pulumi.getter(name="preferredDuringSchedulingIgnoredDuringExecution")
    def preferred_during_scheduling_ignored_during_execution(self) -> Optional[Sequence['outputs.WeightedPodAffinityTerm']]:
        """
        The scheduler will prefer to schedule pods to nodes that satisfy the anti-affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling anti-affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding "weight" to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred.
        """
        return pulumi.get(self, "preferred_during_scheduling_ignored_during_execution")

    @_builtins.property
    @pulumi.getter(name="requiredDuringSchedulingIgnoredDuringExecution")
    def required_during_scheduling_ignored_during_execution(self) -> Optional[Sequence['outputs.PodAffinityTerm']]:
        """
        If the anti-affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the anti-affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from 