/*
 * Decompiled with CFR 0.152.
 */
package jap;

import jap.Alignment;
import jap.CodonAlignment;
import jap.NucleotideAlignment;
import java.util.Arrays;
import java.util.TreeSet;

public class AminoAcidAlignment
extends Alignment {
    private final char[] character = new char[]{'A', 'R', 'N', 'D', 'C', 'Q', 'E', 'G', 'H', 'I', 'L', 'K', 'M', 'F', 'P', 'S', 'T', 'W', 'Y', 'V', 'X', '?', '-'};
    private final int A = 0;
    private final int R = 1;
    private final int N = 2;
    private final int D = 3;
    private final int C = 4;
    private final int Q = 5;
    private final int E = 6;
    private final int G = 7;
    private final int H = 8;
    private final int I = 9;
    private final int L = 10;
    private final int K = 11;
    private final int M = 12;
    private final int F = 13;
    private final int P = 14;
    private final int S = 15;
    private final int T = 16;
    private final int W = 17;
    private final int Y = 18;
    private final int V = 19;
    private static double[] freq;
    private static double total;
    private static TreeSet<Character> alphabet;
    private static int i;
    private static int j;
    private static int c;
    private static StringBuffer sb;
    private static String codon;
    private static AminoAcidAlignment aaAlig;
    private static CodonAlignment coAlig;
    private static CodonAlignment coAlig_;
    private static NucleotideAlignment dnaAlig;

    public AminoAcidAlignment() {
        alphabet = new TreeSet();
        c = -1;
        while (++c < this.character.length) {
            alphabet.add(new Character(this.character[c]));
        }
    }

    public static String filter(String string) {
        sb = new StringBuffer(string);
        j = -1;
        while (++j < sb.length()) {
            if (alphabet.contains(new Character(sb.charAt(j)))) continue;
            sb.setCharAt(j, new Character('X').charValue());
        }
        return sb.toString();
    }

    @Override
    public boolean setCharAt(int n, int n2, char c) {
        if (!alphabet.contains(new Character(c))) {
            return false;
        }
        return super.setCharAt(n, n2, c);
    }

    @Override
    public int getAlphabetSize() {
        return 20;
    }

    @Override
    public double[] getFrequencies(int n) {
        freq = new double[this.getAlphabetSize()];
        Arrays.fill(freq, 0.0);
        total = 0.0;
        i = -1;
        block25: while (++i < super.size()) {
            total += 1.0;
            switch (super.getSequence(i).charAt(n)) {
                case 'A': {
                    freq[0] = freq[0] + 1.0;
                    continue block25;
                }
                case 'R': {
                    freq[1] = freq[1] + 1.0;
                    continue block25;
                }
                case 'N': {
                    freq[2] = freq[2] + 1.0;
                    continue block25;
                }
                case 'D': {
                    freq[3] = freq[3] + 1.0;
                    continue block25;
                }
                case 'C': {
                    freq[4] = freq[4] + 1.0;
                    continue block25;
                }
                case 'Q': {
                    freq[5] = freq[5] + 1.0;
                    continue block25;
                }
                case 'E': {
                    freq[6] = freq[6] + 1.0;
                    continue block25;
                }
                case 'G': {
                    freq[7] = freq[7] + 1.0;
                    continue block25;
                }
                case 'H': {
                    freq[8] = freq[8] + 1.0;
                    continue block25;
                }
                case 'I': {
                    freq[9] = freq[9] + 1.0;
                    continue block25;
                }
                case 'L': {
                    freq[10] = freq[10] + 1.0;
                    continue block25;
                }
                case 'K': {
                    freq[11] = freq[11] + 1.0;
                    continue block25;
                }
                case 'M': {
                    freq[12] = freq[12] + 1.0;
                    continue block25;
                }
                case 'F': {
                    freq[13] = freq[13] + 1.0;
                    continue block25;
                }
                case 'P': {
                    freq[14] = freq[14] + 1.0;
                    continue block25;
                }
                case 'S': {
                    freq[15] = freq[15] + 1.0;
                    continue block25;
                }
                case 'T': {
                    freq[16] = freq[16] + 1.0;
                    continue block25;
                }
                case 'W': {
                    freq[17] = freq[17] + 1.0;
                    continue block25;
                }
                case 'Y': {
                    freq[18] = freq[18] + 1.0;
                    continue block25;
                }
                case 'V': {
                    freq[19] = freq[19] + 1.0;
                    continue block25;
                }
                case 'B': {
                    freq[3] = freq[3] + 0.5;
                    freq[2] = freq[2] + 0.5;
                    continue block25;
                }
                case 'Z': {
                    freq[5] = freq[5] + 0.5;
                    freq[6] = freq[6] + 0.5;
                    continue block25;
                }
                case 'X': {
                    c = -1;
                    while (++c < this.getAlphabetSize()) {
                        int n2 = c;
                        freq[n2] = freq[n2] + 0.05;
                    }
                    continue block25;
                }
            }
            total -= 1.0;
        }
        c = -1;
        while (++c < this.getAlphabetSize()) {
            int n3 = c;
            freq[n3] = freq[n3] / total;
        }
        return freq;
    }

    @Override
    public AminoAcidAlignment toAminoAcidAlignment() {
        aaAlig = new AminoAcidAlignment();
        i = -1;
        while (++i < super.size()) {
            aaAlig.add(super.getSequence(i), super.getLabel(i));
        }
        return aaAlig;
    }

    @Override
    public NucleotideAlignment toNucleotideAlignment() {
        coAlig_ = this.toCodonAlignment();
        return coAlig_.toNucleotideAlignment(7);
    }

    @Override
    public CodonAlignment toCodonAlignment() {
        coAlig = new CodonAlignment();
        i = -1;
        while (++i < super.size()) {
            sb = new StringBuffer("");
            j = -1;
            while (++j < super.length()) {
                switch (super.charAt(i, j)) {
                    case 'A': {
                        codon = "GCX";
                        break;
                    }
                    case 'R': {
                        codon = "MGX";
                        break;
                    }
                    case 'N': {
                        codon = "AAY";
                        break;
                    }
                    case 'D': {
                        codon = "GAY";
                        break;
                    }
                    case 'C': {
                        codon = "TGY";
                        break;
                    }
                    case 'Q': {
                        codon = "CAR";
                        break;
                    }
                    case 'E': {
                        codon = "GAR";
                        break;
                    }
                    case 'G': {
                        codon = "GGX";
                        break;
                    }
                    case 'H': {
                        codon = "CAY";
                        break;
                    }
                    case 'I': {
                        codon = "ATH";
                        break;
                    }
                    case 'L': {
                        codon = "YTX";
                        break;
                    }
                    case 'K': {
                        codon = "AAR";
                        break;
                    }
                    case 'M': {
                        codon = "ATG";
                        break;
                    }
                    case 'F': {
                        codon = "TTY";
                        break;
                    }
                    case 'P': {
                        codon = "CCX";
                        break;
                    }
                    case 'S': {
                        codon = "WSX";
                        break;
                    }
                    case 'T': {
                        codon = "ACX";
                        break;
                    }
                    case 'W': {
                        codon = "TGG";
                        break;
                    }
                    case 'Y': {
                        codon = "TAY";
                        break;
                    }
                    case 'V': {
                        codon = "GTX";
                        break;
                    }
                    case 'X': {
                        codon = "XXX";
                        break;
                    }
                    case '-': {
                        codon = "---";
                        break;
                    }
                    default: {
                        codon = "???";
                    }
                }
                sb = sb.append(codon);
            }
            coAlig.add(sb.toString(), super.getLabel(i));
        }
        return coAlig;
    }

    @Override
    public NucleotideAlignment toRYcodingAlignment() {
        dnaAlig = new NucleotideAlignment();
        i = -1;
        while (++i < super.size()) {
            sb = new StringBuffer("");
            j = -1;
            while (++j < super.length()) {
                switch (super.charAt(i, j)) {
                    case 'A': {
                        codon = "RYX";
                        break;
                    }
                    case 'R': {
                        codon = "XRX";
                        break;
                    }
                    case 'N': {
                        codon = "RRY";
                        break;
                    }
                    case 'D': {
                        codon = "RRY";
                        break;
                    }
                    case 'C': {
                        codon = "YRY";
                        break;
                    }
                    case 'Q': {
                        codon = "YRR";
                        break;
                    }
                    case 'E': {
                        codon = "RRR";
                        break;
                    }
                    case 'G': {
                        codon = "RRX";
                        break;
                    }
                    case 'H': {
                        codon = "YRY";
                        break;
                    }
                    case 'I': {
                        codon = "RYX";
                        break;
                    }
                    case 'L': {
                        codon = "YYX";
                        break;
                    }
                    case 'K': {
                        codon = "RRR";
                        break;
                    }
                    case 'M': {
                        codon = "RYR";
                        break;
                    }
                    case 'F': {
                        codon = "YYY";
                        break;
                    }
                    case 'P': {
                        codon = "YYX";
                        break;
                    }
                    case 'S': {
                        codon = "XXX";
                        break;
                    }
                    case 'T': {
                        codon = "RYX";
                        break;
                    }
                    case 'W': {
                        codon = "YRR";
                        break;
                    }
                    case 'Y': {
                        codon = "YRY";
                        break;
                    }
                    case 'V': {
                        codon = "RYX";
                        break;
                    }
                    case 'X': {
                        codon = "XXX";
                        break;
                    }
                    case '-': {
                        codon = "---";
                        break;
                    }
                    default: {
                        codon = "???";
                    }
                }
                sb = sb.append(codon);
            }
            dnaAlig.add(sb.toString(), super.getLabel(i));
        }
        return dnaAlig;
    }
}

