"""
Vector store connector helpers.

Provides connect_vector_store() to construct the vector backend explicitly.
"""
from __future__ import annotations

from typing import Any, Literal


def connect_vector_store(
    backend: Literal["local", "pgvector"],
    *,
    database_url: str | None = None,
) -> Any:
    from evenage.core.vector import LocalVectorStore, PostgresVectorStore

    if backend == "local":
        return LocalVectorStore()
    if backend == "pgvector":
        if not database_url:
            raise ValueError("database_url is required for pgvector backend")
        return PostgresVectorStore(database_url)
    raise ValueError(f"Unsupported vector backend: {backend}")
