import asyncio
from evenage.core.runtime_entry import AgentRunner
from evenage.core import EvenAgeConfig, AgentConfig
from .agents.diagnostic.handler import DiagnosticAgent


def test_runner_run_and_replay():
    cfg = EvenAgeConfig(queue_backend="memory", db_backend="sqlite", database_url="sqlite:///:memory:")
    # Create a concrete agent instance to avoid relying on external package discovery
    agent = DiagnosticAgent(AgentConfig(name="diagnostic", role="Diagnostic", goal="Test"), cfg)
    runner = AgentRunner(agent=agent, env_config=cfg)

    async def run():
        res = await runner.run({"message": "hello"})
        assert res["status"] in ("success", "completed")
        job_id = res["job_id"]

        replay = runner.replay(job_id, reexecute=False)
        assert replay["job_id"] == job_id
        assert replay["status"] in ("success", "completed")

    asyncio.run(run())
