# 更新日志

所有版本更新遵循 [语义化版本控制](https://semver.org/lang/zh-CN/) 规范。

> **如何阅读本日志**
> 每个版本分为“新增”、“变更”、“修复”等部分。建议开发者在升级前先阅读对应版本的 Breaking Change 和修复内容。

> **贡献日志**
> 如需为新版本添加日志，请在对应版本号下补充内容，并注明日期和主要贡献者。

## [1.2.6]
> 这是一个兼容性控制版本
### 新增
- 新增 sdk.logger.get_logs([ModuleName]) 方法，用于获取底层日志内容
### 变更
- 优化部分注解类型以兼容更多Python版本
- 注解从 py3.10+ 的原生注解改为typings注解 | 已在 py3.8+ 版本中测试通过

---

## [1.2.5]
### 修复
- 现在CLI更新模块时会进行依赖检测并自动补全
### 变更
- 调整Adapter类引用关系（不影响其他模块）

---

## [1.2.4]
### 修复
- 恢复 raiserr 的加载以解决兼容性问题

---

## [1.2.3]
### 新增
- 安装本地模块时自动安装依赖

### 修复
- 修复使用UV管理器安装SDK后安装模块时提示 "pip" 不存在的错误

---

## [1.2.2]

### 修复
- 初始化项目时自动初始化环境配置的时候两个环境变量被错误覆盖的问题

---

## [1.2.0]
### 新增
- 添加 `main.py` 的初始化方法
- 添加CLI: `epsdk init` 初始化项目

### 修复
- 修复 `Windows` 平台下安装本地模块时无法指定目录的问题

---

## [1.1.16]
### 修复
- 修复本地模块安装时可能出现的错误

---

## [1.1.15]
> 此版本为回滚版本,版本基于1.1.14.dev1:re | 为了修复多项目带来的严重问题，建议升级前先备份数据
### 新增
- 拓展CLI:install命令，现在可以指定本地目录直接安装模块

### 修复
- 修复多项目下模块初始化时可能出现的错误(回滚为单模块项目)

---
## [1.1.14.dev1:re]
> 此版本为开发版本，不保证兼容性，仅用于测试和开发

> dev1 的改动为sdk初始化功能优化 | 修复上个版本留下的bug
### 新增
- 添加新的 ForAIDocs 项目文档

### 修复
- 修复自动快照初始化时`_last_snapshot_time`和`_snapshot_interval`可能为None的问题
- 添加快照时的安全关闭数据库和恢复

## [1.1.14.dev0]
> dev0 的改动为数据库重构优化

### 新增
- 环境配置（env）模块支持**事务**、**快照**和**批量操作**：
  - `transaction()` 上下文管理器，支持多操作安全性，异常自动回滚
  - `snapshot(name)` 创建数据库快照，`restore(name)` 恢复快照，`list_snapshots()`/`delete_snapshot(name)` 快照管理
  - `set_multi`、`get_multi`、`delete_multi` 批量操作接口
  - `set_snapshot_interval(seconds)` 设置自动快照间隔，默认每小时自动快照

- 启用 SQL-WAL 模式提升并发性能

---


<details>
<summary>历史版本（1.1.13 及更早）</summary>

## [1.1.12 - 1.1.13]
### 新增
-  默认模块源,现在直接执行 epsdk update 命令即可添加并更新官方模块源

### 变更
- 现在Adapter需要继承的类从sdk.SendDSL改为继承上层Send嵌套类,即重写为 class Send(super().Send)

### 修复
- 修复CLI-Origin选择协议时未正确显示所有协议的问题

---

## [1.1.11]

### 新增
- 新增 `run` CLI 命令，支持运行脚本并可选热重载模式
- 新增 `show_topology()` 工具函数，可视化显示模块依赖关系
- 适配器新增指数退避重试机制，失败后自动延迟重试

### 变更
- 重构适配器重启逻辑，使用渐进式延迟重试策略
- 将模块依赖关系存储到环境变量中
- 改进 CLI 输出格式和交互体验

### 修复
- 修复模块状态更新时未同步更新模块信息的问题

---

## [1.1.10]

### 新增
- 支持通过 `hasattr(sdk.adapter, '<platform>')` 检查平台适配器是否存在
- 对短平台名（≤10字符）自动注册所有大小写组合形式（如 `qq`, `qQ`, `Qq`, `QQ`）
- 对长平台名注入 `.lower()`, `.upper()`, `.capitalize()` 三种形式以提升兼容性

---

## [1.1.9]
### 新增
- `adapter.<AdapterRegName>.on` 修饰器现在不强制要求传入事件类型
- `adapter.<AdapterRegName>.add_handler(event_type, handler)` 方法，用于运行时动态注册事件处理器
- 支持调用 `add_handler(handler)` 单参数形式，默认监听所有事件（等价于 `"*"`）

### 变更
- 更新 `adapter` 实现，支持通过任意大小写形式访问适配器（如 `adapter.QQ`、`adapter.qq`）
- 新增 `AdapterManager.get()` 对大小写不敏感的支持，提升平台查找兼容性

---

## [1.1.8]
### 变更
- 移动环境变量加载至初始化函数内
- 添加 SDK 初始化日志输出
- 调整 SendDSLBase.To 方法，支持可选参数
- 更新 logger 中的致命错误处理方式

---

## [1.1.7]
### 变更
- 修改 adapter.startup() 方法，引入 `scheduled_adapters` 集合用于防止重复调度相同适配器实例
- 调整日志输出逻辑，减少“已被其他协程启动”类提示，仅保留关键启动信息

### 修复
- 解决在并发启动多个同实例适配器时产生的冗余任务与日志问题

---

## [1.1.6]
### 修复
- 优化了模块扫描逻辑，避免重复加载模块

## [1.1.5]
### 变更
- adapter.start 变更为单例factory，避免重复创建实例

## [1.1.4]
### 修复
- 我们不再希望模块通过 register_adapters() 实例方法来注册适配器（因为需要实例化 Main），改为在模块 __init__() 方法中通过定义类似 moduleInfo 的结构实现Adapter

## [1.1.3]

### 变更
- 重构 init() 函数结构，分阶段处理模块扫描、依赖解析、适配器注册、Main 实例化

## [1.1.2]
### 修复
- 修复adapter模块中重启模块的方法

## [1.1.1]
### 新增
- **新增 SDK 初始化时自动生成 `env.py` 配置文件的功能**，若文件不存在，则生成带注释和示例的模板文件

---

## [1.1.0]

### 新增
- 新增全局异常钩子机制，捕获非 SDK 抛出的异常并重定向至 `sdk.raiserr`
- 新增线程池任务异常处理逻辑，确保线程内错误被捕获
- 新增适配器自动重启机制，在异常时尝试 stop 后重新 start
- 新增适配器链式发送接口 `Send.To(...).Func()`，提供 DSL 风格的消息构建方式
- 支持开发者继承 `SendDSL` 类型并扩展 `.Func()` 方法

### 变更
- 优化异常处理流程，统一使用 `sdk.raiserr.CaughtExternalError` 处理外部异常
- 改进 `AdapterManager._run_adapter` 方法，支持失败重试与自动恢复

### 修复
- 修复了部分线程任务中未正确记录日志的问题

---

## [1.0.15]

### 新增
- 新增适配器模块支持，引入 adapter 模块，包含 BaseAdapter 基类与 adapter 实例。
- 支持模块通过实现 `register_adapters()` 方法注册平台适配器，并在初始化阶段自动加载。
- 提供 `sdk.adapter.register(platform_name, adapter_class)` 接口用于手动注册适配器。

### 变更
- 在 SDK 初始化流程中增加对模块 `register_adapters()` 方法的检查与执行逻辑。
- 优化 SDK 属性注册顺序，确保 adapter、BaseAdapter 正确挂载到 `sdk` 实例。
- 更新底层文档（REFERENCE），补充适配器机制说明。

### 修复
- 修复了部分异常场景下适配器注册失败时的日志输出问题。
- 优化错误捕获逻辑，避免因单个适配器注册失败导致模块初始化中断。

---

## [1.0.14]

### 新增
- 添加了工具模块 (util)，包含 `ExecAsync` 函数和 `@cache`, `@run_in_executor`, `@retry` 装饰器，用于简化开发过程并提高代码质量。
- `logger` 新增 `save_logs(path: str | list)` 方法，支持手动保存日志到指定路径
- `logger` 新增 `set_output_file(path: str | list)` 方法，支持配置日志输出路径
- `logger` 新增 `set_module_level(module: str, level: int)` 方法，支持按模块设置日志等级
- `logger` 新增 `catch` 装饰器，支持自动捕获和记录函数异常
- 新增`REFERENCE`文档，提供底层文档支持

### 变更
- 重构了环境管理和模块管理功能，将 `db` 模块拆分为 `EnvManager` 和 `ModuleManager`
- 优化了配置存储结构，引入系统级命名空间 `erispulse.system` 以隔离核心配置
- 修改了模块数据存储方式，使用前缀标识替代专用数据表
- 将各实例方法修改为在模块内部定义，方便被重写
- 重命名`errors` --> `raiserr`，并提供自定义错误
- 重命名`envManager` --> `db`，sdk实例无变化
- 删除除`aiohttp`外对于非标准库的依赖

### 修复
- 修复了日志保存功能中的文件编码问题，确保使用 UTF-8 编码
- 修复了日志输出文件功能中的多路径处理问题
- 修复安装模块时总提示需要更新源的问题

---

## [1.0.14.dev]
> 该版本起对于底层进行了较为较大的修改重构

### [1.0.14.dev3]

#### 新增
- 添加了工具模块 (util)，包含 `ExecAsync` 函数和 `@cache`, `@run_in_executor`, `@retry` 装饰器，用于简化开发过程并提高代码质量。

### [1.0.14.dev2]

#### 变更
- 重构了环境管理和模块管理功能，将 `db` 模块拆分为 `EnvManager` 和 `ModuleManager`
- 优化了配置存储结构，引入系统级命名空间 `erispulse.system` 以隔离核心配置
- 修改了模块数据存储方式，使用前缀标识替代专用数据表

---

### [1.0.14.dev1]

#### 新增
- `logger` 新增 `save_logs(path: str | list)` 方法，支持手动保存日志到指定路径
- `logger` 新增 `set_output_file(path: str | list)` 方法，支持配置日志输出路径
- `logger` 新增 `set_module_level(module: str, level: int)` 方法，支持按模块设置日志等级
- `logger` 新增 `catch` 装饰器，支持自动捕获和记录函数异常

#### 修复
- 修复了日志保存功能中的文件编码问题，确保使用 UTF-8 编码
- 修复了日志输出文件功能中的多路径处理问题

---

### [1.0.14.dev0]
#### 新增
- 新增`REFERENCE`文档，提供底层文档支持

#### 变更
- 将各实例方法修改为在模块内部定义，方便被重写
- 重命名`errors` --> `raiserr`，并提供自定义错误
- 重命名`envManager` --> `db`，sdk实例无变化
- 删除除`aiohttp`外对于非标准库的依赖
- 重构了日志系统，支持运行日志写入和模块级日志等级控制

#### 修复
- 修复安装模块时总提示需要更新源的问题

---

## [1.0.13] - 修复并发问题

### 修复
- 优化了多线程/异步任务调度逻辑，解决了模块在高并发环境下出现的竞态条件问题
- 修复了部分共享资源访问时未加锁导致的数据不一致问题

---

## [1.0.12] - 重大更新（Breaking Change）
> ⚠️ 此版本不兼容旧版本，请注意迁移事项

### 变更
- 重构模块 info 结构
- 修改 SDK 实例为伪指针，方便模块重写底层功能
- 移除了logger对 `rich` 的依赖
- 删除了强制传入模块 logger 的参数，请改用 `sdk.logger` 进行日志记录

---

## [1.0.11]

### 改进
- 优化了模块加载时对空可选依赖列表的处理，避免不必要的警告日志输出
- 改进了日志信息的清晰度，减少冗余提示，提升用户体验

---

## [1.0.10]

### 修复
- 修复了模块加载逻辑中可选依赖未正确加载的问题

### 改进
- 增强了日志输出，便于调试模块加载过程
- 改进了 `optional_dependencies` 的处理逻辑，支持部分依赖加载

---

## [1.0.9]

### 修复
- 修复了部分命令行参数的错误

---

## [1.0.8]

### 新增
- 现在包会被添加至系统环境，用户可以直接通过命令行 `ep` 或 `epsdk` 调用 CLI

---

## [1.0.7]

### 修复
- 修复了诸多小问题

---

## [1.0.6]

### 修复
- 修复了 SDK-CLI 中的颜色乱码问题

### 改进
- 将数据库调整为包内存储，以解决多进程问题

---

## [1.0.5]

### 改进
- 更新了 SDK 模块对于 pip 依赖安装的支持

---

## [1.0.4]

### 修复
- 修复了部分命令行不支持 logger 颜色代码的问题

### 改进
- 替换为 `rich` 库进行日志输出

</details>