// Copyright (c) 2025 Soumyadip Sarkar.
// All rights reserved.
//
// This source code is licensed under the Apache-style license found in the
// LICENSE file in the root directory of this source tree.

pub mod activation;
pub mod arithmetic;
pub mod binary;
pub mod comparison;
pub mod conv;
pub mod fusion;
pub mod linalg;
pub mod loss;
pub mod minmax;
pub mod normalization;
pub mod reduction;
pub mod selection;
pub mod shape_ops;
pub mod simd;

// Re-export common operations
pub use activation::*;
pub use arithmetic::*;
pub use comparison::*;
pub use conv::*;
pub use fusion::*;
pub use linalg::*;
pub use loss::*;
pub use minmax::*;
pub use normalization::*;
pub use reduction::*;
pub use selection::*;
pub use shape_ops::*;
pub use simd::*;
