# Introduction

Welcome to the Polaris documentation!



--- 

## What is Polaris?

!!! info "Our vision"

    Polaris aims to **foster the development of impactful AI models in drug discovery** by establishing a new 
    and adaptive standard for measuring progress of computational tools in drug discovery.

Polaris is a suite of tools to implement, host and run benchmarks in computational drug discovery. Existing benchmarks leave several key challenges - related to the characteristics of datasets in drug discovery - unaddressed. This can lead to a situation in which newly proposed models do not perform as well _as advertised_ in real drug discovery programs, ultimately risking misalignment between the scientists developing the models and downstream users. With Polaris, we aim to further close that gap. 

### Polaris Hub
A quick word on the [Polaris Hub](https://polarishub.io/). The hub hosts a variety of high-quality benchmarks and datasets. While the hub is built to easily integrate with the Polaris library, you can use them independently.

## Where to next?

---

**:fontawesome-solid-rocket:  Quickstart**

If you are entirely new to Polaris, this is the place to start! Learn about the essential concepts and partake in your first benchmark.

[:material-arrow-right: Let's get started](./quickstart.md)


---

**:fontawesome-solid-graduation-cap:  Tutorials**

Dive deeper into the Polaris code and learn about advanced concepts to create your own benchmarks and datasets. 

[:material-arrow-right: Let's get started](./tutorials/basics.ipynb)

---

**:fontawesome-solid-code:  API Reference**

This is where you will find the technical documentation of the code itself. Learn the intricate details of how the various methods and classes work.

[:material-arrow-right: Let's get started](./api/dataset.md)

---

**:fontawesome-solid-comments:  Community**

Whether you are a first-time contributor or open-source veteran, we welcome any contribution to Polaris. Learn more about our community initiatives.

[:material-arrow-right: Let's get started](https://portal.valencelabs.com/)

---

