import shutil
from setuptools import setup, find_packages

with open("README.md", "r", encoding="utf-8") as f:
    long_description = f.read()
if not shutil.which("tcpreplay"):
    print(
        "\n[WARNING] 'tcpreplay' is not installed! "
        "If using Linux then Install it with: sudo apt install tcpreplay\n"
        "If using Windows then Install it manually\n"
    )
setup(
    name="greedos",
    version="0.4.0",
    description="Advanced Cybersecurity Red Team Tool",
    author="MrEchoFi_MdAbuNaserNayeem_TanjibIsham",
    long_description=long_description,
    long_description_content_type="text/markdown", 
    packages=find_packages(),
    install_requires=[
        "requests",
        "rich",
        "scapy",
    ],
    entry_points={
        "console_scripts": [
            "greedos=greedos.GreeDoS_ii:main_menu"
        ]
    },
    python_requires=">=3.7",
)
