import json
from typing import *

import httpx

from ..api_config import APIConfig, HTTPException
from ..models import *


def _ObjectTypesResource_get_get(
    api_config_override: Optional[APIConfig] = None,
) -> Paginated_ObjectTypeSchema_:
    api_config = api_config_override if api_config_override else APIConfig()

    base_path = api_config.base_path
    path = f"/api/object_type"
    headers = {
        "Content-Type": "application/json",
        "Accept": "application/json",
        "Authorization": f"Bearer { api_config.get_access_token() }",
    }
    query_params: Dict[str, Any] = {}

    query_params = {
        key: value for (key, value) in query_params.items() if value is not None
    }

    try:
        with httpx.Client(base_url=base_path, verify=api_config.verify) as client:
            response = client.request(
                "get",
                httpx.URL(path),
                headers=headers,
                params=query_params,
            )
    except httpx.ConnectError:
        import os

        from blissclient.exceptions import BlissRESTCantConnect

        raise BlissRESTCantConnect(f"Cant connect to Bliss REST API at `{base_path}`")

    if response.status_code != 200:
        from blissclient import parse_http_error_response

        parse_http_error_response(response)
        raise HTTPException(
            response.status_code, f" failed with status code: {response.status_code}"
        )

    return (
        Paginated_ObjectTypeSchema_(**response.json())
        if response.json() is not None
        else Paginated_ObjectTypeSchema_()
    )


def _ObjectTypeResource_get__string_id__get(
    id: str, api_config_override: Optional[APIConfig] = None
) -> ObjectTypeSchema:
    api_config = api_config_override if api_config_override else APIConfig()

    base_path = api_config.base_path
    path = f"/api/object_type/{id}"
    headers = {
        "Content-Type": "application/json",
        "Accept": "application/json",
        "Authorization": f"Bearer { api_config.get_access_token() }",
    }
    query_params: Dict[str, Any] = {}

    query_params = {
        key: value for (key, value) in query_params.items() if value is not None
    }

    try:
        with httpx.Client(base_url=base_path, verify=api_config.verify) as client:
            response = client.request(
                "get",
                httpx.URL(path),
                headers=headers,
                params=query_params,
            )
    except httpx.ConnectError:
        import os

        from blissclient.exceptions import BlissRESTCantConnect

        raise BlissRESTCantConnect(f"Cant connect to Bliss REST API at `{base_path}`")

    if response.status_code != 200:
        from blissclient import parse_http_error_response

        parse_http_error_response(response)
        raise HTTPException(
            response.status_code, f" failed with status code: {response.status_code}"
        )

    return (
        ObjectTypeSchema(**response.json())
        if response.json() is not None
        else ObjectTypeSchema()
    )
