# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import pulumi
import pulumi.runtime

class VPNTunnel(pulumi.CustomResource):
    """
    Manages a VPN Tunnel to the GCE network. For more info, read the
    [documentation](https://cloud.google.com/compute/docs/vpn).
    
    ~> **Note:** All arguments including the `shared_secret` will be stored in the raw state as plain-text.
    [Read more about sensitive data in state](/docs/state/sensitive-data.html).
    """
    def __init__(__self__, __name__, __opts__=None, description=None, ike_version=None, local_traffic_selectors=None, name=None, peer_ip=None, project=None, region=None, remote_traffic_selectors=None, router=None, shared_secret=None, target_vpn_gateway=None):
        """Create a VPNTunnel resource with the given unique name, props, and options."""
        if not __name__:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(__name__, basestring):
            raise TypeError('Expected resource name to be a string')
        if __opts__ and not isinstance(__opts__, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        if description and not isinstance(description, basestring):
            raise TypeError('Expected property description to be a basestring')
        __self__.description = description
        """
        A description of the resource. Changing this forces
        a new resource to be created.
        """
        __props__['description'] = description

        if ike_version and not isinstance(ike_version, int):
            raise TypeError('Expected property ike_version to be a int')
        __self__.ike_version = ike_version
        """
        Either version 1 or 2. Default is 2. Changing this
        forces a new resource to be created.
        """
        __props__['ikeVersion'] = ike_version

        if local_traffic_selectors and not isinstance(local_traffic_selectors, list):
            raise TypeError('Expected property local_traffic_selectors to be a list')
        __self__.local_traffic_selectors = local_traffic_selectors
        """
        Specifies which CIDR ranges are
        announced to the VPN peer. Mandatory if the VPN gateway is attached to a
        custom subnetted network. Refer to Google documentation for more
        information.
        """
        __props__['localTrafficSelectors'] = local_traffic_selectors

        if name and not isinstance(name, basestring):
            raise TypeError('Expected property name to be a basestring')
        __self__.name = name
        """
        A unique name for the resource, required by GCE. Changing
        this forces a new resource to be created.
        """
        __props__['name'] = name

        if not peer_ip:
            raise TypeError('Missing required property peer_ip')
        elif not isinstance(peer_ip, basestring):
            raise TypeError('Expected property peer_ip to be a basestring')
        __self__.peer_ip = peer_ip
        """
        The VPN gateway sitting outside of GCE. Changing this
        forces a new resource to be created.
        """
        __props__['peerIp'] = peer_ip

        if project and not isinstance(project, basestring):
            raise TypeError('Expected property project to be a basestring')
        __self__.project = project
        """
        The ID of the project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        __props__['project'] = project

        if region and not isinstance(region, basestring):
            raise TypeError('Expected property region to be a basestring')
        __self__.region = region
        """
        The region this tunnel should sit in. If not specified,
        the project region will be used. Changing this forces a new resource to be
        created.
        """
        __props__['region'] = region

        if remote_traffic_selectors and not isinstance(remote_traffic_selectors, list):
            raise TypeError('Expected property remote_traffic_selectors to be a list')
        __self__.remote_traffic_selectors = remote_traffic_selectors
        """
        Specifies which CIDR ranges the VPN
        tunnel can route to the remote side. Mandatory if the VPN gateway is attached to a
        custom subnetted network. Refer to Google documentation for more
        information.
        """
        __props__['remoteTrafficSelectors'] = remote_traffic_selectors

        if router and not isinstance(router, basestring):
            raise TypeError('Expected property router to be a basestring')
        __self__.router = router
        """
        Name of a Cloud Router in the same region
        to be used for dynamic routing. Refer to Google documentation for more
        information.
        """
        __props__['router'] = router

        if not shared_secret:
            raise TypeError('Missing required property shared_secret')
        elif not isinstance(shared_secret, basestring):
            raise TypeError('Expected property shared_secret to be a basestring')
        __self__.shared_secret = shared_secret
        """
        A passphrase shared between the two VPN gateways.
        Changing this forces a new resource to be created.
        """
        __props__['sharedSecret'] = shared_secret

        if not target_vpn_gateway:
            raise TypeError('Missing required property target_vpn_gateway')
        elif not isinstance(target_vpn_gateway, basestring):
            raise TypeError('Expected property target_vpn_gateway to be a basestring')
        __self__.target_vpn_gateway = target_vpn_gateway
        """
        A link to the VPN gateway sitting inside
        GCE. Changing this forces a new resource to be created.
        """
        __props__['targetVpnGateway'] = target_vpn_gateway

        __self__.detailed_status = pulumi.runtime.UNKNOWN
        """
        Information about the status of the VPN tunnel.
        """
        __self__.self_link = pulumi.runtime.UNKNOWN
        """
        The URI of the created resource.
        """

        super(VPNTunnel, __self__).__init__(
            'gcp:compute/vPNTunnel:VPNTunnel',
            __name__,
            __props__,
            __opts__)

    def set_outputs(self, outs):
        if 'description' in outs:
            self.description = outs['description']
        if 'detailedStatus' in outs:
            self.detailed_status = outs['detailedStatus']
        if 'ikeVersion' in outs:
            self.ike_version = outs['ikeVersion']
        if 'localTrafficSelectors' in outs:
            self.local_traffic_selectors = outs['localTrafficSelectors']
        if 'name' in outs:
            self.name = outs['name']
        if 'peerIp' in outs:
            self.peer_ip = outs['peerIp']
        if 'project' in outs:
            self.project = outs['project']
        if 'region' in outs:
            self.region = outs['region']
        if 'remoteTrafficSelectors' in outs:
            self.remote_traffic_selectors = outs['remoteTrafficSelectors']
        if 'router' in outs:
            self.router = outs['router']
        if 'selfLink' in outs:
            self.self_link = outs['selfLink']
        if 'sharedSecret' in outs:
            self.shared_secret = outs['sharedSecret']
        if 'targetVpnGateway' in outs:
            self.target_vpn_gateway = outs['targetVpnGateway']
