# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import pulumi
import pulumi.runtime
from .. import utilities, tables

class GetManagedZoneResult(object):
    """
    A collection of values returned by getManagedZone.
    """
    def __init__(__self__, description=None, dns_name=None, name_servers=None, id=None):
        if description and not isinstance(description, str):
            raise TypeError('Expected argument description to be a str')
        __self__.description = description
        """
        A textual description field.
        """
        if dns_name and not isinstance(dns_name, str):
            raise TypeError('Expected argument dns_name to be a str')
        __self__.dns_name = dns_name
        """
        The fully qualified DNS name of this zone, e.g. `terraform.io.`.
        """
        if name_servers and not isinstance(name_servers, list):
            raise TypeError('Expected argument name_servers to be a list')
        __self__.name_servers = name_servers
        """
        The list of nameservers that will be authoritative for this
        domain. Use NS records to redirect from your DNS provider to these names,
        thus making Google Cloud DNS authoritative for this zone.
        """
        if id and not isinstance(id, str):
            raise TypeError('Expected argument id to be a str')
        __self__.id = id
        """
        id is the provider-assigned unique ID for this managed resource.
        """

async def get_managed_zone(name=None, project=None):
    """
    Provides access to a zone's attributes within Google Cloud DNS.
    For more information see
    [the official documentation](https://cloud.google.com/dns/zones/)
    and
    [API](https://cloud.google.com/dns/api/v1/managedZones).
    
    ```hcl
    data "google_dns_managed_zone" "env_dns_zone" {
      name        = "qa-zone"
    }
    
    resource "google_dns_record_set" "dns" {
      name = "my-address.${data.google_dns_managed_zone.env_dns_zone.dns_name}"
      type = "TXT"
      ttl  = 300
    
      managed_zone = "${data.google_dns_managed_zone.env_dns_zone.name}"
    
      rrdatas = ["test"]
    }
    ```
    """
    __args__ = dict()

    __args__['name'] = name
    __args__['project'] = project
    __ret__ = await pulumi.runtime.invoke('gcp:dns/getManagedZone:getManagedZone', __args__)

    return GetManagedZoneResult(
        description=__ret__.get('description'),
        dns_name=__ret__.get('dnsName'),
        name_servers=__ret__.get('nameServers'),
        id=__ret__.get('id'))
