# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import pulumi
import pulumi.runtime
from .. import utilities, tables

class CryptoKey(pulumi.CustomResource):
    """
    Allows creation of a Google Cloud Platform KMS CryptoKey. For more information see
    [the official documentation](https://cloud.google.com/kms/docs/object-hierarchy#cryptokey)
    and
    [API](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys).
    
    A CryptoKey is an interface to key material which can be used to encrypt and decrypt data. A CryptoKey belongs to a
    Google Cloud KMS KeyRing.
    
    ~> Note: CryptoKeys cannot be deleted from Google Cloud Platform. Destroying a
    Terraform-managed CryptoKey will remove it from state and delete all
    CryptoKeyVersions, rendering the key unusable, but **will not delete the
    resource on the server**. When Terraform destroys these keys, any data
    previously encrypted with these keys will be irrecoverable. For this reason, it
    is strongly recommended that you add lifecycle hooks to the resource to prevent
    accidental destruction.
    """
    def __init__(__self__, __name__, __opts__=None, key_ring=None, name=None, rotation_period=None):
        """Create a CryptoKey resource with the given unique name, props, and options."""
        if not __name__:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(__name__, str):
            raise TypeError('Expected resource name to be a string')
        if __opts__ and not isinstance(__opts__, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        if not key_ring:
            raise TypeError('Missing required property key_ring')
        __props__['key_ring'] = key_ring

        __props__['name'] = name

        __props__['rotation_period'] = rotation_period

        __props__['self_link'] = None

        super(CryptoKey, __self__).__init__(
            'gcp:kms/cryptoKey:CryptoKey',
            __name__,
            __props__,
            __opts__)


    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

