# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import pulumi
import pulumi.runtime
from .. import utilities, tables

class Folder(pulumi.CustomResource):
    """
    Allows management of a Google Cloud Platform folder. For more information see 
    [the official documentation](https://cloud.google.com/resource-manager/docs/creating-managing-folders)
    and 
    [API](https://cloud.google.com/resource-manager/reference/rest/v2/folders).
    
    A folder can contain projects, other folders, or a combination of both. You can use folders to group projects under an organization in a hierarchy. For example, your organization might contain multiple departments, each with its own set of Cloud Platform resources. Folders allows you to group these resources on a per-department basis. Folders are used to group resources that share common IAM policies.
    
    Folders created live inside an Organization. See the [Organization documentation](https://cloud.google.com/resource-manager/docs/quickstarts) for more details.
    
    The service account used to run Terraform when creating a `google_folder`
    resource must have `roles/resourcemanager.folderCreator`. See the
    [Access Control for Folders Using IAM](https://cloud.google.com/resource-manager/docs/access-control-folders)
    doc for more information.
    """
    def __init__(__self__, __name__, __opts__=None, display_name=None, parent=None):
        """Create a Folder resource with the given unique name, props, and options."""
        if not __name__:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(__name__, str):
            raise TypeError('Expected resource name to be a string')
        if __opts__ and not isinstance(__opts__, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        if not display_name:
            raise TypeError('Missing required property display_name')
        __props__['display_name'] = display_name

        if not parent:
            raise TypeError('Missing required property parent')
        __props__['parent'] = parent

        __props__['create_time'] = None
        __props__['lifecycle_state'] = None
        __props__['name'] = None

        super(Folder, __self__).__init__(
            'gcp:organizations/folder:Folder',
            __name__,
            __props__,
            __opts__)


    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

