# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import pulumi
import pulumi.runtime
from .. import utilities, tables

class IAMCustomRole(pulumi.CustomResource):
    """
    Allows management of a customized Cloud IAM organization role. For more information see
    [the official documentation](https://cloud.google.com/iam/docs/understanding-custom-roles)
    and
    [API](https://cloud.google.com/iam/reference/rest/v1/organizations.roles).
    
    ~> **Warning:** Note that custom roles in GCP have the concept of a soft-delete. There are two issues that may arise
     from this and how roles are propagated. 1) creating a role may involve undeleting and then updating a role with the
     same name, possibly causing confusing behavior between undelete and update. 2) A deleted role is permanently deleted
     after 7 days, but it can take up to 30 more days (i.e. between 7 and 37 days after deletion) before the role name is
     made available again. This means a deleted role that has been deleted for more than 7 days cannot be changed at all
     by Terraform, and new roles cannot share that name.
    """
    def __init__(__self__, __name__, __opts__=None, deleted=None, description=None, org_id=None, permissions=None, role_id=None, stage=None, title=None):
        """Create a IAMCustomRole resource with the given unique name, props, and options."""
        if not __name__:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(__name__, str):
            raise TypeError('Expected resource name to be a string')
        if __opts__ and not isinstance(__opts__, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        __props__['deleted'] = deleted

        __props__['description'] = description

        if not org_id:
            raise TypeError('Missing required property org_id')
        __props__['org_id'] = org_id

        if not permissions:
            raise TypeError('Missing required property permissions')
        __props__['permissions'] = permissions

        if not role_id:
            raise TypeError('Missing required property role_id')
        __props__['role_id'] = role_id

        __props__['stage'] = stage

        if not title:
            raise TypeError('Missing required property title')
        __props__['title'] = title

        super(IAMCustomRole, __self__).__init__(
            'gcp:organizations/iAMCustomRole:IAMCustomRole',
            __name__,
            __props__,
            __opts__)


    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

