# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import pulumi
import pulumi.runtime
from .. import utilities, tables

class IAMPolicy(pulumi.CustomResource):
    """
    Allows management of the entire IAM policy for an existing Google Cloud Platform Organization.
    
    ~> **Warning:** New organizations have several default policies which will,
       without extreme caution, be **overwritten** by use of this resource.
       The safest alternative is to use multiple `google_organization_iam_binding`
       resources.  It is easy to use this resource to remove your own access to
       an organization, which will require a call to Google Support to have
       fixed, and can take multiple days to resolve.  If you do use this resource,
       the best way to be sure that you are not making dangerous changes is to start
       by importing your existing policy, and examining the diff very closely.
    
    ~> **Note:** This resource __must not__ be used in conjunction with
       `google_organization_iam_member` or `google_organization_iam_binding`
       or they will fight over what your policy should be.
    """
    def __init__(__self__, __name__, __opts__=None, org_id=None, policy_data=None):
        """Create a IAMPolicy resource with the given unique name, props, and options."""
        if not __name__:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(__name__, str):
            raise TypeError('Expected resource name to be a string')
        if __opts__ and not isinstance(__opts__, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        if not org_id:
            raise TypeError('Missing required property org_id')
        __props__['org_id'] = org_id

        if not policy_data:
            raise TypeError('Missing required property policy_data')
        __props__['policy_data'] = policy_data

        __props__['etag'] = None

        super(IAMPolicy, __self__).__init__(
            'gcp:organizations/iAMPolicy:IAMPolicy',
            __name__,
            __props__,
            __opts__)


    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

