# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import pulumi
import pulumi.runtime
from .. import utilities, tables

class Project(pulumi.CustomResource):
    """
    Allows creation and management of a Google Cloud Platform project.
    
    Projects created with this resource must be associated with an Organization.
    See the [Organization documentation](https://cloud.google.com/resource-manager/docs/quickstarts) for more details.
    
    The service account used to run Terraform when creating a `google_project`
    resource must have `roles/resourcemanager.projectCreator`. See the
    [Access Control for Organizations Using IAM](https://cloud.google.com/resource-manager/docs/access-control-org)
    doc for more information.
    
    Note that prior to 0.8.5, `google_project` functioned like a data source,
    meaning any project referenced by it had to be created and managed outside
    Terraform. As of 0.8.5, `google_project` functions like any other Terraform
    resource, with Terraform creating and managing the project. To replicate the old
    behavior, either:
    
    * Use the project ID directly in whatever is referencing the project, using the
      [google_project_iam_policy](https://www.terraform.io/docs/providers/google/r/google_project_iam.html)
      to replace the old `policy_data` property.
    * Use the [import](https://www.terraform.io/docs/import/usage.html) functionality
      to import your pre-existing project into Terraform, where it can be referenced and
      used just like always, keeping in mind that Terraform will attempt to undo any changes
      made outside Terraform.
    
    ~> It's important to note that any project resources that were added to your Terraform config
    prior to 0.8.5 will continue to function as they always have, and will not be managed by
    Terraform. Only newly added projects are affected.
    """
    def __init__(__self__, __name__, __opts__=None, app_engine=None, auto_create_network=None, billing_account=None, folder_id=None, labels=None, name=None, org_id=None, project_id=None, skip_delete=None):
        """Create a Project resource with the given unique name, props, and options."""
        if not __name__:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(__name__, str):
            raise TypeError('Expected resource name to be a string')
        if __opts__ and not isinstance(__opts__, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        __props__['app_engine'] = app_engine

        __props__['auto_create_network'] = auto_create_network

        __props__['billing_account'] = billing_account

        __props__['folder_id'] = folder_id

        __props__['labels'] = labels

        __props__['name'] = name

        __props__['org_id'] = org_id

        if not project_id:
            raise TypeError('Missing required property project_id')
        __props__['project_id'] = project_id

        __props__['skip_delete'] = skip_delete

        __props__['number'] = None

        super(Project, __self__).__init__(
            'gcp:organizations/project:Project',
            __name__,
            __props__,
            __opts__)


    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

