"""This file contains complete version of MongoDB error codes."""

_codes_to_exc_name: dict[str, str] = {
    "0": "OK",
    "1": "InternalError",
    "2": "BadValue",
    "4": "NoSuchKey",
    "5": "GraphContainsCycle",
    "6": "HostUnreachable",
    "7": "HostNotFound",
    "8": "UnknownError",
    "9": "FailedToParse",
    "10": "CannotMutateObject",
    "11": "UserNotFound",
    "12": "UnsupportedFormat",
    "13": "Unauthorized",
    "14": "TypeMismatch",
    "15": "Overflow",
    "16": "InvalidLength",
    "17": "ProtocolError",
    "18": "AuthenticationFailed",
    "19": "CannotReuseObject",
    "20": "IllegalOperation",
    "21": "EmptyArrayOperation",
    "22": "InvalidBSON",
    "23": "AlreadyInitialized",
    "24": "LockTimeout",
    "25": "RemoteValidationError",
    "26": "NamespaceNotFound",
    "27": "IndexNotFound",
    "28": "PathNotViable",
    "29": "NonExistentPath",
    "30": "InvalidPath",
    "31": "RoleNotFound",
    "32": "RolesNotRelated",
    "33": "PrivilegeNotFound",
    "34": "CannotBackfillArray",
    "35": "UserModificationFailed",
    "36": "RemoteChangeDetected",
    "37": "FileRenameFailed",
    "38": "FileNotOpen",
    "39": "FileStreamFailed",
    "40": "ConflictingUpdateOperators",
    "41": "FileAlreadyOpen",
    "42": "LogWriteFailed",
    "43": "CursorNotFound",
    "45": "UserDataInconsistent",
    "46": "LockBusy",
    "47": "NoMatchingDocument",
    "48": "NamespaceExists",
    "49": "InvalidRoleModification",
    "50": "MaxTimeMSExpired",
    "51": "ManualInterventionRequired",
    "52": "DollarPrefixedFieldName",
    "53": "InvalidIdField",
    "54": "NotSingleValueField",
    "55": "InvalidDBRef",
    "56": "EmptyFieldName",
    "57": "DottedFieldName",
    "58": "RoleModificationFailed",
    "59": "CommandNotFound",
    "61": "ShardKeyNotFound",
    "62": "OplogOperationUnsupported",
    "64": "WriteConcernTimeout",
    "65": "MultipleErrorsOccurred",
    "66": "ImmutableField",
    "67": "CannotCreateIndex",
    "68": "IndexAlreadyExists",
    "69": "AuthSchemaIncompatible",
    "70": "ShardNotFound",
    "71": "ReplicaSetNotFound",
    "72": "InvalidOptions",
    "73": "InvalidNamespace",
    "74": "NodeNotFound",
    "75": "WriteConcernLegacyOK",
    "76": "NoReplicationEnabled",
    "77": "OperationIncomplete",
    "78": "CommandResultSchemaViolation",
    "79": "UnknownReplWriteConcern",
    "80": "RoleDataInconsistent",
    "81": "NoMatchParseContext",
    "82": "NoProgressMade",
    "83": "RemoteResultsUnavailable",
    "85": "IndexOptionsConflict",
    "86": "IndexKeySpecsConflict",
    "87": "CannotSplit",
    "89": "NetworkTimeout",
    "90": "CallbackCanceled",
    "91": "ShutdownInProgress",
    "92": "SecondaryAheadOfPrimary",
    "93": "InvalidReplicaSetConfig",
    "94": "NotYetInitialized",
    "95": "NotSecondary",
    "96": "OperationFailed",
    "97": "NoProjectionFound",
    "98": "DBPathInUse",
    "100": "UnsatisfiableWriteConcern",
    "101": "OutdatedClient",
    "102": "IncompatibleAuditMetadata",
    "103": "NewReplicaSetConfigurationIncompatible",
    "104": "NodeNotElectable",
    "105": "IncompatibleShardingMetadata",
    "106": "DistributedClockSkewed",
    "107": "LockFailed",
    "108": "InconsistentReplicaSetNames",
    "109": "ConfigurationInProgress",
    "110": "CannotInitializeNodeWithData",
    "111": "NotExactValueField",
    "112": "WriteConflict",
    "113": "InitialSyncFailure",
    "114": "InitialSyncOplogSourceMissing",
    "115": "CommandNotSupported",
    "116": "DocTooLargeForCapped",
    "117": "ConflictingOperationInProgress",
    "118": "NamespaceNotSharded",
    "119": "InvalidSyncSource",
    "120": "OplogStartMissing",
    "121": "DocumentValidationFailure",
    "123": "NotAReplicaSet",
    "124": "IncompatibleElectionProtocol",
    "125": "CommandFailed",
    "126": "RPCProtocolNegotiationFailed",
    "127": "UnrecoverableRollbackError",
    "128": "LockNotFound",
    "129": "LockStateChangeFailed",
    "130": "SymbolNotFound",
    "133": "FailedToSatisfyReadPreference",
    "134": "ReadConcernMajorityNotAvailableYet",
    "135": "StaleTerm",
    "136": "CappedPositionLost",
    "137": "IncompatibleShardingConfigVersion",
    "138": "RemoteOplogStale",
    "139": "JSInterpreterFailure",
    "140": "InvalidSSLConfiguration",
    "141": "SSLHandshakeFailed",
    "142": "JSUncatchableError",
    "143": "CursorInUse",
    "144": "IncompatibleCatalogManager",
    "145": "PooledConnectionsDropped",
    "146": "ExceededMemoryLimit",
    "147": "ZLibError",
    "148": "ReadConcernMajorityNotEnabled",
    "149": "NoConfigPrimary",
    "150": "StaleEpoch",
    "151": "OperationCannotBeBatched",
    "152": "OplogOutOfOrder",
    "153": "ChunkTooBig",
    "154": "InconsistentShardIdentity",
    "155": "CannotApplyOplogWhilePrimary",
    "157": "CanRepairToDowngrade",
    "158": "MustUpgrade",
    "159": "DurationOverflow",
    "160": "MaxStalenessOutOfRange",
    "161": "IncompatibleCollationVersion",
    "162": "CollectionIsEmpty",
    "163": "ZoneStillInUse",
    "164": "InitialSyncActive",
    "165": "ViewDepthLimitExceeded",
    "166": "CommandNotSupportedOnView",
    "167": "OptionNotSupportedOnView",
    "168": "InvalidPipelineOperator",
    "169": "CommandOnShardedViewNotSupportedOnMongod",
    "170": "TooManyMatchingDocuments",
    "171": "CannotIndexParallelArrays",
    "172": "TransportSessionClosed",
    "173": "TransportSessionNotFound",
    "174": "TransportSessionUnknown",
    "175": "QueryPlanKilled",
    "176": "FileOpenFailed",
    "177": "ZoneNotFound",
    "178": "RangeOverlapConflict",
    "179": "WindowsPdhError",
    "180": "BadPerfCounterPath",
    "181": "AmbiguousIndexKeyPattern",
    "182": "InvalidViewDefinition",
    "183": "ClientMetadataMissingField",
    "184": "ClientMetadataAppNameTooLarge",
    "185": "ClientMetadataDocumentTooLarge",
    "186": "ClientMetadataCannotBeMutated",
    "187": "LinearizableReadConcernError",
    "188": "IncompatibleServerVersion",
    "189": "PrimarySteppedDown",
    "190": "MasterSlaveConnectionFailure",
    "192": "FailPointEnabled",
    "194": "BalancerInterrupted",
    "195": "ViewPipelineMaxSizeExceeded",
    "197": "InvalidIndexSpecificationOption",
    "199": "ReplicaSetMonitorRemoved",
    "200": "ChunkRangeCleanupPending",
    "201": "CannotBuildIndexKeys",
    "202": "NetworkInterfaceExceededTimeLimit",
    "203": "ShardingStateNotInitialized",
    "204": "TimeProofMismatch",
    "205": "ClusterTimeFailsRateLimiter",
    "206": "NoSuchSession",
    "207": "InvalidUUID",
    "208": "TooManyLocks",
    "209": "StaleClusterTime",
    "210": "CannotVerifyAndSignLogicalTime",
    "211": "KeyNotFound",
    "212": "IncompatibleRollbackAlgorithm",
    "213": "DuplicateSession",
    "214": "AuthenticationRestrictionUnmet",
    "215": "DatabaseDropPending",
    "216": "ElectionInProgress",
    "217": "IncompleteTransactionHistory",
    "218": "UpdateOperationFailed",
    "219": "FTDCPathNotSet",
    "220": "FTDCPathAlreadySet",
    "221": "IndexModified",
    "222": "CloseChangeStream",
    "223": "IllegalOpMsgFlag",
    "224": "QueryFeatureNotAllowed",
    "225": "TransactionTooOld",
    "226": "AtomicityFailure",
    "227": "CannotImplicitlyCreateCollection",
    "228": "SessionTransferIncomplete",
    "229": "MustDowngrade",
    "230": "DNSHostNotFound",
    "231": "DNSProtocolError",
    "232": "MaxSubPipelineDepthExceeded",
    "233": "TooManyDocumentSequences",
    "234": "RetryChangeStream",
    "235": "InternalErrorNotSupported",
    "236": "ForTestingErrorExtraInfo",
    "237": "CursorKilled",
    "238": "NotImplemented",
    "239": "SnapshotTooOld",
    "240": "DNSRecordTypeMismatch",
    "241": "ConversionFailure",
    "242": "CannotCreateCollection",
    "243": "IncompatibleWithUpgradedServer",
    "244": "NOT_YET_AVAILABLE_TransactionAborted",
    "245": "BrokenPromise",
    "246": "SnapshotUnavailable",
    "247": "ProducerConsumerQueueBatchTooLarge",
    "248": "ProducerConsumerQueueEndClosed",
    "249": "StaleDbVersion",
    "250": "StaleChunkHistory",
    "251": "NoSuchTransaction",
    "252": "ReentrancyNotAllowed",
    "256": "TransactionCommitted",
    "257": "TransactionTooLarge",
    "258": "UnknownFeatureCompatibilityVersion",
    "259": "KeyedExecutorRetry",
    "260": "InvalidResumeToken",
    "261": "TooManyLogicalSessions",
    "262": "ExceededTimeLimit",
    "263": "OperationNotSupportedInTransaction",
    "264": "TooManyFilesOpen",
    "265": "OrphanedRangeCleanUpFailed",
    "266": "FailPointSetFailed",
    "267": "PreparedTransactionInProgress",
    "268": "CannotBackup",
    "269": "DataModifiedByRepair",
    "270": "RepairedReplicaSetNode",
    "271": "JSInterpreterFailureWithStack",
    "272": "MigrationConflict",
    "273": "ProducerConsumerQueueProducerQueueDepthExceeded",
    "274": "ProducerConsumerQueueConsumed",
    "275": "ExchangePassthrough",
    "276": "IndexBuildAborted",
    "277": "AlarmAlreadyFulfilled",
    "278": "UnsatisfiableCommitQuorum",
    "279": "ClientDisconnect",
    "280": "ChangeStreamFatalError",
    "281": "TransactionCoordinatorSteppingDown",
    "282": "TransactionCoordinatorReachedAbortDecision",
    "283": "WouldChangeOwningShard",
    "284": "ForTestingErrorExtraInfoWithExtraInfoInNamespace",
    "285": "IndexBuildAlreadyInProgress",
    "286": "ChangeStreamHistoryLost",
    "287": "TransactionCoordinatorDeadlineTaskCanceled",
    "288": "ChecksumMismatch",
    "289": "WaitForMajorityServiceEarlierOpTimeAvailable",
    "290": "TransactionExceededLifetimeLimitSeconds",
    "291": "NoQueryExecutionPlans",
    "292": "QueryExceededMemoryLimitNoDiskUseAllowed",
    "293": "InvalidSeedList",
    "294": "InvalidTopologyType",
    "295": "InvalidHeartBeatFrequency",
    "296": "TopologySetNameRequired",
    "297": "HierarchicalAcquisitionLevelViolation",
    "298": "InvalidServerType",
    "299": "OCSPCertificateStatusRevoked",
    "300": "RangeDeletionAbandonedBecauseCollectionWithUUIDDoesNotExist",
    "301": "DataCorruptionDetected",
    "302": "OCSPCertificateStatusUnknown",
    "303": "SplitHorizonChange",
    "306": "ReadThroughCacheLookupCanceled",
    "307": "RangeDeletionAbandonedBecauseTaskDocumentDoesNotExist",
    "308": "CurrentConfigNotCommittedYet",
    "309": "ExhaustCommandFinished",
    "310": "PeriodicJobIsStopped",
    "311": "TransactionCoordinatorCanceled",
    "312": "OperationIsKilledAndDelisted",
    "313": "ResumableRangeDeleterDisabled",
    "314": "ObjectIsBusy",
    "315": "TooStaleToSyncFromSource",
    "316": "QueryTrialRunCompleted",
    "317": "ConnectionPoolExpired",
    "318": "ForTestingOptionalErrorExtraInfo",
    "319": "MovePrimaryInProgress",
    "322": "APIVersionError",
    "323": "APIStrictError",
    "324": "APIDeprecationError",
    "326": "OplogQueryMinTsMissing",
    "330": "SkipCommandExecution",
    "331": "FailedToRunWithReplyBuilder",
    "332": "CannotDowngrade",
    "333": "ServiceExecutorInShutdown",
    "334": "MechanismUnavailable",
    "336": "TimeseriesBucketCleared",
    "337": "AuthenticationAbandoned",
    "338": "ReshardCollectionInProgress",
    "339": "NoSuchReshardCollection",
    "340": "ReshardCollectionCommitted",
    "341": "ReshardCollectionAborted",
    "342": "ReshardingCriticalSectionTimeout",
    "343": "ShardCannotRefreshDueToLocksHeld",
    "344": "AuditingNotEnabled",
    "345": "RuntimeAuditConfigurationNotEnabled",
    "346": "ChangeStreamInvalidated",
    "347": "APIMismatchError",
    "348": "ChangeStreamTopologyChange",
    "349": "KeyPatternShorterThanBound",
    "350": "ReshardCollectionTruncatedError",
    "351": "ChangeStreamStartAfterInvalidate",
    "352": "UnsupportedOpQueryCommand",
    "354": "LoadBalancerSupportMismatch",
    "355": "InterruptedDueToStorageChange",
    "356": "TxnRetryCounterTooOld",
    "357": "InvalidBSONType",
    "358": "InternalTransactionNotSupported",
    "359": "CannotConvertIndexToUnique",
    "360": "PlacementVersionRefreshCanceled",
    "361": "CollectionUUIDMismatch",
    "362": "FutureAlreadyRetrieved",
    "363": "RetryableTransactionInProgress",
    "365": "TemporarilyUnavailable",
    "366": "WouldChangeOwningShardDeletedNoDocument",
    "367": "FLECompactionPlaceholder",
    "369": "FLETransactionAbort",
    "370": "CannotDropShardKeyIndex",
    "371": "UserWritesBlocked",
    "372": "CloseConnectionForShutdownCommand",
    "373": "InternalTransactionsExhaustiveFindHasMore",
    "374": "TransactionAPIMustRetryTransaction",
    "375": "TransactionAPIMustRetryCommit",
    "376": "ChangeStreamNotEnabled",
    "377": "FLEMaxTagLimitExceeded",
    "378": "NonConformantBSON",
    "379": "DatabaseMetadataRefreshCanceled",
    "380": "RequestAlreadyFulfilled",
    "381": "ReshardingCoordinatorServiceConflictingOperationInProgress",
    "382": "RemoteCommandExecutionError",
    "383": "CollectionIsEmptyLocally",
    "384": "ConnectionError",
    "385": "ConflictingServerlessOperation",
    "386": "DuplicateKeyId",
    "387": "EncounteredFLEPayloadWhileApplyingHmac",
    "388": "TransactionTooLargeForCache",
    "389": "LibmongocryptError",
    "390": "InvalidSignature",
    "391": "ReauthenticationRequired",
    "392": "InvalidJWT",
    "393": "InvalidTenantId",
    "395": "TruncatedSerialization",
    "396": "IndexInformationTooLarge",
    "398": "StreamTerminated",
    "400": "CannotUpgrade",
    "401": "ResumeTenantChangeStream",
    "402": "ResourceExhausted",
    "403": "UnsupportedShardingEventNotification",
    "404": "LDAPRoleAcquisitionError",
    "405": "CannotCreateChunkDistribution",
    "406": "MigrationBlockingOperationCoordinatorCleaningUp",
    "407": "PooledConnectionAcquisitionExceededTimeLimit",
    "408": "CannotInsertTimeseriesBucketsWithMixedSchema",
    "409": "TimeseriesBucketCompressionFailed",
    "410": "TimeseriesBucketFrozen",
    "411": "QueryRejectedBySettings",
    "412": "UpdatesStillPending",
    "413": "TransactionParticipantFailedUnyield",
    "414": "AddOrRemoveShardInProgress",
    "415": "StreamProcessorDoesNotExist",
    "416": "StreamProcessorAlreadyExists",
    "417": "StreamProcessorWorkerShuttingDown",
    "418": "StreamProcessorWorkerOutOfMemory",
    "419": "StreamProcessorKafkaConnectionError",
    "420": "StreamProcessorInvalidOptions",
    "421": "StreamProcessorAtlasConnectionError",
    "422": "StreamProcessorAtlasUnauthorizedError",
    "423": "StreamProcessorSourceDocTooLarge",
    "424": "StreamProcessorTooManyOutputTargets",
    "425": "StreamProcessorCannotResumeFromSource",
    "426": "IndexIsEmpty",
    "427": "DbCheckSecondaryBatchTimeout",
    "428": "DbCheckAttemptOnClusteredCollectionIdIndex",
    "429": "DbCheckInconsistentHash",
    "430": "IndexKeyOrderViolation",
    "431": "ChunkMetadataInconsistency",
    "432": "OfflineValidationFailedToComplete",
    "433": "AdmissionQueueOverflow",
    "434": "NoDistinctScansForDistinctEligibleQuery",
    "435": "QueryStatsFailedToRecord",
    "436": "StreamProcessorHTTPSConnectionError",
    "440": "StreamProcessorExternalFunctionConnectionError",
    "442": "RetryMultiPlanning",
    "443": "StreamProcessorS3ConnectionError",
    "444": "StreamProcessorS3Error",
    "445": "DatabaseMetadataRefreshCanceledDueToFCVTransition",
    "446": "ClusterUMCErrorWithWriteConcernError",
    "447": "ObjectAlreadyExists",
    "448": "StreamProcessorInvalidNamespace",
    "449": "RateLimitExceeded",
    "450": "PooledConnectionAcquisitionRejected",
    "451": "StreamProcessorS3TokenExpired",
    "452": "ReleaseMemoryShardError",
    "453": "InterruptedDueToReshardingCriticalSection",
    "454": "ReplayClientConfigurationError",
    "455": "ReplayClientNotConnected",
    "456": "ReplayClientFailedToProcessBSON",
    "457": "ReplayClientInternalError",
    "458": "ReplayClientSessionSchedulerError",
    "459": "ReplayClientSessionSimulationError",
    "8000": "AtlasError",
    "9001": "SocketException",
    "10003": "CannotGrowDocumentInCappedNamespace",
    "10058": "LegacyNotPrimary",
    "10065": "ErrIndexesWrongType",
    "10107": "NotWritablePrimary",
    "10334": "BSONObjectTooLarge",
    "11000": "DuplicateKey",
    "11600": "InterruptedAtShutdown",
    "11601": "Interrupted",
    "11602": "InterruptedDueToReplStateChange",
    "12586": "BackgroundOperationInProgressForDatabase",
    "12587": "BackgroundOperationInProgressForNamespace",
    "13113": "MergeStageNoMatchingDocument",
    "13297": "DatabaseDifferCase",
    "13388": "StaleConfig",
    "13435": "NotPrimaryNoSecondaryOk",
    "13436": "NotPrimaryOrSecondary",
    "14031": "OutOfDiskSpace",
    "15947": "ErrStageGroupInvalidFields",
    "15948": "ErrStageGroupID",
    "15955": "ErrStageGroupMissingID",
    "15958": "ErrStageLimitZero",
    "15959": "ErrMatchBadExpression",
    "15969": "ErrProjectBadExpression",
    "15973": "ErrSortBadExpression",
    "15974": "ErrSortBadValue",
    "15975": "ErrSortBadOrder",
    "15976": "ErrSortMissingKey",
    "15981": "ErrStageUnwindWrongType",
    "15983": "ErrExpressionWrongLenOfFields",
    "15998": "ErrPathContainsEmptyElement",
    "16020": "ErrOperatorWrongLenOfArgs",
    "16406": "ErrGroupDuplicateFieldName",
    "16410": "ErrFieldPathInvalidName",
    "16872": "ErrGroupInvalidFieldPath",
    "17276": "ErrGroupUndefinedVariable",
    "28667": "ErrInvalidArg",
    "28724": "ErrSliceFirstArg",
    "28769": "NamespaceCannotBeSharded",
    "28812": "ErrStageUnwindNoPath",
    "28818": "ErrStageUnwindNoPrefix",
    "31002": "ErrStageUnsetInvalidType",
    "31082": "SearchNotEnabled",
    "31119": "ErrStageUnsetNoPath",
    "31120": "ErrStageUnsetArrElementInvalidType",
    "31249": "ErrUnsetPathCollision",
    "31250": "ErrUnsetPathOverwrite",
    "31253": "ErrProjectionInEx",
    "31254": "ErrProjectionExIn",
    "31324": "ErrAggregatePositionalProject",
    "31325": "ErrAggregateInvalidExpression",
    "31394": "ErrWrongPositionalOperatorLocation",
    "31395": "ErrExclusionPositionalProjection",
    "40156": "ErrStageCountNonString",
    "40157": "ErrStageCountNonEmptyString",
    "40158": "ErrStageCountBadPrefix",
    "40160": "ErrStageCountBadValue",
    "40181": "ErrAddFieldsExpressionWrongAmountOfArgs",
    "40234": "ErrStageGroupInvalidAccumulator",
    "40237": "ErrStageGroupUnaryOperator",
    "40238": "ErrStageGroupMultipleAccumulator",
    "40272": "ErrSetBadExpression",
    "40323": "ErrStageInvalid",
    "40352": "ErrEmptyFieldPath",
    "40353": "ErrInvalidFieldPath",
    "40413": "IDLDuplicateField",
    "40414": "IDLFailedToParse",
    "40415": "IDLUnknownField",
    "40602": "ErrCollStatsIsNotFirstStage",
    "46841": "ClientMarkedKilled",
    "50768": "NotARetryableWriteCommand",
    "50840": "ErrFreeMonitoringDisabled",
    "50915": "BackupCursorOpenConflictWithCheckpoint",
    "51003": "ErrUserAlreadyExists",
    "51024": "ErrValueNegative",
    "51075": "ErrRegexOptions",
    "51091": "ErrRegexMissingParen",
    "51108": "ErrBadRegexOption",
    "51246": "ErrBadPositionalProjection",
    "51247": "ErrElementMismatchPositionalProjection",
    "51270": "ErrEmptySubProject",
    "51272": "ErrEmptyProject",
    "56846": "ConfigServerUnreachable",
    "57986": "RetryableInternalTransactionNotSupported",
    "91331": "RetriableRemoteCommandFailure",
    "640570": "IllegalChangeToExpectedShardVersion",
    "640571": "IllegalChangeToExpectedDatabaseVersion",
    "1003141": "RemoveShardDrainingInProgress",
    "4662500": "IDLUnknownFieldPossibleMongocryptd",
    "4822819": "ErrDuplicateField",
    "4938500": "IndexNotFoundCachedPlan",
    "5107200": "ErrStageSkipBadValue",
    "5107201": "ErrStageLimitInvalidArg",
    "5447000": "ErrStageCollStatsInvalidArg",
    "7582300": "ErrStageIndexedStringVectorDuplicate",
    "9737301": "UnsupportedCbrNode",
    "9751901": "HistogramCEFailure",
    "9751902": "SamplingCEFailure",
    "9751903": "CEFailure",
    "10045600": "InterruptedDueToFCVChange",
    "10171600": "ReadThroughCacheTimeMonotonicityViolation",
}


def get_exception_name(code: int) -> str | None:
    """Returns exception name based on its code."""
    return _codes_to_exc_name.get(str(code))
