# Open Edison Documentation

Welcome to Open Edison documentation! This directory contains comprehensive guides for users, developers, and contributors to the single-user MCP proxy server.

## 📚 Documentation Structure

### 🎯 **Core Documentation** [`core/`](core/)

Essential guides for using Open Edison:

- **[Project Structure](core/project_structure.md)** - Architecture overview and system design
- **[Configuration Guide](core/configuration.md)** - JSON configuration and setup
- **[MCP Proxy Usage](core/proxy_usage.md)** - Managing and using MCP servers

### ⚡ **Quick Reference** [`quick-reference/`](quick-reference/)

Fast lookup guides:

- **[API Reference](quick-reference/api_reference.md)** - Complete REST API documentation
- **[Configuration Quick Start](quick-reference/config_quick_start.md)** - Essential config options

### 🏗️ **Architecture** [`architecture/`](architecture/)

Design decisions and technical deep-dives:

- **[Single-User Design](architecture/single_user_design.md)** - Why simplicity over multi-user complexity
- JSON vs Database config decisions: integrated into the configuration guide

### 💻 **Development** [`development/`](development/)

Guidelines for contributors and developers:

- **[Development Guide](development/development_guide.md)** - Comprehensive development documentation
- **[Contributing](development/contributing.md)** - How to contribute to Open Edison
- **[Testing Strategy](development/testing.md)** - Testing approach and guidelines

### 🚀 **Deployment** [`deployment/`](deployment/)

Production deployment guides:

- **[Docker Deployment](deployment/docker.md)** - Container-based deployment
- **[Local Installation](deployment/local.md)** - Local development setup
  
## 🚀 **Getting Started**

New to Open Edison? Start here:

1. **[Project Structure](core/project_structure.md)** - Understand the architecture
2. **[Configuration Quick Start](quick-reference/config_quick_start.md)** - Basic setup
3. **[MCP Proxy Usage](core/proxy_usage.md)** - Start using MCP servers

## 🔍 **Quick Finds**

| **I want to...** | **Go here** |
|------------------|-------------|
| 🚀 Set up Open Edison | [Configuration Quick Start](quick-reference/config_quick_start.md) |
| 🔧 Configure MCP servers | [Configuration Guide](core/configuration.md) |
| 🏗️ Understand the architecture | [Project Structure](core/project_structure.md) |
| ⚡ API reference | [API Reference](quick-reference/api_reference.md) |
| 🧪 Write tests | [Testing Strategy](development/testing.md) |
| 🐳 Deploy with Docker | [Docker Deployment](deployment/docker.md) |
| 💻 Contribute code | [Development Guide](development/development_guide.md) |

## 📝 **Documentation Standards**

All documentation follows these principles:

- ✅ **Simple** - Reflects single-user, self-hosted nature
- 🎯 **Practical** - Includes working examples
- 📚 **Complete** - Covers essential use cases
- 🔄 **Current** - Updated with system changes
- 💡 **Clear** - Easy to understand and follow

## 🤝 **Contributing**

When updating documentation:

1. Keep the single-user focus throughout
2. Update relevant sections when code changes
3. Test all code examples
4. Use consistent terminology
5. Follow the simplicity principle

---

**Need help?** Check the [main README](../README.md) or explore the specific guides above.

**Open Edison** - Simple, self-hosted MCP proxy for single users.
