#  Created byMartin.cz
#  Copyright (c) Martin Strohalm. All rights reserved.

import wx
from ... enums import *


WX_LINE_CAP = {
    LINE_CAP_BUTT: wx.CAP_BUTT,
    LINE_CAP_SQUARE: wx.CAP_PROJECTING,
    LINE_CAP_ROUND: wx.CAP_ROUND}

WX_LINE_JOIN = {
    LINE_JOIN_BEVEL: wx.JOIN_BEVEL,
    LINE_JOIN_MITER: wx.JOIN_MITER,
    LINE_JOIN_ROUND: wx.JOIN_ROUND}

WX_LINE_STYLE = {
    LINE_STYLE_CUSTOM: wx.PENSTYLE_USER_DASH,
    LINE_STYLE_SOLID: wx.PENSTYLE_SOLID,
    LINE_STYLE_DOTTED: DASH_VALUES_DOTTED,
    LINE_STYLE_DASHED: DASH_VALUES_DASHED,
    LINE_STYLE_DASHDOTTED: DASH_VALUES_DASHDOTTED}

WX_FILL_STYLE = {
    FILL_STYLE_TRANS: wx.BRUSHSTYLE_TRANSPARENT,
    FILL_STYLE_SOLID: wx.BRUSHSTYLE_SOLID}

WX_FILL_RULE = {
    FILL_RULE_EVENODD: wx.ODDEVEN_RULE,
    FILL_RULE_WINDING: wx.WINDING_RULE}

WX_FONT_FAMILY = {
    FONT_FAMILY_SERIF: wx.FONTFAMILY_ROMAN,
    FONT_FAMILY_SANS: wx.FONTFAMILY_SWISS,
    FONT_FAMILY_MONO: wx.FONTFAMILY_TELETYPE}

WX_FONT_STYLE = {
    FONT_STYLE_NORMAL: wx.FONTSTYLE_NORMAL,
    FONT_STYLE_ITALIC: wx.FONTSTYLE_ITALIC}

WX_FONT_WEIGHT = {
    FONT_WEIGHT_NORMAL: wx.FONTWEIGHT_NORMAL,
    FONT_WEIGHT_LIGHT: wx.FONTWEIGHT_LIGHT,
    FONT_WEIGHT_BOLD: wx.FONTWEIGHT_BOLD,
    FONT_WEIGHT_BLACK: wx.FONTWEIGHT_BOLD,
    FONT_WEIGHT_HEAVY: wx.FONTWEIGHT_BOLD,
    FONT_WEIGHT_SEMIBOLD: wx.FONTWEIGHT_BOLD,
    FONT_WEIGHT_MEDIUM: wx.FONTWEIGHT_NORMAL,
    FONT_WEIGHT_ULTRALIGHT: wx.FONTWEIGHT_LIGHT,
    FONT_WEIGHT_THIN: wx.FONTWEIGHT_LIGHT}

WX_CURSORS = {
    CURSOR_BLANK: wx.CURSOR_BLANK,
    CURSOR_ARROW: wx.CURSOR_ARROW,
    CURSOR_HAND: wx.CURSOR_HAND,
    CURSOR_SIZEWE: wx.CURSOR_SIZEWE,
    CURSOR_SIZENS: wx.CURSOR_SIZENS}

WX_KEYS = {
    wx.WXK_TAB: KEY_TAB,
    wx.WXK_RETURN: KEY_RETURN,
    
    wx.WXK_SHIFT: KEY_SHIFT,
    wx.WXK_CONTROL: KEY_CTRL,
    wx.WXK_ALT: KEY_ALT,
    
    wx.WXK_ESCAPE: KEY_ESC,
    wx.WXK_SPACE: KEY_SPACE,
    
    wx.WXK_PAGEUP: KEY_PAGEUP,
    wx.WXK_PAGEDOWN: KEY_PAGEDOWN,
    wx.WXK_END: KEY_END,
    wx.WXK_HOME: KEY_HOME,
    wx.WXK_LEFT: KEY_LEFT,
    wx.WXK_UP: KEY_UP,
    wx.WXK_RIGHT: KEY_RIGHT,
    wx.WXK_DOWN: KEY_DOWN,
    
    wx.WXK_DELETE: KEY_DELETE,
    
    wx.WXK_F1: KEY_F1,
    wx.WXK_F2: KEY_F2,
    wx.WXK_F3: KEY_F3,
    wx.WXK_F4: KEY_F4,
    wx.WXK_F5: KEY_F5,
    wx.WXK_F6: KEY_F6,
    wx.WXK_F7: KEY_F7,
    wx.WXK_F8: KEY_F8,
    wx.WXK_F9: KEY_F9,
    wx.WXK_F10: KEY_F10,
    wx.WXK_F11: KEY_F11,
    wx.WXK_F12: KEY_F12}

WX_RASTER_TYPES = {
    '.bmp': wx.BITMAP_TYPE_BMP,
    '.jpg': wx.BITMAP_TYPE_JPEG,
    '.jpeg': wx.BITMAP_TYPE_JPEG,
    '.png': wx.BITMAP_TYPE_PNG,
    '.pcx': wx.BITMAP_TYPE_PCX,
    '.pnm': wx.BITMAP_TYPE_PNM,
    '.tif': wx.BITMAP_TYPE_TIFF,
    '.tiff': wx.BITMAP_TYPE_TIFF,
    '.xpm': wx.BITMAP_TYPE_XPM,
    '.ico': wx.BITMAP_TYPE_ICO,
    '.cur': wx.BITMAP_TYPE_CUR}
