#  Created byMartin.cz
#  Copyright (c) Martin Strohalm. All rights reserved.

from . color import Color
from . palette import Palette
from . gradient import Gradient


# define colors
Transparent = Color('#FFF0', name='Transparent')
AliceBlue = Color('#F0F8FF', name='AliceBlue')
AntiqueWhite = Color('#FAEBD7', name='AntiqueWhite')
Aqua = Color('#00FFFF', name='Aqua')
Aquamarine = Color('#7FFFD4', name='Aquamarine')
Azure = Color('#F0FFFF', name='Azure')
Beige = Color('#F5F5DC', name='Beige')
Bisque = Color('#FFE4C4', name='Bisque')
Black = Color('#000000', name='Black')
BlanchedAlmond = Color('#FFEBCD', name='BlanchedAlmond')
Blue = Color('#0000FF', name='Blue')
BlueViolet = Color('#8A2BE2', name='BlueViolet')
Brown = Color('#A52A2A', name='Brown')
BurlyWood = Color('#DEB887', name='BurlyWood')
CadetBlue = Color('#5F9EA0', name='CadetBlue')
Chartreuse = Color('#7FFF00', name='Chartreuse')
Chocolate = Color('#D2691E', name='Chocolate')
Coral = Color('#FF7F50', name='Coral')
CornflowerBlue = Color('#6495ED', name='CornflowerBlue')
Cornsilk = Color('#FFF8DC', name='Cornsilk')
Crimson = Color('#DC143C', name='Crimson')
Cyan = Color('#00FFFF', name='Cyan')
DarkBlue = Color('#00008B', name='DarkBlue')
DarkCyan = Color('#008B8B', name='DarkCyan')
DarkGoldenRod = Color('#B8860B', name='DarkGoldenRod')
DarkGray = Color('#A9A9A9', name='DarkGray')
DarkGrey = Color('#A9A9A9', name='DarkGrey')
DarkGreen = Color('#006400', name='DarkGreen')
DarkKhaki = Color('#BDB76B', name='DarkKhaki')
DarkMagenta = Color('#8B008B', name='DarkMagenta')
DarkOliveGreen = Color('#556B2F', name='DarkOliveGreen')
DarkOrange = Color('#FF8C00', name='DarkOrange')
DarkOrchid = Color('#9932CC', name='DarkOrchid')
DarkRed = Color('#8B0000', name='DarkRed')
DarkSalmon = Color('#E9967A', name='DarkSalmon')
DarkSeaGreen = Color('#8FBC8F', name='DarkSeaGreen')
DarkSlateBlue = Color('#483D8B', name='DarkSlateBlue')
DarkSlateGray = Color('#2F4F4F', name='DarkSlateGray')
DarkSlateGrey = Color('#2F4F4F', name='DarkSlateGrey')
DarkTurquoise = Color('#00CED1', name='DarkTurquoise')
DarkViolet = Color('#9400D3', name='DarkViolet')
DeepPink = Color('#FF1493', name='DeepPink')
DeepSkyBlue = Color('#00BFFF', name='DeepSkyBlue')
DimGray = Color('#696969', name='DimGray')
DimGrey = Color('#696969', name='DimGrey')
DodgerBlue = Color('#1E90FF', name='DodgerBlue')
FireBrick = Color('#B22222', name='FireBrick')
FloralWhite = Color('#FFFAF0', name='FloralWhite')
ForestGreen = Color('#228B22', name='ForestGreen')
Fuchsia = Color('#FF00FF', name='Fuchsia')
Gainsboro = Color('#DCDCDC', name='Gainsboro')
GhostWhite = Color('#F8F8FF', name='GhostWhite')
Gold = Color('#FFD700', name='Gold')
GoldenRod = Color('#DAA520', name='GoldenRod')
Gray = Color('#808080', name='Gray')
Grey = Color('#808080', name='Grey')
Green = Color('#008000', name='Green')
GreenYellow = Color('#ADFF2F', name='GreenYellow')
HoneyDew = Color('#F0FFF0', name='HoneyDew')
HotPink = Color('#FF69B4', name='HotPink')
IndianRed = Color('#CD5C5C', name='IndianRed')
Indigo = Color('#4B0082', name='Indigo')
Ivory = Color('#FFFFF0', name='Ivory')
Khaki = Color('#F0E68C', name='Khaki')
Lavender = Color('#E6E6FA', name='Lavender')
LavenderBlush = Color('#FFF0F5', name='LavenderBlush')
LawnGreen = Color('#7CFC00', name='LawnGreen')
LemonChiffon = Color('#FFFACD', name='LemonChiffon')
LightBlue = Color('#ADD8E6', name='LightBlue')
LightCoral = Color('#F08080', name='LightCoral')
LightCyan = Color('#E0FFFF', name='LightCyan')
LightGoldenRodYellow = Color('#FAFAD2', name='LightGoldenRodYellow')
LightGray = Color('#D3D3D3', name='LightGray')
LightGrey = Color('#D3D3D3', name='LightGrey')
LightGreen = Color('#90EE90', name='LightGreen')
LightPink = Color('#FFB6C1', name='LightPink')
LightSalmon = Color('#FFA07A', name='LightSalmon')
LightSeaGreen = Color('#20B2AA', name='LightSeaGreen')
LightSkyBlue = Color('#87CEFA', name='LightSkyBlue')
LightSlateGray = Color('#778899', name='LightSlateGray')
LightSlateGrey = Color('#778899', name='LightSlateGrey')
LightSteelBlue = Color('#B0C4DE', name='LightSteelBlue')
LightYellow = Color('#FFFFE0', name='LightYellow')
Lime = Color('#00FF00', name='Lime')
LimeGreen = Color('#32CD32', name='LimeGreen')
Linen = Color('#FAF0E6', name='Linen')
Magenta = Color('#FF00FF', name='Magenta')
Maroon = Color('#800000', name='Maroon')
MediumAquaMarine = Color('#66CDAA', name='MediumAquaMarine')
MediumBlue = Color('#0000CD', name='MediumBlue')
MediumOrchid = Color('#BA55D3', name='MediumOrchid')
MediumPurple = Color('#9370DB', name='MediumPurple')
MediumSeaGreen = Color('#3CB371', name='MediumSeaGreen')
MediumSlateBlue = Color('#7B68EE', name='MediumSlateBlue')
MediumSpringGreen = Color('#00FA9A', name='MediumSpringGreen')
MediumTurquoise = Color('#48D1CC', name='MediumTurquoise')
MediumVioletRed = Color('#C71585', name='MediumVioletRed')
MidnightBlue = Color('#191970', name='MidnightBlue')
MintCream = Color('#F5FFFA', name='MintCream')
MistyRose = Color('#FFE4E1', name='MistyRose')
Moccasin = Color('#FFE4B5', name='Moccasin')
NavajoWhite = Color('#FFDEAD', name='NavajoWhite')
Navy = Color('#000080', name='Navy')
OldLace = Color('#FDF5E6', name='OldLace')
Olive = Color('#808000', name='Olive')
OliveDrab = Color('#6B8E23', name='OliveDrab')
Orange = Color('#FFA500', name='Orange')
OrangeRed = Color('#FF4500', name='OrangeRed')
Orchid = Color('#DA70D6', name='Orchid')
PaleGoldenRod = Color('#EEE8AA', name='PaleGoldenRod')
PaleGreen = Color('#98FB98', name='PaleGreen')
PaleTurquoise = Color('#AFEEEE', name='PaleTurquoise')
PaleVioletRed = Color('#DB7093', name='PaleVioletRed')
PapayaWhip = Color('#FFEFD5', name='PapayaWhip')
PeachPuff = Color('#FFDAB9', name='PeachPuff')
Peru = Color('#CD853F', name='Peru')
Pink = Color('#FFC0CB', name='Pink')
Plum = Color('#DDA0DD', name='Plum')
PowderBlue = Color('#B0E0E6', name='PowderBlue')
Purple = Color('#800080', name='Purple')
RebeccaPurple = Color('#663399', name='RebeccaPurple')
Red = Color('#FF0000', name='Red')
RosyBrown = Color('#BC8F8F', name='RosyBrown')
RoyalBlue = Color('#4169E1', name='RoyalBlue')
SaddleBrown = Color('#8B4513', name='SaddleBrown')
Salmon = Color('#FA8072', name='Salmon')
SandyBrown = Color('#F4A460', name='SandyBrown')
SeaGreen = Color('#2E8B57', name='SeaGreen')
SeaShell = Color('#FFF5EE', name='SeaShell')
Sienna = Color('#A0522D', name='Sienna')
Silver = Color('#C0C0C0', name='Silver')
SkyBlue = Color('#87CEEB', name='SkyBlue')
SlateBlue = Color('#6A5ACD', name='SlateBlue')
SlateGray = Color('#708090', name='SlateGray')
SlateGrey = Color('#708090', name='SlateGrey')
Snow = Color('#FFFAFA', name='Snow')
SpringGreen = Color('#00FF7F', name='SpringGreen')
SteelBlue = Color('#4682B4', name='SteelBlue')
Tan = Color('#D2B48C', name='Tan')
Teal = Color('#008080', name='Teal')
Thistle = Color('#D8BFD8', name='Thistle')
Tomato = Color('#FF6347', name='Tomato')
Turquoise = Color('#40E0D0', name='Turquoise')
Violet = Color('#EE82EE', name='Violet')
Wheat = Color('#F5DEB3', name='Wheat')
White = Color('#FFFFFF', name='White')
WhiteSmoke = Color('#F5F5F5', name='WhiteSmoke')
Yellow = Color('#FFFF00', name='Yellow')
YellowGreen = Color('#9ACD32', name='YellowGreen')

R = Color('#FF0000', name='R')  # red
G = Color('#008000', name='G')  # green
B = Color('#0000FF', name='B')  # blue

C = Color('#00FFFF', name='C')  # cyan
M = Color('#FF00FF', name='M')  # magenta
Y = Color('#FFFF00', name='Y')  # yellow

T = Color('#0000', name='T')  # transparent
K = Color('#000000', name='K')  # black
W = Color('#FFFFFF', name='W')  # white
A = Color('#808080', name='A')  # gray
O = Color('#FFA500', name='O')  # orange

# define palettes
Pero = Palette(('#1047b9', '#328c00', '#f19000', '#4cc7c5', '#8f8f15', '#edbb00', '#786dff', '#b34e00', '#80bfbd', '#c88812', '#c5ca3d', '#7bb6ff', '#45438a', '#188183', '#838183', '#457ec6', '#7f2200', '#4c4e4c'), name='Pero')
Accent = Palette(('#7fc97f', '#beaed4', '#fdc086', '#ffff99', '#386cb0', '#f0027f', '#bf5b17', '#666666'), name='Accent')
Dark = Palette(('#1b9e77', '#d95f02', '#7570b3', '#e7298a', '#66a61e', '#e6ab02', '#a6761d', '#666666'), name='Dark')
Paired = Palette(('#a6cee3', '#1f78b4', '#b2df8a', '#33a02c', '#fb9a99', '#e31a1c', '#fdbf6f', '#ff7f00', '#cab2d6', '#6a3d9a', '#ffff99', '#b15928'), name='Paired')
Pastel1 = Palette(('#fbb4ae', '#b3cde3', '#ccebc5', '#decbe4', '#fed9a6', '#ffffcc', '#e5d8bd', '#fddaec', '#f2f2f2'), name='Pastel1')
Pastel2 = Palette(('#b3e2cd', '#fdcdac', '#cbd5e8', '#f4cae4', '#e6f5c9', '#fff2ae', '#f1e2cc', '#cccccc'), name='Pastel2')
Set1 = Palette(('#e41a1c', '#377eb8', '#4daf4a', '#984ea3', '#ff7f00', '#ffff33', '#a65628', '#f781bf', '#999999'), name='Set1')
Set2 = Palette(('#66c2a5', '#fc8d62', '#8da0cb', '#e78ac3', '#a6d854', '#ffd92f', '#e5c494', '#b3b3b3'), name='Set2')
Set3 = Palette(('#8dd3c7', '#ffffb3', '#bebada', '#fb8072', '#80b1d3', '#fdb462', '#b3de69', '#fccde5', '#d9d9d9', '#bc80bd', '#ccebc5', '#ffed6f'), name='Set3')
Spectral = Palette(("#3288bd", "#66c2a5", "#abdda4", "#e6f598", "#ffffbf", "#fee08b", "#fdae61", "#f46d43", "#d53e4f"), name='Spectral')

Blues = Palette(('#f7fbff', '#deebf7', '#c6dbef', '#9ecae1', '#6baed6', '#4292c6', '#2171b5', '#08519c', '#08306b'), name='Blues')
Greens = Palette(('#f7fcf5', '#e5f5e0', '#c7e9c0', '#a1d99b', '#74c476', '#41ab5d', '#238b45', '#006d2c', '#00441b'), name='Greens')
Greys = Palette(('#ffffff', '#f0f0f0', '#d9d9d9', '#bdbdbd', '#969696', '#737373', '#525252', '#252525', '#000000'), name='Greys')
Oranges = Palette(('#fff5eb', '#fee6ce', '#fdd0a2', '#fdae6b', '#fd8d3c', '#f16913', '#d94801', '#a63603', '#7f2704'), name='Oranges')
Purples = Palette(('#fcfbfd', '#efedf5', '#dadaeb', '#bcbddc', '#9e9ac8', '#807dba', '#6a51a3', '#54278f', '#3f007d'), name='Purples')
Reds = Palette(('#fff5f0', '#fee0d2', '#fcbba1', '#fc9272', '#fb6a4a', '#ef3b2c', '#cb181d', '#a50f15', '#67000d'), name='Reds')

Inferno = Palette(('#fcfea4', '#f8c931', '#f98c09', '#e35832', '#ba3655', '#88216a', '#550f6d', '#1f0c47', '#000003'), name='Inferno')
Magma = Palette(('#fbfcbf', '#fec286', '#fb8660', '#e55063', '#b53679', '#812581', '#4f117b', '#1b1044', '#000003'), name='Magma')
Plasma = Palette(('#eff821', '#fdc328', '#f79341', '#e56b5c', '#ca4678', '#a82296', '#7c02a7', '#4a02a0', '#0c0786'), name='Plasma')
Viridis = Palette(('#fde724', '#aadb32', '#5bc862', '#27ad80', '#208f8c', '#2c718e', '#3b518a', '#472b7a', '#440154'), name='Viridis')

BrBG = Palette(('#8c510a', '#bf812d', '#dfc27d', '#f6e8c3', '#f5f5f5', '#c7eae5', '#80cdc1', '#35978f', '#01665e'), name='BrBG')
BuGn = Palette(('#f7fcfd', '#e5f5f9', '#ccece6', '#99d8c9', '#66c2a4', '#41ae76', '#238b45', '#006d2c', '#00441b'), name='BuGn')
BuPu = Palette(('#f7fcfd', '#e0ecf4', '#bfd3e6', '#9ebcda', '#8c96c6', '#8c6bb1', '#88419d', '#810f7c', '#4d004b'), name='BuPu')
GnBu = Palette(('#f7fcf0', '#e0f3db', '#ccebc5', '#a8ddb5', '#7bccc4', '#4eb3d3', '#2b8cbe', '#0868ac', '#084081'), name='GnBu')
OrRd = Palette(('#fff7ec', '#fee8c8', '#fdd49e', '#fdbb84', '#fc8d59', '#ef6548', '#d7301f', '#b30000', '#7f0000'), name='OrRd')
PiYG = Palette(('#c51b7d', '#de77ae', '#f1b6da', '#fde0ef', '#f7f7f7', '#e6f5d0', '#b8e186', '#7fbc41', '#4d9221'), name='PiYG')
PRGn = Palette(('#762a83', '#9970ab', '#c2a5cf', '#e7d4e8', '#f7f7f7', '#d9f0d3', '#a6dba0', '#5aae61', '#1b7837'), name='PRGn')
PuBu = Palette(('#fff7fb', '#ece7f2', '#d0d1e6', '#a6bddb', '#74a9cf', '#3690c0', '#0570b0', '#045a8d', '#023858'), name='PuBu')
PuBuGn = Palette(('#fff7fb', '#ece2f0', '#d0d1e6', '#a6bddb', '#67a9cf', '#3690c0', '#02818a', '#016c59', '#014636'), name='PuBuGn')
PuOr = Palette(('#542788', '#8073ac', '#b2abd2', '#d8daeb', '#f7f7f7', '#fee0b6', '#fdb863', '#e08214', '#b35806'), name='PuOr')
PuRd = Palette(('#f7f4f9', '#e7e1ef', '#d4b9da', '#c994c7', '#df65b0', '#e7298a', '#ce1256', '#980043', '#67001f'), name='PuRd')
RdBu = Palette(('#b2182b', '#d6604d', '#f4a582', '#fddbc7', '#f7f7f7', '#d1e5f0', '#92c5de', '#4393c3', '#2166ac'), name='RdBu')
RdGy = Palette(('#b2182b', '#d6604d', '#f4a582', '#fddbc7', '#ffffff', '#e0e0e0', '#bababa', '#878787', '#4d4d4d'), name='RdGy')
RdPu = Palette(('#fff7f3', '#fde0dd', '#fcc5c0', '#fa9fb5', '#f768a1', '#dd3497', '#ae017e', '#7a0177', '#49006a'), name='RdPu')
RdYlBu = Palette(('#d73027', '#f46d43', '#fdae61', '#fee090', '#ffffbf', '#e0f3f8', '#abd9e9', '#74add1', '#4575b4'), name='RdYlBu')
RdYlGn = Palette(('#d73027', '#f46d43', '#fdae61', '#fee08b', '#ffffbf', '#d9ef8b', '#a6d96a', '#66bd63', '#1a9850'), name='RdYlGn')
YlGn = Palette(('#ffffe5', '#f7fcb9', '#d9f0a3', '#addd8e', '#78c679', '#41ab5d', '#238443', '#006837', '#004529'), name='YlGn')
YlGnBu = Palette(('#ffffd9', '#edf8b1', '#c7e9b4', '#7fcdbb', '#41b6c4', '#1d91c0', '#225ea8', '#253494', '#081d58'), name='YlGnBu')
YlOrBr = Palette(('#ffffe5', '#fff7bc', '#fee391', '#fec44f', '#fe9929', '#ec7014', '#cc4c02', '#993404', '#662506'), name='YlOrBr')
YlOrRd = Palette(('#ffffcc', '#ffeda0', '#fed976', '#feb24c', '#fd8d3c', '#fc4e2a', '#e31a1c', '#bd0026', '#800026'), name='YlOrRd')

# define gradients
palettes = (Spectral,
    Blues, Greens, Greys, Oranges, Purples, Reds,
    Inferno, Magma, Plasma, Viridis,
    BrBG, BuGn, BuPu, GnBu, OrRd, PiYG, PRGn, PuBu, PuBuGn, PuOr, PuRd, RdBu, RdGy, RdPu, RdYlBu, RdYlGn, YlGn, YlGnBu, YlOrBr, YlOrRd)

for palette in palettes:
    Gradient(palette, name=palette.name)
